static char sccsid[]="@(#)%E% P.Hoad@ee.surrey.ac.uk %I% %M%";
/*
 * Copyright (C) 1992, 1993, 1994, Paul D. Hoad This file is part of the Xmgf
 * Software. For conditions of distribution and use, see the accompanying
 * README file.
 *
 * Vision Speech and Signal Processing Group . Dept. of Electronic Engineering.
 * University of Surrey. Guildford, Surrey. England. Phone: +44 483 300800
 * Ext 2753 Email: P.Hoad@ee.surrey.ac.uk
 */
#include "XmgfStruct.h"
#include "XmgfGlobal.h"
#include "XmgfDefines.h"
#include <X11/StringDefs.h>
#include <Xm/Scale.h>
#include "FrameMaker.h"
#include "Pixmaps.h"
#include "3Droutines.h"
#include "Parse.h"
#include "XmgfFont.h"

FILE           *FrameFilePtr;
int 		OutFrame;
float 		FmSc=100;

#define GROUPID 	1

#ifndef _NO_PROTO 
void MakeOutLineFRAME(XPoint *Pts,int num,int LineWidth);
int SetFrameColour(int Color);
#else 
void MakeOutLineFRAME();
int SetFrameColour();
#endif 



/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SaveFRAMECB(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	XmFileSelect("Saving MIF  File", SAVE_MIF_FILE, MIFFIL, "Out.mif", MIFDIR);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
OutputFRAME(fname, Col)
char *fname;
int Col;
{
	OutFrame=1;
	if ((FrameFilePtr = fopen(fname, "w")) == NULL)
		return ;
	else if (OutFrame == 1)
		InitFrame();
	REDRAW_SCREEN;
	if (OutFrame == 1)
		EndFrame();
	fclose(FrameFilePtr);
	OutFrame = 0;
	return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
PolygonFRAME(Pts, num, fill, TmpWind, Color, PtType, BaseType, LineStyle, LineWidth, FillStyle,ShadedVal)
XPoint *Pts;
int num;
int fill;
Window TmpWind;
int Color;
int PtType;
int BaseType;
int LineStyle;
int LineWidth;
int FillStyle;
int ShadedVal;
{
	int i;
	int FrameColour = -1;
	int HaloedFrameColour=-1;
	int P = DefaultPointSize;
	int FrameFill = 0;
	int si;
	char FontName[30];

	FrameColour = SetFrameColour(Color);
	HaloedFrameColour = SetFrameColour(HaloedColor);
	fill =  DetermineFillType(fill,num,PtType,FillStyle,BaseType);

	if (Color < 64) {
                FrameColour = 0;
                FrameFill = (int) (((double) Color / 64.0) * 7.0);
        }
	else {
		FrameFill = 0;
	}


	switch (fill) {
	    case DOT:{
		fprintf(FrameFilePtr, "\t<Polygon\n");
		fprintf(FrameFilePtr, "\t<GroupID\t%d>\n",GROUPID);
		fprintf(FrameFilePtr, "\t<Pen 0>\n");
		fprintf(FrameFilePtr, "\t<PenWidth %d>\n",LineWidth);
		fprintf(FrameFilePtr, "\t<Separation %d>\n",FrameColour);
                fprintf(FrameFilePtr, "\t\t<NumPoints 5>\n");
                fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",((float)Pts[0].x-1)/ FmSc ,((float)Pts[0].y-1)/FmSc);
                fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",((float)Pts[0].x+1)/ FmSc ,((float)Pts[0].y-1)/FmSc);
                fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",((float)Pts[0].x+1)/ FmSc ,((float)Pts[0].y+1)/FmSc);
                fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",((float)Pts[0].x-1)/ FmSc ,((float)Pts[0].y+1)/FmSc);
                fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",((float)Pts[0].x-1)/ FmSc ,((float)Pts[0].y-1)/FmSc);
                fprintf(FrameFilePtr, "\t> # end of Polygon\n");
                break;
		}
	    case PLUS:{
		fprintf(FrameFilePtr, "\t<PolyLine\n");
		fprintf(FrameFilePtr, "\t<GroupID\t%d>\n",GROUPID);
		fprintf(FrameFilePtr, "\t<Pen 0>\n");
		fprintf(FrameFilePtr, "\t<PenWidth %d>\n",LineWidth);
		fprintf(FrameFilePtr, "\t<Separation %d>\n",FrameColour);
                fprintf(FrameFilePtr, "\t\t<NumPoints 2>\n");
                fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",((float)Pts[0].x-P)/FmSc ,((float)Pts[0].y)/FmSc);
                fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",((float)Pts[0].x+P)/FmSc ,((float)Pts[0].y)/FmSc);
                fprintf(FrameFilePtr, "\t> # end of PolyLine\n");
		fprintf(FrameFilePtr, "\t<PolyLine\n");
                fprintf(FrameFilePtr, "\t\t<NumPoints 2>\n");
                fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",((float)Pts[0].x)/ FmSc ,((float)Pts[0].y-P)/FmSc);
                fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",((float)Pts[0].x)/ FmSc ,((float)Pts[0].y+P)/FmSc);
                fprintf(FrameFilePtr, "\t> # end of PolyLine\n");
                break;
		}
	    case CROSS:{
		fprintf(FrameFilePtr, "\t<PolyLine\n");
		fprintf(FrameFilePtr, "\t<GroupID\t%d>\n",GROUPID);
		fprintf(FrameFilePtr, "\t<Pen 0>\n");
		fprintf(FrameFilePtr, "\t<PenWidth %d>\n",LineWidth);
		fprintf(FrameFilePtr, "\t<Separation %d>\n",FrameColour);
                fprintf(FrameFilePtr, "\t\t<NumPoints 2>\n");
                fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",((float)Pts[0].x-P)/FmSc ,((float)Pts[0].y-P)/FmSc);
                fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",((float)Pts[0].x+P)/FmSc ,((float)Pts[0].y+P)/FmSc);
                fprintf(FrameFilePtr, "\t> # end of PolyLine\n");
		fprintf(FrameFilePtr, "\t<PolyLine\n");
                fprintf(FrameFilePtr, "\t\t<NumPoints 2>\n");
                fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",((float)Pts[0].x-P)/ FmSc ,((float)Pts[0].y+P)/FmSc);
                fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",((float)Pts[0].x+P)/ FmSc ,((float)Pts[0].y-P)/FmSc);
                fprintf(FrameFilePtr, "\t> # end of PolyLine\n");
                break;
		}
	    case BOX:{
		fprintf(FrameFilePtr, "\t<PolyLine\n");
		fprintf(FrameFilePtr, "\t<GroupID\t%d>\n",GROUPID);
		fprintf(FrameFilePtr, "\t<Pen 0>\n");
		fprintf(FrameFilePtr, "\t<PenWidth %d>\n",LineWidth);
		fprintf(FrameFilePtr, "\t<Separation %d>\n",FrameColour);
                fprintf(FrameFilePtr, "\t\t<NumPoints 5>\n");
                fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",((float)Pts[0].x-P)/ FmSc ,((float)Pts[0].y-P)/FmSc);
                fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",((float)Pts[0].x+P)/ FmSc ,((float)Pts[0].y-P)/FmSc);
                fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",((float)Pts[0].x+P)/ FmSc ,((float)Pts[0].y+P)/FmSc);
                fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",((float)Pts[0].x-P)/ FmSc ,((float)Pts[0].y+P)/FmSc);
                fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",((float)Pts[0].x-P)/ FmSc ,((float)Pts[0].y-P)/FmSc);
                fprintf(FrameFilePtr, "\t> # end of PolyLine\n");
                break;
		}
	    case TRI:{
		fprintf(FrameFilePtr, "\t<PolyLine\n");
		fprintf(FrameFilePtr, "\t<GroupID\t%d>\n",GROUPID);
		fprintf(FrameFilePtr, "\t<Pen 0>\n");
		fprintf(FrameFilePtr, "\t<PenWidth %d>\n",LineWidth);
		fprintf(FrameFilePtr, "\t<Separation %d>\n",FrameColour);
                fprintf(FrameFilePtr, "\t\t<NumPoints 3>\n");
                fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",((float)Pts[0].x-P)/ FmSc ,((float)Pts[0].y+P)/FmSc);
                fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",((float)Pts[0].x+P)/ FmSc ,((float)Pts[0].y+P)/FmSc);
                fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",((float)Pts[0].x)/ FmSc ,((float)Pts[0].y-P)/FmSc);
                fprintf(FrameFilePtr, "\t> # end of PolyLine\n");
                break;
		}
	    case FILLEDTRI:{
		fprintf(FrameFilePtr, "\t<Polygon\n");
		fprintf(FrameFilePtr, "\t<GroupID\t%d>\n",GROUPID);
		fprintf(FrameFilePtr, "\t<Pen 0>\n");
		fprintf(FrameFilePtr, "\t<PenWidth %d>\n",LineWidth);
		fprintf(FrameFilePtr, "\t<Fill %d>\n",7);
		fprintf(FrameFilePtr, "\t<Separation %d>\n",FrameColour);
                fprintf(FrameFilePtr, "\t\t<NumPoints 3>\n");
                fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",((float)Pts[0].x-P)/ FmSc ,((float)Pts[0].y+P)/FmSc);
                fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",((float)Pts[0].x+P)/ FmSc ,((float)Pts[0].y+P)/FmSc);
                fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",((float)Pts[0].x)/ FmSc ,((float)Pts[0].y-P)/FmSc);
                fprintf(FrameFilePtr, "\t> # end of Polygon\n");
                break;
		}
	    case FILLEDBOX:{
		fprintf(FrameFilePtr, "\t<Polygon\n");
		fprintf(FrameFilePtr, "\t<GroupID\t%d>\n",GROUPID);
		fprintf(FrameFilePtr, "\t<Pen 0>\n");
		fprintf(FrameFilePtr, "\t<Fill %d>\n",7);
		fprintf(FrameFilePtr, "\t<PenWidth %d>\n",LineWidth);
		fprintf(FrameFilePtr, "\t<Separation %d>\n",FrameColour);
                fprintf(FrameFilePtr, "\t\t<NumPoints 5>\n");
                fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",((float)Pts[0].x-P)/ FmSc ,((float)Pts[0].y-P)/FmSc);
                fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",((float)Pts[0].x+P)/ FmSc ,((float)Pts[0].y-P)/FmSc);
                fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",((float)Pts[0].x+P)/ FmSc ,((float)Pts[0].y+P)/FmSc);
                fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",((float)Pts[0].x-P)/ FmSc ,((float)Pts[0].y+P)/FmSc);
                fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",((float)Pts[0].x-P)/ FmSc ,((float)Pts[0].y-P)/FmSc);
                fprintf(FrameFilePtr, "\t> # end of Polygon\n");
                break;
		}
	    case PTCIRCLE:{
		fprintf(FrameFilePtr, "<Ellipse\n");
		fprintf(FrameFilePtr, "\t<GroupID\t%d>\n",GROUPID);
		fprintf(FrameFilePtr, "\t<Pen 0>\n");
		fprintf(FrameFilePtr, "\t<PenWidth %d>\n",LineWidth);
		fprintf(FrameFilePtr, "\t<Separation %d>\n",FrameColour);
                fprintf(FrameFilePtr, "\t\t<BRect  %f\" %f\" %f\" %f\">\n",
		((float)Pts[0].x-P)/FmSc ,((float)Pts[0].y-P)/FmSc,
		((float) P)/FmSc,((float) P)/FmSc);
		fprintf(FrameFilePtr, "> # end ellipse\n");
		break;
		}
	    case FILLEDCIRCLE:{
		fprintf(FrameFilePtr, "<Ellipse\n");
		fprintf(FrameFilePtr, "\t<GroupID\t%d>\n",GROUPID);
		fprintf(FrameFilePtr, "\t<Pen 0>\n");
		fprintf(FrameFilePtr, "\t<PenWidth %d>\n",LineWidth);
		fprintf(FrameFilePtr, "\t<Fill %d>\n",7);
		fprintf(FrameFilePtr, "\t<Separation %d>\n",FrameColour);
                fprintf(FrameFilePtr, "\t\t<BRect  %f\" %f\" %f\" %f\">\n",
		((float)Pts[0].x-P)/FmSc ,((float)Pts[0].y-P)/FmSc,
		((float) P)/FmSc,((float) P)/FmSc);
		fprintf(FrameFilePtr, "> # end ellipse\n");
		break;
		}
            case FILLEDSPHERE:{
		for(i=9;i>1;i--){
                si = P/9*i;
		fprintf(FrameFilePtr, "<Ellipse\n");
                fprintf(FrameFilePtr, "\t<GroupID\t%d>\n",GROUPID);
                fprintf(FrameFilePtr, "\t<Pen %d>\n",abs(i-9));
                fprintf(FrameFilePtr, "\t<PenWidth %d>\n",0);
                fprintf(FrameFilePtr, "\t<Fill %d>\n",abs(i-9));
                fprintf(FrameFilePtr, "\t<Separation %d>\n",FrameColour);
                fprintf(FrameFilePtr, "\t\t<BRect  %f\" %f\" %f\" %f\">\n",
                ((float)Pts[0].x-(si)+(si/2))/FmSc ,((float)Pts[0].y-(si)+(si/2))/FmSc, ((float) 2*si)/FmSc,((float) 2*si)/FmSc);
		/* Old size too small 5/1/94 */
/*                ((float)Pts[0].x-(si/2)+(si/4))/FmSc ,((float)Pts[0].y-(si/2)+(si/4))/FmSc, ((float) si)/FmSc,((float) si)/FmSc);*/
                fprintf(FrameFilePtr, "> # end ellipse\n");
		}
                break;
                }
	    case FILLEDOPAQUE:{/* Polygon and PolyLine */
		fprintf(FrameFilePtr, "<Polygon\n");
		fprintf(FrameFilePtr, "\t<GroupID\t%d>\n",GROUPID);
		fprintf(FrameFilePtr, "\t<Fill 7>\n");
		fprintf(FrameFilePtr, "\t<Pen 0>\n");
		fprintf(FrameFilePtr, "\t<PenWidth %d>\n",LineWidth);
		fprintf(FrameFilePtr, "\t<Separation %d>\n",FrameColour);
		fprintf(FrameFilePtr, "\t\t<NumPoints %d>\n",num);
		for (i = 0; i < num; i++) {
		fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",(float)Pts[i].x/FmSc,(float)Pts[i].y/FmSc);}
		fprintf(FrameFilePtr, "> # end of Polygon\n");
		break;
		}
	    case COLOUREDOPAQUE:{/* Polygon and PolyLine */
		fprintf(FrameFilePtr, "<Polygon\n");
		fprintf(FrameFilePtr, "\t<GroupID\t%d>\n",GROUPID);
		fprintf(FrameFilePtr, "\t<Fill 7>\n");
		fprintf(FrameFilePtr, "\t<Pen 0>\n");
		fprintf(FrameFilePtr, "\t<PenWidth %d>\n",LineWidth);
		fprintf(FrameFilePtr, "\t<Separation %d>\n",FrameColour);
		fprintf(FrameFilePtr, "\t\t<NumPoints %d>\n",num);
		for (i = 0; i < num; i++) {
		fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",(float)Pts[i].x/FmSc,(float)Pts[i].y/FmSc);}
		fprintf(FrameFilePtr, "> # end of Polygon\n");
		break;
	    }
	    case HALOEDLINES:{/* Polygon and PolyLine */
/*		FrameColour = 1;*/
		if (num>2) {fprintf(FrameFilePtr, "<Polygon\n"); }
		else {fprintf(FrameFilePtr, "<PolyLine\n"); }
		fprintf(FrameFilePtr, "\t<GroupID\t%d>\n",GROUPID);
		fprintf(FrameFilePtr, "\t<Fill 15>\n");
		fprintf(FrameFilePtr, "\t<Pen 7>\n");
		fprintf(FrameFilePtr, "\t<PenWidth %d>\n",LineWidth+HALSIZE);
		fprintf(FrameFilePtr, "\t<Separation %d>\n",HaloedFrameColour);
		fprintf(FrameFilePtr, "\t\t<NumPoints %d>\n",num);
		for (i = 0; i < num; i++) {
		fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",(float)Pts[i].x/FmSc,(float)Pts[i].y/FmSc);}
		fprintf(FrameFilePtr, "> # end of Polygon\n");
		FrameColour = 0;
		if (num>2) {fprintf(FrameFilePtr, "<Polygon\n"); }
		else {fprintf(FrameFilePtr, "<PolyLine\n"); }
                fprintf(FrameFilePtr, "\t<GroupID\t%d>\n",GROUPID);
                fprintf(FrameFilePtr, "\t<Fill 15>\n");
                fprintf(FrameFilePtr, "\t<Pen 0>\n");
                fprintf(FrameFilePtr, "\t<PenWidth %d>\n",LineWidth);
                fprintf(FrameFilePtr, "\t<Separation %d>\n",FrameColour);
                fprintf(FrameFilePtr, "\t\t<NumPoints %d>\n",num);
                for (i = 0; i < num; i++) {
                fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",(float)Pts[i].x/FmSc,(float)Pts[i].y/FmSc);}
                fprintf(FrameFilePtr, "> # end of Polygon\n");

		break;
	    }
	    case FILLEDHIDDENLINE:{
		if(DitherFill){
		FrameFill = (int) (((double) ShadedVal / 64.0) * 7.0);
		}
		fprintf(FrameFilePtr, "<Polygon\n");
		fprintf(FrameFilePtr, "\t<GroupID\t%d>\n",GROUPID);
		fprintf(FrameFilePtr, "\t<Fill 0>\n");
		fprintf(FrameFilePtr, "\t<Pen 3>\n");
		fprintf(FrameFilePtr, "\t<PenWidth %d>\n",LineWidth);
		fprintf(FrameFilePtr, "\t<Separation 0>\n");
		fprintf(FrameFilePtr, "\t\t<NumPoints %d>\n",num);
		for (i = 0; i < num; i++) {
		fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",(float)Pts[i].x/FmSc,(float)Pts[i].y/FmSc);}
		fprintf(FrameFilePtr, "> # end of Polygon\n");
		MakeOutLineFRAME(Pts,num,LineWidth);
		break;
		}
	    case WHITELINES:{
		FrameColour = 1;
		if (num>2) {fprintf(FrameFilePtr, "<Polygon\n"); }
		else {fprintf(FrameFilePtr, "<PolyLine\n"); }
		fprintf(FrameFilePtr, "\t<Fill 15>\n");
		fprintf(FrameFilePtr, "\t<GroupID\t%d>\n",GROUPID);
		
		fprintf(FrameFilePtr, "\t<Pen 0>\n");
		fprintf(FrameFilePtr, "\t<PenWidth %d>\n",LineWidth);
		fprintf(FrameFilePtr, "\t<Separation %d>\n",FrameColour);
		fprintf(FrameFilePtr, "\t\t<NumPoints %d>\n",num);
		for (i = 0; i < num; i++) {
		fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",(float)Pts[i].x/FmSc,(float)Pts[i].y/FmSc);}
		fprintf(FrameFilePtr, "> # end of Poly[Line/gon]\n");
		break;
                }
            case BLACKLINES:{
		FrameColour = 0;
		if (num>2) {fprintf(FrameFilePtr, "<Polygon\n");
		}
		else {fprintf(FrameFilePtr, "<PolyLine\n");
		}
		fprintf(FrameFilePtr, "\t<GroupID\t%d>\n",GROUPID);
		fprintf(FrameFilePtr, "\t<Fill 15>\n");
		fprintf(FrameFilePtr, "\t<Pen 0>\n");
		fprintf(FrameFilePtr, "\t<PenWidth %d>\n",LineWidth);
		fprintf(FrameFilePtr, "\t<Separation %d>\n",FrameColour);
		fprintf(FrameFilePtr, "\t\t<NumPoints %d>\n",num);
		for (i = 0; i < num; i++) {
		fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",(float)Pts[i].x/FmSc,(float)Pts[i].y/FmSc);}
		fprintf(FrameFilePtr, "> # end of Poly[Line/gon]\n");
		break;
                }
	    case COLOUREDLINES:
	    case FILLEDCOLOR:{	/* Polygon */
		if(DitherFill){
		FrameFill = (int) (((double) ShadedVal / 64.0) * 7.0);
		}
		fprintf(FrameFilePtr, "<Polygon\n");
		fprintf(FrameFilePtr, "\t<GroupID\t%d>\n",GROUPID);
		fprintf(FrameFilePtr, "\t<Fill %d>\n",FrameFill);
		fprintf(FrameFilePtr, "\t<Pen %d>\n",FrameFill);
		fprintf(FrameFilePtr, "\t<PenWidth %d>\n",LineWidth);
		fprintf(FrameFilePtr, "\t<Separation %d>\n",FrameColour);
		fprintf(FrameFilePtr, "\t\t<NumPoints %d>\n",num);
		for (i = 0; i < num; i++) {
		fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",(float)Pts[i].x/FmSc,(float)Pts[i].y/FmSc);}
		fprintf(FrameFilePtr, "> # end of Polygon\n");
		MakeOutLineFRAME(Pts,num,LineWidth);
		break;
		}
	    case POINTS_ONLY:{
		for(i=0;i<num;i++){
		fprintf(FrameFilePtr, "\t<Polygon\n");
		fprintf(FrameFilePtr, "\t<GroupID\t%d>\n",GROUPID);
		fprintf(FrameFilePtr, "\t<Pen 0>\n");
		fprintf(FrameFilePtr, "\t<PenWidth %d>\n",LineWidth);
		fprintf(FrameFilePtr, "\t<Separation %d>\n",FrameColour);
                fprintf(FrameFilePtr, "\t\t<NumPoints 5>\n");
                fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",((float)Pts[i].x-1)/ FmSc ,((float)Pts[i].y-1)/FmSc);
                fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",((float)Pts[i].x+1)/ FmSc ,((float)Pts[i].y-1)/FmSc);
                fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",((float)Pts[i].x+1)/ FmSc ,((float)Pts[i].y+1)/FmSc);
                fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",((float)Pts[i].x-1)/ FmSc ,((float)Pts[i].y+1)/FmSc);
                fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",((float)Pts[i].x-1)/ FmSc ,((float)Pts[i].y-1)/FmSc);
                fprintf(FrameFilePtr, "\t> # end of Polygon\n");
		}
                break;
		}
	    case TEXTLABEL:{  fprintf(FrameFilePtr, "<TextLine\n");
		  switch(FontFamily){
         	  case COURIER: strcpy(FontName,"Courier");break;
         	  case NEWCENSCH: strcpy(FontName,"NewCenturySchlbk");break;
                  case SYMBOL: strcpy(FontName,"Symbol");break;
                  case HELVETICA: strcpy(FontName,"Helvetica");break;
                  case TIMES: strcpy(FontName,"Times");break;
                  default: strcpy(FontName,"Helvetica");break;
		  }
                fprintf(FrameFilePtr, "\t<GroupID\t%d>\n",GROUPID);
                fprintf(FrameFilePtr, "\t\t<TLOrigin %f\" %f\">\n",((float)Pts[0].x-
P)/ FmSc ,((float)Pts[0].y-P)/FmSc);
                fprintf(FrameFilePtr, "\t<TLAlignment Left >\n");
                fprintf(FrameFilePtr, "\t<Angle 0>\n");
                fprintf(FrameFilePtr, "\t<Font\n");
                fprintf(FrameFilePtr, "\t<FTag `'>\n");
                fprintf(FrameFilePtr, "\t<FFamily `%s'>\n",FontName);
                fprintf(FrameFilePtr, "\t<FWeight `Regular'>\n");
                fprintf(FrameFilePtr, "\t<FSize  %d.0 pt>\n",FontSize);
                fprintf(FrameFilePtr, "\t<FUnderline No >\n\t<FOverline No >\n");
                fprintf(FrameFilePtr, "\t<FStrike No >\n\t<FSupScript No >\n");
                fprintf(FrameFilePtr, "\t<FSubScript No >\n\t<FChangeBar No >\n");
                fprintf(FrameFilePtr, "\t<FOutline No >\n\t<FShadow No >\n");
                fprintf(FrameFilePtr, "\t<FPairKern No >\n");
                fprintf(FrameFilePtr, "\t<FDoubleUnderline No >\n");
                fprintf(FrameFilePtr, "\t<FNumericUnderline No >\n");
                fprintf(FrameFilePtr, "\t<FDX  0.0 pt>\n");
                fprintf(FrameFilePtr, "\t<FDY  0.0 pt>\n");
                fprintf(FrameFilePtr, "\t<FDW  0.0 pt>\n");
                fprintf(FrameFilePtr, "\t<FDW  0.0 pt>\n");
                fprintf(FrameFilePtr, "\t<FSeparation %d>\n",FrameColour);
                fprintf(FrameFilePtr, "\t> # end of Font\n");
                fprintf(FrameFilePtr, "\t<String `%s'>\n",CurrentString);
                fprintf(FrameFilePtr, "> # end of TextLine\n");
		break;
        }
	    default:{		/* PolyLine */
		if (num>2) {fprintf(FrameFilePtr, "<Polygon\n");
		}
		else {fprintf(FrameFilePtr, "<PolyLine\n");
		}
		fprintf(FrameFilePtr, "\t<GroupID\t%d>\n",GROUPID);
		fprintf(FrameFilePtr, "\t<Fill 15>\n");
		fprintf(FrameFilePtr, "\t<Pen %d>\n",FrameFill);
		fprintf(FrameFilePtr, "\t<PenWidth %d>\n",LineWidth);
		fprintf(FrameFilePtr, "\t<Separation %d>\n",FrameColour);
		fprintf(FrameFilePtr, "\t\t<NumPoints %d>\n",num);
		for (i = 0; i < num; i++) {
		fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",(float)Pts[i].x/FmSc,(float)Pts[i].y/FmSc);}
		fprintf(FrameFilePtr, "> # end of Poly[Line/gon]\n");
		break;
		}
	}
	return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
InitFrame()
{
	fprintf(FrameFilePtr, "<MIFFile 3.00> # Generated by Xmgf \n");
	fprintf(FrameFilePtr, "<Units Umm>\n");
	return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
EndFrame()
{
	fprintf(FrameFilePtr, "<Group \n\t<ID\t%d>\n>\n",GROUPID);
	fprintf(FrameFilePtr, "\n");
	return ;
}

void
MakeOutLineFRAME(Pts,num,LineWidth)
XPoint *Pts;
int num;
int LineWidth;
{
    int FrameColour = -1;
    int FrameFill;
    int i;

    if(OutLine){
    FrameColour =SetFrameColour(OutLineColour);
    FrameFill = 0;
     fprintf(FrameFilePtr, "<Polygon\n");
     fprintf(FrameFilePtr, "\t<GroupID\t%d>\n",GROUPID);
     fprintf(FrameFilePtr, "\t<Fill %d>\n",15);
     fprintf(FrameFilePtr, "\t<Pen %d>\n",0);
     fprintf(FrameFilePtr, "\t<PenWidth %d>\n",LineWidth);
     fprintf(FrameFilePtr, "\t<Separation %d>\n",FrameColour);
     fprintf(FrameFilePtr, "\t\t<NumPoints %d>\n",num);
     for (i = 0; i < num; i++) {
     fprintf(FrameFilePtr, "\t\t<Point %f\" %f\">\n",(float)Pts[i].x/FmSc,(float)Pts[i].y/FmSc);}
     fprintf(FrameFilePtr, "> # end of Polygon\n");

    }
}

int SetFrameColour(Color)
int Color;
{
        int FrameColour = -1;

        switch (Color) {
            case 64:
                FrameColour = 0; /* Black */
                break;
            case 70:
                FrameColour = 1; /* White */
                break;
            case 65:
                FrameColour = 2; /* Red */
                break;
            case 69:
                FrameColour = 3; /* Green */
                break;
            case 66:
                FrameColour = 4; /* Blue */
                break;
            case 72:
                FrameColour = 5; /* Cyan */
                break;
            case 92:
                FrameColour = 6; /* Magenta */
                break;
            case 67:
                FrameColour = 7; /* Yellow */
                break;
            case -1:
                FrameColour = 0; /* Black */
                break;
            default:
                FrameColour = 0; /* Black */
                break;
            }
        return FrameColour;
}

