static char sccsid[]="@(#)%E% P.Hoad@ee.surrey.ac.uk %I% %M%";
/*
 * Copyright (C) 1992, 1993, 1994, Paul D. Hoad This file is part of the Xmgf
 * Software. For conditions of distribution and use, see the accompanying
 * README file.
 *
 * Vision Speech and Signal Processing Group . Dept. of Electronic Engineering.
 * University of Surrey. Guildford, Surrey. England. Phone: +44 483 300800
 * Ext 2753 Email: P.Hoad@ee.surrey.ac.uk
 */
#include <stdio.h>
#include <Xm/PushBG.h>
#include <Xm/PushB.h>
#include <Xm/ToggleBG.h>
#include <Xm/ToggleB.h>
#include <Xm/Label.h>
#include "Bitmaps.h"
#include "Disp3DGF.h"
#include "InitX.h"
#include "callbacks.h"



/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
Widget
CreateBitmapButt(CB, arg, w_toplevel, w_parent, pBits, width, height)
void *CB;
caddr_t arg;
Widget w_toplevel;
Widget w_parent;
char *pBits;
int width;
int height;
{
	Widget w_button;
	Pixel fg, bg;
	Arg args[10];

	theDepth = DefaultDepth(theDisplay, theScreen);
	theRootWindow = DefaultRootWindow(theDisplay);
	fg = BlackPixel(theDisplay, theScreen);
	bg = WhitePixel(theDisplay, theScreen);
	fg = appres.LineThickColor;
	bg = appres.LineButtColor;

	XtSetArg(args[0], XmNwidth, width);
	XtSetArg(args[1], XmNheight, height);
	XtSetArg(args[2], XmNfillOnArm, True);
	XtSetArg(args[3], XmNwidth, width);
	XtSetArg(args[4], XmNlabelType, XmPIXMAP);
	XtSetArg(args[5], XmNhighlightOnEnter, True);
	XtSetArg(args[6], XmNalignment, XmALIGNMENT_CENTER);
	XtSetArg(args[7], XmNlabelPixmap,
	XCreatePixmapFromBitmapData(theDisplay, (Drawable)theRootWindow,
	pBits, (unsigned int)width, (unsigned int)height, fg, bg, theDepth));
	
	w_button = XtCreateWidget("button", xmPushButtonGadgetClass, w_parent, args, 8); 
	XtAddCallback(w_button, XmNactivateCallback, (XtCallbackProc) CB, (caddr_t) arg);
	XtManageChild(w_button);
	return w_button;
}



/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
Widget
CreateBitmapToggButt(CB, arg, w_toplevel, w_parent, pBits, width, height)
void *CB;
caddr_t arg;
Widget w_toplevel;
Widget w_parent;
char *pBits;
int width;
int height;
{
	Widget w_button;
	Pixel fg, bg;
	Arg args[10];

	XtSetArg(args[0], XmNbottomAttachment, XmATTACH_POSITION);
	XtSetArg(args[1], XmNtopAttachment, XmATTACH_POSITION);
	XtSetArg(args[2], XmNrightAttachment, XmATTACH_POSITION);
	XtSetArg(args[3], XmNwidth, width);
	XtSetArg(args[4], XmNlabelType, XmPIXMAP);
	XtSetArg(args[5], XmNhighlightOnEnter, True);

	theDepth = DefaultDepth(theDisplay, theScreen);
	theRootWindow = DefaultRootWindow(theDisplay);
	fg = BlackPixel(theDisplay, theScreen);
	bg = WhitePixel(theDisplay, theScreen);
	fg = appres.LineThickColor;
	bg = appres.LineButtColor;
	XtSetArg(args[6], XmNlabelPixmap,
		XCreatePixmapFromBitmapData(theDisplay, (Drawable)theRootWindow,
			pBits, (unsigned int)width, (unsigned int)height, fg, bg, theDepth));
	XtSetArg(args[7], XmNalignment, XmALIGNMENT_CENTER);
	w_button = XtCreateWidget("button", xmPushButtonGadgetClass, w_parent, args, 8);
	XtAddCallback(w_button, XmNactivateCallback, (XtCallbackProc) CB, (caddr_t) arg);
	XtManageChild(w_button);
	return w_button;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
Widget
CreateBitmapLabel(w_toplevel, w_parent, pBits, width, height)
Widget w_toplevel;
Widget w_parent;
char *pBits;
int width;
int height;
{
	Widget w_button;
	Pixel fg, bg;
	Arg args[10];

	XtSetArg(args[0], XmNbottomAttachment, XmATTACH_POSITION);
	XtSetArg(args[1], XmNtopAttachment, XmATTACH_POSITION);
	XtSetArg(args[2], XmNrightAttachment, XmATTACH_POSITION);
	XtSetArg(args[3], XmNwidth, width);
	XtSetArg(args[4], XmNlabelType, XmPIXMAP);
	XtSetArg(args[5], XmNhighlightOnEnter, True);
	theRootWindow = DefaultRootWindow(theDisplay);
	theDepth = DefaultDepth(theDisplay, theScreen);
	fg = BlackPixel(theDisplay, theScreen);
	bg = WhitePixel(theDisplay, theScreen);
	fg = appres.AboutfgColor;
	bg = appres.AboutbgColor;
	XtSetArg(args[6], XmNlabelPixmap,
		XCreatePixmapFromBitmapData(theDisplay, (Drawable)theRootWindow,
			pBits, (unsigned int)width, (unsigned int)height, fg, bg, theDepth));
	XtSetArg(args[7], XmNalignment, XmALIGNMENT_CENTER);
	w_button = XtCreateWidget("button", xmLabelWidgetClass, w_parent, args, 8);
	XtManageChild(w_button);
	return w_button;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
Widget
CreateIconButt(CB, arg, w_toplevel, w_parent, pBits, width, height,Butttype)
void *CB;
caddr_t arg;
Widget w_toplevel;
Widget w_parent;
char *pBits;
int width;
int height;
int Butttype;
{
        Widget w_button;
        Pixel fg, bg;
	Pixel Sfg,Sbg;
        Arg args[10];

        XtSetArg(args[0], XmNwidth, width);
        XtSetArg(args[1], XmNlabelType, XmPIXMAP);
        XtSetArg(args[2], XmNhighlightOnEnter, False);
	XtSetArg(args[3], XmNindicatorOn, FALSE );
        theDepth = DefaultDepth(theDisplay, theScreen);
        theRootWindow = DefaultRootWindow(theDisplay);
        fg = appres.IconFGColour;
        bg = appres.IconBGColour;
        Sfg = appres.IconSFGColour;
        Sbg = appres.IconSBGColour;
        XtSetArg(args[4], XmNlabelPixmap,
              XCreatePixmapFromBitmapData(theDisplay, (Drawable)theRootWindow,
              pBits, (unsigned int)width, (unsigned int)height, fg, bg, theDepth));
	XtSetArg(args[5], XmNalignment, XmALIGNMENT_CENTER);

	switch(Butttype){
	case 1: {
	  XtSetArg(args[6], XmNselectPixmap, 
	      XCreatePixmapFromBitmapData(theDisplay, (Drawable)theRootWindow, 
	      pBits, (unsigned int)width, (unsigned int)height, Sfg,Sbg, theDepth));
	  w_button = XtCreateWidget("button", 
              xmToggleButtonWidgetClass, w_parent, args, 7);
              XtAddCallback(w_button, XmNvalueChangedCallback, 
	      (XtCallbackProc) CB, (caddr_t) arg);
	  }
	  break;
        default: {
	  w_button = XtCreateWidget("button", 
			xmPushButtonWidgetClass, w_parent, args, 6);
          XtAddCallback(w_button, XmNactivateCallback, 
			(XtCallbackProc) CB, (caddr_t) arg);
	  break;
	  }
	}
        XtManageChild(w_button);
        return w_button;
}

