static char sccsid[]="@(#)%E% P.Hoad@ee.surrey.ac.uk %I% %M%";
/*
 * Copyright (C) 1992, 1993, 1994, Paul D. Hoad This file is part of the Xmgf
 * Software. For conditions of distribution and use, see the accompanying
 * README file.
 *
 * Vision Speech and Signal Processing Group . Dept. of Electronic Engineering.
 * University of Surrey. Guildford, Surrey. England. Phone: +44 483 300800
 * Ext 2753 Email: P.Hoad@ee.surrey.ac.uk
 */

#include <stdio.h>
#include "AutoCommand.h"
#include "XmgfStruct.h"
#include "XmgfGlobal.h"
#include "XmgfDefines.h"
#include "BackDrop.h"
#include "Parse.h"
#include "3Droutines.h"
#include "Read3DSet.h"
#include "Disp3DGF.h"
#include "callbacks.h"
#include "ReadWriteParm.h"

char * line_pos=0;
static char line[1000];
Boolean hold = 0;

#ifndef _NO_PROTO 
char * FindOpt(void);
char * FindOption1 (FILE * command_file);
char * Skip(void);
#else 
char * FindOpt();
char * FindOption1 ();
char * Skip();
#endif 
char * buff="0";

Boolean start_up(client_data)
XtPointer client_data;
{
  /* read in Sets and Image from the command line */
static int delay;
static long delay_start;
static in_delay=0;
int lock = 0;
char filename[100];
/*char c;*/
int dummy;
char parmfile[30];
char BckGrdStr[100];

      if (hold)  return False;
      if (lock)  return False;
      if (in_delay)
        if (time(0)>=delay_start+delay) in_delay=0;
        else return False;
       lock = 1;
       while (0!=(line_pos=FindOpt())){
        line_pos++;
/*        fprintf(stderr,"------ XGF ------ in before switch %s\n",line_pos); */
        switch(*(line_pos++))
        {

            case 't': /*  */
		sscanf(Skip(), "%d", &dummy);
		Theta =Theta + dummy;
		if (Theta >= 360)
                Theta = Theta - 360;
		if (Theta < 0)
                Theta = Theta + 360;
		UpdateRotationParms();
        	Redraw();
		SetScale();
            break;
	    case 's':
		sscanf(Skip(), "%d", &dummy);
		Theta = dummy;
		if (Theta >= 360)
                Theta = Theta - 360;
                if (Theta < 0)
                Theta = Theta + 360;
                UpdateRotationParms();
                Redraw();
                SetScale();
            break;
	    case 'q':
                sscanf(Skip(), "%d", &dummy);
                Phi = dummy;
                if (Phi >= 360)
                Phi = Phi - 360;
                if (Phi < 0)
                Phi = Phi + 360;
                UpdateRotationParms();
                Redraw();
                SetScale();
            break;
	    case 'h':
                sscanf(Skip(), "%d", &dummy);
                Gamma = dummy;
                if (Gamma >= 360)
                Gamma = Gamma - 360;
                if (Gamma < 0)
                Gamma = Gamma + 360;
                UpdateRotationParms();
                Redraw();
                SetScale();
            break;
            case 'p': /*  */
		sscanf(Skip(), "%d", &dummy);
		Phi =Phi + dummy;
		if (Phi >= 360)
                Phi = Phi - 360;
		 if (Phi < 0)
                Phi = Phi + 360;
		UpdateRotationParms();
        	Redraw();
		SetScale();
	    break;
	    case 'g': /*  */
		sscanf(Skip(), "%d", &dummy);
                Gamma =Gamma + dummy;
                if (Gamma >= 360)
                Gamma = Gamma - 360;
                 if (Gamma < 0)
                Gamma = Gamma + 360;
                UpdateRotationParms();
                Redraw();
                SetScale();
	    break;
	    case 'e':
                        AutoRotateFlag = !AutoRotateFlag;
                        break;
	    case 'v': /* Redraw */
			Redraw();
			break;
	    case 'x': /* Redraw */
			UpDateVisible();
			break;
	    case 'y': /* Redraw */
			DrawAllSets();
			if (DoubleBuff == 1) Redraw(); 
			break;
	    case 'z': /* Empty Sets  */
			SpecialEmpty3DSets();
	    case 'w': /* Empty Sets and clear */
			Empty3DSets();
			break;
	    case 'B':   /*Sorting */
                 Sorting = 1;
	    case 'A':   /* Load Parmfile  */
                        sscanf(Skip(), "%s", parmfile);
                        LoadParmSpecify(parmfile);
                        break;
	    case 'C':   /* User Colour Selection */
                        SelectColours = 1;
                        break;
            case 'D':   /* PointType  */
                        sscanf(Skip(), "%d", &PointType);
                        break;
	    case 'E':   /* Expand Image */
                        ExpandImage = 1;
                        break;
            case 'F':   /* FillType  */
                       sscanf(Skip(), "%d", &FillPolys);
                        break;
            case 'H':   /* Circle DefaultResolution  */
                        sscanf(Skip(), "%d", &DefaultResolution);
                        break;
            case 'I':   /* Turn Origin on */
                       Origin = 1;
                        break;
            case 'J':   /* Get Default  line style */
                        sscanf(Skip(), "%d", &DefaultLineStyle);
                        if (DefaultLineStyle < 0 || DefaultLineStyle > 2)
                                DefaultLineStyle = SOLIDLS;
                        break;
	    case 'K':   /* Sphere tesserlation */
                        sscanf(Skip(), "%d", &DefaultTessLevel);
                        break;
            case 'L':   /* Labels */
                       SelectLabels = 1;
                        break;
            case 'M':   /* Centroid */
                        Centroid = 1;
                        break;
            case 'N':   /* Double Buffering */
                        DoubleBuff = 1;
                        break;
            case 'O':   /* Orthographic+Perspective  */
                        viewtype = 1;
                        break;
            case 'P':   /* PolyApprox  */
                        sscanf(Skip(), "%d", &polydiv);
                        break;
            case 'Q':   /* BackFace Culling */
                        BackFace = 1;
                        break;
            case 'R':   /* User Point Selection defunct */
                        SelectPoints = 1;
                        break;
	    case 'S':   /* Stereo  */
                        /* viewtype=2;break; */
                        break;
            case 'T':   /* DefaultLineWidth  */
                        sscanf(Skip(), "%d", &DefaultLineWidth);
                        break;
            case 'U':   /* DefaultPointSize  */
                        sscanf(Skip(), "%d", &DefaultPointSize);
                        break;
            case 'V':   /* Postscript Orientation  */
                        PSOrientation = LANDSCAPE;
                       break;
            case 'W':   /* Scalefactor - Scalefoactor */
                        sscanf(Skip(), "%lf", &UserScaleFactor);
                        break;
            case 'X':   /* Axis Selection */
                        AxisLabel = 1;
                        break;
            case 'Y':   /* Depth Cueing */
                        DepthCueing = 1;
                       break;
	    case 'Z':   /* Axis Size  */
                        sscanf(Skip(), "%d", &DefaultAxisSize);
                        Axis = 1;
                        break;
            case 'a':   /* RotateGuide */
                        RotateGuide = 1;
                        break;
            case 'o':
                        OutLine = 1;
                        break;
            case 'u':
                        sscanf(Skip(), "%lf", &ScaleNumber);
			Scale_factor = LogScale(ScaleNumber);
                        break;
	    case 'b':   /* Image in background */
                        sscanf(Skip(), "%s", BckGrdStr);
                        BackImage = ReadImage(BckGrdStr, &BackDropWidth, &BackDropHeight);
			if (BackImage!=NULL) BackDropImage = 1;
                        else BackDropImage = 0;
                        break;
	    case 'G':   /* load a file(s) with .gf 3D-sets, @xgf A.Tai G.Matas */
                 /* Allows compress files though */
                 sscanf(Skip(), "%s", filename);
		 SpecialEmpty3DSets();
                 Append3DSets(filename);
		 if (WindowOpen) DoneCursor();
	    break;
	    case 'd': /* delay */
                sscanf(Skip(),"%d",&delay);
                delay_start=time(0);
                in_delay=1;
                return False;
            break;

        }
  }
   lock = 0;
return True;
}

char * FindOpt()
{
  static FILE * comm_file, *ctrl_file;
  static NoFile = 1;
  char * line_pos1;
  char rmcom[210];
 
/*  fprintf(stderr,"controlfile = %s \n",controlfile); */
/*  fprintf(stderr,"commandfile = %s \n",commandfile); */
  if (NoFile)
    if (0 != (ctrl_file=(fopen(controlfile/*"xgf_comm_cont"*/,"r")))){
      fclose(ctrl_file);
      if (0 != (comm_file=fopen(commandfile/*"xgf_comm"*/,"r")))
        NoFile=0;
      else {
        fprintf(stderr,"Can't open commandfile %s !\n",commandfile);
        exit (-1);
      }
    }

  if(!NoFile) {
    line_pos1 = FindOption1(comm_file)   ;
/*    fprintf(stderr,"line_pos1 = %s \n",line_pos1);*/
    if (line_pos1 == 0) {
      NoFile = 1;
      fclose(comm_file);
      strcpy(rmcom,"/bin/rm ");
       strcat(rmcom,commandfile);
/*       fprintf(stderr,"------ XGF ------ before %s\n",rmcom);*/
     /* system(rmcom "/bin/rm xgf_comm"); */
      strcpy(rmcom,"/bin/rm ");
      strcat(rmcom,controlfile);
/*      fprintf(stderr,"------ XGF ------ before %s\n",rmcom);*/
      system(rmcom /*bin/rm xgf_comm_cont"*/);
    }
  }

  if(NoFile){
     sprintf(line,"-d 2");
     line_pos = line;
     return line;
  }
  else
     return line_pos1;
}

char * FindOption1 (command_file)
FILE * command_file;
{
  while(1){
  if ((NULL == line_pos)){
    if (feof(command_file)) return 0;
    if (0==(line_pos=fgets(line,1000,command_file))) return 0;
  }

  while((*line_pos != '-') && (*line_pos!='\0')) line_pos++;

  if (*line_pos=='-') return line_pos;
  else line_pos=0;
  }
}

char * Skip()
{
  while ((*line_pos==' ')&&(*line_pos!='\0'))line_pos++;
  if (*line_pos=='\0') return buff;
  else return line_pos;
}

