static char         sccsid[] = "@(#)%E% P.Hoad@ee.surrey.ac.uk %I% %M%";
/*
 * Copyright (C) 1992, 1993, 1994, Paul D. Hoad This file is part of the Xmgf
 * Software. For conditions of distribution and use, see the accompanying
 * README file.
 *
 * Vision Speech and Signal Processing Group . Dept. of Electronic Engineering.
 * University of Surrey. Guildford, Surrey. England. Phone: +44 483 300800
 * Ext 2753 Email: P.Hoad@ee.surrey.ac.uk
 */
#include <stdio.h>
#include <assert.h>

#include "XmgfMalloc.h"

#include "XmgfStruct.h"
#include "PostScript.h"
#include "RayShade.h"
#include "XFig.h"
#include "FrameMaker.h"
#include "Parse.h"
#include "SortPoly.h"
#include "InitX.h"
#include "callbacks.h"
#include "Polygon.h"
#include "XmgfGlobal.h"
#include "3Droutines.h"
#include "BackDrop.h"
#include "XmgfDefines.h"
#include "XmgfFont.h"
#include "Mouse.h"
#include "GetColNum.h"
#include "GUI.h"
#include "Read3DSet.h"

double              ax, ay, az, NewThreeDen;
int                 DistSC;
double              R11, R12, R13, R21, R22, R23, R31, R32, R33;
double              FDistSC, FOX, FOY, FOZ;
static double       costab[451];
static double       sintab[451];
char               *CurrentString;

#define MAX_POINTS 1000
#define MAX_PT_SIZE 16

#ifndef _NO_PROTO
void                Clip3D(t_XmgfPoly * Poly);
void                DrawAxisBox(void);
void                WipePolys(t_LL Polys);
void 		    QuickDrawPolys(t_LL Polys);
void 		    QuickAxis();
#else
void                Clip3D();
void                DrawAxisBox();
void                WipePolys();
void 		    QuickDrawPolys();
void 		    QuickAxis();
#endif

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Initalize  All Drawing function (Sinetable)                 */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
InitDraw()
{
 /* Make Sine Table */
  makesintab();
 /* Output Init */
  CurrentString = (char *) XmgfMalloc(MAX_TEXT_LENGTH * sizeof(char));
  assert(CurrentString);
  All_Polys = ConsLL();
  InitSets();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Set All Sets to Invisible */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
InitSets()
{
  t_XmgfSet          *SelectedSet;
  t_XmgfLine         *SelectedLine;
  t_XmgfObject       *SelectedObject;

  ForeachLL_M(gfSets.ListXmgfSets, SelectedSet) {
    ForeachLL_M(SelectedSet->ListXmgfLines, SelectedLine) {
      ForeachLL_M(SelectedLine->ListXmgfObjects, SelectedObject) {
        /* Set all Line and Sets invisible */
	SelectedObject->visible = 0;
      }
    }
  }
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Get Max Depth */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
GetMaxDepth(PolyList, MaxDepth, MinDepth)
t_LL                PolyList;
double             *MaxDepth;
double             *MinDepth;
{
  t_XmgfPoly         *Poly;

  double depth;

  *MaxDepth = (double) -10e7;
  *MinDepth = (double) 10e7;
  if (!Sorting){
  ForeachLL_M(PolyList, Poly) { depth = Poly->z_depth; 
    *MaxDepth = max(*MaxDepth, depth); 
    *MinDepth = min(*MinDepth, depth); 
    } 
  }
  else {
  Poly = FirstElmLL(PolyList);
  *MaxDepth = Poly->z_depth;
  Poly = LastElmLL(PolyList);
  *MinDepth = Poly->z_depth;
  }
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Find Polys visible in this box */
/* Author: Paul Hoad 24/8/1993 */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void 
FindVisibleInBox(vbx1, vby1, vbx2, vby2)
double              vbx1, vby1, vbx2, vby2;
{
  t_XmgfSet          *SelectedSet;
  t_XmgfLine         *SelectedLine;
  t_XmgfObject       *SelectedObject;
  t_XmgfPoly         *Poly;
  t_XmgfPt           *Pt;
  double              PX, PY;

  UnDraw();
  DestLL(All_Polys);
  All_Polys = ConsLL();
  ForeachLL_M(gfSets.ListXmgfSets, SelectedSet) {
    ForeachLL_M(SelectedSet->ListXmgfLines, SelectedLine) {
      ForeachLL_M(SelectedLine->ListXmgfObjects, SelectedObject) {
	if (SelectedObject->visible == 1) {
	  ForeachLL_M(SelectedObject->ListXmgfPolys, Poly) {
	    ForeachLL_M(Poly->ListXmgfPts, Pt) {
	      NEWTHREEDTWOD(Pt->x, Pt->y, Pt->z);
	      PX = ((Scale_factor * ax) + Midx);
	      PY = ((Scale_factor * ay) + Midy);
	      if (PX > vbx1 && PX < vbx2 && PY > vby1 && PY < vby2) {
		SelectedObject->visible = 1;
		InsLastLL(All_Polys, *Poly);
		break;
	      } else {
		SelectedObject->visible = 0;
	      }
	    }
	  }
	}
      }
    }
  }
  Redraw();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Find Bounding Box */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
FindWorldMaxMin()
{
  int n;
  Arg args[10];
  double MaxX,MaxY,MaxZ;

  MaxX=0.0;
  MaxY=0.0;
  MaxZ=0.0;

  InitEmptySet();

  MaxX = (double)max((fabs(MinXDisp)),(fabs(MaxXDisp)));
  MaxY = (double)max((fabs(MinYDisp)),(fabs(MaxYDisp)));
  MaxZ = (double)max((fabs(MinZDisp)),(fabs(MaxZDisp)));
  if (MaxX<2.0) MaxX = 1000.0;
  if (MaxY<2.0) MaxY = 1000.0;
  if (MaxZ<2.0) MaxZ = 1000.0;

#ifdef DEBUG
  fprintf(stderr,"%lf %lf %lf\n",MaxX,MaxY,MaxZ);
#endif

  if(XtIsRealized(OX)&&XtIsRealized(OY)&&XtIsRealized(OZ)){
  n=0;
  XtSetArg(args[n], XmNminimum, -(int)MaxX);n++;
  XtSetArg(args[n], XmNmaximum, (int)MaxX);n++;
  XtSetValues(OX,args,n);
  n=0;
  XtSetArg(args[n], XmNminimum, -(int)MaxY);n++;
  XtSetArg(args[n], XmNmaximum, (int)MaxY);n++;
  XtSetValues(OY,args,n);
  n=0;
  XtSetArg(args[n], XmNminimum, -(int)MaxZ);n++;
  XtSetArg(args[n], XmNmaximum, (int)MaxZ);n++;
  XtSetValues(OZ,args,n);
  }
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Find Bounding Box */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
t_LL
FindBoundingBox(PolyList)
t_LL                PolyList;
{
  t_XmgfPoly         *Poly;
  t_XmgfPt           *Pt;
  t_LL                BoxList;
  t_XmgfPoly          BoxPoly;
  t_XmgfPt            PtA, PtB, PtC, PtD, PtE, PtF, PtG, PtH;
  double              MinX, MinY, MinZ, MaxX, MaxY, MaxZ;

  MinX = MinY = MinZ = 10e7;
  MaxX = MaxY = MaxZ = -10e7;

  if (SizeLL(PolyList) <= 1) {
    MinX = MinY = MinZ = -2;
    MaxX = MaxY = MaxZ = 2;
  } else {
    ForeachLL_M(PolyList, Poly) {
      ForeachLL_M(Poly->ListXmgfPts, Pt) {
	MinX = min(Pt->x, MinX);
	MinY = min(Pt->y, MinY);
	MinZ = min(Pt->z, MinZ);
	MaxX = max(Pt->x, MaxX);
	MaxY = max(Pt->y, MaxY);
	MaxZ = max(Pt->z, MaxZ);
      }
    }
  }
  PtA.x = MinX; PtA.y = MinY; PtA.z = MinZ;
  PtB.x = MinX; PtB.y = MaxY; PtB.z = MinZ;
  PtC.x = MaxX; PtC.y = MaxY; PtC.z = MinZ;
  PtD.x = MaxX; PtD.y = MinY; PtD.z = MinZ;
  PtE.x = MinX; PtE.y = MinY; PtE.z = MaxZ;
  PtF.x = MinX; PtF.y = MaxY; PtF.z = MaxZ;
  PtG.x = MaxX; PtG.y = MaxY; PtG.z = MaxZ;
  PtH.x = MaxX; PtH.y = MinY; PtH.z = MaxZ;
  BoxList = ConsLL();
  BoxPoly.ListXmgfPts = ConsLL();
  BoxPoly.num = 5;
  BoxPoly.ColNum = GetColourNumber("Black");
  BoxPoly.fill = NOFILL;
  BoxPoly.cull = 0;
  BoxPoly.Ill = 0;
  BoxPoly.LineStyle = DOTLS;
  BoxPoly.FillStyle = BLACKLINES;
  BoxPoly.LineWidth = 1;
  strcpy(BoxPoly.Text, "");
  InsLastLL(BoxPoly.ListXmgfPts, PtA);
  InsLastLL(BoxPoly.ListXmgfPts, PtB);
  InsLastLL(BoxPoly.ListXmgfPts, PtC);
  InsLastLL(BoxPoly.ListXmgfPts, PtD);
  InsLastLL(BoxPoly.ListXmgfPts, PtA);
  InsLastLL(BoxList, BoxPoly);
  BoxPoly.ListXmgfPts = ConsLL();
  InsLastLL(BoxPoly.ListXmgfPts, PtE);
  InsLastLL(BoxPoly.ListXmgfPts, PtF);
  InsLastLL(BoxPoly.ListXmgfPts, PtG);
  InsLastLL(BoxPoly.ListXmgfPts, PtH);
  InsLastLL(BoxPoly.ListXmgfPts, PtE);
  InsLastLL(BoxList, BoxPoly);
  BoxPoly.ListXmgfPts = ConsLL();
  InsLastLL(BoxPoly.ListXmgfPts, PtA);
  InsLastLL(BoxPoly.ListXmgfPts, PtE);
  InsLastLL(BoxPoly.ListXmgfPts, PtH);
  InsLastLL(BoxPoly.ListXmgfPts, PtD);
  InsLastLL(BoxPoly.ListXmgfPts, PtA);
  InsLastLL(BoxList, BoxPoly);
  BoxPoly.ListXmgfPts = ConsLL();
  InsLastLL(BoxPoly.ListXmgfPts, PtF);
  InsLastLL(BoxPoly.ListXmgfPts, PtG);
  InsLastLL(BoxPoly.ListXmgfPts, PtC);
  InsLastLL(BoxPoly.ListXmgfPts, PtB);
  InsLastLL(BoxPoly.ListXmgfPts, PtF);
  InsLastLL(BoxList, BoxPoly);
  return BoxList;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* UnDraw Everything Basically */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
DrawClear()
{
  InitSets();
  UnDraw();
  DestLL(All_Polys);
  All_Polys = ConsLL();
  REDRAW_SCREEN;
#ifdef BLIT_EXPOSES
  SaveScreen(w_Orth);
#endif
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Draw the Bounding Box */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
QuickReDraw()
{
  t_LL Box = FindBoundingBox(All_Polys);
  QuickDrawPolys(Box);
  DestroyAllPolygons(Box);
  QuickAxis();
	
}

void
QuickAxis()
{
  if (Axis) {
    switch (AxisType) {
     case AXIS_ON_CENTROID:
      DrawAxisProc(CentroidX, CentroidY, CentroidZ);
      break;
     case AXIS_ON_CENTRE:
      DrawAxisProc(CentreX, CentreY, CentreZ);
      break;
     case AXIS_BOX:
      DrawAxisBox();
      break;
     default:
      DrawAxisProc(0.0, 0.0, 0.0);
      break;
    }
  }
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Update (i.e. draw) those that are visible */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
UpDateVisible()
{
  t_XmgfSet          *SelectedSet;
  t_XmgfLine         *SelectedLine;
  t_XmgfObject       *SelectedObject;
  t_LL                Tmp;

  UnDraw();
  DestLL(All_Polys);
  All_Polys = ConsLL();
  ForeachLL_M(gfSets.ListXmgfSets, SelectedSet) {
    ForeachLL_M(SelectedSet->ListXmgfLines, SelectedLine) {
      ForeachLL_M(SelectedLine->ListXmgfObjects, SelectedObject) {
	if (SelectedObject->visible == 1) {
	  Tmp = ConsCopyLL(SelectedObject->ListXmgfPolys);
	  MoveListLastLL(All_Polys, Tmp);
	}
      }
    }
  }
  Redraw();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Draw Every Set */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
DrawAllSets()
{
  t_XmgfSet          *SelectedSet;
  t_XmgfLine         *SelectedLine;
  t_XmgfObject       *SelectedObject;
  t_LL                Tmp;

  ForeachLL_M(gfSets.ListXmgfSets, SelectedSet) {
    ForeachLL_M(SelectedSet->ListXmgfLines, SelectedLine) {
      ForeachLL_M(SelectedLine->ListXmgfObjects, SelectedObject) {
	if (SelectedObject->visible != 1) {
	  if (SelectedObject->gfID.IDidentifier != IDIDENTIFIER) {
	    Tmp = ConsCopyLL(SelectedObject->ListXmgfPolys);
	    MoveListLastLL(All_Polys, Tmp);
  /* Set all Line and Sets Visible except ID strings */
	    SelectedObject->visible = 1;
	  } else
	    SelectedObject->visible = 0;
	}
      }
    }
  }
  REDRAW_SCREEN;
#ifdef BLIT_EXPOSES
      SaveScreen(w_Orth);
#endif
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Draw a Single set */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
DrawSingleSet(SetNum)
int                 SetNum;
{
  t_XmgfSet          *SelectedSet;
  t_XmgfLine         *SelectedLine;
  t_XmgfObject       *SelectedObject;
  t_LL                Tmp;

  SelectedSet = SelectSet(&SetNum);
  ForeachLL_M(SelectedSet->ListXmgfLines, SelectedLine) {
    ForeachLL_M(SelectedLine->ListXmgfObjects, SelectedObject) {
      if (SelectedObject->visible != 1) {
	if (SelectedObject->gfID.IDidentifier != IDIDENTIFIER) {
	  Tmp = ConsCopyLL(SelectedObject->ListXmgfPolys);
	  MoveListLastLL(All_Polys, Tmp);
	  SelectedObject->visible = 1;
	} else
	  SelectedObject->visible = 0;
      }
    }
  }
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* same as remove that set */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
UnDrawSingleSet(SetNum)
int                 SetNum;
{
  t_XmgfSet          *SelectedSet;
  t_XmgfLine         *SelectedLine;
  t_XmgfObject       *SelectedObject;
  t_LL                Tmp;

  SelectedSet = SelectSet(&SetNum);
  ForeachLL_M(SelectedSet->ListXmgfLines, SelectedLine) {
    ForeachLL_M(SelectedLine->ListXmgfObjects, SelectedObject) {
      if (SelectedObject->visible == 1) {
	Tmp = ConsCopyLL(SelectedObject->ListXmgfPolys);
	MoveListLastLL(All_Polys, Tmp);
	SelectedObject->visible = 0;
      }
    }
  }
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* This is the new version of DrawSingleLineofSet */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
t_LL
NewDrawSingleLineofSet(SetNum, LineNum)
int                 SetNum;
int                 LineNum;
{
  t_XmgfLine         *SelectedLine;
  t_XmgfObject       *SelectedObject;
  t_LL                Tmp;
  t_LL                SingleSetOfPolys = ConsLL();

  SelectedLine = SelectLine(&SetNum, &LineNum);
  ForeachLL_M(SelectedLine->ListXmgfObjects, SelectedObject) {
    Tmp = ConsCopyLL(SelectedObject->ListXmgfPolys);
    MoveListLastLL(SingleSetOfPolys, Tmp);
  }
  return SingleSetOfPolys;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
t_LL
NewSingleLine(SetNum, LineNum)
int                 SetNum;
int                 LineNum;
{
  t_XmgfLine         *SelectedLine;
  t_LL                AllThingsOnLine;

  SelectedLine = SelectLine(&SetNum, &LineNum);
  AllThingsOnLine = ConsCopyLL(SelectedLine->ListXmgfObjects);
  return AllThingsOnLine;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
DrawSingleItem(ListPolys)
t_LL                ListPolys;
{
  static int                 num;
  t_XmgfPt           *Pt;
  static int          ShadedValue = 0;

  t_XmgfPt            ArrayPt;
  t_XmgfPoly         *Poly;
  static double       MaxDepth, MinDepth, DepthColConst = 0;
  static double       PntCueSizeConst = 0.0;
  static XPoint       points[MAX_POINTS];
  static t_XmgfPt     Dpoints[MAX_POINTS];

 /* Comments Code ready for when clipping is implemented */
  static int                 ArrayIndex = 1, i;
  static int                 Color, BaseType;

 /* Axis */
  if (Axis) {
    switch (AxisType) {
     case AXIS_ON_CENTROID:
      DrawAxisProc(CentroidX, CentroidY, CentroidZ);
      break;
     case AXIS_ON_CENTRE:
      DrawAxisProc(CentreX, CentreY, CentreZ);
      break;
     case AXIS_BOX:
      DrawAxisBox();
      break;
     default:
      DrawAxisProc(0.0, 0.0, 0.0);
      break;
    }
  }
  ForeachLL_M(ListPolys, Poly) {
    ForeachLL_M(Poly->ListXmgfPts, Pt) {
      NEWTHREEDTWOD(Pt->x, Pt->y, Pt->z);
      Pt->ax = (double) ax;
      Pt->ay = (double) ay;
      Pt->az = (double) az;
    }
  }


  if (DefaultFillStyle != BLACKLINES && DefaultFillStyle != WHITELINES) {
 /* Set Up Poly for Sorting */
    ForeachLL_M(ListPolys, Poly) {
      if (Poly->num >= 3) {
/*			Clip3D(Poly);*/
	if (!Poly->Clipped) {
	  visible(Poly);
	}
      } else {
/*			Clip3D(Poly);*/
	if (!Poly->Clipped) {
	  PointVisible(Poly);
	}
	Poly->cull = 0;
      }
    }


 /* Sort Polygon */
    if (Sorting == 1)
      SortPolygons(&ListPolys);
  }
  if (DepthCueing || PointCueing) {
    GetMaxDepth(ListPolys, &MaxDepth, &MinDepth);
  }
  if (DepthCueing == 1) {
    DepthColConst = (MaxDepth - MinDepth) / 63.0;
	
  }
  if (PointCueing == 1) {
    PntCueSizeConst = (MaxDepth - MinDepth) / (double) MAX_PT_SIZE;
  }
  if (viewtype == 0) {
 /* 3D orth Projections */
    if (!RedBlue){
    ForeachLL_M(ListPolys, Poly) {
      num = Poly->num;
      if (Poly->Clipped || (BackFace == 1 && Poly->cull == 1))
	continue;
      ArrayIndex = 0;
      ForeachLL_M(Poly->ListXmgfPts, Pt) {
	ArrayPt.x = ((Scale_factor * Pt->ax) + Midx);
	ArrayPt.y = ((Scale_factor * Pt->ay) + Midy);
	if (OutRay == 1) {
	  Dpoints[ArrayIndex].x = Pt->ax;
	  Dpoints[ArrayIndex].y = Pt->ay;
	  Dpoints[ArrayIndex].z = Pt->az;
	}
	points[ArrayIndex].x = (short) ArrayPt.x;
	points[ArrayIndex++].y = (short) ArrayPt.y;
      }

      ShadedValue = (int) Poly->Ill;
      if (SelectColours == 1) {
	Color = (int) Poly->ColNum;
      } else {
	Color = (int) Poly->Ill;
      }

      if (DepthCueing == 1) {
	if (DepthColConst == 0.0)
	  Color = 63;
	else {
	  Color = 63 - (int) fabs((Poly->z_depth - MinDepth) /
	    DepthColConst);
	  ShadedValue = Color;
	}
      }
      if (PointCueing == 1) {
	if (PntCueSizeConst == 0.0) {
	  DefaultPointSize = 1.0;
	} else {
	  DefaultPointSize = 1 + MAX_PT_SIZE - (int)
	    ((Poly->z_depth - MinDepth) / PntCueSizeConst);
	}
      } else
	DefaultPointSize = Poly->PtSize;

      if (Color == UNDEF_COLOR) {
	Color = Poly->Ill;
      }
 /* Do you Want to have on screen labels */
      BaseType = 0;
      if (SelectLabels == 1) {
	if (Poly->BaseType == TEXTLABEL) {
	  BaseType = TEXTLABEL;
	  FontFamily = Poly->Font;
	  FontSize = Poly->FontSize;
	  FontWeight = Poly->FontWeight;
	  FontSlant = Poly->FontSlant;
	  strcpy(CurrentString, Poly->Text);
	}
      }
 /* Postscript Output */
      if (OutPost == 1) {
	if (DoubleBuff == 1)
	  PolygonPS(points, num, FillPolys, theDrawable, Color, Poly->PtType, BaseType, Poly->LineStyle, Poly->LineWidth, Poly->FillStyle, ShadedValue);
	else
	  PolygonPS(points, num, FillPolys, w_Orth, Color, Poly->PtType, BaseType, Poly->LineStyle, Poly->LineWidth, Poly->FillStyle, ShadedValue);
      } else if (OutPostCol == 1) {
	if (DoubleBuff == 1)
	  PolygonPS(points, num, FillPolys, theDrawable, Color, Poly->PtType, BaseType, Poly->LineStyle, Poly->LineWidth, Poly->FillStyle, ShadedValue);
	else
	  PolygonPS(points, num, FillPolys, w_Orth, Color, Poly->PtType, BaseType, Poly->LineStyle, Poly->LineWidth, Poly->FillStyle, ShadedValue);
      }
 /* XFig Output */
      else if (OutFig == 1) {
	if (DoubleBuff == 1)
	  PolygonFIG(points, num, FillPolys, theDrawable, Color, Poly->PtType, BaseType, Poly->LineStyle, Poly->LineWidth, Poly->FillStyle, ShadedValue);
	else
	  PolygonFIG(points, num, FillPolys, w_Orth, Color, Poly->PtType, BaseType, Poly->LineStyle, Poly->LineWidth, Poly->FillStyle, ShadedValue);
      } else if (OutFigCol == 1) {
	if (DoubleBuff == 1)
	  PolygonFIG(points, num, FillPolys, theDrawable, Color, Poly->PtType, BaseType, Poly->LineStyle, Poly->LineWidth, Poly->FillStyle, ShadedValue);
	else
	  PolygonFIG(points, num, FillPolys, w_Orth, Color, Poly->PtType, BaseType, Poly->LineStyle, Poly->LineWidth, Poly->FillStyle, ShadedValue);
      }
 /* RayShade */
      else if (OutRay == 1) {
	if (DoubleBuff == 1)
	  PolygonRAY(Dpoints, num, FillPolys, theDrawable, Color);
	else
	  PolygonRAY(Dpoints, num, FillPolys, w_Orth, Color);
      }
 /* FrameMaker */
      else if (OutFrame == 1) {
	if (DoubleBuff == 1)
	  PolygonFRAME(points, num, FillPolys, theDrawable, Color, Poly->PtType, BaseType, Poly->LineStyle, Poly->LineWidth, Poly->FillStyle, ShadedValue);
	else
	  PolygonFRAME(points, num, FillPolys, w_Orth, Color, Poly->PtType, BaseType, Poly->LineStyle, Poly->LineWidth, Poly->FillStyle, ShadedValue);
      }
      if (DoubleBuff == 1)
	Polygon(points, num, FillPolys, theDrawable, Color, Poly->PtType, BaseType, Poly->LineStyle, Poly->LineWidth, Poly->FillStyle, ShadedValue);
      else
	Polygon(points, num, FillPolys, w_Orth, Color, Poly->PtType, BaseType, Poly->LineStyle, Poly->LineWidth, Poly->FillStyle, ShadedValue);
    }
    } /* if */
    else {
    for (i = 0; i < 2; i++) {
      ForeachLL_M(ListPolys, Poly) {
        num = Poly->num;
        ArrayIndex = 0;
        ForeachLL_M(Poly->ListXmgfPts, Pt) {
          switch (i) {
           case 0:
            ThreeDxyz(Pt->x, Pt->y, Pt->z, 20);
            break;
           case 1:
            ThreeDxyz(Pt->x, Pt->y, Pt->z, 21);
            break;
          }
          points[ArrayIndex].x = (short) ((Scale_factor * ax) + Midx);
          points[ArrayIndex].y = (short) ((Scale_factor * ay) + Midy);
          ArrayIndex++;
        }
        if (DepthCueing == 1) {
          GetMaxDepth(ListPolys, &MaxDepth, &MinDepth);
          DepthColConst = (MaxDepth - MinDepth) / 63.0;
        }
          BaseType = 0;

        switch (i) {
         case 0:{
/*	    Color=GetColourNumber("Red");*/
	    Color=LeftEyeColour;
            Polygon(points, num, FillPolys, w_Orth, Color, Poly->PtType, BaseType, Poly->LineStyle, Poly->LineWidth, Poly->FillStyle, ShadedValue);
            break;
          }
         case 1:{
/*	    Color=GetColourNumber("Cyan");*/
	    Color=RightEyeColour;
            Polygon(points, num, FillPolys, w_Orth, Color, Poly->PtType, BaseType, Poly->LineStyle, Poly->LineWidth, Poly->FillStyle, ShadedValue);
            break;
          }
        }
      }
    }
    }
  } else if (viewtype == 1) {
 /* 3D orth Projections +Multi views */
    for (i = 0; i < 4; i++) {
      ForeachLL_M(ListPolys, Poly) {
	num = Poly->num;
	ArrayIndex = 0;
	ForeachLL_M(Poly->ListXmgfPts, Pt) {
	  switch (i) {
	   case 0:
	    NEWTHREEDTWOD(Pt->x, Pt->y, Pt->z);
	    break;
	   case 1:
	    ThreeDxyz(Pt->x, Pt->y, Pt->z, i - 1);
	    break;
	   case 2:
	    ThreeDxyz(Pt->x, Pt->y, Pt->z, i - 1);
	    break;
	   case 3:
	    ThreeDxyz(Pt->x, Pt->y, Pt->z, i - 1);
	    break;
	  }
	  points[ArrayIndex].x = (short) ((Scale_factor * ax) + Midx);
	  points[ArrayIndex].y = (short) ((Scale_factor * ay) + Midy);
	  ArrayIndex++;
	}
	if (SelectColours == 1)
	  Color = (int) Poly->ColNum;
	else
	  Color = (int) Poly->Ill;

	if (DepthCueing || PointCueing) {
	  GetMaxDepth(ListPolys, &MaxDepth, &MinDepth);
	}
	if (DepthCueing == 1) {
	  DepthColConst = (MaxDepth - MinDepth) / 63.0;
	}
	if (PointCueing == 1) {
	  PntCueSizeConst = (MaxDepth - MinDepth) / 10.0;
	}
 /* Do you Want to have on screen labels */
	if (SelectLabels == 1) {
	  if (Poly->BaseType == TEXTLABEL) {
	    BaseType = TEXTLABEL;
	    strcpy(CurrentString, Poly->Text);
	  } else
	    BaseType = 0;
	} else
	  BaseType = 0;

	if (OutPost != 1) {
	  switch (i) {
	   case 0:{
	      Polygon(points, num, FillPolys, w_Orth, Color, Poly->PtType, BaseType, Poly->LineStyle, Poly->LineWidth, Poly->FillStyle, ShadedValue);
	      break;
	    }
	   case 1:{
	      Polygon(points, num, FillPolys, w_Plan, Color, Poly->PtType, BaseType, Poly->LineStyle, Poly->LineWidth, Poly->FillStyle, ShadedValue);
	      break;
	    }
	   case 2:{
	      Polygon(points, num, FillPolys, w_Frnt, Color, Poly->PtType, BaseType, Poly->LineStyle, Poly->LineWidth, Poly->FillStyle, ShadedValue);
	      break;
	    }
	   case 3:{
	      Polygon(points, num, FillPolys, w_Side, Color, Poly->PtType, BaseType, Poly->LineStyle, Poly->LineWidth, Poly->FillStyle, ShadedValue);
	      break;
	    }
	  }
	}
      }
    }
  } else {
 /* 3D orth Projections +Multi views */
    for (i = 0; i < 2; i++) {
      ForeachLL_M(ListPolys, Poly) {
	num = Poly->num;
	ArrayIndex = 0;
	ForeachLL_M(Poly->ListXmgfPts, Pt) {
	  switch (i) {
	   case 0:
	    ThreeDxyz(Pt->x, Pt->y, Pt->z, 10);
	    break;
	   case 1:
	    ThreeDxyz(Pt->x, Pt->y, Pt->z, 11);
	    break;
	  }
	  points[ArrayIndex].x = (short) ((Scale_factor * ax) + Midx);
	  points[ArrayIndex].y = (short) ((Scale_factor * ay) + Midy);
	  ArrayIndex++;
	}
	if (SelectColours == 1)
	  Color = (int) Poly->ColNum;
	else
	  Color = (int) Poly->Ill;
	if (DepthCueing == 1) {
	  GetMaxDepth(ListPolys, &MaxDepth, &MinDepth);
	  DepthColConst = (MaxDepth - MinDepth) / 63.0;
	}
 /* Do you Want to have on screen labels */
	if (SelectLabels == 1) {
	  if (Poly->BaseType == TEXTLABEL) {
	    BaseType = TEXTLABEL;
	    strcpy(CurrentString, Poly->Text);
	  } else
	    BaseType = 0;
	} else
	  BaseType = 0;

	switch (i) {
	 case 0:{
	    Polygon(points, num, FillPolys, w_Orth, Color, Poly->PtType, BaseType, Poly->LineStyle, Poly->LineWidth, Poly->FillStyle, ShadedValue);
	    break;
	  }
	 case 1:{
	    Polygon(points, num, FillPolys, w_Right, Color, Poly->PtType, BaseType, Poly->LineStyle, Poly->LineWidth, Poly->FillStyle, ShadedValue);
	    break;
	  }
	}
      }
    }
  }
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
UnDraw()
{
  switch (DoubleBuff) {
    case 0:{
      if (viewtype == 1) {
	XClearWindow(theDisplay, w_Side);
	XClearWindow(theDisplay, w_Plan);
	XClearWindow(theDisplay, w_Frnt);
	XClearWindow(theDisplay, w_Orth);
      } else if (viewtype == 2) {
	XClearWindow(theDisplay, w_Orth);
	XClearWindow(theDisplay, w_Right);
      } else {
	XClearWindow(theDisplay, w_Orth);
      }
      break;
    }
   case 1:{
      if (viewtype == 1) {
	XClearWindow(theDisplay, w_Side);
	XClearWindow(theDisplay, w_Plan);
	XClearWindow(theDisplay, w_Frnt);
	XClearWindow(theDisplay, w_Orth);
      } else if (viewtype == 2) {
	XClearWindow(theDisplay, w_Orth);
	XClearWindow(theDisplay, w_Right);
      } else {
	ClearBuff(w_Orth, DrawingAreaWidth, DrawingAreaHeight);
      }
      break;
    }
  }
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Update Rotation Parameters to speed thing up Version 1.2   */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
UpdateRotationParms()
{
  static double  CosTheta, SinTheta, CosPhi, SinPhi, CosGamma, SinGamma;

  FDistSC = (double) DistSC;
  CosTheta = costab[Theta];
  SinTheta = sintab[Theta];
  CosPhi = costab[Phi];
  SinPhi = sintab[Phi];
  CosGamma = costab[Gamma];
  SinGamma = sintab[Gamma];

  R11 = CosPhi * CosGamma;
  R12 = -CosPhi * SinGamma;
  R13 = SinPhi;
  R21 = SinTheta * SinPhi * CosGamma + CosTheta * SinGamma;
  R22 = -SinTheta * SinPhi * SinGamma + CosTheta * CosGamma;
  R23 = -SinTheta * CosPhi;
  R31 = -CosTheta * SinPhi * CosGamma + SinTheta * SinGamma;
  R32 = CosTheta * SinPhi * SinGamma + SinTheta * CosGamma;
  R33 = CosTheta * CosPhi;
  FOX = ((double)Ox);
  FOY = ((double)Oy);
  FOZ = ((double)Oz);

 /* MakeLookPt(); should roughly determine the look point */
 /* MakeLookPt(); */


}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
ThreeDxyz(x, y, z, direction)
double              x;
double              y;
double              z;
int                 direction;
{
  double              ca, sa, cb, sb, cg, sg;
  double              a11, a12, a13, a21, a22, a23, a31, a32, a33;
  double              tx, ty, tz;
  double              ThetaRad, PhiRad, GammaRad;

  switch (direction) {
   case 0:{
      ThetaRad = Deg2Rad((double) Theta);
      PhiRad = 0;
      GammaRad = 0;
      break;
    }
   case 1:{
      ThetaRad = 0;
      PhiRad = Deg2Rad((double) Phi);
      GammaRad = 0;
      break;
    }
   case 2:{
      ThetaRad = 0;
      PhiRad = 0;
      GammaRad = Deg2Rad((double) Gamma);
      break;
    }
   case 10:{
      ThetaRad = Deg2Rad((double) Theta);
      PhiRad = Deg2Rad((double) Phi + 10);
      GammaRad = Deg2Rad((double) Gamma);
      break;
    }
   case 11:{
      ThetaRad = Deg2Rad((double) Theta);
      PhiRad = Deg2Rad((double) Phi - 10);
      GammaRad = Deg2Rad((double) Gamma);
      break;
    }
   case 20:{
      ThetaRad = Deg2Rad((double) Theta);
      PhiRad = Deg2Rad((double) Phi);
      GammaRad = Deg2Rad((double) Gamma+5);
      break;
    }
   case 21:{
      ThetaRad = Deg2Rad((double) Theta);
      PhiRad = Deg2Rad((double) Phi);
      GammaRad = Deg2Rad((double) Gamma-5);
      break;
    }
   default:{
      ThetaRad = Deg2Rad((double) Theta);
      PhiRad = Deg2Rad((double) Phi);
      GammaRad = Deg2Rad((double) Gamma);
    }
  }

  x = x + (double) Ox;
  y = y + (double) Oy;
  z = z + (double) Oz;

  ca = cos(ThetaRad);
  sa = sin(ThetaRad);
  cb = cos(PhiRad);
  sb = sin(PhiRad);
  cg = cos(GammaRad);
  sg = sin(GammaRad);
  a11 = cb * cg;
  a12 = -cb * sg;
  a13 = sb;
  a21 = sa * sb * cg + ca * sg;
  a22 = -sa * sb * sg + ca * cg;
  a23 = -sa * cb;
  a31 = -ca * sb * cg + sa * sg;
  a32 = ca * sb * sg + sa * cg;
  a33 = ca * cb;

  tx = a11 * (double) x + a12 * (double) y + a13 * (double) z;
  ty = a21 * (double) x + a22 * (double) y + a23 * (double) z;
  tz = a31 * (double) x + a32 * (double) y + a33 * (double) z;

  ax = ((double) (tx * (double) DistSC)) / ((double) (tz + (double) DistSC));
  ay = ((double) (ty * (double) DistSC)) / ((double) (tz + (double) DistSC));

  return;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
PointVisible(Poly)
t_XmgfPoly         *Poly;
{
  t_XmgfPt           *Pt;
  static double       xa[100], ya[100], za[100];
  int                 count = 0;
  double              midz = 0.0;

  Poly->z_depth = 0;

  ForeachLL_M(Poly->ListXmgfPts, Pt) {
    xa[count] = Pt->ax;
    ya[count] = Pt->ay;
    za[count] = Pt->az;
    midz += Pt->az;
    count++;
    if (count >= 100) {
      count = 100;
      break;
    }
  }
  if (count > 0)
    Poly->z_depth = (int) (1000.0 * (midz / count));
  else
    Poly->z_depth = 0;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Clip3D is trying to determine if polygon is inside the        */
/* viewing cone as it seems little point in drawing it otherwise */
/* currently only those polys whose verticies are completely     */
/* outside the cone are removed. this might lead to problems     */
/* where apolygons verticies are not visible but the plane is    */
/* Solution this only happens when verticies are not completely  */
/* invisible above one plane so this must be an && rule not a || */
/* new XmgfPt means no need to recompute ax,ay,az                */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
Clip3D(Poly)
t_XmgfPoly         *Poly;
{
  t_XmgfPt           *Pt;
  int                 ClippedPoly = 1;
  int                 ClipLeft = 0;
  int                 ClipRight = 0;
  int                 ClipTop = 0;
  int                 ClipBottom = 0;
  int                 Behind = 0;
  int                 Size;
  double              XViewThres;
  double              YViewThres;
  double              PX, PY;

  XViewThres = (double) (DrawingAreaWidth) / (2 * DistSC);
  YViewThres = (double) (DrawingAreaHeight) / (2 * DistSC);

  Size = SizeLL(Poly->ListXmgfPts);
  ForeachLL_M(Poly->ListXmgfPts, Pt) {
    PX = ((Scale_factor * Pt->ax) + Midy);
    PY = ((Scale_factor * Pt->ay) + Midy);
    if (Pt->az > -DistSC)
      Behind += 1;
    if ((PX > (XViewThres * Pt->az) && (PX > (-XViewThres * Pt->az)))) {
      ClippedPoly = 0;
    } else {
      if (PX < (XViewThres * Pt->az)) {
	ClipLeft += 1;
      }
      if (PX < (-XViewThres * Pt->az)) {
	ClipRight += 1;
      }
    }
    if ((PY > (YViewThres * Pt->az)) && (PY > (-YViewThres * Pt->az))) {
      ClippedPoly = 0;
    } else {
      if (PY < (YViewThres * Pt->az)) {
	ClipTop += 1;
      }
      if (PY < (-YViewThres * Pt->az)) {
	ClipBottom += 1;
      }
    }
  }
 /* Kill Polugon if all Verticies are off screen and same side */
  if (ClipLeft == Size)
    ClippedPoly = 1;
  if (ClipRight == Size)
    ClippedPoly = 1;
  if (ClipTop == Size)
    ClippedPoly = 1;
  if (ClipBottom == Size)
    ClippedPoly = 1;
  if (ClippedPoly) {
    Poly->Clipped = 1;
  } else
    Poly->Clipped = 0;
 /* default setup for depth */
  Poly->z_depth = 0;
  return;
}



/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
visible(Poly)
t_XmgfPoly         *Poly;
{
  static t_XmgfPt            S, R;
  double              c;
  t_XmgfPt           *Pt;
  static double       xa[5], ya[5], za[5];
  int                 count = 0;
  double              midz = 0.0;
  double              PDHden;

/* Now ax,ay,az will be precomputed coming into here */
/*		NEWTHREEDTWOD(Pt->x, Pt->y, Pt->z);  */
  ForeachLL_M(Poly->ListXmgfPts, Pt) {
    xa[count] = Pt->ax;
    ya[count] = Pt->ay;
    za[count++] = Pt->az;
    midz += Pt->az;
    if (count >= 3) {
      count = 3;
      break;
    }
  }

/*	if (count > 0) Poly->z_depth = midz / count;*/
  if (count > 0)
    Poly->z_depth = (int) (1000.0 * (midz / count));
  else
    Poly->z_depth = 0;

  R.x = ((ya[1] - ya[0]) * (za[2] - za[0])) - ((za[1] - za[0]) * (ya[2] - ya[0]));
  R.y = ((za[1] - za[0]) * (xa[2] - xa[0])) - ((xa[1] - xa[0]) * (za[2] - za[0]));
  R.z = ((xa[1] - xa[0]) * (ya[2] - ya[0]) - (ya[1] - ya[0]) * (xa[2] - xa[0]));

  S.x = -xa[0];
  S.y = -ya[0];
  S.z = DistSC - za[0];

  c = (double) S.x * (double) R.x + (double) S.y * (double) R.y + (double) S.z * (double) R.z;
 /* if the result is greater than one, the two vectors face in the general same
    direction */
  PDHden = (sqrt(S.x * S.x + S.y * S.y + S.z * S.z) * sqrt(R.x * R.x + R.y * R.y + R.z * R.z));
  if (PDHden != 0.0)
    c = c / PDHden;
  else
    c = 0;

  Poly->Ill = (int) (60.0 * fabs(c));
/*	fprintf(stderr,"%f %d\n",c,Poly->Ill);*/

  if (c > 0)
    Poly->cull = 1;
  else
    Poly->cull = 0;
}

void 
DrawAxisBox()
{
  int                 num;
  static XPoint       points[12];
  t_LL                AxisPolys;
  t_XmgfPoly         *Poly;
  t_XmgfPt           *Pt;
  int                 ArrayIndex;
  int                 Red;

  Red = GetColourNumber("Red");

  AxisPolys = FindBoundingBox(All_Polys);
  ForeachLL_M(AxisPolys, Poly) {
    num = Poly->num;
    ArrayIndex = 0;
    ForeachLL_M(Poly->ListXmgfPts, Pt) {
      NEWTHREEDTWOD(Pt->x, Pt->y, Pt->z);
      Pt->ax = (double) ax;
      Pt->ay = (double) ay;
      Pt->az = (double) az;
      points[ArrayIndex].x = (short) ((Scale_factor * Pt->ax) + Midy);
      points[ArrayIndex].y = (short) ((Scale_factor * Pt->ay) + Midy);
      ArrayIndex++;
    }
    if (DoubleBuff == 1)
      Polygon(points, num, FillPolys, theDrawable, Red, 0, 0, 0, 1, 0, 0);
    else
      Polygon(points, num, FillPolys, w_Orth, Red, 0, 0, 0, 1, 0, 0);
  }
  DestroyAllPolygons(AxisPolys);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
DrawAxisProc(AcenX, AcenY, AcenZ)
double              AcenX;
double              AcenY;
double              AcenZ;
{
  static XPoint              points[6];
  double              F_AxisSize;
  int                 Red, Green, Blue, Black;


  F_AxisSize = (double) DefaultAxisSize;
  if (AxisColour) {
    Red = GetColourNumber("Red");
    Green = GetColourNumber("Green");
    Blue = GetColourNumber("Blue");
  } else {
    Red = Black = GetColourNumber("Black");
    Green = Black;
    Blue = Black;
  }

 /* Axis */
  if (viewtype == 0) {
    NEWTHREEDTWOD(AcenX, AcenY, AcenZ);
    points[0].x = (short) ((Scale_factor * ax) + Midx);
    points[0].y = (short) ((Scale_factor * ay) + Midy);
    NEWTHREEDTWOD(AcenX, AcenY, F_AxisSize + AcenZ);
    points[1].x = (short) ((Scale_factor * ax) + Midx);
    points[1].y = (short) ((Scale_factor * ay) + Midy);
    if (DoubleBuff == 1)
      Polygon(points, 2, FillPolys, theDrawable, Red, 0, 0, 0, 1, 0, 0);
    else
      Polygon(points, 2, FillPolys, w_Orth, Red, 0, 0, 0, 1, 0, 0);
    NEWTHREEDTWOD(AcenX, AcenY, AcenZ);
    points[0].x = (short) ((Scale_factor * ax) + Midx);
    points[0].y = (short) ((Scale_factor * ay) + Midy);
    NEWTHREEDTWOD(AcenX, F_AxisSize + AcenY, AcenZ);
    points[1].x = (short) ((Scale_factor * ax) + Midx);
    points[1].y = (short) ((Scale_factor * ay) + Midy);
    if (DoubleBuff == 1)
      Polygon(points, 2, FillPolys, theDrawable, Green, 0, 0, 0, 1, 0, 0);
    else
      Polygon(points, 2, FillPolys, w_Orth, Green, 0, 0, 0, 1, 0, 0);
    NEWTHREEDTWOD(AcenX, AcenY, AcenZ);
    points[0].x = (short) ((Scale_factor * ax) + Midx);
    points[0].y = (short) ((Scale_factor * ay) + Midy);
    NEWTHREEDTWOD(F_AxisSize + AcenX, AcenY, AcenZ);
    points[1].x = (short) ((Scale_factor * ax) + Midx);
    points[1].y = (short) ((Scale_factor * ay) + Midy);
    if (DoubleBuff == 1)
      Polygon(points, 2, FillPolys, theDrawable, Blue, 0, 0, 0, 1, 0, 0);
    else
      Polygon(points, 2, FillPolys, w_Orth, Blue, 0, 0, 0, 1, 0, 0);
    NEWTHREEDTWOD(AcenX, AcenY, F_AxisSize + AcenZ);
    points[0].x = (short) ((Scale_factor * ax) + Midx);
    points[0].y = (short) ((Scale_factor * ay) + Midy);
    strcpy(CurrentString, "Z");
    if (DoubleBuff == 1)
      Polygon(points, 1, FillPolys, theDrawable, Red, 0, TEXTLABEL, 0, 1, 0, 0);
    else
      Polygon(points, 1, FillPolys, w_Orth, Red, 0, TEXTLABEL, 0, 1, 0, 0);
    NEWTHREEDTWOD(F_AxisSize + AcenX, AcenY, AcenZ);
    points[0].x = (short) ((Scale_factor * ax) + Midx);
    points[0].y = (short) ((Scale_factor * ay) + Midy);
    strcpy(CurrentString, "X");
    if (DoubleBuff == 1)
      Polygon(points, 1, FillPolys, theDrawable, Blue, 0, TEXTLABEL, 0, 1, 0, 0);
    else
      Polygon(points, 1, FillPolys, w_Orth, Blue, 0, TEXTLABEL, 0, 1, 0, 0);
    NEWTHREEDTWOD(AcenX, F_AxisSize + AcenY, AcenZ);
    points[0].x = (short) ((Scale_factor * ax) + Midx);
    points[0].y = (short) ((Scale_factor * ay) + Midy);
    strcpy(CurrentString, "Y");
    if (DoubleBuff == 1)
      Polygon(points, 1, FillPolys, theDrawable, Green, 0, TEXTLABEL, 0, 1, 0, 0);
    else
      Polygon(points, 1, FillPolys, w_Orth, Green, 0, TEXTLABEL, 0, 1, 0, 0);
  }
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
makesintab()
{
  int                 i;
  double              d, d2;

  for (i = 0; i <= 360 + 90; i++) {
    d = i;
    d2 = cos(DTOR * d);
    costab[i] = d2;
    d2 = sin(DTOR * d);
    sintab[i] = d2;
  }
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
t_XmgfSet          *
SelectSet(SetNum)
int                *SetNum;
{
  t_XmgfSet          *SelectedSet;
  int                 NumofSets;

  if (SetNum == 0)
    *SetNum = 1;
  NumofSets = SizeLL(gfSets.ListXmgfSets);
  while (*SetNum > NumofSets)
    *SetNum -= NumofSets;
  while (*SetNum <= 0)
    *SetNum += NumofSets;
  SelectedSet = NthElmLL((gfSets.ListXmgfSets), (long) (*SetNum));
 /* return set num */
  return SelectedSet;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
t_XmgfLine         *
SelectLine(SetNum, LineNum)
int                *SetNum;
int                *LineNum;
{
  t_XmgfSet          *SelectedSet;
  t_XmgfLine         *SelectedLine;
  int                 NumofLines = 0;

  SelectedSet = SelectSet(SetNum);
  NumofLines = SizeLL(SelectedSet->ListXmgfLines);
  while (*LineNum > NumofLines)
    *LineNum -= NumofLines;
  while (*LineNum <= 0)
    *LineNum += NumofLines;
  SelectedLine = NthElmLL(SelectedSet->ListXmgfLines, *LineNum);
  return SelectedLine;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Draw Next Item */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
NextLine(SetNum, LineNum)
int                *SetNum;
int                *LineNum;
{
  *LineNum = *LineNum + 1;
  SelectLine(SetNum, LineNum);
  return;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Set item to be visible */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SetVisible(SetNum, LineNum)
int                *SetNum;
int                *LineNum;
{
  t_XmgfLine         *SelLine;
  t_XmgfObject       *SelectedObject;

  SelLine = SelectLine(SetNum, LineNum);
  ForeachLL_M(SelLine->ListXmgfObjects, SelectedObject) {
 /* Set Line visible */
    SelectedObject->visible = 1;
  }
  return;
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Draw the previous item */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
PrevLine(SetNum, LineNum)
int                *SetNum;
int                *LineNum;
{
  *LineNum = *LineNum - 1;
  SelectLine(SetNum, LineNum);
  return;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Draw all Sets */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
int
DrawSets()
{
  t_XmgfSet          *SelectedSet;

  ForeachLL_M(gfSets.ListXmgfSets, SelectedSet) {
    DrawSelectedSet(SelectedSet);
  }
  return 0;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Draw A selected set */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
int
DrawSet(SetNum)
int                 SetNum;
{
  t_XmgfSet          *SelectedSet;

  SelectedSet = SelectSet(&SetNum);
  DrawSelectedSet(SelectedSet);

  return 0;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Draw the who of one set */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
DrawSelectedSet(SelectedSet)
t_XmgfSet          *SelectedSet;
{
  t_XmgfLine         *SelectedLine;

  ForeachLL_M(SelectedSet->ListXmgfLines, SelectedLine) {
  }
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Set a single set with a colour	                         */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SetSingleSetCol(SetNum, ColNum)
int                 SetNum;
int                 ColNum;
{
  t_XmgfSet          *SelectedSet;
  t_XmgfLine         *SelectedLine;
  t_XmgfObject       *SelectedObject;
  t_XmgfPoly         *Poly;

  SelectedSet = SelectSet(&SetNum);
  ForeachLL_M(SelectedSet->ListXmgfLines, SelectedLine) {
    ForeachLL_M(SelectedLine->ListXmgfObjects, SelectedObject) {
      ForeachLL_M(SelectedObject->ListXmgfPolys, Poly) {
	Poly->ColNum = ColNum;
      }
    }
  }
  return;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* To determine the look point *Not working completely correctly */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
MakeLookPt()
{

  static double   CosTheta, SinTheta, CosPhi, SinPhi, CosGamma, SinGamma;
  static double   tx, ty, tz;

  FDistSC = (double) DistSC;
  CosTheta = costab[Theta];
  SinTheta = sintab[Theta];
  CosPhi = costab[Phi];
  SinPhi = sintab[Phi];
  CosGamma = costab[Gamma];
  SinGamma = sintab[Gamma];

  ax = 0;
  ay = 0;
  az = -DistSC / (2 * Scale_factor);
 /* Blame XMaple */
  tz = (-ay * CosPhi * SinTheta + ax * SinPhi - FDistSC * NewThreeDen * FOZ + FDistSC * NewThreeDen * CosPhi * az * CosTheta) / FDistSC / NewThreeDen;
  ty = (-FDistSC * NewThreeDen * FOY + SinPhi * FDistSC * NewThreeDen * az * CosTheta * SinGamma - SinPhi * ay * SinTheta * SinGamma - ax * SinGamma * CosPhi + CosGamma * ay * CosTheta + CosGamma * FDistSC * NewThreeDen * az * SinTheta) / FDistSC / NewThreeDen;
  tx = -(-CosGamma * SinPhi * SinTheta * ay + FOX * FDistSC * NewThreeDen + CosGamma * SinPhi * CosTheta * az * FDistSC * NewThreeDen - CosGamma * CosPhi * ax - CosTheta * SinGamma * ay - SinGamma * FDistSC * NewThreeDen * az * SinTheta) / FDistSC / NewThreeDen;
  ax = tx;
  ay = ty;
  az = -tz;
}

void 
WipePolys(Polys)
t_LL                Polys;
{
  int                 num;
  static XPoint       points[1000];
  t_XmgfPoly         *Poly;
  t_XmgfPt           *Pt;
  int                 ArrayIndex;
  int                 Bg;

  Bg = GetColourNumber("Default");

  ForeachLL_M(Polys, Poly) {
    num = Poly->num;
    ArrayIndex = 0;
    ForeachLL_M(Poly->ListXmgfPts, Pt) {
      points[ArrayIndex].x = (short) ((Scale_factor * Pt->ax) + Midx);
      points[ArrayIndex].y = (short) ((Scale_factor * Pt->ay) + Midy);
      ArrayIndex++;
    }
    if (DoubleBuff == 1)
      Polygon(points, num, 0, theDrawable, Bg, 0, 0, 0, 1, 0, 0);
    else
      Polygon(points, num, 0, w_Orth, Bg, 0, 0, 0, 1, 0, 0);
  }
}


void
QuickDrawPolys(Polys)
t_LL                Polys;
{
  int                 num;
  static XPoint       points[1000];
  t_XmgfPoly         *Poly;
  t_XmgfPt           *Pt;
  int                 ArrayIndex;

  ForeachLL_M(Polys, Poly) {
    num = Poly->num;
    ArrayIndex = 0;
    ForeachLL_M(Poly->ListXmgfPts, Pt) {
      NEWTHREEDTWOD(Pt->x, Pt->y, Pt->z);
      points[ArrayIndex].x = (short) ((Scale_factor * ax) + Midx);
      points[ArrayIndex].y = (short) ((Scale_factor * ay) + Midy);
      ArrayIndex++;
    }
    if (DoubleBuff == 1)
      Polygon(points, num, 0, theDrawable, Poly->ColNum, 0, 0, 0, 1, 0, 0);
    else
      Polygon(points, num, 0, w_Orth, Poly->ColNum, 0, 0, 0, 1, 0, 0);
  }
}

