
#include <malloc.h>

typedef  void * xmgfmalloc_t;

#ifdef MALLOCDEBUG
#define XmgfMalloc(x) XmgfMallocSub(x);\
	fprintf(stderr,"Malloc: : file \"%s\", line %d\n", __FILE__, __LINE__);
#define XmgfFree(x) XmgfFreeSub(x);\
	fprintf(stderr,"Free: : file \"%s\", line %d\n", __FILE__, __LINE__);

#ifndef _NO_PROTO 
xmgfmalloc_t XmgfMallocSub();
int XmgfFreeSub();
#else 
xmgfmalloc_t XmgfMallocSub(long size);
int XmgfFreeSub(void *ptr);
#endif

#else
#define XmgfMalloc(x) malloc(x)
#define XmgfFree(x) free(x)
#endif

