
#include <stdio.h>
#include <string.h>

#include "filter.h"

FILE *InputFile;
FILE *OutputFile;

int main(argc, argv)
int argc; char **argv;
	{
	char SingleLineBuffer[MAX_LINE_LEN];
	char Tokens[MAX_NUMB_TOKEN][MAX_TOKEN_LEN];
	int LineCounter, TokenLength, SideCounter, j;
	char *PositionInString;
	char GeneralBuffer[MAX_NAME_LEN];
	bool SetStarted = FALSE;
	float x,y,z;
	char VertixStrings[ MAX_LENGTH_VERTIX ][ MAX_NUMB_SIDES ];

	fprintf(stderr,"minicad2gf Filter :- D.Johnston 1993-Nov-03\n");

	/* check command line arguments, supply extensions and/or
	output file name if required */
	if( !CheckAndOpenFiles( argc, argv ))
	        exit(-1);

	WriteOutput( ";This file produced from minicad2gf filter\n");
	WriteOutput( ";It contains only Polygon3D objects\n");

	/* Now... we can get to work */
	LineCounter = 0;
	while( fgets(SingleLineBuffer,MAX_LINE_LEN,InputFile) != NULL )
		{
		LineCounter++;
		sscanf( SingleLineBuffer, "%s", Tokens[0]);
		
		/* check for any tokens we recognize */
		/* first look for a new set name  */
		if( strncmp(Tokens[0], NAME, strlen(NAME)) == 0 )
		   {
		   /* if a set is already started, terminate it */
		   if( SetStarted == TRUE )
		       WriteOutput("@\n");
                   /* use the supplied name as the new set name,  */
                   PositionInString = strchr(SingleLineBuffer, (int)NAMECHAR);
		   strcpy( Tokens[1], &PositionInString[1] );
		   /* look for the terminating token char */
                   PositionInString = strchr(Tokens[1], (int)NAMECHAR);
		   strcpy( PositionInString, "\0" );                
                   sprintf(GeneralBuffer, "@Set %s\nFormat Polygon3D\n",Tokens[1]);
                   WriteOutput( GeneralBuffer );
                   SetStarted = TRUE;
        	   }

		/* now check for the start of a Polygon3D  */
		if( strcmp(Tokens[0], POLYNAME ) == 0 )
		   /* should be start of a new n-sided polygon */

			{
			/* we read 3D verticies off lines until the end, keep track
			 *  of the number of verticies */
			LineCounter++;
			if (fgets(SingleLineBuffer,MAX_LINE_LEN,InputFile) == NULL )
				FormatError( LineCounter );
			/* read out the x, y and z of the vertix, remove the commas */
			sscanf( SingleLineBuffer, "%f,%f,%f", &x,&y,&z);
			sprintf( GeneralBuffer, "%f %f %f", x,y,z);
			SideCounter = 0;
			strcpy( &VertixStrings[SideCounter][0], GeneralBuffer);

			/* now read the rest of the lines in the polygon until the
			 *  end, and then add these lined to the array
			 */
			while( fgets(SingleLineBuffer,MAX_LINE_LEN,InputFile) != NULL )
				{
				LineCounter++;
				sscanf( SingleLineBuffer, "%s", Tokens[0]);
		
				/* is it the end of this polygon?  */
				if( strncmp(Tokens[0], ENDPOLYNAME, strlen(ENDPOLYNAME)) == 0 )
				   {
				   /* we have finished the polygon, write it out */
				   sprintf( GeneralBuffer, "%d %s \\\n", SideCounter+1, 
				                 &VertixStrings[0][0]);
				   WriteOutput( GeneralBuffer );
				   for(j=1; j<=SideCounter-1 ; j++)
				       {
	  			       sprintf( GeneralBuffer, "%s \\\n",
	  			                 &VertixStrings[ j ][0]);
				       WriteOutput( GeneralBuffer );
				       }
				   sprintf( GeneralBuffer, "%s\n",  
				                 &VertixStrings[ SideCounter ][0]);
				   WriteOutput( GeneralBuffer );
				   break; /* quit this while loop, we have finished the polygon */
				   }
				else
				   /* must be another vertix for the polygon, add it to array */
				   {
				   sscanf( SingleLineBuffer, "%f,%f,%f", &x,&y,&z);
				   sprintf( GeneralBuffer, "%f %f %f",x,y,z);
				   SideCounter++;
				   strcpy( &VertixStrings[ SideCounter ][0], GeneralBuffer);

				   /* just in case, check for large numb sides on polygon */
				   if(SideCounter >= MAX_NUMB_SIDES )
					{
					FormatError( LineCounter );
					break;
					}
				   }
				} /* end of while inside polygon */
			} /* end of 'if polygon' */

		} /* end of outer while loop */

	/* close the output file, close input, exit */
        WriteOutput("@\n");
	close(InputFile);
	close(OutputFile);
	fprintf(stderr,"Conversion complete, %d lines in input file\n", LineCounter);
	return 0;
	}
