proc ExtEditor {} {
global xf ea ee

set xf(ee_on) 1
if [winfo exists .ext_edit] {
wm deiconify .ext_edit
raise .ext_edit
return
}
set ee(top) [toplevel .ext_edit -bd 2]
wm geometry $ee(top) +100+100
wm resizable $ee(top) 0 0
wm title $ee(top) "Extension Editor v1.1"
wm protocol $ee(top) WM_DELETE_WINDOW EE_Exit
SetCnfMenuBg

frame $ee(top).top -relief groove -bd 3
frame $ee(top).top.dummy
frame $ee(top).top.dummy.1
frame $ee(top).top.dummy.1.radio
frame $ee(top).top.dummy.2
frame $ee(top).top.dummy.line
frame $ee(top).top.dummy.check
frame $ee(top).middle
frame $ee(top).lists
frame $ee(top).buttons -relief groove -bd 3
frame $ee(top).buttons.dummy

label $ee(top).top.dummy.1.l -text "Extension:"
entry $ee(top).top.dummy.1.e -textvariable ea(ext) -width 12
pack $ee(top).top.dummy.1.l -side left
pack $ee(top).top.dummy.1.e -side left
radiobutton $ee(top).top.dummy.1.radio.l -text "Left mousebutton" \
-variable ea(button) -value "L"  -selectcolor palevioletred1 \
-bd 2 -relief ridge
radiobutton $ee(top).top.dummy.1.radio.m -text "Middle mousebutton" \
-variable ea(button) -value "M"  -selectcolor palevioletred1 \
-bd 2 -relief ridge
pack $ee(top).top.dummy.1.radio.l $ee(top).top.dummy.1.radio.m -side left
pack $ee(top).top.dummy.1.radio -side right -anchor c
pack $ee(top).top.dummy.1 -side top -fill x

label $ee(top).top.dummy.2.l -text "Command:"
set ea(cmdtxt) "Execute"
menubutton $ee(top).top.dummy.2.mb -textvariable ea(cmdtxt) -menu $ee(top).top.dummy.2.mb.menu \
-width 9 -relief raised -indicatoron true
set cm [menu $ee(top).top.dummy.2.mb.menu -tearoff 1]
$cm add radio -label Execute -variable ea(cmdtxt) -value Execute
$cm add radio -label VirtualZip -variable ea(cmdtxt) -value VirtualZip
$cm add radio -label VirtualTar -variable ea(cmdtxt) -value VirtualTar
$cm add radio -label VirtualLha -variable ea(cmdtxt) -value VirtualLha
entry $ee(top).top.dummy.2.e -textvariable ea(cmd)
pack $ee(top).top.dummy.2.l -side left
pack $ee(top).top.dummy.2.mb -side left
pack $ee(top).top.dummy.2.e -side left -fill x -expand true
pack $ee(top).top.dummy.2 -side top -fill x -pady 2

pack $ee(top).top.dummy.line -side top -fill x -expand true -pady 5

checkbutton $ee(top).top.dummy.check.c -text "Confirm" -variable ea(c) \
-bd 2 -relief ridge -selectcolor palevioletred1 -width 13 -anchor w
checkbutton $ee(top).top.dummy.check.d -text "Quiet" -variable ea(d) \
-bd 2 -relief ridge -selectcolor palevioletred1 -width 13 -anchor w
checkbutton $ee(top).top.dummy.check.w -text "OutputWin" -variable ea(w) \
-bd 2 -relief ridge -selectcolor palevioletred1 \
-width 13 -anchor w
checkbutton $ee(top).top.dummy.check.u -text "Update" -variable ea(u) \
-bd 2 -relief ridge -selectcolor palevioletred1 -width 13 -anchor w
pack $ee(top).top.dummy.check.c $ee(top).top.dummy.check.d $ee(top).top.dummy.check.w \
$ee(top).top.dummy.check.u -side left -fill x -expand true
pack $ee(top).top.dummy.check -side top -fill x -expand true
pack $ee(top).top.dummy -side top -padx 10 -pady 5
pack $ee(top).top -side top

label $ee(top).middle.e -text "Ext" -width 10 -anchor center
label $ee(top).middle.m -text "Button" -width 6 -anchor w
label $ee(top).middle.c -text "Command" -width 9 -anchor w
label $ee(top).middle.o -text "Opts" -width 6 -anchor w
pack $ee(top).middle.e $ee(top).middle.m $ee(top).middle.c -side left
pack $ee(top).middle.o -side right
pack $ee(top).middle -side top -fill x -expand true

button $ee(top).buttons.dummy.new -text "New" -width 6 -command EE_New
button $ee(top).buttons.dummy.rm -text "Remove" -width 6 -command EE_Remove \
-cursor pirate
button $ee(top).buttons.dummy.save -text "Save" -width 6 -command EE_Save
button $ee(top).buttons.dummy.close -text "Close" -width 6 -command EE_Exit
pack $ee(top).buttons.dummy.new $ee(top).buttons.dummy.rm $ee(top).buttons.dummy.save -side left
pack $ee(top).buttons.dummy.close -side right
pack $ee(top).buttons.dummy -side top -fill x -padx 10 -pady 5
pack $ee(top).buttons -side bottom -fill x
scrollbar $ee(top).lists.s -orient vertical \
-command "EE_LBSet yview"
listbox $ee(top).lists.ext -yscrollcommand EE_LBScroll -width 6 -exportselection false -selectbackground "#dfdfaf" -selectborderwidth 1
listbox $ee(top).lists.mb -yscrollcommand EE_LBScroll -width 5 -exportselection false -selectbackground "#dfdfaf" -selectborderwidth 1
listbox $ee(top).lists.cmd -yscrollcommand EE_LBScroll -selectbackground "#dfdfaf" -selectborderwidth 1
listbox $ee(top).lists.opts -yscrollcommand EE_LBScroll -width 6 -exportselection false -selectbackground "#dfdfaf" -selectborderwidth 1

pack $ee(top).lists.s -side left -fill y
pack $ee(top).lists.ext $ee(top).lists.mb -side left -fill y
pack $ee(top).lists.cmd -side left -fill both -expand true
pack $ee(top).lists.opts -side left -fill y
pack $ee(top).lists -side bottom -fill both -expand true

foreach l [list $ee(top).lists.ext $ee(top).lists.mb $ee(top).lists.cmd $ee(top).lists.opts] {
bind $l <Button-1> {
EE_LBSet select clear 0 end
EE_LBSet select set [%W nearest %y]
}
bind $l <ButtonRelease-1> {
EE_LBSet select clear 0 end
EE_LBSet select set [%W nearest %y]
EE_Select %y
}
}
bind $ee(top).top.dummy.1.e <Return> {focus $ee(top).top.dummy.2.e}
bind $ee(top).top.dummy.2.e <Return> {focus $ee(top)}
bind $ee(top) <Control-c> EE_Exit
bind $ee(top) <Escape> EE_Exit

EE_Display 1 $xf(extensions_file)
trace variable ea w EE_Update

EE_Select 0
foreach w [list $ee(top).lists.ext $ee(top).lists.mb $ee(top).lists.cmd $ee(top).lists.opts] {
$w select clear 0 end
$w select anchor 0
$w select set anchor 0
}

}
proc EE_LBSet args {
global ee
foreach lb {$ee(top).lists.ext $ee(top).lists.mb $ee(top).lists.cmd $ee(top).lists.opts} {
eval $lb $args
}
}
proc EE_LBScroll args {
global ee
eval $ee(top).lists.s set $args
EE_LBSet yview moveto [lindex $args 0]
}
proc EE_Select { y } {
global ee ea

set ee(%y) $y
set ind [$ee(top).lists.ext nearest $y]

trace vdelete ea w EE_Update
set ea(c) [string match *C* [lindex $ee(opts) $ind]]
set ea(d) [string match *Q* [lindex $ee(opts) $ind]]
set ea(w) [string match *W* [lindex $ee(opts) $ind]]
set ea(u) [string match *U* [lindex $ee(opts) $ind]]
set ea(ext) [lindex $ee(ext) $ind]
$ee(top).top.dummy.1.e icursor end
set ea(button) [lindex $ee(button) $ind]
set ea(cmdtxt) [lindex $ee(cmdtxt) $ind]

switch -glob -- [lindex $ee(cmdtxt) $ind] {
"Execute" {
set ea(cmd) [string trimright [lindex $ee(cmd) $ind] &]
}
"Virtual*" {
set ea(cmd) "%f"
}
}
$ee(top).top.dummy.2.e icursor end
trace variable ea w EE_Update
}
proc EE_Exit {} {
global ee ea xf

if [info exists ee(changed)] {
if $ee(changed) {
set ret [AskWin "You have made changes! Close the editor without saving?" -100 -100 "Save"]
switch $ret {
0 {return}
2 {
EE_Save
}
default {uplevel #0 {source $xf(extensions_file)}}
}
}
}
trace vdelete ea w EE_Update
set xf(ee_on) 0
SetCnfMenuBg
destroy $ee(top)
unset ee
unset ea
}

proc EE_Update {var index op} {
global ea ee count

set ee(changed) 1
trace vdelete ea w EE_Update
set ind [$ee(top).lists.ext curselection]
if $ea(c) {
set c "C"
} {
set c ""
}
if $ea(d) {
set d "Q"
} {
set d ""
}
if $ea(w) {
set w "W"
} {
set w ""
}
if $ea(u) {
set u "U"
} {
set u ""
}

switch $index {
c -
d -
w -
u {set ee(opts) [lreplace $ee(opts) $ind $ind [format "%s%s%s%s" $c $d $w $u]]}
cmdtxt {
if ![string match $ea(cmdtxt) [lindex $ee(cmdtxt) $ind]] {
switch -glob -- $ea(cmdtxt) {
"Execute" {
set ee(cmd) [lreplace $ee(cmd) $ind $ind {}]
set ea(cmd) {}
focus $ee(top).top.dummy.2.e
}
"Virtual*" {
set ee(cmd) [lreplace $ee(cmd) $ind $ind "$ea(cmdtxt) %f"]
set ea(cmd) "%f"
}
}
set ee(cmdtxt) [lreplace $ee(cmdtxt) $ind $ind $ea(cmdtxt)]
}
}
cmd {
set ea(cmd) [string trimright $ea(cmd) "&"]
switch -glob -- $ea(cmdtxt) {
"Execute" {set ee(cmd) [lreplace $ee(cmd) $ind $ind $ea(cmd)]}
"Virtual*" {
set ea(cmd) "%f"
set ee(cmd) [lreplace $ee(cmd) $ind $ind \
[format "%s %s" $ea(cmdtxt) $ea(cmd)]]
}
}
}
default {
set ee($index) [lreplace $ee($index) $ind $ind $ea($index)]
}
}
switch $index {
button -
ext {
if {[string compare $ea(button) {}] && [string compare $ea(ext) {}]} {
for {set i 0} {$i < [llength [$ee(top).lists.ext get 0 end]]} {incr i} {
set extmb  [format "%s%s" [string trimleft [lindex $ee(ext) $i] .] \
[lindex $ee(button) $i]]
lappend list $extmb
}

if {[set dp [lsearch -exact [lreplace $list $ind $ind] \
[lindex $list $ind]]] >= 0} {
foreach l [list ext mb opts cmd] {
$ee(top).lists.$l select clear 0 end
$ee(top).lists.$l yview $dp
$ee(top).lists.$l select anchor $dp
$ee(top).lists.$l select set anchor $dp
}
if {$dp <= $ind} {
incr dp
}
set resp [AskWin "Overwrite the already existing combination ?"]
if {$resp == 1} {
set ee(ext) [lreplace $ee(ext) $dp $dp $ea(ext)]
set ee(button) [lreplace $ee(button) $dp $dp $ea(button)]
set ee(cmdtxt) [lreplace $ee(cmdtxt) $dp $dp $ea(cmdtxt)]
switch -glob -- $ea(cmdtxt) {
"Execute" {set ee(cmd) [lreplace $ee(cmd) $dp $dp $ea(cmd)]}
"Virtual*" {
set ea(cmd) "%f"
set ee(cmd) [lreplace $ee(cmd) $dp $dp \
[format "%s %s" $ea(cmdtxt) $ea(cmd)]]
}
}
set ee(opts) [lreplace $ee(opts) $dp $dp \
[format "%s%s%s%s" $c $d $w $u]]
set ee(ext) [lreplace $ee(ext) $ind $ind]
set ee(button) [lreplace $ee(button) $ind $ind]
set ee(cmdtxt) [lreplace $ee(cmdtxt) $ind $ind]
set ee(cmd) [lreplace $ee(cmd) $ind $ind]
set ee(opts) [lreplace $ee(opts) $ind $ind]
if {[llength $ee(ext)] < [$ee(top).lists.ext size]} {
foreach l [list ext mb opts cmd] {
$ee(top).lists.$l delete $ind
}
}
incr count -1
set ind [expr $dp-1]
focus $ee(top).top.dummy.2.e
} {
set ea(ext) {}
set ea(button) {}
set ee(ext) [lreplace $ee(ext) $ind $ind {}]
set ee(button) [lreplace $ee(button) $ind $ind {}]
focus $ee(top).top.dummy.1.e
}
} {
set this [lindex $list $ind]
set list [lsort $list]
set nind [lsearch -exact $list $this]
if {$nind != $ind} {
set ee(ext) [lreplace $ee(ext) $ind $ind]
set ee(button) [lreplace $ee(button) $ind $ind]
set ee(cmdtxt) [lreplace $ee(cmdtxt) $ind $ind]
set ee(cmd) [lreplace $ee(cmd) $ind $ind]
set ee(opts) [lreplace $ee(opts) $ind $ind]
set ee(ext) [linsert $ee(ext) $nind $ea(ext)]
set ee(button) [linsert $ee(button) $nind $ea(button)]
set ee(cmdtxt) [linsert $ee(cmdtxt) $nind $ea(cmdtxt)]
switch -glob -- $ea(cmdtxt) {
"Execute" {set ee(cmd) [linsert $ee(cmd) $nind $ea(cmd)]}
"Virtual*" {
set ea(cmd) "%f"
set ee(cmd) [linsert $ee(cmd) $nind \
[format "%s %s" $ea(cmdtxt) $ea(cmd)]]
}
}
set ee(opts) [linsert $ee(opts) $nind [format "%s%s%s%s" $c $d $w $u]]
set ind $nind
}
}
}
}
}


foreach l [list ext mb opts cmd] {
$ee(top).lists.$l delete 0 end
}

for {set a 0} {$a < $count} {incr a} {
$ee(top).lists.ext insert end [lindex $ee(ext) $a]
$ee(top).lists.mb insert end [lindex $ee(button) $a]
$ee(top).lists.opts insert end [lindex $ee(opts) $a]
$ee(top).lists.cmd insert end [lindex $ee(cmd) $a]
}
foreach l [list ext mb opts cmd] {
$ee(top).lists.$l see $ind
$ee(top).lists.$l select anchor $ind
$ee(top).lists.$l select set anchor $ind
}
trace variable ea w EE_Update

}

proc EE_Display {{open {}} {dotfile {}}} {
global ee count

if {$open == 1} {
if [catch {source $dotfile} err] {
MessageBox "Opening $dotfile failed: $err"
}
}
set extlist [lsort $extlist]

set n 0
foreach z $extlist {

set pituus [expr [string length $z]-1]
lappend ee(button) [string index $z $pituus]
lappend ee(ext) [string range $z 0 [expr $pituus-1]]
set opts [lindex [set $z] 0]
if [string match $opts "N"] {
lappend ee(opts) {}
} {
lappend ee(opts) $opts
}

switch -glob -- [lindex [set $z] 1] {
"exec" {
lappend ee(cmdtxt) "Execute"
lappend ee(cmd) [string trimright [lrange [set $z] 2 end] &]
}
"Virtual*" {
lappend ee(cmdtxt) [lindex [set $z] 1]
lappend ee(cmd) [string trimright [lrange [set $z] 1 2] &]
}
}

$ee(top).lists.ext insert end [lindex $ee(ext) $n]
$ee(top).lists.mb insert end [lindex $ee(button) $n]
$ee(top).lists.opts insert end [lindex $ee(opts) $n]
$ee(top).lists.cmd insert end [lindex $ee(cmd) $n]
incr n
}
set count $n
unset extlist

}
proc EE_New {} {
global ee ea count

set ee(%y) [expr 10 * $count]
set ee(changed) 1
trace vdelete ea w EE_Update
foreach x [list ext button opts cmd] {
lappend ee($x) {}
set ea($x) {}
}
set ea(cmdtxt) "Execute"
lappend ee(cmdtxt) "Execute"
incr count

$ee(top).lists.ext insert end [lindex $ee(ext) $count]
$ee(top).lists.mb insert end [lindex $ee(button) $count]
$ee(top).lists.opts insert end [lindex $ee(opts) $count]
$ee(top).lists.cmd insert end [lindex $ee(cmd) $count]

foreach l [list ext mb opts cmd] {
$ee(top).lists.$l yview moveto 1
$ee(top).lists.$l select clear 0 end
$ee(top).lists.$l select anchor $count
$ee(top).lists.$l select set anchor $count
}
foreach x [list c d w u] {
set ea($x) 0
}
focus $ee(top).top.dummy.1.e
trace variable ea w EE_Update
}
proc EE_Remove {} {
global ee count

if {[AskWin "Are You sure ?!"] == 0} {
return
}
set ee(changed) 1
set ind [$ee(top).lists.ext curselection]
foreach l [list ext mb opts cmd] {
$ee(top).lists.$l delete $ind
}
set var [lindex $ee(ext) $ind][lindex $ee(button) $ind]
global $var
catch {unset $var}

foreach x [list ext button cmd cmdtxt opts] {
set ee($x) [lreplace $ee($x) $ind $ind]
}
incr count -1

EE_Select $ee(%y)
}
proc EE_Save {} {
global ee xf count

MakeSaveDir
set xf(extensions_file) "$xf(user_home)[file tail $xf(extensions_file)]"
set out [open $xf(extensions_file).new w]
set  wrong 0

for {set i 0} {$i < $count} {incr i} {

set extmb  [format "%s%s" [string trimleft [lindex $ee(ext) $i] .] \
[lindex $ee(button) $i]]
if {![string match {*[LM]} $extmb] || [string match {[LM]} $extmb]} {
foreach l [list ext mb opts cmd] {
$ee(top).lists.$l select clear 0 end
$ee(top).lists.$l yview $i
$ee(top).lists.$l select anchor $i
$ee(top).lists.$l select set anchor $i
}
MessageBox "Not enough for input...\next+mb: $extmb"
close $out
exec rm $xf(extensions_file).new
return
}
lappend list $extmb

switch -glob -- [lindex $ee(cmdtxt) $i] {
"Execute" {
set cmdtxt " exec"
if ![string match *W* [lindex $ee(opts) $i]] {
set bg " &"
} {
set bg ""
}
}
"Virtual*" {set cmdtxt ""; set bg " %s"}
}
set cmd [string trimright [lindex $ee(cmd) $i] " &"]
if [string match [$ee(top).lists.opts get $i] ""] {
set opts "N"
} {
set opts [lindex $ee(opts) $i]
}
set line [format "%s %s %s%s %s%s %s%s%s" "set" $extmb "\[" "list" \
$opts $cmdtxt $cmd $bg "\]"]
puts $out $line
}
puts $out ""
puts $out [format "%s %s %s%s %s%s" "set" "extlist" "\[" "list" [lsort $list] "\]"]
puts $out ""

close $out
exec mv $xf(extensions_file).new $xf(extensions_file)
set ee(changed) 0
uplevel #0 {source $xf(extensions_file)}

$ee(top).buttons.dummy.save flash
}
