proc MAIN {argc argv} {
global xf xf_image env menu tk_version

puts stdout "Starting X-Files..."
wm withdraw .
after idle SetWaitPointer
set xf(version) "1.41b"
set xf(mail) "xfiles@java.inf.tu-dresden.de"
set xf_image(topimage) [image create bitmap -data "#define top_width 16
#define top_height 16
#define top_x_hot 8
#define top_y_hot 5
static unsigned char top_bits[] = {
0xfe, 0xff, 0xfe, 0xff, 0x80, 0x03, 0xc0, 0x07, 0xe0, 0x0f, 0xf0, 0x1f,
0xf8, 0x3f, 0xc0, 0x07, 0xc0, 0x07, 0xc0, 0x07, 0xc0, 0x07, 0xc0, 0x07,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};"]
set xf_image(bottomimage) [image create bitmap -data "#define bottom_width 16
#define bottom_height 16
#define bottom_x_hot 8
#define bottom_y_hot 10
static unsigned char bottom_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x07, 0xc0, 0x07,
0xc0, 0x07, 0xc0, 0x07, 0xc0, 0x07, 0xf8, 0x3f, 0xf0, 0x1f, 0xe0, 0x0f,
0xc0, 0x07, 0x80, 0x03, 0xfe, 0xff, 0xfe, 0xff
};"]
set xf_image(menuimage) [image create bitmap -data "#define Menubutton_width 11
#define Menubutton_height 14
static unsigned char Menubutton_bits[] = {
0x00, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
0xfe, 0x03, 0xfc, 0x01, 0xf8, 0x00, 0x70, 0x00, 0x20, 0x00, 0x00, 0x00,
0xfe, 0x03, 0xfe, 0x03};"]

if {$argc > 3} {
puts stderr "Syntax: X-Files \[-iconify\] \[left_startupdir \[right_startupdir\]\]"
exit 0
}
CreateLog "left"
CreateLog "right"
if [info exists env(XF_HOME)] {
set xf(xf_home) [string trimright $env(XF_HOME) /]/
} {
set xf(xf_home) [TildeSubst $xf(xf_home)]
}
set xf(user_home) [TildeSubst "~/.x-files/"]
if ![file exists $xf(user_home)] {
if [catch {eval exec mkdir -p -m 0755 -- [list $xf(user_home)]}] {
MakeDirProc $xf(user_home)
}
}
ReadResources
if [catch {set xf(uname) [exec uname -sr]}] {
set xf(uname) {UNKNOWN 9.9.9}
}
SetUnixCommands

frame .xfiles
set xf(log) [option get .xfiles log_messages {}]
set xf(log2file) [option get .xfiles log_messages_to_file {}]
set tmp [option get .xfiles messagelog_file {}]
if {[string compare {} $tmp] == 0} {
set xf(log_file) $xf(user_home)xfLog.1
} {
set xf(log_file) [TildeSubst [file dirname $tmp]][file tail $tmp]
}

MenuBar xf
set xf(trashdir) [TildeSubst [option get .xfiles trash_dir {}]]
if {![file exists $xf(trashdir)]} {
if [catch {eval exec mkdir -p -m 0700 -- [list $xf(trashdir)]}] {
MakeDirProc $xf(trashdir)
}
}
set xf(actionbuttons_file) [LoadConfigFile xf "xfiles.buttons"]
set xf(extensions_file) [LoadConfigFile xf "xfiles.extensions"]
set xf(headers_file) [LoadConfigFile xf "xfiles.headers"]
set xf(user_pophelp_file) [LoadConfigFile xf "xfiles.user_pophelp" 0]
foreach s [list "left" "right"] {
NullSelect xf $s
set xf(fsmode_$s) 0
.log$s.t config -font [option get .xfiles log_font {}]
SetPaths xf $s [option get .xfiles startup_dir_$s {}]
set xf(hiddens_$s) [option get .xfiles hidden_files_$s {}]
}
ParseArgs
foreach s [list "left" "right"] {
if ![file isdirectory $xf(pathi$s)] {
MessageBox "Invalid $s startup path\n$xf(pathi$s) !!" $s
SetPaths xf $s $env(HOME)
}
}
set xf(main_pophelp_file) "$xf(xf_home)xfiles.main_pophelp"
set xf(mailchk) [option get .xfiles mail_check {}]
set xf(mailmsgbox) [option get .xfiles mail_message_box {}]
set xf(r_mail_on_ack) [option get .xfiles read_on_ack {}]
set xf(memenable) [option get .xfiles mem_label {}]
set xf(timeenable) [option get .xfiles time_label {}]
set xf(turbomode) [option get .xfiles turbo_file_operations {}]
set xf(safedelete) [option get .xfiles safe_deletion {}]
set xf(helpmode) 0
set xf(editmode) 0
set xf(editbutton) .xfright.bf(0).f(0).b(0)
set xf(clearselect) 0
set xf(linz1) [option get .xfiles button_line_1 {}]
set xf(linz2) [option get .xfiles button_line_2 {}]
set xf(linz3) [option get .xfiles button_line_3 {}]
set xf(linz4) [option get .xfiles button_line_4 {}]
set xf(linz5) [option get .xfiles button_line_5 {}]
set xf(linz6) [option get .xfiles button_line_6 {}]
set xf(linz7) [option get .xfiles button_line_7 {}]
set xf(linz8) [option get .xfiles button_line_8 {}]
set xf(buttonset1) [option get .xfiles button_set_1 {}]
set xf(buttonset2) [option get .xfiles button_set_2 {}]
set xf(buttonset3) [option get .xfiles button_set_3 {}]
set xf(buttonset4) [option get .xfiles button_set_4 {}]
set xf(button_cols) [option get .xfiles button_cols {}]
set xf(highlightthicknes) [option get .xfiles button_spacing {}]
set xf(bitsi) [option get .xfiles protection_bits {}]
set xf(reg) "<UNREGISTERED>"
set xf(reversi) [option get .xfiles pack_order_reverse {}]
set xf(mb) 1
set xf(links) [option get .xfiles show_link_dest {}]
set xf(outwin_num) 0
set xf(autoupdate) [option get .xfiles auto_update {}]
set xf(extsort) [option get .xfiles sort_by_extension {}]
set xf(autofocus) [option get .xfiles focus_follows_mouse {}]
#if {[set tk_version] > 4.0} {
if {[set xf(user_email) [option get .xfiles user_email {}]] == ""} {
if [info exists env(USER)] {
set xf(user_email) "$env(USER)@[info hostname]"
} elseif [info exists env(USERNAME)] {
set xf(user_email) "$env(USERNAME)@[info hostname]"
} elseif [info exists env(LOGNAME)] {
set xf(user_email) "$env(LOGNAME)@[info hostname]"
} {
set xf(user_email) "Please@Configure.me"
}
}
#}
set xf(leftautoud) [file mtime $xf(pathileft)]
set xf(rightautoud) [file mtime $xf(pathiright)]
set xf(noinfo) 0
set xf(be_on) 0
set xf(ee_on) 0
set xf(re_on) 0
set xf(W) 0
set xf(b2r) 0
if {[set xf(peekheader) [option get .xfiles peek_file_header {}]] == ""} {
set xf(peekheader) 1
}
if {$xf(button_cols) < 1} {set xf(button_cols) 1}
if {$xf(button_cols) > 6} {set xf(button_cols) 6}
for {set a 0} {$a < 6} {incr a} {
set menu($a) ""
}
FileWindow xf .ff
frame .xfleft -relief sunken -bd 2
frame .xfright -relief sunken -bd 2
ButtonFrame 0 {L} {.xfleft}
ButtonFrame 1 {R} {.xfright}
ButtonFrame 2 {L} {.xfleft}
ButtonFrame 3 {R} {.xfright}
ButtonFrame 4 {L} {.xfleft}
ButtonFrame 5 {R} {.xfright}
ButtonFrame 6 {L} {.xfleft}
ButtonFrame 7 {R} {.xfright}
ButtonFrame 8 {L} {.xfleft}
ButtonFrame 9 {R} {.xfright}
ButtonFrame 10 {L} {.xfleft}
ButtonFrame 11 {R} {.xfright}
ButtonFrame 12 {L} {.xfleft}
ButtonFrame 13 {R} {.xfright}
ButtonFrame 14 {L} {.xfleft}
ButtonFrame 15 {R} {.xfright}

if !$xf(reversi) {
set b "bottom"
set t "top"
} {
set b "top"
set t "bottom"
}
pack .xfiles -side $t -fill x
pack .ff -side $b -expand true -fill both
pack .xfleft -side left -expand true -fill both -in .xfiles
pack .xfright -side right -expand true -fill both -in .xfiles

for {set i 0} {$i < 8} {incr i} {
if {$xf(linz[expr $i+1])} {
pack .xfleft.bf([expr 2 * $i]) -side bottom -expand true -fill x
pack .xfright.bf([expr 2 * $i +1]) -side bottom -expand true -fill x
}
}

$xf(pathEnt_left) xview moveto 1
$xf(pathEnt_left) icursor end
$xf(pathEnt_right) xview moveto 1
$xf(pathEnt_right) icursor end
Bindings

if [catch {set site " on [info hostname]"}] {
if [catch {set site " on $env(HOSTNAME)"}] {
set site ""
}
}
wm title . "X-Files $xf(version)$site"
wm geometry . [option get .xfiles geometry {}]
if !$xf(iconify) {
wm deiconify .
tkwait visibility $xf(fuf).rightlist
} {
wm iconify .
}
wm protocol . WM_DELETE_WINDOW {Confirm_exit}
set xf(redrawleft) 0
set xf(redrawright) 0
after idle [list UpdateListbox xf "left"]
after idle [list UpdateListbox xf "right"]

if {$xf(mailmsgbox) == 1} {
.xfmenu.butt.m.mail entryconfigure Read* -state disabled
}
if {![file exists $env(MAIL)] || \
[catch {set xf(mailtime) [file mtime $env(MAIL)]}]} {
set xf(mailtime) 0
set xf(mailatime) 0
MailChk
} {
set xf(mailatime) [file atime $env(MAIL)]
if {$xf(mailchk) == 1} {
MailChk
} {
.xfmenu.butt.m.mail entryconfigure Messa* -state disabled
.xfmenu.butt.m.mail entryconfigure Read* -state disabled
}
}
if {[file exists /proc/meminfo] \
&& ![string match 2.1.* [lindex $xf(uname) 1]] \
&& ![string match 2.2.* [lindex $xf(uname) 1]]} {
.xfmenu.butt.m.sub1 entryconfigure Mem* -state normal
} {
set xf(memenable) 0
.xfmenu.butt.m.sub1 entryconfigure Mem* -state disabled
}
titletime
titlemem
after 1000 [list CheckErrorSize]
after 1000 [list CheckTrashDevice]
unset xf(reversi) xf(iconify)
if {$xf(autoupdate) == 1} {AutoUD}
set xf(config_menu_bg) [.xfmenu.config cget -bg]
set xf(config_menu_abg) [.xfmenu.config cget -activebackground]
SetArrowPointer
bind XF_Listbox <Configure> {
if [string match *right* %W] {
set g [wm geometry .]
regexp {^([^x]*)x([^\+]*)(\+.*)} $g gg w h r
if {$xf(W) != [set wi [winfo width $xf(fuf).rightlist]]} {
set xf(redrawleft) 1
set xf(redrawright) 1
set xf(W) $wi
after idle [list UpdateListbox xf "left"]
after idle [list UpdateListbox xf "right"]
}
}
}
}
proc ParseArgs {} {
global xf argc argv
set xf(iconify) 0
set cc 0
for {set i 0} {$i < $argc} {incr i} {
set a [lindex $argv $i]
switch -- $a {
-iconify {set xf(iconify) 1}
default {
if {$cc == 0} {
SetPaths xf "left" $a
} elseif {$cc == 1} {
SetPaths xf "right" $a
}
incr cc
}
}
}
}
proc ReadResources {} {
global xf

set res1 [catch {option readfile $xf(xf_home)xfilesrc startupFile} err1]
set res2 [catch {option readfile $xf(user_home)xfilesrc userDefault}]
if !$res2 {
set xf(rcfile) $xf(user_home)xfilesrc
} {
set xf(rcfile) $xf(xf_home)xfilesrc
}

if {$res1 && $res2} {
puts stderr "Could not read either $xf(xf_home)xfilesrc or $xf(user_home)xfilesrc. Exiting...\n"
exit
} elseif $res1 {
puts stdout "X-Files startup warning: $err1\n"
}
}
proc SetUnixCommands {} {
global xf

set version "-2-"
set type _[lindex $xf(uname) 0]

if [file exists $xf(user_home)xfiles.commands$type$version] {
source "$xf(user_home)xfiles.commands$type$version"
} {
set pwd [pwd]
cd $xf(user_home)

set xf(COPY) {cp -r --}
set xf(MOVE) {mv -f --}
set xf(DEL) {rm -rf --}
set xf(MKDIR) {mkdir -p --}
set xf(LISTZIP) {unzip -Z}
set xf(TOZIP) {zip -rq}
set xf(DELZIP) {zip -dq}
set xf(FROMZIP) {unzip -oqq}
set xf(ZIPOUTP) {unzip -pqq}
set xf(LISTTAR) {tar tvf}
set xf(TOTAR) {tar -rf}
set xf(FROMTAR) {tar -xf}
set xf(TAROUTP) {tar Oxf}
set xf(LISTLHA) {lha lq}
set xf(TOLHA) {lha aq}
set xf(FROMLHA) {lha eq}
set xf(LHAOUTP) {lha pq}
set xf(DELLHA) {lha dq}
if [catch {exec tar --help} foo] {
catch {eval exec tar} foo
}
if [regexp -nocase -- {--delete} $foo] {
set xf(DELTAR) {tar --delete -f}
set xf(notardel) 0
} {
set xf(DELTAR) {tar -f}
set xf(notardel) 1
}
if [catch {exec df --help} foo] {
set xf(DISKFREE) df
} {
if [regexp -nocase -- {--no-sync} $foo] {
set xf(DISKFREE) {df --no-sync}
} {
set xf(DISKFREE) df
}
}
set xf(df_1k) 0
if {[catch {eval exec df -k}] == 0} {
append xf(DISKFREE) " -k"
set xf(df_1k) 1
}
if {[catch {eval exec df -T}] == 0} {
append xf(DISKFREE) " -T"
set xf(df_1k) 1
}
if [catch {eval exec du -sk}] {
set xf(DIRSIZE) {du -s}
set xf(du_1k) 0
} {
set xf(DIRSIZE) {du -sk}
set xf(du_1k) 1
}
set fh [open $xf(user_home)xfiles.commands$type$version w]
puts $fh "# X-Files commands file, version $version\n# Created on [exec date]\n"
foreach i [list COPY MOVE DEL MKDIR LISTZIP TOZIP DELZIP \
FROMZIP ZIPOUTP LISTTAR TOTAR FROMTAR TAROUTP DELTAR \
notardel DISKFREE df_1k DIRSIZE du_1k LISTLHA TOLHA DELLHA FROMLHA LHAOUTP] {
puts $fh "set xf($i) \{$xf($i)\}"
}
close $fh

cd $pwd
}
}
proc LogBoth {text class} {
after idle [list InsertToLog left $text $class]
after idle [list InsertToLog right $text $class]
}
proc CheckTrashDevice {} {
global xf

set fs [string match {*-T*} $xf(DISKFREE)]
ExecGetDfSize $xf(DISKFREE) $xf(trashdir) fs "left"
if {[string compare "msdos" $fs] == 0} {
MessageBox "Your trashdirectory is in a MSDOS-partition. Insufficient user IQ, disabling safedelete..."
set xf(safedelete) 0
.xfmenu.butt.m.del entryconfigure Safe* -state disabled
}
}
proc CheckErrorSize {} {
global xf
LogBoth "X-Files started on [exec date]" 2
if [catch {set s "[file size $xf(user_home)ErrorLog] bytes"}] {
set s "N/A"
}
LogBoth "Init: size of ErrorLog: $s" 0
set x [winfo pointerx .]
set y [winfo pointery .]

if {[file exists $xf(user_home)ErrorLog] \
&& [file size $xf(user_home)ErrorLog] > [expr 100*1024]} {
if [AskWin "The size of the X-Files 'ErrorLog' -file is over 100 kb.\nRemove it NOW?" -50 -50 {} $x $y] {
exec rm $xf(user_home)ErrorLog
}
}
if [catch {set s "[file size $xf(log_file)] bytes"}] {
set s "N/A"
}
LogBoth "Init: size of log-file: $s" 0
if {[file exists $xf(log_file)] \
&& [file size $xf(log_file)] > [expr 100*1024]} {
if [AskWin "The size of the message log-file is over 100 kb.\nRemove it NOW ?" -50 -50 {} $x $y] {
exec rm $xf(log_file)
}
}
}
proc CreateLog {s} {
global log

set log($s.win) [frame .log$s]
set log($s.nrow) 1

text .log$s.t -wrap word -relief sunken -bd 2 \
-padx 0 -pady 0 -bg "#404040" \
-yscrollcommand [list .log$s.sb set] \
-width 10 -height 6 -wrap char -highlightthickness 0
scrollbar .log$s.sb -command [list .log$s.t yview] -width 8 \
-bg "#404040" -highlightthickness 0
pack .log$s.sb -side $s -fill y
pack .log$s.t -fill both -expand 1
}
proc InsertToLog {s text class} {
global log xf

if {$xf(log) == 1} {
switch $class {
0 {set fg "yellow"}
1 {set fg "#ff9999"}
2 {set fg "#00ffff"}
default {set fg "#333333"}
}
$log($s.win).t configure -state normal
$log($s.win).t tag add tg.$log($s.nrow) $log($s.nrow).0 $log($s.nrow).end
$log($s.win).t tag configure tg.$log($s.nrow) -foreground $fg
if {[regsub -all \n $text {\ } tmp] > 0} {
regsub -all {\\} $tmp {} text
}
$log($s.win).t insert end "* $text\n" tg.$log($s.nrow)
$log($s.win).t see end
$log($s.win).t configure -state disabled
incr log($s.nrow)
}
if {$xf(log2file) == 1} {
after idle [list Log2File $s $text]
}
}
proc Log2File {s text} {
global xf
set lh [open $xf(log_file) {WRONLY APPEND CREAT}]
puts $lh "[exec date]: [format "%-6s %s" [string toupper $s] $text]"
close $lh
}
proc ShowLog {s} {
global log

if [winfo ismapped $log($s.win)] {
place forget $log($s.win)
} {
place $log($s.win) -in .ff.files.${s}list -x 0 -rely 1.0 \
-anchor sw -relwidth 1.0
raise $log($s.win)
update idletasks
}
}
proc ClearLogs {} {
global log

foreach s {left right} {
$log($s.win).t configure -state normal
$log($s.win).t delete 0.0 end
set t$s $log($s.win)
$log($s.win).t configure -state disabled
}
unset log
set log(left.nrow) 1
set log(right.nrow) 1
set log(left.win) $tleft
set log(right.win) $tright
}
proc LogVis {} {
global xf log
set w .ff.bottom
if {$xf(log) == 1} {
pack $w.logl -in $w -side left -before $w.infoleft
pack $w.logr -in $w -side right -before $w.inforight
} {
place forget $log(left.win)
place forget $log(right.win)
pack forget $w.logl
pack forget $w.logr
}
}
proc FormatNumber {number} {
set l [string length $number]
set i 0
set n 0
while {$i<$l} {
incr n
set o $i
incr i 3
set foo($n) [string range $number [expr $l-$i] [expr $l-$o-1]]
}
for {set a $n} {$a > 0} {incr a -1} {
append res "$foo($a) "
}
return $res
}

proc ProtEditor {s} {
global prot res xf

if {[string compare {} $xf(selekted$s)] == 0} {
NoSelect $s
return
}
set xf(clearselect) 1
catch {destroy .prot_edit}
set pe [toplevel .prot_edit]
wm withdraw $pe
wm title $pe "X-Files ProtEditor"
wm geometry $pe +300+300
wm minsize $pe 184 147
wm protocol $pe WM_DELETE_WINDOW {set res abort}

frame $pe.top -bd 3 -relief ridge -bg "#bcbcbc"
label $pe.top.l -bg "#c0c0c0"
pack $pe.top.l -side left -fill x
pack $pe.top -side top -fill x
update idletasks

frame $pe.m
frame $pe.m.1
frame $pe.m.2
frame $pe.m.3
frame $pe.m.4

label $pe.m.1.u -text "user:"
label $pe.m.1.g -text "group:"
label $pe.m.1.a -text "all:"
pack $pe.m.1.a $pe.m.1.g $pe.m.1.u -side bottom -pady 1
pack $pe.m.1 -side left -fill y

label $pe.m.2.l -text "read" -width 6
checkbutton $pe.m.2.u -variable prot(ur) -onvalue 4 -pady 0
checkbutton $pe.m.2.g -variable prot(gr) -onvalue 4 -pady 0
checkbutton $pe.m.2.a -variable prot(ar) -onvalue 4 -pady 0
pack $pe.m.2.a $pe.m.2.g $pe.m.2.u $pe.m.2.l -side bottom
pack $pe.m.2 -side left -fill y

label $pe.m.3.l -text "write" -width 6
checkbutton $pe.m.3.u -variable prot(uw) -onvalue 2 -pady 0
checkbutton $pe.m.3.g -variable prot(gw) -onvalue 2 -pady 0
checkbutton $pe.m.3.a -variable prot(aw) -onvalue 2 -pady 0
pack $pe.m.3.a $pe.m.3.g $pe.m.3.u $pe.m.3.l -side bottom
pack $pe.m.3 -side left -fill y

label $pe.m.4.l -text "execute" -width 6
checkbutton $pe.m.4.u -variable prot(ue) -pady 0
checkbutton $pe.m.4.g -variable prot(ge) -pady 0
checkbutton $pe.m.4.a -variable prot(ae) -pady 0
pack $pe.m.4.a $pe.m.4.g $pe.m.4.u $pe.m.4.l -side bottom
pack $pe.m.4 -side left -fill y

pack $pe.m -side top -fill both

frame $pe.b -bd 3 -relief ridge
button $pe.b.ok -text "OK" -width 6 \
-command {\
set user [expr $prot(ur)+$prot(uw)+$prot(ue)];\
set group [expr $prot(gr)+$prot(gw)+$prot(ge)];\
set all [expr $prot(ar)+$prot(aw)+$prot(ae)];\
set res $user$group$all}

button $pe.b.cancel -text "Cancel" -width 6 \
-command {set res {}}
button $pe.b.abort -text "Abort!" -width 6 \
-command {set res abort}
pack $pe.b.ok -side left -padx 10
pack $pe.b.abort $pe.b.cancel -side right
pack $pe.b -side top -fill x

focus $pe.b.ok
bind $pe <Control-c> {set res ""}
bind $pe <Escape> {set res ""}

wm deiconify $pe
grab $pe

set changed 0
foreach f [GetSelNames $s] {
SetChecks prot $xf(pathi$s) $f
$pe.top.l config -text "File: $f"
tkwait variable res
if ![string compare abort $res] {
set xf(clearselect) 0
set xf(noinfo) 1
after 50 [list set xf(noinfo) 0]
after 150 [list InfoChange xf $s "Command aborted!"]
after 4000 [list DefaultInfo xf $s]
break
}
if [string compare {} $res] {
if [catch {eval exec chmod $res [list $xf(pathi$s)$f]} err] {
MessageBox $err $s
continue
}
set changed 1
}
}
catch {destroy $pe}
unset prot
if $changed {
UpdateListbox xf $s
}
}

proc SetChecks {arr path file} {
upvar $arr prot

catch {file stat $path$file stat}
set mode [expr [format "%o" $stat(mode)] % 1000]
for {set i 0} {$i < 3} {incr i} {
set d [string index $mode $i]
switch $i {
0 {set c u}
1 {set c g}
2 {set c a}
}
set prot(${c}r) [expr $d & 100]
set prot(${c}w) [expr $d & 10]
set prot(${c}e) [expr $d & 1]
}
}
proc LoadConfigFile {arr file {nhf 1}} {
upvar $arr xf

if [file exists $xf(user_home)$file] {
if $nhf {
if [catch {uplevel #0 source $xf(user_home)$file} err] {
puts stderr "Error while reading $xf(user_home)$file: $err"
} {
return $xf(user_home)$file
}
} {
return $xf(user_home)$file
}
}
if [file exists $xf(xf_home)$file] {
if $nhf {
if [catch {uplevel #0 source $xf(xf_home)$file} err] {
puts stderr "Error while reading $xf(xf_home)$file: $err"
} {
return $xf(xf_home)$file
}
} {
return $xf(xf_home)$file
}
}
puts stderr "Could not read $file either in ~/.x-files/ or in $xf(xf_home), exiting..."
exit
}

proc MakeSaveDir {} {
global xf

if ![file exists $xf(user_home)] {
if [catch {eval exec $xf(MKDIR) [list $xf(user_home)]}] {
MakeDirProc $xf(user_home)
}
}
}

proc MakeDirProc {dir {parent {}}} {
if {[string compare {} $dir] == 0} {return}
set dir [string trimright $dir /]/
regexp {^[^/]*/} $dir alku
append parent $alku
regsub {^[^/]*/} $dir {} loppu
if ![file exists $parent] {
exec mkdir [list $parent]
}
MakeDirProc $loppu $parent
}
proc TildeSubst {path {s {}}} {
global env

if [catch {set dir [pwd]/}] {
set dir [string trimright $env(HOME) /]/
}
set path [string trimright $path /]/
set rc $path
if {[string match "\." $path] || [string match "\./" $path]} {
set rc [string trimright $dir /]/
} elseif [regexp {^~[^/]*/} $path beg] {
if [catch {glob -- $beg} err] {
MessageBox "Invalid pathname: $path\nError: $err" $s
set rc [string trimright $env(HOME) /]/
} {
regsub {^~[^/]*/} $path [string trimright $err /]/ rc
}
} elseif [regexp {\.\./} $path beg] {
if [catch {cd $beg} err] {
MessageBox "Invalid pathname: $path\nError: $err" $s
set rc [string trimright $env(HOME) /]/
} {
set new [pwd]
regsub {\.\./} $path $new/ rc
}
} elseif ![string match {/*} $path] {
regsub {^\./} $path {} path
set rc [string trimright [pwd] /]/[string trimright $path /]/
}
catch {cd $dir}
return $rc
}

proc GetParentDir {dir} {
set result [file dirname [string trimright $dir /]]/
if [string match $result //] {
set result /
}
return $result
}

proc Bindings {} {
global xf log

bind XF <Enter> {
SetCursor %W
if {$xf(autofocus) != 0} {
focus %W
}
}
bind . <Tab> {}
bind XF <Control-c> {Confirm_exit}
bind XF <Control-z> {wm iconify .}
bind XF <Escape> {
if [string match {*left*} %W] {
set ent $xf(pathEnt_left)
} {
set ent $xf(pathEnt_right)
}
if {[$ent select present] && [string match [focus] $ent]} {
continue
}
focus $ent
$ent select range 0 end
break
}
bind XF <Button-1> {
if {$xf(helpmode) == 1 } {
HelpInfo %x %y %W
tkButtonUp %W
break
}
}

bind XF <Control-h> {
.xfmenu.help.m invoke 1
if $xf(helpmode) {set m "ON"} {set m "OFF"}
LogBoth "Help mode $m." 2
SetCursor %W
break
}

bind XF "+" {if {$xf(helpmode) == 1} "GetHelp $xf(xf_home)xfiles.manual"}

bind XF <Control-d> {Xf_variable_dumb}

bind XF <Key> {
if [string match {F*} %K] {
set xf(butsetindic) ""
}
switch %K {
F1 {ButtonLines 1 1}
F2 {ButtonLines 2 1}
F3 {ButtonLines 3 1}
F4 {ButtonLines 4 1}
F5 {ButtonLines 5 1}
F6 {ButtonLines 6 1}
F7 {ButtonLines 7 1}
F8 {ButtonLines 8 1}
F9 {
set xf(butsetindic) "Set 1 (F9)"
ButtonLineSets $xf(buttonset1)
}
F10 {
set xf(butsetindic) "Set 2 (F10)"
ButtonLineSets $xf(buttonset2)
break
}
F11 {
set xf(butsetindic) "Set 3 (F11)"
ButtonLineSets $xf(buttonset3)
}
F12 {
set xf(butsetindic) "Set 4 (F12)"
ButtonLineSets $xf(buttonset4)
}
default {}
}
}
bind XF_Path <Double-Button-1> {
if [string match {*left*} %W] {
set s "left"
} {
set s "right"
}
set i [%W index insert]
set end [string first / [string range $xf(pathi$s) $i end]]
if {[string match $xf(pathi$s) [string range $xf(pathi$s) 0 [expr $i + $end]]] == 0} {
FileOK xf $s [string range $xf(pathi$s) 0 [expr $i + $end]] "L"
}
break
}
bind XF_Path <Alt-c> {
selection own %W
break
}
bind XF_Path <Key> {
if [string match {*left*} %W] {
set s "left"
set o "right"
} {
set s "right"
set o "left"
}
if [%W select present] {
switch %K {
Escape {
focus $xf(pathEnt_$o)
$xf(pathEnt_$o) select range 0 end
%W xview moveto 1
%W icursor end
break
}
Delete -
BackSpace {
InvalidateLb $s
%W delete sel.first sel.last
if {[string compare {} $xf(pathi$s)] == 0} {
%W insert 0 "/"
}
%W xview moveto 1
%W icursor end
break
}
Alt_L {}
default {%W select clear}
}
}
switch %K {
Tab {
DirComplete xf $s
break
}
Up -
Down {
if {$xf(smode_$s) == 1 && [$xf(fuf).${s}list size] > 0} {
set sel [$xf(fuf).${s}list curselection]
if {[string compare {} $sel] == 0} {
$xf(fuf).${s}list select set 0
} {
if [string match Up %K] {set i -1} {set i 1}
$xf(fuf).${s}list select clear $sel
$xf(fuf).${s}list select set [expr $sel+$i]
$xf(fuf).${s}list see [expr $sel+$i]
}
}
}
Alt_L {}
default {
InvalidateLb $s
}
}
}
bind XF_Path <Return> {
if [string match {*left*} %W] {
set s "left"
} {
set s "right"
}
%W select clear
set l $xf(fuf).${s}list
set sel [$l curselection]
if {$xf(smode_$s) == 1 && \
[string compare {} $sel] != 0} {
set file [$l get $sel]
$l selection clear $sel
regsub {[^/]*$} $xf(pathi$s) {} xf(pathi$s)
FileOK xf $s $file "L"
} {
BindReturn xf $s
}
}
bind XF_Path <Button-3> {
if [string match {*left*} %W] {
set s "left"
set o "right"
} {
set s "right"
set o "left"
}
if {$xf(smode_$s) == 0} {
SetWaitPointer
ListFlash xf $s
switch $xf(fsmode_$s) {
0 {
if {[string compare $xf(pathi$s) $xf(pathi$o)] == 0} {
UpdBoth
} {
UpdateListbox xf $s
DefaultInfo xf $o
}
}
1 {VirtualZip $xf(virtualfile) $s 1}
2 {VirtualTar $xf(virtualfile) $s 1}
3 {VirtualLha $xf(virtualfile) $s 1}
}
SetArrowPointer
} {
BindReturn xf $s
}
}
bind XF_Path <Leave> {
%W select clear
}
bind XF_Path <Enter> {
if $xf(helpmode) {
%W config -cursor question_arrow
} {
%W config -cursor xterm
}
%W xview moveto 1
%W icursor end
selection handle %W [list EntrySelect %W]
}
foreach k [list left.dirup left.dirroot middle.all_left middle.no_left \
middle.copyleft middle.swap middle.copyright middle.all_right \
middle.no_right right.dirup right.dirroot] {
bind .ff.top.$k <Button-2> {tkButtonDown %W}
bind .ff.top.$k <Button-3> {tkButtonDown %W}
bind .ff.top.$k <ButtonRelease-2> {tkButtonUp %W}
bind .ff.top.$k <ButtonRelease-3> {tkButtonUp %W}
bindtags .ff.top.$k [list XF .ff.top.$k Button . all]
}

foreach k [list left.dirHistory right.dirHistory] {
bind .ff.top.$k <Button-2> {
if {$tkPriv(inMenubutton) != ""} {
tkMbPost $tkPriv(inMenubutton) %X %Y
}
}
bind .ff.top.$k <Button-3> {
if {$tkPriv(inMenubutton) != ""} {
tkMbPost $tkPriv(inMenubutton) %X %Y
}
}
bindtags .ff.top.$k [list XF .ff.top.$k Menubutton . all]
}

foreach k [list middle.hideleft middle.hideright] {
bind .ff.top.$k <Button-2> {tkCheckRadioInvoke %W}
bind .ff.top.$k <Button-3> {tkCheckRadioInvoke %W}
bindtags .ff.top.$k [list XF .ff.top.$k Checkbutton . all]
}

bind Button <Return> {%W invoke}
bind all <F10> {}

bind XF_Listbox <Key-Up> {%W yview scroll -1 units}
bind XF_Listbox <Key-Down> {%W yview scroll 1 units}
bind XF_Listbox <Key-Prior> {%W yview scroll -1 pages}
bind XF_Listbox <Key-Next> {%W yview scroll 1 pages}
bind XF_Listbox <B1-Leave> {
if {!$xf(helpmode)} {
set tkPriv(x) %x
set tkPriv(y) %y
tkListboxAutoScan %W
}
}
bind XF_Listbox <Button-1> {
focus %W
set xf(b1r) 1
if $xf(helpmode) {
HelpInfo %x %y %W
break
} {
tkCancelRepeat
%W activate @%x,%y
tkListboxBeginToggle %W [%W index @%x,%y]
}
}
bind XF_Listbox <ButtonRelease-1> {
if [string match {*left*} %W] {
set s "left"
set o "right"
} {
set s "right"
set o "left"
}
tkCancelRepeat
set a [%W index active]
set n [%W nearest %y]
if {$a <= $n} {
set alku $a
set loppu $n
} {
set alku $n
set loppu $a
}
for {set i $alku} {$i <= $loppu} {incr i} {
if {$i == 0 && [string match {\.\.*} [$xf(fuf).${s}list get 0]]} {
$xf(fuf).${s}list selection clear 0
SetArrowPointer
continue
}
set ind [lsearch -exact $xf(selekted$s) $i]
if ![%W select includes $i] {
if {$ind > -1} {
AddSelSize $s $i "-"
}
} {
if {$ind == -1} {
AddSelSize $s $i "+"
}
}
}
set xf(selekted$s) [$xf(fuf).${s}list curselection]
if $xf(b1r) {
DefaultInfo xf $s
}
set xf(b1r) 1
%W activate @%x,%y
}

bind XF_Listbox <B1-Motion> {
catch {
if !$xf(helpmode) {
set tkPriv(x) %x
set tkPriv(y) %y
tkListboxMotion %W [%W index @%x,%y]
}
}
}

bind XF_Listbox <Double-Button-1> {
set xf(b1r) 0
if [string match {*left*} %W] {
set s "left"
} {
set s "right"
}
SetWaitPointer
set f [FileClick xf $s %y]
FileOK xf $s $f "L"
SetArrowPointer
}

bind XF_Listbox <Button-2> {Listbox_B2 %W %x %y}

bind XF_Listbox <B2-Motion> {
set xf(b2r) 0
if {(%x != $tkPriv(x)) || (%y != $tkPriv(y))} {
set tkPriv(mouseMoved) 1
}
if $tkPriv(mouseMoved) {
%W scan dragto 10000 %y
}
}
bind XF_Listbox <Double-Button-2> {}
bind XF_Listbox <ButtonRelease-2> {Listbox_BR2 %W %y}

bind XF_Listbox <Button-3> {
if [string match {*left*} %W] {
set popup $xf(fuf).leftlist.popup_menu
} {
set popup $xf(fuf).rightlist.popup_menu
}
tk_popup $popup %X %Y
}

bind XF_Listbox <KeyPress> {
if [string match {*left*} %W] {
set s "left"
} {
set s "right"
}
ListKey %W %A $xf(pathi$s) $xf(fsmode_$s)
}
foreach j [list "left" "right"] {
bindtags $xf(fuf).${j}list {XF XF_Listbox . all}
bindtags $xf(pathEnt_$j) {XF XF_Path Entry . all}
bindtags $xf(infoEnt_$j) {XF . all}
}
}

proc Listbox_B2 {W x y} {
global xf tkPriv
set xf(b2r) 1
set tkPriv(x) $x
set tkPriv(y) $y

tkCancelRepeat
$W scan mark $x $y
set tkPriv(mouseMoved) 0
$W activate @$x,$y
after 300 [list set xf(b2r) 0]
}
proc Listbox_BR2 {W y} {
global xf
if {$xf(b2r)} {
if [string match {*left*} $W] {
set s "left"
set o "right"
} {
set s "right"
set o "left"
}
SetWaitPointer
set i [$W nearest $y]
if [$W select includes active] {
AddSelSize $s [$W index active] "-"
set ind [lsearch -exact $xf(selekted$s) [$W index active]]
if {$ind > -1} {
set xf(selekted$s) [lreplace $xf(selekted$s) $ind $ind]
}
CorrectColor $o xf {} {}
ShowSelSize $s
}
set f [FileClick xf $s $y]
$W select set $i
update idletasks
after 500 [list $W selection clear $i]
FileOK xf $s $f "M"
SetArrowPointer
}
}
proc Listbox_B2M {W x y} {
global xf tkPriv
set xf(b2r) 0
if {($x != $tkPriv(x)) || ($y != $tkPriv(y))} {
set tkPriv(mouseMoved) 1
}
if $tkPriv(mouseMoved) {
$W scan dragto 10000 $y
}
}
proc EntrySelect {W offset maxbytes} {
return [$W get]
}
proc SetCursor {W} {
global xf
set cur [lindex [$W config -cursor] end]
if {$xf(helpmode)} {
if {[string match "top_left_arrow" $cur] || \
[string compare {} $cur] == 0} {
$W config -cursor question_arrow
}
} {
if [string match "question_arrow" $cur] {
$W config -cursor top_left_arrow
}
}
}
proc InvalidateLb {s} {
global xf

if {[$xf(fuf).${s}list size] > 0 && $xf(fsmode_$s) == 0} {
set xf(no_aud) 1
NullSelect xf $s
$xf(fuf).${s}list delete 0 end
$xf(fuf).${s}list config  -bg "#9696ff"
set xf(smode_$s) 1
update idletasks
}
}

proc ListKey {W a path fsmode} {
global vdleft vdright

if [string compare {} $a] {
if [string match *left* $W] {
set dirpit $vdleft(size)
} elseif [string match *right* $W] {
set dirpit $vdright(size)
}
set others [$W get $dirpit end]
set flag 1
set pad 0
set i 0
while {$flag} {
set loc [lsearch $others $a*]
if {$loc > -1} {
set flag 0
$W yview [expr $loc+$dirpit+$pad]
} {
scan $a %c i
if {$i > 126} {
set flag 0
$W yview moveto 1
} {
set pad -1
set a [format %c [incr i]]
set loc [lsearch $others $a*]
}
}
}
}
}
proc SetWaitPointer {{W .}} {
$W config -cursor watch
update idletasks
}
proc SetArrowPointer {{W .}} {
$W config -cursor top_left_arrow
update idletasks
}
proc FileWindow {arr parent args} {
upvar $arr xf

if $xf(reversi) {
set t "bottom"
} {
set t "top"
}
frame $parent
frame $parent.top
frame $parent.files
frame $parent.bottom

set xf(fuf) $parent.files
FileEntries xf $parent.top -relief sunken

FileFrame xf $parent.files "left" -height 25 -setgrid true \
-selectmode extended \
-exportselection false -relief ridge
FileFrame xf $parent.files "right" -height 25 -setgrid true  \
-selectmode extended \
-exportselection false -relief ridge
listbox $xf(fuf).dummye -font [$xf(fuf).leftlist cget -font]
$xf(fuf).dummye insert 0 W
set xf(char_W) [expr [lindex [$xf(fuf).dummye bbox 0] 2] +1]
catch {destroy $xf(fuf).dummye}
FileInfo xf $parent.bottom
pack $parent.top -side $t -fill x
pack $parent.bottom -side bottom -fill x
pack $parent.files.left -side left -expand true -fill both
pack $parent.files.right -side right -expand true -fill both
pack $parent.files -side top -expand true -fill both
}

proc ListFlash {arr s} {
upvar $arr xf

set color [$xf(fuf).${s}list cget -bg]
$xf(fuf).${s}list config -bg "#f0f0f0"
update idletasks
$xf(fuf).${s}list config -bg $color
update idletasks
}

proc InfoChange {arr s string} {
upvar $arr xf

if !$xf(noinfo) {
set xf(infoA$s) ""
$xf(infoEnt_$s) config -justify left
$xf(infoEnt_$s) config -bg "#10106a"
set xf(infoA$s) $string
if {![string match {Selected*} $string] && ![string match {Calcul*} $string]} {
after idle [list InsertToLog $s $string 2]
}
update idletasks
}
}

proc DirComplete {arr s} {
upvar $arr xf

if {[string compare {} $xf(pathi$s)] == 0} {
set xf(pathi$s) "/"
$xf(pathEnt_$s) icursor end
ListFlash xf $s
bell
ShowChoices $s
return
}
if [file isdirectory $xf(pathi$s)] {
if {[string match */ $xf(pathi$s)] || \
[llength [GetDirsInDir $s $xf(pathi$s)]] > 1} {
ListFlash xf $s
bell
ShowChoices $s
} {
set xf(pathi$s) [string trimright $xf(pathi$s) /]/
}
$xf(pathEnt_$s) xview moveto 1
$xf(pathEnt_$s) icursor end
return
}
set tail [file tail $xf(pathi$s)]
if {[string match /* $xf(pathi$s)] && ![string match /*/* $xf(pathi$s)]} {
set dir "/"
} elseif [string match /*/* $xf(pathi$s)] {
set dir [file dirname $xf(pathi$s)]/
} elseif  [string compare {/*} $xf(pathi$s)] {
set dir "/"
set tail $xf(pathi$s)
}
if {[string compare {//} $dir] == 0} {
set dir "/"
}
set dirs [GetDirsInDir $s $xf(pathi$s)]

if {[llength [split $dirs]] == 1} {
if [file isdirectory $dir$dirs] {
set xf(pathi$s) $dir$dirs
$xf(pathEnt_$s) xview moveto 1
$xf(pathEnt_$s) icursor end
}
} {
if {[llength [split $dirs]] > 1} {
set l [expr [string length $tail] -1]
set miss 0
set dir1 [lindex $dirs 0]
while {!$miss} {
incr l
if {$l == [string length $dir1]} {
break
}
set new [string range $dir1 0 $l]
foreach d $dirs {
if ![string match $new* $d] {
set miss 1
incr l -1
break
}
}
}
set xf(pathi$s) $dir[string range $dir1 0 $l]
$xf(pathEnt_$s) xview moveto 1
$xf(pathEnt_$s) icursor end
}
ListFlash xf $s
bell
ShowChoices $s
}
}
proc GetDirsInDir {s expr} {
global xf

SetWaitPointer
if {$xf(hiddens_$s) == 1} {
set files [lsort [glob -nocomplain -- $expr{.*,*}]]
} {
set files [lsort [glob -nocomplain -- $expr*]]
}
set dirs ""
foreach f $files {
if {[string match {*\.\.} $f] || [string match {*\.} $f]} {
continue
}
if [file isdirectory $f] {
lappend dirs [file tail $f]/
}
}
SetArrowPointer
return $dirs
}
proc ShowChoices {s} {
global xf
set dirs [GetDirsInDir $s $xf(pathi$s)]
InvalidateLb $s
eval $xf(fuf).${s}list insert end $dirs
}
proc SelectionSize {arr s} {
upvar $arr xf
global stop_calc

set stop_calc 0
if [string match {*left*} $s] {
set s "left"
set o "right"
} {
set s "right"
set o "left"
}
set xf(selekted$s) [$xf(fuf).${s}list curselection]
set xf(selsum$s) 0
if {[string compare {} $xf(selekted$s)] == 0} {
DefaultInfo xf $s
return
}
foreach f $xf(selekted$s) {
if $stop_calc {
NullSelect xf $s
DefaultInfo xf $s
return
}
set size [GetFileSize $s $f]
set xf(selsum$s) [expr $xf(selsum$s) + $size]
update idletasks
}
CorrectColor $o xf {} {}
ShowSelSize $s
SetArrowPointer
}

proc AddSelSize {s ind mark} {
global xf
set xf(selsum$s) [expr $xf(selsum$s) $mark [GetFileSize $s $ind]]
}

proc ShowSelSize {s} {
global xf
InfoChange xf $s "Selected [llength [$xf(fuf).${s}list curselection]]\
objects: [FormatNumber [expr $xf(selsum$s)/1024]]kb"
}
proc BindReturn {arr s} {
upvar $arr xf
SetWaitPointer
set f [TildeSubst $xf(pathi$s) $s]
FileOK xf $s $f {}
catch {unset xf(no_aud)}
focus $xf(fuf).${s}list
after idle [list InsertToLog $s "CWD: $f" 2]
SetArrowPointer
}
proc FileEntries {arr parent args } {
upvar $arr xf
global menu xf_image
frame $parent.left
frame $parent.middle
frame $parent.right

button $parent.left.dirup -text .. -padx 1 -pady 0 -command {dirUp xf "left"}
button $parent.left.dirroot -text / -padx 3 -pady 0 -command {dirRoot xf "left"}
menubutton $parent.left.dirHistory -padx 0 -pady 0 -relief raised \
-menu $parent.left.dirHistory.menu -image $xf_image(menuimage)

button $parent.right.dirup -text .. -padx 1 -pady 0 -command {dirUp xf "right"}
button $parent.right.dirroot -text / -padx 3 -pady 0 \
-command {dirRoot xf "right"}
menubutton $parent.right.dirHistory -padx 0 -pady 0 -relief raised \
-menu $parent.right.dirHistory.menu -image $xf_image(menuimage)

pack $parent.left.dirroot $parent.left.dirup $parent.left.dirHistory \
-side left
pack $parent.right.dirroot $parent.right.dirup -side right

set xf(ml) [menu $parent.left.dirHistory.menu -tearoff 0]
set xf(mr) [menu $parent.right.dirHistory.menu -tearoff 0]
frame $parent.leftd -width 60 -height 20
frame $parent.rightd -width 60 -height 20
pack propagate $parent.leftd 0
pack propagate $parent.rightd 0
set e_left [eval {entry $parent.leftd.e  \
-textvariable xf(pathileft) } $args]
set e_right [eval {entry $parent.rightd.e \
-textvariable xf(pathiright)} $args]

pack $parent.leftd.e -side left -expand true -fill x
pack $parent.rightd.e -side right -expand true -fill x
pack $parent.right.dirHistory -side right
set xf(pathEnt_left) $e_left
set xf(pathEnt_right) $e_right
checkbutton $parent.middle.hideleft -text H -padx 2 -pady 1 \
-variable xf(hiddens_left)\
-indicatoron false -command [list HiddenMode "left"] \
-selectcolor palevioletred1

button $parent.middle.all_left -text A -padx 1 -pady 0 \
-command {SelectAll xf "left"}
button $parent.middle.no_left -text N -padx 1 -pady 0 \
-command {UnselectAll xf "left";DefaultInfo xf "left"}
button $parent.middle.copyleft -text << -padx 0 -pady 0 \
-command {Copyleft xf "left"} -cursor left_side
button $parent.middle.swap -text <> -padx 0 -pady 0 -command {Swap_sides xf} -cursor exchange
button $parent.middle.copyright -text >> -padx 0 -pady 0 \
-command {CopyRight xf "right"} -cursor right_side
button $parent.middle.all_right -text A -padx 1 -pady 0 \
-command {SelectAll xf "right"}
button $parent.middle.no_right -text N -padx 1 -pady 0 \
-command {UnselectAll xf "right";DefaultInfo xf "right"}
checkbutton $parent.middle.hideright -text H -padx 2 -pady 1 \
-variable xf(hiddens_right) \
-indicatoron false -command [list HiddenMode "right"] \
-selectcolor palevioletred1

pack $parent.middle.hideleft $parent.middle.all_left \
$parent.middle.no_left $parent.middle.copyleft \
$parent.middle.swap $parent.middle.copyright \
$parent.middle.no_right $parent.middle.all_right \
$parent.middle.hideright \
-side left -anchor center
pack $parent.left -in $parent -side left -expand true -fill x
pack $parent.right -in $parent -side right -expand true -fill x
pack $parent.middle -in $parent -side top -expand true \
-fill y -anchor center

pack $parent.leftd -side left -fill both -expand true -after $parent.left.dirHistory
pack $parent.rightd -side right -fill both -expand true -after $parent.right.dirup
update idletasks
}
proc HiddenMode {s} {
global xf
SetWaitPointer
NullSelect xf $s
FileList $s $xf(pathi$s)
DefaultInfo xf $s
if $xf(hiddens_$s) {
set str "Show hidden files!"
} {
set str "Hide hidden files!"
}
after idle [list InsertToLog $s $str 2]
SetArrowPointer
}
proc History {arr s} {
upvar $arr xf
global menu

for {set i 0} {$i < 6} {incr i} {
if [string match $xf(backup_$s) $menu($i)] {
if {$i == 0} {
return
}

catch {$xf(ml) delete 0 end}
catch {$xf(mr) delete 0 end}

for {set a $i} {$a > 0} {incr a -1} {
set aa [expr $a-1]
set menu($a) $menu($aa)
}
set menu(0) $xf(backup_$s)
for {set a 0} {$a < 6} {incr a} {
if {$menu($a) != ""} {
$xf(ml) add command -label $menu($a) \
-command [list MenuDir "left" $menu($a)]
$xf(mr) add command -label $menu($a) \
-command [list MenuDir "right" $menu($a)]
}
}
return
}
}
catch {$xf(ml) delete 0 end}
catch {$xf(mr) delete 0 end}
for {set i 5} {$i > 0} {incr i -1} {
set ii [expr $i-1]
set menu($i) $menu($ii)
}
set menu(0) $xf(backup_$s)
for {set i 0} {$i < 6} {incr i} {
if {$menu($i) != ""} {
$xf(ml) add command -label $menu($i) \
-command [list MenuDir "left" $menu($i)]
$xf(mr) add command -label $menu($i) \
-command [list MenuDir "right" $menu($i)]
}
}
}
proc MenuDir {s dir} {
after idle [list InsertToLog $s "CWD: $dir" 2]
ChangeDir $s $dir
}
proc UpdateListbox {arr s {pos {}} {delay {}} {swap 0}} {
upvar $arr xf
global vdleft vdright vfleft vfright

if [string match $s left] {
set dirpit $vdleft(size)
set dirs vdleft
set files vfleft
set o "right"
} {
set dirpit $vdright(size)
set dirs vdright
set files vfright
set o "left"
}

if {$xf(fsmode_$s) == 0} {
$xf(fuf).${s}list config  -bg [option get $xf(fuf).${s}list background {}]
} {
$xf(fuf).${s}list config -bg #eeeece
}
if {!$swap} {set selfiles [GetSelNames $s]}
if {[string compare {} $pos] == 0} {
set pos [expr [lindex [$xf(fuf).${s}list yview] 0]+0.0001]
}
FileList $s $xf(pathi$s)
set def 0
if {[string compare {} $xf(selekted$s)] == 0} {
set def 1
} {
if {!$swap} {
set xf(selekted$s) {}
set xf(selsum$s) 0
foreach f $selfiles {
if [string match {*/} $f] {
for {set i 1} {$i < $dirpit} {incr i} {
if [catch {set name [set ${dirs}($i.name)][set ${dirs}($i.ext)]}] {continue}
if {[string compare $f $name] == 0} {
lappend xf(selekted$s) $i
set xf(selsum$s) [expr $xf(selsum$s)+[GetFileSize $s $i]]
}
}
} {
for {set i 0} {$i < [set ${files}(size)]} {incr i} {
if [catch {set name [set ${files}($i.name)][set ${files}($i.ext)]}] {continue}
if {[string compare $f $name] == 0} {
set ind [expr $i+$dirpit]
lappend xf(selekted$s) $ind
set xf(selsum$s) [expr $xf(selsum$s)+[GetFileSize $s $ind]]
}
}
}
}
}
foreach i $xf(selekted$s) {
$xf(fuf).${s}list select set $i
}
CorrectColor $o xf {} {}
if {[string compare {} $xf(selekted$s)] != 0} {
if [string compare {} $delay] {
after $delay [list ShowSelSize $s]
} {
ShowSelSize $s
}
} {
set def 1
}
}
if $def {
if {[string compare {} $delay]} {
after $delay [list DefaultInfo xf $s]
} {
DefaultInfo xf $s
}
}
$xf(fuf).${s}list yview moveto $pos
catch {set xf(${s}autoud) [file mtime $xf(pathi$s)]}
}
proc SelectAll {arr s} {
upvar $arr xf

SetWaitPointer
InfoChange xf $s "Calculating..."
$xf(fuf).${s}list select set 0 end
if {[$xf(fuf).${s}list selection includes 0] && \
[string match {\.\.*} [$xf(fuf).${s}list get 0]]} {
$xf(fuf).${s}list selection clear 0
}
after idle [list InsertToLog $s "Selected all items" 2]
after idle [list SelectionSize xf $s]
}
proc UnselectAll {arr s} {
upvar $arr xf

$xf(fuf).${s}list selection clear 0 [$xf(fuf).${s}list index end]
$xf(fuf).${s}list config -selectbackground [option get .xfiles selectBg_$s {}]
update idletasks
NullSelect xf $s
after idle [list InsertToLog $s "Cleared all selections" 2]
}

proc NullSelect {arr s} {
upvar $arr xf
set xf(selekted$s) {}
set xf(selsum$s) 0
}
proc NoSelect {s} {
global xf
SetArrowPointer
set xf(mb) 1
InfoChange xf $s "No files selected!"
bell
after 4000 [list DefaultInfo xf $s]
}
proc CopyVars {afrom ato sfrom sto} {
upvar $ato result $afrom array
foreach i [list pathi backup_ parent_ selsum hiddens_ fsmode_ devicefree] {
set result(${i}$sto) $array(${i}$sfrom)
}
}
proc Copyleft {arr s} {
upvar $arr xf

History xf "left"
set pos [expr [lindex [$xf(fuf).rightlist yview] 0]+0.0001]

CopyVars xf xf "right" "left"
set xf(selektedleft) $xf(selektedright)
CorrectColor "left" xf {} {}
UpdateListbox xf "left" $pos {} 1
LogBoth "Right listing copied to the left." 2
}
proc Swap_sides {arr} {
upvar $arr xf

set temp(?) ?
CopyVars xf temp "right" ""
CopyVars xf xf "left" "right"
CopyVars temp xf "" "left"
unset temp

set selekt $xf(selektedright)
set xf(selektedright) $xf(selektedleft)
set xf(selektedleft) $selekt

if [string match [lindex [.ff.top.middle.hideright config -state] end] disabled] {
.ff.top.middle.hideright config -state normal
.ff.top.right.dirHistory config -state normal
.ff.top.middle.hideleft config -state disabled
.ff.top.left.dirHistory config -state disabled
} elseif [string match [lindex [.ff.top.middle.hideleft config -state] end] disabled] {
.ff.top.middle.hideleft config -state normal
.ff.top.left.dirHistory config -state normal
.ff.top.middle.hideright config -state disabled
.ff.top.right.dirHistory config -state disabled
}
set posr [expr [lindex [$xf(fuf).rightlist yview] 0]+0.0001]
set posl [expr [lindex [$xf(fuf).leftlist yview] 0]+0.0001]

UpdateListbox xf "left" $posr {} 1
UpdateListbox xf "right" $posl {} 1
LogBoth "Listings swapped." 2
}
proc CopyRight {arr s} {
upvar $arr xf

History xf "right"
set pos [expr [lindex [$xf(fuf).leftlist yview] 0]+0.0001]

CopyVars xf xf "left" "right"
set xf(selektedright) $xf(selektedleft)
CorrectColor "right" xf {} {}
UpdateListbox xf "right" $pos {} 1
LogBoth "Left listing copied to the right." 2
}
proc dirUp {arr s} {
upvar $arr xf
global stop_calc

set stop_calc 1
if {$xf(fsmode_$s) == 0} {
if [string match $xf(pathi$s) $xf(parent_$s)] {
return
}
History xf $s
} {
if [string match $xf(pathi$s) /] {
AfterVirtual xf $s
FileList $s $xf(pathi$s)
DefaultInfo xf $s
return
}
}
$xf(fuf).${s}list config \
-selectbackground [option get .xfiles selectBg_$s {}]
SetPaths xf $s $xf(parent_$s)
NullSelect xf $s
FileList $s $xf(pathi$s)
if {[string match $xf(pathi$s) /] || [string compare {} $xf(selekted$s)]} {
DefaultInfo xf $s
}
}
proc dirRoot {arr s} {
upvar $arr xf
global stop_calc

set stop_calc 1
if {[string match $xf(pathi$s) $xf(parent_$s)] \
&& $xf(smode_$s) == 0} {
return
}
if [string match $xf(fsmode_$s) 0] {
History xf $s
}
SetPaths xf $s /
$xf(fuf).${s}list config \
-selectbackground [option get .xfiles selectBg_$s {}]
NullSelect xf $s
FileList $s $xf(pathi$s)
DefaultInfo xf $s
}
proc FileFrame {arr parent s args} {
upvar $arr xf
if { [string compare $s "left"] == 0 } {
set o "right"
} {
set o "left"
}
frame $parent.$s
eval {listbox $parent.${s}list -yscrollcommand \
[list $parent.$s.sy set]} $args
scrollbar $parent.$s.sy -orient vertical -command \
[list $parent.${s}list yview] -relief ridge
pack $parent.$s.sy -side $o -fill y
pack $parent.${s}list -in $parent.$s -side $s -expand true -fill both
set popup [menu $parent.${s}list.popup_menu -tearoff 0 \
-relief ridge -bd 4 -bg grey80]
$popup add command -label "Copy" -command [list PopupOps xf $s "cp"]
$popup add command -label "Move" -command [list PopupOps xf $s "mv"]
$popup add separator
$popup add cascade -label "Delete" -menu $popup.sub
set popup.sub [menu $popup.sub -tearoff 0]
$popup.sub add command -label "Yes!" -command [list PopupOps xf $s "rm"]\
-activebackground "#ff0000" -background "#ffa0a0"
set flag 1
set a 1
while {[string compare {} [option get .xfiles popup_user_item_$a {}]]} {
set xf(popup_user$a) [option get .xfiles popup_user_item_$a {}]
if $flag {
set popup.user [menu $popup.user -tearoff 0]
$popup add separator
$popup add cascade -label "User" -menu $popup.user \
-font [option get .ff.files.${s}list.popup_menu.user font {}]
set flag 0
}
$popup.user add command -label [lindex $xf(popup_user$a) 0] \
-command [list PopupOps xf $s "$a" [lindex $xf(popup_user$a) 1]]
unset xf(popup_user$a)
incr a
}
}
proc PopupOps {arr s op {command {}}} {
upvar $arr xf

switch $op {
cp -
mv -
rm {
if {[string compare {} $xf(selekted$s)] == 0} {
NoSelect $s
return
} {
FileOps $op $s
}
}
default {
Executer xf [lrange $command 0 end] [GetSelNames $s] $s "\[Pop-menu\]"
}
}
if {$xf(clearselect) == 1} {
UnselectAll xf $s
update idletasks
set xf(clearselect) 0
}
}
proc FileInfo {arr parent args} {
upvar $arr xf

set xf(infoEnt_left) [entry $parent.infoleft -relief sunken -bd 2\
-textvariable xf(infoAleft) -state disabled -justify left\
-bg "#404040" -fg "#ffff60" -highlightthickness 0 \
-exportselection 0 -cursor top_left_arrow \
-font [option get $xf(fuf).leftlist font {}]]
set xf(infoEnt_right) [entry $parent.inforight -relief sunken -bd 2\
-textvariable xf(infoAright) -state disabled -justify left \
-bg "#404040"  -fg "#ffff60" -highlightthickness 0 \
-exportselection 0  -cursor top_left_arrow \
-font [option get $xf(fuf).leftlist font {}]]

button $parent.logl -text Log... -padx 1 -pady 0 \
-command [list ShowLog "left"] -bd 0 \
-bg "#404040" -fg "#ffff60" -activebackground "#404040"\
-activeforeground "#ffff60" -font *times*6* \
-highlightthickness 0
button $parent.logr -text Log... -padx 1 -pady 0 \
-command [list ShowLog "right"] -bd 0 \
-bg "#404040" -fg "#ffff60" -activebackground "#404040"\
-activeforeground "#ffff60" -font *times*6* \
-highlightthickness 0
bindtags $parent.logl [list XF $parent.logl Button . all]
bindtags $parent.logr [list XF $parent.logr Button . all]
if {$xf(log) == 1} {
pack $parent.logl -side left
pack $parent.logr -side right
}
pack $parent.infoleft -side left -expand true -fill x
pack $parent.inforight -side right -expand true -fill x
}

proc FileList {s dir} {
global xf vfs vdleft vdright vfleft vfright

if {$xf(redraw$s) == 0} {
catch {unset vd$s vf$s}
set vd${s}(0.name) ..
set vd${s}(0.ext) /
set vd${s}(0.size) {}
set vd${s}(0.mode) {}
set vd${s}(0.link) {}
set vd${s}(size) 1
set vf${s}(size) 0
set xf(smode_$s) 0
set if 0
switch $xf(fsmode_$s) {
0 {
$xf(pathEnt_$s) config -state normal -relief sunken
$xf(fuf).${s}list config  -bg [option get $xf(fuf).${s}list background {}]

if {![file executable $dir] || ![file readable $dir]} {
SetArrowPointer
$xf(fuf).${s}list delete 0 end
$xf(fuf).${s}list insert 0 ../
set vd${s}(size) 1
$xf(pathEnt_$s) xview moveto 1
$xf(pathEnt_$s) icursor end
DefaultInfo xf $s
MessageBox "You have no permissions here!" $s
return
}

if {[string compare $dir /] != 0} {set id 1} {set id 0}
if {!$xf(hiddens_$s)} {
set files [lsort [glob -nocomplain -- $dir*]]
} {
set files [lsort [glob -nocomplain -- $dir{.*,*}]]
}

foreach f $files {
regsub {^~} [file tail $f] \.\/\~ tail
regsub {^\.\/\~} [file rootname $tail] \~ name
if [string match directory [set t [file type $f]]] {
if {[string compare "\." $tail] != 0 && \
[string compare "\.\." $tail] != 0} {
set vd${s}($id.name) $name
set vd${s}($id.ext) [file extension $tail]/
set vd${s}($id.size) "<Dir>"
if $xf(bitsi) {
set vd${s}($id.mode) [BitsProc $f]
}
incr id
}
} {
if $xf(bitsi) {
set vf${s}($if.mode) [BitsProc $f]
}
set vf${s}($if.name) $name
set vf${s}($if.ext) [file extension $tail]
set vf${s}($if.link) {}
switch $t {
file {
set vf${s}($if.size) [file size $f]
}
link {
if [catch {set vf${s}($if.size) [string length [file readlink $f]]}] {
set vf${s}($if.size) [string length $f]
}
if $xf(links) {
if [catch {set vf${s}($if.link) " -> [file readlink $f]"}] {
set vf${s}($if.link) @
}
} {
set vf${s}($if.link) @
}
}
characterSpecial -
blockSpecial {
set vf${s}($if.size) "-Dev-"
}
default {
set vf${s}($if.size) [file size $f]
}
}
incr if
}
}
}
1 -
2 -
3 {
$xf(pathEnt_$s) config -state disabled -relief flat

set id 1
foreach d [lsort $vfs(${dir}dirs)] {
regsub {^~} [lindex $d 0] \.\/\~ tail
regsub {^\.\/\~} [file rootname $tail] \~ name
set vd${s}($id.name) $name
set vd${s}($id.ext) [file extension $tail]
set vd${s}($id.size) "<Dir>"
set vd${s}($id.link) ""
if $xf(bitsi) {
set vd${s}($id.mode) [lindex $d 1]
}
incr id
}
foreach row [lsort $vfs($dir)] {
regsub {^~} [lindex $row 0] \.\/\~ tail
regsub {^\.\/\~} [file rootname $tail] \~ name
set vf${s}($if.name) $name
set vf${s}($if.ext) [file extension $tail]
set vf${s}($if.size) [lindex $row 1]
set vf${s}($if.link) ""
if $xf(bitsi) {
set vf${s}($if.mode) [lindex $row 2]
}
incr if
}
}
}
set vd${s}(size) $id
set vf${s}(size) $if
$xf(pathEnt_$s) delete 0 end
$xf(pathEnt_$s) insert 0 $dir
$xf(pathEnt_$s) xview moveto 1
$xf(pathEnt_$s) icursor end
if {$xf(extsort) == 1} {
set tmp {}
for {set a 0} {$a < [set vf${s}(size)]} {incr a} {
lappend tmp [list [set vf${s}($a.ext)] [set vf${s}($a.name)] $a]
}
set exts [lsort -command ExtCompare $tmp]
set a 0
foreach i $exts {
set new($a.name) [set vf${s}([lindex $i 2].name)]
set new($a.size) [set vf${s}([lindex $i 2].size)]
set new($a.ext) [set vf${s}([lindex $i 2].ext)]
set new($a.link) [set vf${s}([lindex $i 2].link)]
if $xf(bitsi) {
set new($a.mode) [set vf${s}([lindex $i 2].mode)]
}
incr a
}
for {set a 0} {$a < [set vf${s}(size)]} {incr a} {
set vf${s}($a.name) $new($a.name)
set vf${s}($a.ext) $new($a.ext)
set vf${s}($a.size) $new($a.size)
set vf${s}($a.link) $new($a.link)
if $xf(bitsi) {
set vf${s}($a.mode) $new($a.mode)
}
}
}
} {
set xf(redraw$s) 0
}
$xf(fuf).${s}list delete 0 end

if $xf(bitsi) {
set w [expr ([winfo width $xf(fuf).${s}list]/$xf(char_W))-23]
if [string match "left" $s] {
for {set a 0} {$a < $vdleft(size)} {incr a} {
LbInsert $s end $w [FormatFileName $w  $vdleft($a.name) $vdleft($a.ext)] $vdleft($a.size) $vdleft($a.mode)
}
for {set a 0} {$a < $vfleft(size)} {incr a} {
LbInsert $s end $w [FormatFileName $w $vfleft($a.name) $vfleft($a.ext)$vfleft($a.link)] $vfleft($a.size) $vfleft($a.mode)
}
} {
for {set a 0} {$a < $vdright(size)} {incr a} {
LbInsert $s end $w [FormatFileName $w $vdright($a.name) $vdright($a.ext)] $vdright($a.size) $vdright($a.mode)
}
for {set a 0} {$a < $vfright(size)} {incr a} {
LbInsert $s end $w [FormatFileName $w $vfright($a.name) $vfright($a.ext)$vfright($a.link)] $vfright($a.size) $vfright($a.mode)
}
}
} {
set w [expr ([winfo width $xf(fuf).${s}list]/$xf(char_W))-12]
if [string match "left" $s] {
for {set a 0} {$a < $vdleft(size)} {incr a} {
LbInsert $s end $w [FormatFileName $w  $vdleft($a.name) $vdleft($a.ext)] $vdleft($a.size)
}
for {set a 0} {$a < $vfleft(size)} {incr a} {
LbInsert $s end $w [FormatFileName $w $vfleft($a.name) $vfleft($a.ext)$vfleft($a.link)] $vfleft($a.size)
}
} {
for {set a 0} {$a < $vdright(size)} {incr a} {
LbInsert $s end $w [FormatFileName $w $vdright($a.name) $vdright($a.ext)] $vdright($a.size)
}
for {set a 0} {$a < $vfright(size)} {incr a} {
LbInsert $s end $w [FormatFileName $w $vfright($a.name) $vfright($a.ext)$vfright($a.link)] $vfright($a.size)
}
}
}
}
proc LbInsert {s p w name size {mode {}}} {
global xf
if {[string compare {} $mode] == 0} {
$xf(fuf).${s}list insert $p [format "%-${w}s %9s" $name $size]
} {
$xf(fuf).${s}list insert $p [format "%-${w}s %10s %9s" $name $mode $size]
}
}
proc ExtCompare {a b} {
set aext [lindex $a 0]
set bext [lindex $b 0]
set rc [string compare $aext $bext]
if {$rc != 0} {
return $rc
} {
return [string compare $a $b]
}
}
proc FormatFileName {w name ext} {
global xf
set n [string length $name]
set e [string length $ext]
if {[set of [expr $n+$e-$w]] > 0} {
if {$n-$of > $e} {
return [string range $name 0 [expr $n-$of-3]]..$ext
} elseif {$e-$of > $n} {
return $name..[string range $ext [expr $of+2] end]
} {
return [string range $name 0 [expr $n-($of/2)-2]]..[string range $ext [expr ($of/2)+2] $e]
}
}
return $name$ext
}
proc SetPaths {arr s path} {
upvar $arr xf

set xf(pathi$s) [TildeSubst $path $s]
set xf(backup_$s) $xf(pathi$s)
set xf(parent_$s) [GetParentDir $xf(pathi$s)]
after idle [list InsertToLog $s "CWD: $xf(pathi$s)" 2]
}

proc BitsProc {f} {
catch {file stat $f arr}
switch [file type $f] {
file { set d "-"}
directory {set d "d"}
link {
set d "l"
catch {file lstat $f arr}
}
characterSpecial {set d "c"}
blockSpecial {set d "b"}
socket {set d "s"}
fifo {set d "p"}
}
set m [expr [format "%o" $arr(mode)] % 1000]
for {set i 0} {$i < 3} {incr i} {
set c [string index $m $i]
switch $c {
7 {append d "rwx"}
6 {append d "rw-"}
5 {append d "r-x"}
4 {append d "r--"}
3 {append d "-wx"}
2 {append d "-w-"}
1 {append d "--x"}
0 {append d "---"}
}
}
return $d
}
proc Mount {s dev} {
global xf

if [catch {open /etc/fstab r} fstab] {
MessageBox "Unable to open file '/etc/fstab'"
return
}
set con [split [read $fstab] \n]
close $fstab
set ind [lsearch $con $dev*]
if {$ind == -1} {
MessageBox "There has to be a line \"$dev\t<mountpoint>\t<filesys>\tdefaults,exec,user 0 0\" in the file /etc/fstab" $s
return
}
cd /
catch {exec umount $dev} err
if [string match {*device is busy*} $err] {
MessageBox "Somebody is accessing $dev\nUnable to unmount..." $s
return
}
catch {exec mount $dev} err
if [string match {*not a valid block device*} $err] {
MessageBox "The device cannot be mounted! If floppy or cd-rom, please insert the disk and try again." $s
return
}
set dir [lindex [lindex $con $ind] 1]
History xf $s
SetPaths xf $s $dir/
NullSelect xf $s
FileList $s $xf(pathi$s)
DefaultInfo xf $s
}
proc FileOK {arr s f button} {
upvar $arr xf
global vfs stop_calc

if {[string compare $s "left"] == 0} {
set o "right"
} {
set o "left"
}

if {[string match $f $xf(backup_$s)] && \
[$xf(fuf).${s}list size] > 0 && \
$xf(smode_$s) == 0} {
set xf(pathi$s) $f
$xf(pathEnt_$s) xview moveto 1
$xf(pathEnt_$s) icursor end
return
}

if {[regexp {^\.\./?} $f]} {
dirUp xf $s
DefaultInfo xf $s
return
}

if [string match {/} $f] {
dirRoot xf $s
DefaultInfo xf $s
return
}
set pathway "$xf(pathi$s)$f"
if {$xf(fsmode_$s) == 0} {
if [file isdirectory $pathway] {
set stop_calc 1
$xf(fuf).${s}list config \
-selectbackground [option get .xfiles selectBg_$s {}]
History xf $s
NullSelect xf $s
SetPaths xf $s $pathway

FileList $s $xf(pathi$s)
DefaultInfo xf $s
return
} {
if [file exists $pathway] {
QuickExe xf $f $button $xf(pathi$o) $s
return
}
}
} {
if [string match */ $pathway] {
set stop_calc 1
$xf(fuf).${s}list config \
-selectbackground [option get .xfiles selectBg_$s {}]
SetPaths xf $s $pathway
NullSelect xf $s
FileList $s $xf(pathi$s)
DefaultInfo xf $s
return
} {
VirtualOutput xf $xf(fsmode_$s) $xf(virtualfile) \
[string trimleft $pathway /] $s
DefaultInfo xf $s
return
}
}
if [file isdirectory $f] {
set stop_calc 1
History xf $s
SetPaths xf $s $f
NullSelect xf $s

FileList $s $f
DefaultInfo xf $s
return
}
if [file exists [string trimright $f /]] {
SetPaths xf $s [GetParentDir $f]
NullSelect xf $s
FileList $s $xf(pathi$s)
DefaultInfo xf $s
QuickExe xf [file tail [file dirname $f]] $button $xf(pathi$o) $s
return
} {
set stop_calc 1
set xf(pathi$s) $xf(backup_$s)
$xf(pathEnt_$s) xview moveto 1
$xf(pathEnt_$s) icursor end
set xf(parent_$s) [GetParentDir $xf(pathi$s)]
FileList $s $xf(pathi$s)
InfoChange xf $s "Invalid path or filename!"
bell
after 4000 [list DefaultInfo xf $s]
return
}
}
proc FileClick {arr s y } {
upvar $arr xf

set l $xf(fuf).${s}list
$l selection clear [$l index [$l nearest $y]]
return [GetFileName $s [$l index [$l nearest $y]]]
}

proc GetFileName {s ind} {
global xf vdleft vdright vfleft vfright

if {$ind < [set vd${s}(size)]} {
return [set vd${s}($ind.name)][set vd${s}($ind.ext)]
} {
set ind [expr $ind-[set vd${s}(size)]]
return [set vf${s}($ind.name)][set vf${s}($ind.ext)]
}
}
proc GetFileSize {s ind} {
global xf vdleft vdright vfleft vfright

if {$ind < [set vd${s}(size)]} {
set tmp [set vd${s}($ind.size)]
} {
set ind [expr $ind-[set vd${s}(size)]]
set tmp [set vf${s}($ind.size)]
}
regexp {[0-9]*} $tmp size
if {[string compare {} $size] == 0} {
set size 1024
}
return $size
}
proc GetSelNames {s} {
global xf

set lnam {}
foreach i $xf(selekted$s) {
lappend lnam [GetFileName $s $i]
}
return $lnam
}
proc DefaultInfo {arr s} {
upvar $arr xf

if [string match $s "left"] {
set o "right"
} {
set o "left"
}

if {[string compare {} [$xf(fuf).${s}list curselection]] != 0} {
CorrectColor $o xf {} {}
ShowSelSize $s
return
}

switch $xf(fsmode_$s) {
1 -
2 {
$xf(infoEnt_$s) config -justify center -bg "#404040" -fg "#ffff60"
set xf(infoA$s) "In file: [string trimleft [file tail $xf(virtualfile)] \./]"
return
}
}
set xf(infoA$s) ""
$xf(infoEnt_$s) config -justify right -bg "#404040" -fg "#ffff60"

set fs [string match {*-T*} $xf(DISKFREE)]
set dfsize [ExecGetDfSize $xf(DISKFREE) $xf(pathi$s) fs $s]

if {$dfsize == -1} {
set xf(infoA$s) "Unable to obtain free space information!      "
set xf(devicefree$s) 99999999
} {
if {$xf(df_1k) == 0} {
set dfsize [expr $dfsize / 2]
}
set xf(devicefree$s) $dfsize
if {[string compare "msdos" $fs] == 0} {
set xf(mdos_$s) 1
} {
set xf(mdos_$s) 0
}
set w [expr ([winfo width $xf(fuf).${s}list]/$xf(char_W))-23]
set xf(infoA$s) [format "%-7s%${w}s%-11s" $fs [FormatNumber $xf(devicefree$s)] "kb free  "]
CorrectColor $s xf {} {}
}
catch {cd $xf(pathi$s)}
}
proc ExecGetDfSize {dfree path var s} {
upvar $var fs

if [catch {eval exec $dfree [list $path]} foo] {
if [catch {cd $path;set pwd [pwd]/}] {
set pwd $path
}
return [GetDiskFree $pwd $dfree fs $s]
} {
return [GetDFSize $foo fs]
}
}
proc GetDFSize {line var} {
upvar $var fs
global xf

if [string match {*HP*} [lindex $xf(uname) 0]] {
set df_l_ind 3
} {
set df_l_ind 2
}
if {$fs == 1} {
set fs [lindex $line [expr [llength $line] - 5 -1]]
} {
set fs ""
}
return [lindex $line [expr [llength $line] - $df_l_ind -1]]
}
proc GetDiskFree {path cmd var s} {
upvar $var fs

if [catch {eval exec $cmd} foo] {
set freespace -1
tkerror $err $s
} {
set lines [split $foo \n]
set freespace -1
if [string match Filesystem* [lindex $lines 0]] {
set a 1
set df_sz_ind end
set df_l_ind 2
} {
set a 0
set df_sz_ind 0
set df_l_ind 3
}
set l 0
for {set i $a} {$i < [llength $lines]} {incr i} {
set df [lindex $lines $i]
set try [lindex $df $df_sz_ind]
if {[string compare {} $try] == 0} {
continue
}
if [regexp ^($try) $path tmp] {
if {[string length $tmp] > $l} {
set l [string length $tmp]
set freespace [GetDFSize $df fs]
}
}
}
}
return $freespace
}
proc CorrectColor {s var index op} {
upvar $var xf

if [string match $s left] {
set o "right"
} {
set o "left"
}
if {$xf(selsum$o)/1024 > $xf(devicefree$s)} {
$xf(fuf).${o}list config -selectbackground red
} {
$xf(fuf).${o}list config \
-selectbackground [option get .xfiles selectBg_$o {}]
}

}
proc DialogWin {string {xoffset -50} {yoffset -50} {select 1} \
{X {}} {Y {}} {abort {}}} {
global prompt ret xf

set old_focus [focus]
set f .prompt
catch {destroy $f}
toplevel $f -borderwidth 5
if {[option get .xfiles messages_always_on_top {}] == 1} {
bind $f <Visibility> [list KeepOnTop $f %W %s]
}
wm title $f "X-Files Request"
if {[string compare {} $X] == 0} {
set x [expr [winfo pointerx .] + $xoffset]
set y [expr [winfo pointery .] + $yoffset]
} {
set x [expr $X + $xoffset]
set y [expr $Y + $yoffset]
}
wm geometry $f "+$x+$y"
wm resizable $f 0 0
wm protocol $f WM_DELETE_WINDOW {set ret 0}

frame $f.m -relief flat -bd 2
message $f.m.msg -width 150  -justify center -text $string
set b [frame $f.buttons -bd 3 -relief ridge]
pack $f.m.msg -side top -fill x
frame $f.m.fake
pack $f.buttons -side bottom -fill x
pack $f.m.fake -side bottom -fill x -ipady 5
pack $f.m -side top
set ind 1
while {[info exists prompt($ind.label)]} {
frame $f.m.$ind
entry $f.m.$ind.e -textvariable prompt($ind.result)
if [string compare {} $prompt($ind.label)] {
label $f.m.$ind.l -text $prompt($ind.label)
pack $f.m.$ind.l -side left
pack $f.m.$ind.e -side right -fill x
} {
pack $f.m.$ind.e -side top -fill x
}
pack $f.m.$ind -side top -fill x
$f.m.$ind.e xview moveto 1
$f.m.$ind.e icursor end
bind $f.m.$ind.e <Return> [list focus $f.m.[incr ind].e]
}
incr ind -1
bind $f.m.$ind.e <Return> {set ret 1}
bind $f <Control-c> {set ret 0}
bind $f <Escape> {set ret 0}
button $b.ok -width 6 -text OK -command {set ret 1}
button $b.cancel -width 6 -text Cancel -command {set ret 0}
pack $b.ok -side left -padx 10 -pady 4
if [string compare {} $abort] {
button $b.misc -width 6 -text $abort -command {set ret 2}
pack $b.misc -side right -pady 4
pack $b.cancel -side right -pady 4
} {
pack $b.cancel -side right -padx 10 -pady 4
}

tkwait visibility $f
KeepInScreen $f
grab $f
focus $f.m.1.e
if {$select && [string compare {} $prompt(1.result)]} {
$f.m.1.e select range 0 end
}
$f.m.1.e xview moveto 1
$f.m.1.e icursor end
tkwait variable ret
grab release $f
catch {destroy $f}
focus $old_focus
return $ret

}
proc GetCharValue { fid } {
set byte [read $fid 15]
set pit [string length $byte]
if {$pit > 0} {

for {set i 0} {$i < $pit } {incr i} {
scan [string index $byte $i] "%c" resu
append t $resu
}

if {$pit < 15} {
append t 0
if {[catch {seek $fid [expr $pit - 14] current}]} {
return -1
}
}
return $t
} {
if [eof $fid] {return -1} {return 0}
}
}
proc String2Integer {s} {
set pit [string length $s]
for {set i 0} {$i < $pit } {incr i} {
scan [string index $s $i] "%c" resu
append tulo $resu
}
return $tulo
}
proc QuickExe {arr f b d s} {
upvar $arr xf
set cont 1
set i "\[Extension\]"
set pid -1
SetWaitPointer
regexp (\[^.]*$) $f ext
set ext ${ext}$b
regsub {^~} $f \.\/\~ tail
set tmp [file rootname $tail]
while {1} {
regexp (\[^.]*$) $tmp tmpe
set tmp [file rootname $tmp]
if {[lsearch -exact [info globals *$tmpe.$ext*] $tmpe.$ext] < 0} {
break
}
set ext $tmpe.$ext
}
global $ext
if [catch {set tmp [set $ext]} eerror] {
if ![file readable "$xf(pathi$s)$f"] {
MessageBox "Could not complete operation. File is not readable." $s
NullSelect xf $s
DefaultInfo xf $s
return $pid
} {
if $xf(peekheader) {
if [catch {open "$xf(pathi$s)$f" RDONLY} fileId] {
bell;tkerror $fileId $s
SetArrowPointer
return $pid
} {
set cont 0
for {set i 0} {$i < 3} {incr i} {
append tmp3 [GetCharValue $fileId]
}
set i 0
global H header hcomm
while { $i < $H($b)} {
append header($b.$i) *
if { [string match $header($b.$i) $tmp3] } {
Executer xf $hcomm($b.$i) [list $f] $s "\[Header\]"
break
}
incr i
}
close $fileId
}

if {$i == $H($b)} {
global txt$b
set cont 1
set tmp txt$b
set tmp [set $tmp]
set i "\[NoMatch\]"

}
} {
global txt$b
set cont 1
set tmp txt$b
set tmp [set $tmp]
set i "\[NoHeader\]"
}
}
}
if {$cont} {
Executer xf $tmp [list $f] $s $i
}
SetArrowPointer
return $pid
}

proc Executer {arr co f s {info ""} {ot {}}} {
upvar $arr xf
global prompt
set both 0
if {$s == "left"} {
set d $xf(pathiright)
set c $xf(pathileft)
set o "right"
} {
set d $xf(pathileft)
set c $xf(pathiright)
set o "left"
}

set param [lindex $co 0]
if [regexp C $param] {
if ![AskWin {Are You Sure ?}] {
return -1
}
}
if [regexp %d $co] {
set both 1
}
if [string match {*%o1*} $co] {
set i 1
while {[set paikka [string first %o$i $co]] >= 0} {
set tmp3 [string range $co $paikka end]
set e [expr [string first ' $tmp3] -5]
regexp "%o$i'(.*)'" $tmp3 op op1
set op1 ${op1}'
set e [expr [string first %o$i $tmp3]+3]
set tmp3 [string range $tmp3 $e end]
set e [expr [string first ' $op1] -1]

set opt($i) [string range $op1 0 $e]
set tmp3 [string range $tmp3 $e end]
incr i
}
foreach a [array names opt] {
regsub $opt($a) $co {} co
set prompt($a.label) $opt($a)
}

if [DialogWin "Additional options"] {
foreach a [array names opt] {
if {[string compare {} $prompt($a.result)] == 0} {
regsub "%o$a''" $co {} co
continue
}
regsub -all { } $prompt($a.result) {\ } o$a
}
} {
InfoChange xf $s "Command aborted!"
after 4000 [list DefaultInfo xf $s]
unset prompt
return -1
}
unset prompt
regsub -all {''} $co \} co
regsub -all {%o} $co \$\{o co
} elseif [string match *%o* $co] {
MessageBox "You have \"%o\"-specifier when you should have \"%o\?\", where \? is a number starting from 1." $s
return
}
regsub -all {%} $co {$} co
set co [lreplace $co 0 0 ]
regsub -all { } $d {\ } d
set xf(clearselect) 1
if {[string compare {} $ot] != 0} {
set f ""
foreach d $xf(selekted$s) {
lappend f $xf(pathi$s)[GetFileName $s $d]
}
foreach d $xf(selekted$o) {
lappend f $xf(pathi$o)[GetFileName $o $d]
}
}
catch {cd $xf(pathi$s)}
update idletasks
set co [subst -nobackslashes $co]
switch -exact -- [lindex $co 0] {
exec {set ci [lindex $co 1]}
ChangeDir {set ci "[lindex $co 0 ] [lindex $co 2]"}
default {set ci [lindex $co 0]}
}
if {[catch {set pid [eval $co]} err]} {
if ![regexp Q $param] {
tkerror $err
} {
InfoChange xf $s "$info $ci: Quiet error!"
after 4000 [list DefaultInfo xf $s]
}
return -1
} {
if [regexp W $param] {
OutputWindow $pid [list $xf(pathi$s)] [lindex $f 0]
}
InfoChange xf $s "$info Executed: $ci"
if [string match $xf(pathileft) $xf(pathiright)] {
set both 1
}
if [regexp U $param] {
if $both {
after 100 [list UpdateListbox xf left]
after 100 [list UpdateListbox xf right {} 4000]
} {
after 100 [list UpdateListbox xf $s]
}
} {
after 4000 [list DefaultInfo xf $s]
}

return 1
SetArrowPointer
}
}
proc ButtonFrame { i s bfpath } {
global bargs xf bcomm bargs

frame $bfpath.bf($i) -height 30
set error 0
set refindex [expr $i*6]
if [catch {
for {set n 0} {$n <  $xf(button_cols)} {incr n} {
set realindex [expr $n+$refindex]
set realaction "BAction $realindex $s $bfpath $i $bfpath.bf($i).f($n).b($n)"
frame $bfpath.bf($i).f($n) -width 30 -height 30 -bd 0
if [catch {
eval { button $bfpath.bf($i).f($n).b($n) -comm $realaction\
-width 1 -highlightthicknes $xf(highlightthicknes) \
} $bargs($realindex)}] {
incr error 1
set bcomm($realindex) [list N MessageBox {Please, Configure me !}]
set bargs($realindex) ""
eval {
button $bfpath.bf($i).f($n).b($n) -relief flat -width 1\
-highlightthicknes $xf(highlightthicknes) \
-comm "BAction $realindex $s $bfpath $i $bfpath.bf($i).f($n).b($n)"
}
}
pack propagate $bfpath.bf($i).f($n) 0
pack $bfpath.bf($i).f($n).b($n) -expand true -fill both \
-side left
pack $bfpath.bf($i).f($n)  -expand true -fill both \
-side left
bind $bfpath.bf($i).f($n).b($n) <Button-2> "set xf(mb) 2 ; $bfpath.bf($i).f($n).b($n) invoke"
bind $bfpath.bf($i).f($n).b($n) <Button-3> "set xf(mb) 3 ; $bfpath.bf($i).f($n).b($n) invoke"
bindtags $bfpath.bf($i).f($n).b($n) [list XF $bfpath.bf($i).f($n).b($n) Button . all]
}
}  err] {tkerror $err $s; return -1}
if {$error != 0} {
MessageBox "$error invalid button(s) in Your xfiles.buttons -file! \n Use\
Button Editor to fix the problem!"
}
}

proc GetButtonIndex {w} {
regexp {(left|right).*\((.*)\).*\((.*)\).*\((.*)\)}\
$w nul side y x
return [expr $y * 6 + $x]
}
proc BAction { i side bfpath framenumber button} {
global bcomm be xf bargs beparent bindex prompt
if {$xf(editmode) > 0} {
set tmped $button
if {$be(editedi) == 2} {
set ret [AskWin "You have made changes! Edit another button and forget changes in this button ?" -100 -100 "Save"]
switch $ret {
0 { return}
2 {ApplyProc $bindex ; ButtonSave}
default {}
}
}
catch {BE_UnSetTrace}
if {!$xf(helpmode)} {
set xf(editbutton) $tmped
}
$beparent.menu.toolmenu.m entryconfigure Copy* -state normal
$beparent.menu.toolmenu.m entryconfigure "Copy Style" -state normal
regexp {(left|right).*\((.*)\).*\((.*)\).*\((.*)\)}\
$xf(editbutton) nul be(side) y x
unset nul be(side)
set bindex [expr $y * 6 + $x]

if {$xf(editmode) < 2} {
pack forget $beparent.menu.msg
set bcommtmp $bcomm($bindex)
set bargstmp $bargs($bindex)

set param [lindex $bcommtmp 0]

if [regexp C $param] {
set  be(confirm) C
} {
set  be(confirm) ""
}
if [regexp D $param] {
set  be(dialog) D
} {
set be(dialog) ""
}
if [regexp W $param] {
set be(win) W
} {
set be(win) ""
}
if [regexp U $param] {
set  be(update) U
} {
set be(update) ""
}
if [regexp Q $param] {
set  be(quiet) Q
} {
set be(quiet) ""
}
if {[string match {&} [lindex $bcommtmp end]]} {
set be(bg) "&" ; set bcommtmp [lreplace $bcommtmp end end]
} {
set be(bg) ""
}
pack  $beparent.menu.toolmenu -side left
pack $beparent.entframe -side top -fill y -fill x
pack $beparent.middle -fill x -pady 10 -padx 3
$beparent.entframe.up.2.cmdentry delete 0 end
update idletasks
switch -glob -- [lindex $bcommtmp 1] {
ChangeDir {
set be(cmd) [lrange $bcommtmp 1 2]
set be(cmdarg) [lindex $bcommtmp 3]
}
Mount {
set be(cmd) [lrange $bcommtmp 1 2]
set be(cmdarg) [lindex $bcommtmp 3]
}
exec {
set be(cmd) [lindex $bcommtmp 1]
set be(cmdarg) [lrange $bcommtmp 2 end]
}
MessageBox {
set be(cmd) exec
set be(cmdarg) ""
set be(txt) ""
$beparent.entframe.up.3.button config -text ""
}
default {
set be(cmd) [lrange $bcommtmp 1 end]
set be(cmdarg) ""
}
}
$beparent.entframe.up.2.cmdentry icursor end
set be(style) $bargstmp
set be(undoargs) $bargstmp
set be(undocomm) $bcommtmp
switch -glob -- $be(cmd) {
ChangeDir* { set be(cmdtxt) ChangeDir ;\
pack $beparent.entframe.up.2.cmdentry -side bottom ;\
pack forget  $beparent.entframe.up.2.bg}
FileOps*cp* { set be(cmdtxt) Copy ;\
pack forget $beparent.entframe.up.2.cmdentry ;\
pack forget  $beparent.entframe.up.2.bg}
CopyAs* { set be(cmdtxt) CopyAs ;\
pack forget $beparent.entframe.up.2.cmdentry ;\
pack forget  $beparent.entframe.up.2.bg}
FileOps*rm* { set be(cmdtxt) Delete ;\
pack forget $beparent.entframe.up.2.cmdentry ;\
pack forget  $beparent.entframe.up.2.bg}
*DirSize* { set be(cmdtxt) DirSize ;\
pack forget $beparent.entframe.up.2.cmdentry ;\
pack forget  $beparent.entframe.up.2.bg}
Mount* { set be(cmdtxt) Mount ;\
pack $beparent.entframe.up.2.cmdentry -side bottom ;\
pack forget  $beparent.entframe.up.2.bg}
Grep* { set be(cmdtxt) Grep ;\
pack forget $beparent.entframe.up.2.cmdentry ;\
pack forget  $beparent.entframe.up.2.bg}
exec { set be(cmdtxt) Execute ;\
pack $beparent.entframe.up.2.cmdentry -side bottom;\
pack $beparent.entframe.up.2.bg -side top -anchor nw}
MkDir*  { set be(cmdtxt) MakeDir ;\
pack forget $beparent.entframe.up.2.cmdentry ;\
pack forget  $beparent.entframe.up.2.bg}
FileOps*mv* { set be(cmdtxt) Move ;\
pack forget $beparent.entframe.up.2.cmdentry ;\
pack forget  $beparent.entframe.up.2.bg}
PatternSel*  { set be(cmdtxt) PatternSel ;\
pack forget $beparent.entframe.up.2.cmdentry ;\
pack forget  $beparent.entframe.up.2.bg}
ProtEdit*  { set be(cmdtxt) ProtEdit ;\
pack forget $beparent.entframe.up.2.cmdentry ;\
pack forget  $beparent.entframe.up.2.bg}
ReadFiles*  { set be(cmdtxt) ReadFiles ;\
pack forget $beparent.entframe.up.2.cmdentry ;\
pack forget  $beparent.entframe.up.2.bg}
Rename*  { set be(cmdtxt) Rename ;\
pack forget $beparent.entframe.up.2.cmdentry ;\
pack forget  $beparent.entframe.up.2.bg}
VirtualLha*  { set be(cmdtxt) VirtualLha ;\
pack forget $beparent.entframe.up.2.cmdentry ;\
pack forget  $beparent.entframe.up.2.bg}
VirtualTar*  { set be(cmdtxt) VirtualTar ;\
pack forget $beparent.entframe.up.2.cmdentry ;\
pack forget  $beparent.entframe.up.2.bg}
VirtualZip*  { set be(cmdtxt) VirtualZip ;\
pack forget $beparent.entframe.up.2.cmdentry ;\
pack forget  $beparent.entframe.up.2.bg}
default { set be(cmdtxt) Execute ;\
pack $beparent.entframe.up.2.cmdentry -side bottom;\
pack $beparent.entframe.up.2.bg -side top -anchor nw}
}

foreach arg {-relief -bd -fg -bg -activebackground -activeforeground\
-font} {
SetButtonStyle "$arg" [$xf(editbutton) cget "$arg"]
}
SetScale
set be(bd) [$xf(editbutton) cget {-bd}]
set be(txt) [$xf(editbutton) cget {-text}]
$beparent.entframe.up.1.txtentry icursor end
set be(relief) [$xf(editbutton) cget {-relief}]
set be(cursor) [$xf(editbutton) cget {-cursor}]
$beparent.bottom.undo config -state normal
$beparent.bottom.save config -state normal
$beparent.bottom.applyframe.apply config -state normal
update idletasks
if {$be(cursor) == ""} {
set be(cursor) "Default"
}
catch {eval {$beparent.entframe.up.3.button config} $be(style)}
BE_SetTrace
if [winfo exists .write_help] {
WriteHelp_Get .write_help
}
}
return 0
} {

if {$xf(helpmode) == "1" } {
HelpInfo_Conf $bfpath $bcomm($i) $i $framenumber
} {
SetWaitPointer
if { $side == "L"} {
set s "left"
set o "right"
} {
set s "right"
set o "left"
}
switch $xf(mb) {
1 {set selekted $xf(selekted$s)}
2 {lappend selekted $xf(selekted$s) $xf(selekted$o)}
3 {set selekted $xf(selekted$o)}
}
set f_ops 0
set none 0
if {[string match *FileOps* $bcomm($i)] \
|| [string match *Rename* $bcomm($i)] \
|| [string match *CopyAs* $bcomm($i)] \
|| [string match *ProtEdit* $bcomm($i)] \
|| [string match *Virtual* $bcomm($i)] \
|| [string match *DirSize* $bcomm($i)]} {
set f_ops 1
if {[string compare {} $selekted] == 0} {
set none 1
}
}
unset selekted
switch $xf(mb) {
1 {
if {$xf(fsmode_$s) > 0 && ![string match *PatternSel* $bcomm($i)]} {
if ![string match *FileOps* $bcomm($i)] {
MessageBox "This does not work with Virtual Filesystem!" $s
return
}
}
if $none {NoSelect $s;return}
Executer xf $bcomm($i) [GetSelNames $s] $s "\[A_Button\]"
}
2 {
if {$xf(fsmode_$s) || $xf(fsmode_$o)} {
MessageBox "Middle mousebutton does not work while using Virtual Filesystem!" $s
set xf(mb) 1
return
}
if $none {NoSelect $s;return}
if $f_ops {
Executer xf $bcomm($i) [GetSelNames $s] $s "\[A_Button\]"
Executer xf $bcomm($i) [GetSelNames $o] $o "\[A_Button\]"
} {
Executer xf $bcomm($i) {} $s "\[A_Button\]" $o
}
}

3 {
if {$xf(fsmode_$o) > 0 && ![string match *PatternSel* $bcomm($i)]} {
if ![string match *FileOps* $bcomm($i)] {
MessageBox "This does not work with Virtual Filesystem!" $s
set xf(mb) 1
return
}
}
if $none {NoSelect $s;return}
Executer xf $bcomm($i) [GetSelNames $o] $o "\[A_Button\]"
}
}
if {$xf(clearselect) == 1} {
switch $xf(mb) {
1 {UnselectAll xf $s}
2 {UnselectAll xf left; UnselectAll xf right; DefaultInfo xf $o}
3 {UnselectAll xf $o}
}
update idletasks
set xf(clearselect) 0
}
set xf(mb) 1
SetArrowPointer
return 1
}
}
}
proc KeepOnTop {w W s} {
global xf

if {[string match $w $W] \
&& [string compare $s VisibilityUnobscured]} {
raise $W
update idletasks
}
}
proc KeepInScreen {w} {
regexp {^([^x]*)x([^\+]*)\+([^\+]*)\+(.*)} [wm geometry $w] all ww wh wx wy
set pw [winfo screenwidth $w]
set ph [winfo screenheight $w]
set xt [expr ($wx+$ww) - $pw]
if {$xt > 0} {
set x [expr $wx-$xt]
set ux 1
} elseif {$wx < 0} {
set x 0
set ux 1
} else {
set x $wx
set ux 0
}
set yt [expr ($wy+$wh) - $ph]
if {$yt > 0} {
set y [expr $wy-$yt]
set uy 1
} elseif {$wy < 20} {
set y 20
set uy 1
} else {
set y $wy
set uy 0
}
if {$ux || $uy} {
wm geometry $w "+$x+$y"
update idletasks
}
}

proc MessageBox {string {s {}} {xoffset -50} {yoffset -50} {X {}} {Y {}} {width {200}} {font {}}} {
global xf res

catch {destroy .messages}
SetArrowPointer
set f [toplevel .messages -borderwidth 5]
if {[option get .xfiles messages_always_on_top {}] == 1} {
bind $f <Visibility> [list KeepOnTop $f %W %s]
}
if {[string compare {} $X] == 0} {
set x [expr [winfo pointerx .] + $xoffset]
set y [expr [winfo pointery .] + $yoffset]
} {
set x [expr $X + $xoffset]
set y [expr $Y + $yoffset]
}
wm geometry $f "+$x+$y"
wm title $f "X-Files Message"
wm resizable $f 0 0
wm protocol $f WM_DELETE_WINDOW {set res 0}

frame $f.mf -relief sunken -bd 2 -bg "#cacaca"
message $f.mf.msg -width $width  -justify left -text $string
if [string compare $font {}] {
$f.mf.msg config -font $font
}

label $f.mf.pic -bitmap info
set b [frame $f.buttons -bd 10]
pack $f.mf.pic -side left -padx 10
pack $f.mf.msg -side right
pack $f.mf -fill both
pack $f.buttons -side bottom -fill x

bind $f <Return> {set res 1}
bind $f <Control-c> {set res 0}
bind $f <Escape> {set res 0}
button $b.ok -text OK -command {set res 1}
pack $b.ok -side top

focus $b.ok
tkwait visibility $f
KeepInScreen $f
grab $f
tkwait variable res
grab release $f
if {[string match $string {*xternal comm}] != 0} {
if {[string compare {} $s] == 0} {
LogBoth $string 0
} {
after idle [list InsertToLog $s $string 0]
}
}
catch {destroy $f}
}
proc AskWin { string {xoffset -50} {yoffset -50}\
{text {}} {X {}} {Y {}} } {

global ret xf
set f [toplevel .prompt -borderwidth 5]
if {[option get .xfiles messages_always_on_top {}] == 1} {
bind $f <Visibility> [list KeepOnTop $f %W %s]
}
if {[string compare {} $X] == 0} {
set x [expr [winfo pointerx .] + $xoffset]
set y [expr [winfo pointery .] + $yoffset]
} {
set x [expr $X + $xoffset]
set y [expr $Y + $yoffset]
}
wm geometry $f "+$x+$y"
wm title $f "Query"
wm resizable $f 0 0
wm protocol $f WM_DELETE_WINDOW {set res 0}

set b [frame $f.buttons -bd 10]
set mf [frame $f.messages -relief sunken -bd 2]
label $mf.pic -bitmap question
message $mf.msg -width 110  -justify left -text $string \
-font *helvetica-bold-r-*-*-14*

pack $mf.pic $mf.msg -side left -pady 5 -padx 5

pack $f.messages $f.buttons -side top -fill x -expand true

bind $f <Control-c> {set ret  0}
bind $f <Escape> {set ret  0}
button $b.ok -width 6 -text OK -command {set ret 1}
button $b.cancel -width 6 -text Cancel -command {set ret 0}
pack $b.ok -side left
pack $b.cancel -side right
if [string compare {} $text] {
button $b.misc -width 6 -text $text -command {set ret 2}
pack $b.misc -side right
}

tkwait visibility $f
KeepInScreen $f
grab $f
focus $b.cancel
tkwait variable ret
grab release $f
catch {destroy $f}
return $ret
}
proc ChangeDir { s dirname } {
global xf

if ![file isdirectory $dirname] {
MessageBox "This button has an invalid path. Use the \"Config / Edit buttons...\" to fix the problem!" $s
return
}

History xf $s
SetPaths xf $s $dirname
NullSelect xf $s

$xf(fuf).${s}list config \
-selectbackground [option get .xfiles selectBg_$s {}]
FileList $s $xf(pathi$s)
DefaultInfo xf $s
}
proc ChkDosNames {files to_mdos} {
global xf

set rc 0
if {$to_mdos == 1} {
foreach f $files {
if {[string length [file extension $f]] > 4 || \
[string length [file rootname $f]] > 8} {
set rc 1
break
}
}
}
return $rc
}
proc SuggestDosName {f} {
regsub {\.} [string range [file rootname $f] 0 7] _ root
regsub {\.} [string range [file extension $f] 1 3] _ ext
return $root.$ext
}

proc FileOps { operation s } {
global xf vfs

if {[string compare $s left] == 0} {
set o "right"
} {
set o "left"
}

SetWaitPointer
switch $operation {
cp { set op "Copying" }
rm { set op "Deleting" }
mv { set op "Moving" }
}

set rc 0
set files [GetSelNames $s]
switch  $xf(fsmode_$s) {
0 {
cd $xf(pathi$s)
if $xf(turbomode) {
set rc [FO_Nor_Turbo xf $s $o $files $xf(selekted$s) \
$xf(fuf).${s}list $operation $op]
} {
set rc [FO_Nor_Noturbo xf $s $o $files $xf(selekted$s) \
$xf(fuf).${s}list $operation $op]
}
}
1 {
set rc [FO_Zip $s $o $files $operation $op]
}
2 {
set rc [FO_Tar $s $o $files $operation $op]
}
3 {
set rc [FO_Lha $s $o $files $operation $op]
}
}

if !$xf(turbomode) {
if !$rc {UnselectAll xf $s} {SelectionSize xf $s}
} {
UnselectAll xf $s
}
switch $operation {
mv {
UpdateListbox xf $s
UpdateListbox xf $o
}
cp {
UpdateListbox xf $o
DefaultInfo xf $s
}
rm {
UpdateListbox xf $s
if {[string compare $xf(pathi$s) $xf(pathi$o)] == 0 && \
!$xf(fsmode_$o)} {
NullSelect xf $o
UpdateListbox xf $o
} {
DefaultInfo xf $o
}
}
}
SetArrowPointer
}

proc FO_Nor_Noturbo {arr s o filelist intlist list operation op} {
upvar $arr xf

set rc 0
set n [llength $filelist]
set index 1
set cleartrash 1
set clist {}
set x [winfo pointerx .]
set y [winfo pointery .]
foreach file $filelist {
InfoChange xf $s "$op: $index / $n"
if {$operation == "rm" } {
if {$xf(safedelete)} {
if {[string match "$xf(pathi$s)" "$xf(trashdir)"]} {
MessageBox "Disable SafeDelete or use menuitem Empty Trash!" $s
set rc 1
break
}
if $cleartrash {
ClearTrashDir xf
.xfmenu.butt.m.del entryconfigure Undo* -state normal
set xf(safedel_from) $xf(pathi$s)
set cleartrash 0
}
set rc [CopyFile $s $xf(pathi$s) $file $xf(trashdir)]
}
if {$rc == 0} {
set rc [DelFile $s $xf(pathi$s) $file]
}
} {
switch $xf(fsmode_$o) {
0 {
set newf ""
set cancel 0
if [ChkDosNames $file $xf(mdos_$o)] {
set newf "a.kissa"
global prompt
while {[ChkDosNames $newf $xf(mdos_$o)]} {
set prompt(1.label) ""
set prompt(1.result) [SuggestDosName $file]
if {[DialogWin "Name will be truncated! New name for\n$file" -50 -50 1 $x $y] == 0} {
set cancel 1
}

set newf $prompt(1.result)
}
}

if $cancel {
lappend clist [lindex $intlist 0]
set intlist [lreplace $intlist 0 0]
continue
}
set rc [CopyFile $s $xf(pathi$s) $file $xf(pathi$o)$newf]
if {$rc == 0 && [string match $operation "mv"]} {
set rc [DelFile $s $xf(pathi$s) $file]
}
if [string compare {} $newf] {
set file $newf
}
}
1 -
2 -
3 {set rc [FO_Nor_Virt xf $s $o "$file" $operation $xf(fsmode_$o)]}
}
}
if !$rc {
set item [lindex $intlist 0]
switch $operation {
cp {
$list selection clear $item
$xf(fuf).${o}list insert end $file
}
mv {
$list selection clear [expr $item-$index+1]
$xf(fuf).${o}list insert end $file
$list delete [expr $item-$index+1]
}
rm {
$list selection clear [expr $item-$index+1]
$list delete [expr $item-$index+1]
}
}
} {
break
}
set intlist [lreplace $intlist 0 0]
incr index
}
switch $xf(fsmode_$o) {
1 {VirtualZip $xf(virtualfile) $o 1}
2 {VirtualTar $xf(virtualfile) $o 1}
3 {VirtualLha $xf(virtualfile) $o 1}
}
if [string compare {} $clist] {
set xf(selekted$s) $clist
set rc 1
}
return $rc
}
proc FO_Nor_Turbo {arr s o filelist intlist list operation op} {
upvar $arr xf

InfoChange xf $s "$op..."
set rc 0
if {$operation == "rm" } {
if {$xf(safedelete)} {
if {[string match "$xf(pathi$s)" "$xf(trashdir)"]} {
MessageBox "Disable SafeDelete or use Empty Trash!" $s
return 1
}
ClearTrashDir xf
.xfmenu.butt.m.del entryconfigure Undo* -state normal
set xf(safedel_from) $xf(pathi$s)
set rc [CopyFiles $s $xf(pathi$s) $filelist $xf(trashdir)]
}
if {$rc == 0} {
set rc [DelFiles $s $xf(pathi$s) $filelist]
}
} {
switch $xf(fsmode_$o) {
0 {
if [ChkDosNames $filelist $xf(mdos_$o)] {
if ![AskWin "Some of the file names will be trunkated. Proceed?"] {
return 1
}
}
set rc [CopyFiles $s $xf(pathi$s) $filelist $xf(pathi$o)]
if {$rc == 0 && [string match $operation "mv"]} {
set rc [DelFiles $s $xf(pathi$s) $filelist]
}
}
1 -
2 -
3 {set rc [FO_Nor_Virt xf $s $o $filelist $operation $xf(fsmode_$o)]}
}
}
return $rc
}
proc CopyFiles {s path files dest} {
global xf

cd $path
set rc [catch {eval exec $xf(COPY) $files [list $dest]}]
if $rc {
set rc [CopyCatch $s $files $dest]
}
return $rc
}
proc CopyFile {s path file dest {newf {}}} {
global xf

cd $path
set rc [catch {eval exec $xf(COPY) [list $file] [list ${dest}$newf]}]
if $rc {
set rc [CopyCatch $s [list $file] $dest $newf]
}
return $rc
}
proc CopyCatch {s flist dest {newf {}}} {
global errorInfo

if {[string compare {} $newf] == 0} {set f [lindex $flist 0]} {set f $newf}
if {[file exists $dest$f] == 1} {
set rc 0
} {
set rc 1
tkerror $errorInfo $s
}
return $rc
}
proc DelFiles {s path files} {
global xf

cd $path
set rc [catch {eval exec $xf(DEL) $files}]
if $rc {
set rc [DelCatch $s $files $path ]
}
return $rc
}
proc DelFile {s path file} {
global xf

cd $path
set rc [catch {eval exec $xf(DEL) [list $file]}]
if $rc {
set rc [DelCatch $s [list $file] $path]
}
return $rc
}
proc DelCatch {s flist path} {
global errorInfo

set f [lindex $flist 0]
if {[file exists $path$f] == 0} {
return 0
} {
tkerror $errorInfo $s
return 1
}
}
proc TrashCan {arr undo} {
upvar $arr xf

if $undo {
set fil [lsort [glob -nocomplain -- $xf(trashdir){.*,*}]]
set files {}
foreach f $fil {
if {![string match {*\.} $f] && ![string match {*\.\.} $f]} {
lappend files [file tail $f]
}
}
set rc [CopyFiles left $xf(trashdir) $files $xf(safedel_from)]
if {$rc  == 0} {
DelFiles left $xf(trashdir) $files
}
if [string match $xf(pathileft) $xf(trashdir)] {
UnselectAll xf "left"
UpdateListbox xf "left"
} elseif [string match $xf(pathileft) $xf(safedel_from)] {
UpdateListbox xf "left"
}
if [string match $xf(pathiright) $xf(trashdir)] {
UnselectAll xf "right"
UpdateListbox xf "right"
} elseif [string match $xf(pathiright) $xf(safedel_from)] {
UpdateListbox xf "right"
}
DefaultInfo xf "left"
DefaultInfo xf "right"
} {
ClearTrashDir xf
if [string match $xf(pathileft) $xf(trashdir)] {
UnselectAll xf "left"
UpdateListbox xf "left"
DefaultInfo xf "right"
} elseif [string match $xf(pathiright) $xf(trashdir)] {
UpdateListbox xf "right"
DefaultInfo xf "left"
} {
DefaultInfo xf "left"
DefaultInfo xf "right"
}
}
if [info exists xf(safedel_from)] {
unset xf(safedel_from)
}
.xfmenu.butt.m.del entryconfigure Undo* -state disabled
}

proc ClearTrashDir {arr} {
upvar $arr xf

set fil [lsort [glob -nocomplain -- $xf(trashdir){.*,*}]]
set files {}
foreach f $fil {
if {![string match {*\.} $f] && ![string match {*\.\.} $f]} {
lappend files [file tail $f]
}
}
if {[string compare {} $files]} {
DelFiles left $xf(trashdir) $files
}
}

proc ReadFiles {s args} {
global xf

if {[string compare {} $args] == 0 \
&& [string compare {} $xf(selekted$s)] != 0} {
MessageBox "You are using the old version of internal command \[ReadFiles\]!\n\
Please open Button Editor, select the button, re-select the item \
'ReadFiles' and then save." $s
return
}
if {[string compare {} $args] == 0} {
OutputWindow "" [list $xf(pathi$s)] "New"
} {
OutputWindow [eval exec cat -- $args] [list $xf(pathi$s)] ""
UnselectAll xf $s
}
}

proc Grep {s} {
global xf prompt

set prompt(1.label) "String:"
set prompt(1.result) ""
set prompt(2.label) "Pattern:"
set prompt(2.result) "*"
if [DialogWin "The <string> will be searched from files matching <pattern> in current directory and its subdirectories."] {
if {[string compare {} $prompt(1.result)] == 0 || [string compare {} $prompt(2.result)] == 0} {
MessageBox "You must give two arguments!" $s
unset prompt
return
}
update idletasks
cd $xf(pathi$s)
set files [exec find . -name $prompt(2.result) -print]
set result ""
foreach f [split $files \n] {
if [catch {eval exec grep -n -e [list $prompt(1.result)] [list $f]} txt] {
continue
}
append result "$f:\n$txt\n\n"
}
if {[string compare {} $result] == 0} {
set result "*** No match ***"
}
OutputWindow $result [list $xf(pathi$s)]
}
unset prompt
}
proc MkDir { s } {
global prompt xf

if [string match $s left] {
set o "right"
} {
set o "left"
}

set xf(clearselect) 0
set prompt(1.label) ""
set prompt(1.result) $xf(pathi$s)
if [DialogWin "Make directory:\n" -50 -50 0] {
set dirri [string trimright $prompt(1.result) /]
if [file exists "$dirri"] {
MessageBox "A file or a directory of that name already exists." $s
} {
if [catch {eval exec $xf(MKDIR) [list $dirri]}] {
MakeDirProc "$dirri"
}
UpdateListbox xf $s
DefaultInfo xf $o
}
}
unset prompt
}
proc Rename {s} {
global prompt xf

if [string match $s left] {
set o "right"
} {
set o "left"
}

if {[string compare {} $xf(selekted$s)] == 0} {
NoSelect $s
} {
cd $xf(pathi$s)
set ind 0

set x [winfo pointerx .]
set y [winfo pointery .]
set xf(clearselect) 0
foreach t [GetSelNames $s] {
set prompt(1.label) ""
set prompt(1.result) $t
switch [DialogWin "Rename\n$t\nto:" -50 -50 1 $x $y "Abort!"] {
0 {}
1 {
if {[catch {eval exec $xf(MOVE) [list $t] [list $prompt(1.result)]} err] && ![string match {*same file*} $err]} {
tkerror $err $s
return
}
$xf(fuf).${s}list select clear [lindex $xf(selekted$s) $ind]
AddSelSize $s [lindex $xf(selekted$s) $ind] "-"
ShowSelSize $s
set xf(selekted$s) [lreplace $xf(selekted$s) $ind $ind]
continue
}
2 {
set xf(noinfo) 1
after 50 [list set xf(noinfo) 0]
after 150 [list InfoChange xf $s "Command aborted!"]
after 4000 [list DefaultInfo xf $s]
break
}
}
incr ind
}
}
catch {unset prompt}
if {[string compare $xf(pathi$s) $xf(pathi$o)] == 0} {
UpdBoth
} {
UpdateListbox xf $s
}
}
proc CopyAs {s} {
global prompt xf XF_TMP

if [string match $s left] {
set o "right"
} {
set o "left"
}

if {[string compare {} $xf(selekted$s)] == 0} {
NoSelect $s
} {
set ind 0
set x [winfo pointerx .]
set y [winfo pointerx .]
set xf(clearselect) 0
set vfs 0
switch $xf(fsmode_$o) {
0 {}
1 {
set voper $xf(TOZIP)
set vproc "VirtualZip"
set vfs 1
}
2 {
set voper $xf(TOTAR)
set vproc "VirtualTar"
set vfs 1
}
3 {
set voper $xf(TOLHA)
set vproc "VirtualLha"
set vfs 1
}
}
if $vfs {
if ![file writable $xf(virtualfile)] {
MessageBox "You can not write to\n$xf(virtualfile)\nNo write permission." $s
return
}
}
foreach t [GetSelNames $s] {
set prompt(1.label) ""
set prompt(1.result) $t
switch [DialogWin "Copy\n$t\nas:" -50 -50 1 $x $y "Abort!"] {
0 {}
1 {
switch $xf(fsmode_$o) {
0 {
CopyFile $s $xf(pathi$s) $t $xf(pathi$o) $prompt(1.result)
}
default {
set rc 0
set rc [DelFile $s "/tmp" "$XF_TMP/"]
set temppi "/tmp/$XF_TMP[string trimright $xf(pathi$o) /]"
if [catch {eval exec $xf(MKDIR) [list $temppi]}] {
MakeDirProc $temppi
}
set rc [CopyFile $s $xf(pathi$s) $t $temppi/ $prompt(1.result)]
if {$rc == 0} {
cd /tmp/$XF_TMP/
set dirri [string trimleft $xf(pathi$o) /]
set file [append dirri $prompt(1.result)]
eval exec $voper [list $xf(virtualfile)] [list $file]
$vproc $xf(virtualfile) $o 1
}
set rc [DelFile $s "/tmp" "$XF_TMP/"]
}
}
$xf(fuf).${s}list select clear [lindex $xf(selekted$s) $ind]
AddSelSize $s [lindex $xf(selekted$s) $ind] "-"
ShowSelSize $s
set xf(selekted$s) [lreplace $xf(selekted$s) $ind $ind]
continue
}
2 {
set xf(noinfo) 1
after 50 [list set xf(noinfo) 0]
after 150 [list InfoChange xf $s "Command aborted!"]
after 4000 [list DefaultInfo xf $s]
break
}
}
incr ind
}
}
catch {unset prompt}
if {[string compare $xf(pathi$s) $xf(pathi$o)] == 0} {
UpdBoth
} {
UpdateListbox xf $o
}
}

proc PatternSelect {s} {
global prompt xf vdleft vdright vfleft vfright

set xf(clearselect) 0
set prompt(1.label) ""
set prompt(1.result) "*"
if [DialogWin "Select all files matching pattern:" -50 -50 0] {
if {[string compare $prompt(1.result) {}] == 0} {
unset prompt
return
}
for {set i 0} {$i < [set vf${s}(size)]} {incr i} {
set ind [expr $i+[set vd${s}(size)]]
if [string match "$prompt(1.result)" "[GetFileName $s $ind]"] {
$xf(fuf).${s}list select set $ind
lappend xf(selekted$s) $ind
}
}
InfoChange xf $s "Calculating..."
after idle [list SelectionSize xf $s]
}
unset prompt
}
proc DirSize {s} {
global xf vdleft vdright

cd $xf(pathi$s)
set dirs {}
foreach i $xf(selekted$s) {
if {$i >= [set vd${s}(size)]} {break}
lappend dirs [GetFileName $s $i]
}
if {[string compare {} $dirs] == 0} {
return
}
set xf(clearselect) 0
set res [eval exec $xf(DIRSIZE) $dirs]
set n 0
foreach line [split $res \n] {
scan $line "%d" size
if $xf(du_1k) {
set size [expr $size * 1024]
} {
set size [expr $size * 512]
}
set p [lindex $xf(selekted$s) $n]
$xf(fuf).${s}list delete $p
if $xf(bitsi) {
set w [expr ([winfo width $xf(fuf).${s}list]/$xf(char_W))-23]
LbInsert $s $p $w [FormatFileName $w [set vd${s}($p.name)] [set vd${s}($p.ext)]] $size [set vd${s}($p.mode)]
} {
set w [expr ([winfo width $xf(fuf).${s}list]/$xf(char_W))-12]
LbInsert $s $p $w [FormatFileName $w [set vd${s}($p.name)] [set vd${s}($p.ext)]] $size
}
set vd${s}($p.size) $size
incr n
}
set xf(selekted$s) [lreplace $xf(selekted$s) 0 $n]
after idle [list SelectionSize xf $s]
}
proc AutoUD {} {
global xf

if ![info exists xf(no_aud)] {
foreach s [list "left" "right"] {
set tmp $xf(${s}autoud)
catch {set tmp [file mtime $xf(pathi$s)]}
if {$xf(${s}autoud) != $tmp} {
set xf(${s}autoud) $tmp
after 1000 [list UpdateListbox xf $s]
}
}
}
if {$xf(autoupdate)} {
after 5000 [list AutoUD]
}
}
proc MenuBar {arr} {
upvar $arr xf

frame .xfmenu -relief raised -borderwidth 1
pack .xfmenu -side top -fill x

menubutton .xfmenu.help -text Help -menu .xfmenu.help.m -underline 0 \
-height 1
set m [menu .xfmenu.help.m]
$m add check -label "Help mode" \
-underline 1 -command HelpProc
$m add command -label "External commands..." \
-underline 1 -command Externals
$m add separator
$m add command -label "Main help..." \
-underline 0 -command "GetHelp $xf(xf_home)xfiles.manual"
$m add command -label "FAQ..." \
-underline 0 -command "GetHelp $xf(xf_home)xfiles.faq"
$m add separator
$m add command -label "About..." -underline 0 \
-command {Aboutti}
pack .xfmenu.help -side right

menubutton .xfmenu.file -text "File" -menu .xfmenu.file.m -underline 0 \
-height 1

set m [menu .xfmenu.file.m]
$m add command -label "Exit program" -underline 0 \
-command "Confirm_exit"
pack .xfmenu.file -side left


menubutton .xfmenu.config -text Config -menu .xfmenu.config.m \
-underline 0 -height 1

set m [menu .xfmenu.config.m]

$m add check -label "Edit buttons..."\
-underline 5 -command {ButtonEditorProc} -variable xf(be_on)
$m add check -label "Edit extensions..." \
-underline 5 -command {ExtEditor} -variable xf(ee_on)
$m add check -label "Edit resources..."\
-underline 5 -command [list ResourceEditor $xf(rcfile)] \
-variable xf(re_on)

pack .xfmenu.config -side left

menubutton .xfmenu.butt -text Options -menu .xfmenu.butt.m -underline 0 \
-height 1
set m [menu .xfmenu.butt.m]
$m add check -label "Turbo File Operations" \
-underline 1 -variable xf(turbomode)
$m add check -label "Protection Bits" \
-underline 0 -variable xf(bitsi) -command UpdBoth
$m add check -label "AutoUpdate" \
-underline 0 -variable xf(autoupdate) -command {if {$xf(autoupdate) == 1} { \
set xf(leftautoud) [file mtime $xf(pathileft)]; \
set xf(rightautoud) [file mtime $xf(pathiright)]; \
AutoUD}}
$m add check -label "Show Link Destination" \
-underline 0 -variable xf(links) \
-command UpdBoth
$m add check -label "Sort By Extension" \
-underline 8 -variable xf(extsort) \
-command UpdBoth

$m add separator
$m add cascade -label "Deleting" -menu $m.del \
-underline 0
$m add cascade -label "Mail Check" -menu $m.mail \
-underline 0
$m add cascade -label "Title" -menu $m.sub1 \
-underline 0
$m add cascade -label "Logging" -menu $m.log \
-underline 0
menu $m.sub1 -tearoff 0
$m.sub1 add check -label "Mem/Swap" -variable xf(memenable)\
-underline 0 -command titlemem
$m.sub1 add check -label "Time" -variable xf(timeenable)\
-underline 0 -command titletime
menu $m.log -tearoff 0
$m.log add check -label "Log" -variable xf(log)\
-underline 0 -command LogVis
$m.log add check -label "Log To File" -variable xf(log2file) \
-underline 7
$m.log add separator
$m.log add command -label "Clear Log Windows" -underline 0 -command ClearLogs
menu $m.del -tearoff 0
$m.del add check -label "SafeDelete" -underline 0 \
-variable xf(safedelete)
$m.del add command -label "Undo last deletion" -underline 0 \
-command [list TrashCan xf 1] -state disabled
$m.del add command -label "Empty trash" -underline 0 \
-command [list TrashCan xf 0]
menu $m.mail -tearoff 0
$m.mail add check -label "Enabled" -underline 0\
-variable xf(mailchk)\
-underline 0 -command {
global env;
if {[info exists env(MAIL)] && [file exists $env(MAIL)]} {
MailChk
} {
MessageBox "Sorry, I can't find Your mail spool!!"
.xfmenu.butt.m entryconfigure Mail* -state disabled
}
if {$xf(mailchk) == 1} {set st "normal"} {set st "disabled"}
.xfmenu.butt.m.mail entryconfigure Messa* -state $st
.xfmenu.butt.m.mail entryconfigure Read* -state $st
}
$m.mail add check -label "MessageBox" -underline 0\
-variable xf(mailmsgbox) -command {
if {$xf(mailmsgbox) == 1} {set t "disabled"} {set t "normal"};
.xfmenu.butt.m.mail entryconfigure Read* -state $t
}
$m.mail add check -label "Read Mail on Ack" -underline 0\
-variable xf(r_mail_on_ack)

menubutton .xfmenu.lines -text "Buttons" -menu .xfmenu.lines.m \
-underline 0 -height 1
set m [menu .xfmenu.lines.m -tearoff 1]
$m add command -label "All" -command \
{set xf(butsetindic) "";ButtonLineSets {1 2 3 4 5 6 7 8}} -underline 0
$m add command -label "None" -command {set xf(butsetindic) "";ButtonLineSets} \
-underline 0
$m add separator
$m add cascade -label "Lines" -menu $m.sub1 \
-underline 0
$m add separator
$m add radio -label "Set 1 (F9)" -variable xf(butsetindic)\
-command {eval {ButtonLineSets $xf(buttonset1)}}
$m add radio -label "Set 2 (F10)" -variable xf(butsetindic)\
-command {eval {ButtonLineSets $xf(buttonset2)}}
$m add radio -label "Set 3 (F11)" -variable xf(butsetindic)\
-command {eval {ButtonLineSets $xf(buttonset3)}}
$m add radio -label "Set 4 (F12)" -variable xf(butsetindic)\
-command {eval {ButtonLineSets $xf(buttonset4)}}
set m [menu $m.sub1 -tearoff 0]
$m add check -label "Line 1 (F1)" -variable xf(linz1)\
-command {ButtonLines 1}
$m add check -label "Line 2 (F2)" -variable xf(linz2)\
-command {ButtonLines 2}
$m add check -label "Line 3 (F3)" -variable xf(linz3)\
-command {ButtonLines 3}
$m add check -label "Line 4 (F4)" -variable xf(linz4)\
-command {ButtonLines 4}
$m add check -label "Line 5 (F5)" -variable xf(linz5)\
-command {ButtonLines 5}
$m add check -label "Line 6 (F6)" -variable xf(linz6)\
-command {ButtonLines 6}
$m add check -label "Line 7 (F7)" -variable xf(linz7)\
-command {ButtonLines 7}
$m add check -label "Line 8 (F8)" -variable xf(linz8)\
-command {ButtonLines 8}

pack .xfmenu.butt -side left
pack .xfmenu.lines -side left
frame .xfmenu.if
pack propagate .xfmenu.if 0
pack .xfmenu.if -side left -expand true -fill both

label .xfmenu.if.mem -fg "#6060a0"
button .xfmenu.if.time -fg "#6060a0" -relief flat \
-state disabled -disabledforeground "#6060a0"\
-highlightthickness 0 -command {
set xf(mailnotice) 1
after 2000 [list titlemail 0]
if {$xf(r_mail_on_ack) == 1} {eval exec xterm -e [option get .xfiles mail_reader {}] &}
}
pack .xfmenu.if.time -side right
pack .xfmenu.if.mem -side left
}
proc SetCnfMenuBg {} {
global xf

if {$xf(ee_on) || $xf(be_on) || $xf(re_on)} {
.xfmenu.config configure -background #fcbcbc
.xfmenu.config configure -activebackground #fccccc
.xfmenu.config configure -relief groove
} {
.xfmenu.config configure -background $xf(config_menu_bg)
.xfmenu.config configure -activebackground $xf(config_menu_abg)
.xfmenu.config configure -relief flat
}
}

proc HelpProc {} {
global xf

if {$xf(helpmode) == 1} {
set xf(helpmode) 0
SetArrowPointer
if {$xf(editmode) == 0} {
foreach var [array names xf Help*] {
unset xf($var)
}
}
bindtags $xf(fuf).leftlist {XF XF_Listbox . all}
bindtags $xf(fuf).rightlist {XF XF_Listbox . all}
} {
source $xf(main_pophelp_file)
source $xf(user_pophelp_file)
if ![info exists xf(Help.Version)] {
ConvertHelp
} elseif {$xf(Help.Version) != 2} {
ConvertHelp
}
set xf(helpmode) 1
. config -cursor question_arrow
bindtags $xf(fuf).leftlist {XF}
bindtags $xf(fuf).rightlist {XF}
}
}

proc UpdBoth {} {
global xf

SetWaitPointer
UpdateListbox xf left
UpdateListbox xf right
SetArrowPointer
}

proc ButtonLines {line {key 0}} {
global xf

set xf(butsetindic) ""
set idx0 [expr ($line-1) * 2]
set idx1 [expr $idx0 + 1]
if {$key > 0} {
if {!$xf(linz$line)} {
set xf(linz$line) 1
} {
set xf(linz$line) 0
}
}

if {$xf(linz$line)} {
pack .xfleft.bf($idx0) -side bottom -expand true -fill x
pack .xfright.bf($idx1) -side bottom -expand true -fill x
} {
pack forget .xfleft.bf($idx0)
pack forget .xfright.bf($idx1)
.xfleft config -height 1
.xfright config -height 1
}
}
proc ButtonLineSets {{par ""}} {
global xf
for {set i 0} {$i < 8} {incr i} {
set xf(linz[expr $i +1]) 0
pack forget .xfleft.bf([expr 2 * $i])
pack forget .xfright.bf([expr 2 * $i +1])
.xfleft config -height 1
.xfright config -height 1
}
foreach i $par {
set xf(linz$i) 1
pack .xfleft.bf([expr 2 * ($i-1)])\
-side bottom -expand true -fill x
pack .xfright.bf([expr (2 * ($i-1))+1])\
-side bottom -expand true -fill x
}
}
proc MailChk {} {
global xf env

if {$xf(mailchk) == 1} {
if ![catch {set tmp [file mtime $env(MAIL)]}] {
set tmp2 [file atime $env(MAIL)]
if {$tmp != $xf(mailtime)} {
if {$xf(mailatime) == $tmp2 || $xf(mailatime) == 0} {
if {$xf(mailmsgbox) == 1} {
if [AskWin "You have new mail !\nRead it now?"] {
eval exec xterm -e [option get .xfiles mail_reader {}] &
}
} {
set xf(mailnotice) 0
titlemail 20
}
}
}
set xf(mailtime) $tmp
if {$xf(mailatime) < $tmp2} {
set xf(mailatime) $tmp2
}
}
after 10000 MailChk
}
}
proc titlemail {t} {
global xf
if {$t > 0} {
after 2000 {
if {$xf(mailnotice) == 0} {
if {$xf(timeenable) == 1} {
set dt [string range [exec date] 0 15]
.xfmenu.if.time config -text " < $dt > " -fg "#6060a0" \
-relief flat -state normal \
-disabledforeground "#6060a0"\
-highlightthickness 0\
-fg "#6060a0"
update idletasks
} {
.xfmenu.if.time config -text "             "
}
after 1000 {
.xfmenu.if.time config -text "< New Mail >" \
-state normal -fg #ff3333
update idletasks
}
}
}
incr t -1
if {$xf(mailnotice) == 1} {
titlemail 0
} {
after 3000 [list titlemail $t]
}
} {
if {$xf(timeenable) == 1} {
set dt [string range [exec date] 0 15]
.xfmenu.if.time config -text " < $dt > " -fg "#6060a0" \
-relief flat -state disabled \
-disabledforeground "#6060a0" \
-highlightthickness 0
update idletasks
} {
.xfmenu.if.time config -text ""
update idletasks
}
}
}
proc titletime {} {
global xf

if {$xf(timeenable) == 1} {
set dt [string range [exec date] 0 15]
.xfmenu.if.time config -text " < $dt > " -fg "#6060a0"
after 30000 titletime
} {
.xfmenu.if.time config -text ""
}
}
proc titlemem {} {
global xf

if {$xf(memenable) == "1"} {
set ms [exec cat /proc/meminfo]
set ind [expr [lsearch -glob $ms *ree:*] +1]
set ms [split $ms \n]
set mem [lindex [lindex $ms [lsearch -glob $ms Mem:*]] $ind]
set swp [lindex [lindex $ms [lsearch -glob $ms Swap:*]] $ind]
unset ms
.xfmenu.if.mem config -text "< Mem: [FormatNumber $mem] Swap: [FormatNumber $swp] >"
after 3000 titlemem
} {
.xfmenu.if.mem config -text ""
}
}
proc Aboutti {} {
global xf
set w .about
catch {destroy $w}
set bg "#661d73"
set abg "#772d83"
set afg "#afffff"
toplevel $w -bg $bg
if {[option get .xfiles messages_always_on_top {}] == 1} {
bind $w <Visibility> [list KeepOnTop $w %W %s]
}
wm title $w "About X-Files"
wm iconname $w "About X-Files"
wm geometry $w +300+300
wm protocol $w WM_DELETE_WINDOW  {image delete xfimage; destroy .about}

frame $w.text -bg $bg -relief raised -bd 2
frame $w.buttons -bg $bg
pack  $w.buttons -side bottom -expand y -fill x -pady 2m
button $w.buttons.dismiss -bg $bg -fg "#afffff" -text Dismiss \
-activebackground $abg -activeforeground $afg -bd 2\
-padx 1 -pady 1 -command {image delete xfimage; destroy .about}
pack $w.buttons.dismiss  -side left -expand 1

catch {image delete xfimage}
image create photo xfimage -file "$xf(xf_home)xflogo.gif"
label $w.im -image xfimage -relief flat -bg $bg

text $w.text.tx -bg $abg -fg $afg -height 14 -width 10 -font fixed


$w.text.tx tag configure versioni -font *-times-bold-r-*-12-*\
-foreground "#ffafff" -justify center -spacing3 10
$w.text.tx tag configure prog -font *-times-*-r-*-18-*\
-foreground "#efefa0" -underline 1
$w.text.tx tag configure name -font -*-times-*-r-*-*-18-*-*-*-*-*-*-*\
-foreground "#dfdfff"
$w.text.tx tag configure all -lmargin1 5 -spacing1 5


$w.text.tx insert end "Version: $xf(version) $xf(reg)\n" versioni

$w.text.tx insert end "Programming & Copyrights: \n" prog
$w.text.tx insert end "Juha Forsten \n" name
$w.text.tx insert end "Mikko Kiviniemi \n" name
$w.text.tx insert end "\n"
$w.text.tx insert end "Email: $xf(mail)\n"
$w.text.tx insert end "WWW  : http://java.inf.tu-dresden.de/X-Files/\n"
$w.text.tx insert end "WWW  : http://pinhead.tky.hut.fi/~xf_adm/\n"
$w.text.tx insert end "WWW  : http://www.hut.fi/~mkivinie/xfindex.html\n"
#$w.text.tx insert end "FTP  : ftp://java.inf.tu-dresden.de/pub/unix/X-Files/\n"
$w.text.tx insert end "\n"

$w.text.tx tag add all 2.0 5.0

pack $w.im -side top -padx .5m -pady .5m
pack $w.text -side top -pady 10 -fill x
pack $w.text.tx -fill x
$w.text.tx configure -state disabled
}

proc Confirm_exit {} {
if {[AskWin "Exit  X-Files ?!"] == 1} {
exit
}
}
proc Xf_variable_dumb { {file xf_vars.dumb}} {
global xf tk_patchLevel tcl_patchLevel
set tmp "TK-version: $tk_patchLevel"
set tmp "$tmp\nTCL-version: $tcl_patchLevel\n"
set tmp "$tmp\nX-Files variables & values:\n---------------------------\n\n"
foreach idx [lsort [array names xf]] {
set tmp  "$tmp xf($idx): $xf($idx)\n"
}
OutputWindow $tmp
}

proc HelpInfo { x y hwidget } {
global helppop xf
if {[info exists xf(Help$hwidget)] == 1} {
if {[info exists xf(Help$hwidget)] == 1} {
catch {destroy $helppop}
set helppop [menu .help -bg "#303080" \
-tearoff 0 -disabledforeground "#f0f0b0" -relief ridge]
$helppop  add command -state disabled \
-font *Helvetica*-12-* \
-label [lindex $xf(Help$hwidget) 0]
set temp [lreplace $xf(Help$hwidget) 0 0 ]
$helppop add separator
foreach line $temp {
$helppop  add command -state disabled \
-label $line
}
tk_popup $helppop \
[expr {[winfo rootx $hwidget] + 10}]\
[expr {[winfo rooty $hwidget] + 10}]
}
}
}

proc HelpInfo_Conf {bfpath comm i framenumber} {

catch {destroy .ahpop} err
regsub "exec" $comm "" resp
regsub "%s" $resp "" resp
set rops ""
set ops [lindex $resp 0]
set resp [lreplace $resp 0 0]
set actionhelp [menu .ahpop -bg "#cccccc" \
-tearoff 0 -disabledforeground "#000000" -relief ridge]
$actionhelp add command -state disabled -label \
"ActionButton - Configuration:" \
-font *Helvetica*-12-*
$actionhelp add separator
$actionhelp add command -state disabled -font fixed -label \
[format "%-8s %s" "Command:" $resp]
if [regexp N $ops] {
set rops "<NONE>"
}
if [regexp C $ops] {
set rops "${rops}Confirm "
}
if [regexp D $ops] {
set rops "${rops}Dialog "
}
if [regexp W $ops] {
set rops "${rops}OutputWin "
}
if [regexp U $ops] {
set rops "${rops}Update "
}
if [regexp Q $ops] {
set rops "${rops}Quiet "
}
$actionhelp add command -state disabled -font fixed \
-label [format "%-8s %s" "Options:" $rops]
set ahwidget $bfpath.bf($framenumber).f([expr {$i-$framenumber*6}]).b([expr {$i-$framenumber*6}])
tk_popup $actionhelp [expr {[winfo rootx $ahwidget] + 10}]\
[expr {[winfo rooty $ahwidget] + 10}]
}

proc GetHelp {file} {
global xf
set manual [open $file r]
OutputWindow [read $manual]
close $manual
}
proc OutputWindow { txt {dir ""} {file ""}} {
global xf xf_image env tk_version
if ![string compare $dir ""] {
set dir "$env(HOME)/"
}
incr xf(outwin_num)
set n $xf(outwin_num)
set xf(outwin_changed$n) 0
set w .$xf(outwin_num)
set  xf(outwin_tagcol$n) "Yellow"
catch {destroy $w}
toplevel $w
wm title $w "X-Files <Output Window: \#$xf(outwin_num)>"
wm iconname $w "XF-OutWin"
wm protocol $w WM_DELETE_WINDOW [list OW_Close $w $n $dir $file]

frame $w.buttons -relief sunken  -bd 2
pack  $w.buttons -side bottom -fill x -pady 2
button $w.buttons.close -text Close -command [list OW_Close $w $n $dir $file]
button $w.buttons.save -text "SaveToFile" \
-command "SaveToFileProc $xf(outwin_num) $dir [list $file]"
pack $w.buttons.save -side left -fill x -padx 10
if {[set tk_version] > 4.0} {
button $w.buttons.mail -text Mail -command "OW_Mail $xf(outwin_num)"
pack $w.buttons.mail -side left -fill x -padx 3
}

pack $w.buttons.close -side right -fill x -padx 10

frame $w.tx
text $w.tx.text -relief sunken -bd 2 -yscrollcommand "$w.tx.sc.scroll set"\
-setgrid 1 -height 30
frame $w.tx.sc
scrollbar $w.tx.sc.scroll -command "$w.tx.text yview"
button $w.tx.sc.t -image $xf_image(topimage) -padx 0 -pady 0\
-command "$w.tx.text yview 0" -bd 1
button $w.tx.sc.b -image $xf_image(bottomimage) -padx 0 -pady 0\
-command "$w.tx.text yview end" -bd 1
pack $w.tx.sc.t -side top
pack $w.tx.sc.b -side bottom
pack $w.tx.sc.scroll -side top -fill y -expand 1
pack $w.tx.sc -side right -fill y -fill y
pack $w.tx.text -expand yes -fill both -side left

$w.tx.text insert 0.0 $txt

$w.tx.text tag configure "Yellow$n" -relief raised -borderwidth 1\
-background "#ffffaf"

$w.tx.text tag configure "Red$n" -relief raised -borderwidth 1\
-background "#ffbfbf"

$w.tx.text tag configure "Green$n" -relief raised -borderwidth 1\
-background "#bfffbf"

$w.tx.text tag configure "Blue$n" -relief raised -borderwidth 1\
-background "#dfdfff"

frame $w.entry -relief groove -bd 3
checkbutton $w.entry.mod -variable xf(outwin_changed$n) -bd 1\
-state disabled
label $w.entry.lab -text "Search string:"
label $w.entry.co -fg #992222 -text ""
entry $w.entry.e -textvariable xf(outwin_search$n) -width 14

button $w.entry.search -text "Search" -bd 1\
-command "SearchProc2 $w" -pady 1

button $w.entry.searchall -text "SearchAll" -bd 1\
-command "SearchProc $w" -pady 1

button $w.entry.ct -text "Clear" -bd 1 -command {\
set n $xf(outwin_num);
eval {.$xf(outwin_num).tx.text tag\
remove $xf(outwin_tagcol$n)$n 1.0 end}} -pady 1

menubutton $w.entry.tc -textvariable xf(outwin_tagcol$n)\
-menu $w.entry.tc.menu -relief raised -bd 1 -bg "#ffffaf"\
-pady 1 -activebackground #ffffdf -indicatoron true
set m [menu $w.entry.tc.menu -tearoff 1]
$m add radio -label "Yellow" -variable xf(outwin_tagcol$n) -command\
"$w.entry.tc config -bg #ffffaf -activebackground #ffffdf"\
-activebackground "#ffffbf"
$m add radio -label "Red" -variable xf(outwin_tagcol$n) -command\
"$w.entry.tc config -bg #ffbfbf -activebackground #ffdfdf"\
-activebackground "#ffcfcf"
$m add radio -label "Green" -variable xf(outwin_tagcol$n) -command\
"$w.entry.tc config -bg #bfffbf -activebackground #dfffdf"\
-activebackground "#cfffcf"
$m add radio -label "Blue" -variable xf(outwin_tagcol$n) -command\
"$w.entry.tc config -bg #dfdfff -activebackground #efefff"\
-activebackground "#cfcfff"
pack $w.entry.mod -side left -padx 1 -pady 1
pack $w.entry.lab -side left -padx 10
pack $w.entry.e -side left -padx 0
pack $w.entry.search -side left -fill x -padx 3\
-pady 0
pack $w.entry.searchall -side left -fill x -padx 3\
-pady 0
pack $w.entry.co -side left
pack $w.entry.ct -side right -fill x -padx 10 -pady 0
pack $w.entry.tc -side right -fill x -padx 0 -pady 0

pack $w.entry -fill both -side bottom
pack $w.tx -side bottom -fill both -expand true

bind $w.entry.e <Return> "SearchProc2 $w"
bind $w <Control-x> { }
bind $w <Control-x><Control-s> \
"SaveToFileProc $xf(outwin_num) $dir [list $file]"
bind $w <Control-x><Control-c> \
[list OW_Close $w $n $dir $file]
bind $w <Control-s> "SearchProc2 $w"
bind $w <Up> {catch {FixFocus %W};break}
bind $w <Down> {catch {FixFocus %W};break}
bind $w <Next> {catch {FixFocus %W};break}
bind $w <Prior> {catch {FixFocus %W};break}
bind $w.tx.text <Key> [list OW_ChkKey $n %K %s]

proc OW_ChkKey {n K s} {
global xf
if {($s == "4") && (($K == "x") || ($K == "s") || ($K == "c"))} {
return
}
if {!([string match $K Up] || \
[string match $K Down] || \
[string match $K Left] || \
[string match $K Right] || \
[string match $K Next] || \
[string match $K Prior] || \
[string match $K Home] || \
[string match $K End] || \
[string match {Shift_*} $K] || \
[string match {Alt_*} $K] || \
[string match {Control_*} $K] || \
[string match $K Caps_Lock] || \
[string match $K Mode_switch] || \
[string match $K Escape] || \
[string match $K Num_Lock])} {
set xf(outwin_changed$n) 1
}
}

proc OW_Close {w num d {f ""}} {
global xf
if $xf(outwin_changed$num) {
set ret [AskWin "You have made changes! Close the editor without saving?" -100 -100 "Save"]
switch $ret {
0 {return}
2 {SaveToFileProc $num $d $f}
default {}
}
}
destroy $w
unset xf(outwin_search$num)
unset xf(outwin_changed$num)
unset xf(outwin_tagcol$num)
if {[winfo exists .fs]} {
if {![string compare "FileSelector#$num" [wm title .fs]]} {
destroy .fs
}
}

}

proc OW_Mail {num} {
global env smtp prompt xf
set mtxt [.$num.tx.text get 0.0 end-1c]
catch {unset prompt}
set prompt(1.label) "Receiver:"
set prompt(2.label) "Subject:"

while 1 {
if {[DialogWin "Sender: $xf(user_email)\n" -80 -190] == 0} {
catch {unset prompt}
return
}
if {[string compare $prompt(1.result) ""]} {
break
}
}

if [catch {SMTP_SendMail $xf(user_email) $prompt(1.result)\
$prompt(2.result) $mtxt} err] {
MessageBox "PROBLEM: [lindex [split $err "\n"] 0]\n\nFIX: Try to set proper hostname to resource 'mailserver' !"
} {
if [info exists smtp(failure)] {
MessageBox "MAIL NOT SENT!! (message from server: $smtp(failure))"
}
}
catch {unset prompt}
}

proc FixFocus { w } {

regexp {^.*([0-9])} $w b
catch {focus $b.tx.text}
}

proc SaveToFileProc {num dir {f ""}} {

if [winfo exists .fs] {
MessageBox "Cannot open more than one FileSelector !"
return
}
global xf
set fname [FS $num $dir save $f]
if {$fname == ""} {
return 0
}
if {![winfo exists .$num]} {
MessageBox "Can't save the file! Output Window\#$num don't exists any\
more !"
return -1
} {
set stxt [.$num.tx.text get 0.0 end-1c]
set sfileid [open $fname w 0600]
puts $sfileid $stxt
close $sfileid
set xf(outwin_changed$num) 0
UpdateListbox xf "right"
UpdateListbox xf "left"
}
}

proc SearchProc {w} {
global xf
$w.entry.co config -text ""
set n $xf(outwin_num)
set i [string length $xf(outwin_search$n)]
set tagcol $xf(outwin_tagcol$n)
if {$xf(outwin_search$n) != ""} {
SetWaitPointer $w
SetWaitPointer $w.entry.e
set pos 1.0
set i 0
while 1 {
set pos [$w.tx.text search -count length $xf(outwin_search$n) $pos end]
if {$pos == ""} {
if {$i == 0} {
SetArrowPointer $w
$w.entry.e config -cursor xterm
MessageBox "String not found!"
return
}
break
}
$w.tx.text tag add "$tagcol$n" $pos "$pos + $length char"
set pos [$w.tx.text index "$pos + $length char"]
incr i
}
SetArrowPointer $w
$w.entry.e config -cursor xterm
$w.entry.co config -text "Found: $i"
}
}




proc SearchProc2 {w} {
global xf
$w.entry.co config -text ""
set n $xf(outwin_num)
set i [string length $xf(outwin_search$n)]
set tagcol $xf(outwin_tagcol$n)
if {$xf(outwin_search$n) != ""} {
SetWaitPointer $w
SetWaitPointer $w.entry.e
set pos [$w.tx.text search $xf(outwin_search$n) insert]

if {$pos != ""} {
$w.tx.text mark set nemo $pos
$w.tx.text see $pos
tkTextSetCursor $w.tx.text "nemo + $i chars"
$w.tx.text tag add  "$tagcol$n"  "insert - $i chars"\
"nemo + $i chars"
$w.tx.text mark unset nemo
raise $w
SetArrowPointer $w
$w.entry.e config -cursor xterm
} {
SetArrowPointer $w
$w.entry.e config -cursor xterm
MessageBox "String not found!"
}
}
}

tkTextSetCursor $w.tx.text 0.0
focus $w.buttons.close

}

proc tkerror {err {s {}}} {
global xf errorCode

SetArrowPointer
bell
set mail 1
if [string match {*ermission denied*} $err] {
set err "Could not complete operation, permission denied!"
set mail 0
}
if [string match {*ENOENT*} $errorCode] {
set mail 0
}
if {[string compare {} $s] == 0} {
LogBoth $err 1
} {
after idle [list InsertToLog $s $err 1]
}
if [string match {*left*} [focus]] {
set s "left"
} {
set s "right"
}

$xf(pathEnt_$s) xview moveto 1
$xf(pathEnt_$s) icursor end
DefaultInfo xf $s
set e [toplevel .er]
if {[option get .xfiles messages_always_on_top {}] == 1} {
bind $e <Visibility> [list KeepOnTop $e %W %s]
}
set error(ok) 0
frame $e.up -relief sunken -bd 2  -bg "#cacaca"
wm geometry $e +[expr [winfo pointerx .] - 50]+[expr [winfo pointery .] - 50]
wm title $e "X-Files Error"
wm protocol $e WM_DELETE_WINDOW {set error(ok) 1}

message $e.up.msg -text $err -aspect 400

frame $e.buttons -relief raised -bd 0
frame $e.buttons.dum -relief sunken -bd 1
button $e.buttons.dum.ok -text OK! -command {set error(ok) 1}
button $e.buttons.mail -text "Mail..." -command {if [ERR_Mail] {.er.buttons.mail flash}}
button $e.buttons.save -text Save -command {ERR_Save; .er.buttons.save flash}

pack $e.up.msg -side right -fill both -expand 1
pack $e.up -side top -fill both -expand 1 -padx 4

pack $e.buttons.dum -side left -padx 10 -pady 5
pack $e.buttons.dum.ok -padx 4 -pady 4
pack $e.buttons.save $e.buttons.mail -side right
pack $e.buttons -side bottom -fill x

if {!$mail} {
$e.buttons.mail config -state disabled
}
focus $e.buttons.dum.ok
tkwait visibility $e
KeepInScreen $e
grab $e
tkwait variable error(ok)
grab release $e
catch {destroy .er}
}

proc ERR_Msg {{m ""}} {
global errorInfo xf be ee env tk_patchLevel tcl_patchLevel errorCode

set m "$m\n*****************************************************"
catch {set m  "$m\nDATE: [exec date]"}
set m "$m\n*****************************************************"

set m "$m\n\nTK_ERRORMSG:"
set m "$m\n-------------------\n"
set m "$m\n[set errorCode]\n"
set m "$m\n[set errorInfo]"

set m "$m\nENV_VARS:"
set m "$m\n-------------------\n"

foreach idx [list USER USERNAME HOSTNAME TERM HOSTTYPE PATH HOME SHELL OSTYPE XF_HOME] {
if [info exists env($idx)] {
set m "$m\n$idx:  $env($idx)"
}
}

set m "$m\n\nXF_VARS:"
set m "$m\n-------------------\n"
set m "$m\ntk_version:  $tk_patchLevel"
set m "$m\ntcl_version:  $tcl_patchLevel"
foreach idx [lsort [array names xf]] {
set m  "$m\n$idx:  $xf($idx)"
}
set m "$m\n"

set m "$m\n\nBE_VARS:"
set m "$m\n-------------------\n"
foreach idx [lsort [array names be]] {
set m  "$m\n$idx:  $be($idx)"
}
set m "$m\n"

set m "$m\n\nEE_VARS:"
set m "$m\n-------------------\n"
foreach idx [lsort [array names ee]] {
set m  "$m\n$idx:  $ee($idx)"
}
set m "$m\n"

return $m
}

proc ERR_Mail {} {
global xf ret errorCode subject

set subject "X-Files errorCode: $errorCode"
set top [toplevel .mail -borderwidth 5]
wm title $top "X-Files Error Mail"
wm resizable $top 0 0
wm geometry $top +[expr [winfo pointerx .] - 50]+[expr [winfo pointery .] - 500]
wm protocol $top WM_DELETE_WINDOW {set ret 0}

message $top.info -aspect 500 -text "When you click 'Send', this error will be sent to the X-Files Administrators. The error-mail will include all X-Files internal variables and some system variables. If you could write a brief description of what led to this error, it would help our job of hunting down the bug... Thank you!"
pack $top.info -expand 1

set f [frame $top.top -relief ridge -bd 3]
frame $f.1
label $f.1.l -text "Mail to:" -width 8
entry $f.1.e -textvariable xf(mail) -state disabled -relief flat
pack $f.1.l -side left
pack $f.1.e -side left -fill x -expand 1
pack $f.1 -fill x -expand 1
frame $f.2
label $f.2.l -text "Subject:" -width 8
entry $f.2.e -textvariable subject -state disabled -relief flat
pack $f.2.l -side left
pack $f.2.e -side left -fill x -expand 1
pack $f.2 -fill x -expand 1
pack $f -fill both -expand 1

set f [frame $top.bottom -relief groove -bd 3]
frame $f.h
label $f.h.l -text "Additional info:"
pack $f.h.l -side left
pack $f.h -fill x
set t [text $f.t -height 10 -width 40 -wrap word]
pack $t -fill both -expand 1
pack $f -fill both -expand 1

set f [frame $top.buttons -relief ridge -bd 3]
button $f.send -text "Send" -width 6 -command {set ret 1}
button $f.cancel -text "Cancel" -width 6 -command {set ret 0}
pack $f.send -side left -padx 10 -pady 10
pack $f.cancel -side right -padx 10 -pady 10
pack $f -fill both -expand 1

focus $t
tkwait visibility $top
KeepInScreen $top
grab $top
tkwait variable ret
grab release $top
if {$ret == 0} {
catch {destroy $top}
return 0
}
set addinfo [$t get 0.0 end]
set stream [open "|mail $xf(mail)" w]
puts $stream [ERR_Msg "Subject: $subject\n\nBUG-MAIL:\n\n$addinfo\n"]
close $stream
catch {destroy $top}
return 1
}

proc ERR_Save {} {
global xf
MakeSaveDir
set fileid [open $xf(user_home)ErrorLog {WRONLY APPEND CREAT}]
puts $fileid [ERR_Msg "BUG-SAVE:"]
close $fileid
}


proc SMTP_ReadSocket {sock} {
global smtp
set l [gets $sock]
if { [string index $l 0] == "5"} {
set smtp(ok) -1
set smtp(failure) $l
return
} {
set smtp(ok) 0
return
}
}

proc SMTP_SendMail {from to subject data {host 127.0.0.1} {port 25}} {

global smtp ok
set s [socket $host $port]
fileevent $s readable [list SMTP_ReadSocket $s]
fconfigure $s -buffering line

vwait smtp(ok)
if {$smtp(ok) == -1} {
return -1
}
set header "MAIL FROM: <$from>\nRCPT TO: <$to>\nDATA"
set end ".\nQUIT"
foreach line [split $header "\n"] {
puts $s $line
flush $s
vwait smtp(ok)
if {$smtp(ok) == -1} {
return -1
}
}
puts $s "Subject: $subject"
foreach line [split $data "\n"] {
puts $s $line
}
foreach line [split $end "\n"] {
puts $s $line
flush $s
vwait smtp(ok)
if {$smtp(ok) == -1} {
return -1
}
}
fileevent $s readable {}
fileevent $s writable {}
close $s
unset smtp
}


set XF_TMP X-Files[pid]
set vdleft(size) 0
set vdright(size) 0
lappend auto_path $xf(xf_home)

MAIN $argc $argv
