#ifndef _PUBLIC_H
#define _PUBLIC_H

#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>

#include "Classes.h"

#define String XString
#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <Xm/XmStrDefs.h>
#include <Xm/Xm.h>
#include <Xm/ArrowBGP.h>
#include <Xm/ArrowBP.h>
#include <Xm/BulletinBP.h>
#include <Xm/CascadeBGP.h>
#include <Xm/CascadeBP.h>
#include <Xm/CommandP.h>
#include <Xm/DialogSP.h>
#include <Xm/DrawingAP.h>
#include <Xm/DrawnBP.h>
#include <Xm/FileSBP.h>
#include <Xm/FormP.h>
#include <Xm/FrameP.h>
#include <Xm/LabelGP.h>
#include <Xm/LabelP.h>
#include <Xm/ListP.h>
#include <Xm/MainWP.h>
#include <Xm/MenuShellP.h>
#include <Xm/MessageBP.h>
#include <Xm/PanedWP.h>
#include <Xm/PushBGP.h>
#include <Xm/PushBP.h>
#include <Xm/RowColumnP.h>
#include <Xm/ScaleP.h>
#include <Xm/ScrollBarP.h>
#include <Xm/ScrolledWP.h>
#include <Xm/SelectioBP.h>
#include <Xm/SeparatoGP.h>
#include <Xm/SeparatorP.h>
#include <Xm/TextFP.h>
#include <Xm/TextP.h>
#include <Xm/ToggleBGP.h>
#include <Xm/ToggleBP.h>
#undef String

extern XtAppContext            app_context;
extern Display               * display;
extern GC                      gc, font_gc, color_gc;

#define EVENT_MASK (ButtonPressMask |\
                    ButtonReleaseMask |\
                    ButtonMotionMask |\
                    KeyPressMask|\
                    ExposureMask)

#define CALLBACK_FUNCTION (*f)(Widget, void *, void *)
#define VOID_FUNCTION (*f)()

/* global path names */
#define DEFAULT_PROJECT_PATH "./"
#define DEFAULT_PIXMAP_PATH "./pixmaps/"
#define DEFAULT_SETUP_PATH "./setup/"

#define MAX_LIB_STRING 512
#define MAX_INCLUDE_STRING 512
#define MAX_STRING 256

#define WIDGET_SPACING 24
#define WIDGET_SIZE 32
#define WIDGET_SIZE_X WIDGET_SIZE
#define WIDGET_SIZE_Y WIDGET_SIZE

#define SPACE WIDGET_SPACING + WIDGET_SIZE

/* resource defines */
//#define DISPLAY_
//#define SETTING_
//#define CALLBACK_
//#define DRAG_DROP_
//#define COLOR_PIXMAP_
//#define TOTAL_

#define DISPLAY_MANAGER
#define SETTING_MANAGER 331,
#define CALLBACK_MANAGER
#define DRAG_DROP_MANAGER
#define COLOR_PIXMAP_MANAGER 29,30,432,147,149,376,377,
#define TOTAL_MANAGER 8

#define DISPLAY_PRIMITIVE
#define SETTING_PRIMITIVE 150,331,
#define CALLBACK_PRIMITIVE
#define DRAG_DROP_PRIMITIVE
#define COLOR_PIXMAP_PRIMITIVE 29,30,432,147,148,149,376,377,
#define TOTAL_PRIMITIVE 10

#define DISPLAY_COMPOSITE
#define SETTING_COMPOSITE
#define CALLBACK_COMPOSITE
#define DRAG_DROP_COMPOSITE
#define COLOR_PIXMAP_COMPOSITE
#define TOTAL_COMPOSITE 0

#define DISPLAY_SHELL
#define SETTING_SHELL 408,
#define CALLBACK_SHELL
#define DRAG_DROP_SHELL
#define COLOR_PIXMAP_SHELL
#define TOTAL_SHELL 1

#define DISPLAY_WMSHELL
#define SETTING_WMSHELL 414,415,461,462,463,464,466,467,468,469,
#define CALLBACK_WMSHELL
#define DRAG_DROP_WMSHELL
#define COLOR_PIXMAP_WMSHELL
#define TOTAL_WMSHELL 10

#define DISPLAY_VENDORSHELL
#define SETTING_VENDORSHELL 82,
#define CALLBACK_VENDORSHELL
#define DRAG_DROP_VENDORSHELL
#define COLOR_PIXMAP_VENDORSHELL
#define TOTAL_VENDORSHELL 1

#define DISPLAY_TOPLEVELSHELL
#define SETTING_TOPLEVELSHELL 445,
#define CALLBACK_TOPLEVELSHELL
#define DRAG_DROP_TOPLEVELSHELL
#define COLOR_PIXMAP_TOPLEVELSHELL
#define TOTAL_TOPLEVELSHELL 1

#define DISPLAY_APPLICATIONSHELL
#define SETTING_APPLICATIONSHELL
#define CALLBACK_APPLICATIONSHELL
#define DRAG_DROP_APPLICATIONSHELL
#define COLOR_PIXMAP_APPLICATIONSHELL
#define TOTAL_APPLICATIONSHELL 0

#define DISPLAY_DIALOGSHELL
#define SETTING_DIALOGSHELL
#define CALLBACK_DIALOGSHELL
#define DRAG_DROP_DIALOGSHELL
#define COLOR_PIXMAP_DIALOGSHELL
#define TOTAL_DIALOGSHELL 0

#define DISPLAY_LABEL 141,
#define SETTING_LABEL 182,183,207,208,209,210,211,212,286,
#define CALLBACK_LABEL
#define DRAG_DROP_LABEL
#define COLOR_PIXMAP_LABEL 180,181,
#define TOTAL_LABEL 12

#define DISPLAY_PUSHBUTTON
#define SETTING_PUSHBUTTON
#define CALLBACK_PUSHBUTTON
#define DRAG_DROP_PUSHBUTTON
#define COLOR_PIXMAP_PUSHBUTTON
#define TOTAL_PUSHBUTTON 0

#define DISPLAY_BULLETINBOARD
#define SETTING_BULLETINBOARD
#define CALLBACK_BULLETINBOARD
#define DRAG_DROP_BULLETINBOARD
#define COLOR_PIXMAP_BULLETINBOARD
#define TOTAL_BULLETINBOARD 0

#define DISPLAY_MESSAGEBOX
#define SETTING_MESSAGEBOX
#define CALLBACK_MESSAGEBOX
#define DRAG_DROP_MESSAGEBOX
#define COLOR_PIXMAP_MESSAGEBOX
#define TOTAL_MESSAGEBOX 0

#define DISPLAY_RADIOBOX
#define SETTING_RADIOBOX
#define CALLBACK_RADIOBOX
#define DRAG_DROP_RADIOBOX
#define COLOR_PIXMAP_RADIOBOX
#define TOTAL_RADIOBOX 0

#define DISPLAY_FORM
#define SETTING_FORM 143,157,301,400,
#define CALLBACK_FORM
#define DRAG_DROP_FORM
#define COLOR_PIXMAP_FORM
#define TOTAL_FORM 4

#define DISPLAY_MENUBAR
#define SETTING_MENUBAR
#define CALLBACK_MENUBAR
#define DRAG_DROP_MENUBAR
#define COLOR_PIXMAP_MENUBAR
#define TOTAL_MENUBAR 0

#define DISPLAY_ROWCOLUMN
#define SETTING_ROWCOLUMN
#define CALLBACK_ROWCOLUMN
#define DRAG_DROP_ROWCOLUMN
#define COLOR_PIXMAP_ROWCOLUMN
#define TOTAL_ROWCOLUMN 0

#define DISPLAY_SELECTIONBOX
#define SETTING_SELECTIONBOX
#define CALLBACK_SELECTIONBOX
#define DRAG_DROP_SELECTIONBOX
#define COLOR_PIXMAP_SELECTIONBOX
#define TOTAL_SELECTIONBOX 0

#define DISPLAY_DRAWINGAREA
#define SETTING_DRAWINGAREA
#define CALLBACK_DRAWINGAREA
#define DRAG_DROP_DRAWINGAREA
#define COLOR_PIXMAP_DRAWINGAREA
#define TOTAL_DRAWINGAREA 0

#define DISPLAY_SCALE
#define SETTING_SCALE
#define CALLBACK_SCALE
#define DRAG_DROP_SCALE
#define COLOR_PIXMAP_SCALE
#define TOTAL_SCALE 0

#define DISPLAY_COMMAND
#define SETTING_COMMAND
#define CALLBACK_COMMAND
#define DRAG_DROP_COMMAND
#define COLOR_PIXMAP_COMMAND
#define TOTAL_COMMAND 0

#define DISPLAY_FRAME
#define SETTING_FRAME
#define CALLBACK_FRAME
#define DRAG_DROP_FRAME
#define COLOR_PIXMAP_FRAME
#define TOTAL_FRAME 0

#define DISPLAY_SCROLLEDWINDOW
#define SETTING_SCROLLEDWINDOW
#define CALLBACK_SCROLLEDWINDOW
#define DRAG_DROP_SCROLLEDWINDOW
#define COLOR_PIXMAP_SCROLLEDWINDOW
#define TOTAL_SCROLLEDWINDOW 0

#define DISPLAY_FILESELECTIONBOX
#define SETTING_FILESELECTIONBOX
#define CALLBACK_FILESELECTIONBOX
#define DRAG_DROP_FILESELECTIONBOX
#define COLOR_PIXMAP_FILESELECTIONBOX
#define TOTAL_FILESELECTIONBOX 0

#define DISPLAY_PANEDWINDOW
#define SETTING_PANEDWINDOW
#define CALLBACK_PANEDWINDOW
#define DRAG_DROP_PANEDWINDOW
#define COLOR_PIXMAP_PANEDWINDOW
#define TOTAL_PANEDWINDOW 0

#define DISPLAY_MAINWINDOW
#define SETTING_MAINWINDOW
#define CALLBACK_MAINWINDOW
#define DRAG_DROP_MAINWINDOW
#define COLOR_PIXMAP_MAINWINDOW
#define TOTAL_MAINWINDOW 0

#define DISPLAY_ARROWBUTTON
#define SETTING_ARROWBUTTON
#define CALLBACK_ARROWBUTTON
#define DRAG_DROP_ARROWBUTTON
#define COLOR_PIXMAP_ARROWBUTTON
#define TOTAL_ARROWBUTTON 0

#define DISPLAY_TOGGLEBUTTON
#define SETTING_TOGGLEBUTTON
#define CALLBACK_TOGGLEBUTTON
#define DRAG_DROP_TOGGLEBUTTON
#define COLOR_PIXMAP_TOGGLEBUTTON
#define TOTAL_TOGGLEBUTTON 0

#define DISPLAY_SEPARATOR
#define SETTING_SEPARATOR
#define CALLBACK_SEPARATOR
#define DRAG_DROP_SEPARATOR
#define COLOR_PIXMAP_SEPARATOR
#define TOTAL_SEPARATOR 0

#define DISPLAY_LIST
#define SETTING_LIST
#define CALLBACK_LIST
#define DRAG_DROP_LIST
#define COLOR_PIXMAP_LIST
#define TOTAL_LIST 0

#define DISPLAY_TEXT
#define SETTING_TEXT
#define CALLBACK_TEXT
#define DRAG_DROP_TEXT
#define COLOR_PIXMAP_TEXT
#define TOTAL_TEXT 0

#define DISPLAY_CASCADEBUTTON
#define SETTING_CASCADEBUTTON
#define CALLBACK_CASCADEBUTTON
#define DRAG_DROP_CASCADEBUTTON
#define COLOR_PIXMAP_CASCADEBUTTON
#define TOTAL_CASCADEBUTTON 0

#define DISPLAY_OPTIONMENU
#define SETTING_OPTIONMENU
#define CALLBACK_OPTIONMENU
#define DRAG_DROP_OPTIONMENU
#define COLOR_PIXMAP_OPTIONMENU
#define TOTAL_OPTIONMENU 0

#define DISPLAY_TEXTFIELD
#define SETTING_TEXTFIELD
#define CALLBACK_TEXTFIELD
#define DRAG_DROP_TEXTFIELD
#define COLOR_PIXMAP_TEXTFIELD
#define TOTAL_TEXTFIELD 0

#define DISPLAY_DRAWNBUTTON
#define SETTING_DRAWNBUTTON
#define CALLBACK_DRAWNBUTTON
#define DRAG_DROP_DRAWNBUTTON
#define COLOR_PIXMAP_DRAWNBUTTON
#define TOTAL_DRAWNBUTTON 0

#define DISPLAY_PULLDOWNMENU
#define SETTING_PULLDOWNMENU
#define CALLBACK_PULLDOWNMENU
#define DRAG_DROP_PULLDOWNMENU
#define COLOR_PIXMAP_PULLDOWNMENU
#define TOTAL_PULLDOWNMENU 0

#define DISPLAY_SCROLLEDTEXT
#define SETTING_SCROLLEDTEXT
#define CALLBACK_SCROLLEDTEXT
#define DRAG_DROP_SCROLLEDTEXT
#define COLOR_PIXMAP_SCROLLEDTEXT
#define TOTAL_SCROLLEDTEXT 0

#define DISPLAY_SCROLLBAR
#define SETTING_SCROLLBAR
#define CALLBACK_SCROLLBAR
#define DRAG_DROP_SCROLLBAR
#define COLOR_PIXMAP_SCROLLBAR
#define TOTAL_SCROLLBAR 0

#define DISPLAY_SCROLLEDLIST
#define SETTING_SCROLLEDLIST
#define CALLBACK_SCROLLEDLIST
#define DRAG_DROP_SCROLLEDLIST
#define COLOR_PIXMAP_SCROLLEDLIST
#define TOTAL_SCROLLEDLIST 0


enum widget_type_enum {
  applicationshell_v = 1,
  toplevelshell_v,
  arrowbutton_v,
  arrowbuttongadget_v,
  bulletinboard_v,
  cascadebutton_v,
  cascadebuttongadget_v,
  command_v,
  dialogshell_v,
  drawingarea_v,
  drawnbutton_v,
  errordialog_v,
  fileselectionbox_v,
  form_v,
  formdialog_v,
  frame_v,
  informationdialog_v,
  label_v,
  labelgadget_v,
  list_v,
  mainwindow_v,
  menubar_v,
  messagebox_v,
  optionmenu_v,
  panedwindow_v,
  popupmenu_v,
  promptdialog_v,
  pulldownmenu_v,
  pushbutton_v,
  pushbuttongadget_v,
  questiondialog_v,
  radiobox_v,
  rowcolumn_v,
  scale_v,
  scrollbar_v,
  scrolledlist_v,
  scrolledtext_v,
  scrolledwindow_v,
  selectionbox_v,
  selectiondialog_v,
  separator_v,
  separatorgadget_v,
  templatedialog_v,
  text_v,
  textfield_v,
  togglebutton_v,
  togglebuttongadget_v,
  warningdialog_v,
  workingdialog_v,
  last_widget_type_v
};
typedef enum widget_type_enum widget_type_enum;

enum callback_type_enum {
  activate_v,
  cascading_v,
  command_entered_v,
  command_changed_v,
  arm_v,
  disarm_v,
  destroy_v,
  focus_v,
  focus_moved_v,
  gain_primary_v,
  lose_primary_v,
  losing_focus_v,
  modify_verify_v,
  motion_verify_v,
  input_v,
  expose_v,
  resize_v,
  help_v,
  browse_selection_v,
  default_action_v,
  extended_selection_v,
  multiple_selection_v,
  single_selection_v,
  apply_v,
  cancel_v,
  ok_v,
  no_match_v,
  entry_v,
  map_v,
  tearoff_menu_activate_v,
  tearoff_menu_deactivate_v,
  unmap_v,
  drag_v,
  value_changed_v,
  decrement_v,
  increment_v,
  page_decrement_v,
  page_increment_v,
  to_bottom_v,
  to_position_v,
  to_top_v,
  drag_drop_finish_v,
  drag_motion_v,
  drop_finish_v,
  drop_site_enter_v,
  drop_site_leave_v,
  drop_start_v,
  operation_changed_v,
  top_level_enter_v,
  top_level_leave_v,
  traverse_obscured_v,
  protocol_v,
  realize_v,
  no_callback_v,
  last_callback_type_v
};
typedef enum callback_type_enum callback_type_enum;

enum selection_enum {
  top_v,
  bottom_v,
  left_v,
  right_v,
  none_v
};
typedef enum selection_enum selection_enum;

enum code_type_enum{
  c_code_v,
  cpp_code_v,
  resource_code_v,
  smalltalk_code_v,
  main_code_v,
  callback_code_v,
  event_code_v,
  makefile_code_v,
  include_code_v,
  last_code_v
};
typedef enum code_type_enum code_type_enum;

struct core_widget_rec {
  Widget frame;
  Widget text;
  Widget toggle;
  Widget button;
  Widget menu;
  Widget opt[10];
   bool modified;
   bool toggle_on;
};
typedef struct core_widget_rec core_widget_rec;

struct resource_rec {
   char * name;
   char * type;
   char * default_value;
   char * access_method;
   char * value;
   char * options;
   int tool;
   core_widget_rec *cw;
};
typedef struct resource_rec resource_rec;

struct attachment_rec {
  int top_attachment;
  int bottom_attachment;
  int left_attachment;
  int right_attachment;
  WidgetObj * top_widget;
  WidgetObj * bottom_widget;
  WidgetObj * left_widget;
  WidgetObj * right_widget;
  int top_offset;
  int bottom_offset;
  int left_offset;
  int right_offset;
  int top_position;
  int bottom_position;
  int left_position;
  int right_position;
};
typedef struct attachment_rec attachment_rec;


struct option_rec {
   // Libraries
   char motif_lib[MAX_LIB_STRING];
   bool motif_static;
   char xt_lib[MAX_LIB_STRING];
   bool xt_static;
   char x11_lib[MAX_LIB_STRING];
   bool x11_static;

   // include path
   char includes[MAX_INCLUDE_STRING];

   // compiler stuff
   char c_compiler[MAX_STRING];
   char c_flags[MAX_STRING];
   char cpp_compiler[MAX_STRING];
   char cpp_flags[MAX_STRING];

   // code generation
   char event_filename[MAX_STRING];
   char callback_filename[MAX_STRING];
   char public_filename[MAX_STRING];
   char resource_directory[MAX_STRING];
   char project_directory[MAX_STRING];
   char pixmap_directory[MAX_STRING];
};
typedef struct option_rec option_rec;

struct layout_rec {
  Position Main_x;
  Position Main_y;
  Position Shell_x;
  Position Shell_y;
  Position Manager_x;
  Position Manager_y;
  Position Primitive_x;
  Position Primitive_y;
  Position Dialog_x;
  Position Dialog_y;
  Position Gadget_x;
  Position Gadget_y;
  Position Option_x;
  Position Option_y;
  Position Widget_x;
  Position Widget_y;
  Position Interface_x;
  Position Interface_y;
};
typedef struct layout_rec layout_rec;

struct button_rec {
  // Shells
  Widget applicationshell;
  Widget toplevelshell;
  Widget dialogshell;
  // Managers
  Widget bulletinboard;
  Widget form;
  Widget selectionbox;
  Widget command;
  Widget fileselectionbox;
  Widget messagebox;
  Widget menubar;
  Widget drawingarea;
  Widget frame;
  Widget panedwindow;
  Widget radiobox;
  Widget rowcolumn;
  Widget scale;
  Widget scrolledwindow;
  Widget mainwindow;
  // Primitives
  Widget arrowbutton;
  Widget label;
  Widget cascadebutton;
  Widget drawnbutton;
  Widget pushbutton;
  Widget togglebutton;
  Widget list;
  Widget optionmenu;
  Widget pulldownmenu;
  Widget scrollbar;
  Widget separator;
  Widget text;
  Widget textfield;
  Widget scrolledtext;
  Widget scrolledlist;
  // Dialogs
  Widget errordialog;
  Widget informationdialog;
  Widget formdialog;
  Widget questiondialog;
  Widget promptdialog;
  Widget selectiondialog;
  Widget templatedialog;
  Widget warningdialog;
  Widget workingdialog;
  // Gadgets
  Widget arrowbuttongadget;
  Widget labelgadget;
  Widget cascadebuttongadget;
  Widget pushbuttongadget;
  Widget togglebuttongadget;
  Widget separatorgadget;
};
typedef struct button_rec button_rec;

struct creation_rec {
  WidgetClass *class_name;
  char *name;
  char *label;
  char *mnemonic;
  char *accelerator;
  char *accel_text;
  void (*cb)();
  XtPointer cbdata;
  widget_type_enum type;
};

extern WidgetClass *widget_class_name[];
extern char* selection_arr[];
extern char* callback_name[];
extern char* widget_name[];
extern bool include_file[last_widget_type_v];
extern char * include_arr[];
extern char * attachment_arr[];
extern char attach_buffer[];
extern button_rec bt;
extern resource_rec resource_array[522];
extern int core_resource_index[19];
extern option_rec new_options;
extern option_rec default_options;
extern layout_rec new_layout;
extern layout_rec default_layout;
extern void set_handlers();
extern "C" {
  extern char *optarg;
  extern int optind;
  //extern int getopt(int, char **, char *);
  extern int getopt(int, char *const *, const char *);
  extern void XcgLiteClueAddWidget(_WidgetRec *, _WidgetRec *, char *, int, int);
}

extern Guide * guide;
extern int applicationshell_index[5 
				 + TOTAL_SHELL 
				 + TOTAL_WMSHELL 
				 + TOTAL_VENDORSHELL 
				 + TOTAL_TOPLEVELSHELL 
				 + TOTAL_COMPOSITE 
				 + TOTAL_APPLICATIONSHELL];
extern int toplevelshell_index[5 
			      + TOTAL_SHELL 
			      + TOTAL_WMSHELL 
			      + TOTAL_VENDORSHELL 
			      + TOTAL_TOPLEVELSHELL 
			      + TOTAL_COMPOSITE];
extern int arrowbutton_index[5 
			    + TOTAL_PRIMITIVE
			    + TOTAL_ARROWBUTTON];
extern int arrowbuttongadget_index[5];
extern int bulletinboard_index[5
			      + TOTAL_MANAGER
			      + TOTAL_COMPOSITE
			      + TOTAL_BULLETINBOARD];
extern int cascadebutton_index[5 
			      + TOTAL_PRIMITIVE 
			      + TOTAL_LABEL
			      + TOTAL_CASCADEBUTTON];
extern int cascadebuttongadget_index[5];
extern int command_index[5
			+ TOTAL_COMPOSITE
			+ TOTAL_BULLETINBOARD
			+ TOTAL_MANAGER
			+ TOTAL_SELECTIONBOX
			+ TOTAL_COMMAND];
extern int dialogshell_index[5 
			    + TOTAL_SHELL 
			    + TOTAL_WMSHELL 
			    + TOTAL_VENDORSHELL 
			    + TOTAL_COMPOSITE 
			    + TOTAL_DIALOGSHELL];
extern int drawingarea_index[5
			    + TOTAL_COMPOSITE
			    + TOTAL_MANAGER
			    + TOTAL_DRAWINGAREA];
extern int drawnbutton_index[5 
			    + TOTAL_PRIMITIVE 
			    + TOTAL_LABEL
			    + TOTAL_DRAWNBUTTON];
extern int errordialog_index[5];
extern int fileselectionbox_index[5
				 + TOTAL_COMPOSITE
				 + TOTAL_BULLETINBOARD
				 + TOTAL_MANAGER
				 + TOTAL_SELECTIONBOX
				 + TOTAL_FILESELECTIONBOX];
extern int form_index[5
		     + TOTAL_COMPOSITE
		     + TOTAL_BULLETINBOARD
		     + TOTAL_MANAGER
		     + TOTAL_FORM];
extern int formdialog_index[5];
extern int frame_index[5
		      + TOTAL_COMPOSITE
		      + TOTAL_MANAGER
		      + TOTAL_FRAME];
extern int informationdialog_index[5];
extern int label_index[5 
		      + TOTAL_PRIMITIVE 
		      + TOTAL_LABEL];
extern int labelgadget_index[5];
extern int list_index[5 
		     + TOTAL_PRIMITIVE 
		     + TOTAL_LIST];
extern int mainwindow_index[5
			   + TOTAL_COMPOSITE
			   + TOTAL_SCROLLEDWINDOW
			   + TOTAL_MANAGER
			   + TOTAL_MAINWINDOW];
extern int menubar_index[5];
extern int messagebox_index[5
			   + TOTAL_COMPOSITE
			   + TOTAL_BULLETINBOARD
			   + TOTAL_MANAGER
			   + TOTAL_MESSAGEBOX];
extern int optionmenu_index[5];
extern int panedwindow_index[5
			    + TOTAL_COMPOSITE
			    + TOTAL_MANAGER
			    + TOTAL_PANEDWINDOW];
extern int popupmenu_index[5];
extern int promptdialog_index[5];
extern int pulldownmenu_index[5];
extern int pushbutton_index[5 
			   + TOTAL_PRIMITIVE 
			   + TOTAL_LABEL 
			   + TOTAL_PUSHBUTTON];
extern int pushbuttongadget_index[5];
extern int questiondialog_index[5];
extern int radiobox_index[5];
extern int rowcolumn_index[5
			  + TOTAL_COMPOSITE
			  + TOTAL_MANAGER
			  + TOTAL_ROWCOLUMN];
extern int scale_index[5
		      + TOTAL_COMPOSITE
		      + TOTAL_MANAGER
		      + TOTAL_SCALE];
extern int scrollbar_index[5 
			  + TOTAL_PRIMITIVE 
			  + TOTAL_SCROLLBAR];
extern int scrolledlist_index[5];
extern int scrolledtext_index[5];
extern int scrolledwindow_index[5
			       + TOTAL_COMPOSITE
			       + TOTAL_MANAGER
			       + TOTAL_SCROLLEDWINDOW];
extern int selectionbox_index[5
			     + TOTAL_COMPOSITE
			     + TOTAL_BULLETINBOARD
			     + TOTAL_MANAGER
			     + TOTAL_SELECTIONBOX];
extern int selectiondialog_index[5];
extern int separator_index[5 
			  + TOTAL_PRIMITIVE 
			  + TOTAL_SEPARATOR];
extern int separatorgadget_index[5];
extern int templatedialog_index[5];
extern int text_index[5 
		     + TOTAL_PRIMITIVE 
		     + TOTAL_TEXT];
extern int textfield_index[5 
			  + TOTAL_PRIMITIVE 
			  + TOTAL_TEXTFIELD];
extern int togglebutton_index[5 
			  + TOTAL_PRIMITIVE 
			  + TOTAL_LABEL 
			  + TOTAL_TOGGLEBUTTON];
extern int togglebuttongadget_index[5];
extern int warningdialog_index[5];
extern int workingdialog_index[5];
#endif _PUBLIC_H
