/* WidgetResourceEditor.C */

#include "WidgetResourceEditor.h"
// Super Class : None

/*oodB%WidgetResourceEditor*** Global Declarations and Stuffs ****/
 
/*oodE************************************************************/

WidgetResourceEditor::WidgetResourceEditor()
{
	init();
}

WidgetResourceEditor::~WidgetResourceEditor()
{
	// Empty
}

void WidgetResourceEditor::init(void)
{
        _old_type = last_widget_type_v;
        _is_popped = False;
        _window_type = display_v;
        _old_window_type = display_v;
	create_window();
}

void WidgetResourceEditor::create_window(void)
{
  Arg al[10];
  int ac = 0;
  int index;
  int i = 0;
  char opt_name[MAX_STRING];
  Widget mode[5];
  char * token = NULL;
  XrmValue from_value, to_value;
  int fg, bg;
  DesignEditor * d = guide->get_DesignEditor();
  bool use_pixmap = True;
  bool no_pixmap = False;
  XmString xmstr;
  Widget parent = guide->get_top_widget();
  Factory * _factory = guide->get_Factory();
  Widget prev = NULL;
  Widget menu = NULL;
  Widget pulldown = NULL;
  Widget SW = NULL;
  Widget form1 = NULL;
  Widget form2 = NULL;

  XtSetArg(al[ac],XmNminWidth,441);ac++;
  XtSetArg(al[ac],XmNminHeight,476);ac++;
  _WidgetCoreResource = _factory->create_widget(parent,
					"WidgetCoreResource",
					toplevelshell_v,
					NULL,
					NULL,
					no_callback_v,
					no_pixmap,
					al,ac);
  ac = 0;
  form1 = _factory->create_widget(_WidgetCoreResource,
				 "XmForm",
				 form_v,
				 NULL,
				 NULL,
				 no_callback_v,
				 no_pixmap,
				 al,ac);
  ac = 0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNtopOffset,5);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftOffset,50);ac++;
  xmstr = XmStringCreateLtoR("", (XmStringCharSet)XmFONTLIST_DEFAULT_TAG);
  XtSetArg(al[ac],XmNlabelString,xmstr);ac++;
  menu = _factory->create_widget(form1,
				 "XmOptionMenu",
				 optionmenu_v,
				 NULL,
				 NULL,
				 no_callback_v,
				 no_pixmap,
				 al,ac);
  XmStringFree (xmstr);
  ac = 0;
  pulldown = _factory->create_widget(menu,
					    "XmPulldownMenu",
					    pulldownmenu_v,
					    NULL,
					    NULL,
					    no_callback_v,
					    no_pixmap,
					    al,ac);

  ac = 0;
  XtSetArg(al[ac], XmNsubMenuId,pulldown);ac++;
  XtSetValues(XmOptionButtonGadget(menu),al,ac);
  ac = 0;

  token = get_token("Display,Settings,Callbacks,Drag and Drop,Colors and Pixmaps");
  // create option button for options
  while(token != NULL){
    strcpy(opt_name,token);
    mode[i] = _factory->create_widget(pulldown,
 					    opt_name,
 					    pushbutton_v,
 					    WidgetResourceEditor::set_mode_CB,
 					    (XtPointer) i,
 					    activate_v,
 					    no_pixmap,
 					    al,ac);
    i++;
    ac = 0;
    token = get_token(NULL);
  }
  ac = 0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNtopOffset,60);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNrightAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNbottomOffset,50);ac++;
  XtSetArg(al[ac],XmNscrollingPolicy,XmAUTOMATIC);ac++;
  SW = _factory->create_widget(form1,
				  "XmScrolledWindow",
				  scrolledwindow_v,
				  NULL,
				  NULL,
				  no_callback_v,
				  no_pixmap,
				  al,ac);
  ac = 0;
  _form = _factory->create_widget(SW,
				  "XmForm",
				  form_v,
				  NULL,
				  NULL,
				  no_callback_v,
				  no_pixmap,
				  al,ac);
  ac = 0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_WIDGET);ac++;
  XtSetArg(al[ac],XmNtopWidget,SW);ac++;
  XtSetArg(al[ac],XmNtopOffset,10);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftOffset,20);ac++;
  XtSetArg(al[ac],XmNwidth,70);ac++;
  XtSetArg(al[ac],XmNheight,30);ac++;
 _factory->create_widget(form1,
			 "Apply",
			 pushbutton_v,
			 WidgetResourceEditor::button_CB,
			 (XtPointer) widget_apply_v,
			 activate_v,
			 no_pixmap,
			 al,ac);
  ac = 0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_WIDGET);ac++;
  XtSetArg(al[ac],XmNtopWidget,SW);ac++;
  XtSetArg(al[ac],XmNtopOffset,10);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftOffset,100);ac++;
  XtSetArg(al[ac],XmNwidth,70);ac++;
  XtSetArg(al[ac],XmNheight,30);ac++;
 _factory->create_widget(form1,
			 "Close",
			 pushbutton_v,
			 WidgetResourceEditor::button_CB,
			 (XtPointer) widget_close_v,
			 activate_v,
			 no_pixmap,
			 al,ac);
  ac = 0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_WIDGET);ac++;
  XtSetArg(al[ac],XmNtopWidget,SW);ac++;
  XtSetArg(al[ac],XmNtopOffset,10);ac++;
  XtSetArg(al[ac],XmNrightAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNrightOffset,20);ac++;
  XtSetArg(al[ac],XmNwidth,70);ac++;
  XtSetArg(al[ac],XmNheight,30);ac++;
 _factory->create_widget(form1,
			 "Help",
			 pushbutton_v,
			 WidgetResourceEditor::button_CB,
			 (XtPointer) widget_help_v,
			 activate_v,
			 no_pixmap,
			 al,ac);
  ac = 0;
}

void WidgetResourceEditor::create_form(Widget *prev,resource_rec &res_rec)
{
  Arg al[10];
  int ac = 0;
  int index;
  int i = 0;
  char * token = NULL;
  char opt_name[MAX_STRING];
  XrmValue from_value, to_value;
  int fg, bg;
  DesignEditor * d = guide->get_DesignEditor();
  bool use_pixmap = True;
  bool no_pixmap = False;
  XmString xmstr;
  Widget form = NULL;
  Widget pulldown = NULL;
  Factory * _factory = guide->get_Factory();

  cout << "create_form called \n";

  res_rec.cw = (core_widget_rec *)calloc(1,sizeof(core_widget_rec));
  res_rec.cw->modified = False;

  if(prev == NULL){
    XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
    XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
    XtSetArg(al[ac],XmNrightAttachment,XmATTACH_FORM);ac++;
  }
  else{
    XtSetArg(al[ac],XmNtopAttachment,XmATTACH_WIDGET);ac++;
    XtSetArg(al[ac],XmNtopWidget,*prev);ac++;
    XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
    XtSetArg(al[ac],XmNrightAttachment,XmATTACH_FORM);ac++;
  }
  *prev = res_rec.cw->frame = _factory->create_widget(_form,
				  "XmFrame",
				  frame_v,
				  NULL,
				  NULL,
				  no_callback_v,
				  no_pixmap,
				  al,ac);
  ac = 0;
  form =  _factory->create_widget(*prev,
			   "XmForm",
			   form_v,
			   NULL,
			   NULL,
			   no_callback_v,
			   no_pixmap,
			   al,ac);
  ac = 0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;    
  XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_FORM);ac++;    
  if(!res_rec.tool){
  res_rec.cw->button = _factory->create_widget(form,
				  res_rec.name,
				  label_v,
				  NULL,
				  NULL,
				  no_callback_v,
				  no_pixmap,
				  al,ac);
  }
  else{
  res_rec.cw->button = _factory->create_widget(form,
				  res_rec.name,
				  pushbutton_v,
				  NULL,
				  NULL,
				  no_callback_v,
				  no_pixmap,
				  al,ac);
  }
  ac = 0;
    XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
    XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;    
    XtSetArg(al[ac],XmNleftOffset,200);ac++;
    XtSetArg(al[ac],XmNselectColor,d->get_color("red"));ac++;    
    XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_FORM);ac++;    
    xmstr = XmStringCreateLtoR("", 
				   (XmStringCharSet)XmFONTLIST_DEFAULT_TAG);
    XtSetArg(al[ac],XmNlabelString,xmstr);ac++;
    res_rec.cw->toggle =  _factory->create_widget(form,
			   "XmToggleButton",
			   togglebutton_v,
			   NULL,
			   (XtPointer) NULL,
			   no_callback_v,
			   no_pixmap,
			   al,ac);
    XmStringFree (xmstr);
    
    ac = 0;

    if(res_rec.options != NULL){
      XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
      XtSetArg(al[ac],XmNleftAttachment,XmATTACH_WIDGET);ac++;    
      XtSetArg(al[ac],XmNleftWidget,res_rec.cw->toggle);ac++;    
      XtSetArg(al[ac],XmNleftOffset,15);ac++;
      XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_FORM);ac++;    
      xmstr = XmStringCreateLtoR("", 
				   (XmStringCharSet)XmFONTLIST_DEFAULT_TAG);
      XtSetArg(al[ac],XmNlabelString,xmstr);ac++;
      res_rec.cw->menu =  _factory->create_widget(form,
					    "XmOptionMenu",
					    optionmenu_v,
					    NULL,
					    NULL,
					    no_callback_v,
					    no_pixmap,
					    al,ac);
      XmStringFree (xmstr);
      ac = 0;
      pulldown = _factory->create_widget(res_rec.cw->menu,
					    "XmPulldownMenu",
					    pulldownmenu_v,
					    NULL,
					    NULL,
					    no_callback_v,
					    no_pixmap,
					    al,ac);

      ac = 0;
      XtSetArg(al[ac], XmNsubMenuId,pulldown);ac++;
      XtSetValues(XmOptionButtonGadget(res_rec.cw->menu),al,ac);
      ac = 0;

      token = get_token(res_rec.options);
      // create option button for options
      while(token != NULL){
        strcpy(opt_name,token);
        cout << "        token is : " << opt_name << "\n";
        res_rec.cw->opt[i] = _factory->create_widget(pulldown,
					    opt_name,
					    pushbutton_v,
					    WidgetResourceEditor::option_changed_CB,
					    (XtPointer) &res_rec,
					    activate_v,
					    no_pixmap,
					    al,ac);
        if(strcmp(opt_name,res_rec.default_value)==0){
          ac = 0;
	  XtSetArg(al[ac],XmNmenuHistory,res_rec.cw->opt[i]);ac++;
	  XtSetValues(res_rec.cw->menu,al,ac);
	  ac = 0;
	}
	i++;
        ac = 0;
	token = get_token(NULL);
      }
    }
    else{
      XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
      XtSetArg(al[ac],XmNrightAttachment,XmATTACH_FORM);ac++;
      XtSetArg(al[ac],XmNrightOffset,15);ac++;
      XtSetArg(al[ac],XmNleftAttachment,XmATTACH_WIDGET);ac++;    
      XtSetArg(al[ac],XmNleftWidget,res_rec.cw->toggle);ac++;    
      XtSetArg(al[ac],XmNleftOffset,15);ac++;
      XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_FORM);ac++;
      res_rec.cw->text =  _factory->create_widget(form,
					    "XmText",
					    text_v,
					    WidgetResourceEditor::text_changed_CB,
					    (XtPointer) &res_rec,
					    value_changed_v,
					    no_pixmap,
					    al,ac);
      XmTextSetString(res_rec.cw->text,res_rec.default_value);
      ac = 0;
    }
}

char * WidgetResourceEditor::get_token(char * search_str)
{
  static char ss[MAX_STRING];
  char new_str[MAX_STRING];
  char * begin;
  char * end;
  int i = 0;

  if(search_str != NULL)
    strcpy(ss,search_str);

  if(strlen(ss) == 0)
    return NULL;

  strcpy(new_str,ss);
  begin = &new_str[0];

  // find next token
  while((ss[i] != ',')&&(ss[i] != '\0'))
    i++;
  
  end = &new_str[i];
  if(end[0] != '\0')
    strcpy(ss,&end[1]);
  else
    ss[0] = '\0';

  end[0] = '\0';

  return begin;
}

void WidgetResourceEditor::manage(Widget child)
{
  XtManageChild(child);
}

void WidgetResourceEditor::unmanage(Widget child)
{
  XtUnmanageChild(child);
}

void WidgetResourceEditor::unmanage_all(void)
{
  if(_old_type != last_widget_type_v){
    switch(_old_window_type){
    case display_v:
      remove_display_window();
      break;
    case setting_v:
      remove_setting_window();
      break;
    case callback_v:
      remove_callback_window();
      break;
    case drag_drop_v:
      remove_drag_drop_window();
      break;
    case color_pixmap_v:
      remove_color_pixmap_window();
      break;
    }
  }
}

void WidgetResourceEditor::show_display_window(void)
{
  Arg al[5];
  int ac = 0;
  int index;
  int * resource_index = NULL;
  int num_res = 0;
  int i = 0;
  char * temp = NULL;
  char * token = NULL;
  int menu_item = 0;
  Widget prev = NULL;
  WidgetObj * wc = guide->get_current_widget();

  cout << "show_display_window called \n";

  if((wc != NULL) &&(_is_popped)){
    _old_type = wc->get_type();
    resource_index = get_resource_index();
    num_res = get_number_of_resources();

    cout << "Number of resources = " << num_res << "\n";

    while((resource_index[i] != -1) && (i < num_res)){
      cout << "Name: " << resource_array[resource_index[i]].name << "\n";
      if(resource_array[resource_index[i]].cw == NULL){
        create_form(&prev,resource_array[resource_index[i]]);
      }
      else{
        // need to reset the default values or set values
        temp = wc->get_resource(resource_array[resource_index[i]].name);
        if(temp != NULL){
          // check the type of resource
	  cout << "Found <"
	       << resource_array[resource_index[i]].name  << "> with value <"
	       << temp << ">\n";
          // check if text or options
          if(resource_array[resource_index[i]].options != NULL){
            // option menu - uuh uh
            token = get_token(resource_array[resource_index[i]].options);
            while(token != NULL){
              if(strcmp(token,temp)==0){
		ac = 0;
		XtSetArg(al[ac],XmNmenuHistory,
			 resource_array[resource_index[i]].cw->opt[menu_item]);ac++;
		XtSetValues(resource_array[resource_index[i]].cw->menu,al,ac);		
	      }
              menu_item++;
              token = get_token(NULL);
	    }
	  }
	  else{
	    // text widget
            XmTextSetString(resource_array[resource_index[i]].cw->text,temp);
	  }
	}
	else{
          // set the default value
          // check if text or options
          if(resource_array[resource_index[i]].options != NULL){
            // option menu - uuh uh
            token = get_token(resource_array[resource_index[i]].options);
            while(token != NULL){
              if(strcmp(token,resource_array[resource_index[i]].default_value)==0){
		ac = 0;
		XtSetArg(al[ac],XmNmenuHistory,
			 resource_array[resource_index[i]].cw->opt[menu_item]);ac++;
		XtSetValues(resource_array[resource_index[i]].cw->menu,al,ac);		
	      }
              menu_item++;
              token = get_token(NULL);
	    }
	  }
	  else{
	    // text widget
            XmTextSetString(resource_array[resource_index[i]].cw->text,
			    resource_array[resource_index[i]].default_value);
	  }
	}
        manage(resource_array[resource_index[i]].cw->frame);
      }
      i++;
    }
  }
}

void WidgetResourceEditor::remove_display_window(void)
{
  int i = 0;
  int * resource_index = NULL;
  int num_res = 0;
  WidgetObj * wc = guide->get_current_widget();
  if(wc != NULL){
    _old_type = wc->get_type();
    resource_index = get_resource_index();
    num_res = get_number_of_resources();
    cout << "remove_display_window called \n";

    while((resource_index[i] != -1) && (i < num_res)){
      if(resource_array[resource_index[i]].cw != NULL)
        unmanage(resource_array[resource_index[i]].cw->frame);
      i++;
    }
  }
}

void WidgetResourceEditor::update_display_window(void)
{
  int i = 0;
  int * resource_index = NULL;
  int num_res = 0;
  resource_rec * temp = NULL;
  char * value = NULL;
  WidgetObj * wc = guide->get_current_widget();

  if(wc != NULL){
    _old_type = wc->get_type();
    resource_index = get_resource_index();
    num_res = get_number_of_resources();

    cout << "update_display_window called \n";

    while((resource_index[i] != -1) && (i < num_res)){
      value = wc->get_resource(resource_array[resource_index[i]].name);
      // resource already exists in widget
      if(value){
        // check for option menu
        if(resource_array[resource_index[i]].options) {
	}
        // must be a text field
        else {
          XmTextSetString(resource_array[resource_index[i]].cw->text, value);
	}
      }
      // just set default value
      else{
        // check for option menu
        if(resource_array[resource_index[i]].options) {
	}
        // must be a text field
        else {
          // if this is a dynamic value 
          if(strcmp(resource_array[resource_index[i]].default_value,"Dynamic")==0){
            // get value from widget directly
            XmTextSetString(resource_array[resource_index[i]].cw->text,
			    get_dynamic_value(resource_array[resource_index[i]]));
	  }
	  else{
            XmTextSetString(resource_array[resource_index[i]].cw->text,
	  	  	    resource_array[resource_index[i]].default_value);
	  }
	}
      }
      i++;
    }
  }
}

void WidgetResourceEditor::apply_display_window(void)
{
  int index;
  int * resource_index = NULL;
  int num_res = 0;
  int i = 0;
  Widget prev = NULL;
  WidgetObj * wc = guide->get_current_widget();

  cout << "apply_display_window called \n";

  // find modified resources   
  if((wc != NULL) &&(_is_popped)){
    _old_type = wc->get_type();
    resource_index = get_resource_index();
    num_res = get_number_of_resources();

    while((resource_index[i] != -1) && (i < num_res)){
      if(resource_array[resource_index[i]].cw->modified){
        resource_array[resource_index[i]].cw->modified = False;
	cout << "Found modified resource\n";
      }
      i++;
    }
  }
}


char * WidgetResourceEditor::get_dynamic_value(resource_rec & res)
{
  char * temp = NULL;

  return temp;
}

void WidgetResourceEditor::show_setting_window(void)
{
  Arg al[5];
  int ac = 0;
  int index;
  int * resource_index = NULL;
  int num_res = 0;
  int i = 0;
  char * temp = NULL;
  char * token = NULL;
  int menu_item = 0;
  Widget prev = NULL;
  WidgetObj * wc = guide->get_current_widget();

  cout << "show_setting_window called \n";

  if((wc != NULL) &&(_is_popped)){
    _old_type = wc->get_type();
    resource_index = get_resource_index();
    num_res = get_number_of_resources();

    while(resource_index[i++] != -1);
    cout << "Number of resources = " << num_res << "\n";

    while((resource_index[i] != -1) && (i < num_res)){
      cout << "Name: " << resource_array[resource_index[i]].name << "\n";
      if(resource_array[resource_index[i]].cw == NULL)
        create_form(&prev,resource_array[resource_index[i]]);
      else{
        // need to reset the default values or set values
        temp = wc->get_resource(resource_array[resource_index[i]].name);
        if(temp != NULL){
          // check the type of resource
	  cout << "Found <"
	       << resource_array[resource_index[i]].name  << "> with value <"
	       << temp << ">\n";
          // check if text or options
          if(resource_array[resource_index[i]].options != NULL){
            // option menu - uuh uh
            token = get_token(resource_array[resource_index[i]].options);
            while(token != NULL){
              if(strcmp(token,temp)==0){
		ac = 0;
		XtSetArg(al[ac],XmNmenuHistory,
			 resource_array[resource_index[i]].cw->opt[menu_item]);ac++;
		XtSetValues(resource_array[resource_index[i]].cw->menu,al,ac);		
	      }
              menu_item++;
              token = get_token(NULL);
	    }
	  }
	  else{
	    // text widget
            XmTextSetString(resource_array[resource_index[i]].cw->text,temp);
	  }
	}
	else{
          // set the default value
          // check if text or options
          if(resource_array[resource_index[i]].options != NULL){
            // option menu - uuh uh
            token = get_token(resource_array[resource_index[i]].options);
            while(token != NULL){
              if(strcmp(token,resource_array[resource_index[i]].default_value)==0){
		ac = 0;
		XtSetArg(al[ac],XmNmenuHistory,
			 resource_array[resource_index[i]].cw->opt[menu_item]);ac++;
		XtSetValues(resource_array[resource_index[i]].cw->menu,al,ac);		
	      }
              menu_item++;
              token = get_token(NULL);
	    }
	  }
	  else{
	    // text widget
            XmTextSetString(resource_array[resource_index[i]].cw->text,
			    resource_array[resource_index[i]].default_value);
	  }
	}
        manage(resource_array[resource_index[i]].cw->frame);
      }
      i++;
    }
  }
}

void WidgetResourceEditor::remove_setting_window(void)
{
  int i = 0;
  int * resource_index = NULL;
  int num_res = 0;
  WidgetObj * wc = guide->get_current_widget();
  if(wc != NULL){
    _old_type = wc->get_type();
    resource_index = get_resource_index();
    num_res = get_number_of_resources();
    cout << "remove_setting_window called \n";

    while(resource_index[i++] != -1);

    while((resource_index[i] != -1) && (i < num_res)){
      if(resource_array[resource_index[i]].cw != NULL)
        unmanage(resource_array[resource_index[i]].cw->frame);
      i++;
    }
  }
}

void WidgetResourceEditor::update_setting_window(void)
{
  int i = 0;
  int * resource_index = NULL;
  int num_res = 0;
  resource_rec * temp = NULL;
  char * value = NULL;
  WidgetObj * wc = guide->get_current_widget();

  if(wc != NULL){
    _old_type = wc->get_type();
    resource_index = get_resource_index();
    num_res = get_number_of_resources();

    cout << "update_display_window called \n";

    while(resource_index[i++] != -1);

    while((resource_index[i] != -1) && (i < num_res)){
      value = wc->get_resource(resource_array[resource_index[i]].name);
      // resource already exists in widget
      if(value){
        // check for option menu
        if(resource_array[resource_index[i]].options) {
	}
        // must be a text field
        else {
          XmTextSetString(resource_array[resource_index[i]].cw->text, value);
	}
      }
      // just set default value
      else{
        // check for option menu
        if(resource_array[resource_index[i]].options) {
	}
        // must be a text field
        else {
          // if this is a dynamic value 
          if(strcmp(resource_array[resource_index[i]].default_value,"Dynamic")==0){
            // get value from widget directly
            XmTextSetString(resource_array[resource_index[i]].cw->text,
			    get_dynamic_value(resource_array[resource_index[i]]));
	  }
	  else{
            XmTextSetString(resource_array[resource_index[i]].cw->text,
	  	  	    resource_array[resource_index[i]].default_value);
	  }
	}
      }
      i++;
    }
  }
}

void WidgetResourceEditor::apply_setting_window(void)
{
  int index;
  int * resource_index = NULL;
  int num_res = 0;
  int i = 0;
  Widget prev = NULL;
  WidgetObj * wc = guide->get_current_widget();

  cout << "apply_setting_window called \n";

  // find modified resources   
  if((wc != NULL) &&(_is_popped)){
    _old_type = wc->get_type();
    resource_index = get_resource_index();
    num_res = get_number_of_resources();

    while(resource_index[i++] != -1);

    while((resource_index[i] != -1) && (i < num_res)){
      if(resource_array[resource_index[i]].cw->modified){
        resource_array[resource_index[i]].cw->modified = False;
	cout << "Found modified resource\n";
      }
      i++;
    }
  }
}

void WidgetResourceEditor::show_callback_window(void)
{
  Arg al[5];
  int ac = 0;
  int index;
  int * resource_index = NULL;
  int num_res = 0;
  int i = 0;
  char * temp = NULL;
  char * token = NULL;
  int menu_item = 0;
  Widget prev = NULL;
  WidgetObj * wc = guide->get_current_widget();

  cout << "show_callback_window called \n";

  if((wc != NULL) &&(_is_popped)){
    _old_type = wc->get_type();
    resource_index = get_resource_index();
    num_res = get_number_of_resources();

    while(resource_index[i++] != -1);
    while(resource_index[i++] != -1);

    cout << "Number of resources = " << num_res << "\n";

    while((resource_index[i] != -1) && (i < num_res)){
      cout << "Name: " << resource_array[resource_index[i]].name << "\n";
      if(resource_array[resource_index[i]].cw == NULL)
        create_form(&prev,resource_array[resource_index[i]]);
      else{
        // need to reset the default values or set values
        temp = wc->get_resource(resource_array[resource_index[i]].name);
        if(temp != NULL){
          // check the type of resource
	  cout << "Found <"
	       << resource_array[resource_index[i]].name  << "> with value <"
	       << temp << ">\n";
          // check if text or options
          if(resource_array[resource_index[i]].options != NULL){
            // option menu - uuh uh
            token = get_token(resource_array[resource_index[i]].options);
            while(token != NULL){
              if(strcmp(token,temp)==0){
		ac = 0;
		XtSetArg(al[ac],XmNmenuHistory,
			 resource_array[resource_index[i]].cw->opt[menu_item]);ac++;
		XtSetValues(resource_array[resource_index[i]].cw->menu,al,ac);		
	      }
              menu_item++;
              token = get_token(NULL);
	    }
	  }
	  else{
	    // text widget
            XmTextSetString(resource_array[resource_index[i]].cw->text,temp);
	  }
	}
	else{
          // set the default value
          // check if text or options
          if(resource_array[resource_index[i]].options != NULL){
            // option menu - uuh uh
            token = get_token(resource_array[resource_index[i]].options);
            while(token != NULL){
              if(strcmp(token,resource_array[resource_index[i]].default_value)==0){
		ac = 0;
		XtSetArg(al[ac],XmNmenuHistory,
			 resource_array[resource_index[i]].cw->opt[menu_item]);ac++;
		XtSetValues(resource_array[resource_index[i]].cw->menu,al,ac);		
	      }
              menu_item++;
              token = get_token(NULL);
	    }
	  }
	  else{
	    // text widget
            XmTextSetString(resource_array[resource_index[i]].cw->text,
			    resource_array[resource_index[i]].default_value);
	  }
	}
        manage(resource_array[resource_index[i]].cw->frame);
      }
      i++;
    }
  }
}

void WidgetResourceEditor::remove_callback_window(void)
{
  int i = 0;
  int * resource_index = NULL;
  int num_res = 0;
  WidgetObj * wc = guide->get_current_widget();
  if(wc != NULL){
    _old_type = wc->get_type();
    resource_index = get_resource_index();
    num_res = get_number_of_resources();
    cout << "remove_callback_window called \n";

    while(resource_index[i++] != -1);
    while(resource_index[i++] != -1);

    while((resource_index[i] != -1) && (i < num_res)){
      if(resource_array[resource_index[i]].cw != NULL)
        unmanage(resource_array[resource_index[i]].cw->frame);
      i++;
    }
  }
}

void WidgetResourceEditor::update_callback_window(void)
{
  int i = 0;
  int * resource_index = NULL;
  int num_res = 0;
  resource_rec * temp = NULL;
  char * value = NULL;
  WidgetObj * wc = guide->get_current_widget();

  if(wc != NULL){
    _old_type = wc->get_type();
    resource_index = get_resource_index();
    num_res = get_number_of_resources();

    cout << "update_display_window called \n";

    while(resource_index[i++] != -1);
    while(resource_index[i++] != -1);

    while((resource_index[i] != -1) && (i < num_res)){
      value = wc->get_resource(resource_array[resource_index[i]].name);
      // resource already exists in widget
      if(value){
        // check for option menu
        if(resource_array[resource_index[i]].options) {
	}
        // must be a text field
        else {
          XmTextSetString(resource_array[resource_index[i]].cw->text, value);
	}
      }
      // just set default value
      else{
        // check for option menu
        if(resource_array[resource_index[i]].options) {
	}
        // must be a text field
        else {
          // if this is a dynamic value 
          if(strcmp(resource_array[resource_index[i]].default_value,"Dynamic")==0){
            // get value from widget directly
            XmTextSetString(resource_array[resource_index[i]].cw->text,
			    get_dynamic_value(resource_array[resource_index[i]]));
	  }
	  else{
            XmTextSetString(resource_array[resource_index[i]].cw->text,
	  	  	    resource_array[resource_index[i]].default_value);
	  }
	}
      }
      i++;
    }
  }
}

void WidgetResourceEditor::apply_callback_window(void)
{
  int index;
  int * resource_index = NULL;
  int num_res = 0;
  int i = 0;
  Widget prev = NULL;
  WidgetObj * wc = guide->get_current_widget();

  cout << "apply_callback_window called \n";

  // find modified resources   
  if((wc != NULL) &&(_is_popped)){
    _old_type = wc->get_type();
    resource_index = get_resource_index();
    num_res = get_number_of_resources();

    while(resource_index[i++] != -1);
    while(resource_index[i++] != -1);

    while((resource_index[i] != -1) && (i < num_res)){
      if(resource_array[resource_index[i]].cw->modified){
        resource_array[resource_index[i]].cw->modified = False;
	cout << "Found modified resource\n";
      }
      i++;
    }
  }
}

void WidgetResourceEditor::show_drag_drop_window(void)
{
  Arg al[5];
  int ac = 0;
  int index;
  int * resource_index = NULL;
  int num_res = 0;
  int i = 0;
  char * temp = NULL;
  char * token = NULL;
  int menu_item = 0;
  Widget prev = NULL;
  WidgetObj * wc = guide->get_current_widget();

  cout << "show_drag_drop_window called \n";

  if((wc != NULL) &&(_is_popped)){
    _old_type = wc->get_type();
    resource_index = get_resource_index();
    num_res = get_number_of_resources();

    while(resource_index[i++] != -1);
    while(resource_index[i++] != -1);
    while(resource_index[i++] != -1);

    cout << "Number of resources = " << num_res << "\n";

    while((resource_index[i] != -1) && (i < num_res)){
      cout << "Name: " << resource_array[resource_index[i]].name << "\n";
      if(resource_array[resource_index[i]].cw == NULL)
        create_form(&prev,resource_array[resource_index[i]]);
      else{
        // need to reset the default values or set values
        temp = wc->get_resource(resource_array[resource_index[i]].name);
        if(temp != NULL){
          // check the type of resource
	  cout << "Found <"
	       << resource_array[resource_index[i]].name  << "> with value <"
	       << temp << ">\n";
          // check if text or options
          if(resource_array[resource_index[i]].options != NULL){
            // option menu - uuh uh
            token = get_token(resource_array[resource_index[i]].options);
            while(token != NULL){
              if(strcmp(token,temp)==0){
		ac = 0;
		XtSetArg(al[ac],XmNmenuHistory,
			 resource_array[resource_index[i]].cw->opt[menu_item]);ac++;
		XtSetValues(resource_array[resource_index[i]].cw->menu,al,ac);		
	      }
              menu_item++;
              token = get_token(NULL);
	    }
	  }
	  else{
	    // text widget
            XmTextSetString(resource_array[resource_index[i]].cw->text,temp);
	  }
	}
	else{
          // set the default value
          // check if text or options
          if(resource_array[resource_index[i]].options != NULL){
            // option menu - uuh uh
            token = get_token(resource_array[resource_index[i]].options);
            while(token != NULL){
              if(strcmp(token,resource_array[resource_index[i]].default_value)==0){
		ac = 0;
		XtSetArg(al[ac],XmNmenuHistory,
			 resource_array[resource_index[i]].cw->opt[menu_item]);ac++;
		XtSetValues(resource_array[resource_index[i]].cw->menu,al,ac);		
	      }
              menu_item++;
              token = get_token(NULL);
	    }
	  }
	  else{
	    // text widget
            XmTextSetString(resource_array[resource_index[i]].cw->text,
			    resource_array[resource_index[i]].default_value);
	  }
	}
        manage(resource_array[resource_index[i]].cw->frame);
      }
      i++;
    }
  }
}

void WidgetResourceEditor::remove_drag_drop_window(void)
{
  int i = 0;
  int * resource_index = NULL;
  int num_res = 0;
  WidgetObj * wc = guide->get_current_widget();
  if(wc != NULL){
    _old_type = wc->get_type();
    resource_index = get_resource_index();
    num_res = get_number_of_resources();
    cout << "remove_drag_drop_window called \n";

    while(resource_index[i++] != -1);
    while(resource_index[i++] != -1);
    while(resource_index[i++] != -1);

    while((resource_index[i] != -1) && (i < num_res)){
      if(resource_array[resource_index[i]].cw != NULL)
        unmanage(resource_array[resource_index[i]].cw->frame);
      i++;
    }
  }
}

void WidgetResourceEditor::update_drag_drop_window(void)
{
  int i = 0;
  int * resource_index = NULL;
  int num_res = 0;
  resource_rec * temp = NULL;
  char * value = NULL;
  WidgetObj * wc = guide->get_current_widget();

  if(wc != NULL){
    _old_type = wc->get_type();
    resource_index = get_resource_index();
    num_res = get_number_of_resources();

    cout << "update_display_window called \n";

    while(resource_index[i++] != -1);
    while(resource_index[i++] != -1);
    while(resource_index[i++] != -1);

    while((resource_index[i] != -1) && (i < num_res)){
      value = wc->get_resource(resource_array[resource_index[i]].name);
      // resource already exists in widget
      if(value){
        // check for option menu
        if(resource_array[resource_index[i]].options) {
	}
        // must be a text field
        else {
          XmTextSetString(resource_array[resource_index[i]].cw->text, value);
	}
      }
      // just set default value
      else{
        // check for option menu
        if(resource_array[resource_index[i]].options) {
	}
        // must be a text field
        else {
          // if this is a dynamic value 
          if(strcmp(resource_array[resource_index[i]].default_value,"Dynamic")==0){
            // get value from widget directly
            XmTextSetString(resource_array[resource_index[i]].cw->text,
			    get_dynamic_value(resource_array[resource_index[i]]));
	  }
	  else{
            XmTextSetString(resource_array[resource_index[i]].cw->text,
	  	  	    resource_array[resource_index[i]].default_value);
	  }
	}
      }
      i++;
    }
  }
}

void WidgetResourceEditor::apply_drag_drop_window(void)
{
  int index;
  int * resource_index = NULL;
  int num_res = 0;
  int i = 0;
  Widget prev = NULL;
  WidgetObj * wc = guide->get_current_widget();

  cout << "apply_drag_drop_window called \n";

  // find modified resources   
  if((wc != NULL) &&(_is_popped)){
    _old_type = wc->get_type();
    resource_index = get_resource_index();
    num_res = get_number_of_resources();

    while(resource_index[i++] != -1);
    while(resource_index[i++] != -1);
    while(resource_index[i++] != -1);

    while((resource_index[i] != -1) && (i < num_res)){
      if(resource_array[resource_index[i]].cw->modified){
        resource_array[resource_index[i]].cw->modified = False;
	cout << "Found modified resource\n";
      }
      i++;
    }
  }
}

void WidgetResourceEditor::show_color_pixmap_window(void)
{
  Arg al[5];
  int ac = 0;
  int index;
  int * resource_index = NULL;
  int num_res = 0;
  int i = 0;
  char * temp = NULL;
  char * token = NULL;
  int menu_item = 0;
  Widget prev = NULL;
  WidgetObj * wc = guide->get_current_widget();

  cout << "show_color_pixmap_window called \n";

  if((wc != NULL) &&(_is_popped)){
    _old_type = wc->get_type();
    resource_index = get_resource_index();
    num_res = get_number_of_resources();

    while(resource_index[i++] != -1);
    while(resource_index[i++] != -1);
    while(resource_index[i++] != -1);
    while(resource_index[i++] != -1);

    cout << "Number of resources = " << num_res << "\n";

    while((resource_index[i] != -1) && (i < num_res)){
      cout << "Name: " << resource_array[resource_index[i]].name << "\n";
      if(resource_array[resource_index[i]].cw == NULL)
        create_form(&prev,resource_array[resource_index[i]]);
      else{
        // need to reset the default values or set values
        temp = wc->get_resource(resource_array[resource_index[i]].name);
        if(temp != NULL){
          // check the type of resource
	  cout << "Found <"
	       << resource_array[resource_index[i]].name  << "> with value <"
	       << temp << ">\n";
          // check if text or options
          if(resource_array[resource_index[i]].options != NULL){
            // option menu - uuh uh
            token = get_token(resource_array[resource_index[i]].options);
            while(token != NULL){
              if(strcmp(token,temp)==0){
		ac = 0;
		XtSetArg(al[ac],XmNmenuHistory,
			 resource_array[resource_index[i]].cw->opt[menu_item]);ac++;
		XtSetValues(resource_array[resource_index[i]].cw->menu,al,ac);		
	      }
              menu_item++;
              token = get_token(NULL);
	    }
	  }
	  else{
	    // text widget
            XmTextSetString(resource_array[resource_index[i]].cw->text,temp);
	  }
	}
	else{
          // set the default value
          // check if text or options
          if(resource_array[resource_index[i]].options != NULL){
            // option menu - uuh uh
            token = get_token(resource_array[resource_index[i]].options);
            while(token != NULL){
              if(strcmp(token,resource_array[resource_index[i]].default_value)==0){
		ac = 0;
		XtSetArg(al[ac],XmNmenuHistory,
			 resource_array[resource_index[i]].cw->opt[menu_item]);ac++;
		XtSetValues(resource_array[resource_index[i]].cw->menu,al,ac);		
	      }
              menu_item++;
              token = get_token(NULL);
	    }
	  }
	  else{
	    // text widget
            XmTextSetString(resource_array[resource_index[i]].cw->text,
			    resource_array[resource_index[i]].default_value);
	  }
	}
        manage(resource_array[resource_index[i]].cw->frame);
      }
      i++;
    }
  }
}
void WidgetResourceEditor::remove_color_pixmap_window(void)
{
  int i = 0;
  int * resource_index = NULL;
  int num_res = 0;
  WidgetObj * wc = guide->get_current_widget();
  if(wc != NULL){
    _old_type = wc->get_type();
    resource_index = get_resource_index();
    num_res = get_number_of_resources();
    cout << "remove_color_pixmap_window called \n";

    while(resource_index[i++] != -1);
    while(resource_index[i++] != -1);
    while(resource_index[i++] != -1);
    while(resource_index[i++] != -1);

    while((resource_index[i] != -1) && (i < num_res)){
      if(resource_array[resource_index[i]].cw != NULL)
        unmanage(resource_array[resource_index[i]].cw->frame);
      i++;
    }
  }
}

void WidgetResourceEditor::update_color_pixmap_window(void)
{
  int i = 0;
  int * resource_index = NULL;
  int num_res = 0;
  resource_rec * temp = NULL;
  char * value = NULL;
  WidgetObj * wc = guide->get_current_widget();

  if(wc != NULL){
    _old_type = wc->get_type();
    resource_index = get_resource_index();
    num_res = get_number_of_resources();

    cout << "update_display_window called \n";

    while(resource_index[i++] != -1);
    while(resource_index[i++] != -1);
    while(resource_index[i++] != -1);
    while(resource_index[i++] != -1);

    while((resource_index[i] != -1) && (i < num_res)){
      value = wc->get_resource(resource_array[resource_index[i]].name);
      // resource already exists in widget
      if(value){
        // check for option menu
        if(resource_array[resource_index[i]].options) {
	}
        // must be a text field
        else {
          XmTextSetString(resource_array[resource_index[i]].cw->text, value);
	}
      }
      // just set default value
      else{
        // check for option menu
        if(resource_array[resource_index[i]].options) {
	}
        // must be a text field
        else {
          // if this is a dynamic value 
          if(strcmp(resource_array[resource_index[i]].default_value,"Dynamic")==0){
            // get value from widget directly
            XmTextSetString(resource_array[resource_index[i]].cw->text,
			    get_dynamic_value(resource_array[resource_index[i]]));
	  }
	  else{
            XmTextSetString(resource_array[resource_index[i]].cw->text,
	  	  	    resource_array[resource_index[i]].default_value);
	  }
	}
      }
      i++;
    }
  }
}

void WidgetResourceEditor::apply_color_pixmap_window(void)
{
  int index;
  int * resource_index = NULL;
  int num_res = 0;
  int i = 0;
  Widget prev = NULL;
  WidgetObj * wc = guide->get_current_widget();

  cout << "apply_color_pixmap_window called \n";

  // find modified resources   
  if((wc != NULL) &&(_is_popped)){
    _old_type = wc->get_type();
    resource_index = get_resource_index();
    num_res = get_number_of_resources();

    while(resource_index[i++] != -1);
    while(resource_index[i++] != -1);
    while(resource_index[i++] != -1);
    while(resource_index[i++] != -1);

    while((resource_index[i] != -1) && (i < num_res)){
      if(resource_array[resource_index[i]].cw->modified){
        resource_array[resource_index[i]].cw->modified = False;
	cout << "Found modified resource\n";
      }
      i++;
    }
  }
}

void WidgetResourceEditor::apply(void)
{
  if(_is_popped){
    switch(_window_type){
    case display_v:
      apply_display_window();
      break;
    case setting_v:
      apply_setting_window();
      break;
    case callback_v:
      apply_callback_window();
      break;
    case drag_drop_v:
      apply_drag_drop_window();
      break;
    case color_pixmap_v:
      apply_color_pixmap_window();
      break;
    }
  }
}

void WidgetResourceEditor::update(void)
{
  if(_is_popped){
    switch(_window_type){
    case display_v:
      show_display_window();
      update_display_window();
      break;
    case setting_v:
      show_setting_window();
      update_setting_window();
      break;
    case callback_v:
      show_callback_window();
      update_callback_window();
      break;
    case drag_drop_v:
      show_drag_drop_window();
      update_drag_drop_window();
      break;
    case color_pixmap_v:
      show_color_pixmap_window();
      update_color_pixmap_window();
      break;
    }
  }
}

void WidgetResourceEditor::popup(void)
{
  XtPopup(_WidgetCoreResource,XtGrabNone);
  _is_popped = True;
  update();
}

void WidgetResourceEditor::popdown(void)
{
  XtPopdown(_WidgetCoreResource);
  _is_popped = False;
}

void WidgetResourceEditor::text_changed(resource_rec * res_rec)
{
  char * temp = NULL;
  temp = XmTextGetString(res_rec->cw->text);
  WidgetObj * wc = guide->get_current_widget();

  res_rec->cw->modified = False;

  if(temp != NULL)
    if(strlen(temp) != 0){
      if(strcmp(temp,res_rec->default_value)!=0)
        res_rec->cw->modified = True;
    }  
  XtFree(temp);
}

void WidgetResourceEditor::option_changed(resource_rec * res_rec)
{
  cout << res_rec->name << " option menu has been modified \n";
}


void WidgetResourceEditor::text_changed_CB(Widget w,
				   XtPointer clientdata,
				   XtPointer calldata)
{
  WidgetResourceEditor *wre;
  wre = guide->get_WidgetResourceEditor();

  wre->text_changed((resource_rec *) clientdata);
}

void WidgetResourceEditor::option_changed_CB(Widget w,
				   XtPointer clientdata,
				   XtPointer calldata)
{
  WidgetResourceEditor *wre;
  wre = guide->get_WidgetResourceEditor();

  wre->option_changed((resource_rec *) clientdata);
}

void WidgetResourceEditor::set_mode(window_type_enum mode)
{
  _old_window_type = _window_type;
  _window_type = mode;
  unmanage_all();
  update();
  _old_window_type = _window_type;
}

void WidgetResourceEditor::set_mode_CB(Widget w,
				   XtPointer clientdata,
				   XtPointer calldata)
{
  WidgetResourceEditor *wre;
  wre = guide->get_WidgetResourceEditor();

  wre->set_mode((window_type_enum)clientdata);
}

void WidgetResourceEditor::button_CB(Widget w,
				   XtPointer clientdata,
				   XtPointer calldata)
{
  WidgetResourceEditor *wre;
  wre = guide->get_WidgetResourceEditor();

  switch((widget_menu_enum)clientdata)
  {
  case widget_apply_v:
    wre->apply();
    break;
  case widget_close_v:
    wre->popdown();
    break;
  case widget_help_v:
    break;
  }
}
int WidgetResourceEditor::get_number_of_resources()
{
  switch(_old_type){
  case applicationshell_v:
    return(5 
	   + TOTAL_SHELL 
	   + TOTAL_WMSHELL 
	   + TOTAL_VENDORSHELL 
	   + TOTAL_TOPLEVELSHELL 
	   + TOTAL_COMPOSITE 
	   + TOTAL_APPLICATIONSHELL);
    break;
  case toplevelshell_v:
    return(5  
	   + TOTAL_SHELL 
	   + TOTAL_WMSHELL 
	   + TOTAL_VENDORSHELL 
	   + TOTAL_TOPLEVELSHELL 
	   + TOTAL_COMPOSITE);
    break;
  case arrowbutton_v:
    return(5+ TOTAL_PRIMITIVE
			    + TOTAL_ARROWBUTTON);
    break;
  case arrowbuttongadget_v:
    return(5);
    break;
  case bulletinboard_v:
    return(5
	   + TOTAL_MANAGER
	   + TOTAL_COMPOSITE
	   + TOTAL_BULLETINBOARD);
    break;
  case cascadebutton_v:
    return(5
	   + TOTAL_PRIMITIVE 
	   + TOTAL_LABEL
	   + TOTAL_CASCADEBUTTON);
    break;
  case cascadebuttongadget_v:
    return(5);
    break;
  case command_v:
    return(5
	   + TOTAL_COMPOSITE
	   + TOTAL_BULLETINBOARD
	   + TOTAL_MANAGER
	   + TOTAL_SELECTIONBOX
	   + TOTAL_COMMAND);
    break;
  case dialogshell_v:
    return(5
	   + TOTAL_SHELL 
	   + TOTAL_WMSHELL 
	   + TOTAL_VENDORSHELL 
	   + TOTAL_COMPOSITE 
	   + TOTAL_DIALOGSHELL);
    break;
  case drawingarea_v:
    return(5
	   + TOTAL_COMPOSITE
	   + TOTAL_MANAGER
	   + TOTAL_DRAWINGAREA);
    break;
  case drawnbutton_v:
    return(5
	   + TOTAL_PRIMITIVE 
	   + TOTAL_LABEL
	   + TOTAL_DRAWNBUTTON);
    break;
  case errordialog_v:
    return(5);
    break;
  case fileselectionbox_v:
    return(5
	   + TOTAL_COMPOSITE
	   + TOTAL_BULLETINBOARD
	   + TOTAL_MANAGER
	   + TOTAL_SELECTIONBOX
	   + TOTAL_FILESELECTIONBOX);
    break;
  case form_v:
    return(5
	   + TOTAL_COMPOSITE
	   + TOTAL_BULLETINBOARD
	   + TOTAL_MANAGER
	   + TOTAL_FORM);
    break;
  case formdialog_v:
    return(5);
    break;
  case frame_v:
    return(5 
	   + TOTAL_COMPOSITE
	   + TOTAL_MANAGER
	   + TOTAL_FRAME);
    break;
  case informationdialog_v:
    return(5);
    break;
  case label_v:
    return(5 
	   + TOTAL_PRIMITIVE 
	   + TOTAL_LABEL);
    break;
  case labelgadget_v:
    return(5);
    break;
  case list_v:
    return(5
	   + TOTAL_PRIMITIVE 
	   + TOTAL_LIST);
    break;
  case mainwindow_v:
    return(5
	   + TOTAL_COMPOSITE
	   + TOTAL_SCROLLEDWINDOW
	   + TOTAL_MANAGER
	   + TOTAL_MAINWINDOW);
    break;
  case menubar_v:
    return(5);
    break;
  case messagebox_v:
    return(5
	   + TOTAL_COMPOSITE
	   + TOTAL_BULLETINBOARD
	   + TOTAL_MANAGER
	   + TOTAL_MESSAGEBOX);
    break;
  case optionmenu_v:
    return(5);
    break;
  case panedwindow_v:
    return(5
	   + TOTAL_COMPOSITE
	   + TOTAL_MANAGER
	   + TOTAL_PANEDWINDOW);
    break;
  case popupmenu_v:
    return(5);
    break;
  case promptdialog_v:
    return(5);
    break;
  case pulldownmenu_v:
    return(5);
    break;
  case pushbutton_v:
    return(5 
	   + TOTAL_PRIMITIVE 
	   + TOTAL_LABEL 
	   + TOTAL_PUSHBUTTON);
    break;
  case pushbuttongadget_v:
    return(5);
    break;
  case questiondialog_v:
    return(5);
    break;
  case radiobox_v:
    return(5);
    break;
  case rowcolumn_v:
    return(5
	   + TOTAL_COMPOSITE
	   + TOTAL_MANAGER
	   + TOTAL_ROWCOLUMN);
    break;
  case scale_v:
    return(5
	   + TOTAL_COMPOSITE
	   + TOTAL_MANAGER
	   + TOTAL_SCALE);
    break;
  case scrollbar_v:
    return(5
	   + TOTAL_PRIMITIVE 
	   + TOTAL_SCROLLBAR);
    break;
  case scrolledlist_v:
    return(5);
    break;
  case scrolledtext_v:
    return(5);
    break;
  case scrolledwindow_v:
    return(5
	   + TOTAL_COMPOSITE
	   + TOTAL_MANAGER
	   + TOTAL_SCROLLEDWINDOW);
    break;
  case selectionbox_v:
    return(5
	   + TOTAL_COMPOSITE
	   + TOTAL_BULLETINBOARD
	   + TOTAL_MANAGER
	   + TOTAL_SELECTIONBOX);
    break;
  case selectiondialog_v:
    return(5);
    break;
  case separator_v:
    return(5
	   + TOTAL_PRIMITIVE 
	   + TOTAL_SEPARATOR);
    break;
  case separatorgadget_v:
    return(5);
    break;
  case templatedialog_v:
    return(5);
    break;
  case text_v:
    return(5
	   + TOTAL_PRIMITIVE 
	   + TOTAL_TEXT);
    break;
  case textfield_v:
    return(5
	   + TOTAL_PRIMITIVE 
	   + TOTAL_TEXTFIELD);
    break;
  case togglebutton_v:
    return(5
	   + TOTAL_PRIMITIVE 
	   + TOTAL_LABEL 
	   + TOTAL_TOGGLEBUTTON);
    break;
  case togglebuttongadget_v:
    return(5);
    break;
  case warningdialog_v:
    return(5);
    break;
  case workingdialog_v:
    return(5);
    break;
  default:
   return(0);
  break;
  }
}

int * WidgetResourceEditor::get_resource_index()
{
  switch(_old_type){
  case applicationshell_v:
    return applicationshell_index;
  break;
  case toplevelshell_v:
    return toplevelshell_index;
  break;
  case arrowbutton_v:
    return arrowbutton_index;
  break;
  case arrowbuttongadget_v:
    return arrowbuttongadget_index;
  break;
  case bulletinboard_v:
    return bulletinboard_index;
  break;
  case cascadebutton_v:
    return cascadebutton_index;
  break;
  case cascadebuttongadget_v:
    return cascadebuttongadget_index;
  break;
  case command_v:
    return command_index;
  break;
  case dialogshell_v:
    return dialogshell_index;
  break;
  case drawingarea_v:
    return drawingarea_index;
  break;
  case drawnbutton_v:
    return drawnbutton_index;
  break;
  case errordialog_v:
    return errordialog_index;
  break;
  case fileselectionbox_v:
    return fileselectionbox_index;
  break;
  case form_v:
    return form_index;
  break;
  case formdialog_v:
    return formdialog_index;
  break;
  case frame_v:
    return frame_index;
  break;
  case informationdialog_v:
    return informationdialog_index;
  break;
  case label_v:
    return label_index;
  break;
  case labelgadget_v:
    return labelgadget_index;
  break;
  case list_v:
    return list_index;
  break;
  case mainwindow_v:
    return mainwindow_index;
  break;
  case menubar_v:
    return menubar_index;
  break;
  case messagebox_v:
    return messagebox_index;
  break;
  case optionmenu_v:
    return optionmenu_index;
  break;
  case panedwindow_v:
    return panedwindow_index;
  break;
  case popupmenu_v:
    return popupmenu_index;
  break;
  case promptdialog_v:
    return promptdialog_index;
  break;
  case pulldownmenu_v:
    return pulldownmenu_index;
  break;
  case pushbutton_v:
    return pushbutton_index;
  break;
  case pushbuttongadget_v:
    return pushbuttongadget_index;
  break;
  case questiondialog_v:
    return questiondialog_index;
  break;
  case radiobox_v:
    return radiobox_index;
  break;
  case rowcolumn_v:
    return rowcolumn_index;
  break;
  case scale_v:
     return scale_index;
  break;
 case scrollbar_v:
    return scrollbar_index;
  break;
  case scrolledlist_v:
    return scrolledlist_index;
  break;
  case scrolledtext_v:
    return scrolledtext_index;
  break;
  case scrolledwindow_v:
    return scrolledwindow_index;
  break;
  case selectionbox_v:
    return selectionbox_index;
  break;
  case selectiondialog_v:
    return selectiondialog_index;
  break;
  case separator_v:
    return separator_index;
  break;
  case separatorgadget_v:
    return separatorgadget_index;
  break;
  case templatedialog_v:
    return templatedialog_index;
  break;
  case text_v:
    return text_index;
  break;
  case textfield_v:
    return textfield_index;
  break;
  case togglebutton_v:
    return togglebutton_index;
  break;
  case togglebuttongadget_v:
    return togglebuttongadget_index;
  break;
  case warningdialog_v:
    return warningdialog_index;
  break;
  case workingdialog_v:
    return workingdialog_index;
  break;
  default:
    return NULL;
  break;
  }
}
