/* WidgetObj.h */

#ifndef _WIDGETOBJ_H
#define _WIDGETOBJ_H

#include "Classes.h"

#ifndef DEFAULT_TYPE
#define DEFAULT_TYPE
typedef int DefaultType;
#endif

/*oodB:WidgetObj********** Documentation **************/
// Creation Data : Tue Oct 22 19:00:07 1996
// Programmer : Automatic
// Revised Date :
/* Purpose of Class WidgetObj :
 
*/
/*oodE*************************************************/
/*oodB#WidgetObj*** Some Definitions and Stuffs *******/
#include "public.h"
#include "Guide.h"
#include "PixmapServer.h"
#include "Resource.h"
#include "DesignEditor.h"
#include "List.h"
#include "ListIterator.h"

struct widget_resource_rec {
  char name[MAX_STRING];
  char type[MAX_STRING];
  char value[MAX_STRING];
};
typedef struct widget_resource_rec widget_resource_rec;
/*oodE*************************************************/

class WidgetObj {
	friend bool operator!=(const class WidgetObj & ,const class WidgetObj &);
	friend bool operator==(const class WidgetObj & ,const class WidgetObj &);
private : // data members
	char _name[MAX_STRING];
        char _variable_name[MAX_STRING];
        char _default_variable_name[MAX_STRING];
        char _widget_name[MAX_STRING];
        char _default_widget_name[MAX_STRING];
        selection_enum _selection;
	Widget _w;
	Widget _virtual;
	widget_type_enum _type;
	bool _is_global;
        bool _show_names;
        bool _is_hidden;
	Pixmap _pmap;
	Pixmap _hidden;
	WidgetObj* _parent;
	int _x;
	int _y;
        int _max_children;
        attachment_rec * _attach;
        widget_resource_rec resources[100];
public : // data members
	int index;
	List<WidgetObj> _wlist;
	// Resources needed at creation time
	List<Resource> _Clist;
	// Resources needed before/after creation time
	List<Resource> _Slist;
private : // member functions
	void init(void);
	void display_widget(Widget area);
        void save_C_resources(int tab, ofstream * ofile);
        void save_S_resources(int tab, ofstream * ofile);
        void save_attachments(int tab, ofstream * ofile);
public : // member functions
	~WidgetObj();
	WidgetObj(char* name,widget_type_enum type);
	WidgetObj(char* name,widget_type_enum type,bool unreal);

        // other methods
	void print_core(void);
 	int add_widget(WidgetObj* w);
	void display_widgets(Widget area);
	void draw_tree(Widget w);
        void hide(bool hide);
	WidgetObj* remove_widget(WidgetObj* w);
	void calculate_icon_positions(int x,int y,int& total_x, int& total_y);
	WidgetObj* find_widget(int x,int y);
        WidgetObj* find_form_widget(int x,int y);
        void find_selection(int sx,int sy,int x, int y, int width, int height);
	void default_actions(void);
	void unmap(void);
	void map(void);
	void unmanage(void);
	void manage(void);
        void save(int tab,ofstream *ofile);
        void show_names(bool show);
        void draw_outline(Widget w,GC pgc);
        void draw_attachments(Widget w,GC pgc);
        void draw_positions(Widget w,GC pgc);
        void draw_pin(Widget w,int x, int y);
        void remove_resource(char * name);
        void generate_c_code(ofstream *output);
        void add_extern_c_vars(ofstream *output);
        void add_local_c_vars(ofstream *output);
        void add_global_c_vars(ofstream *output);
        void add_includes(ofstream *output);
        void add_attachments(ofstream *output);
        void add_resources_before(ofstream *output);
        bool add_resources_after(ofstream *output);
        void manage_child(ofstream *output,WidgetObj * wo);
        WidgetObj * find_child(widget_type_enum type);

       // data access methods (get)
	char* get_name(void);
	widget_type_enum get_type(void);
	char* get_type_name(void);
	Widget get_widget(void);
	Widget get_virtual(void);
	Pixmap get_pixmap(void);
	int get_num_children(void);
	int get_x(void);
	int get_y(void);
	WidgetObj* get_parent(void);
        char * get_default_variable_name(void);
        char * get_variable_name(void);
        char * get_default_widget_name(void);
        char * get_widget_name(void);
        selection_enum get_selection(void);
        List<WidgetObj> * get_widget_list(void);
        int get_max_children(void);
        attachment_rec * get_attachment_rec(void);
        char * get_resource(char * name);

        // data access methods (set)
	void set_name(char name[]);
	void set_widget(Widget w);
	void set_virtual(Widget w);
	void set_pixmap(Pixmap pmap);
	void set_x(int x);
	void set_y(int y);
	void set_parent(WidgetObj* p);
        void set_widget_global(bool global);
        void set_variable_name(char * name);
        void set_widget_name(char * name);
        void set_max_children(int max);
        void set_resource(char * name,char * value, char * type);

        // status methods (_is...)
	bool is_global(void);
	bool is_hidden(void);
        bool is_real(void);
};

#endif
