/* WidgetObj.C */

#include "WidgetObj.h"
// Super Class : None

/*oodB%WidgetObj*** Global Declarations and Stuffs ****/
/*oodE*************************************************/

WidgetObj::~WidgetObj()
{
  cout << " deleting " << _name << "\n";
  if(_w)
    XtDestroyWidget(_w);
  _wlist.DeleteAll();
  if(_attach != NULL)
   free(_attach);
}

void WidgetObj::init(void)
{
  PixmapServer * ps = guide->get_PixmapServer();
  static int count;
  if(guide->get_current_interface() == NULL)
    count = 0;
  index = ++count;
  _w = NULL;
  _virtual = NULL;
  _parent = NULL;
  _attach = NULL;
  _x = SPACE/2;
  _y = SPACE/2;
  _is_global = False;
  _is_hidden = False;
  _show_names = True;
  _max_children = 0;
  _selection = none_v;
  _pmap = ps->get_pixmap(_type);
  _hidden = ps->get_pixmap((widget_type_enum)0);

  // set all resources to zero
  for(int i=0;i<100;i++){
    resources[i].name[0] = '\0';
  }
}

void WidgetObj::show_names(bool show)
{
  _show_names = show;
}

void WidgetObj::display_widget(Widget area)
{
  WidgetObj * temp = NULL;

  // create a list iterator
  ListIterator<WidgetObj> iter(_wlist);

  while((temp = iter.CurrentItem())!= NULL)
  {

    if(temp->get_pixmap() != 0){
      XCopyArea(display, temp->get_pixmap(),XtWindow(area),
		gc,0,0,WIDGET_SIZE_X,WIDGET_SIZE_Y,
		temp->get_x(), temp->get_y());
      if(_show_names)
      XDrawString(display,XtWindow(area),font_gc,
		  temp->get_x(),temp->get_y()+SPACE/2,
		  temp->get_widget_name(),strlen(temp->get_widget_name()));
    }

    // check if this widget has children
    temp->display_widget(area);

    iter.GetNext();
  }
}

WidgetObj::WidgetObj(char* name,widget_type_enum type)
{
  _type = type;
  _pmap = XmUNSPECIFIED_PIXMAP;
  init();
  sprintf(_name,"%s",name,index);
  sprintf(_variable_name,"%s_%d",_name,index);
  sprintf(_default_variable_name,"%s_%d",_name,index);
  sprintf(_widget_name,"%s_%d",_name,index);
  sprintf(_default_widget_name,"%s_%d",_name,index);
}

WidgetObj::WidgetObj(char* name,widget_type_enum type,bool unreal)
{
  _type = type;
  _pmap = XmUNSPECIFIED_PIXMAP;
  init();
  sprintf(_name,"%s",name);
  sprintf(_variable_name,"%s_%d",_name,index);
  sprintf(_default_variable_name,"%s_%d",_name,index);
  sprintf(_widget_name,"%s",_name);
  sprintf(_default_widget_name,"%s",_name);
}

WidgetObj * WidgetObj::find_child(widget_type_enum type)
{
  WidgetObj * temp = NULL;

  // create a list iterator
  ListIterator<WidgetObj> iter(_wlist);


  while((temp= iter.CurrentItem()) != NULL)
  {
    if(temp->get_type() == type)
      return temp;
    iter.GetNext();
  }
  return NULL;
}

void WidgetObj::print_core(void)
{
  Widget w;
  if(_w)
   w = _w;
  else
   w = _virtual;

  if(w != NULL){
  cout << "---------------------" << w->core.name << "----------------------------\n";
  cout << "Height = " << w->core.height << "\n";
  cout << "Width = " << w->core.width << "\n";
  cout << "x = " << w->core.x << "\n";
  cout << "y = " << w->core.y << "\n";
  cout << "borderwidth = " << w->core.border_width << "\n";
  cout << "managed = " << (int)w->core.managed << "\n";
  cout << "sensitive = " << (int)w->core.sensitive << "\n";
  cout << "ancestorsensitive = " << (int)w->core.ancestor_sensitive << "\n";
  cout << "visible = " << (int)w->core.visible << "\n";
  cout << "mappedwhenmanaged = " << (int)w->core.mapped_when_managed << "\n";
  }
}

int WidgetObj::add_widget(WidgetObj* w)
{
	_wlist.LinkTail(w);
}

char* WidgetObj::get_name(void)
{
	return _name;
}

void WidgetObj::set_name(char name[])
{
  if(name){
	strcpy(_name,name);
	strcpy(_variable_name,name);
	strcpy(_widget_name,name);
	strcpy(_default_variable_name,name);
	strcpy(_default_widget_name,name);
  }
  else
    cout << "BUGGER... errrorr...\n";
}

widget_type_enum WidgetObj::get_type(void)
{
	return _type;
}

char* WidgetObj::get_type_name(void)
{
	return widget_name[_type];
}

Widget WidgetObj::get_widget(void)
{
  if(_w != NULL)
    return _w;
  else
    return _virtual;
}

void WidgetObj::set_widget(Widget w)
{
	_w = w;
}

Widget WidgetObj::get_virtual(void)
{
	return _virtual;
}

void WidgetObj::set_virtual(Widget w)
{
	_virtual = w;
}

bool WidgetObj::is_global(void)
{
	return _is_global;
}

bool WidgetObj::is_hidden(void)
{
	return _is_hidden;
}

void WidgetObj::hide(bool hide)
{
  _is_hidden = hide;
}

void WidgetObj::set_pixmap(Pixmap pmap)
{
	_pmap = pmap;
}

Pixmap WidgetObj::get_pixmap(void)
{
  if(_is_hidden)
    return _hidden;
  else
    return _pmap;
}

void WidgetObj::display_widgets(Widget area)
{
  XCopyArea(display, get_pixmap(),XtWindow(area),
	    gc,0,0,WIDGET_SIZE_X,WIDGET_SIZE_Y,
	    get_x(), get_y());
  if(_show_names)
  XDrawString(display,XtWindow(area),font_gc,
	      get_x(),get_y()+SPACE/2,
	      get_widget_name(),strlen(get_widget_name()));

  display_widget(area);
}

void WidgetObj::draw_tree(Widget w)
{
  WidgetObj * temp = NULL;
  WidgetObj * prev = NULL;

  // create a list iterator
  ListIterator<WidgetObj> iter(_wlist);
  temp = iter.CurrentItem();

  if(temp != NULL)
    XDrawLine(XtDisplay(w), 
	      XtWindow(w), 
	      gc,
	      get_x()+(WIDGET_SIZE/2),
	      get_y()+WIDGET_SIZE,
	      get_x()+(WIDGET_SIZE/2),
	      get_y()+WIDGET_SIZE+(WIDGET_SPACING/2));

  while((temp = iter.CurrentItem()) != NULL)
  {
    if(prev != NULL)
    XDrawLine(XtDisplay(w), XtWindow(w), gc,
	      prev->get_x()+(WIDGET_SIZE/2),
	      prev->get_y()-(WIDGET_SPACING/2),
	      temp->get_x()+(WIDGET_SIZE/2),
	      temp->get_y()-(WIDGET_SPACING/2));

    temp->draw_tree(w);
    XDrawLine(XtDisplay(w), XtWindow(w), gc,
	      temp->get_x() + WIDGET_SIZE/2,
	      temp->get_y(),
	      temp->get_x() + (WIDGET_SIZE/2),
	      temp->get_y() - (WIDGET_SPACING/2));
    prev = temp;
    iter.GetNext();
  }
}

int WidgetObj::get_num_children(void)
{
	return _wlist.ItemCount();
}

int WidgetObj::get_max_children(void)
{
	return _max_children;
}

void WidgetObj::set_max_children(int max)
{
  _max_children = max;
}

void WidgetObj::set_x(int x)
{
	_x = x;
}

void WidgetObj::set_y(int y)
{
	_y = y;
}

int WidgetObj::get_x(void)
{
	return _x;
}

int WidgetObj::get_y(void)
{
	return _y;
}

WidgetObj* WidgetObj::get_parent(void)
{
	return _parent;
}

WidgetObj* WidgetObj::remove_widget(WidgetObj* w)
{
	return _wlist.UnlinkItem(w);
}

void WidgetObj::set_parent(WidgetObj* p)
{
   _parent = p;

   // check if attachments are needed
  if(p->get_type() == form_v)
  {
    _attach = (attachment_rec *) calloc(1,sizeof(attachment_rec));
  }
}

void WidgetObj::calculate_icon_positions(int x,int y,int& total_x,int& total_y)
{
  WidgetObj * temp = NULL;

  // this carries the total width of the drawing
  total_x = x;
  // create a list iterator
  ListIterator<WidgetObj> iter(_wlist);

  if((y+SPACE) > total_y)
    total_y = y+SPACE;

  while((temp= iter.CurrentItem()) != NULL)
  {

    // check if this widget has children
    temp->calculate_icon_positions(x, y+SPACE, total_x, total_y);

    temp->set_y(y+SPACE);
    temp->set_x((x + total_x) / 2);
    x = total_x + SPACE;
    iter.GetNext();
  }
}

WidgetObj* WidgetObj::find_form_widget(int x,int y)
{
  WidgetObj * temp = NULL;
  Widget w = NULL;
  ListIterator<WidgetObj> iter(_wlist);
  // re-initialize
  _selection = none_v;
  // need to set selection when widget found
  while((temp = iter.CurrentItem()) != NULL)
  {
    w = temp->get_widget();
    if(((w->core.x < x) && (w->core.y < y)) &&
       (((w->core.x + w->core.width) > x) && 
       ((w->core.y + w->core.height) > y)))
    {
      // try to work out where the seletion was - top/bottom/left/right
      temp->find_selection(x,y,w->core.x,w->core.y,w->core.width,w->core.height);
      return temp;
    }
    iter.GetNext();
  }
  return NULL;
}

void WidgetObj::find_selection(int sx,int sy,int x, int y, int width, int height)
{ 
  int nw,nh,new_x,new_y;

  new_y = sy - y;
  new_x = sx - x;

  if((x+width)>(y+height)){

    nw = width/10;
    nh = height/2;

    if(new_y < nh)
      _selection = top_v;
    else
      _selection = bottom_v;
    
    if(new_x < (nw*2))
      _selection = left_v;
    
    if(new_x > (nw*8))
      _selection = right_v;
  }
  else{
    nw = width/2;
    nh = height/10;

    if(new_x < nw)
      _selection = left_v;
    else
      _selection = right_v;
    
    if(new_y < (nh*2))
      _selection = top_v;
    
    if(new_y > (nh*8))
      _selection = bottom_v;
  }
}

WidgetObj* WidgetObj::find_widget(int x,int y)
{
  WidgetObj * temp = NULL;
  WidgetObj * return_widget = NULL;

  if(((x > this->get_x()) && (x < (this->get_x() + SPACE + 4))) &&
       ((y > this->get_y()) && (y < (this->get_y() + SPACE + 4))))
  {
    return_widget = this;
  }
  else
  {    
    // create a list iterator
    ListIterator<WidgetObj> iter(_wlist);

    while((temp= iter.CurrentItem()) != NULL)
    {

      // check if this widget has children
      if(return_widget == NULL)
         return_widget = temp->find_widget(x,y);

      // check if this is the widget we are looking for
      if(((x > temp->get_x()) && (x < (temp->get_x() +SPACE + 4))) &&
       ((y > temp->get_y()) && (y < (temp->get_y() +SPACE + 4))))
      {
        return_widget = temp; 
	cout << "found \n";
      }

      iter.GetNext();
    }
  }

  return return_widget;
}

void WidgetObj::default_actions(void)
{
  if(_parent == NULL){
    manage();
    map();
  }
  else{
  }
}

void WidgetObj::unmap(void)
{
  if(_w)
    XtUnmapWidget(_w);
  else
    XtUnmapWidget(_virtual);
}

void WidgetObj::map(void)
{
  if(_w)
    XtMapWidget(_w);
  else
    XtMapWidget(_virtual);
}

void WidgetObj::unmanage(void)
{
  if(_w)
    XtUnmanageChild(_w);
  else
    XtUnmanageChild(_virtual);
}

void WidgetObj::manage(void)
{
  if(_w)
    XtManageChild(_w);
  else
    XtManageChild(_virtual);
}

void WidgetObj::save(int tab ,ofstream * ofile)
{
  WidgetObj * temp;
  char new_tab[tab+1];
  new_tab[tab] = 0;
  memset(new_tab,' ',tab);

cout << "tab is " << tab << "\n";

  *ofile << new_tab << _w->core.name << ":" << widget_name[_type] << "{\n";

  save_C_resources(tab+2,ofile);
  save_S_resources(tab+2,ofile);
  save_attachments(tab+2,ofile);

  // create a list iterator
  ListIterator<WidgetObj> iter(_wlist);

  while((temp= iter.CurrentItem()) != NULL)
  {
    if(temp->is_real())
      // check if this widget has children
      temp->save((tab+2),ofile);

    iter.GetNext();
  }
  *ofile << new_tab << "}\n";
}

void WidgetObj::save_C_resources(int tab, ofstream * ofile)
{
  Resource * temp;
  char new_tab[tab+1];
  new_tab[tab] = 0;
  memset(new_tab,' ',tab);

  *ofile << new_tab << "C_resources: {\n";

  // create a list iterator
  ListIterator<Resource> iter(_Clist);

  while((temp= iter.CurrentItem()) != NULL)
  {
    // check if this widget has children
    temp->save((tab+2),ofile);

    iter.GetNext();
  }

  *ofile << new_tab << "}\n"; 
}

void WidgetObj::save_S_resources(int tab, ofstream * ofile)
{
  Resource * temp;
  char new_tab[tab+1];
  new_tab[tab] = 0;
  memset(new_tab,' ',tab);

  *ofile << new_tab << "S_resources: {\n";

  // create a list iterator
  ListIterator<Resource> iter(_Clist);

  while((temp= iter.CurrentItem()) != NULL)
  {
    // check if this widget has children
    temp->save((tab+2),ofile);

    iter.GetNext();
  }

  *ofile << new_tab << "}\n"; 
}

void WidgetObj::save_attachments(int tab, ofstream * ofile)
{
}

void WidgetObj::set_widget_global(bool global)
{
  _is_global = global;
}

void WidgetObj::set_variable_name(char * name)
{
  strcpy(_variable_name,name);
}

char * WidgetObj::get_default_variable_name(void)
{
  return _default_variable_name;
}

void WidgetObj::set_widget_name(char * name)
{
  strcpy(_widget_name,name);
}

char * WidgetObj::get_default_widget_name(void)
{
  return _default_widget_name;
}

char * WidgetObj::get_widget_name(void)
{
  return _widget_name;
}

char * WidgetObj::get_variable_name(void)
{
  return _variable_name;
}

bool WidgetObj::is_real(void)
{
  if(_virtual)
    return False;
  else
    return True;
}

List<WidgetObj> * WidgetObj::get_widget_list(void)
{
  return &_wlist;
}

attachment_rec * WidgetObj::get_attachment_rec(void)
{
  return _attach;
}


void WidgetObj::draw_outline(Widget w,GC pgc)
{
  DesignEditor * d = guide->get_DesignEditor();

  XSetForeground(display,pgc,d->get_color("black"));

  XDrawRectangle(display,
		 XtWindow(w),
		 pgc,
		 _w->core.x,
		 _w->core.y,
		 _w->core.width,
		 _w->core.height);

  XSetForeground(display,pgc,d->get_color("white"));

  XDrawRectangle(display,
		 XtWindow(w),
		 pgc,
		 _w->core.x+1,
		 _w->core.y+1,
		 _w->core.width-2,
		 _w->core.height-2);
  XDrawRectangle(display,
		 XtWindow(w),
		 pgc,
		 _w->core.x+2,
		 _w->core.y+2,
		 _w->core.width-4,
		 _w->core.height-4);
}

void WidgetObj::draw_pin(Widget w,int x, int y)
{
  DesignEditor * d = guide->get_DesignEditor();
  Window win;
  win = XtWindow(w);
  
  XSetForeground(display,color_gc,d->get_color("black"));
  XDrawLine(display,win,color_gc,x,y,x+3,y-6);
  XSetForeground(display,color_gc,d->get_color("blue"));
  XDrawArc(display,win,color_gc,x+3-2,y-6-5,7,7,0,360*64);
  XFillArc(display,win,color_gc,x+3-2,y-6-5,6,6,0,360*64);
}

void WidgetObj::draw_attachments(Widget w,GC pgc)
{
  DesignEditor * d = guide->get_DesignEditor();
  Widget form = _parent->get_widget();
  Widget temp = NULL;

  XSetForeground(display,pgc,d->get_color("red"));
  
  switch(_attach->top_attachment){
  case XmATTACH_FORM:
    XDrawLine(display,XtWindow(w),pgc,
              _w->core.x + _w->core.width/2,
              _w->core.y,
              _w->core.x + _w->core.width/2,
              0);
    draw_pin(w,_w->core.x + _w->core.width/2,0);      
  break;
  case XmATTACH_WIDGET:
    temp = (_attach->top_widget)->get_widget();
    XDrawLine(display,XtWindow(w),pgc,
              _w->core.x + _w->core.width/2,
              _w->core.y,
              temp->core.x + 
	      temp->core.width/2,
              temp->core.y + 
	      temp->core.height - 5);
    draw_pin(w, temp->core.x + 
	     temp->core.width/2,
	     temp->core.y + 
	     temp->core.height - 5);      
  break;
  case XmATTACH_OPPOSITE_FORM:
  break;
  case XmATTACH_OPPOSITE_WIDGET:
    temp = (_attach->top_widget)->get_widget();
    XDrawLine(display,XtWindow(w),pgc,
              _w->core.x + _w->core.width/2,
              _w->core.y,
              temp->core.x + 
	      temp->core.width/2,
              temp->core.y + 5);
    draw_pin(w, temp->core.x + 
	     temp->core.width/2,
	     temp->core.y + 5);      
  break;
  case XmATTACH_NONE:
  break;
  case XmATTACH_SELF:
  break;
  case XmATTACH_POSITION:
  break;
  }

  switch(_attach->bottom_attachment){
  case XmATTACH_FORM:
    XDrawLine(display,XtWindow(w),pgc,
              _w->core.x + _w->core.width/2,
              _w->core.y + _w->core.height,
              _w->core.x + _w->core.width/2,
              form->core.height);
    draw_pin(w,_w->core.x + _w->core.width/2,form->core.height);      
  break;
  case XmATTACH_WIDGET:
    temp = (_attach->bottom_widget)->get_widget();
    XDrawLine(display,XtWindow(w),pgc,
              _w->core.x + _w->core.width/2,
              _w->core.y + _w->core.height,
              temp->core.x + 
	      temp->core.width/2,
              temp->core.y + 5);
    draw_pin(w, temp->core.x + 
	     temp->core.width/2,
	     temp->core.y + 5);      
  break;
  case XmATTACH_OPPOSITE_FORM:
  break;
  case XmATTACH_OPPOSITE_WIDGET:
    temp = (_attach->bottom_widget)->get_widget();
    XDrawLine(display,XtWindow(w),pgc,
              _w->core.x + _w->core.width/2,
              _w->core.y + _w->core.height,
              temp->core.x + 
	      temp->core.width/2,
              temp->core.y + 
	     temp->core.height - 5);
    draw_pin(w, temp->core.x + 
	     temp->core.width/2,
	     temp->core.y + 
	     temp->core.height - 5);      
  break;
  case XmATTACH_NONE:
  break;
  case XmATTACH_SELF:
  break;
  case XmATTACH_POSITION:
  break;
  }
  switch(_attach->left_attachment){
  case XmATTACH_FORM:
    XDrawLine(display,XtWindow(w),pgc,
              _w->core.x,
              _w->core.y + _w->core.height/2,
              0,
              _w->core.y + _w->core.height/2);
    draw_pin(w,0,_w->core.y + _w->core.height/2);      
  break;
  case XmATTACH_WIDGET:
    temp = (_attach->left_widget)->get_widget();
    XDrawLine(display,XtWindow(w),pgc,
              _w->core.x,
              _w->core.y + _w->core.height/2,
              temp->core.x + 
	      temp->core.width - 5,
              temp->core.y + 
	      temp->core.height/2);
    draw_pin(w, temp->core.x + 
	     temp->core.width - 5,
	     temp->core.y + 
	     temp->core.height/2 );      
  break;
  case XmATTACH_OPPOSITE_FORM:
  break;
  case XmATTACH_OPPOSITE_WIDGET:
    temp = (_attach->left_widget)->get_widget();
    XDrawLine(display,XtWindow(w),pgc,
              _w->core.x,
              _w->core.y + _w->core.height/2,
              temp->core.x + 5,
              temp->core.y + 
	      temp->core.height/2);
    draw_pin(w, temp->core.x + 5,
	     temp->core.y + 
	     temp->core.height/2 );      
  break;
  case XmATTACH_NONE:
  break;
  case XmATTACH_SELF:
  break;
  case XmATTACH_POSITION:
  break;
  }
  switch(_attach->right_attachment){
  case XmATTACH_FORM:
    XDrawLine(display,XtWindow(w),pgc,
              _w->core.x + _w->core.width,
              _w->core.y + _w->core.height/2,
              form->core.width,
              _w->core.y + _w->core.height/2);
    draw_pin(w,form->core.width,_w->core.y + _w->core.height/2);      
  break;
  case XmATTACH_WIDGET:
    temp = (_attach->right_widget)->get_widget();
    XDrawLine(display,XtWindow(w),pgc,
              _w->core.x + _w->core.width,
              _w->core.y + _w->core.height/2,
              temp->core.x + 5,
              temp->core.y + 
	      temp->core.height/2);
    draw_pin(w, temp->core.x + 5,
	     temp->core.y + 
	     temp->core.height/2 );      
  break;
  case XmATTACH_OPPOSITE_FORM:
  break;
  case XmATTACH_OPPOSITE_WIDGET:
    temp = (_attach->right_widget)->get_widget();
    XDrawLine(display,XtWindow(w),pgc,
              _w->core.x + _w->core.width,
              _w->core.y + _w->core.height/2,
              temp->core.x + 
	      temp->core.width - 5,
              temp->core.y + 
	      temp->core.height/2);
    draw_pin(w, temp->core.x + 
	     temp->core.width - 5,
	     temp->core.y + 
	     temp->core.height/2 );      
  break;
  case XmATTACH_NONE:
  break;
  case XmATTACH_SELF:
  break;
  case XmATTACH_POSITION:
  break;
  }

}

void WidgetObj::draw_positions(Widget w,GC pgc)
{
  DesignEditor * d = guide->get_DesignEditor();

  XSetForeground(display,pgc,d->get_color("blue"));
  
  XSetForeground(display,pgc,d->get_color("white"));
}

selection_enum WidgetObj::get_selection(void)
{
  return _selection;
}

void WidgetObj::remove_resource(char * name)
{
  bool found_slot = False;

  // find resource and clear
  for(int i = 0; i < 100 && !found_slot; i++){
    if(strcmp(resources[i].name,name)==0){
      resources[i].name[0] ='\0';
      resources[i].value[0] ='\0';
      found_slot = True;
    }
  }  
}

void WidgetObj::set_resource(char * name,char * value,char * type)
{
  bool found_slot = False;

  // find an empty slot
  for(int i = 0; i < 100 && !found_slot; i++){
    if(strlen(resources[i].name)==0){
      strcpy(resources[i].name,name);
      strcpy(resources[i].value,value);
      strcpy(resources[i].type,type);
      found_slot = True;
    }
  }  
}

char * WidgetObj::get_resource(char * name)
{
  char * temp = NULL;

  for(int i = 0; i < 100; i++){
    if(strcmp(name,resources[i].name)==0)
      temp = resources[i].value;
  }
  return temp;
}

void WidgetObj::manage_child(ofstream *output,WidgetObj * wo)
{
  char TAB[] = "  ";

  switch(wo->get_type()){
    case applicationshell_v:
      *output << TAB << "ac = 0;\n";
      break;
    case toplevelshell_v:
      *output << TAB << "XtPopup(" << wo->get_variable_name() << ",XtGrabNone);\n";
      *output << TAB << "ac = 0;\n";
      break;
    case pulldownmenu_v:
      *output << TAB << "ac = 0;\n";
      *output << TAB << "XtSetArg(al[ac], XmNsubMenuId,"
	      << wo->get_variable_name()
	      << ");ac++;\n";
      *output << TAB << "XtSetValues(" 
	      << (wo->get_parent())->get_variable_name()
	      << ",al,ac);\n";
      *output << TAB << "ac = 0;\n";
      break;
    case optionmenu_v:
      *output << TAB << "XtManageChild (" << wo->get_variable_name() << ");\n";
      *output << TAB << "ac = 0;\n";
      break;
    case labelgadget_v:
      if((wo->get_parent())->get_type() != optionmenu_v){
        *output << TAB << "XtManageChild (" << wo->get_variable_name() << ");\n";
      }
      else{
        *output << TAB << wo->get_variable_name()
		<< " = XmOptionLabelGadget("
		<< (wo->get_parent())->get_variable_name()
		<< ");\n";
      }
      *output << TAB << "ac = 0;\n";
      break;
    case cascadebuttongadget_v:
      if((wo->get_parent())->get_type() != optionmenu_v){
        *output << TAB << "XtManageChild (" << wo->get_variable_name() << ");\n";
      }
      else{
        *output << TAB << wo->get_variable_name()
		<< " = XmOptionButtonGadget("
		<< (wo->get_parent())->get_variable_name()
		<< ");\n";
      }
      *output << TAB << "ac = 0;\n";
      break;
     case scrollbar_v:
      if(((wo->get_parent())->get_type() == scrolledlist_v) ||
	 ((wo->get_parent())->get_type() == scrolledtext_v) ||
	 ((wo->get_parent())->get_type() == scrolledwindow_v)){
        if(strcmp(wo->get_widget_name(),"HorScrollBar")==0){
	  *output << TAB << "XtSetArg(al[ac],XmNhorizontalScrollBar,&"
		  << wo->get_variable_name() << ");ac++;\n";
	}
	else{
	  *output << TAB << "XtSetArg(al[ac],XmNverticalScrollBar,&"
		  << wo->get_variable_name() << ");ac++;\n";
	}
	*output << TAB << "XtGetValues(" 
		<< (wo->get_parent())->get_variable_name() 
		<< ",al,ac);\n" << TAB << "ac = 0;\n";
      }
      else{
        *output << TAB << "XtManageChild (" << wo->get_variable_name() << ");\n" ;
        *output << TAB << "ac = 0;\n";
      }
      break;
    case list_v:
      if((wo->get_parent())->get_type() == scrolledlist_v){
      }
      else{
        *output << TAB << "XtManageChild (" << wo->get_variable_name() << ");\n" ;
        *output << TAB << "ac = 0;\n";
      }
      break;
    case text_v:
      if((wo->get_parent())->get_type() == scrolledtext_v){
      }
      else {
        *output << TAB << "XtManageChild (" << wo->get_variable_name() << ");\n" ;
        *output << TAB << "ac = 0;\n";
      }
      break;
    default:
      if(wo->is_real()){
        *output << TAB << "XtManageChild (" << wo->get_variable_name() << ");\n";
        *output << TAB << "ac = 0;\n";
      }
      break;
  }
}

void WidgetObj::generate_c_code(ofstream *output)
{
  ListIterator<WidgetObj> iter(_wlist);
  WidgetObj * temp = NULL;
  char code[1024];
  CodeGenerator *cg = guide->get_CodeGenerator();

  add_resources_before(output);
  cg->generate_code(_type,output,this);
  manage_child(output,this);
  if(add_resources_after(output)){
    *output << "  XtSetValues(" << _variable_name << ",al,ac);\n";
    *output << "  ac=0;\n";
  }

  while(temp = iter.CurrentItem()){
    temp->generate_c_code(output);
    iter.GetNext();
  }
}

void WidgetObj::add_global_c_vars(ofstream *output)
{
  ListIterator<WidgetObj> iter(_wlist);
  WidgetObj * temp = NULL;
  
  if(_is_global)
    *output << "Widget " << get_variable_name() << "= (Widget) NULL;\n";

  while(temp = iter.CurrentItem()){
    temp->add_global_c_vars(output);
    iter.GetNext();
  }
}

void WidgetObj::add_local_c_vars(ofstream *output)
{
  ListIterator<WidgetObj> iter(_wlist);
  WidgetObj * temp = NULL;
  
  if(!_is_global)
    *output << "  Widget " << get_variable_name() << "= (Widget) NULL;\n";

  while(temp = iter.CurrentItem()){
    temp->add_local_c_vars(output);
    iter.GetNext();
  }
}

void WidgetObj::add_extern_c_vars(ofstream *output)
{
  ListIterator<WidgetObj> iter(_wlist);
  WidgetObj * temp = NULL;

  if(_is_global)
    *output << "extern Widget " << get_variable_name() << ";\n";

  while(temp = iter.CurrentItem()){
    temp->add_extern_c_vars(output);
    iter.GetNext();
  }
}

void WidgetObj::add_attachments(ofstream *output)
{
  ListIterator<WidgetObj> iter(_wlist);
  WidgetObj * temp = NULL;
  char TAB[] = "  ";

  if(_attach){

    *output << "\n";

    // Top attachments
    if(strcmp(attachment_arr[_attach->top_attachment],"XmATTACH_NONE")!=0){
      *output << TAB << "XtSetArg(al[ac],XmNtopAttachment,"
	      << attachment_arr[_attach->top_attachment] << ");ac++;\n";
      if(_attach->top_widget)
	*output << TAB << "XtSetArg(al[ac],XmNtopWidget,"
		<< (_attach->top_widget)->get_variable_name() << ");ac++;\n";
      *output << TAB << "XtSetArg(al[ac],XmNtopOffset,"
	      << _attach->top_offset << ");ac++;\n";
      *output << TAB << "XtSetArg(al[ac],XmNtopPosition,"
	      << _attach->top_position << ");ac++;\n";   
    }
    // Bottom attachments
    if(strcmp(attachment_arr[_attach->bottom_attachment],"XmATTACH_NONE")!=0){
      *output << TAB << "XtSetArg(al[ac],XmNbottomAttachment,"
	      << attachment_arr[_attach->bottom_attachment] << ");ac++;\n";
      if(_attach->bottom_widget)
	*output << TAB << "XtSetArg(al[ac],XmNbottomWidget,"
		<< (_attach->bottom_widget)->get_variable_name() << ");ac++;\n";
      *output << TAB << "XtSetArg(al[ac],XmNbottomOffset,"
	      << _attach->bottom_offset << ");ac++;\n";
      *output << TAB << "XtSetArg(al[ac],XmNbottomPosition,"
	      << _attach->bottom_position << ");ac++;\n";
    }
    // Left attachments
    if(strcmp(attachment_arr[_attach->left_attachment],"XmATTACH_NONE")!=0){
      *output << TAB << "XtSetArg(al[ac],XmNleftAttachment,"
	      << attachment_arr[_attach->left_attachment] << ");ac++;\n";
      if(_attach->left_widget)
	*output << TAB << "XtSetArg(al[ac],XmNleftWidget,"
		<< (_attach->left_widget)->get_variable_name() << ");ac++;\n";
      *output << TAB << "XtSetArg(al[ac],XmNleftOffset,"
	      << _attach->left_offset << ");ac++;\n";
      *output << TAB << "XtSetArg(al[ac],XmNleftPosition,"
	      << _attach->left_position << ");ac++;\n";
    }
    // Right attachments
    if(strcmp(attachment_arr[_attach->right_attachment],"XmATTACH_NONE")!=0){
      *output << TAB << "XtSetArg(al[ac],XmNrightAttachment,"
	      << attachment_arr[_attach->right_attachment] << ");ac++;\n";
      if(_attach->right_widget)
	*output << TAB << "XtSetArg(al[ac],XmNrightWidget,"
		<< (_attach->right_widget)->get_variable_name() << ");ac++;\n";
      *output << TAB << "XtSetArg(al[ac],XmNrightOffset,"
	      << _attach->right_offset << ");ac++;\n";
      *output << TAB << "XtSetArg(al[ac],XmNrightPosition,"
	      << _attach->right_position << ");ac++;\n";
    }

    // set the new values
    *output << TAB << "XtSetValues(" << _variable_name << ",al,ac);\n";

    *output << TAB << "ac = 0;\n";
  }
  while(temp = iter.CurrentItem()){
    temp->add_attachments(output);
    iter.GetNext();
  }
}

bool WidgetObj::add_resources_after(ofstream *output)
{
  int i = 0;
  char TAB[] = "  ";
  bool resource_found = False;
  bool free_string = False;

  cout << "Add resource after " << _variable_name << "\n";

  for(i=0;i<100;i++){
    if(strlen(resources[i].name)!=0){
      // found a resource
      resource_found = True;

      // check type of resource
      if(strcmp(resources[i].type,"XmRPixmap")==0){
      *output << TAB << "xpm_return = XpmReadFileToPixmap(display,\n"
	      << TAB << TAB << "XDefaultRootWindow(display),\n" 
	      << TAB << TAB << "\""<< resources[i].value << "\",\n"
	      << TAB << TAB << "&new_pixmap,\n"
	      << TAB << TAB << "NULL,\n"
	      << TAB << TAB << "NULL);\n";

      *output <<  "  /* check if valid pixmap */\n";
      *output <<  "  switch(xpm_return)\n";
      *output <<  "  {\n";
      *output <<  "    case XpmOpenFailed:\n";
      *output <<  "      printf(\"Failed to open %s.\\n\",\""
              << resources[i].value <<"\");\n";
      *output <<  "      exit(0);\n";
      *output <<  "    break;\n";
      *output <<  "    case XpmFileInvalid:\n";
      *output <<  "      printf(\"File %s is not a valid XPM format.\\n\",\""
	      << resources[i].value << "\");\n";
      *output <<  "      exit(0);\n";
      *output <<  "    break;\n";
      *output <<  "    case XpmNoMemory:\n";
      *output <<  "      printf(\"Failed to allocate memory.\\n\");\n";
      *output <<  "      exit(0);\n";
      *output <<  "    break;\n";
      *output <<  "    default:\n";
      *output <<  "    break;\n";
      *output <<  "  }\n";

      *output << TAB << "XtSetArg(al[ac], " 
              << resources[i].name << ", " 
              << "new_pixmap);ac++;\n";
      

      }
      else if(strcmp(resources[i].type,"XmRPixel")==0){
	*output << "  from_value.addr = \"" << resources[i].value << "\";\n";
	*output << "  from_value.size = strlen( from_value.addr ) + 1;\n";
	*output << "  to_value.addr = NULL;\n";
	*output << "  XtConvertAndStore (" 
		<< _variable_name
		<< ",\n";
	*output << "		     XmRString, &from_value, \n";
	*output << "		     XmRPixel, &to_value);\n";
	*output << "  if ( to_value.addr )\n";
	*output << "  {\n";
	*output << "    XtSetArg(al[ac]," 
		<< resources[i].name
		<< ",*(int *)to_value.addr);ac++;\n";
	*output << "  }\n";
      }
      else if(strcmp(resources[i].type,"XmRInt")==0){
      }
      else if(strcmp(resources[i].type,"XmRString")==0){
	*output << TAB << "xmstr = XmStringCreateSimple(\""
		<< resources[i].value <<"\");\n";
	*output << TAB << "XtSetArg(al[ac], " 
		<< resources[i].name << ", xmstr);ac++;\n";
	free_string = True;
      }
      else if(strcmp(resources[i].type,"XmRPosition")==0){
      }
      else if(strcmp(resources[i].type,"XmRDimension")==0){
      }
      else if(strcmp(resources[i].type,"XmRColor")==0){
      }
      else if(strcmp(resources[i].type,"XmRBoolean")==0){
      }
      else if(strcmp(resources[i].type,"XmRBool")==0){
      }
      else if(strcmp(resources[i].type,"XmRFloat")==0){
      }
      else if(strcmp(resources[i].type,"XmRShort")==0){
      }
      else if(strcmp(resources[i].type,"XmRUnsignedChar")==0){
      }
      else if(strcmp(resources[i].type,"XmRAtom")==0){
      }
      else if(strcmp(resources[i].type,"XmRCursor")==0){
      }
      else if(strcmp(resources[i].type,"XmRDisplay")==0){
      }
      else if(strcmp(resources[i].type,"XmRFile")==0){
      }
      else if(strcmp(resources[i].type,"XmRFont")==0){
      }
      else if(strcmp(resources[i].type,"XmRFontList")==0){
	*output << TAB << "from_value.addr = \"" << resources[i].value << "\";\n";
	*output << TAB << "from_value.size = strlen( from_value.addr ) + 1;\n";
	*output << TAB << "to_value.addr = NULL;\n";
	*output << TAB << "XtConvertAndStore ("
		<< _variable_name
		<< ",XmRString, &from_value, XmRFontList, &to_value);\n";
	*output << TAB << "if ( to_value.addr )\n";
	*output << TAB << "{\n";
	*output << TAB << TAB << "XtSetArg(al[ac], "
		<< resources[i].name
		<< " , *(unsigned int *)to_value.addr); ac++;\n";
	*output << TAB << "}\n";
      }
      else if(strcmp(resources[i].type,"XmRFontSet")==0){
      }
      else if(strcmp(resources[i].type,"XmRFontStruct")==0){
      }
      else if(strcmp(resources[i].type,"XmRGeometry")==0){
      }
      else if(strcmp(resources[i].type,"XmRInitialState")==0){
      }
      else if(strcmp(resources[i].type,"XmRTranslationTable")==0){
      }
      else if(strcmp(resources[i].type,"XmRVisual")==0){
      }
    }

    if(free_string){
      *output << TAB << "XmStringFree(xmstr);\n";
      free_string = False;
      *output << TAB << "ac = 0;\n";
    }
  }
  return resource_found;
}

void WidgetObj::add_resources_before(ofstream *output)
{
  int i = 0;
  char TAB[] = "  ";
  bool resource_found = False;

  cout << "Add resource before " << _variable_name << "\n";

  for(i=0;i<100;i++){
    if(strlen(resources[i].name)!=0){
      // found a resource
      resource_found = True;

      // check type of resource
      if(strcmp(resources[i].type,"XmRPixmap")==0){
      }
      else if(strcmp(resources[i].type,"XmRPixel")==0){
      }
      else if(strcmp(resources[i].type,"XmRInt")==0){
        *output << TAB << "XtSetArg(al[ac],"
		<< resources[i].name << "," 
		<< resources[i].value << ");ac++;\n";
      }
      else if(strcmp(resources[i].type,"XmRString")==0){
      }
      else if(strcmp(resources[i].type,"XmRPosition")==0){
        *output << TAB << "XtSetArg(al[ac],"
		<< resources[i].name << "," 
		<< resources[i].value << ");ac++;\n";
      }
      else if(strcmp(resources[i].type,"XmRDimension")==0){
        *output << TAB << "XtSetArg(al[ac],"
		<< resources[i].name << "," 
		<< resources[i].value << ");ac++;\n";
      }
      else if(strcmp(resources[i].type,"XmRColor")==0){
      }
      else if(strcmp(resources[i].type,"XmRBoolean")==0){
        *output << TAB << "XtSetArg(al[ac],"
		<< resources[i].name << "," 
		<< resources[i].value << ");ac++;\n";
      }
      else if(strcmp(resources[i].type,"XmRBool")==0){
        *output << TAB << "XtSetArg(al[ac],"
		<< resources[i].name << "," 
		<< resources[i].value << ");ac++;\n";
      }
      else if(strcmp(resources[i].type,"XmRFloat")==0){
        *output << TAB << "XtSetArg(al[ac],"
		<< resources[i].name << "," 
		<< resources[i].value << ");ac++;\n";
      }
      else if(strcmp(resources[i].type,"XmRFont")==0){
      }
      else if(strcmp(resources[i].type,"XmRShort")==0){
        *output << TAB << "XtSetArg(al[ac],"
		<< resources[i].name << "," 
		<< resources[i].value << ");ac++;\n";
      }
      else if(strcmp(resources[i].type,"XmRUnsignedChar")==0){
        *output << TAB << "XtSetArg(al[ac],"
		<< resources[i].name << "," 
		<< resources[i].value << ");ac++;\n";
      }
      else if(strcmp(resources[i].type,"XmRAtom")==0){
      }
      else if(strcmp(resources[i].type,"XmRCursor")==0){
      }
      else if(strcmp(resources[i].type,"XmRDisplay")==0){
      }
      else if(strcmp(resources[i].type,"XmRFile")==0){
      }
      else if(strcmp(resources[i].type,"XmRFontSet")==0){
      }
      else if(strcmp(resources[i].type,"XmRFontStruct")==0){
      }
      else if(strcmp(resources[i].type,"XmRGeometry")==0){
      }
      else if(strcmp(resources[i].type,"XmRInitialState")==0){
      }
      else if(strcmp(resources[i].type,"XmRTranslationTable")==0){
      }
      else if(strcmp(resources[i].type,"XmRVisual")==0){
      }
    }
  }
}

void WidgetObj::add_includes(ofstream *output)
{
  ListIterator<WidgetObj> iter(_wlist);
  WidgetObj * temp = NULL;

  // check if this file is already included
  if(!include_file[_type]){
    *output << include_arr[_type] << "\n";
    include_file[_type] = True;
  }

  while(temp = iter.CurrentItem()){
    temp->add_includes(output);
    iter.GetNext();
  }
}
