/* Resource.C */

#include "Resource.h"
// Super Class : None

/*oodB%Resource*** Global Declarations and Stuffs ****/
/*oodE************************************************/

Resource::Resource()
{
  cout << "Removing Resource " << _full_name << "\n";
}

Resource::Resource(char * name, char * value, int ivalue, Widget w)
{
  init();
  _w = w;
  _name = &name[3];
  _full_name = name;
  _value = value;
  _def_value = NULL;
  _options = NULL;
  _type = NULL;
  _access_method = NULL;
  _ivalue = ivalue;
}

Resource::~Resource()
{
	// Empty
}

void Resource::init()
{
        _w = NULL;
	_name = NULL;
	_full_name = NULL;
	_value = NULL;
        _def_value = NULL;
	_options = NULL;
        _type = NULL;
        _access_method = NULL;
}

int Resource::get_enum(char* name)
{
  int return_value = -1;

  if(strcmp(name,"XmPIXMAP")==0)
    return_value = 1;
  if(strcmp(name,"XmSTRING")==0)
    return_value = 2;

  if(strcmp(name,"XmCHANGE_ALL")==0)
    return_value = 0;
  if(strcmp(name,"XmCHANGE_NONE")==0)
    return_value = 1;
  if(strcmp(name,"XmCHANGE_WIDTH")==0)
    return_value = 2;
  if(strcmp(name,"XmCHANGE_HEIGHT")==0)
    return_value = 3;

  if(strcmp(name,"XmPIXELS")==0)
    return_value = 0;
  if(strcmp(name,"Xm100TH_MILLIMETERS")==0)
    return_value = 1;
  if(strcmp(name,"Xm1000TH_INCHES")==0)
    return_value = 2;
  if(strcmp(name,"Xm100TH_POINTS")==0)
    return_value = 3;
  if(strcmp(name,"Xm100TH_FONT_UNITS")==0)
    return_value = 4;

  if(strcmp(name,"XmDESTROY")==0)
    return_value = 0;
  if(strcmp(name,"XmUNMAP")==0)
    return_value = 1;
  if(strcmp(name,"XmDO_NOTHING")==0)
    return_value = 2;

  if(strcmp(name,"XmEXPLICIT")==0)
    return_value = 0;
  if(strcmp(name,"XmPOINTER")==0)
    return_value = 1;

  if(strcmp(name,"XmNONE")==0)
    return_value = 0;
  if(strcmp(name,"XmTAB_GROUP")==0)
    return_value = 1;
  if(strcmp(name,"XmSTICKY_TAB_GROUP")==0)
    return_value = 2;
  if(strcmp(name,"XmEXCLUSIVE_TAB_GROUP")==0)
    return_value = 3;

  if(strcmp(name,"XmDYNAMIC_DEFAULT_TAB_GROUP")==0)
    return_value = 255;

  if(strcmp(name,"XmBELL")==0)
    return_value = 1;

  if(strcmp(name,"XmNO_ORIENTATION")==0)
    return_value = 0;
  if(strcmp(name,"XmVERTICAL")==0)
    return_value = 1;
  if(strcmp(name,"XmHORIZONTAL")==0)
    return_value = 2;

  if(strcmp(name,"XmWORK_AREA")==0)
    return_value = 0;
  if(strcmp(name,"XmMENU_BAR")==0)
    return_value = 1;
  if(strcmp(name,"XmMENU_PULLDOWN")==0)
    return_value = 2;
  if(strcmp(name,"XmMENU_POPUP")==0)
    return_value = 3;
  if(strcmp(name,"XmMENU_OPTION")==0)
    return_value = 4;

  if(strcmp(name,"XmNO_PACKING")==0)
    return_value = 0;
  if(strcmp(name,"XmPACK_TIGHT")==0)
    return_value = 1;
  if(strcmp(name,"XmPACK_COLUMN")==0)
    return_value = 2;
  if(strcmp(name,"XmPACK_NONE")==0)
    return_value = 3;

  if(strcmp(name,"XmALIGNMENT_BASELINE_TOP")==0)
    return_value = 0;
  if(strcmp(name,"XmALIGNMENT_CENTER")==0)
    return_value = 1;
  if(strcmp(name,"XmALIGNMENT_BASELINE_BOTTOM")==0)
    return_value = 2;
  if(strcmp(name,"XmALIGNMENT_CONTENTS_TOP")==0)
    return_value = 3;
  if(strcmp(name,"XmALIGNMENT_CONTENTS_BOTTOM")==0)
    return_value = 4;

  if(strcmp(name,"XmTEAR_OFF_ENABLED")==0)
    return_value = 0;
  if(strcmp(name,"XmTEAR_OFF_DISABLED")==0)
    return_value = 1;

  if(strcmp(name,"XmUNPOST")==0)
    return_value = 0;
  if(strcmp(name,"XmUNPOST_AND_REPLAY")==0)
    return_value = 1;

  if(strcmp(name,"XmLAST_POSITION")==0)
    return_value = -1;
  if(strcmp(name,"XmFIRST_POSITION")==0)
    return_value = 0;

  if(strcmp(name,"XmALIGNMENT_BEGINNING")==0)
    return_value = 0;
  if(strcmp(name,"XmALIGNMENT_CENTER")==0)
    return_value = 1;
  if(strcmp(name,"XmALIGNMENT_END")==0)
    return_value = 2;

  if(strcmp(name,"XmFRAME_GENERIC_CHILD")==0)
    return_value = 0;
  if(strcmp(name,"XmFRAME_WORKAREA_CHILD")==0)
    return_value = 1;
  if(strcmp(name,"XmFRAME_TITLE_CHILD")==0)
    return_value = 2;

  if(strcmp(name,"XmN_OF_MANY")==0)
    return_value = 1;
  if(strcmp(name,"XmONE_OF_MANY")==0)
    return_value = 2;

  if(strcmp(name,"XmATTACH_NONE")==0)
    return_value = 0;
  if(strcmp(name,"XmATTACH_FORM")==0)
    return_value = 1;
  if(strcmp(name,"XmATTACH_OPPOSITE_FORM")==0)
    return_value = 2;
  if(strcmp(name,"XmATTACH_WIDGET")==0)
    return_value = 3;
  if(strcmp(name,"XmATTACH_OPPOSITE_WIDGET")==0)
    return_value = 4;
  if(strcmp(name,"XmATTACH_POSITION")==0)
    return_value = 5;
  if(strcmp(name,"XmATTACH_SELF")==0)
    return_value = 6;

  if(strcmp(name,"XmRESIZE_NONE")==0)
    return_value = 0;
  if(strcmp(name,"XmRESIZE_GROW")==0)
    return_value = 1;
  if(strcmp(name,"XmRESIZE_ANY")==0)
    return_value = 2;

  if(strcmp(name,"XmCR_NONE")==0)
    return_value = 0;
  if(strcmp(name,"XmCR_HELP")==0)
    return_value = 1;
  if(strcmp(name,"XmCR_VALUE_CHANGED")==0)
    return_value = 2;
  if(strcmp(name,"XmCR_INCREMENT")==0)
    return_value = 3;
  if(strcmp(name,"XmCR_DECREMENT")==0)
    return_value = 4;
  if(strcmp(name,"XmCR_PAGE_INCREMENT")==0)
    return_value = 5;
  if(strcmp(name,"XmCR_PAGE_DECREMENT")==0)
    return_value = 6;
  if(strcmp(name,"XmCR_TO_TOP")==0)
    return_value = 7;
  if(strcmp(name,"XmCR_TO_BOTTOM")==0)
    return_value = 8;
  if(strcmp(name,"XmCR_DRAG")==0)
    return_value = 9;
  if(strcmp(name,"XmCR_ACTIVATE")==0)
    return_value = 10;
  if(strcmp(name,"XmCR_ARM")==0)
    return_value = 11;
  if(strcmp(name,"XmCR_DISARM")==0)
    return_value = 12;

  if(strcmp(name,"XmCR_MAP")==0)
    return_value = 16;
  if(strcmp(name,"XmCR_UNMAP")==0)
    return_value = 17;
  if(strcmp(name,"XmCR_FOCUS")==0)
    return_value = 18;
  if(strcmp(name,"XmCR_LOSING_FOCUS")==0)
    return_value = 19;
  if(strcmp(name,"XmCR_MODIFYING_TEXT_VALUE")==0)
    return_value = 20;
  if(strcmp(name,"XmCR_MOVING_INSERT_CURSOR")==0)
    return_value = 21;
  if(strcmp(name,"XmCR_EXECUTE")==0)
    return_value = 22;
  if(strcmp(name,"XmCR_SINGLE_SELECT")==0)
    return_value = 23;
  if(strcmp(name,"XmCR_MULTIPLE_SELECT")==0)
    return_value = 24;
  if(strcmp(name,"XmCR_EXTENDED_SELECT")==0)
    return_value = 25;
  if(strcmp(name,"XmCR_BROWSE_SELECT")==0)
    return_value = 26;
  if(strcmp(name,"XmCR_DEFAULT_ACTION")==0)
    return_value = 27;
  if(strcmp(name,"XmCR_CLIPBOARD_DATA_REQUEST")==0)
    return_value = 28;
  if(strcmp(name,"XmCR_CLIPBOARD_DATA_DELETE")==0)
    return_value = 29;
  if(strcmp(name,"XmCR_CASCADING")==0)
    return_value = 30;
  if(strcmp(name,"XmCR_OK")==0)
    return_value = 31;
  if(strcmp(name,"XmCR_CANCEL")==0)
    return_value = 32;

  if(strcmp(name,"XmCR_APPLY")==0)
    return_value = 34;
  if(strcmp(name,"XmCR_NO_MATCH")==0)
    return_value = 35;
  if(strcmp(name,"XmCR_COMMAND_ENTERED")==0)
    return_value = 36;
  if(strcmp(name,"XmCR_COMMAND_CHANGED")==0)
    return_value = 37;
  if(strcmp(name,"XmCR_EXPOSE")==0)
    return_value = 38;
  if(strcmp(name,"XmCR_RESIZE")==0)
    return_value = 39;
  if(strcmp(name,"XmCR_INPUT")==0)
    return_value = 40;
  if(strcmp(name,"XmCR_GAIN_PRIMARY")==0)
    return_value = 41;
  if(strcmp(name,"XmCR_LOSE_PRIMARY")==0)
    return_value = 42;
  if(strcmp(name,"XmCR_CREATE")==0)
    return_value = 43;
  if(strcmp(name,"XmCR_TEAR_OFF_ACTIVATE")==0)
    return_value = 44;
  if(strcmp(name,"XmCR_TEAR_OFF_DEACTIVATE")==0)
    return_value = 45;
  if(strcmp(name,"XmCR_OBSCURED_TRAVERSAL")==0)
    return_value = 46;
  if(strcmp(name,"XmCR_PROTOCOLS")==0)
    return_value = 47;
  if(strcmp(name,"XmCR_FOCUS_MOVED")==0)
    return_value = 48;

  if(strcmp(name,"XmMULTICLICK_DISCARD")==0)
    return_value = 0;
  if(strcmp(name,"XmMULTICLICK_KEEP")==0)
    return_value = 1;

  if(strcmp(name,"XmSHADOW_IN")==0)
    return_value = 7;
  if(strcmp(name,"XmSHADOW_OUT")==0)
    return_value = 8;

  if(strcmp(name,"XmARROW_UP")==0)
    return_value = 0;
  if(strcmp(name,"XmARROW_DOWN")==0)
    return_value = 1;
  if(strcmp(name,"XmARROW_LEFT")==0)
    return_value = 2;
  if(strcmp(name,"XmARROW_RIGHT")==0)
    return_value = 3;

  if(strcmp(name,"XmNO_LINE")==0)
    return_value = 0;
  if(strcmp(name,"XmSINGLE_LINE")==0)
    return_value = 1;
  if(strcmp(name,"XmDOUBLE_LINE")==0)
    return_value = 2;
  if(strcmp(name,"XmSINGLE_DASHED_LINE")==0)
    return_value = 3;
  if(strcmp(name,"XmDOUBLE_DASHED_LINE")==0)
    return_value = 4;
  if(strcmp(name,"XmSHADOW_ETCHED_IN")==0)
    return_value = 5;
  if(strcmp(name,"XmSHADOW_ETCHED_OUT")==0)
    return_value = 6;
  if(strcmp(name,"XmSHADOW_ETCHED_IN_DASH")==0)
    return_value = 7;
  if(strcmp(name,"XmSHADOW_ETCHED_OUT_DASH")==0)
    return_value = 8;
  if(strcmp(name,"XmINVALID_SEPARATOR_TYPE")==0)
    return_value = 9;

  if(strcmp(name,"XmWINDOW")==0)
    return_value = 0;
  if(strcmp(name,"XmCURSOR")==0)
    return_value = 2;

  if(strcmp(name,"XmMAX_ON_TOP")==0)
    return_value = 0;
  if(strcmp(name,"XmMAX_ON_BOTTOM")==0)
    return_value = 1;
  if(strcmp(name,"XmMAX_ON_LEFT")==0)
    return_value = 2;
  if(strcmp(name,"XmMAX_ON_RIGHT")==0)
    return_value = 3;

  if(strcmp(name,"XmSINGLE_SELECT")==0)
    return_value = 0;
  if(strcmp(name,"XmMULTIPLE_SELECT")==0)
    return_value = 1;
  if(strcmp(name,"XmEXTENDED_SELECT")==0)
    return_value = 2;
  if(strcmp(name,"XmBROWSE_SELECT")==0)
    return_value = 3;

  if(strcmp(name,"XmSTATIC")==0)
    return_value = 0;
  if(strcmp(name,"XmDYNAMIC")==0)
    return_value = 1;

  if(strcmp(name,"XmVARIABLE")==0)
    return_value = 0;
  if(strcmp(name,"XmCONSTANT")==0)
    return_value = 1;
  if(strcmp(name,"XmRESIZE_IF_POSSIBLE")==0)
    return_value = 2;

  if(strcmp(name,"XmAUTOMATIC")==0)
    return_value = 0;
  if(strcmp(name,"XmAPPLICATION_DEFINED")==0)
    return_value = 1;

  if(strcmp(name,"XmAS_NEEDED")==0)
    return_value = 1;

  if(strcmp(name,"XmTOP_LEFT")==0)
    return_value = 3;
  if(strcmp(name,"XmBOTTOM_LEFT")==0)
    return_value = 2;
  if(strcmp(name,"XmTOP_RIGHT")==0)
    return_value = 1;
  if(strcmp(name,"XmBOTTOM_RIGHT")==0)
    return_value = 0;

  if(strcmp(name,"XmCOMMAND_ABOVE_WORKSPACE")==0)
    return_value = 0;
  if(strcmp(name,"XmCOMMAND_BELOW_WORKSPACE")==0)
    return_value = 1;

  if(strcmp(name,"XmMULTI_LINE_EDIT")==0)
    return_value = 0;
  if(strcmp(name,"XmSINGLE_LINE_EDIT")==0)
    return_value = 1;

  if(strcmp(name,"XmTEXT_FORWARD")==0)
    return_value = 0;
  if(strcmp(name,"XmTEXT_BACKWARD")==0)
    return_value = 1;

  if(strcmp(name,"XmSELECT_POSITION")==0)
    return_value = 0;
  if(strcmp(name,"XmSELECT_WHITESPACE")==0)
    return_value = 1;
  if(strcmp(name,"XmSELECT_WORD")==0)
    return_value = 2;
  if(strcmp(name,"XmSELECT_LINE")==0)
    return_value = 3;
  if(strcmp(name,"XmSELECT_ALL")==0)
    return_value = 4;
  if(strcmp(name,"XmSELECT_PARAGRAPH")==0)
    return_value = 5;

  if(strcmp(name,"XmHIGHLIGHT_NORMAL")==0)
    return_value = 0;
  if(strcmp(name,"XmHIGHLIGHT_SELECTED")==0)
    return_value = 1;
  if(strcmp(name,"XmHIGHLIGHT_SECONDARY_SELECTED")==0)
    return_value = 2;

  if(strcmp(name,"XmCOPY_FAILED")==0)
    return_value = 0;
  if(strcmp(name,"XmCOPY_SUCCEEDED")==0)
    return_value = 1;
  if(strcmp(name,"XmCOPY_TRUNCATED")==0)
    return_value = 2;

  if(strcmp(name,"XmDIALOG_NONE")==0)
    return_value = 0;
  if(strcmp(name,"XmDIALOG_APPLY_BUTTON")==0)
    return_value = 1;
  if(strcmp(name,"XmDIALOG_CANCEL_BUTTON")==0)
    return_value = 2;
  if(strcmp(name,"XmDIALOG_DEFAULT_BUTTON")==0)
    return_value = 3;
  if(strcmp(name,"XmDIALOG_OK_BUTTON")==0)
    return_value = 4;
  if(strcmp(name,"XmDIALOG_FILTER_LABEL")==0)
    return_value = 5;
  if(strcmp(name,"XmDIALOG_FILTER_TEXT")==0)
    return_value = 6;
  if(strcmp(name,"XmDIALOG_HELP_BUTTON")==0)
    return_value = 7;
  if(strcmp(name,"XmDIALOG_LIST")==0)
    return_value = 8;
  if(strcmp(name,"XmDIALOG_LIST_LABEL")==0)
    return_value = 9;
  if(strcmp(name,"XmDIALOG_MESSAGE_LABEL")==0)
    return_value = 10;
  if(strcmp(name,"XmDIALOG_SELECTION_LABEL")==0)
    return_value = 11;
  if(strcmp(name,"XmDIALOG_SYMBOL_LABEL")==0)
    return_value = 12;
  if(strcmp(name,"XmDIALOG_TEXT")==0)
    return_value = 13;
  if(strcmp(name,"XmDIALOG_SEPARATOR")==0)
    return_value = 14;
  if(strcmp(name,"XmDIALOG_DIR_LIST")==0)
    return_value = 15;
  if(strcmp(name,"XmDIALOG_DIR_LIST_LABEL")==0)
    return_value = 16;

  if(strcmp(name,"XmDIALOG_HISTORY_LIST")==0)
    return_value = 8;
  if(strcmp(name,"XmDIALOG_PROMPT_LABEL")==0)
    return_value = 11;
  if(strcmp(name,"XmDIALOG_VALUE_TEXT")==0)
    return_value = 13;
  if(strcmp(name,"XmDIALOG_COMMAND_TEXT")==0)
    return_value = 13;
  if(strcmp(name,"XmDIALOG_FILE_LIST")==0)
    return_value = 8;
  if(strcmp(name,"XmDIALOG_FILE_LIST_LABEL")==0)
    return_value = 9;

  if(strcmp(name,"XmDIALOG_MODELESS")==0)
    return_value = 0;
  if(strcmp(name,"XmDIALOG_PRIMARY_APPLICATION_MODAL")==0)
    return_value = 1;
  if(strcmp(name,"XmDIALOG_FULL_APPLICATION_MODAL")==0)
    return_value = 2;
  if(strcmp(name,"XmDIALOG_SYSTEM_MODAL")==0)
    return_value = 3;

  if(strcmp(name,"XmDIALOG_APPLICATION_MODAL")==0)
    return_value = 1;

  if(strcmp(name,"XmPLACE_TOP")==0)
    return_value = 0;
  if(strcmp(name,"XmPLACE_ABOVE_SELECTION")==0)
    return_value = 1;
  if(strcmp(name,"XmPLACE_BELOW_SELECTION")==0)
    return_value = 2;

  if(strcmp(name,"XmDIALOG_WORK_AREA")==0)
    return_value = 0;
  if(strcmp(name,"XmDIALOG_PROMPT")==0)
    return_value = 1;
  if(strcmp(name,"XmDIALOG_SELECTION")==0)
    return_value = 2;
  if(strcmp(name,"XmDIALOG_COMMAND")==0)
    return_value = 3;
  if(strcmp(name,"XmDIALOG_FILE_SELECTION")==0)
    return_value = 4;

  if(strcmp(name,"XmDIALOG_TEMPLATE")==0)
    return_value = 0;
  if(strcmp(name,"XmDIALOG_ERROR")==0)
    return_value = 1;
  if(strcmp(name,"XmDIALOG_INFORMATION")==0)
    return_value = 2;
  if(strcmp(name,"XmDIALOG_MESSAGE")==0)
    return_value = 3;
  if(strcmp(name,"XmDIALOG_QUESTION")==0)
    return_value = 4;
  if(strcmp(name,"XmDIALOG_WARNING")==0)
    return_value = 5;
  if(strcmp(name,"XmDIALOG_WORKING")==0)
    return_value = 6;

  if(strcmp(name,"XmVISIBILITY_UNOBSCURED")==0)
    return_value = 0;
  if(strcmp(name,"XmVISIBILITY_PARTIALLY_OBSCURED")==0)
    return_value = 1;
  if(strcmp(name,"XmVISIBILITY_FULLY_OBSCURED")==0)
    return_value = 2;

  if(strcmp(name,"XmTRAVERSE_CURRENT")==0)
    return_value = 0;
  if(strcmp(name,"XmTRAVERSE_NEXT")==0)
    return_value = 1;
  if(strcmp(name,"XmTRAVERSE_PREV")==0)
    return_value = 2;
  if(strcmp(name,"XmTRAVERSE_HOME")==0)
    return_value = 3;
  if(strcmp(name,"XmTRAVERSE_NEXT_TAB_GROUP")==0)
    return_value = 4;
  if(strcmp(name,"XmTRAVERSE_PREV_TAB_GROUP")==0)
    return_value = 5;
  if(strcmp(name,"XmTRAVERSE_UP")==0)
    return_value = 6;
  if(strcmp(name,"XmTRAVERSE_DOWN")==0)
    return_value = 7;
  if(strcmp(name,"XmTRAVERSE_LEFT")==0)
    return_value = 8;
  if(strcmp(name,"XmTRAVERSE_RIGHT")==0)
    return_value = 9;

  if(strcmp(name,"XmPUSHBUTTON")==0)
    return_value = 1;
  if(strcmp(name,"XmTOGGLEBUTTON")==0)
    return_value = 2;
  if(strcmp(name,"XmRADIOBUTTON")==0)
    return_value = 3;
  if(strcmp(name,"XmCASCADEBUTTON")==0)
    return_value = 4;
  if(strcmp(name,"XmSEPARATOR")==0)
    return_value = 5;
  if(strcmp(name,"XmDOUBLE_SEPARATOR")==0)
    return_value = 6;
  if(strcmp(name,"XmTITLE")==0)
    return_value = 7;
  if(strcmp(name,"XmCHECKBUTTON")==0)
    return_value = 2;

  return (return_value);
}

Resource::Resource(Widget w,resource_rec* rec)
{
  //struct resource_rec {
  //  char *name;
  //  char *default_value;
  //  char *value;
  //  char *options;
  //  char *type;
  //  int tool;
  //  void (*callback)();
  //  XtPointer callbackdata;
  //};
  // empty
  init();
  _w = w;
  _full_name = rec->name;
  _name = &_full_name[3];
  _value = rec->value;
  _def_value = rec->default_value;
  _options = rec->options;
  _tool = rec->tool;
  _type = rec->type;
  _access_method = rec->access_method;
  // if(rec->callback != NULL)
  //   _callback = new Callback(rec->callback,rec->callbackdata);
}

char* Resource::get_name() const
{
	return(_name);
}

char* Resource::get_full_name() const
{
	return(_full_name);
}

char* Resource::get_value() const
{
	return(_value);
}

char* Resource::get_def_value() const
{
	return(_def_value);
}

int Resource::get_tool() const
{
	return _tool;
}

char* Resource::get_type() const
{
	return _type;
}

char* Resource::get_options() const
{
	return(_options);
}

void Resource::set_args(Arg al[],int& ac)
{
  XrmValue from_value, to_value; /* For resource conversion */
  from_value.addr = _value;
  from_value.size = strlen( from_value.addr ) + 1;
  to_value.addr = NULL;
  XtConvertAndStore (_w,XmRString, &from_value, _type, &to_value);
  if ( to_value.addr )
  {
    XtSetArg(al[ac], _name , *(unsigned int *)to_value.addr); ac++;
  }
}

void Resource::save(int tab, ofstream * ofile)
{
  char new_tab[tab+1];
  new_tab[tab] = 0;
  memset(new_tab,' ',tab);

  *ofile << new_tab << _full_name << ":" << _value << "\n";
}

void Resource::set_value(char * new_value)
{
  _value = new_value;
}

void Resource::set_ivalue(int new_ivalue)
{
  _ivalue = new_ivalue;
}

void Resource::set_widget(Widget new_widget)
{
  _w = new_widget;
}
