/* OptionEditor.h */

#ifndef _OPTIONEDITOR_H
#define _OPTIONEDITOR_H

#include "Classes.h"

#ifndef DEFAULT_TYPE
#define DEFAULT_TYPE
typedef int DefaultType;
#endif

/*oodB:OptionEditor********** Documentation **************/
// Creation Data : Tue Oct 29 18:40:37 1996
// Programmer : Automatic
// Revised Date :
/* Purpose of Class OptionEditor :
 
*/
/*oodE****************************************************/
/*oodB#OptionEditor*** Some Definitions and Stuffs *******/
#include "public.h"
#include "Factory.h"
#include "Guide.h"
#include "DesignEditor.h"

enum option_menu_enum {
  // File menu
  option_save_v,
  option_default_v,
  option_layout_v,
  option_close_v,
  // Options menu
  option_code_v,
  option_preference_v,
  option_install_v,
  // Help menu
  option_help_v
};
typedef enum option_menu_enum option_menu_enum;
enum option_code_enum {
  code_motif_lib_v,
  code_motif_static_v,
  code_Xt_lib_v,
  code_Xt_static_v,
  code_X11_lib_v,
  code_X11_static_v,
  code_includes_v,
  code_c_compiler_v,
  code_c_flags_v,
  code_cpp_compiler_v,
  code_cpp_flags_v,
  code_callback_v,
  code_event_v,
  code_public_v,
  code_pixmap_v,
  code_project_v,
  code_resource_v,
  code_last_v
};
typedef enum option_code_enum option_code_enum;
/*oodE****************************************************/
class OptionEditor {

private : // data members
	Widget _Option;
	Widget _frame;
	Widget _current;
	Widget _option_code;
	Widget _option_install;
	Widget _option_preference;
	Widget _code_callback_name;
	Widget _code_event_name;
	Widget _code_public_name;
	Widget _code_project_directory;
	Widget _code_pixmap_directory;
	Widget _code_resource_directory;
	Widget _code_motif_lib;
	Widget _code_motif_static;
	Widget _code_Xt_lib;
	Widget _code_Xt_static;
	Widget _code_X11_lib;
	Widget _code_X11_static;
	Widget _code_includes;
	Widget _code_c_compiler;
	Widget _code_c_flags;
	Widget _code_cpp_compiler;
	Widget _code_cpp_flags;
	option_rec _new_options;
	Factory* _factory;
protected : // member functions
	void init();
	void build_option_window();
        void write_options_file(option_rec opt);
        void write_layout_file(layout_rec lay);
        Widget create_code(void);
        Widget create_install(void);
        Widget create_preference(void);
        void update(void);
        void read_options(void);
public : // member functions
	OptionEditor();
	~OptionEditor();
	static void menu_button_CB(Widget w,XtPointer clientdata,XtPointer calldata);
	static void code_setting_CB(Widget w,XtPointer clientdata,XtPointer calldata);
	void popup(void);
	void popdown(void);
	void map_code_generation(void);
	void map_preferences(void);
	void map_installation(void);
	void save_options(void);
	void reset_default_options(void);
	void save_layout(void);
	void help(void);
        option_rec * get_options(void);
	void set_callback_name(void);
	void set_event_name(void);
	void set_public_name(void);
	void set_pixmap_dir(void);
	void set_project_dir(void);
	void set_resource_name(void);
	void set_motif_lib(void);
	void set_motif_static(void);
	void set_Xt_lib(void);
	void set_Xt_static(void);
	void set_X11_lib(void);
	void set_X11_static(void);
	void set_includes(void);
	void set_c_compiler(void);
	void set_c_flags(void);
	void set_cpp_compiler(void);
	void set_cpp_flags(void);
};

#endif
