/* OptionEditor.C */

#include "OptionEditor.h"
// Super Class : None

/*oodB%OptionEditor*** Global Declarations and Stuffs ****/
 
/*oodE****************************************************/

OptionEditor::OptionEditor()
{
	init();
}

OptionEditor::~OptionEditor()
{
	// Empty
}

void OptionEditor::init()
{
  _current = NULL;
  _option_code = NULL;
  _option_install = NULL;
  _option_preference = NULL;
  _new_options.event_filename[0] = '\0';
  _new_options.callback_filename[0] = '\0';
  _new_options.public_filename[0] = '\0';
  _new_options.resource_directory[0] = '\0';
  _new_options.project_directory[0] = '\0';
  _new_options.pixmap_directory[0] = '\0';
  _new_options.motif_lib[0] = '\0';
  _new_options.motif_static = False;
  _new_options.xt_lib[0] = '\0';
  _new_options.xt_static = False;
  _new_options.x11_lib[0] = '\0';
  _new_options.x11_static = False;
  _new_options.includes[0] = '\0';
  _new_options.c_compiler[0] = '\0';
  _new_options.c_flags[0] = '\0';
  _new_options.cpp_compiler[0] = '\0';
  _new_options.cpp_flags[0] = '\0';
  read_options();
  build_option_window();
}

void OptionEditor::build_option_window()
{
  Arg al[50];
  int ac = 0;
  bool no_pixmap = False;
  _factory = guide->get_Factory();
  Widget form = NULL;
  Widget menu = NULL;
  Widget pullmenu = NULL;
  Widget cascade = NULL;

  XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
  XtSetArg(al[ac], XmNdeleteResponse, XmUNMAP); ac++;
  if(guide->layout_found){
    XtSetArg(al[ac], XmNx, new_layout.Option_x); ac++;
    XtSetArg(al[ac], XmNy, new_layout.Option_y); ac++;
  }
  _Option = _factory->create_widget(guide->get_top_widget(),
				    "Option Editor",
				    toplevelshell_v,
				    NULL,
				    NULL,
				    no_callback_v,
				    no_pixmap,
				    al,ac);
    ac = 0;
    XtSetArg(al[ac], XmNautoUnmanage, FALSE); ac++;
    form = _factory->create_widget(_Option,
				   "XmForm",
				   form_v,
				   NULL,
				   NULL,
				   no_callback_v,
				   no_pixmap,
				   al,ac);
      ac = 0;
      XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
      XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
      XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
      menu = _factory->create_widget(form,
				     "XmMenuBar",
				     menubar_v,
				     NULL,
				     NULL,
				     no_callback_v,
				     no_pixmap,
				     al,ac);
      ac = 0;
      cascade = _factory->create_widget(menu,
					"File",
					cascadebutton_v,
					NULL,
					NULL,
					no_callback_v,
					no_pixmap,
					al,ac);
      ac = 0;
      pullmenu = _factory->create_widget(cascade,"XmPulldownMenu",pulldownmenu_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
     XtSetArg(al[ac], XmNsubMenuId,pullmenu);ac++;
     XtSetValues(cascade,al,ac);
        ac = 0;
        _factory->create_widget(pullmenu,"Save Options",pushbutton_v,OptionEditor::menu_button_CB,(XtPointer)option_save_v,activate_v,no_pixmap,al,ac);
        ac = 0;
        _factory->create_widget(pullmenu,"Set Default Options",pushbutton_v,OptionEditor::menu_button_CB,(XtPointer)option_default_v,activate_v,no_pixmap,al,ac);
        ac = 0;
        _factory->create_widget(pullmenu,"Save Layout",pushbutton_v,OptionEditor::menu_button_CB,(XtPointer)option_layout_v,activate_v,no_pixmap,al,ac);
        ac = 0;
        _factory->create_widget(pullmenu,"Close",pushbutton_v,OptionEditor::menu_button_CB,(XtPointer)option_close_v,activate_v,no_pixmap,al,ac);
        ac = 0;
      cascade = _factory->create_widget(menu,"Options",cascadebutton_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
      ac = 0;
      pullmenu = _factory->create_widget(cascade,"XmPulldownMenu",pulldownmenu_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
     XtSetArg(al[ac], XmNsubMenuId,pullmenu);ac++;
     XtSetValues(cascade,al,ac);
        ac = 0;
        _factory->create_widget(pullmenu,"Code Generation",pushbutton_v,OptionEditor::menu_button_CB,(XtPointer)option_code_v,activate_v,no_pixmap,al,ac);
        ac = 0;
        _factory->create_widget(pullmenu,"Installation",pushbutton_v,OptionEditor::menu_button_CB,(XtPointer)option_install_v,activate_v,no_pixmap,al,ac);
        ac = 0;
        _factory->create_widget(pullmenu,"Preferences",pushbutton_v,OptionEditor::menu_button_CB,(XtPointer)option_preference_v,activate_v,no_pixmap,al,ac);
        ac = 0;
      cascade = _factory->create_widget(menu,"Help",cascadebutton_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
      ac = 0;
      XtSetArg(al[ac],XmNmenuHelpWidget,cascade);ac++;
      XtSetValues(menu,al,ac);
      ac = 0;
      pullmenu = _factory->create_widget(cascade,"XmPulldownMenu",pulldownmenu_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
     XtSetArg(al[ac], XmNsubMenuId,pullmenu);ac++;
     XtSetValues(cascade,al,ac);
        ac = 0;
        _factory->create_widget(pullmenu,"On Window",pushbutton_v,OptionEditor::menu_button_CB,(XtPointer)option_help_v,activate_v,no_pixmap,al,ac);
      ac = 0;
      XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
      XtSetArg(al[ac], XmNtopWidget, menu); ac++;
      XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
      XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
      XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
      _frame = _factory->create_widget(form,"XmFrame",frame_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
      ac = 0;
}

void OptionEditor::code_setting_CB(Widget w,XtPointer clientdata,XtPointer calldata)
{
  OptionEditor *oe;
  oe = guide->get_OptionEditor();

  switch((option_code_enum) clientdata){
    case code_motif_lib_v:
      oe->set_motif_lib();
      break;
    case code_motif_static_v:
      oe->set_motif_static();
      break;
    case code_Xt_lib_v:
      oe->set_Xt_lib();
      break;
    case code_Xt_static_v:
      oe->set_Xt_static();
      break;
    case code_X11_lib_v:
      oe->set_X11_lib();
      break;
    case code_X11_static_v:
      oe->set_X11_static();
      break;
    case code_includes_v:
      oe->set_includes();
      break;
    case code_c_compiler_v:
      oe->set_c_compiler();
      break;
    case code_c_flags_v:
      oe->set_c_flags();
      break;
    case code_cpp_compiler_v:
      oe->set_cpp_compiler();
      break;
    case code_cpp_flags_v:
      oe->set_cpp_flags();
      break;
    case code_callback_v:
       oe->set_callback_name();
      break;
    case code_event_v:
       oe->set_event_name();
      break;
    case code_public_v:
       oe->set_public_name();
      break;
    case code_pixmap_v:
       oe->set_pixmap_dir();
      break;
    case code_project_v:
       oe->set_project_dir();
      break;
    case code_resource_v:
       oe->set_resource_name();
      break;
    case code_last_v:
      break;
  }
}

void OptionEditor::menu_button_CB(Widget w,XtPointer clientdata,XtPointer calldata)
{
  OptionEditor *oe;
  oe = guide->get_OptionEditor();

  switch((option_menu_enum) clientdata)
  {
    // File Menu
    case option_save_v:
    oe->save_options();
    break;
    case option_default_v:
    oe->reset_default_options();
    break;
    case option_layout_v:
    oe->save_layout();
    break;
    case option_close_v:
    oe->popdown();
    break;
    // Options menu
    case option_code_v:
    oe->map_code_generation();
    break;
    case option_preference_v:
    oe->map_preferences();
    break;
    case option_install_v:
    oe->map_installation();
    break;
    // Help menu
    case option_help_v:
    oe->help();
    break;
  }
}

void OptionEditor::popup(void)
{
	XtPopup(_Option,XtGrabNone);
}

void OptionEditor::popdown(void)
{
	XtPopdown(_Option);
}

void OptionEditor::map_code_generation(void)
{
  if(_current != NULL)
    XtUnmapWidget(_current);
  
  if(_option_code != NULL)
  {
    XtMapWidget(_option_code);
  }
  else
  {
    _option_code = create_code();
  }
  _current = _option_code;
  update();
}

void OptionEditor::map_preferences(void)
{
  if(_current != NULL)
    XtUnmapWidget(_current);
  
  if(_option_preference != NULL)
  {
    XtMapWidget(_option_preference);
  }
  else
  {
    _option_preference = create_preference();
  }
  _current = _option_preference;
  update();
}

void OptionEditor::map_installation(void)
{
  if(_current != NULL)
    XtUnmapWidget(_current);
  
  if(_option_install != NULL)
  {
    XtMapWidget(_option_install);
  }
  else
  {
    _option_install = create_install();
  }
  _current = _option_install;
  update();
}

void OptionEditor::save_options(void)
{
  write_options_file(_new_options);
  popdown();
}

void OptionEditor::reset_default_options(void)
{
  write_options_file(default_options);
  popdown();
}

void OptionEditor::save_layout(void)
{
  Arg al[5];
  int ac = 0 ;
  DesignEditor * d = guide->get_DesignEditor();

  XtSetArg(al[ac], XmNx, &new_layout.Option_x); ac++;
  XtSetArg(al[ac], XmNy, &new_layout.Option_y); ac++;
  XtGetValues(_Option,al,ac);

  d->save_layout();
  guide->save_layout();

  write_layout_file(new_layout);
  popdown();
}

void OptionEditor::help(void)
{
	// Empty
}

void OptionEditor::write_options_file(option_rec opt)
{
  ofstream ofile(".guide_options");

  if(ofile != NULL){
   ofile.write((char *) &opt, sizeof(option_rec));
  }
  else {
    cout << " Couldn't open file <.guide.options>\n";
  }
}

void OptionEditor::write_layout_file(layout_rec lay)
{
  ofstream ofile(".guide_layout");

  if(ofile != NULL){
   ofile.write((char *) &lay, sizeof(layout_rec));
  }
  else {
    cout << " Couldn't open file <.guide.layout>\n";
  }
}

Widget OptionEditor::create_code()
{
  Arg al[10];
  int ac = 0;
  bool no_pixmap = False;
  Widget code = NULL;
  Widget frame = NULL;
  Widget form = NULL;
  Widget label = NULL;

  code = _factory->create_widget(_frame,"Code",
			  form_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  //----------------------------------------------------------------------
  ac=0; 
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  frame =  _factory->create_widget(code,"XmFrame",
			  frame_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0; 
  form = _factory->create_widget(frame,"XmForm",
			  form_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  label = _factory->create_widget(form,"Callback Filename",
			  label_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftOffset,180);ac++;
  _code_callback_name = _factory->create_widget(form,
						"XmText",
						text_v,
						OptionEditor::code_setting_CB,
						(XtPointer) code_callback_v,
						value_changed_v,
						no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET);ac++;
  XtSetArg(al[ac],XmNbottomWidget,_code_callback_name);ac++;
  XtSetValues(label,al,ac);
  ac=0;
  //----------------------------------------------------------------------
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_WIDGET);ac++;
  XtSetArg(al[ac],XmNtopWidget,frame);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  frame =  _factory->create_widget(code,"XmFrame",
			  frame_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0; 
  form = _factory->create_widget(frame,"XmForm",
			  form_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  label = _factory->create_widget(form,"Event Filename",
			  label_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftOffset,180);ac++;
  _code_event_name = _factory->create_widget(form,
						"XmText",
						text_v,
						OptionEditor::code_setting_CB,
						(XtPointer) code_event_v,
						value_changed_v,
						no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET);ac++;
  XtSetArg(al[ac],XmNbottomWidget,_code_event_name);ac++;
  XtSetValues(label,al,ac);
  ac=0;
  //----------------------------------------------------------------------
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_WIDGET);ac++;
  XtSetArg(al[ac],XmNtopWidget,frame);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  frame =  _factory->create_widget(code,"XmFrame",
			  frame_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0; 
  form = _factory->create_widget(frame,"XmForm",
			  form_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  label = _factory->create_widget(form,"Public Filename",
			  label_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftOffset,180);ac++;
  _code_public_name = _factory->create_widget(form,"XmText",
						text_v,
						OptionEditor::code_setting_CB,
						(XtPointer) code_public_v,
						value_changed_v,
						no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET);ac++;
  XtSetArg(al[ac],XmNbottomWidget,_code_public_name);ac++;
  XtSetValues(label,al,ac);
  ac=0;
  //----------------------------------------------------------------------
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_WIDGET);ac++;
  XtSetArg(al[ac],XmNtopWidget,frame);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  frame =  _factory->create_widget(code,"XmFrame",
			  frame_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0; 
  form = _factory->create_widget(frame,"XmForm",
			  form_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  label = _factory->create_widget(form,"Resource Directory",
			  label_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftOffset,180);ac++;
  _code_resource_directory = _factory->create_widget(form,"XmText",
						text_v,
						OptionEditor::code_setting_CB,
						(XtPointer) code_resource_v,
						value_changed_v,
						no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET);ac++;
  XtSetArg(al[ac],XmNbottomWidget,_code_resource_directory);ac++;
  XtSetValues(label,al,ac);
  ac=0;
  //----------------------------------------------------------------------
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_WIDGET);ac++;
  XtSetArg(al[ac],XmNtopWidget,frame);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  frame =  _factory->create_widget(code,"XmFrame",
			  frame_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0; 
  form = _factory->create_widget(frame,"XmForm",
			  form_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  label = _factory->create_widget(form,"Project Directory",
			  label_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftOffset,180);ac++;
  _code_project_directory = _factory->create_widget(form,"XmText",
						text_v,
						OptionEditor::code_setting_CB,
						(XtPointer) code_project_v,
						value_changed_v,
						no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET);ac++;
  XtSetArg(al[ac],XmNbottomWidget,_code_project_directory);ac++;
  XtSetValues(label,al,ac);
  ac=0;
  //----------------------------------------------------------------------
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_WIDGET);ac++;
  XtSetArg(al[ac],XmNtopWidget,frame);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  frame =  _factory->create_widget(code,"XmFrame",
			  frame_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0; 
  form = _factory->create_widget(frame,"XmForm",
			  form_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  label = _factory->create_widget(form,"Pixmap Directory",
			  label_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftOffset,180);ac++;
  _code_pixmap_directory = _factory->create_widget(form,"XmText",
						text_v,
						OptionEditor::code_setting_CB,
						(XtPointer) code_pixmap_v,
						value_changed_v,
						no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET);ac++;
  XtSetArg(al[ac],XmNbottomWidget,_code_pixmap_directory);ac++;
  XtSetValues(label,al,ac);
  ac=0;


  //----------------------------------------------------------------------
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_WIDGET);ac++;
  XtSetArg(al[ac],XmNtopWidget,frame);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  frame =  _factory->create_widget(code,"XmFrame",
			  frame_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0; 
  form = _factory->create_widget(frame,"XmForm",
			  form_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  label = _factory->create_widget(form,"Motif Library",
			  label_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftOffset,180);ac++;
  _code_motif_lib = _factory->create_widget(form,"XmText",
						text_v,
						OptionEditor::code_setting_CB,
						(XtPointer) code_motif_lib_v,
						value_changed_v,
						no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET);ac++;
  XtSetArg(al[ac],XmNbottomWidget,_code_motif_lib);ac++;
  XtSetValues(label,al,ac);
  ac=0;
  //----------------------------------------------------------------------
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_WIDGET);ac++;
  XtSetArg(al[ac],XmNtopWidget,frame);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  frame =  _factory->create_widget(code,"XmFrame",
			  frame_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0; 
  form = _factory->create_widget(frame,"XmForm",
			  form_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  label = _factory->create_widget(form,"Xt Library",
			  label_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftOffset,180);ac++;
  _code_Xt_lib = _factory->create_widget(form,"XmText",
						text_v,
						OptionEditor::code_setting_CB,
						(XtPointer) code_Xt_lib_v,
						value_changed_v,
						no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET);ac++;
  XtSetArg(al[ac],XmNbottomWidget,_code_Xt_lib);ac++;
  XtSetValues(label,al,ac);
  ac=0;
  //----------------------------------------------------------------------
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_WIDGET);ac++;
  XtSetArg(al[ac],XmNtopWidget,frame);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  frame =  _factory->create_widget(code,"XmFrame",
			  frame_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0; 
  form = _factory->create_widget(frame,"XmForm",
			  form_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  label = _factory->create_widget(form,"X11 Library",
			  label_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftOffset,180);ac++;
  _code_X11_lib = _factory->create_widget(form,"XmText",
						text_v,
						OptionEditor::code_setting_CB,
						(XtPointer) code_X11_lib_v,
						value_changed_v,
						no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET);ac++;
  XtSetArg(al[ac],XmNbottomWidget,_code_X11_lib);ac++;
  XtSetValues(label,al,ac);
  ac=0;
  //----------------------------------------------------------------------
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_WIDGET);ac++;
  XtSetArg(al[ac],XmNtopWidget,frame);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  frame =  _factory->create_widget(code,"XmFrame",
			  frame_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0; 
  form = _factory->create_widget(frame,"XmForm",
			  form_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  label = _factory->create_widget(form,"Include Directories",
			  label_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftOffset,180);ac++;
  _code_includes = _factory->create_widget(form,"XmText",
						text_v,
						OptionEditor::code_setting_CB,
						(XtPointer) code_includes_v,
						value_changed_v,
						no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET);ac++;
  XtSetArg(al[ac],XmNbottomWidget,_code_includes);ac++;
  XtSetValues(label,al,ac);
  ac=0;
  //----------------------------------------------------------------------
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_WIDGET);ac++;
  XtSetArg(al[ac],XmNtopWidget,frame);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  frame =  _factory->create_widget(code,"XmFrame",
			  frame_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0; 
  form = _factory->create_widget(frame,"XmForm",
			  form_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  label = _factory->create_widget(form,"C Compiler",
			  label_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftOffset,180);ac++;
  _code_c_compiler = _factory->create_widget(form,"XmText",
						text_v,
						OptionEditor::code_setting_CB,
						(XtPointer) code_c_compiler_v,
						value_changed_v,
						no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET);ac++;
  XtSetArg(al[ac],XmNbottomWidget,_code_c_compiler);ac++;
  XtSetValues(label,al,ac);
  ac=0;
  //----------------------------------------------------------------------
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_WIDGET);ac++;
  XtSetArg(al[ac],XmNtopWidget,frame);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  frame =  _factory->create_widget(code,"XmFrame",
			  frame_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0; 
  form = _factory->create_widget(frame,"XmForm",
			  form_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  label = _factory->create_widget(form,"CFLAGS",
			  label_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftOffset,180);ac++;
  _code_c_flags = _factory->create_widget(form,"XmText",
						text_v,
						OptionEditor::code_setting_CB,
						(XtPointer) code_c_flags_v,
						value_changed_v,
						no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET);ac++;
  XtSetArg(al[ac],XmNbottomWidget,_code_c_flags);ac++;
  XtSetValues(label,al,ac);
  ac=0;
  //----------------------------------------------------------------------
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_WIDGET);ac++;
  XtSetArg(al[ac],XmNtopWidget,frame);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  frame =  _factory->create_widget(code,"XmFrame",
			  frame_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0; 
  form = _factory->create_widget(frame,"XmForm",
			  form_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  label = _factory->create_widget(form,"C++ Compiler",
			  label_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftOffset,180);ac++;
  _code_cpp_compiler = _factory->create_widget(form,"XmText",
					       text_v,
					       OptionEditor::code_setting_CB,
					       (XtPointer) code_cpp_compiler_v,
					       value_changed_v,
					       no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET);ac++;
  XtSetArg(al[ac],XmNbottomWidget,_code_cpp_compiler);ac++;
  XtSetValues(label,al,ac);
  ac=0;
  //----------------------------------------------------------------------
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_WIDGET);ac++;
  XtSetArg(al[ac],XmNtopWidget,frame);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  frame =  _factory->create_widget(code,"XmFrame",
			  frame_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0; 
  form = _factory->create_widget(frame,"XmForm",
			  form_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  label = _factory->create_widget(form,"C++FLAGS",
			  label_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftOffset,180);ac++;
  _code_cpp_flags = _factory->create_widget(form,"XmText",
						text_v,
						OptionEditor::code_setting_CB,
						(XtPointer) code_cpp_flags_v,
						value_changed_v,
						no_pixmap,al,ac);
  ac=0;
  XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET);ac++;
  XtSetArg(al[ac],XmNbottomWidget,_code_cpp_flags);ac++;
  XtSetValues(label,al,ac);
  ac=0;


  return code;
}

Widget OptionEditor::create_preference()
{
  Arg al[10];
  int ac = 0;
  bool no_pixmap = False;
  Widget preference = NULL;
  Widget frame = NULL;
  Widget form = NULL;
  Widget label = NULL;

  preference = _factory->create_widget(_frame,"Not Available",
			  pushbutton_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  return preference;
}

Widget OptionEditor::create_install()
{
  Arg al[10];
  int ac = 0;
  bool no_pixmap = False;
  Widget install = NULL;
  Widget frame = NULL;
  Widget form = NULL;
  Widget label = NULL;

  install = _factory->create_widget(_frame,"Not Available",
			   pushbutton_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);

  return install;
}

void OptionEditor::set_callback_name(void)
{
  char * name;
  name = XmTextGetString(_code_callback_name);
  strcpy(_new_options.callback_filename,name);
  XtFree(name);
}

void OptionEditor::set_event_name(void)
{
  char * name;
  name = XmTextGetString(_code_event_name);
  strcpy(_new_options.event_filename,name);
  XtFree(name);
}

void OptionEditor::set_public_name(void)
{
  char * name;
  name = XmTextGetString(_code_public_name);
  strcpy(_new_options.public_filename,name);
  XtFree(name);
}

void OptionEditor::set_pixmap_dir(void)
{
  char * name;
  name = XmTextGetString(_code_pixmap_directory);
  strcpy(_new_options.pixmap_directory,name);
  XtFree(name);
}

void OptionEditor::set_project_dir(void)
{
  char * name;
  name = XmTextGetString(_code_project_directory);
  strcpy(_new_options.project_directory,name);
  XtFree(name);
}

void OptionEditor::set_resource_name(void)
{
  char * name;
  name = XmTextGetString(_code_resource_directory);
  strcpy(_new_options.resource_directory,name);
  XtFree(name);
}

void OptionEditor::set_motif_lib(void)
{
  char * name;
  name = XmTextGetString(_code_motif_lib);
  strcpy(_new_options.motif_lib,name);
  XtFree(name);
}

void OptionEditor::set_motif_static(void)
{
}

void OptionEditor::set_Xt_lib(void)
{
  char * name;
  name = XmTextGetString(_code_Xt_lib);
  strcpy(_new_options.xt_lib,name);
  XtFree(name);
}

void OptionEditor::set_Xt_static(void)
{
}

void OptionEditor::set_X11_lib(void)
{
  char * name;
  name = XmTextGetString(_code_X11_lib);
  strcpy(_new_options.x11_lib,name);
  XtFree(name);
}

void OptionEditor::set_X11_static(void)
{
}

void OptionEditor::set_includes(void)
{
  char * name;
  name = XmTextGetString(_code_includes);
  strcpy(_new_options.includes,name);
  XtFree(name);
}

void OptionEditor::set_c_compiler(void)
{
  char * name;
  name = XmTextGetString(_code_c_compiler);
  strcpy(_new_options.c_compiler,name);
  XtFree(name);
}

void OptionEditor::set_c_flags(void)
{
  char * name;
  name = XmTextGetString(_code_c_flags);
  strcpy(_new_options.c_flags,name);
  XtFree(name);
}

void OptionEditor::set_cpp_compiler(void)
{
  char * name;
  name = XmTextGetString(_code_cpp_compiler);
  strcpy(_new_options.cpp_compiler,name);
  XtFree(name);
}

void OptionEditor::set_cpp_flags(void)
{
  char * name;
  name = XmTextGetString(_code_cpp_flags);
  strcpy(_new_options.cpp_flags,name);
  XtFree(name);
}

option_rec * OptionEditor::get_options(void)
{
  return &_new_options;
}

void OptionEditor::update(void)
{
  if(_current == _option_code){
    if(strlen(_new_options.motif_lib))
      XmTextSetString(_code_motif_lib,_new_options.motif_lib);
    else
      XmTextSetString(_code_motif_lib,default_options.motif_lib);

    if(strlen(_new_options.xt_lib))
      XmTextSetString(_code_Xt_lib,_new_options.xt_lib);
    else
      XmTextSetString(_code_Xt_lib,default_options.xt_lib);

    if(strlen(_new_options.x11_lib))
      XmTextSetString(_code_X11_lib,_new_options.x11_lib);
    else
      XmTextSetString(_code_X11_lib,default_options.x11_lib);


    if(strlen(_new_options.callback_filename))
      XmTextSetString(_code_callback_name,_new_options.callback_filename);
    else
      XmTextSetString(_code_callback_name,default_options.callback_filename);

    if(strlen(_new_options.event_filename))
      XmTextSetString(_code_event_name,_new_options.event_filename);
    else
      XmTextSetString(_code_event_name,default_options.event_filename);

    if(strlen(_new_options.public_filename))
      XmTextSetString(_code_public_name,_new_options.public_filename);
    else
      XmTextSetString(_code_public_name,default_options.public_filename);

    if(strlen(_new_options.project_directory))
      XmTextSetString(_code_project_directory,_new_options.project_directory);
    else
      XmTextSetString(_code_project_directory,default_options.project_directory);

    if(strlen(_new_options.pixmap_directory))
      XmTextSetString(_code_pixmap_directory,_new_options.pixmap_directory);
    else
      XmTextSetString(_code_pixmap_directory,default_options.pixmap_directory);

    if(strlen(_new_options.resource_directory))
      XmTextSetString(_code_resource_directory,_new_options.resource_directory);
    else
      XmTextSetString(_code_resource_directory,default_options.resource_directory);

    if(strlen(_new_options.includes))
      XmTextSetString(_code_includes,_new_options.includes);
    else
      XmTextSetString(_code_includes,default_options.includes);

    if(strlen(_new_options.c_compiler))
      XmTextSetString(_code_c_compiler,_new_options.c_compiler);
    else
      XmTextSetString(_code_c_compiler,default_options.c_compiler);

    if(strlen(_new_options.c_flags))
      XmTextSetString(_code_c_flags,_new_options.c_flags);
    else
      XmTextSetString(_code_c_flags,default_options.c_flags);

    if(strlen(_new_options.cpp_compiler))
      XmTextSetString(_code_cpp_compiler,_new_options.cpp_compiler);
    else
      XmTextSetString(_code_cpp_compiler,default_options.cpp_compiler);

    if(strlen(_new_options.cpp_flags))
      XmTextSetString(_code_cpp_flags,_new_options.cpp_flags);
    else
      XmTextSetString(_code_cpp_flags,default_options.cpp_flags);

 

  }
  else if(_current == _option_preference){
  }
  else if(_current == _option_install){
  }

}

void OptionEditor::read_options(void)
{
}
