/* List.h */

#ifndef _LIST_H
#define _LIST_H

#include "Classes.h"
#include "Carrier.h" // Aggregation

#ifndef DEFAULT_TYPE
#define DEFAULT_TYPE
typedef int DefaultType;
#endif

/*oodB:List********** Documentation **************/
// Creation Data : Wed Sep 25 20:48:55 1996
// Programmer : Automatic
// Revised Date :
/* Purpose of Class List :
 
*/
/*oodE********************************************/
/*oodB#List*** Some Definitions and Stuffs *******/
#include "Carrier.h"
/*oodE********************************************/


template<class T>
class List {
private : // data members
	Carrier<T>* head;
	// Points to first carrier in list
	Carrier<T>* tail;
	// Points to last carrier in list
	int count;
public : // member functions
	List();
	~List();
	List(const List<T>& copy);
	T* LinkHead(T* item);
	T* LinkHead(T item);
	T* LinkTail(T* item);
	T* LinkTail(T item);
        T* LinkAfter(T item, T new_item);
        T* LinkAfter(T* item, T* new_item);
	T* UnlinkHead();
	T* UnlinkTail();
	T* UnlinkItem(T* item);
	T* UnlinkItem(T item);
	void DeleteAll();
	void ClearAll();
	void operator=(const List<T>& copy);
	int operator!();
	int ItemCount() const;
	Carrier<T>* GetHead() const;
	Carrier<T>* GetTail() const;
};

template<class T>
List<T>::List()
: head(0),tail(0),count(0)
{
  // Empty
}

template<class T>
List<T>::~List()
{
	DeleteAll();  // Delete carriers and items
}

template<class T>
List<T>::List(const List<T>& copy)
{
  head = tail = 0;  // Prepare for operator=()
  *this = copy;     // Calls operator=()
}

template<class T>
T* List<T>::LinkHead(T* item)
{
  if (!item) return 0;     // Can't add a null item
  Carrier<T> *p = 
    new Carrier<T>(item);  // Create Carrier object
  if (!p) return 0;        // Return null if new fails
  if (count == 0)          // If list is empty,
    head = tail = p;       // start a new list.
  else {
    head->prev = p;        // Attach Carrier to head
    p->next = head;        // Address next carrier
    head = p;              // Assign new head pointer
  }
  count++;                 // Increment items in list
  return item;             // Return item pointer
}

template<class T>
T* List<T>::LinkHead(T item)
{
	return LinkHead(&item);
}

template<class T>
T* List<T>::LinkTail(T* item)
{
  if (!item) return 0;     // Can't add a null item
  Carrier<T> *p = 
    new Carrier<T>(item);  // Create Carrier object
  if (!p) return 0;        // Return null if new fails
  if (count == 0)          // If list is empty,
    head = tail = p;       // start a new list.
  else {
    tail->next = p;        // Attach Carrier to tail
    p->prev = tail;        // Address previous carrier
    tail = p;              // Assign new tail pointer
  }
  count++;                 // Increment items in list
  return item;             // Return item pointer
}

template<class T>
T* List<T>::LinkTail(T item)
{
	return LinkTail(&item);
}

template<class T>
T* List<T>::LinkAfter(T* item, T* new_item)
{
  if (!new_item) return 0;     // Can't add a null item
  Carrier<T> *p = 
    new Carrier<T>(new_item);  // Create Carrier object
  if (!p) return 0;        // Return null if new fails
  if (count == 0)          // If list is empty,
    head = tail = p;       // start a new list.
  else {
    tail->next = p;        // Attach Carrier to tail
    p->prev = tail;        // Address previous carrier
    tail = p;              // Assign new tail pointer
  }
  count++;                 // Increment items in list

  return new_item;             // Return item pointer
}

template<class T>
T* List<T>::LinkAfter(T item, T new_item)
{
	return LinkAfter(&item,&new_item);
}

template<class T>
T* List<T>::UnlinkHead()
{
  if (!head) return 0;     // List is empty; return null
  Carrier<T> *p = head;    // Address head of list with p
  head = head->next;       // Assign new list head pointer
  if (head)                // If head pointer not null,
    head->prev = 0;        // null Carrier's prev pointer.
  else                     // Else if head pointer is null,
    tail = 0;              // set tail (list is empty).
  T *ip = p->ip;           // Assign pointer to item
  p->next = 0;             // Null Carrier's next pointer
  p->prev = 0;             // Null Carrier's prev pointer
  p->ip = 0;               // Null Carrier's item pointer
  delete p;                // Delete Carrier object
  cout << "Unlinking head\n";
  count--;                 // Decrement items in list
  return ip;               // Return item pointer
}

template<class T>
T* List<T>::UnlinkTail()
{
  if (!tail) return 0;     // List is empty; return null
  Carrier<T> *p = tail;    // Address tail of list with p
  tail = tail->prev;       // Assign new list tail pointer
  if (tail)                // If tail pointer not null,
    tail->next = 0;        // null Carrier's next pointer.
  else                     // Else if head pointer is null,
    head = 0;              // set tail (list is empty).
  T *ip = p->ip;           // Assign pointer to item
  p->next = 0;             // Null Carrier's next pointer
  p->prev = 0;             // Null Carrier's prev pointer
  p->ip = 0;               // Null Carrier's item pointer
  delete p;                // Delete Carrier object
  cout << "Unlinking tail\n";
  count--;                 // Decrement items in list
  return ip;               // Return item pointer
}

template<class T>
T* List<T>::UnlinkItem(T* item)
{
  if (!head) return 0;          // List is empty; return null
  Carrier<T> *p = head;         // Address head of list with p
  while (p && *p->ip!= *item )  // Search for item in list,
    p = p->next;                // stopping if p becomes null.
  if (!p) return 0;             // Return null if item not found
  if (*p->ip == *head->ip)      // If Carrier is at head of list,
    return UnlinkHead();        // default to UnlinkHead().
  if (*p->ip == *tail->ip)      // If Carrier is at tail of list,
    return UnlinkTail();        // default to UnlinkTail().
  T *ip = p->ip;                // Copy pointer in Carrier
  p->next->prev = p->prev;      // Unlink from next Carrier
  p->prev->next = p->next;      // Unlink from previous Carrier
  p->next = 0;                  // Null Carrier's next pointer
  p->prev = 0;                  // Null Carrier's prev pointer
  p->ip = 0;                    // Null Carrier's item pointer
  delete p;                     // Delete Carrier object
  count--;                      // Decrement items in list
  return ip;                    // Return item pointer
}

template<class T>
T* List<T>::UnlinkItem(T item)
{
	return UnlinkItem(&item);
}

template<class T>
void List<T>::DeleteAll()
{
  Carrier<T> *cp = head;  // Address head of list
  while (cp) 
  {                            // While not at end of list
    delete cp->ip;             // delete
    cp = cp->next;             // Do next carrier object
  }
  delete head;
  head = tail = 0;
  count = 0;
}

template<class T>
void List<T>::ClearAll()
{
  delete head;
  head = tail = 0;
  count = 0;
}

template<class T>
void List<T>::operator=(const List<T>& copy)
{
  if (this == &copy) return;   // Can't copy self to self
  DeleteAll();                 // Delete any current list
  Carrier<T> *cp = copy.head;  // Address head of list
  while (cp) {                 // While not at end of list
    LinkTail(cp->ip);          // Link copy of item to this list
    cp = cp->next;             // Do next carrier object
  }
}

template<class T>
int List<T>::operator!()
{
	return FALSE;
}

template<class T>
int List<T>::ItemCount() const
{
	return count;
}

template<class T>
Carrier<T>* List<T>::GetHead() const
{
	return head;
}

template<class T>
Carrier<T>* List<T>::GetTail() const
{
	return tail;
}

#endif
