/* Guide.h */

#ifndef _GUIDE_H
#define _GUIDE_H

#include "Classes.h"

#ifndef DEFAULT_TYPE
#define DEFAULT_TYPE
typedef int DefaultType;
#endif

/*oodB:Guide********** Documentation **************/
// Creation Data : Tue Oct 22 18:54:22 1996
// Programmer : Automatic
// Revised Date :
/* Purpose of Class Guide :
 
*/
/*oodE*********************************************/
/*oodB#Guide*** Some Definitions and Stuffs *******/
#include "public.h" 
#include "Factory.h"
#include "List.h"
#include "ListIterator.h"
#include "PixmapServer.h"
#include "DesignEditor.h"
#include "OptionEditor.h"
#include "ConstraintEditor.h"
#include "CoreResourceEditor.h"
#include "ResourceConverter.h"
#include "WidgetResourceEditor.h"
#include "WidgetObj.h"
#include "InterfaceObj.h"
#include "CodeGenerator.h"
enum menu_enum {
  // File menu
  menu_new_v,
  menu_save_v,
  menu_save_as_v,
  menu_exit_v,
  // Edit menu
  menu_undo_v,
  menu_cut_v,
  menu_copy_v,
  menu_paste_v,
  // Editor menu
  menu_design_editor_v,
  menu_widget_resource_editor_v,
  menu_core_resource_editor_v,
  menu_constraint_editor_v,
  menu_option_editor_v,
  menu_translation_editor_v,
  menu_callback_editor_v,
  menu_pixmap_editor_v,
  // Code Generation
  menu_generate_default_v,
  menu_generate_c_v,
  menu_generate_cpp_v,
  menu_generate_resource_v,
  menu_generate_smalltalk_v,
  menu_generate_main_v,
  menu_generate_callback_v,
  menu_generate_event_v,
  menu_generate_include_v,
  menu_generate_makefile_v,
  // Help menu
  menu_help_version_v,
  menu_help_index_v,
  menu_help_context_v
};
typedef enum menu_enum menu_enum;
 
/*oodE*********************************************/
class Guide {
private : // data members
	Widget _Guide;
	Factory* _factory;
	PixmapServer* _pixmap_server;
	DesignEditor* _design_editor;
	OptionEditor* _option_editor;
	ConstraintEditor* _constraint_editor;
	CoreResourceEditor* _core_resource_editor;
	ResourceConverter* _resource_converter;
	WidgetResourceEditor* _widget_resource_editor;
	CodeGenerator * _code_generator;
	WidgetObj* _wc;
	WidgetObj* _wbuffer;
	WidgetObj* _winsert;
	List<InterfaceObj> _ilist;
	bool _options_found;
	bool _layout_found;
	InterfaceObj* _ic;
	InterfaceObj* _ibuffer;
	Widget _variable_name;
	Widget _variable_text;
	Widget _widget_name;
	Widget _widget_text;
	Widget _frame;
        char _application[80];
public:
        bool code[last_code_v];
protected : // member functions
	void init(void);
	void build_menu(int argc,char* argv[]);
	bool get_options_file(void);
	bool get_layout_file(void);
public : // member functions
	~Guide();
	Guide(int argc,char* argv[]);
	void run(int argc,char* argv[]);
	Widget get_top_widget(void);
	Factory* get_Factory(void);
	PixmapServer* get_PixmapServer(void);
	DesignEditor* get_DesignEditor(void);
	OptionEditor* get_OptionEditor(void);
	ConstraintEditor* get_ConstraintEditor(void);
	CoreResourceEditor* get_CoreResourceEditor(void);
	ResourceConverter* get_ResourceConverter(void);
	WidgetResourceEditor* get_WidgetResourceEditor(void);
	CodeGenerator * get_CodeGenerator(void);
	static void menu_button_CB(Widget w,XtPointer clientdata,XtPointer calldata);
	void set_current_widget(WidgetObj* wc);
	void set_current_interface(InterfaceObj* ic);
        void set_project_name(char * name);
        char * get_project_name(void);
	WidgetObj* get_current_widget(void);
	InterfaceObj* get_current_interface(void);
	List<InterfaceObj>* get_interface_list(void);
	void add_interface(InterfaceObj* i);
	void display_interface(Widget area);
	void new_interface(void);
	void save_interface(void);
	void save_interface_as(void);
	void undo(void);
	void cut(void);
	void copy(void);
	void paste(void);
	void clean_up(void);
	void save_layout(void);
	bool layout_found(void);
	void clear_cut_buffers(void);
	void set_variable_name(void);
	void set_widget_name(void);
	void update_variable_name(void);
	void update_widget_name(void);
	static void set_variable_name_CB(Widget w,XtPointer clientdata,XtPointer calldata);
	static void set_widget_name_CB(Widget w,XtPointer clientdata,XtPointer calldata);
};

#endif
