/* DesignEditor.C */

#include "DesignEditor.h"
// Super Class : None

/*oodB%DesignEditor*** Global Declarations and Stuffs ****/
 
/*oodE****************************************************/

DesignEditor::DesignEditor()
{
	init();
}

DesignEditor::~DesignEditor()
{
}

void DesignEditor::save_layout(void)
{
  Arg al[5];
  int ac = 0;
 
  XtSetArg(al[ac],XmNx,&new_layout.Shell_x);ac++;
  XtSetArg(al[ac],XmNy,&new_layout.Shell_y);ac++;
  XtGetValues(_Shells,al,ac);
  ac = 0;
  XtSetArg(al[ac],XmNx,&new_layout.Manager_x);ac++;
  XtSetArg(al[ac],XmNy,&new_layout.Manager_y);ac++;
  XtGetValues(_Managers,al,ac);
  ac = 0;
  XtSetArg(al[ac],XmNx,&new_layout.Primitive_x);ac++;
  XtSetArg(al[ac],XmNy,&new_layout.Primitive_y);ac++;
  XtGetValues(_Primitives,al,ac);
  ac = 0;
  XtSetArg(al[ac],XmNx,&new_layout.Dialog_x);ac++;
  XtSetArg(al[ac],XmNy,&new_layout.Dialog_y);ac++;
  XtGetValues(_Dialogs,al,ac);
  ac = 0;
  XtSetArg(al[ac],XmNx,&new_layout.Gadget_x);ac++;
  XtSetArg(al[ac],XmNy,&new_layout.Gadget_y);ac++;
  XtGetValues(_Gadgets,al,ac);
  ac = 0;
  XtSetArg(al[ac],XmNx,&new_layout.Widget_x);ac++;
  XtSetArg(al[ac],XmNy,&new_layout.Widget_y);ac++;
  XtGetValues(_WidgetArea,al,ac);
  ac = 0;
  XtSetArg(al[ac],XmNx,&new_layout.Interface_x);ac++;
  XtSetArg(al[ac],XmNy,&new_layout.Interface_y);ac++;
  XtGetValues(_InterfaceArea,al,ac);
  ac = 0;
}

unsigned long DesignEditor::get_color(char *color)
{
  XrmValue from_value, to_value; /* For resource conversion */
  from_value.addr = color;
  from_value.size = strlen( from_value.addr ) + 1;
  to_value.addr = NULL;
  XtConvertAndStore (guide->get_top_widget(),XmRString, &from_value, XmRPixel , &to_value);
  if ( to_value.addr )
  {
    return( *(unsigned int *)to_value.addr);
  }
  else
    return(0);
}

void DesignEditor::init()
{
  Arg al[50];
  int ac = 0;
  Widget rc = NULL;
  Widget sw = NULL;
  bool use_pixmap = True;
  bool no_pixmap = False;

  _factory = guide->get_Factory();


  // create hints widget
  _liteClue = XtVaCreatePopupShell( 
             "popup_shell", 
             xcgLiteClueWidgetClass,guide->get_top_widget() ,
             XmNforeground, get_color("green"),
             XmNbackground, get_color("red"),
             NULL);

  if(guide->layout_found){
    XtSetArg(al[ac], XmNx, new_layout.Shell_x); ac++;
    XtSetArg(al[ac], XmNy, new_layout.Shell_y); ac++;
  }
  _Shells = _factory->create_widget(guide->get_top_widget(),
				    "Shells",
				    toplevelshell_v,
				    NULL,
				    NULL,
				    no_callback_v,
				    no_pixmap,
				    al,ac);
    ac = 0;
    XtSetArg(al[ac], XmNorientation,XmVERTICAL ); ac++;
    XtSetArg(al[ac], XmNpacking,XmPACK_COLUMN ); ac++;
    XtSetArg(al[ac], XmNresizeWidth,TRUE ); ac++;
    XtSetArg(al[ac], XmNresizeHeight,TRUE ); ac++;
    XtSetArg(al[ac], XmNnumColumns,3 ); ac++;
    XtSetArg(al[ac], XmNadjustLast,FALSE ); ac++;
    rc = _factory->create_widget(_Shells,
				 "XmRowColumn",
				 rowcolumn_v,
				 NULL,
				 NULL,
				 no_callback_v,
				 no_pixmap,
				 al,ac);
      ac = 0;
      bt.applicationshell = _factory->create_widget(rc,
						    "B",
						    pushbutton_v,
						    DesignEditor::create_widget_CB,
						    (XtPointer) applicationshell_v,
						    activate_v,
						    applicationshell_v,
						    al,ac);
      ac = 0;
      XcgLiteClueAddWidget(_liteClue, bt.applicationshell, "Application Shell", 0, 0);
      bt.toplevelshell = _factory->create_widget(rc,
						 "B",
						 pushbutton_v,
						 DesignEditor::create_widget_CB,
						 (XtPointer) toplevelshell_v,
						 activate_v,
						 toplevelshell_v,
						 al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.toplevelshell ,  "Top Level Shell", 0, 0);
      ac = 0;
      bt.dialogshell = _factory->create_widget(rc,
					       "B",
					       pushbutton_v,
					       DesignEditor::create_widget_CB,
					       (XtPointer) dialogshell_v,
					       activate_v,
					       dialogshell_v,
					       al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.dialogshell ,  "Dialog Shell", 0, 0);
  ac = 0;

  if(guide->layout_found){
    XtSetArg(al[ac], XmNx, new_layout.Manager_x); ac++;
    XtSetArg(al[ac], XmNy, new_layout.Manager_y); ac++;
  }
  _Managers = _factory->create_widget(guide->get_top_widget(),
				      "Managers",
				      toplevelshell_v,
				      NULL,
				      NULL,
				      no_callback_v,
				      no_pixmap,
				      al,ac);
    ac = 0;
    XtSetArg(al[ac], XmNorientation,XmVERTICAL ); ac++;
    XtSetArg(al[ac], XmNpacking,XmPACK_COLUMN ); ac++;
    XtSetArg(al[ac], XmNresizeWidth,TRUE ); ac++;
    XtSetArg(al[ac], XmNresizeHeight,TRUE ); ac++;
    XtSetArg(al[ac], XmNnumColumns,3 ); ac++;
    XtSetArg(al[ac], XmNadjustLast,FALSE ); ac++;
    rc = _factory->create_widget(_Managers,
				 "XmRowColumn",
				 rowcolumn_v,
				 NULL,
				 NULL,
				 no_callback_v,
				 no_pixmap,
				 al,ac);
      ac = 0;
      bt.bulletinboard = _factory->create_widget(rc,
						 "B",
						 pushbutton_v,
						 DesignEditor::create_widget_CB,
						 (XtPointer) bulletinboard_v,
						 activate_v,
						 bulletinboard_v,
						 al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.bulletinboard ,  "Bulletin Board", 0, 0);
      bt.form = _factory->create_widget(rc,
					"B",
					pushbutton_v,
					DesignEditor::create_widget_CB,
					(XtPointer) form_v,activate_v,
					form_v,
					al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.form ,  "Form", 0, 0);
      bt.selectionbox = _factory->create_widget(rc,
						"B",
						pushbutton_v,
						DesignEditor::create_widget_CB,
						(XtPointer) selectionbox_v,
						activate_v,
						selectionbox_v,
						al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.selectionbox ,  "Selection Box", 0, 0);
      bt.command = _factory->create_widget(rc,
					   "B",
					   pushbutton_v,
					   DesignEditor::create_widget_CB,
					   (XtPointer) command_v,
					   activate_v,
					   command_v,
					   al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.command ,  "Command", 0, 0);
      bt.fileselectionbox = _factory->create_widget(rc,
						    "B",
						    pushbutton_v,
						    DesignEditor::create_widget_CB,
						    (XtPointer) fileselectionbox_v,
						    activate_v,
						    fileselectionbox_v,
						    al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.fileselectionbox ,  "File Selection Box", 0, 0);
      bt.messagebox = _factory->create_widget(rc,
					      "B",
					      pushbutton_v,
					      DesignEditor::create_widget_CB,
					      (XtPointer) messagebox_v,
					      activate_v,
					      messagebox_v,
					      al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.messagebox ,  "Message Box", 0, 0);
      bt.menubar = _factory->create_widget(rc,
					   "B",
					   pushbutton_v,
					   DesignEditor::create_widget_CB,
					   (XtPointer) menubar_v,
					   activate_v,
					   menubar_v,
					   al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.menubar ,  "Menu Bar", 0, 0);
      bt.drawingarea = _factory->create_widget(rc,
					       "B",
					       pushbutton_v,
					       DesignEditor::create_widget_CB,
					       (XtPointer) drawingarea_v,
					       activate_v,
					       drawingarea_v,
					       al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.drawingarea ,  "Drawing Area", 0, 0);
      bt.frame = _factory->create_widget(rc,
					 "B",
					 pushbutton_v,
					 DesignEditor::create_widget_CB,
					 (XtPointer) frame_v,
					 activate_v,
					 frame_v,
					 al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.frame ,  "Frame", 0, 0);
      bt.panedwindow = _factory->create_widget(rc,
					       "B",
					       pushbutton_v,
					       DesignEditor::create_widget_CB,
					       (XtPointer) panedwindow_v,
					       activate_v,
					       panedwindow_v,
					       al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.panedwindow ,  "Paned Window", 0, 0);
      bt.radiobox = _factory->create_widget(rc,
					    "B",
					    pushbutton_v,
					    DesignEditor::create_widget_CB,
					    (XtPointer) radiobox_v,
					    activate_v,
					    radiobox_v,
					    al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.radiobox ,  "Radio Box", 0, 0);
      bt.rowcolumn = _factory->create_widget(rc,
					     "B",
					     pushbutton_v,
					     DesignEditor::create_widget_CB,
					     (XtPointer) rowcolumn_v,
					     activate_v,
					     rowcolumn_v,
					     al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.rowcolumn ,  "Row Column", 0, 0);
      bt.scale = _factory->create_widget(rc,
					 "B",
					 pushbutton_v,
					 DesignEditor::create_widget_CB,
					 (XtPointer) scale_v,
					 activate_v,
					 scale_v,
					 al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.scale ,  "Scale", 0, 0);
      bt.scrolledwindow = _factory->create_widget(rc,
						  "B",
						  pushbutton_v,
						  DesignEditor::create_widget_CB,
						  (XtPointer) scrolledwindow_v,
						  activate_v,
						  scrolledwindow_v,
						  al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.scrolledwindow ,  "Scrolled Window", 0, 0);
      bt.mainwindow = _factory->create_widget(rc,
					      "B",
					      pushbutton_v,
					      DesignEditor::create_widget_CB,
					      (XtPointer) mainwindow_v,
					      activate_v,
					      mainwindow_v,
					      al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.mainwindow ,  "Main Window", 0, 0);
  ac = 0;
  if(guide->layout_found){
    XtSetArg(al[ac], XmNx, new_layout.Primitive_x); ac++;
    XtSetArg(al[ac], XmNy, new_layout.Primitive_y); ac++;
  }
  _Primitives = _factory->create_widget(guide->get_top_widget(),
					"Primitives",
					toplevelshell_v,
					NULL,
					NULL,
					no_callback_v,
					no_pixmap,
					al,ac);
    ac = 0;
    XtSetArg(al[ac], XmNorientation,XmVERTICAL ); ac++;
    XtSetArg(al[ac], XmNpacking,XmPACK_COLUMN ); ac++;
    XtSetArg(al[ac], XmNresizeWidth,TRUE ); ac++;
    XtSetArg(al[ac], XmNresizeHeight,TRUE ); ac++;
    XtSetArg(al[ac], XmNnumColumns,3 ); ac++;
    XtSetArg(al[ac], XmNadjustLast,FALSE ); ac++;
    rc = _factory->create_widget(_Primitives,
				 "XmRowColumn",
				 rowcolumn_v,
				 NULL,
				 NULL,
				 no_callback_v,
				 no_pixmap,
				 al,ac);
      ac = 0;
      bt.arrowbutton = _factory->create_widget(rc,
					       "B",
					       pushbutton_v,
					       DesignEditor::create_widget_CB,
					       (XtPointer) arrowbutton_v,
					       activate_v,
					       arrowbutton_v,
					       al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.arrowbutton, "Arrow Button", 0, 0);
      bt.label = _factory->create_widget(rc,
					 "B",
					 pushbutton_v,
					 DesignEditor::create_widget_CB,
					 (XtPointer) label_v,
					 activate_v,
					 label_v,
					 al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.label, "Label", 0, 0);
      bt.cascadebutton = _factory->create_widget(rc,
						 "B",
						 pushbutton_v,
						 DesignEditor::create_widget_CB,
						 (XtPointer) cascadebutton_v,
						 activate_v,
						 cascadebutton_v,
						 al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.cascadebutton, "Cascade Button", 0, 0);
      bt.drawnbutton = _factory->create_widget(rc,
					       "B",
					       pushbutton_v,
					       DesignEditor::create_widget_CB,
					       (XtPointer) drawnbutton_v,
					       activate_v,
					       drawnbutton_v,
					       al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.drawnbutton, "Drawn Button", 0, 0);
      bt.pushbutton = _factory->create_widget(rc,
					      "B",
					      pushbutton_v,
					      DesignEditor::create_widget_CB,
					      (XtPointer) pushbutton_v,
					      activate_v,
					      pushbutton_v,
					      al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.pushbutton, "Push Button", 0, 0);
      bt.togglebutton = _factory->create_widget(rc,
						"B",
						pushbutton_v,
						DesignEditor::create_widget_CB,
						(XtPointer) togglebutton_v,
						activate_v,
						togglebutton_v,
						al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.togglebutton, "Toggle Button", 0, 0);
      bt.list = _factory->create_widget(rc,
					"B",
					pushbutton_v,
					DesignEditor::create_widget_CB,
					(XtPointer) list_v,
					activate_v,
					list_v,
					al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.list, "List", 0, 0);
      bt.optionmenu = _factory->create_widget(rc,
					      "B",
					      pushbutton_v,
					      DesignEditor::create_widget_CB,
					      (XtPointer) optionmenu_v,
					      activate_v,
					      optionmenu_v,
					      al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.optionmenu, "Option Menu", 0, 0);
      bt.pulldownmenu = _factory->create_widget(rc,
						"B",
						pushbutton_v,
						DesignEditor::create_widget_CB,
						(XtPointer) pulldownmenu_v,
						activate_v,
						pulldownmenu_v,
						al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.pulldownmenu, "Pulldown Menu", 0, 0);
      bt.scrollbar = _factory->create_widget(rc,
					     "B",
					     pushbutton_v,
					     DesignEditor::create_widget_CB,
					     (XtPointer) scrollbar_v,
					     activate_v,
					     scrollbar_v,
					     al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.scrollbar, "Scroll Bar", 0, 0);
      bt.separator = _factory->create_widget(rc,
					     "B",
					     pushbutton_v,
					     DesignEditor::create_widget_CB,
					     (XtPointer) separator_v,
					     activate_v,
					     separator_v,
					     al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.separator, "Separator", 0, 0);
      bt.text = _factory->create_widget(rc,
					"B",
					pushbutton_v,
					DesignEditor::create_widget_CB,
					(XtPointer) text_v,
					activate_v,
					text_v,
					al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.text, "Text", 0, 0);
      bt.textfield = _factory->create_widget(rc,
					     "B",
					     pushbutton_v,
					     DesignEditor::create_widget_CB,
					     (XtPointer) textfield_v,
					     activate_v,
					     textfield_v,
					     al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.textfield, "Text Field", 0, 0);
      bt.scrolledtext = _factory->create_widget(rc,
						"B",
						pushbutton_v,
						DesignEditor::create_widget_CB,
						(XtPointer) scrolledtext_v,
						activate_v,
						scrolledtext_v,
						al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.scrolledtext, "Scrolled Text", 0, 0);
      bt.scrolledlist = _factory->create_widget(rc,
						"B",
						pushbutton_v,
						DesignEditor::create_widget_CB,
						(XtPointer) scrolledlist_v,
						activate_v,
						scrolledlist_v,
						al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.scrolledlist, "Scrolled List", 0, 0);
  ac = 0;
  if(guide->layout_found){
    XtSetArg(al[ac], XmNx, new_layout.Dialog_x); ac++;
    XtSetArg(al[ac], XmNy, new_layout.Dialog_y); ac++;
  }
  _Dialogs = _factory->create_widget(guide->get_top_widget(),
				     "Dialogs",
				     toplevelshell_v,
				     NULL,
				     NULL,
				     no_callback_v,
				     no_pixmap,
				     al,ac);
    ac = 0;
    XtSetArg(al[ac], XmNorientation,XmVERTICAL ); ac++;
    XtSetArg(al[ac], XmNpacking,XmPACK_COLUMN ); ac++;
    XtSetArg(al[ac], XmNresizeWidth,TRUE ); ac++;
    XtSetArg(al[ac], XmNresizeHeight,TRUE ); ac++;
    XtSetArg(al[ac], XmNnumColumns,5 ); ac++;
    XtSetArg(al[ac], XmNadjustLast,FALSE ); ac++;
    rc = _factory->create_widget(_Dialogs,
				 "XmRowColumn",
				 rowcolumn_v,
				 NULL,
				 NULL,
				 no_callback_v,
				 no_pixmap,
				 al,ac);
      ac = 0;
      bt.errordialog = _factory->create_widget(rc,"B",pushbutton_v,
					       DesignEditor::create_widget_CB,
					       (XtPointer) errordialog_v,activate_v,
					       errordialog_v,al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.errordialog, "Error Dialog", 0, 0);
      bt.informationdialog = _factory->create_widget(rc,"B",pushbutton_v,
						     DesignEditor::create_widget_CB,
						     (XtPointer) informationdialog_v,activate_v,
						     informationdialog_v,al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.informationdialog, "Information Dialog", 0, 0);
      bt.questiondialog = _factory->create_widget(rc,"B",pushbutton_v,
						  DesignEditor::create_widget_CB,
						  (XtPointer) questiondialog_v,activate_v,
						  questiondialog_v,al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.questiondialog, "Question Dialog", 0, 0);
      bt.warningdialog = _factory->create_widget(rc,"B",pushbutton_v,
						 DesignEditor::create_widget_CB,
						 (XtPointer) warningdialog_v,activate_v,
						 warningdialog_v,al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.warningdialog, "Warning Dialog", 0, 0);
      bt.workingdialog = _factory->create_widget(rc,"B",pushbutton_v,
						 DesignEditor::create_widget_CB,
						 (XtPointer) workingdialog_v,activate_v,
						 workingdialog_v,al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.workingdialog, "Working Dialog", 0, 0);
      bt.templatedialog = _factory->create_widget(rc,"B",pushbutton_v,
						  DesignEditor::create_widget_CB,
						  (XtPointer) templatedialog_v,activate_v,
						  templatedialog_v,al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.templatedialog, "Template Dialog", 0, 0);
      bt.formdialog = _factory->create_widget(rc,"B",pushbutton_v,
					      DesignEditor::create_widget_CB,
					      (XtPointer) formdialog_v,activate_v,
					      formdialog_v,al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.formdialog, "Form Dialog", 0, 0);
      bt.selectiondialog = _factory->create_widget(rc,"B",pushbutton_v,
						   DesignEditor::create_widget_CB,
						   (XtPointer) selectiondialog_v,
						   activate_v,selectiondialog_v,al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.selectiondialog, "Selection Dialog", 0, 0);
      bt.promptdialog = _factory->create_widget(rc,"B",pushbutton_v,
						DesignEditor::create_widget_CB,
						(XtPointer) promptdialog_v,activate_v,
						promptdialog_v,al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.promptdialog, "Prompt Dialog", 0, 0);
  ac = 0;
  if(guide->layout_found){
    XtSetArg(al[ac], XmNx, new_layout.Gadget_x); ac++;
    XtSetArg(al[ac], XmNy, new_layout.Gadget_y); ac++;
  }
  _Gadgets = _factory->create_widget(guide->get_top_widget(),
				     "Gadgets",
				     toplevelshell_v,
				     NULL,
				     NULL,
				     no_callback_v,
				     no_pixmap,
				     al,ac);
    ac = 0;
    XtSetArg(al[ac], XmNorientation,XmVERTICAL ); ac++;
    XtSetArg(al[ac], XmNpacking,XmPACK_COLUMN ); ac++;
    XtSetArg(al[ac], XmNresizeWidth,TRUE ); ac++;
    XtSetArg(al[ac], XmNresizeHeight,TRUE ); ac++;
    XtSetArg(al[ac], XmNnumColumns,3 ); ac++;
    XtSetArg(al[ac], XmNadjustLast,FALSE ); ac++;
    rc = _factory->create_widget(_Gadgets,
				 "XmRowColumn",
				 rowcolumn_v,
				 NULL,
				 NULL,
				 no_callback_v,
				 no_pixmap,
				 al,ac);
      ac = 0;
      bt.arrowbuttongadget = _factory->create_widget(rc,
						     "B",
						     pushbutton_v,
						     DesignEditor::create_widget_CB,
						     (XtPointer) arrowbuttongadget_v,
						     activate_v,
						     arrowbutton_v,
						     al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.arrowbuttongadget, "Arrow Button Gadget", 0, 0);
      bt.labelgadget = _factory->create_widget(rc,
					       "B",
					       pushbutton_v,
					       DesignEditor::create_widget_CB,
					       (XtPointer) labelgadget_v,
					       activate_v,
					       labelgadget_v,
					       al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.labelgadget, "Label Gadget", 0, 0);
      bt.cascadebuttongadget = _factory->create_widget(rc,
						       "B",
						       pushbutton_v,
						       DesignEditor::create_widget_CB,
						       (XtPointer) cascadebuttongadget_v,
						       activate_v,
						       cascadebutton_v,
						       al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.cascadebuttongadget, "Cascade Button Gadget", 0, 0);
      bt.pushbuttongadget = _factory->create_widget(rc,
						    "B",
						    pushbutton_v,
						    DesignEditor::create_widget_CB,
						    (XtPointer) pushbuttongadget_v,
						    activate_v,
						    pushbuttongadget_v,
						    al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.pushbuttongadget, "Push Button Gadget", 0, 0);
      bt.togglebuttongadget = _factory->create_widget(rc,
						      "B",
						      pushbutton_v,
						      DesignEditor::create_widget_CB,
						      (XtPointer) togglebuttongadget_v,
						      activate_v,
						      togglebuttongadget_v,
						      al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.togglebuttongadget, "Toggle Button Gadget", 0, 0);
      bt.separatorgadget = _factory->create_widget(rc,
						   "B",
						   pushbutton_v,
						   DesignEditor::create_widget_CB,
						   (XtPointer) separatorgadget_v,
						   activate_v,
						   separator_v,
						   al,ac);
      XcgLiteClueAddWidget(_liteClue, bt.separatorgadget, "Separator Gadget", 0, 0);

  ac = 0;
  XtSetArg(al[ac], XmNwidth, 400); ac++;
  XtSetArg(al[ac], XmNheight, 400); ac++;
  if(guide->layout_found){
    XtSetArg(al[ac], XmNx, new_layout.Widget_x); ac++;
    XtSetArg(al[ac], XmNy, new_layout.Widget_y); ac++;
  }
  _WidgetArea = _factory->create_widget(guide->get_top_widget(),
					"Widget Display Tree",
					toplevelshell_v,
					NULL,
					NULL,
					no_callback_v,
					no_pixmap,
					al,ac);
    ac = 0;
    XtSetArg(al[ac], XmNscrollingPolicy, XmAUTOMATIC); ac++;
    sw = _factory->create_widget(_WidgetArea,
				 "SW1",
				 scrolledwindow_v,
				 NULL,
				 NULL,
				 no_callback_v,
				 no_pixmap,
				 al,ac);
      ac = 0;
      XtSetArg(al[ac], XmNwidth, 600); ac++;
      XtSetArg(al[ac], XmNheight, 600); ac++;
      _warea =_factory->create_widget(sw,
				      "WidgetArea",
				      drawingarea_v,
				      NULL,
				      NULL,
				      no_callback_v,
				      no_pixmap,
				      al,ac);
    create_widget_popup(_warea);
  ac = 0;
   XtSetArg(al[ac], XmNwidth, 100); ac++;
  XtSetArg(al[ac], XmNheight, 400); ac++;
  if(guide->layout_found){
    XtSetArg(al[ac], XmNx, new_layout.Interface_x); ac++;
    XtSetArg(al[ac], XmNy, new_layout.Interface_y); ac++;
  }
  _InterfaceArea = _factory->create_widget(guide->get_top_widget(),
					   "Interfaces",
					   toplevelshell_v,
					   NULL,
					   NULL,
					   no_callback_v,
					   no_pixmap,
					   al,ac);
    ac = 0;
    XtSetArg(al[ac], XmNscrollingPolicy, XmAUTOMATIC); ac++;
    sw = _factory->create_widget(_InterfaceArea,
				 "SW2",
				 scrolledwindow_v,
				 NULL,
				 NULL,
				 no_callback_v,
				 no_pixmap,
				 al,ac);
      ac = 0;
      XtSetArg(al[ac], XmNwidth, 69); ac++;
      XtSetArg(al[ac], XmNheight, 600); ac++;
      _iarea =_factory->create_widget(sw,
				      "WidgetArea",
				      drawingarea_v,
				      NULL,
				      NULL,
				      no_callback_v,
				      no_pixmap,
				      al,ac);
    create_interface_popup(_iarea);

    set_sensitive_pixmaps();
    sensitise_all(False);
}

void DesignEditor::popup()
{
  XtPopup(_Shells,XtGrabNone);
  XtPopup(_Managers,XtGrabNone);
  XtPopup(_Primitives,XtGrabNone);
  XtPopup(_Dialogs,XtGrabNone);
  XtPopup(_Gadgets,XtGrabNone);
  XtPopup(_WidgetArea,XtGrabNone);
  XtPopup(_InterfaceArea,XtGrabNone);
}

void DesignEditor::popdown()
{
  XtPopdown(_Shells);
  XtPopdown(_Managers);
  XtPopdown(_Primitives);
  XtPopdown(_Dialogs);
  XtPopdown(_Gadgets);
  XtPopdown(_WidgetArea);
  XtPopdown(_InterfaceArea);
}

void DesignEditor::create_frame_args(WidgetObj * wc, Arg al[],int &ac)
{
  if(wc->get_type()==frame_v){
    if(wc->get_num_children() > 0){
      XtSetArg(al[ac], XmNchildType,XmFRAME_TITLE_CHILD);ac++;
    }
  }
}

void DesignEditor::create_form_attachments(WidgetObj * wc,
					   WidgetObj * wn,
					   Arg al[],int &ac)
{
  WidgetObj * temp = NULL;
  attachment_rec * attach = NULL;

  if(wc){
    if(wc->get_type()==form_v){
      ListIterator<WidgetObj> * iter = 
        new ListIterator<WidgetObj>(wc->get_widget_list());

      // find last item added to list
      temp = iter->CurrentItem();

      while(iter->GetNext())
        temp = iter->CurrentItem();

      attach = wn->get_attachment_rec();

      if(temp){
        XtSetArg(al[ac],XmNtopAttachment,XmATTACH_WIDGET);ac++;
        attach->top_attachment = XmATTACH_WIDGET;
        XtSetArg(al[ac],XmNtopWidget,temp->get_widget());ac++;
        attach->top_widget = temp;
        XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
        attach->left_attachment = XmATTACH_FORM;
      }
      else{
        XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
        attach->top_attachment = XmATTACH_FORM;
        XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
        attach->left_attachment = XmATTACH_FORM;
      }
      delete iter;
    }
  }
}

void DesignEditor::create_widget(widget_type_enum type)
{
  Arg al[15];
  int ac = 0;
  Widget w = NULL;
  Widget parent = NULL;
  Widget menu_pane = NULL;
  Factory *f = guide->get_Factory();
  PixmapServer *ps = guide->get_PixmapServer();
  ConstraintEditor * ce = guide->get_ConstraintEditor();
  CoreResourceEditor * cre = guide->get_CoreResourceEditor();
  WidgetResourceEditor * wre = guide->get_WidgetResourceEditor();
  WidgetObj * wc = guide->get_current_widget();
  WidgetObj * new_widget = NULL;
  WidgetObj * new_pulldown = NULL;
  WidgetObj * temp = NULL;
  InterfaceObj * ic = guide->get_current_interface();
  InterfaceObj * new_interface = NULL;
  XmString xmstr;
  int x = SPACE/2;
  int y = SPACE/2;
  int total_x = SPACE/2;
  int total_y = SPACE/2;
  bool no_pixmap = False;

  if(wc != NULL)
    wre->unmanage_all();

  guide->clear_cut_buffers();

  f->create_widget(type);

  new_widget = new WidgetObj(widget_name[type],type);

   switch(type)
   {
      case applicationshell_v:
      case toplevelshell_v:
      case dialogshell_v:
        parent = guide->get_top_widget();
        w = f->create_widget(parent,
			     new_widget->get_name(),
			     type,
			     NULL,
			     NULL,
			     no_callback_v,
			     no_pixmap,
			     al,ac);
        XtManageChild(w);
        new_interface = new InterfaceObj;
        new_interface->set_child(new_widget);
        new_interface->set_pixmap(ps->get_big_pixmap(type));
        guide->set_current_interface(new_interface);
        guide->add_interface(new_interface);
        guide->set_current_widget(new_widget);
        new_widget->set_max_children(1);
	break;
      case formdialog_v:
      case promptdialog_v:
      case selectiondialog_v:
      case templatedialog_v:
        parent = guide->get_top_widget();
        w = f->create_widget(parent,
			     new_widget->get_name(),
			     type,
			     NULL,
			     NULL,
			     no_callback_v,
			     no_pixmap,
			     al,ac);
        new_interface = new InterfaceObj;
        new_interface->set_pixmap(ps->get_big_pixmap(type));
        new_interface->set_child(new_widget);
        guide->set_current_interface(new_interface);
        guide->add_interface(new_interface);
        guide->set_current_widget(new_widget);
      break;
      case questiondialog_v:
      case informationdialog_v:
      case errordialog_v:
      case warningdialog_v:
      case workingdialog_v:
        ac = 0;
        parent = guide->get_top_widget();
        w = f->create_widget(parent,
			     new_widget->get_name(),
			     type,
			     NULL,
			     NULL,
			     no_callback_v,
			     no_pixmap,
			     al,ac);
        new_interface = new InterfaceObj;
        new_interface->set_pixmap(ps->get_big_pixmap(type));
        new_interface->set_child(new_widget);
        guide->set_current_interface(new_interface);
        guide->add_interface(new_interface);
        guide->set_current_widget(new_widget);
        create_children(w,new_widget,type);
	break;
      case scrolledtext_v:
        ac = 0;
        XtSetArg(al[ac], XmNeditMode,XmMULTI_LINE_EDIT);ac++;
        new_widget->set_parent(wc);
        create_frame_args(wc, al,ac);
        create_form_attachments(wc,new_widget, al,ac);
        parent = wc->get_widget();
        w = f->create_widget(parent,
			     new_widget->get_name(),
			     type,
			     NULL,
			     NULL,
			     no_callback_v,
			     no_pixmap,
			     al,ac);
        wc->add_widget(new_widget);
        create_children(w,new_widget,type);
        new_widget->set_max_children(1);
	break;
      case scrolledlist_v:
        ac = 0;
        XtSetArg(al[ac], XmNscrollBarDisplayPolicy,XmSTATIC);ac++;
        XtSetArg(al[ac], XmNlistSizePolicy,XmCONSTANT);ac++;
        new_widget->set_parent(wc);
        create_frame_args(wc, al,ac);
        create_form_attachments(wc,new_widget, al,ac);
        parent = wc->get_widget();
        w = f->create_widget(parent,
			     new_widget->get_name(),
			     type,
			     NULL,
			     NULL,
			     no_callback_v,
			     no_pixmap,
			     al,ac);
        wc->add_widget(new_widget);
        create_children(w,new_widget,type);
        new_widget->set_max_children(1);
	break;
      case optionmenu_v:
        ac = 0;
        parent = wc->get_widget();
        new_widget->set_parent(wc);
        create_frame_args(wc, al,ac);
        create_form_attachments(wc,new_widget, al,ac);
        xmstr = XmStringCreateLtoR("Options", 
				   (XmStringCharSet)XmFONTLIST_DEFAULT_TAG);
        XtSetArg(al[ac],XmNlabelString,xmstr);ac++;
        w = f->create_widget(parent,
			     new_widget->get_name(),
			     type,
			     NULL,
			     NULL,
			     no_callback_v,
			     no_pixmap,
			     al,ac);
        XmStringFree (xmstr);
        wc->add_widget(new_widget);
        create_children(w,new_widget,type);
        new_widget->set_max_children(1);
        break;
      case pulldownmenu_v:
        ac = 0;
        parent = wc->get_widget();
        new_widget->set_parent(wc);
        create_frame_args(wc, al,ac);
        create_form_attachments(wc,new_widget, al,ac);
        if((wc->get_parent())->get_type()==optionmenu_v){
          // option menu pulldown has to be treated differently
	  // parent has to be the option menu
          w = f->create_widget((wc->get_parent())->get_widget(),
			       new_widget->get_name(),
			       type,
			       NULL,
			       NULL,
			       no_callback_v,
			       no_pixmap,
			       al,ac);
	}
        else{
          w = f->create_widget(parent,
			       new_widget->get_name(),
			       type,
			       NULL,
			       NULL,
			       no_callback_v,
			       no_pixmap,
			       al,ac);
	}
        XtSetArg(al[ac], XmNsubMenuId,w);ac++;
        XtSetValues(parent,al,ac);
        wc->add_widget(new_widget);
        create_children(w,new_widget,type);
        break;
      case mainwindow_v:
        ac = 0;
        guide->set_current_widget(new_widget);
        new_widget->set_parent(wc);
        create_frame_args(wc, al,ac);
        create_form_attachments(wc,new_widget, al,ac);
        parent = wc->get_widget();
        w = f->create_widget(parent,
			     new_widget->get_name(),
			     type,
			     NULL,
			     NULL,
			     no_callback_v,
			     no_pixmap,
			     al,ac);
        wc->add_widget(new_widget);
        new_widget->set_max_children(5);
        break;
      case frame_v:
        ac = 0;
        guide->set_current_widget(new_widget);
        new_widget->set_parent(wc);
        create_frame_args(wc, al,ac);
        create_form_attachments(wc,new_widget, al,ac);
        parent = wc->get_widget();
        w = f->create_widget(parent,
			     new_widget->get_name(),
			     type,
			     NULL,
			     NULL,
			     no_callback_v,
			     no_pixmap,
			     al,ac);
        wc->add_widget(new_widget);
        new_widget->set_max_children(2);
        break;
      case rowcolumn_v:
      case panedwindow_v:
      case radiobox_v:
      case bulletinboard_v:
      case drawingarea_v:
      case menubar_v:
      case form_v:
        ac = 0;
        guide->set_current_widget(new_widget);
        new_widget->set_parent(wc);
        create_frame_args(wc, al,ac);
        create_form_attachments(wc,new_widget, al,ac);
        parent = wc->get_widget();
        w = f->create_widget(parent,
			     new_widget->get_name(),
			     type,
			     NULL,
			     NULL,
			     no_callback_v,
			     no_pixmap,
			     al,ac);
        wc->add_widget(new_widget);
        break;
      case popupmenu_v:
        break;
      case fileselectionbox_v:
      case messagebox_v:
      case scrolledwindow_v:
      case selectionbox_v:
      case command_v:
      case cascadebutton_v:
        guide->set_current_widget(new_widget);
      case arrowbutton_v:
      case arrowbuttongadget_v:
      case cascadebuttongadget_v:
      case drawnbutton_v:
      case label_v:
      case labelgadget_v:
      case list_v:
      case scale_v:
      case scrollbar_v:
      case separator_v:
      case separatorgadget_v:
      case text_v:
      case textfield_v:
      case togglebutton_v:
      case togglebuttongadget_v:
        ac = 0;
        new_widget->set_parent(wc);
        create_frame_args(wc, al,ac);
        create_form_attachments(wc,new_widget, al,ac);
        parent = wc->get_widget();
        w = f->create_widget(parent,
			     new_widget->get_name(),
			     type,
			     NULL,
			     NULL,
			     no_callback_v,
			     no_pixmap,
			     al,ac);
        wc->add_widget(new_widget);
        create_children(w,new_widget,type);
        new_widget->set_max_children(1);
	break;
      case pushbuttongadget_v:
      case pushbutton_v:
        ac = 0;
        new_widget->set_parent(wc);
        create_frame_args(wc, al,ac);
        create_form_attachments(wc,new_widget, al,ac);
        parent = wc->get_widget();
        w = f->create_widget(parent,
			     new_widget->get_name(),
			     type,
			     DesignEditor::default_pushbutton_CB,
			     NULL,
			     activate_v,
			     no_pixmap,
			     al,ac);
        wc->add_widget(new_widget);
        new_widget->set_max_children(1);
	break;
   }
  if(new_widget->get_widget() == NULL)
    new_widget->set_widget(w);

  resize_drawing();
  update_displays();
  wc = guide->get_current_widget();

  if(wc){
    ce->update();
    cre->update();
    wre->update();
  }
  guide->update_variable_name();
  guide->update_widget_name();
}

void DesignEditor::resize_drawing(void)
{
  InterfaceObj * ic = NULL;
  WidgetObj * wc = NULL;
  Arg al[5];
  int ac = 0;
  int x = SPACE/2;
  int y = SPACE/2;
  int total_x = SPACE/2;
  int total_y = SPACE/2;

  ic = guide->get_current_interface();
  (ic->get_child())->calculate_icon_positions(x,y,total_x,total_y);
  (ic->get_child())->set_x((x+total_x)/2);
  ac = 0;
  XtSetArg(al[ac],XmNwidth,(Dimension)(total_x + SPACE*2));ac++;
  XtSetArg(al[ac],XmNheight,(Dimension)(total_y));ac++;
  XtSetValues(_warea,al,ac);

  wc = guide->get_current_widget();
  sensitise_all(True);
  if((wc->get_num_children() != wc->get_max_children())||
     (wc->get_max_children() == 0))
    sensitise_buttons(wc->get_type());
  else
    sensitise_all(False);
}

void DesignEditor::create_widget_CB(Widget w,XtPointer clientdata,XtPointer calldata)
{
  DesignEditor *d = guide->get_DesignEditor();
  d->create_widget((widget_type_enum)clientdata);
}

void DesignEditor::update_displays(void)
{
  update_widget_area();
  update_interface_area();
}

void DesignEditor::update_widget_area(void)
{
  InterfaceObj * iface = guide->get_current_interface();
  WidgetObj * wtemp = guide->get_current_widget();
  WidgetObj  * top = NULL;

  clear_widget_area();

  if(iface != NULL)
    top = iface->get_child();

  if(top != NULL)
    top->display_widgets(_warea);

  if(wtemp != NULL)
  draw_selection_box (_warea,
		      wtemp->get_x(),
		      wtemp->get_y(), WIDGET_SIZE, WIDGET_SIZE);

  draw_tree(_warea);

}

void DesignEditor::update_interface_area(void)
{
  InterfaceObj * itemp = guide->get_current_interface();
  clear_interface_area();
  guide->display_interface(_iarea);
  if(itemp != NULL)
  draw_selection_box (_iarea,
		      itemp->get_x(),
		      itemp->get_y(), 54, 46);
}

void DesignEditor::select_interface(int x,int y)
{
  List<InterfaceObj>* ilist = guide->get_interface_list();
  int y1 = 10;
  int x1 = 10;
  int index = -1;
  InterfaceObj * itemp;
  InterfaceObj * found;
  ListIterator<InterfaceObj> iter(ilist);

  while((itemp = iter.CurrentItem()) != NULL)
  {
    if(((x > x1) && (x < (x1 + 54))) &&
       ((y > y1) && (y < (y1 + 46))))
    {
      found = itemp;
      index = itemp->index;
      guide->set_current_interface(itemp);
      (itemp->get_child())->default_actions();
      guide->set_current_widget(itemp->get_child());
      resize_drawing();
      update_widget_area();
      update_interface_area();
      guide->update_variable_name();
      guide->update_widget_name();
    }    
    y1 = y1 + 46 + 10;
    iter.GetNext();
  }
}

void DesignEditor::select_widget(int x,int y)
{
  InterfaceObj * iface = guide->get_current_interface();
  ConstraintEditor * ce = guide->get_ConstraintEditor();
  CoreResourceEditor * cre = guide->get_CoreResourceEditor();
  WidgetResourceEditor * wre = guide->get_WidgetResourceEditor();
  WidgetObj  * top = NULL;
  WidgetObj  * selected = NULL;

  if(iface != NULL){
    top = iface->get_child();
  }

  if(top != NULL){
    wre->unmanage_all();
    selected = top->find_widget(x,y);
  }

  if(selected != NULL){
    selected->print_core();
    selected->default_actions();
    sensitise_all(True);
    if((selected->get_num_children() != selected->get_max_children())||
       (selected->get_max_children() == 0))
      sensitise_buttons(selected->get_type());
    else
      sensitise_all(False);
    guide->set_current_widget(selected);
    ce->update();
    cre->update();
    wre->update();
  }

  update_widget_area();
  guide->update_variable_name();
  guide->update_widget_name();
}

void DesignEditor::draw_tree(Widget w)
{
  InterfaceObj * iface = guide->get_current_interface();
  WidgetObj * wtemp = guide->get_current_widget();
  WidgetObj  * top = NULL;

  if(iface != NULL)
    top = iface->get_child();

  if(top != NULL)
    top->draw_tree(w);
}

void DesignEditor::draw_selection_box(Widget w,int x,int y,int width,int height)
{
  XrmValue from_value, to_value; /* For resource conversion */
  unsigned long fg;
  Window win;
    
  from_value.addr = "red";
  from_value.size = strlen( from_value.addr ) + 1;
  to_value.addr = NULL;
  XtConvertAndStore (w, XmRString, &from_value, XmRPixel, &to_value);
  if ( to_value.addr )
  {
    fg = *(unsigned int *)to_value.addr;
  }
  
  XSetForeground(display,gc,fg);
  win = XtWindow(w);

  /* top line */    
  XDrawLine(display, win, gc, x - 1,y - 1,x + width,    y - 1);
  XDrawLine(display, win, gc, x - 2,y - 2,x + width + 1,y - 2);
  XDrawLine(display, win, gc, x - 3,y - 3,x + width + 2,y - 3);

  /* bottom line */    
  XDrawLine(display, win, gc, x - 1,y +height,    x + width,    y +height);
  XDrawLine(display, win, gc, x - 2,y +height + 1,x + width + 1,y +height + 1);
  XDrawLine(display, win, gc, x - 3,y +height + 2,x + width + 2,y +height + 2);
    
  /* left line */    
  XDrawLine(display, win, gc, x - 1,y - 1,x - 1,y + height);
  XDrawLine(display, win, gc, x - 2,y - 2,x - 2,y + height + 1);
  XDrawLine(display, win, gc, x - 3,y - 3,x - 3,y + height + 2);
  
  /* right line */    
  XDrawLine(display, win, gc,x + width,    y - 1,x + width,    y + height);
  XDrawLine(display, win, gc,x + width + 1,y - 2,x + width + 1,y + height + 1);
  XDrawLine(display, win, gc,x + width + 2,y - 3,x + width + 2,y + height + 2);

  from_value.addr = "white";
  from_value.size = strlen( from_value.addr ) + 1;
  to_value.addr = NULL;
  XtConvertAndStore (w, XmRString, &from_value, XmRPixel, &to_value);
  if ( to_value.addr )
  {
    fg = *(unsigned int *)to_value.addr;
  }
  XSetForeground(display,gc,fg);
}

void DesignEditor::widget_area_input_CB(Widget w,XtPointer clientdata,XtPointer calldata)
{
  Widget popup_menu = (Widget ) clientdata;
  DesignEditor * _d = guide->get_DesignEditor();
  
  XmDrawingAreaCallbackStruct *cbs = (XmDrawingAreaCallbackStruct *) calldata;
  
  /* check which button has been pressed */
  if(cbs->event->xany.type != ButtonPress)
    return;
  switch(cbs->event->xbutton.button)
  {
    case 1:
       _d->select_widget(cbs->event->xbutton.x,cbs->event->xbutton.y);
    break;
    case 2:
    break;
    case 3:  
      XmMenuPosition(popup_menu, (XButtonPressedEvent *) (cbs->event));
      XtManageChild(popup_menu);
    break;
  }
}

void DesignEditor::widget_area_refresh_CB(Widget w,XtPointer clientdata,XtPointer calldata)
{
  DesignEditor *_d = guide->get_DesignEditor();
  _d->update_widget_area();
}

void DesignEditor::interface_area_input_CB(Widget w,XtPointer clientdata,XtPointer calldata)
{
  Widget popup_menu = (Widget ) clientdata;
  DesignEditor * _d = guide->get_DesignEditor();
  
  XmDrawingAreaCallbackStruct *cbs = (XmDrawingAreaCallbackStruct *) calldata;
  
  /* check which button has been pressed */
  if(cbs->event->xany.type != ButtonPress)
    return;
  switch(cbs->event->xbutton.button)
  {
    case 1:
       _d->select_interface(cbs->event->xbutton.x,cbs->event->xbutton.y);
    break;
    case 2:
    break;
    case 3:  
      XmMenuPosition(popup_menu, (XButtonPressedEvent *) (cbs->event));
      XtManageChild(popup_menu);
    break;
  }
}

void DesignEditor::interface_area_refresh_CB(Widget w,XtPointer clientdata,XtPointer calldata)
{
  DesignEditor *_d = guide->get_DesignEditor();
  _d->update_interface_area();
}

void DesignEditor::clear_widget_area()
{
  XClearWindow(XtDisplay(_warea), 
               XtWindow(_warea));
}

void DesignEditor::clear_interface_area()
{
  XClearWindow(XtDisplay(_iarea), 
               XtWindow(_iarea));
}

void DesignEditor::create_interface_popup(Widget parent)
{
  Arg al[5];
  int ac = 0;
  Widget popup;
  bool no_pixmap = False;

  Factory * _factory = guide->get_Factory();

  popup = _factory->create_widget(parent,"XmPopup",popupmenu_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac = 0;
  _factory->create_widget(popup,"Cut",pushbutton_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac = 0;
  _factory->create_widget(popup,"Copy",pushbutton_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac = 0;
  _factory->create_widget(popup,"Paste",pushbutton_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  XtAddCallback( _iarea,
                 XmNinputCallback,
                 DesignEditor::interface_area_input_CB,
                 popup);
  XtAddCallback(_iarea, XmNexposeCallback, 
                DesignEditor::interface_area_refresh_CB,NULL);
}

void DesignEditor::create_widget_popup(Widget parent)
{
  Arg al[5];
  int ac = 0;
  Widget popup;
  bool no_pixmap = False;

  Factory * _factory = guide->get_Factory();

  popup = _factory->create_widget(parent,"XmPopup",popupmenu_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac = 0;
  _factory->create_widget(popup,"Cut",pushbutton_v,Guide::menu_button_CB,(XtPointer)menu_cut_v,activate_v,no_pixmap,al,ac);
  ac = 0;
  _factory->create_widget(popup,"Copy",pushbutton_v,Guide::menu_button_CB,(XtPointer)menu_copy_v,activate_v,no_pixmap,al,ac);
  ac = 0;
  _factory->create_widget(popup,"Paste",pushbutton_v,Guide::menu_button_CB,(XtPointer)menu_paste_v,activate_v,no_pixmap,al,ac);
  ac = 0;
  _factory->create_widget(popup,"Hide/Show",pushbutton_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
  ac = 0;
  _factory->create_widget(popup,"Design Editor",pushbutton_v,Guide::menu_button_CB,(XtPointer)menu_design_editor_v,activate_v,no_pixmap,al,ac);
  ac = 0;
  _factory->create_widget(popup,"Option Editor",pushbutton_v,Guide::menu_button_CB,(XtPointer)menu_option_editor_v,activate_v,no_pixmap,al,ac);
  XtAddCallback( _warea,
                 XmNinputCallback,
                 DesignEditor::widget_area_input_CB,
                 popup);
  XtAddCallback(_warea, XmNexposeCallback, 
                DesignEditor::widget_area_refresh_CB,NULL);
}

void DesignEditor::create_children(Widget w,
				   WidgetObj *parent, 
				   widget_type_enum type)
{
  Arg al[15];
  int ac = 0;
  char new_name[MAX_STRING];
  bool unreal = True;
  WidgetObj * w1 = NULL;
  WidgetObj * w2 = NULL;
  WidgetObj * w3 = NULL;
  WidgetObj * w4 = NULL;
  WidgetObj * w5 = NULL;
  WidgetObj * w6 = NULL;
  WidgetObj * w7 = NULL;
  WidgetObj * w8 = NULL;
  WidgetObj * w9 = NULL;
  WidgetObj * w10 = NULL;
  WidgetObj * w11 = NULL;
  WidgetObj * w12 = NULL;
  WidgetObj * w13 = NULL;
  WidgetObj * w14 = NULL;
  WidgetObj * w15 = NULL;
  WidgetObj * w16 = NULL;
  WidgetObj * w17 = NULL;
  WidgetObj * w18 = NULL;
  Widget vertscroll = NULL;
  Widget horscroll = NULL;
  Widget scrollwin = NULL;
  Widget findw,top,nw;

  switch(type){
  case formdialog_v:
    w1 = new WidgetObj(parent->get_name(),form_v,unreal);
    w1->set_virtual(w);
    w1->set_parent(parent);
    parent->add_widget(w1);
  break;
  case promptdialog_v:
  case selectiondialog_v:
  break;
  case templatedialog_v:
    w1 = new WidgetObj(parent->get_name(),messagebox_v,unreal);
    w1->set_virtual(w);
    w1->set_parent(parent);
    parent->add_widget(w1);

    w5 = new WidgetObj("Separator",separator_v,unreal);
    w5->set_virtual(XmMessageBoxGetChild(w1->get_virtual(),XmDIALOG_SEPARATOR));
    w5->set_parent(parent);
    w1->add_widget(w5);
  break;
  case errordialog_v:
  case informationdialog_v:
  case questiondialog_v:
  case warningdialog_v:
  case workingdialog_v:
    w1 = new WidgetObj(parent->get_name(),messagebox_v,unreal);
    w1->set_virtual(w);
    w1->set_parent(parent);
    parent->add_widget(w1);

    w2 = new WidgetObj("OK",pushbutton_v,unreal);
    w2->set_virtual(XmMessageBoxGetChild(w1->get_virtual(),XmDIALOG_OK_BUTTON));
    w2->set_parent(parent);
    w1->add_widget(w2);

    w3 = new WidgetObj("Cancel",pushbutton_v,unreal);
    w3->set_virtual(XmMessageBoxGetChild(w1->get_virtual(),XmDIALOG_CANCEL_BUTTON));
    w3->set_parent(parent);
    w1->add_widget(w3);

    w4 = new WidgetObj("Help",pushbutton_v,unreal);
    w4->set_virtual(XmMessageBoxGetChild(w1->get_virtual(),XmDIALOG_HELP_BUTTON));
    w4->set_parent(parent);
    w1->add_widget(w4);

    w5 = new WidgetObj("Separator",separator_v,unreal);
    w5->set_virtual(XmMessageBoxGetChild(w1->get_virtual(),XmDIALOG_SEPARATOR));
    w5->set_parent(parent);
    w1->add_widget(w5);

    w6 = new WidgetObj("SLabel",label_v,unreal);
    w6->set_virtual(XmMessageBoxGetChild(w1->get_virtual(),XmDIALOG_SYMBOL_LABEL));
    w6->set_parent(parent);
    w1->add_widget(w6);

    w7 = new WidgetObj("MLabel",label_v,unreal);
    w7->set_virtual(XmMessageBoxGetChild(w1->get_virtual(),XmDIALOG_MESSAGE_LABEL));
    w7->set_parent(parent);
    w1->add_widget(w7);
    
    break;
  case fileselectionbox_v:
    w1 = new WidgetObj("OK",pushbutton_v,unreal);
    w1->set_virtual(XmFileSelectionBoxGetChild(w,XmDIALOG_OK_BUTTON));
    w1->set_parent(parent);
    parent->add_widget(w1);

    w2 = new WidgetObj("Apply",pushbutton_v,unreal);
    w2->set_virtual(XmFileSelectionBoxGetChild(w,XmDIALOG_APPLY_BUTTON));
    w2->set_parent(parent);
    parent->add_widget(w2);
    w3 = new WidgetObj("Cancel",pushbutton_v,unreal);
    w3->set_virtual(XmFileSelectionBoxGetChild(w,XmDIALOG_CANCEL_BUTTON));
    w3->set_parent(parent);
    parent->add_widget(w3);
    w4 = new WidgetObj("Help",pushbutton_v,unreal);
    w4->set_virtual(XmFileSelectionBoxGetChild(w,XmDIALOG_HELP_BUTTON));
    w4->set_parent(parent);
    parent->add_widget(w4);

    w5 = new WidgetObj(widget_name[scrolledlist_v],scrolledlist_v,unreal);
    w5->set_virtual(XmFileSelectionBoxGetChild(w,XmDIALOG_DIR_LIST));
    w5->set_parent(parent);
    parent->add_widget(w5);

    w6 = new WidgetObj(widget_name[label_v],label_v,unreal);
    w6->set_virtual(XmFileSelectionBoxGetChild(w,XmDIALOG_DIR_LIST_LABEL));
    w6->set_parent(parent);
    parent->add_widget(w6);

    w7 = new WidgetObj(widget_name[text_v],text_v,unreal);
    w7->set_virtual(XmFileSelectionBoxGetChild(w,XmDIALOG_FILTER_TEXT));
    w7->set_parent(parent);
    parent->add_widget(w7);
    w8 = new WidgetObj(widget_name[label_v],label_v,unreal);
    w8->set_virtual(XmFileSelectionBoxGetChild(w,XmDIALOG_FILTER_LABEL));
    w8->set_parent(parent);
    parent->add_widget(w8);

    w9 = new WidgetObj(widget_name[scrolledlist_v],scrolledlist_v,unreal);
    w9->set_virtual(XmFileSelectionBoxGetChild(w,XmDIALOG_LIST));
    w9->set_parent(parent);
    parent->add_widget(w9);
    w10 = new WidgetObj(widget_name[label_v],label_v,unreal);
    w10->set_virtual(XmFileSelectionBoxGetChild(w,XmDIALOG_LIST_LABEL));
    w10->set_parent(parent);
    parent->add_widget(w10);

    w11 = new WidgetObj(widget_name[label_v],label_v,unreal);
    w11->set_virtual(XmFileSelectionBoxGetChild(w,XmDIALOG_SELECTION_LABEL));
    w11->set_parent(parent);
    parent->add_widget(w11);

    w12 = new WidgetObj(widget_name[separator_v],separator_v,unreal);
    w12->set_virtual(XmFileSelectionBoxGetChild(w,XmDIALOG_SEPARATOR));
    w12->set_parent(parent);
    parent->add_widget(w12);

    w13 = new WidgetObj(widget_name[text_v],text_v,unreal);
    w13->set_virtual(XmFileSelectionBoxGetChild(w,XmDIALOG_TEXT));
    w13->set_parent(parent);
    parent->add_widget(w13);
    break;
  case selectionbox_v:
    break;
  case scrolledlist_v:
    sprintf(new_name,"%sSW",parent->get_name());
    parent->set_widget(XtNameToWidget((parent->get_parent())->get_widget(),new_name));
    w1 = new WidgetObj(parent->get_name(),list_v,unreal);
    w1->set_virtual(w);
    w1->set_parent(parent);
    parent->set_name(new_name);
    parent->add_widget(w1);

    ac = 0;
    XtSetArg(al[ac], XmNverticalScrollBar,&vertscroll);ac++;  
    XtSetArg(al[ac], XmNhorizontalScrollBar,&horscroll);ac++;  
    scrollwin = parent->get_widget();    
    XtGetValues(scrollwin, al, ac );  
    if(horscroll){
      w3 = new WidgetObj("HorScrollBar",scrollbar_v,unreal);
      w3->set_virtual(horscroll);
      w3->set_parent(parent);
      parent->add_widget(w3);
    }
    if(vertscroll){
      w4 = new WidgetObj("VertScrollBar",scrollbar_v,unreal);
      w4->set_virtual(vertscroll);
      w4->set_parent(parent);
      parent->add_widget(w4);
    }
    break;
  case scrolledtext_v:
    sprintf(new_name,"%sSW",parent->get_name());
    parent->set_widget(XtNameToWidget((parent->get_parent())->get_widget(),new_name));
    w1 = new WidgetObj(parent->get_name(),text_v,unreal);
    w1->set_virtual(w);
    w1->set_parent(parent);
    parent->set_name(new_name);
    parent->add_widget(w1);

    ac = 0;
    XtSetArg(al[ac], XmNverticalScrollBar,&vertscroll);ac++;  
    XtSetArg(al[ac], XmNhorizontalScrollBar,&horscroll);ac++;
    scrollwin = parent->get_widget();
    XtGetValues(scrollwin, al, ac );  
    if(horscroll){
      w3 = new WidgetObj("HorScrollBar",scrollbar_v,unreal);
      w3->set_virtual(horscroll);
      w3->set_parent(parent);
      parent->add_widget(w3);
    }
    if(vertscroll){
      w4 = new WidgetObj("VertScrollBar",scrollbar_v,unreal);
      w4->set_virtual(vertscroll);
      w4->set_parent(parent);
      parent->add_widget(w4);
    }
    break;
  case optionmenu_v:
    w1 = new WidgetObj("OptionLabel",labelgadget_v,unreal);
    w1->set_virtual(XmOptionLabelGadget(w));
    w1->set_parent(parent);
    parent->add_widget(w1);

    w2 = new WidgetObj("OptionButton",cascadebuttongadget_v,unreal);
    w2->set_virtual(XmOptionButtonGadget(w));
    w2->set_parent(parent);
    parent->add_widget(w2);
    break;
  }
}

void DesignEditor::default_pushbutton_CB(Widget w,XtPointer clientdata,XtPointer calldata)
{
  cout << "Pushbutton <" << w->core.name << "> pressed \n";
}

void DesignEditor::sensitise_buttons(widget_type_enum type)
{
  bool sensitive = False;

  switch(type){
  case applicationshell_v:
  case toplevelshell_v:
  case dialogshell_v:

  // Gadgets
  XtSetSensitive(bt.arrowbuttongadget,sensitive);
  XtSetSensitive(bt.labelgadget,sensitive);
  XtSetSensitive(bt.cascadebuttongadget,sensitive);
  XtSetSensitive(bt.pushbuttongadget,sensitive);
  XtSetSensitive(bt.togglebuttongadget,sensitive);
  XtSetSensitive(bt.separatorgadget,sensitive);
  break;
  case bulletinboard_v:
  // Managers
  XtSetSensitive(bt.mainwindow,sensitive);

  // Primitives
  XtSetSensitive(bt.pulldownmenu,sensitive);
  XtSetSensitive(bt.cascadebutton,sensitive);

  // Gadgets
  break;
  case command_v:
  // Managers
  XtSetSensitive(bt.bulletinboard,sensitive);
  XtSetSensitive(bt.form,sensitive);
  XtSetSensitive(bt.selectionbox,sensitive);
  XtSetSensitive(bt.command,sensitive);
  XtSetSensitive(bt.fileselectionbox,sensitive);
  XtSetSensitive(bt.messagebox,sensitive);
  XtSetSensitive(bt.menubar,sensitive);
  XtSetSensitive(bt.drawingarea,sensitive);
  XtSetSensitive(bt.frame,sensitive);
  XtSetSensitive(bt.panedwindow,sensitive);
  XtSetSensitive(bt.radiobox,sensitive);
  XtSetSensitive(bt.rowcolumn,sensitive);
  XtSetSensitive(bt.scale,sensitive);
  XtSetSensitive(bt.scrolledwindow,sensitive);
  XtSetSensitive(bt.mainwindow,sensitive);

  // Primitives
  XtSetSensitive(bt.arrowbutton,sensitive);
  XtSetSensitive(bt.label,sensitive);
  XtSetSensitive(bt.cascadebutton,sensitive);
  XtSetSensitive(bt.drawnbutton,sensitive);
  XtSetSensitive(bt.pushbutton,sensitive);
  XtSetSensitive(bt.togglebutton,sensitive);
  XtSetSensitive(bt.list,sensitive);
  XtSetSensitive(bt.optionmenu,sensitive);
  XtSetSensitive(bt.pulldownmenu,sensitive);
  XtSetSensitive(bt.scrollbar,sensitive);
  XtSetSensitive(bt.separator,sensitive);
  XtSetSensitive(bt.text,sensitive);
  XtSetSensitive(bt.textfield,sensitive);
  XtSetSensitive(bt.scrolledtext,sensitive);
  XtSetSensitive(bt.scrolledlist,sensitive);

  // Gadgets
  XtSetSensitive(bt.arrowbuttongadget,sensitive);
  XtSetSensitive(bt.labelgadget,sensitive);
  XtSetSensitive(bt.cascadebuttongadget,sensitive);
  XtSetSensitive(bt.pushbuttongadget,sensitive);
  XtSetSensitive(bt.togglebuttongadget,sensitive);
  XtSetSensitive(bt.separatorgadget,sensitive);
  break;
  case drawingarea_v:
  // Managers
  XtSetSensitive(bt.mainwindow,sensitive);

  // Primitives
  XtSetSensitive(bt.pulldownmenu,sensitive);
  XtSetSensitive(bt.cascadebutton,sensitive);

  // Gadgets
  break;
  case fileselectionbox_v:
  // Managers
  XtSetSensitive(bt.bulletinboard,sensitive);
  XtSetSensitive(bt.form,sensitive);
  XtSetSensitive(bt.selectionbox,sensitive);
  XtSetSensitive(bt.command,sensitive);
  XtSetSensitive(bt.fileselectionbox,sensitive);
  XtSetSensitive(bt.messagebox,sensitive);
  XtSetSensitive(bt.menubar,sensitive);
  XtSetSensitive(bt.drawingarea,sensitive);
  XtSetSensitive(bt.frame,sensitive);
  XtSetSensitive(bt.panedwindow,sensitive);
  XtSetSensitive(bt.radiobox,sensitive);
  XtSetSensitive(bt.rowcolumn,sensitive);
  XtSetSensitive(bt.scale,sensitive);
  XtSetSensitive(bt.scrolledwindow,sensitive);
  XtSetSensitive(bt.mainwindow,sensitive);

  // Primitives
  XtSetSensitive(bt.arrowbutton,sensitive);
  XtSetSensitive(bt.label,sensitive);
  XtSetSensitive(bt.cascadebutton,sensitive);
  XtSetSensitive(bt.drawnbutton,sensitive);
  XtSetSensitive(bt.pushbutton,sensitive);
  XtSetSensitive(bt.togglebutton,sensitive);
  XtSetSensitive(bt.list,sensitive);
  XtSetSensitive(bt.optionmenu,sensitive);
  XtSetSensitive(bt.pulldownmenu,sensitive);
  XtSetSensitive(bt.scrollbar,sensitive);
  XtSetSensitive(bt.separator,sensitive);
  XtSetSensitive(bt.text,sensitive);
  XtSetSensitive(bt.textfield,sensitive);
  XtSetSensitive(bt.scrolledtext,sensitive);
  XtSetSensitive(bt.scrolledlist,sensitive);

  // Gadgets
  XtSetSensitive(bt.arrowbuttongadget,sensitive);
  XtSetSensitive(bt.labelgadget,sensitive);
  XtSetSensitive(bt.cascadebuttongadget,sensitive);
  XtSetSensitive(bt.pushbuttongadget,sensitive);
  XtSetSensitive(bt.togglebuttongadget,sensitive);
  XtSetSensitive(bt.separatorgadget,sensitive);
  break;
  case form_v:
  // Managers
  XtSetSensitive(bt.selectionbox,sensitive);
  XtSetSensitive(bt.fileselectionbox,sensitive);
  XtSetSensitive(bt.messagebox,sensitive);
  XtSetSensitive(bt.mainwindow,sensitive);

  // Primitives
  XtSetSensitive(bt.pulldownmenu,sensitive);
  XtSetSensitive(bt.cascadebutton,sensitive);

  // Gadgets
  break;
  case frame_v:
  // Managers
  XtSetSensitive(bt.mainwindow,sensitive);

  // Primitives
  XtSetSensitive(bt.pulldownmenu,sensitive);
  XtSetSensitive(bt.cascadebutton,sensitive);

  // Gadgets
  break;
  case mainwindow_v:
  // Managers
  XtSetSensitive(bt.bulletinboard,sensitive);
  XtSetSensitive(bt.form,sensitive);
  XtSetSensitive(bt.selectionbox,sensitive);
  XtSetSensitive(bt.command,sensitive);
  XtSetSensitive(bt.fileselectionbox,sensitive);
  XtSetSensitive(bt.messagebox,sensitive);
  XtSetSensitive(bt.menubar,sensitive);
  XtSetSensitive(bt.drawingarea,sensitive);
  XtSetSensitive(bt.frame,sensitive);
  XtSetSensitive(bt.panedwindow,sensitive);
  XtSetSensitive(bt.radiobox,sensitive);
  XtSetSensitive(bt.rowcolumn,sensitive);
  XtSetSensitive(bt.scale,sensitive);
  XtSetSensitive(bt.scrolledwindow,sensitive);
  XtSetSensitive(bt.mainwindow,sensitive);

  // Primitives
  XtSetSensitive(bt.arrowbutton,sensitive);
  XtSetSensitive(bt.label,sensitive);
  XtSetSensitive(bt.cascadebutton,sensitive);
  XtSetSensitive(bt.drawnbutton,sensitive);
  XtSetSensitive(bt.pushbutton,sensitive);
  XtSetSensitive(bt.togglebutton,sensitive);
  XtSetSensitive(bt.list,sensitive);
  XtSetSensitive(bt.optionmenu,sensitive);
  XtSetSensitive(bt.pulldownmenu,sensitive);
  XtSetSensitive(bt.scrollbar,sensitive);
  XtSetSensitive(bt.separator,sensitive);
  XtSetSensitive(bt.text,sensitive);
  XtSetSensitive(bt.textfield,sensitive);
  XtSetSensitive(bt.scrolledtext,sensitive);
  XtSetSensitive(bt.scrolledlist,sensitive);

  // Gadgets
  XtSetSensitive(bt.arrowbuttongadget,sensitive);
  XtSetSensitive(bt.labelgadget,sensitive);
  XtSetSensitive(bt.cascadebuttongadget,sensitive);
  XtSetSensitive(bt.pushbuttongadget,sensitive);
  XtSetSensitive(bt.togglebuttongadget,sensitive);
  XtSetSensitive(bt.separatorgadget,sensitive);
  break;
  case menubar_v:
  // Managers
  XtSetSensitive(bt.bulletinboard,sensitive);
  XtSetSensitive(bt.form,sensitive);
  XtSetSensitive(bt.selectionbox,sensitive);
  XtSetSensitive(bt.command,sensitive);
  XtSetSensitive(bt.fileselectionbox,sensitive);
  XtSetSensitive(bt.messagebox,sensitive);
  XtSetSensitive(bt.menubar,sensitive);
  XtSetSensitive(bt.drawingarea,sensitive);
  XtSetSensitive(bt.frame,sensitive);
  XtSetSensitive(bt.panedwindow,sensitive);
  XtSetSensitive(bt.radiobox,sensitive);
  XtSetSensitive(bt.rowcolumn,sensitive);
  XtSetSensitive(bt.scale,sensitive);
  XtSetSensitive(bt.scrolledwindow,sensitive);
  XtSetSensitive(bt.mainwindow,sensitive);

  // Primitives
  XtSetSensitive(bt.arrowbutton,sensitive);
  XtSetSensitive(bt.drawnbutton,sensitive);
  XtSetSensitive(bt.list,sensitive);
  XtSetSensitive(bt.optionmenu,sensitive);
  XtSetSensitive(bt.pulldownmenu,sensitive);
  XtSetSensitive(bt.scrollbar,sensitive);
  XtSetSensitive(bt.separator,sensitive);
  XtSetSensitive(bt.textfield,sensitive);
  XtSetSensitive(bt.scrolledtext,sensitive);
  XtSetSensitive(bt.scrolledlist,sensitive);

  // Gadgets
  XtSetSensitive(bt.arrowbuttongadget,sensitive);
  XtSetSensitive(bt.separatorgadget,sensitive);
  break;
  case messagebox_v:
  // Managers
  XtSetSensitive(bt.mainwindow,sensitive);

  // Primitives
  XtSetSensitive(bt.cascadebutton,sensitive);
  XtSetSensitive(bt.pulldownmenu,sensitive);
  XtSetSensitive(bt.scrollbar,sensitive);
  XtSetSensitive(bt.separator,sensitive);

  // Gadgets
  XtSetSensitive(bt.arrowbuttongadget,sensitive);
  XtSetSensitive(bt.labelgadget,sensitive);
  XtSetSensitive(bt.cascadebuttongadget,sensitive);
  XtSetSensitive(bt.pushbuttongadget,sensitive);
  XtSetSensitive(bt.togglebuttongadget,sensitive);
  XtSetSensitive(bt.separatorgadget,sensitive);
  break;
  case optionmenu_v:
  // Managers
  XtSetSensitive(bt.bulletinboard,sensitive);
  XtSetSensitive(bt.form,sensitive);
  XtSetSensitive(bt.selectionbox,sensitive);
  XtSetSensitive(bt.command,sensitive);
  XtSetSensitive(bt.fileselectionbox,sensitive);
  XtSetSensitive(bt.messagebox,sensitive);
  XtSetSensitive(bt.menubar,sensitive);
  XtSetSensitive(bt.drawingarea,sensitive);
  XtSetSensitive(bt.frame,sensitive);
  XtSetSensitive(bt.panedwindow,sensitive);
  XtSetSensitive(bt.radiobox,sensitive);
  XtSetSensitive(bt.rowcolumn,sensitive);
  XtSetSensitive(bt.scale,sensitive);
  XtSetSensitive(bt.scrolledwindow,sensitive);
  XtSetSensitive(bt.mainwindow,sensitive);

  // Primitives
  XtSetSensitive(bt.arrowbutton,sensitive);
  XtSetSensitive(bt.label,sensitive);
  XtSetSensitive(bt.cascadebutton,sensitive);
  XtSetSensitive(bt.drawnbutton,sensitive);
  XtSetSensitive(bt.pushbutton,sensitive);
  XtSetSensitive(bt.togglebutton,sensitive);
  XtSetSensitive(bt.list,sensitive);
  XtSetSensitive(bt.optionmenu,sensitive);
  XtSetSensitive(bt.pulldownmenu,sensitive);
  XtSetSensitive(bt.scrollbar,sensitive);
  XtSetSensitive(bt.separator,sensitive);
  XtSetSensitive(bt.text,sensitive);
  XtSetSensitive(bt.textfield,sensitive);
  XtSetSensitive(bt.scrolledtext,sensitive);
  XtSetSensitive(bt.scrolledlist,sensitive);

  // Gadgets
  XtSetSensitive(bt.arrowbuttongadget,sensitive);
  XtSetSensitive(bt.labelgadget,sensitive);
  XtSetSensitive(bt.cascadebuttongadget,sensitive);
  XtSetSensitive(bt.pushbuttongadget,sensitive);
  XtSetSensitive(bt.togglebuttongadget,sensitive);
  XtSetSensitive(bt.separatorgadget,sensitive);
  break;
  case panedwindow_v:
  // Managers
  XtSetSensitive(bt.mainwindow,sensitive);

  // Primitives
  XtSetSensitive(bt.cascadebutton,sensitive);
  XtSetSensitive(bt.pulldownmenu,sensitive);

  // Gadgets
  XtSetSensitive(bt.arrowbuttongadget,sensitive);
  XtSetSensitive(bt.labelgadget,sensitive);
  XtSetSensitive(bt.cascadebuttongadget,sensitive);
  XtSetSensitive(bt.pushbuttongadget,sensitive);
  XtSetSensitive(bt.togglebuttongadget,sensitive);
  XtSetSensitive(bt.separatorgadget,sensitive);
  break;
  case popupmenu_v:
  // Managers
  XtSetSensitive(bt.bulletinboard,sensitive);
  XtSetSensitive(bt.form,sensitive);
  XtSetSensitive(bt.selectionbox,sensitive);
  XtSetSensitive(bt.command,sensitive);
  XtSetSensitive(bt.fileselectionbox,sensitive);
  XtSetSensitive(bt.messagebox,sensitive);
  XtSetSensitive(bt.menubar,sensitive);
  XtSetSensitive(bt.drawingarea,sensitive);
  XtSetSensitive(bt.frame,sensitive);
  XtSetSensitive(bt.panedwindow,sensitive);
  XtSetSensitive(bt.radiobox,sensitive);
  XtSetSensitive(bt.rowcolumn,sensitive);
  XtSetSensitive(bt.scale,sensitive);
  XtSetSensitive(bt.scrolledwindow,sensitive);
  XtSetSensitive(bt.mainwindow,sensitive);

  // Primitives
  XtSetSensitive(bt.arrowbutton,sensitive);
  XtSetSensitive(bt.label,sensitive);
  XtSetSensitive(bt.cascadebutton,sensitive);
  XtSetSensitive(bt.drawnbutton,sensitive);
  XtSetSensitive(bt.pushbutton,sensitive);
  XtSetSensitive(bt.togglebutton,sensitive);
  XtSetSensitive(bt.list,sensitive);
  XtSetSensitive(bt.optionmenu,sensitive);
  XtSetSensitive(bt.pulldownmenu,sensitive);
  XtSetSensitive(bt.scrollbar,sensitive);
  XtSetSensitive(bt.separator,sensitive);
  XtSetSensitive(bt.text,sensitive);
  XtSetSensitive(bt.textfield,sensitive);
  XtSetSensitive(bt.scrolledtext,sensitive);
  XtSetSensitive(bt.scrolledlist,sensitive);

  // Gadgets
  XtSetSensitive(bt.arrowbuttongadget,sensitive);
  XtSetSensitive(bt.labelgadget,sensitive);
  XtSetSensitive(bt.cascadebuttongadget,sensitive);
  XtSetSensitive(bt.pushbuttongadget,sensitive);
  XtSetSensitive(bt.togglebuttongadget,sensitive);
  XtSetSensitive(bt.separatorgadget,sensitive);
  break;
  case pulldownmenu_v:
  // Managers
  XtSetSensitive(bt.bulletinboard,sensitive);
  XtSetSensitive(bt.form,sensitive);
  XtSetSensitive(bt.selectionbox,sensitive);
  XtSetSensitive(bt.command,sensitive);
  XtSetSensitive(bt.fileselectionbox,sensitive);
  XtSetSensitive(bt.messagebox,sensitive);
  XtSetSensitive(bt.menubar,sensitive);
  XtSetSensitive(bt.drawingarea,sensitive);
  XtSetSensitive(bt.frame,sensitive);
  XtSetSensitive(bt.panedwindow,sensitive);
  XtSetSensitive(bt.radiobox,sensitive);
  XtSetSensitive(bt.rowcolumn,sensitive);
  XtSetSensitive(bt.scale,sensitive);
  XtSetSensitive(bt.scrolledwindow,sensitive);
  XtSetSensitive(bt.mainwindow,sensitive);

  // Primitives
  XtSetSensitive(bt.arrowbutton,sensitive);
  XtSetSensitive(bt.drawnbutton,sensitive);
  XtSetSensitive(bt.list,sensitive);
  XtSetSensitive(bt.optionmenu,sensitive);
  XtSetSensitive(bt.pulldownmenu,sensitive);
  XtSetSensitive(bt.scrollbar,sensitive);
  XtSetSensitive(bt.text,sensitive);
  XtSetSensitive(bt.textfield,sensitive);
  XtSetSensitive(bt.scrolledtext,sensitive);
  XtSetSensitive(bt.scrolledlist,sensitive);

  // Gadgets
  XtSetSensitive(bt.arrowbuttongadget,sensitive);
  XtSetSensitive(bt.cascadebuttongadget,sensitive);
  break;
  case radiobox_v:
  // Managers
  XtSetSensitive(bt.bulletinboard,sensitive);
  XtSetSensitive(bt.form,sensitive);
  XtSetSensitive(bt.selectionbox,sensitive);
  XtSetSensitive(bt.command,sensitive);
  XtSetSensitive(bt.fileselectionbox,sensitive);
  XtSetSensitive(bt.messagebox,sensitive);
  XtSetSensitive(bt.menubar,sensitive);
  XtSetSensitive(bt.drawingarea,sensitive);
  XtSetSensitive(bt.frame,sensitive);
  XtSetSensitive(bt.panedwindow,sensitive);
  XtSetSensitive(bt.radiobox,sensitive);
  XtSetSensitive(bt.rowcolumn,sensitive);
  XtSetSensitive(bt.scale,sensitive);
  XtSetSensitive(bt.scrolledwindow,sensitive);
  XtSetSensitive(bt.mainwindow,sensitive);

  // Primitives
  XtSetSensitive(bt.arrowbutton,sensitive);
  XtSetSensitive(bt.label,sensitive);
  XtSetSensitive(bt.cascadebutton,sensitive);
  XtSetSensitive(bt.drawnbutton,sensitive);
  XtSetSensitive(bt.pushbutton,sensitive);
  XtSetSensitive(bt.list,sensitive);
  XtSetSensitive(bt.optionmenu,sensitive);
  XtSetSensitive(bt.pulldownmenu,sensitive);
  XtSetSensitive(bt.scrollbar,sensitive);
  XtSetSensitive(bt.separator,sensitive);
  XtSetSensitive(bt.text,sensitive);
  XtSetSensitive(bt.textfield,sensitive);
  XtSetSensitive(bt.scrolledtext,sensitive);
  XtSetSensitive(bt.scrolledlist,sensitive);

  // Gadgets
  XtSetSensitive(bt.arrowbuttongadget,sensitive);
  XtSetSensitive(bt.labelgadget,sensitive);
  XtSetSensitive(bt.cascadebuttongadget,sensitive);
  XtSetSensitive(bt.pushbuttongadget,sensitive);
  XtSetSensitive(bt.separatorgadget,sensitive);
  break;
  case rowcolumn_v:
  // Managers
  XtSetSensitive(bt.mainwindow,sensitive);

  // Primitives
  XtSetSensitive(bt.pulldownmenu,sensitive);
  XtSetSensitive(bt.cascadebutton,sensitive);

  // Gadgets
  XtSetSensitive(bt.cascadebuttongadget,sensitive);
  break;
  case scrolledwindow_v:
  // Managers
  XtSetSensitive(bt.selectionbox,sensitive);
  XtSetSensitive(bt.command,sensitive);
  XtSetSensitive(bt.fileselectionbox,sensitive);
  XtSetSensitive(bt.messagebox,sensitive);
  XtSetSensitive(bt.menubar,sensitive);
  XtSetSensitive(bt.frame,sensitive);
  XtSetSensitive(bt.panedwindow,sensitive);
  XtSetSensitive(bt.radiobox,sensitive);
  XtSetSensitive(bt.scale,sensitive);
  XtSetSensitive(bt.scrolledwindow,sensitive);
  XtSetSensitive(bt.mainwindow,sensitive);

  // Primitives
  XtSetSensitive(bt.arrowbutton,sensitive);
  XtSetSensitive(bt.label,sensitive);
  XtSetSensitive(bt.cascadebutton,sensitive);
  XtSetSensitive(bt.drawnbutton,sensitive);
  XtSetSensitive(bt.pushbutton,sensitive);
  XtSetSensitive(bt.togglebutton,sensitive);
  XtSetSensitive(bt.list,sensitive);
  XtSetSensitive(bt.optionmenu,sensitive);
  XtSetSensitive(bt.pulldownmenu,sensitive);
  XtSetSensitive(bt.scrollbar,sensitive);
  XtSetSensitive(bt.separator,sensitive);
  XtSetSensitive(bt.text,sensitive);
  XtSetSensitive(bt.textfield,sensitive);
  XtSetSensitive(bt.scrolledtext,sensitive);
  XtSetSensitive(bt.scrolledlist,sensitive);

  // Gadgets
  XtSetSensitive(bt.arrowbuttongadget,sensitive);
  XtSetSensitive(bt.labelgadget,sensitive);
  XtSetSensitive(bt.cascadebuttongadget,sensitive);
  XtSetSensitive(bt.pushbuttongadget,sensitive);
  XtSetSensitive(bt.togglebuttongadget,sensitive);
  XtSetSensitive(bt.separatorgadget,sensitive);
  break;
  case selectionbox_v:
  // Managers
  XtSetSensitive(bt.bulletinboard,sensitive);
  XtSetSensitive(bt.form,sensitive);
  XtSetSensitive(bt.selectionbox,sensitive);
  XtSetSensitive(bt.command,sensitive);
  XtSetSensitive(bt.fileselectionbox,sensitive);
  XtSetSensitive(bt.messagebox,sensitive);
  XtSetSensitive(bt.menubar,sensitive);
  XtSetSensitive(bt.drawingarea,sensitive);
  XtSetSensitive(bt.frame,sensitive);
  XtSetSensitive(bt.panedwindow,sensitive);
  XtSetSensitive(bt.radiobox,sensitive);
  XtSetSensitive(bt.rowcolumn,sensitive);
  XtSetSensitive(bt.scale,sensitive);
  XtSetSensitive(bt.scrolledwindow,sensitive);
  XtSetSensitive(bt.mainwindow,sensitive);

  // Primitives
  XtSetSensitive(bt.arrowbutton,sensitive);
  XtSetSensitive(bt.label,sensitive);
  XtSetSensitive(bt.cascadebutton,sensitive);
  XtSetSensitive(bt.drawnbutton,sensitive);
  XtSetSensitive(bt.pushbutton,sensitive);
  XtSetSensitive(bt.togglebutton,sensitive);
  XtSetSensitive(bt.list,sensitive);
  XtSetSensitive(bt.optionmenu,sensitive);
  XtSetSensitive(bt.pulldownmenu,sensitive);
  XtSetSensitive(bt.scrollbar,sensitive);
  XtSetSensitive(bt.separator,sensitive);
  XtSetSensitive(bt.text,sensitive);
  XtSetSensitive(bt.textfield,sensitive);
  XtSetSensitive(bt.scrolledtext,sensitive);
  XtSetSensitive(bt.scrolledlist,sensitive);

  // Gadgets
  XtSetSensitive(bt.arrowbuttongadget,sensitive);
  XtSetSensitive(bt.labelgadget,sensitive);
  XtSetSensitive(bt.cascadebuttongadget,sensitive);
  XtSetSensitive(bt.pushbuttongadget,sensitive);
  XtSetSensitive(bt.togglebuttongadget,sensitive);
  XtSetSensitive(bt.separatorgadget,sensitive);
  break;
  case cascadebuttongadget_v:
  case cascadebutton_v:
  // Managers
  XtSetSensitive(bt.bulletinboard,sensitive);
  XtSetSensitive(bt.form,sensitive);
  XtSetSensitive(bt.selectionbox,sensitive);
  XtSetSensitive(bt.command,sensitive);
  XtSetSensitive(bt.fileselectionbox,sensitive);
  XtSetSensitive(bt.messagebox,sensitive);
  XtSetSensitive(bt.menubar,sensitive);
  XtSetSensitive(bt.drawingarea,sensitive);
  XtSetSensitive(bt.frame,sensitive);
  XtSetSensitive(bt.panedwindow,sensitive);
  XtSetSensitive(bt.radiobox,sensitive);
  XtSetSensitive(bt.rowcolumn,sensitive);
  XtSetSensitive(bt.scale,sensitive);
  XtSetSensitive(bt.scrolledwindow,sensitive);
  XtSetSensitive(bt.mainwindow,sensitive);

  // Primitives
  XtSetSensitive(bt.arrowbutton,sensitive);
  XtSetSensitive(bt.label,sensitive);
  XtSetSensitive(bt.cascadebutton,sensitive);
  XtSetSensitive(bt.drawnbutton,sensitive);
  XtSetSensitive(bt.pushbutton,sensitive);
  XtSetSensitive(bt.togglebutton,sensitive);
  XtSetSensitive(bt.list,sensitive);
  XtSetSensitive(bt.optionmenu,sensitive);
  XtSetSensitive(bt.scrollbar,sensitive);
  XtSetSensitive(bt.separator,sensitive);
  XtSetSensitive(bt.text,sensitive);
  XtSetSensitive(bt.textfield,sensitive);
  XtSetSensitive(bt.scrolledtext,sensitive);
  XtSetSensitive(bt.scrolledlist,sensitive);

  // Gadgets
  XtSetSensitive(bt.arrowbuttongadget,sensitive);
  XtSetSensitive(bt.labelgadget,sensitive);
  XtSetSensitive(bt.cascadebuttongadget,sensitive);
  XtSetSensitive(bt.pushbuttongadget,sensitive);
  XtSetSensitive(bt.togglebuttongadget,sensitive);
  XtSetSensitive(bt.separatorgadget,sensitive);
  break;

  case arrowbutton_v:
  case arrowbuttongadget_v:
  case drawnbutton_v:
  case label_v:
  case labelgadget_v:
  case list_v:
  case pushbutton_v:
  case pushbuttongadget_v:
  case scale_v:
  case scrollbar_v:
  case scrolledlist_v:
  case scrolledtext_v:
  case separator_v:
  case separatorgadget_v:
  case text_v:
  case textfield_v:
  case togglebutton_v:
  case togglebuttongadget_v:
    sensitise_all(False);
  break;
  default:
  break;
  }
}

void DesignEditor::sensitise_all(bool sensitive)
{

  // Managers
  XtSetSensitive(bt.bulletinboard,sensitive);
  XtSetSensitive(bt.form,sensitive);
  XtSetSensitive(bt.selectionbox,sensitive);
  XtSetSensitive(bt.command,sensitive);
  XtSetSensitive(bt.fileselectionbox,sensitive);
  XtSetSensitive(bt.messagebox,sensitive);
  XtSetSensitive(bt.menubar,sensitive);
  XtSetSensitive(bt.drawingarea,sensitive);
  XtSetSensitive(bt.frame,sensitive);
  XtSetSensitive(bt.panedwindow,sensitive);
  XtSetSensitive(bt.radiobox,sensitive);
  XtSetSensitive(bt.rowcolumn,sensitive);
  XtSetSensitive(bt.scale,sensitive);
  XtSetSensitive(bt.scrolledwindow,sensitive);
  XtSetSensitive(bt.mainwindow,sensitive);

  // Primitives
  XtSetSensitive(bt.arrowbutton,sensitive);
  XtSetSensitive(bt.label,sensitive);
  XtSetSensitive(bt.cascadebutton,sensitive);
  XtSetSensitive(bt.drawnbutton,sensitive);
  XtSetSensitive(bt.pushbutton,sensitive);
  XtSetSensitive(bt.togglebutton,sensitive);
  XtSetSensitive(bt.list,sensitive);
  XtSetSensitive(bt.optionmenu,sensitive);
  XtSetSensitive(bt.pulldownmenu,sensitive);
  XtSetSensitive(bt.scrollbar,sensitive);
  XtSetSensitive(bt.separator,sensitive);
  XtSetSensitive(bt.text,sensitive);
  XtSetSensitive(bt.textfield,sensitive);
  XtSetSensitive(bt.scrolledtext,sensitive);
  XtSetSensitive(bt.scrolledlist,sensitive);

  // Gadgets
  XtSetSensitive(bt.arrowbuttongadget,sensitive);
  XtSetSensitive(bt.labelgadget,sensitive);
  XtSetSensitive(bt.cascadebuttongadget,sensitive);
  XtSetSensitive(bt.pushbuttongadget,sensitive);
  XtSetSensitive(bt.togglebuttongadget,sensitive);
  XtSetSensitive(bt.separatorgadget,sensitive);

}

void DesignEditor::set_sensitive_pixmaps(void)
{
  Arg al[4];
  int ac = 0;

  XtSetArg(al[ac], XmNlabelInsensitivePixmap, 
	   (guide->get_PixmapServer())->get_pixmap((widget_type_enum)0)); ac++;

  // Managers
  XtSetValues(bt.bulletinboard,al,ac);
  XtSetValues(bt.form,al,ac);
  XtSetValues(bt.selectionbox,al,ac);
  XtSetValues(bt.command,al,ac);
  XtSetValues(bt.fileselectionbox,al,ac);
  XtSetValues(bt.messagebox,al,ac);
  XtSetValues(bt.menubar,al,ac);
  XtSetValues(bt.drawingarea,al,ac);
  XtSetValues(bt.frame,al,ac);
  XtSetValues(bt.panedwindow,al,ac);
  XtSetValues(bt.radiobox,al,ac);
  XtSetValues(bt.rowcolumn,al,ac);
  XtSetValues(bt.scale,al,ac);
  XtSetValues(bt.scrolledwindow,al,ac);
  XtSetValues(bt.mainwindow,al,ac);

  // Primitives
  XtSetValues(bt.arrowbutton,al,ac);
  XtSetValues(bt.label,al,ac);
  XtSetValues(bt.cascadebutton,al,ac);
  XtSetValues(bt.drawnbutton,al,ac);
  XtSetValues(bt.pushbutton,al,ac);
  XtSetValues(bt.togglebutton,al,ac);
  XtSetValues(bt.list,al,ac);
  XtSetValues(bt.optionmenu,al,ac);
  XtSetValues(bt.pulldownmenu,al,ac);
  XtSetValues(bt.scrollbar,al,ac);
  XtSetValues(bt.separator,al,ac);
  XtSetValues(bt.text,al,ac);
  XtSetValues(bt.textfield,al,ac);
  XtSetValues(bt.scrolledtext,al,ac);
  XtSetValues(bt.scrolledlist,al,ac);

  // Gadgets
  XtSetValues(bt.arrowbuttongadget,al,ac);
  XtSetValues(bt.labelgadget,al,ac);
  XtSetValues(bt.cascadebuttongadget,al,ac);
  XtSetValues(bt.pushbuttongadget,al,ac);
  XtSetValues(bt.togglebuttongadget,al,ac);
  XtSetValues(bt.separatorgadget,al,ac);
}
