/* ConstraintEditor.h */

#ifndef _CONSTRAINTEDITOR_H
#define _CONSTRAINTEDITOR_H

#include "Classes.h"

#ifndef DEFAULT_TYPE
#define DEFAULT_TYPE
typedef int DefaultType;
#endif

/*oodB:ConstraintEditor********** Documentation **************/
// Creation Data : Mon Nov 11 13:31:07 1996
// Programmer : Automatic
// Revised Date :
/* Purpose of Class ConstraintEditor :

*/
/*oodE********************************************************/
/*oodB#ConstraintEditor*** Some Definitions and Stuffs *******/
#include "public.h"
#include "Guide.h"
#include "WidgetObj.h"
#include "Resource.h"
#include "Factory.h"
#include "DesignEditor.h"
#include "List.h"
#include "ListIterator.h"
enum layout_menu_enum {
  // File menu
  layout_undo_v,
  layout_close_v,
  // Constraint menu
  layout_attachment_v,
  layout_position_v,
  layout_group_v,
  // Help menu
  layout_help_v
};
typedef enum layout_menu_enum layout_menu_enum;
/*oodE********************************************************/
class ConstraintEditor {
friend void display_warning(char * msg);
private:
        WidgetObj * _src;
        WidgetObj * _dest;
        Widget _Constraint;
        Widget _offset_text;
        Widget _position_text;
        Widget _area;
        int _position;
        int _offset;
        int _x1;
        int _y1;
        int _x2;
        int _y2;
        int _x3;
        int _y3;
        int _ox1;
        int _oy1;
        int _ox2;
        int _oy2;
        int _ox3;
        int _oy3;
        GC _rubber_gc,_red_gc,_blue_gc;
        bool _is_popped;
        layout_menu_enum _mode;
protected : // member functions
	void init();
        void create_window(void);
        void update_area(void);
        void draw_widgets(void);
        void draw_attachments(void);
        void draw_positions(void);
        void draw_all(void);
        void attach_form(selection_enum sel,WidgetObj *src,WidgetObj *dest);
        void attach_opposite_form(selection_enum sel,WidgetObj *src,WidgetObj *dest);
        void attach_widget(selection_enum sel,WidgetObj *src,WidgetObj *dest);
        void attach_none(selection_enum sel,WidgetObj *src);
        void attach_self(selection_enum sel,WidgetObj *src);
        void clear_attachments(selection_enum sel,WidgetObj *src);
        void attach_opposite_widget(selection_enum sel,WidgetObj *src,WidgetObj *dest);
public : // member functions
	ConstraintEditor();
	~ConstraintEditor();
        void attach(WidgetObj * src, WidgetObj * dest);
        void position(WidgetObj * src);
        void hilight_border(WidgetObj * wo);
        void hilight_widget(WidgetObj * wo, int x, int y);
        void popup();
        void popdown();
        void attachment_mode(void);
        void position_mode(void);
        void group_mode(void);
        void set_position(void);
        void set_offset(void);
        void draw_line(Widget w,XEvent * event);
        void move_widget(Widget w, XEvent * event);
        void set_x1(int x);
        void set_y1(int y);
        void set_x2(int x);
        void set_y2(int y);
        void set_x3(int x);
        void set_y3(int y);
        void set_src(WidgetObj * src);
        bool is_popped(void);
        void update(void);
        void show_attachments(void);
        GC CreateXorGC(Display * display, 
               Drawable drawable,
               unsigned long fg,
               unsigned long bg);
	static void set_offset_CB(Widget w,
				  XtPointer clientdata,
				  XtPointer calldata);
	static void set_position_CB(Widget w,
				    XtPointer clientdata,
				    XtPointer calldata);
        static void menu_button_CB(Widget w,
				   XtPointer clientdata,
				   XtPointer calldata);
        static void input_CB(Widget w, 
			     XtPointer clientdata, 
			     XtPointer calldata);
        static void refresh_CB(Widget w, 
			       XtPointer clientdata, 
			       XtPointer calldata);
        static void draw_line_EV(Widget w, 
				 XtPointer client_data, 
				 XEvent * event, 
				 char * dummy);
        static void move_widget_EV(Widget w, 
				   XtPointer client_data, 
				   XEvent * event, 
				   char * dummy);
};

#endif
