/* CodeGenerator.h */

#ifndef _CODEGENERATOR_H
#define _CODEGENERATOR_H

#include "Classes.h"

#ifndef DEFAULT_TYPE
#define DEFAULT_TYPE
typedef int DefaultType;
#endif

/*oodB:CodeGenerator********** Documentation **************/
// Creation Date : Sat Dec 14 21:34:14 1996
// Programmer : Automatic
// Revised Date : 
/* Purpose of Class CodeGenerator :
 
*/
/*oodE*****************************************************/
/*oodB#CodeGenerator*** Some Definitions and Stuffs *******/
#include "public.h"
#include "List.h"
#include "ListIterator.h"
#include "InterfaceObj.h"
#include "WidgetObj.h"
/*oodE*****************************************************/

class CodeGenerator {
        friend void display_warning(char * msg);

private : // member functions
	void init(char * name);
        void generate_c_code(List<InterfaceObj> *ilist);
        void generate_cpp_code(List<InterfaceObj> *ilist);
        void generate_resource_code(List<InterfaceObj> *ilist);
        void generate_smalltalk_code(List<InterfaceObj> *ilist);
        void generate_main_code(List<InterfaceObj> *ilist);
        void generate_callback_code(List<InterfaceObj> *ilist);
        void generate_event_code(List<InterfaceObj> *ilist);
        void generate_include_code(List<InterfaceObj> *ilist);
        void generate_makefile_code(List<InterfaceObj> *ilist);
        void generate_interface_file(WidgetObj *wo);
        void generate_XmCreateObject(char * func_name, 
				     ofstream *output,
				     WidgetObj * wo);
        void set_options(void);
public : // member functions
	CodeGenerator(char * name);
	~CodeGenerator();
	void create_code(code_type_enum language);
        void generate_code(widget_type_enum type,
			   ofstream *output,
			   WidgetObj * wo);
private:
        char _event_file[MAX_STRING];
        char _callback_file[MAX_STRING];
        char _public_file[MAX_STRING];
        char _interface_file[MAX_STRING];
	char _application[MAX_STRING];
        char _project_dir[MAX_STRING];
        char _pixmap_dir[MAX_STRING];
        char _resource_dir[MAX_STRING];
        char _includes[MAX_STRING];
        char _c_compiler[MAX_STRING];
        char _c_flags[MAX_STRING];
        char _cpp_compiler[MAX_STRING];
        char _cpp_flags[MAX_STRING];
        char _motif_lib[MAX_STRING];
        char _xt_lib[MAX_STRING];
        char _x11_lib[MAX_STRING];
};

#endif
