#include	<stdio.h>
#include	<X11/Intrinsic.h>
#include	<X11/IntrinsicP.h>
#include	<X11/StringDefs.h>
#include	<X11/Shell.h>
#include	<X11/Xaw/Box.h>
#include	<X11/Xaw/Command.h>
#include <ctype.h>

/* This file is
   Copyright 1991 Robert H. Forsman Jr.
   Gnu General Public License
	<thoth@manatee.cis.ufl.edu>
	4010 Oak Hammmock Ln
	Ft Pierce, FL  33450

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   */
static char ego[] = "Copyright 1991 Robert H. Forsman Jr. \
<thoth@manatee.cis.ufl.edu>\n Gnu General Public License";

Display	*disp;
int	scrn;

Widget	master,box;

struct XQueryRootResources{
  String	displayname;
  String	pixmaps;
  Pixmap	pmap;
} XQRres;

XtAppContext	app_con;
#define offset(field) XtOffset(struct XQueryRootResources*,field)

void Quit_Application(/* Widget,XEvent*,String*,Cardinal* */);
volatile void dump_core();

static XrmOptionDescRec Options[] = {
  {"-display",	"display",	XrmoptionSepArg,	NULL},
};

static XtResource SubResources[] = {
  {"pixmap","Pixmap",XtRPixmap,sizeof(Pixmap),offset(pmap),
     XtRString, NULL},
};
XtResource	*SRCopy;

static XtResource Resources[] = {
  {"display","Display",XtRString,sizeof(String),offset(displayname),
     XtRString, NULL},
  {"pixmaps","Pixmaps",XtRString,sizeof(String),offset(pixmaps),
     XtRString, NULL},
};

XtActionsRec Actions[] = {
  {"quit-application",	Quit_Application},
};

static String fallback_resources[] = {
  "*allowShellResize: true",
  NULL
};


static XtConvertArgRec screenConvertArg[] = {
  {XtBaseOffset, (caddr_t) XtOffset(Widget, core.screen), sizeof(Screen *)}
};
static XtConvertArgRec screenConvertArg2[] = {
  {XtBaseOffset, (caddr_t) XtOffset(Widget, core.screen), sizeof(Screen *)},
  {XtBaseOffset, (caddr_t) XtOffset(Widget, core.colormap), sizeof(Colormap)}
};


void XmuCvtStringToBitmap( XrmValuePtr, Cardinal, XrmValuePtr, XrmValuePtr);
void XmuCvtStringToPixmap( XrmValuePtr, Cardinal, XrmValuePtr, XrmValuePtr);
void CvtStringToColormap( XrmValuePtr, Cardinal, XrmValuePtr, XrmValuePtr);

void Quit_Application(Widget w,XEvent *event,String *argv,Cardinal *argc)

{
  printf("Goodbye!\n");
/*  XtDestroyApplicationContext(app_con);*/
  exit(0);
}




volatile int kill(int,int);

volatile void dump_core()
{
  fprintf(stderr,"Prepare for core dump.\n");
  *(char*)NULL = 0;
}

void SetBoxBackground(Widget w,caddr_t client_data,caddr_t call_data)
{
  Pixmap pmap = (Pixmap)client_data;
  XtVaSetValues(box, XtNbackgroundPixmap, pmap, NULL);
}

main (argc,argv)
unsigned int argc;
char *argv[];

{
  int	i;
  XtCallbackRec cblist[] = { {SetBoxBackground,NULL}, {NULL,NULL} };

  master = XtVaAppInitialize(&app_con,"BackgroundTest",Options,
			     XtNumber(Options), &argc,(String*)argv,
			     (String*)fallback_resources,0);

  XtAddConverter("String", "Bitmap", XmuCvtStringToBitmap,
		   screenConvertArg, XtNumber(screenConvertArg));
  XtAddConverter("String", "Pixmap", XmuCvtStringToPixmap,
		   screenConvertArg2, XtNumber(screenConvertArg2));

  XtGetApplicationResources(master,&XQRres,Resources,
			    XtNumber(Resources),NULL,0);
  XtAppAddActions(app_con,Actions,XtNumber(Actions));


  disp = XtDisplay(master);
  scrn = DefaultScreen(disp);

  box = XtVaCreateManagedWidget("box", boxWidgetClass, master,
			  NULL);
  {
    char	*s, *p;

    s = XQRres.pixmaps;
    while (*s) {
      for (; *s && isspace(*s); s++)
	;
      p = s;
      printf("%s\n", p);
      for (; *s && !isspace(*s); s++)
	;
      *s='\0'; s++;
      SRCopy = malloc(sizeof(*SRCopy));
      bcopy(SubResources, SRCopy, sizeof(*SRCopy));

      SRCopy->resource_name = p;
      SRCopy->resource_class = p;
      XtVaGetSubresources(master, &XQRres, "pixmaps", "Pixmaps",
			  SRCopy, 1, NULL);
      printf("%x\n", XQRres.pmap);
      cblist[0].closure = (void*)XQRres.pmap;
      XtVaCreateManagedWidget(p, commandWidgetClass, box,
			      XtNcallback, cblist,
			      NULL);
    }
  }

  XtRealizeWidget(master);

  XtAppMainLoop(app_con);
}
