/**
*** XPG - Graphical User Interface for Postgres
*** Copyright (C) 1993  Ranen Goren (ranen@cs.huji.ac.il).

*** This program is free software; you can redistribute it and/or modify
*** it under the terms of the GNU General Public License as published by
*** the Free Software Foundation; either version 2 of the License, or
*** (at your option) any later version.

*** This program is distributed in the hope that it will be useful,
*** but WITHOUT ANY WARRANTY; without even the implied warranty of
*** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*** GNU General Public License for more details.

*** You should have received a copy of the GNU General Public License
*** along with this program; if not, write to the Free Software
*** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**/


#ifndef __XPG_H
#define __XPG_H

#include <Xm/Xm.h>



#define VERSION "1.0"
#define MAX_PG_CMD 4096
#define AUTO_OWNER_PERMISSIONS
#define CONSIDER_FIELD_NAMES True
#define IGNORE_LENGTH  False
#define FIND_LENGTH    True
#define NULL_VAL "--"
#define NULL_VAL_LEN 2     /* no need to recalc everytime */
#define VAL_PHOLDER "%%"   /* in external commands, replaced by array val */
#define NUM_MATH_ACTIONS 7

#define ATTR_1ST(rel)  ((rel)->class ? 1 : 0)
#define mathResultElem(mat, var, op)  (*((mat) + (var)*(NUM_MATH_ACTIONS) + (op)))



typedef struct AppResourceStruct
{
    String  database;
    String  class;
    Boolean showPg;
    Boolean helpSwitch;     /* used for temp. storage of the -help request */
}  APP_RESOURCE_STRUCT, *APP_RESOURCE_STRUCT_PTR;



typedef struct ResourceStruct
{
    XmFontList font;
    String  key;
    String  separator;
    String  printCmd;
    Boolean autoSort;
    int     floatPrecision;
    String  arrayCmd1;
    String  arrayCmd2;
    String  arrayCmd3;
    String  arrayCmdPath1;
    String  arrayCmdPath2;
    String  arrayCmdPath3;
    XmString  arrayCmdName1;
    XmString  arrayCmdName2;
    XmString  arrayCmdName3;
    Boolean printTotals;    /* is not a single array, to help XtOffset
			       must have the member otherPrintTotals next */
    Boolean otherPrintTotals[NUM_MATH_ACTIONS-1];
    String  yearRangeFrom, yearRangeTo;
    String  helpFile;       /* name of file which contains help about class */
}  RESOURCE_STRUCT, *RESOURCE_STRUCT_PTR;



typedef struct 
{
    char    *name;
    int     len;
    int     pgType;    /* internal coding of POSTGRES for the field type */
    int     keyList;   /* attrInfo[i].keyList is the attr # of the i'th key.
			  This is more like keyList[i].attrNumber. It's
			  really disgusting, I know... */
}  attributeInfo;



typedef struct
{
    Boolean totalActions[NUM_MATH_ACTIONS];
}  printingOptions;



typedef struct
{
    Boolean append;
    Boolean read;
    Boolean write;
    Boolean rules;         /* not implemented and probably never will be */
}  permStruct;



typedef struct 
{
    RESOURCE_STRUCT res;
    permStruct perms;
    char   *class;
    char   *portal;
    char   *keyAttr;
    char   *arrayName;
    attributeInfo *attrInfo;
    printingOptions printOptions;
    int    numFields;
    Widget searchSh, arraySh;
    Widget top;
    Widget statLine;
    Widget mainW, mainBox;
    Widget records, fieldNames, key, keyTitle, leftBox, rightBox;
    Widget busyIcon;
}  relInfo;



enum busyStates
{
    SEND,
    RETR,
    PRINT,
    SCRIPT,
    BUSY,
    NOBUSY,
};



enum mathActions     /* shared between math_ops.c and xpg.c */
{
    SUM = 0,
    PRODUCT,
    COUNT,
    AVERAGE,
    STDDEV,
    MMIN,
    MMAX,
};



typedef struct 
{
    relInfo *rel;
    Widget opsSh;
    int numFields;
    Widget *fields;
    enum mathActions action;
    Boolean allAttr;
    Boolean allTuples;
    Widget allAttrBut, allTuplesBut;
    String *results;
} mathCbsStruct;



#endif
