/* Color data file creator for xcfd.
   Eric F. Charlton, The University of Michigan, sometime in 1992.

   This program creates colors.dat files for use with xcfd.  The file
   is dumped to stdout.  Usage:

   makecols [n] > colors.dat

   [n] = number of colors, defaults to 100.

   The color selection is a fairly smooth blending from blue to green
   to yellow, red, and then purple.  

   Darren DeZeeuw of The University of Michigan is originally responsible
   for the color selection. */

#include <stdio.h>
#include <assert.h>

int
main(argc,argv)
     int argc;
     char **argv;
{
  int i,n;
  int r,g,b;
  int mid;
  int Err;
  

  if (argc > 1){
    Err = sscanf(argv[1],"%d",&n);
    assert(Err);
	}
  else{
   Err = fprintf(stderr,"PrettyColourMap Usage: number_of_colours \n");
   assert(Err);
   exit(0);
   } 

  Err = printf("%d\n",n);
  assert(Err);
  
  mid = n / 5;

  for (i=0; i<mid; i++) {
    r = 0;
    g = (i * 65535) / mid ;
    b = 65535 ;
    Err = printf("%d %d %d %d\n",i,r,g,b);
    assert(Err);
  }

  for (i=mid; i < 2*mid; i++) {
    b = (2*mid - i) * 65535 / mid;
    g = 65535 ;
    r = 0;
    Err = printf("%d %d %d %d\n",i,r,g,b);
    assert(Err);
  }

  for (i=2*mid; i< 3*mid; i++) {
    b = 0;
    g = 65535 ;
    r = (i - 2*mid) * 65535 / mid;
    Err = printf("%d %d %d %d\n",i,r,g,b);
    assert(Err);
  }

  for (i=3*mid; i < 4*mid; i++) {
    r = 65535;
    b = 0;
    g = (4*mid - i) * 65535 / mid ;
    Err = printf("%d %d %d %d\n",i,r,g,b);
    assert(Err);
  }

  for (i=4*mid; i < n; i++) {
    g = 0;
    r = 65535;
    b = (i - 4*mid) * 65535 / mid;
    Err = printf("%d %d %d %d\n",i,r,g,b);
    assert(Err);
  }

 return (0);
}
