/*
 * Copyright (C) 1992, 1993, Paul D. Hoad This file is part of the Xmgf
 * Software. For conditions of distribution and use, see the accompanying
 * README file.
 *
 * Vision Speech and Signal Processing Group . Dept. of Electronic Engineering.
 * University of Surrey. Guildford, Surrey. England. Phone: +44 483 300800
 * Ext 2753 Email: P.Hoad@ee.surrey.ac.uk
 */
#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <X11/cursorfont.h>
#include <Xm/MainW.h>

#include "XmgfStruct.h"
#include "XmgfGlobal.h"
#include "XmgfDefines.h"
#include "InitX.h"
#include "Init.h"
#include "3Droutines.h"
#include "Menus.h"
#include "callbacks.h"
#include "GUI.h"
#include "Fallback_res.h"
#include "Disp3DGF.h"
#include "VersionInfo.h"
#include "Parse.h"
#include "AutoCommand.h"
#include "BackDrop.h"
#include "XmgfKeyboard.h"

#include "BITMAPS/WarningBits.xbm"
#include "BITMAPS/BackForth.xbm"
#include "BITMAPS/BackForthMask.xbm"
#include "BITMAPS/ArrowGamma.xbm"
#include "BITMAPS/ArrowGammaMask.xbm"
#include "BITMAPS/ArrowTheta.xbm"
#include "BITMAPS/ArrowThetaMask.xbm"
#include "BITMAPS/ArrowPhi.xbm"
#include "BITMAPS/ArrowPhiMask.xbm"
#include "BITMAPS/HourGlass1.xbm"
#include "BITMAPS/HourGlass2.xbm"
#include "BITMAPS/HourGlass3.xbm"
#include "BITMAPS/HourGlass4.xbm"
#include "BITMAPS/HourGlass5.xbm"
#include "BITMAPS/HourGlass6.xbm"
#include "BITMAPS/HourGlass7.xbm"
#include "BITMAPS/HourGlass7Mask.xbm"
#include "BITMAPS/HourGlass8.xbm"
#include "BITMAPS/HourGlass8Mask.xbm"
#include "BITMAPS/HourGlass9.xbm"
#include "BITMAPS/HourGlass9Mask.xbm"
#include "BITMAPS/HourGlassMask.xbm"
#include "BITMAPS/Xmgf.xbm"

t_XmgfSets      gfSets;
t_LL            NameList,ColorNameList,All_Polys;
Window          w_Plan, w_Side, w_Frnt, w_Orth, w_Left, w_Right;
double           Scale_factor;
int      	ScaleNumber, defScale_factor,PointType;
int      	Theta, Phi, Gamma, Ox, Oy, Oz,defscal;
int      	defOX, defOY, defOZ, defTheta, defPhi, defGamma;
int      	WindowOpen, LoadOpen, SaveOpen, AppendOpen;
appresStruct    appres;
XtAppContext 	appContext;
int Midx = 256;
int Midy = 256;
Cursor SpinCursor, LeftRight, UpDown, BackForthCursor;
Cursor CurTheta, CurPhi, CurGamma;
Cursor Busy1, Busy2, Busy3, Busy4, Busy5, Busy6, Busy7, Busy8, Busy9;
Cursor DefaultCursor;
XmStringCharSet charset = (XmStringCharSet) XmSTRING_DEFAULT_CHARSET;
int viewtype = 0;


#ifndef _NO_PROTO
Pixmap *CreateDefaultPixmap(char *bits, int width, int height);
Cursor MakeXmgfCursor(char *bits, int width, int height, int x_hot, int y_hot, char *CurMask);
void SetUpCursors(void);
#else
Pixmap *CreateDefaultPixmap();
Cursor MakeXmgfCursor();
void SetUpCursors();

#endif

XtResource application_resources[] = {
	{"iconGeometry", "IconGeometry", XtRString, sizeof(char *),
	XtOffset(appresPtr, iconGeometry), XtRString, (caddr_t) NULL},
	{"xmgfwidth", "XmgfWidth", XtRInt, sizeof(int),
	XtOffset(appresPtr, XmgfWidth), XtRImmediate, (XtPointer) 1050},
	{"xmgfheight", "XmgfHeight", XtRInt, sizeof(int),
	XtOffset(appresPtr, XmgfHeight), XtRImmediate, (XtPointer) 800},
	{"xmgfsmallwidth", "XmgfSmallWidth", XtRInt, sizeof(int),
	XtOffset(appresPtr, XmgfSmallWidth), XtRImmediate, (XtPointer) 800},
	{"xmgfsmallheight", "XmgfSmallHeight", XtRInt, sizeof(int),
	XtOffset(appresPtr, XmgfSmallHeight), XtRImmediate, (XtPointer) 800},
	{"xmgfsmalliconwidth", "XmgfSmallIconWidth", XtRInt, sizeof(int),
	XtOffset(appresPtr, XmgfSmallIconWidth), XtRImmediate, (XtPointer) 690},
	{"lineButtColor", "LineButtColor", XtRPixel, sizeof(Pixel),
	XtOffset(appresPtr, LineButtColor), XtRString, "#00F"},
	{"lineThickColor", "LineThickColor", XtRPixel, sizeof(Pixel),
	XtOffset(appresPtr, LineThickColor), XtRString, "#000"},
	{"AboutfgColor", "AboutfgColor", XtRPixel, sizeof(Pixel),
	XtOffset(appresPtr, AboutfgColor), XtRString, "#000"},
	{"AboutbgColor", "AboutbgColor", XtRPixel, sizeof(Pixel),
	XtOffset(appresPtr, AboutbgColor), XtRString, "#ABC"},
	{"IconFGColour", "IconFGColour", XtRPixel, sizeof(Pixel),
	XtOffset(appresPtr, IconFGColour), XtRString, "#000"},
	{"IconBGColour", "IconBGColour", XtRPixel, sizeof(Pixel),
	XtOffset(appresPtr, IconBGColour), XtRString, "#ABC"},
	{"IconSFGColour", "IconSFGColour", XtRPixel, sizeof(Pixel),
	XtOffset(appresPtr, IconSFGColour), XtRString, "#000"},
	{"IconSBGColour", "IconSBGColour", XtRPixel, sizeof(Pixel),
	XtOffset(appresPtr, IconSBGColour), XtRString, "#ABC"},
	{"warningBitmapfg", "WarningBitmapfg", XtRPixel, sizeof(Pixel),
	XtOffset(appresPtr, WarningBitmapfg), XtRString, "Black"},
	{"warningBitmapbg", "WarningBitmapbg", XtRPixel, sizeof(Pixel),
	XtOffset(appresPtr, WarningBitmapbg), XtRString, "Yellow"},
	{"printername", "PrinterName", XtRString, sizeof(String),
	XtOffset(appresPtr, PrinterName), XtRImmediate, ""},
	{"compresscommand", "CompressCommand", XtRString, sizeof(String),
	XtOffset(appresPtr, CompressCommand), XtRImmediate, ""},
	{"gzipcommand", "GzipCommand", XtRString, sizeof(String),
	XtOffset(appresPtr, GZipCommand), XtRImmediate, ""},
	{"removecommand", "RemoveCommand", XtRString, sizeof(String),
	XtOffset(appresPtr, RemoveCommand), XtRImmediate, ""},
	{"GFDir", "GFDir", XtRString, sizeof(String),
	XtOffset(appresPtr, GFDir), XtRImmediate, "."},
	{"PGMDir", "PGMDir", XtRString, sizeof(String),
	XtOffset(appresPtr, PGMDir), XtRImmediate, "."},
	{"POSTDir", "POSTDir", XtRString, sizeof(String),
	XtOffset(appresPtr, POSTDir), XtRImmediate, "."},
	{"EPSDir", "EPSDir", XtRString, sizeof(String),
	XtOffset(appresPtr, EPSDir), XtRImmediate, "."},
	{"FIGDir", "FIGDir", XtRString, sizeof(String),
	XtOffset(appresPtr, FIGDir), XtRImmediate, "."},
	{"RAYDir", "RAYDir", XtRString, sizeof(String),
	XtOffset(appresPtr, RAYDir), XtRImmediate, "."},
	{"PARMDir", "PARMDir", XtRString, sizeof(String),
	XtOffset(appresPtr, PARMDir), XtRImmediate, "."},
	{"XBMDir", "XBMDir", XtRString, sizeof(String),
	XtOffset(appresPtr, XBMDir), XtRImmediate, "."},
	{"PBMDir", "PBMDir", XtRString, sizeof(String),
	XtOffset(appresPtr, PBMDir), XtRImmediate, "."},
	{"PPMDir", "PPMDir", XtRString, sizeof(String),
	XtOffset(appresPtr, PPMDir), XtRImmediate, "."},
	{"GIFDir", "GIFDir", XtRString, sizeof(String),
	XtOffset(appresPtr, GIFDir), XtRImmediate, "."},
	{"RASDir", "RASDir", XtRString, sizeof(String),
	XtOffset(appresPtr, RASDir), XtRImmediate, "."},
	{"IMGDir", "IMGDir", XtRString, sizeof(String),
	XtOffset(appresPtr, IMGDir), XtRImmediate, "."},
	{"MIFDir", "MIFDir", XtRString, sizeof(String),
	XtOffset(appresPtr, MIFDir), XtRImmediate, "."},
	{"ANIMDir", "ANIMDir", XtRString, sizeof(String),
	XtOffset(appresPtr, ANIMDir), XtRImmediate, "."},
	{"IMPORTDir", "IMPORTDir", XtRString, sizeof(String),
	XtOffset(appresPtr, IMPORTDir), XtRImmediate, "."},
	{"CMAPDir", "CMAPDir", XtRString, sizeof(String),
	XtOffset(appresPtr, CMAPDir), XtRImmediate, "."},
	{"off2gf", "off2gf", XtRString, sizeof(String),
	XtOffset(appresPtr, off2gf), XtRImmediate, "../filters/OFF2gf/off2gf"},
	{"nff2gf", "nff2gf", XtRString, sizeof(String),
	XtOffset(appresPtr, nff2gf), XtRImmediate, "../filters/NFF2gf/nff2gf"},
	{"ray2gf", "ray2gf", XtRString, sizeof(String),
	XtOffset(appresPtr, ray2gf), XtRImmediate, "../filters/RAY2gf/ray2gf"},
	{"sla2gf", "sla2gf", XtRString, sizeof(String),
	XtOffset(appresPtr, sla2gf), XtRImmediate, "../filters/SLA2gf/sla2gf"},
	{"obj2gf", "obj2gf", XtRString, sizeof(String),
	XtOffset(appresPtr, obj2gf), XtRImmediate, "../filters/OBJ2gf/obj2gf"},
	{"dxf2gf", "dxf2gf", XtRString, sizeof(String),
	XtOffset(appresPtr, dxf2gf), XtRImmediate, "../filters/DXF2gf/dxf2gf"},
	{"igrip2gf", "igrip2gf", XtRString, sizeof(String),
	XtOffset(appresPtr, igrip2gf), XtRImmediate,"../filters/IGRIP2gf/igrip2gf"},
	{"minicad2gf", "minicad2gf", XtRString, sizeof(String),
	XtOffset(appresPtr, minicad2gf), XtRImmediate, "../filters/MINICAD2gf/minicad2gf"},
	{"XMgfVersion", "XMgfVersion", XtRString, sizeof(String),
	XtOffset(appresPtr, XMgfVersion), XtRImmediate, "1"},
	{"XMgfRelease", "XMgfRelease", XtRString, sizeof(String),
	XtOffset(appresPtr, XMgfRelease), XtRImmediate, "3"},
	{"XMgfRelDate", "XMgfRelDate", XtRString, sizeof(String),
	XtOffset(appresPtr, XMgfRelDate), XtRImmediate, "23/8/93"},
};

XrmOptionDescRec options[] = {
	{"-iconGeometry", ".iconGeometry", XrmoptionSepArg, (caddr_t) NULL},
};


XtActionsRec XmgfActsTable[] = {
	{"quit",	(XtActionProc)QuitOper},
	{"no-op",	(XtActionProc)NoneOper},
	{"plustheta",	(XtActionProc)PlusThetaOper},
	{"minustheta",	(XtActionProc)MinusThetaOper},
	{"plusphi",	(XtActionProc)PlusPhiOper},
	{"minusphi",	(XtActionProc)MinusPhiOper},
	{"plusgamma",	(XtActionProc)PlusGammaOper},
	{"minusgamma",	(XtActionProc)MinusGammaOper},
	{"autorotate",	(XtActionProc)AutoRotateOper},
	{"near",	(XtActionProc)NearOper},
	{"far",		(XtActionProc)FarOper},
	{"buff",	(XtActionProc)DoubleOper},
	{NULL,NULL}
	};

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
int
main(argc, argv)
int argc;
char **argv;
{
	Arg args[10];
	XImage *Warning_image;
	Pixmap Icon;
	char XmgfName[100];


	/* Set Up as much as Possible */
	gfSets.ListXmgfSets = ConsLL();
	InitDraw();
	NameList = ConsLL();
	ColorNameList = ConsLL();
	InitGlobalVar();

	/* main routine, set up windows, then give control to X */
	WindowOpen = 0;
	LoadOpen = 0;
	SaveOpen = 0;
	AppendOpen = 0;

	/* SetUp Waring Symbols */
	Warning_image = CreateDefaultImage(WarningBits_bits, WarningBits_width, WarningBits_height);
	XmInstallImage(Warning_image, "Warning_image");


	/* |//////////////   Create The Application   \\\\\\\\\\\\\\\\\| */
	toplevel = XtAppInitialize(&appContext, "XMgf", (XrmOptionDescList) options,
		XtNumber(options), &argc, argv, fallbackResources, NULL, 0);
	XtAppAddActions(appContext, XmgfActsTable, XtNumber(XmgfActsTable));
	XtGetApplicationResources(toplevel, &appres, application_resources,
		XtNumber(application_resources), NULL, 0);
	/* |//////////////   Parse The Command Line   \\\\\\\\\\\\\\\\\| */
{
/*
#include <X11/Xmu/Editres.h>
        XtAddEventHandler(toplevel, (EventMask) 0, True,
                _XEditResCheckMessages, NULL);
*/
}
	ReadInit();
	ParseCommandLine(argc, argv);
	InitViewScale();

	/* |//////////////   Open the main window  \\\\\\\\\\\\\\\\\| */

	if(MAINPANEL){
	XtSetArg(args[0], XtNwidth, (int) appres.XmgfWidth);
	XtSetArg(args[1], XtNheight, (int) appres.XmgfHeight);
	}
	else if (!ICONPANEL){
	XtSetArg(args[0], XtNwidth, (int) appres.XmgfSmallWidth);
	XtSetArg(args[1], XtNheight, (int) appres.XmgfSmallHeight);
	}
	else{
	XtSetArg(args[0], XtNwidth, (int) appres.XmgfSmallIconWidth);
	XtSetArg(args[1], XtNheight, (int) appres.XmgfSmallHeight);
	}

	main_window = XmCreateMainWindow(toplevel, "main1", args, 2);
	XtManageChild(main_window);

	/* |//////////////   Find the Display CMap \\\\\\\\\\\\\\\\\| */
	theDisplay = XtDisplay(toplevel);
	theGC = DefaultGC(theDisplay, theScreen);
	theCMap = DefaultColormap(theDisplay, theScreen);
	InitColors();

	/* |//////////////   Create the GUI        \\\\\\\\\\\\\\\\\| */
	create_master_widgets();

	/* |//////////////Set Up Title bar and Icon\\\\\\\\\\\\\\\\\| */
	sprintf(XmgfName, "Xmgf - %s.%s Release Date: %s ",
		XMGFVERSION, XMGFRELEASE, RELEASEDATE);
	Icon = XCreateBitmapFromData(theDisplay, XtWindow(toplevel),
		(char *) Xmgf_bits, Xmgf_width, Xmgf_height);
	XtSetArg(args[0], XtNtitle, XmgfName);
	XtSetArg(args[1], XtNiconPixmap, Icon);
	XtSetValues(toplevel, args, 2);

	/* |//////////////Set Up Screen Cursors    \\\\\\\\\\\\\\\\\| */
	SetUpCursors();
	while (!XtIsRealized(Orthdr)) {
	}			/* Wait Until drawing window open is realised */
	WindowOpen = 1;
	InitFiles();
	ResetScaleNoRedraw();
	ChangeAngleLab();
	SetToggles();
	ChangeCurrentFile(CurrentFile);
#ifdef REDRAW
	DrawAllSets();
#endif
	if (AutoCommand) XtAppAddWorkProc(appContext, start_up, NULL );
	XmgfMessage("Welcome to Xmgf");
	XtAppMainLoop(appContext);
	return 0;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
XImage *
CreateDefaultImage(bits, width, height)
char *bits;
int width;
int height;
{
	XImage *Icon;

	Icon = (XImage *) XtMalloc(sizeof(XImage));
	Icon->width = width;
	Icon->height = height;
	Icon->data = bits;
	Icon->depth = 1;
	Icon->xoffset = 0;
	Icon->format = XYBitmap;
	Icon->byte_order = LSBFirst;
	Icon->bitmap_unit = 8;
	Icon->bitmap_bit_order = LSBFirst;
	Icon->bitmap_pad = 8;
	Icon->bytes_per_line = (width + 7) / 8;
	return (Icon);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
Pixmap *
CreateDefaultPixmap(bits, width, height)
char *bits;
int width;
int height;
{
	Pixmap *image;

	image = (Pixmap *) XCreatePixmapFromBitmapData
		(theDisplay, RootWindow(theDisplay, theScreen), (char *) bits,(unsigned int) width,(unsigned int) height, 1, 0, 1);
	return image;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
Cursor
MakeXmgfCursor(bits, width, height, x_hot, y_hot, curmask)
char *bits;
int width;
int height;
int x_hot;
int y_hot;
char *curmask;
{
	Pixmap Pix, MKPix;
	XColor fg, bg;
	Cursor NewCursor;

	Pix = (Pixmap) CreateDefaultPixmap((char *) bits, width, height);
	MKPix = (Pixmap) CreateDefaultPixmap((char *) curmask, width, height);
	XParseColor(theDisplay, theCMap, "White", &fg);
	XParseColor(theDisplay, theCMap, "Black", &bg);
	NewCursor = XCreatePixmapCursor(theDisplay, Pix, MKPix, &fg, &bg,(unsigned int) x_hot,(unsigned int) y_hot);
	XFreePixmap(theDisplay, Pix);
	XFreePixmap(theDisplay, MKPix);
	return NewCursor;
}

void
BusyCursor()
{
	static int BusyFlag = 1;
	Cursor CurrentCursor;

	CurrentCursor = Busy1;

	switch (BusyFlag) {
	    case 1:
		CurrentCursor = Busy9;
		break;
	    case 2:
		CurrentCursor = Busy8;
		break;
	    case 3:
		CurrentCursor = Busy7;
		break;
	    case 4:
		CurrentCursor = Busy6;
		break;
	    case 5:
		CurrentCursor = Busy5;
		break;
	    case 6:
		CurrentCursor = Busy4;
		break;
	    case 7:
		CurrentCursor = Busy3;
		break;
	    case 8:
		CurrentCursor = Busy2;
		break;
	    case 9:
		CurrentCursor = Busy1;
		break;
	}
	BusyFlag++;
	if (BusyFlag > 9)
		BusyFlag = 1;
	XDefineCursor(theDisplay, XtWindow(toplevel), CurrentCursor);
	XDefineCursor(theDisplay, w_Orth, CurrentCursor);
#ifdef MAIN_PANEL
	XDefineCursor(theDisplay, XtWindow(OY), CurrentCursor);
	XDefineCursor(theDisplay, XtWindow(OX), CurrentCursor);
	XDefineCursor(theDisplay, XtWindow(OZ), CurrentCursor);
	XDefineCursor(theDisplay, XtWindow(w_Theta), CurrentCursor);
	XDefineCursor(theDisplay, XtWindow(w_Gamma), CurrentCursor);
	XDefineCursor(theDisplay, XtWindow(w_Phi), CurrentCursor);
#endif
	if (LoadOpen)
		XDefineCursor(theDisplay, XtWindow(FileSelector), CurrentCursor);

}

void
DoneCursor()
{
	XDefineCursor(theDisplay, XtWindow(toplevel), DefaultCursor);
	XDefineCursor(theDisplay, w_Orth, SpinCursor);
#ifdef MAIN_PANEL
	XDefineCursor(theDisplay, XtWindow(OY), UpDown);
	XDefineCursor(theDisplay, XtWindow(OX), LeftRight);
	XDefineCursor(theDisplay, XtWindow(OZ), BackForthCursor);
	XDefineCursor(theDisplay, XtWindow(w_Theta), CurGamma);
	XDefineCursor(theDisplay, XtWindow(w_Gamma), CurTheta);
	XDefineCursor(theDisplay, XtWindow(w_Phi), CurPhi);
#endif
	if (LoadOpen)
		XDefineCursor(theDisplay, XtWindow(FileSelector), DefaultCursor);

}

void
SetUpCursors()
{
	/* X Made Cursors */
	SpinCursor = XCreateFontCursor(theDisplay, XC_arrow);
	LeftRight = XCreateFontCursor(theDisplay, XC_sb_h_double_arrow);
	UpDown = XCreateFontCursor(theDisplay, XC_sb_v_double_arrow);
	DefaultCursor = XCreateFontCursor(theDisplay, XC_arrow);

	/* Self Made Cursors */
	BackForthCursor = MakeXmgfCursor(BackForth_bits, BackForth_width, BackForth_height,
		BackForth_x_hot, BackForth_y_hot, BackForthMask_bits);
	CurGamma = MakeXmgfCursor(ArrowGamma_bits, ArrowGamma_width, ArrowGamma_height,
		ArrowGamma_x_hot, ArrowGamma_y_hot, ArrowGammaMask_bits);
	CurTheta = MakeXmgfCursor(ArrowTheta_bits, ArrowTheta_width, ArrowTheta_height,
		ArrowTheta_x_hot, ArrowTheta_y_hot, ArrowThetaMask_bits);
	CurPhi = MakeXmgfCursor(ArrowPhi_bits, ArrowPhi_width, ArrowPhi_height,
		ArrowPhi_x_hot, ArrowPhi_y_hot, ArrowPhiMask_bits);
	Busy1 = MakeXmgfCursor(HourGlass1_bits, HourGlass1_width, HourGlass1_height,
		HourGlass1_x_hot, HourGlass1_y_hot, HourGlassMask_bits);
	Busy2 = MakeXmgfCursor(HourGlass2_bits, HourGlass1_width, HourGlass1_height,
		HourGlass1_x_hot, HourGlass1_y_hot, HourGlassMask_bits);
	Busy3 = MakeXmgfCursor(HourGlass3_bits, HourGlass1_width, HourGlass1_height,
		HourGlass1_x_hot, HourGlass1_y_hot, HourGlassMask_bits);
	Busy4 = MakeXmgfCursor(HourGlass4_bits, HourGlass1_width, HourGlass1_height,
		HourGlass1_x_hot, HourGlass1_y_hot, HourGlassMask_bits);
	Busy5 = MakeXmgfCursor(HourGlass5_bits, HourGlass1_width, HourGlass1_height,
		HourGlass1_x_hot, HourGlass1_y_hot, HourGlassMask_bits);
	Busy6 = MakeXmgfCursor(HourGlass6_bits, HourGlass1_width, HourGlass1_height,
		HourGlass1_x_hot, HourGlass1_y_hot, HourGlassMask_bits);
	Busy7 = MakeXmgfCursor(HourGlass7_bits, HourGlass7_width, HourGlass7_height,
		HourGlass7_x_hot, HourGlass7_y_hot, HourGlass7Mask_bits);
	Busy8 = MakeXmgfCursor(HourGlass8_bits, HourGlass8_width, HourGlass8_height,
		HourGlass8_x_hot, HourGlass8_y_hot, HourGlass8Mask_bits);
	Busy9 = MakeXmgfCursor(HourGlass9_bits, HourGlass9_width, HourGlass9_height,
		HourGlass9_x_hot, HourGlass9_y_hot, HourGlass9Mask_bits);

}
