/*
 * Copyright (C) 1992, 1993, Paul D. Hoad This file is part of the Xmgf
 * Software. For conditions of distribution and use, see the accompanying
 * README file.
 *
 * Vision Speech and Signal Processing Group . Dept. of Electronic Engineering.
 * University of Surrey. Guildford, Surrey. England. Phone: +44 483 300800
 * Ext 2753 Email: P.Hoad@ee.surrey.ac.uk
 */
#include <assert.h>

#include <Xm/Form.h>
#include <Xm/DrawingA.h>
#include <Xm/Frame.h>
#include <Xm/RowColumn.h>
#include <X11/IntrinsicP.h>
#include "XmgfStruct.h"
#include "XmgfGlobal.h"
#include "XmgfDefines.h"
#include "InitX.h"
#include "ViewType.h"
#include "callbacks.h"
#include "Orth.h"
#include "Perspec.h"
#include "Stereo.h"
#include "Mouse.h"
#include "GUI.h"
#include "Parse.h"
#include "BackDrop.h"
#include "3Droutines.h"
#include "XmgfEvent.h"
#include "XmgfFont.h"

/* Font define stuff */
char *fontname;
int FontClass=ADOBE;
int FontFamily=HELVECTICA;
int FontWeight=BOLD;
int FontSlant=NOITALIC;
int FontSize=10;
int FontColour=0;


char *class[CLASS]={
        "adobe"
};
char *family[FAMILY] ={
        "courier","helvetica","new century schoolbook","symbol","times"
};
char *weight[WEIGHT]={
        "*","bold","medium"
};
char *slant[SLANT]={
        "*","o","r"
};

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SetView(ViewType)
int ViewType;
{
	if (ViewType == 1)
		viewtype = 0;
	else
		viewtype = 1;
	XtDestroyWidget(ViewManager);

	switch (viewtype) {
	    case VIEW_PERS:{
#ifdef DEBUG
			fprintf(stderr, "Perspective View %d\n", viewtype);
#endif
			create_Perspective_widget(graphicspane, 512);
			break;
		}
	    case VIEW_ORTH:{
#ifdef DEBUG
			fprintf(stderr, "Engineering View %d\n", viewtype);
#endif
			create_Ortho_widgets(graphicspane, 256);
			break;
		}
	    case VIEW_STEREO:{
#ifdef DEBUG
			fprintf(stderr, "Stereo View %d\n", viewtype);
#endif
			create_Stereo_widgets(graphicspane, 256);
			break;
		}
	}

	if (viewtype == 1) {
		ScaleNumber = ScaleNumber / 2;
		Midx = 128;
		Midy = 128;
	}
	if (viewtype == 0) {
		ScaleNumber = ScaleNumber * 2;
		Midx = 256;
		Midy = 256;
	}
	Scale_factor = LogScale(ScaleNumber);
	SetScale();
	Redraw();
	return;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
create_Perspective_widget(parent, Size)
Widget parent;
int Size;
{
	/* set up windows */
	Arg args[10];
	XGCValues gcv;
	XtGCMask gc_mask;
	Widget Orfr;
	Widget Orthfo;

	Size = 530;
	XtSetArg(args[0], XmNheight, Size);
	XtSetArg(args[1], XmNwidth, Size);
	ViewManager = XtCreateManagedWidget("ViewManager",
		xmFormWidgetClass, parent, args, 2);
	XtSetArg(args[2], XmNleftAttachment, XmATTACH_FORM);
	XtSetArg(args[3], XmNrightAttachment, XmATTACH_FORM);
/*	XtSetArg(args[4], XmNtopAttachment, XmATTACH_WIDGET);*/
/*	XtSetArg(args[5], XmNbottomAttachment, XmATTACH_WIDGET);*/
	XtSetArg(args[4], XmNtopAttachment, XmATTACH_FORM);
#ifndef MOTIF_1_2_X
       XtSetArg(args[5], XmNbottomAttachment, XmATTACH_FORM);
#else
       XtSetArg(args[5], XmNbottomAttachment, XmATTACH_WIDGET);
#endif
	Orfr = XtCreateManagedWidget("Orfr", xmFrameWidgetClass, ViewManager, args, 5);
	/* Drawing Region */
	XtSetArg(args[0], XmNheight, Size);
	XtSetArg(args[1], XmNwidth, Size);
	Orthfo = XtCreateManagedWidget("Orthfo", xmFormWidgetClass, Orfr, args, 2);
	Orthdr = XmCreateDrawingArea(Orthfo, "Orthdr", args, 2);
	XtAddEventHandler(Orthdr, 
		Button1MotionMask| Button2MotionMask |Button3MotionMask |
		PointerMotionMask| ExposureMask | ButtonPressMask | 
		ButtonReleaseMask | KeyPressMask , False, 
		(XtEventHandler) XmgfEvent, (caddr_t) NULL);
	XtManageChild(Orthdr);
	XtRealizeWidget(toplevel);
	while (!XtIsRealized(toplevel)) {
	}
	XtCreateWindow(Orthdr, InputOutput, CopyFromParent, 0L,0);
        w_Orth = XtWindow(Orthdr);
	/* create the GC */
	gc_mask = GCForeground | GCBackground | GCFunction
		| GCLineWidth | GCCapStyle | GCFillStyle ;
	gcv.foreground = BlackPixel(theDisplay, theScreen);
	gcv.background = WhitePixel(theDisplay, theScreen);
	gcv.line_width = 1;
	gcv.function = GXcopy;
	gcv.cap_style = CapRound;
	gcv.fill_style = FillSolid;
	theGC = XCreateGC(theDisplay, w_Orth, gc_mask, &gcv);
	InitTiles();

	/* Set Font Type */
	XmgfSetFont();

	XFlush(theDisplay);
	ChangeTile(0);
	return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
create_Stereo_widgets(parent, Size)
Widget parent;
int Size;
{
	/* set up windows */
	Arg args[10];
	XGCValues gcv;
        XtGCMask gc_mask;
	Widget Orfr, OrTopRC;
	Widget Orthfr, Orthfo;
	Widget Rightfr, Rightfo, Rightdr;

	Size = 256;
	XtSetArg(args[0], XmNheight, 2 * Size + 20);
	XtSetArg(args[1], XmNwidth, 2 * Size + 20);
	/* XtSetArg (args[2], XmNleftAttachment, XmATTACH_FORM); */
	/* XtSetArg (args[3], XmNrightAttachment, XmATTACH_FORM); */
	/* XtSetArg (args[4], XmNtopAttachment, XmATTACH_WIDGET); */
	ViewManager = XtCreateManagedWidget("ViewManager",
		xmFormWidgetClass, parent, args, 2);
	/* main button window */
	XtSetArg(args[0], XmNheight, Size);
	XtSetArg(args[2], XmNleftAttachment, XmATTACH_FORM);
	XtSetArg(args[3], XmNrightAttachment, XmATTACH_FORM);
/*	XtSetArg(args[4], XmNtopAttachment, XmATTACH_WIDGET);*/
	Orfr = XtCreateManagedWidget("Orfr", xmFrameWidgetClass, ViewManager, args, 4);
	XtSetArg(args[0], XmNpacking, XmPACK_TIGHT);
	XtSetArg(args[1], XmNnumColumns, 2);
	XtSetArg(args[2], XmNorientation, XmHORIZONTAL);
	XtSetArg(args[3], XmNheight, Size);
	XtSetArg(args[4], XmNwidth, 2 * Size);
	XtSetArg(args[5], XmNmarginWidth, 2);
	OrTopRC = XtCreateWidget("OrTopRC",
		xmRowColumnWidgetClass, Orfr, args, 6);
	XtSetArg(args[0], XmNheight, Size);
	XtSetArg(args[1], XmNwidth, Size);
	/* XtSetArg (args[2], XmNleftAttachment, XmATTACH_FORM); */
	/* XtSetArg (args[3], XmNrightAttachment, XmATTACH_FORM); */
	/* XtSetArg (args[4], XmNtopAttachment, XmATTACH_WIDGET); */
	Orthfr = XtCreateManagedWidget("Orthfr", xmFrameWidgetClass, OrTopRC, args, 3);
	Rightfr = XtCreateManagedWidget("Rightfr", xmFrameWidgetClass, OrTopRC, args, 3);
	XtManageChild(OrTopRC);


	/* Drawing Region */
	XtSetArg(args[0], XmNheight, Size);
	XtSetArg(args[1], XmNwidth, Size);
	Orthfo = XtCreateManagedWidget("Orthfo", xmFormWidgetClass, Orthfr, args, 2);
	Rightfo = XtCreateManagedWidget("Rightfo", xmFormWidgetClass, Rightfr, args, 2);
	Orthdr = XmCreateDrawingArea(Orthfo, "Orthdr", args, 2);
	Rightdr = XmCreateDrawingArea(Rightfo, "Rightdr", args, 2);
	XtAddEventHandler(Orthdr,
                Button1MotionMask| Button2MotionMask |Button3MotionMask |
                PointerMotionMask| ExposureMask | ButtonPressMask |
                ButtonReleaseMask | KeyPressMask, False,
                (XtEventHandler) XmgfEvent, (caddr_t) NULL);
	XtManageChild(Orthdr);
	XtManageChild(Rightdr);
	XtRealizeWidget(toplevel);
	while (!XtIsRealized(toplevel)) {
	}
	XtCreateWindow(Orthdr, InputOutput, CopyFromParent, 0L, 0);
	XtCreateWindow(Rightdr, InputOutput, CopyFromParent, 0L, 0);
	w_Orth = XtWindow(Orthdr);
	w_Right = XtWindow(Rightdr);
	/* create the GC */
        gc_mask = GCForeground | GCBackground | GCFunction
                | GCLineWidth | GCCapStyle | GCFillStyle ;
        gcv.foreground = BlackPixel(theDisplay, theScreen);
        gcv.background = WhitePixel(theDisplay, theScreen);
        gcv.line_width = 1;
        gcv.function = GXcopy;
        gcv.cap_style = CapRound;
        gcv.fill_style = FillSolid;
	theGC = XCreateGC(theDisplay, w_Orth, gc_mask, &gcv);
        InitTiles();

	XmgfSetFont();
	XFlush(theDisplay);
	return ;
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
create_Ortho_widgets(parent, Size)
Widget parent;
int Size;
{
	/* set up windows */
	Arg args[10];
	XGCValues gcv;
        XtGCMask gc_mask;
	Widget Orfr, OrColRC;

	/* OrTopRC,OrBotRC; */
	Widget Planfr, Planfo, Plandr;
	Widget Sidefr, Sidefo, Sidedr;
	Widget Frntfr, Frntfo, Frntdr;
	Widget Orthfr, Orthfo;

	Size = 256;
	XtSetArg(args[0], XmNheight, (2 * Size) + 20);
	XtSetArg(args[1], XmNwidth, (2 * Size) + 20);
	ViewManager = XtCreateManagedWidget("ViewManager",
		xmFormWidgetClass, parent, args, 2);
	/* main button window */
	XtSetArg(args[2], XmNrightAttachment, XmATTACH_FORM);
	XtSetArg(args[3], XmNleftAttachment, XmATTACH_FORM);
	Orfr = XtCreateManagedWidget("Orfr", xmFrameWidgetClass, ViewManager, args, 4);
	XtSetArg(args[0], XmNpacking, XmPACK_COLUMN);
	XtSetArg(args[1], XmNnumColumns, 2);
	XtSetArg(args[2], XmNorientation, XmHORIZONTAL);
	XtSetArg(args[3], XmNheight, 2 * Size);
	XtSetArg(args[4], XmNwidth, 2 * Size);
	XtSetArg(args[5], XmNmarginWidth, 5);
	OrColRC = XtCreateManagedWidget("OrColRC", xmRowColumnWidgetClass, Orfr, args, 6);

	XtSetArg(args[0], XmNheight, Size);
	XtSetArg(args[1], XmNwidth, Size);
	Planfr = XtCreateManagedWidget("Planfr",
		xmFrameWidgetClass, OrColRC, args, 2);
	Sidefr = XtCreateManagedWidget("Sidefr",
		xmFrameWidgetClass, OrColRC, args, 2);
	Frntfr = XtCreateManagedWidget("Frntfr",
		xmFrameWidgetClass, OrColRC, args, 2);
	Orthfr = XtCreateManagedWidget("Orthfo",
		xmFrameWidgetClass, OrColRC, args, 2);

	/* Drawing Region */
	XtSetArg(args[0], XmNheight, Size);
	XtSetArg(args[1], XmNwidth, Size);
	Planfo = XtCreateManagedWidget("Planfo",
		xmFormWidgetClass, Planfr, args, 2);
	Sidefo = XtCreateManagedWidget("Sidefo",
		xmFormWidgetClass, Sidefr, args, 2);
	Frntfo = XtCreateManagedWidget("Frntfo",
		xmFormWidgetClass, Frntfr, args, 2);
	Orthfo = XtCreateManagedWidget("Orthfo",
		xmFormWidgetClass, Orthfr, args, 2);
	Plandr = XmCreateDrawingArea(Planfo, "Plandr", args, 2);
	Sidedr = XmCreateDrawingArea(Sidefo, "Sidedr", args, 2);
	Frntdr = XmCreateDrawingArea(Frntfo, "Frntdr", args, 2);
	Orthdr = XmCreateDrawingArea(Orthfo, "Orthdr", args, 2);
	XtAddEventHandler(Orthdr,
                Button1MotionMask| Button2MotionMask |Button3MotionMask |
                PointerMotionMask| ExposureMask | ButtonPressMask |
                ButtonReleaseMask | KeyPressMask, False,
                (XtEventHandler) XmgfEvent, (caddr_t) NULL);
	XtManageChild(Plandr);
	XtManageChild(Sidedr);
	XtManageChild(Frntdr);
	XtManageChild(Orthdr);
	XtRealizeWidget(toplevel);
	while (!XtIsRealized(toplevel)) {
	}
	XtCreateWindow(Plandr, InputOutput, CopyFromParent, 0L, 0);
	XtCreateWindow(Sidedr, InputOutput, CopyFromParent, 0L, 0);
	XtCreateWindow(Frntdr, InputOutput, CopyFromParent, 0L, 0);
	XtCreateWindow(Orthdr, InputOutput, CopyFromParent, 0L, 0);
	w_Plan = XtWindow(Plandr);
	w_Side = XtWindow(Sidedr);
	w_Frnt = XtWindow(Frntdr);
	w_Orth = XtWindow(Orthdr);
	/* create the GC */

         gc_mask = GCForeground | GCBackground | GCFunction
                | GCLineWidth | GCCapStyle | GCFillStyle ;
        gcv.foreground = BlackPixel(theDisplay, theScreen);
        gcv.background = WhitePixel(theDisplay, theScreen);
        gcv.line_width = 1;
        gcv.function = GXcopy;
        gcv.cap_style = CapRound;
        gcv.fill_style = FillSolid;
        theGC = XCreateGC(theDisplay, w_Orth, gc_mask, &gcv);
        InitTiles();
	XmgfSetFont();
	XFlush(theDisplay);
	return ;
}


void
XmgfSetFont()
{
	XFontStruct *FontID;
	fontname = (char *) malloc(100*sizeof(char*));
	assert(fontname);
	if(FontFamily==SYMBOL) { FontWeight=MEDIUM;
				FontSlant= NOITALIC; }
	sprintf(fontname,"-%s-%s-%s-%s-*-*-%d-*", 
		class[FontClass],family[FontFamily],
		weight[FontWeight],slant[FontSlant],FontSize);
	FontID = XLoadQueryFont(theDisplay, fontname);
	if(FontID==NULL) { 
	        fprintf(stderr,"Font %s Not Found:-Using Default\n",fontname);
		fontname="-adobe-helvetica-*-r-*-*-10-*";	
		FontID = XLoadQueryFont(theDisplay, fontname);
		}
	if (FontID!=NULL) XSetFont(theDisplay, theGC, FontID->fid);
	else fprintf(stderr,"Font Error No Font found!\n");
	
}

void
FNTNCB(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	FontFamily=(int)client_data;
	XmgfFontChange();
	XmgfSetFont();
}

void
FNTWCB(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
        FontWeight=(int)client_data;
	XmgfFontChange();
	XmgfSetFont();
}

void
FNTICB(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
        FontSlant=(int)client_data;
	XmgfFontChange();
	XmgfSetFont();
}

void
FNTSCB(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
        FontSize=(int)client_data;
	XmgfFontChange();
	XmgfSetFont();
}

int
GetFontNumber(FontName)
char *FontName;
{

	if (!strcasecmp(FontName,"courier")) return COURIER;
	if (!strcasecmp(FontName,"helvetica")) return HELVECTICA;
	if (!strcasecmp(FontName,"newcensch")) return NEWCENSCH;
	if (!strcasecmp(FontName,"new century schoolbook")) return NEWCENSCH;
	if (!strcasecmp(FontName,"symbol")) return SYMBOL;
	if (!strcasecmp(FontName,"times")) return TIMES;
	else return HELVECTICA;

}

int
GetFontWeight(Weight)
char *Weight;
{
        if (!strcasecmp(Weight,"bold")) return BOLD;
        if (!strcasecmp(Weight,"normal")) return MEDIUM;
        if (!strcasecmp(Weight,"medium")) return MEDIUM;
        if (!strcasecmp(Weight,"noblod")) return MEDIUM;
        else return MEDIUM;

}

int
GetFontSlant(Slant)
char *Slant;
{
        if (!strcasecmp(Slant,"italic")) return ITALIC;
        if (!strcasecmp(Slant,"normal")) return NOITALIC;
        if (!strcasecmp(Slant,"regular")) return NOITALIC;
        if (!strcasecmp(Slant,"noitalic")) return NOITALIC;
        else return NOITALIC;

}


