/*
 * Copyright (C) 1992, 1993, Paul D. Hoad This file is part of the Xmgf
 * Software. For conditions of distribution and use, see the accompanying
 * README file.
 *
 * Vision Speech and Signal Processing Group . Dept. of Electronic Engineering.
 * University of Surrey. Guildford, Surrey. England. Phone: +44 483 300800
 * Ext 2753 Email: P.Hoad@ee.surrey.ac.uk
 */
#include <assert.h>
#include <string.h>

#include "XmgfStruct.h"
#include "XmgfGlobal.h"
#include "XmgfDefines.h"
#include "XmgfFont.h"
#include "InitX.h"
#include "Init.h"
#include "callbacks.h"
#include "Compression.h"
#include "GetColNum.h"
#include "GUI.h"
#include "Read3DSet.h"
#include "3Droutines.h"
#include "Parse.h"
#include "MotifUtils.h"
#include "Disp3DGF.h"
#include "XmError.h"

#define MAX_USER_STRLEN 150
#define LARGE_STR_LEN 10000

char            NewGlobalColor[50];
static int DDefLineWidth;
static int DDefLineStyle;
static int DDefColor;
static int DDefFillStyle;
static int DDefPointType;
static int DDefPointSize;
static int DDefResolution;
static int DDefFont;
static int DDefFontSize,DDefFontWeight,DDefFontSlant;
static double DDefLocObjX,DDefLocObjY,DDefLocObjZ;
static double DDefLocRotX,DDefLocRotY,DDefLocRotZ;
static double DDefRotCenX,DDefRotCenY,DDefRotCenZ;
static double DDefLocalScale;
static double DDefLocScaleX,DDefLocScaleY,DDefLocScaleZ;
static double DDefScaleCenX,DDefScaleCenY,DDefScaleCenZ;
double   LocObjX,LocObjY,LocObjZ;
double   LocRotX, LocRotY, LocRotZ;
double   RotCenX, RotCenY, RotCenZ;
double   LocalScale;
double   LocScaleX,LocScaleY,LocScaleZ;
double   ScaleCenX,ScaleCenY,ScaleCenZ;


#ifndef _NO_PROTO 
void LocalRotate(t_LL Polygons, double RotX,double RotY,double RotZ,double RotCenX,double RotCenY,double RotCenZ);
void ResetLocalScales(void);
#else 
void LocalRotate();
void ResetLocalScales();
#endif 






t_XmgfGeomStruct *DefaultStructs;

t_XmgfGeomStruct AllStructures[] = {
	{"LINE", "STARTX STARTY ENDX ENDY"},
	{"LINE3D", "STARTX STARTY STARTZ ENDX ENDY ENDZ"},
	{"LINECOL", "STARTX STARTY ENDX ENDY COLOR"},
	{"LINE3DCOL", "STARTX STARTY STARTZ ENDX ENDY ENDZ COLOR"},
	{"POINT", "X Y"},
	{"POINT3D", "X Y Z"},
	{"POINTCOL", "X Y COLOR"},
	{"POINT3DCOL", "X Y Z COLOR"},
	{"POINTSET", "REP X Y"},
	{"POINTSET3D", "REP X Y Z"},
	{"POINTSETCOL", "REP X Y"},
	{"POINTSET3DCOL", "REP X Y Z"},
	{"POINTDOT", "X Y"},
	{"POINTDOT3D", "X Y Z"},
	{"POINTDOTCOL", "X Y COLOR"},
	{"POINTDOT3DCOL", "X Y Z COLOR"},
	{"POINTBOX", "X Y"},
	{"POINTBOX3D", "X Y Z"},
	{"POINTBOXCOL", "X Y COLOR"},
	{"POINTBOX3DCOL", "X Y Z COLOR"},
	{"POINTCROSS", "X Y"},
	{"POINTCROSS3D", "X Y Z"},
	{"POINTCROSSCOL", "X Y COLOR"},
	{"POINTCROSS3DCOL", "X Y Z COLOR"},
	{"POINTTYPE", "X Y TYPE"},
	{"POINTTYPE3D", "X Y Z TYPE"},
	{"POINTTYPECOL", "X Y TYPE COLOR"},
	{"POINTTYPE3DCOL", "X Y Z TYPE COLOR"},
	{"POINTPLUS", "X Y"},
	{"POINTPLUS3D", "X Y Z"},
	{"POINTPLUSCOL", "X Y COLOR"},
	{"POINTPLUS3DCOL", "X Y Z COLOR"},
	{"POLYGON", "REP X Y"},
	{"POLYGON3D", "REP X Y Z"},
	{"POLYGONCOL", "X Y"},
	{"POLYGON3DCOL", "X Y Z"},
	{"POLYLINE", "REP X Y"},
	{"POLYLINE3D", "REP X Y Z"},
	{"POLYLINECOL", "REP X Y"},
	{"POLYLINE3DCOL", "REP X Y Z"},
	{"ARC", "XCEN YCEN RADIUS STARTANGLE ENDANGLE"},
	{"ELLIPSE", "XCEN YCEN MAJOR MINOR THETA"},
	{"ELLIPSECOL", "XCEN YCEN MAJOR MINOR THETA COLOR"},
	{"CIRCLE", "XCEN YCEN RADIUS"},
	{"CIRCLECOL", "XCEN YCEN RADIUS COLOR"},
	{"CIRCLE3D", "XCEN YCEN ZCEN RADIUS"},
	{"CIRCLE3DCOL", "XCEN YCEN ZCEN RADIUS COLOR"},
	{"CYLINDER3D", "ORIGX ORIGY ORIGZ RADIUS HEIGHT"},
	{"CYLINDER3DCOL", "ORIGX ORIGY ORIGZ RADIUS HEIGHT COLOR"},
	{"TRUNCCYLINDER3D", "ORIGX ORIGY ORIGZ BOTRADIUS TOPRADIUS HEIGHT"},
	{"TRUNCCYLINDER3DCOL", "ORIGX ORIGY ORIGZ BOTRADIUS TOPRADIUS HEIGHT COLOR"},
	{"CONE3D", "ORIGX ORIGY ORIGZ RADIUS HEIGHT"},
	{"CONE3DCOL", "ORIGX ORIGY ORIGZ RADIUS HEIGHT COLOR"},
	{"BLOCK3D", "ORIGX ORIGY ORIGZ RADIUS HEIGHT"},
	{"BLOCK3DCOL", "ORIGX ORIGY ORIGZ RADIUS HEIGHT COLOR"},
	{"TRUNCBLOCK3D", "ORIGX ORIGY ORIGZ BOTRADIUS TOPRADIUS HEIGHT"},
	{"TRUNCBLOCK3DCOL", "ORIGX ORIGY ORIGZ BOTRADIUS TOPRADIUS HEIGHT COLOR"},
	{"PYRAMID3D", "ORIGX ORIGY ORIGZ RADIUS HEIGHT"},
	{"PYRAMID3DCOL", "ORIGX ORIGY ORIGZ RADIUS HEIGHT COLOR"},
	{"TRIBLOCK3D", "ORIGX ORIGY ORIGZ RADIUS HEIGHT"},
	{"TRIBLOCK3DCOL", "ORIGX ORIGY ORIGZ RADIUS HEIGHT COLOR"},
	{"TRITRUNCBLOCK3D", "ORIGX ORIGY ORIGZ BOTRADIUS TOPRADIUS HEIGHT"},
	{"TRITRUNCBLOCK3DCOL", "ORIGX ORIGY ORIGZ BOTRADIUS TOPRADIUS HEIGHT COLOR"},
	{"TRIPYRAMID3D", "ORIGX ORIGY ORIGZ RADIUS HEIGHT"},
	{"TRIPYRAMID3DCOL", "ORIGX ORIGY ORIGZ RADIUS HEIGHT COLOR"},
	{"POINTTRI", "X Y"},
	{"POINTTRI3D", "X Y Z"},
	{"POINTTRICOL", "X Y"},
	{"POINTTRI3DCOL", "X Y Z"},
	{"ARCCOL", "XCEN YCEN RADIUS STARTANGLE ENDANGLE COLOR"},
	{"ARC3D", "XCEN YCEN ZCEN RADIUS STARTANGLE ENDANGLE"},
	{"ARC3DCOL", "XCEN YCEN ZCEN RADIUS STARTANGLE ENDANGLE COLOR"},
	{"ELLIPSE3D", "XCEN YCEN ZCEN MAJOR MINOR THETA"},
	{"ELLIPSE3DCOL", "XCEN YCEN ZCEN MAJOR MINOR THETA COLOR"},
	{"POLYPOINT", "X Y"},
	{"POLYPOINT3D", "X Y Z"},
	{"POLYPOINTCOL", "X Y"},
	{"POLYPOINT3DCOL", "X Y Z"},
	{"TEXT3D", "X Y Z TEXTSEG"},
	{"TEXT3DCOL", "X Y Z TEXTSEG COLOR"},
	{"OrCYLINDER3D", "ORIGX ORIGY ORIGZ RADIUS HEIGHT VX VY VZ"},
	{"OrCYLINDER3DCOL", "ORIGX ORIGY ORIGZ RADIUS HEIGHT VX VY VZ COLOR"},
	{"OrCONE3D", "ORIGX ORIGY ORIGZ RADIUS HEIGHT VX VY VZ"},
	{"OrCONE3DCOL", "ORIGX ORIGY ORIGZ RADIUS HEIGHT VX VY VZ COLOR"},
	{"OrTRUNCCYLINDER3D", "ORIGX ORIGY ORIGZ BOTRADIUS TOPRADIUS HEIGHT VX VY VZ"},
	{"OrTRUNCCYLINDER3DCOL", "ORIGX ORIGY ORIGZ BOTRADIUS TOPRADIUS HEIGHT VX VY VZ COLOR"},
	{"OrBLOCK3D", "ORIGX ORIGY ORIGZ RADIUS HEIGHT VX VY VZ"},
	{"OrBLOCK3DCOL", "ORIGX ORIGY ORIGZ RADIUS HEIGHT VX VY VZ COLOR"},
	{"OrTRUNCBLOCK3D", "ORIGX ORIGY ORIGZ BOTRADIUS TOPRADIUS HEIGHT VX VY VZ"},
	{"OrTRUNCBLOCK3DCOL", "ORIGX ORIGY ORIGZ BOTRADIUS TOPRADIUS HEIGHT VX VY VZ COLOR"},
	{"OrPYRAMID3D", "ORIGX ORIGY ORIGZ RADIUS HEIGHT VX VY VZ"},
	{"OrPYRAMID3DCOL", "ORIGX ORIGY ORIGZ RADIUS HEIGHT VX VY VZ COLOR"},
	{"NULL", ""},
	{"OrTRIBLOCK3D", "ORIGX ORIGY ORIGZ RADIUS HEIGHT VX VY VZ"},
	{"OrTRIBLOCK3DCOL", "ORIGX ORIGY ORIGZ RADIUS HEIGHT VX VY VZ COLOR"},
	{"OrTRITRUNCBLOCK3D", "ORIGX ORIGY ORIGZ BOTRADIUS TOPRADIUS HEIGHT VX VY VZ"},
	{"OrTRITRUNCBLOCK3DCOL", "ORIGX ORIGY ORIGZ BOTRADIUS TOPRADIUS HEIGHT VX VY VZ COLOR"},
	{"OrTRIPYRAMID3D", "ORIGX ORIGY ORIGZ RADIUS HEIGHT VX VY VZ"},
	{"OrTRIPYRAMID3DCOL", "ORIGX ORIGY ORIGZ RADIUS HEIGHT VX VY VZ COLOR"},
	{"OrCIRCLE3D", "XCEN YCEN ZCEN RADIUS VX VY VZ"},
	{"OrCIRCLE3DCOL", "XCEN YCEN ZCEN RADIUS VX VY VZ COLOR"},
	{"OrCYLINDER3DARC", "ORIGX ORIGY ORIGZ RADIUS HEIGHT VX VY VZ STARTANGLE ENDANGLE"},
	{"OrCYLINDER3DARCCOL", "ORIGX ORIGY ORIGZ RADIUS HEIGHT VX VY VZ STARTANGLE ENDANGLE COLOR"},
	{"OrCONE3DARC", "ORIGX ORIGY ORIGZ RADIUS HEIGHT VX VY VZ"},
	{"OrCONE3DARCCOL", "ORIGX ORIGY ORIGZ RADIUS HEIGHT VX VY VZ COLOR"},
	{"OrTRUNCCYLINDER3DARC", "ORIGX ORIGY ORIGZ BOTRADIUS TOPRADIUS HEIGHT VX VY VZ"},
	{"OrTRUNCCYLINDER3DARCCOL", "ORIGX ORIGY ORIGZ BOTRADIUS TOPRADIUS HEIGHT VX VY VZ COLOR"},
	{"CUBOID", "X Y Z WIDTH LENGTH HEIGHT"},
	{"CUBOIDCOL", "X Y Z WIDTH LENGTH HEIGHT COLOR"},
	{"DASHLINE", "STARTX STARTY ENDX ENDY"},
	{"DASHLINECOL", "STARTX STARTY ENDX ENDY COLOR"},
	{"DASHLINE3D", "STARTX STARTY STARTZ ENDX ENDY ENDZ"},
	{"DASHLINE3DCOL", "STARTX STARTY STARTZ ENDX ENDY ENDZ COLOR"},
	{"DOTLINE", "STARTX STARTY ENDX ENDY"},
	{"DOTLINECOL", "STARTX STARTY ENDX ENDY COLOR"},
	{"DOTLINE3D", "STARTX STARTY STARTZ ENDX ENDY ENDZ"},
	{"DOTLINE3DCOL", "STARTX STARTY STARTZ ENDX ENDY ENDZ COLOR"},
	{"POLYDASHLINE", "REP X Y"},
	{"POLYDASHLINECOL", "REP X Y"},
	{"POLYDASHLINE3D", "REP X Y Z"},
	{"POLYDASHLINE3DCOL", "REP X Y Z"},
	{"POLYDOTLINE", "REP X Y"},
	{"POLYDOTLINECOL", "REP X Y"},
	{"POLYDOTLINE3D", "REP X Y Z"},
	{"POLYDOTLINE3DCOL", "REP X Y Z"},
	{"SPHERE3D", "XCEN YCEN ZCEN RADIUS"},
	{"SPHERE3DCOL", "XCEN YCEN ZCEN RADIUS COLOR"},
	{"TEXT2D", "X Y TEXTSEG"},
	{"TEXT2DCOL", "X Y TEXTSEG COLOR"},
	{"OrSQUARE3D", "XCEN YCEN ZCEN RADIUS VX VY VZ"},
	{"OrSQUARE3DCOL", "XCEN YCEN ZCEN RADIUS VX VY VZ COLOR"},
	{"POINTCIRCLE", "X Y"},
	{"POINTCIRCLE3D", "X Y Z"},
	{"POINTCIRCLECOL", "X Y COLOR"},
	{"POINTCIRCLE3DCOL", "X Y Z COLOR"},
	{"POINTFBOX", "X Y"},
	{"POINTFBOX3D", "X Y Z"},
	{"POINTFBOXCOL", "X Y COLOR"},
	{"POINTFBOX3DCOL", "X Y Z COLOR"},
	{"POINTFTRI", "X Y"},
	{"POINTFTRI3D", "X Y Z"},
	{"POINTFTRICOL", "X Y COLOR"},
	{"POINTFTRI3DCOL", "X Y Z COLOR"},
	{"POINTFCIRCLE", "X Y"},
	{"POINTFCIRCLE3D", "X Y Z"},
	{"POINTFCIRCLECOL", "X Y COLOR"},
	{"POINTFCIRCLE3DCOL", "X Y Z COLOR"},
	{"INCLUDE", "TEXTSEG"},
};

static int NumOfPrim = (sizeof(AllStructures) / sizeof(t_XmgfGeomStruct));
static int DefaultColourNumber=64;

#ifndef _NO_PROTO
t_XmgfLine LoadRepIDItem(char *SingleLine, int *Pos, int Rep, t_LL IDNames);
t_XmgfObject LoadIDItem(char *SingleLine, int *Pos, t_LL IDNames);
void LoadRepTextItem(char *SingleLine, int *Pos, int Rep);

#else
t_XmgfLine LoadRepIDItem();
t_XmgfObject LoadIDItem();
void LoadRepTextItem();

#endif

/* End of Global */

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* ReadInit Stuff you must only do once */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
ReadInit(){
	MakeDefaultStructures();
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Load A New Set */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
Load3DSets(filename)
char *filename;
{
	XmString NewName;
	/* Global Lists */
	strcpy(CurrentFile, filename);
	ChangeCurrentFile(filename);
	/* Clean Up Old Stuff */
	Empty3DSets();
	if (WindowOpen)
		BusyCursor();
	if (FileExist(filename)){
	   Read3DSets(filename);
	   NewName = Str2MotStr(filename);
	   DestLL(CurrentFileList);
	   CurrentFileList = ConsLL();
	   InsLastLL(CurrentFileList,NewName);
	   InitViewScale();
#ifdef REDRAW
	   DrawAllSets();
#endif
	   UpdateList();
	   if (WindowOpen)
		   DoneCursor();
	   }
	return ;
}

void ReLoad()
{
	XmString *Xmcurrentfiles;
	Empty3DSets();
	DrawClear();
	if (WindowOpen) BusyCursor();
	ForeachLL_M(CurrentFileList,Xmcurrentfiles){
	if (FileExist(MotStr2Str(Xmcurrentfiles))){
		Read3DSets(MotStr2Str(Xmcurrentfiles));
	}
	}
	DrawAllSets();
	UpdateList();
	if (WindowOpen) DoneCursor();
	return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Clear out all the Three D sets */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
Empty3DSets()
{
        DestLL(gfSets.ListXmgfSets);
	gfSets.ListXmgfSets = ConsLL();
/*	DestroyAllgfSet();*/
	DestLL(NameList);
	NameList = ConsLL();
	DestLL(All_Polys);
	All_Polys = ConsLL();
/*	DestroyAllPolygons(All_Polys);*/
	DefaultColourNumber=64;
	Redraw();
	return;
}

void
SpecialEmpty3DSets()
{
        DestLL(gfSets.ListXmgfSets);
        gfSets.ListXmgfSets = ConsLL();
/*	DestroyAllgfSet();*/
	DestLL(NameList);
        NameList = ConsLL();
        DestLL(All_Polys);
	All_Polys = ConsLL();
/*	DestroyAllPolygons(All_Polys);*/
        DefaultColourNumber=64;
        return;
}

void DestroyAllgfSet()
{
        t_XmgfSet *SelectedSet;
        t_XmgfLine *SelectedLine;
        t_XmgfObject *SelectedObject;
        t_XmgfPoly *Poly;

        ForeachLL_M(gfSets.ListXmgfSets, SelectedSet) {
          ForeachLL_M(SelectedSet->ListXmgfLines, SelectedLine) {
             ForeachLL_M(SelectedLine->ListXmgfObjects, SelectedObject) {
                  ForeachLL_M(SelectedObject->ListXmgfPolys, Poly) {
                    EmptyLL(Poly->ListXmgfPts);
                  }
                  EmptyLL(SelectedObject->ListXmgfPolys);
            }
            EmptyLL(SelectedLine->ListXmgfObjects);
          }
          EmptyLL(SelectedSet->ListXmgfLines);
        }
        EmptyLL(gfSets.ListXmgfSets);
}

void DestroyAllPolygons(ListPoly)
t_LL ListPoly;
{
        t_XmgfPoly *Poly;

	 ForeachLL_M(ListPoly,Poly){
	   EmptyLL(Poly->ListXmgfPts);
	}
	EmptyLL(ListPoly);
}




/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Add another GF File */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
Append3DSets(filename)
char *filename;
{
	XmString NewName;
	/* Append Some Sets */
	if (FileExist(filename)){
	  Read3DSets(filename);
	  NewName = Str2MotStr(filename);
	  InsLastLL(CurrentFileList,NewName);
	  Redraw();
	  UpdateList();
	}
	return ;
}

void
InLineAppend3DSets(filename)
char *filename;
{
        /* Append Some Sets Called From File */
        if (FileExist(filename)){
          Read3DSets(filename);
        }
        return ;
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Import a CAD file (to be implemented)                       */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
ImportFile(Selectedfilename, CADtype)
char *Selectedfilename;
int CADtype;
{
	int status, Importstatus;
	char *newfilename;
	char *dummyfilename;

	newfilename = (char *) malloc(MAX_USER_STRLEN * sizeof(char));
	assert(newfilename);
	dummyfilename = (char *) malloc(MAX_USER_STRLEN * sizeof(char));
	assert(dummyfilename);
	status = CompressionTest(Selectedfilename, newfilename);
	if (status==-1) { 
			XmErr(NO_COMPRESSIONCMD);
			free(newfilename);
        		free(dummyfilename);
        		return ;
			}
	strcpy(dummyfilename, newfilename);

	if (FileExist(newfilename)){
	Importstatus = ImportCmd(newfilename, CADtype);
	if (Importstatus == -1) {
		XmErr(IMPORT_ERROR);
		return ;
	}
	}
#ifdef DEBUG
	fprintf(stderr, "NewFile=%s\n", newfilename);
#endif
	if (FileExist(newfilename)){
          Read3DSets(newfilename);
	  InitViewScale();
#ifdef REDRAW
	  DrawAllSets();
#else
	  Redraw();
#endif
	UpdateList();
	if (Importstatus==0) ImportCleanUp(newfilename);	
	}

	free(newfilename);
	free(dummyfilename);
	return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| 
* Read in a GF File of name :-filename 
* Modified: 29/9/93 to check file type therefore should read in 
* OFF/NFF/SLA/RAY/ without the need for importing
   |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
int
Read3DSets(filename)
char *filename;
{
	int status;
	int ExtId;
	char *newfilename;

	/* See if file is Compressed */
        ExtId = ExtensionTest(filename);
	strcpy(CurrentFile, filename);
	newfilename = (char *) malloc(MAX_USER_STRLEN * sizeof(char));
	assert(newfilename);
	status = CompressionTest(filename, newfilename);
	if (status==-1) {
                        XmErr(NO_COMPRESSIONCMD);
			free(newfilename);
                        return 0;
                        }
	switch(ExtId){
		case IMPORT_OFF_FILE: 
				fprintf(stderr,"IMPORTING OFF\n"); 
			  	ImportCmd(newfilename, IMPORT_OFF_FILE);
				ImportCleanUp(newfilename);
				break;
		case IMPORT_NFF_FILE: 
				fprintf(stderr,"IMPORTING NFF\n"); 
				ImportCmd(newfilename, IMPORT_NFF_FILE);
				ImportCleanUp(newfilename);
				break;
		case IMPORT_RAY_FILE: 
				fprintf(stderr,"IMPORTING RAY\n"); 
				ImportCmd(newfilename, IMPORT_RAY_FILE);
				ImportCleanUp(newfilename);
				break;
		case IMPORT_SLA_FILE: 
				fprintf(stderr,"IMPORTING SLA\n"); 
				ImportCmd(newfilename, IMPORT_SLA_FILE);
				ImportCleanUp(newfilename);
				break;
		case IMPORT_OBJ_FILE: 
				fprintf(stderr,"IMPORTING OBJ\n"); 
				ImportCmd(newfilename, IMPORT_OBJ_FILE);
				ImportCleanUp(newfilename);
				break;
		case IMPORT_DXF_FILE: 
				fprintf(stderr,"IMPORTING DXF\n"); 
				ImportCmd(newfilename, IMPORT_DXF_FILE);
				ImportCleanUp(newfilename);
				break;
		case IMPORT_IGRIP_FILE: 
				fprintf(stderr,"IMPORTING IGRIP\n"); 
				ImportCmd(newfilename, IMPORT_IGRIP_FILE);
				ImportCleanUp(newfilename);
				break;
		case IMPORT_MINICAD_FILE: 
				fprintf(stderr,"IMPORTING MINICAD\n"); 
				ImportCmd(newfilename, IMPORT_MINICAD_FILE);
				ImportCleanUp(newfilename);
				break;
		default: break;
	}
	LoadgfSetNew(newfilename, status);
	InitViewScale();
	free(newfilename);
	return 0;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Load in uncompress file */
void
LoadgfSetNew(newfilename, status)
char *newfilename;
int status;
{
	t_LL InSets;
	t_LL data;
	t_LLSet *InSet;
	t_XmgfSet gfSet;
	t_XmgfLine gfLine;
	t_XmgfObject gfObject;
	int *itemType;
	int *newitemType;
	int RepNum;
	int Pos = 0;
	int AttribId;
	int AttribType;
	int OldDefCol=0;
	char *Str, *TmpStr;
	char *SingleLine;
	char *ATTokenChar;
	char *ATTokenType;
	char *ATTokenVal;
	XmString XmName;
	static int first_pass;
	t_LL ListofGeomStructs;
	t_LL ListofAttribs;
	char *tmp_str, *TokenChar;
	int GeomNum, GeomPos;

	char *GeomName;
	int BusyCount = 0;

	GeomName = (char *) malloc(MAX_USER_STRLEN * sizeof(char));
	assert(GeomName);
	ATTokenChar = (char *) malloc(MAX_USER_STRLEN * sizeof(char));
	assert(ATTokenChar);
	ATTokenVal = (char *) malloc(MAX_USER_STRLEN * sizeof(char));
	assert(ATTokenVal);
	ATTokenType = (char *) malloc(MAX_USER_STRLEN * sizeof(char));
	assert(ATTokenType);

	/* Read in File Compressed or Not */
	InSets = ReadLLSets(newfilename);
	assert(InSets);
	if (InSets == NULL) {
		if (!WindowOpen) {
			fprintf(stderr, "An Error Occured in reading\n");
			exit(-1);
		} else {
			XmErr(FILE_NOT_FOUND);
			fprintf(stderr, "An Error Occured in reading\n");
		}
		return ;
	}
	if (status == 1) CompressionCleanUp(newfilename);
/*      
This causes massive errors and reallocation of memory removed 
from main code to init routine 23/10/93 
MakeDefaultStructures();
*/

	SingleLine = (char *) malloc(LARGE_STR_LEN * sizeof(char));
	assert(SingleLine);
	if (SingleLine == NULL) fprintf(stderr, "Malloc Error\n");

	assert(InSets);
	ForeachLL_M(InSets, InSet) {
		/* Get Set Name */
		assert(gfSet.Name);
		strcpy(gfSet.Name, GetName(*InSet));
		ResetLocalScales();

		if(GFColours) OldDefCol = DefaultColourNumber;
		ResetDefaultAttribs();
		if(GFColours) DefaultColourNumber = OldDefCol;
		SetDefaultAttribs();

                if(!GFColours){
                  DefaultColourNumber=64;
		  SetDefaultAttribs();
                  }
                else {
                  DefaultColourNumber++;
                  if (DefaultColourNumber>(64+20)) DefaultColourNumber=64;
		  SetDefaultAttribs();
                }


		if (WindowOpen)
			BusyCursor();

		/* Add to Name List */
		XmName = (XmString) XmStringCreateLtoR(gfSet.Name, charset);
		InsLastLL(NameList, XmName);

		/* Geometric Structure Extraction */
		ListofGeomStructs = ConsCopyLL(GetGeom(*InSet));
		if (SizeLL(ListofGeomStructs) > 0) {
			ForeachLL_M(ListofGeomStructs, tmp_str) {
				TokenChar = (char *) malloc(strlen(tmp_str) * sizeof(char));
				assert(TokenChar);
				strcpy(TokenChar, tmp_str);
				GeomPos = 0;
				sscanf(TokenChar, "%s%n", GeomName, &GeomPos);
				if (GeomPos == 0 || GeomPos > strlen(TokenChar))
					GeomPos = strlen(TokenChar);
#ifdef NON_STR_PTR
				GeomPos = 1 + (int) strlen(GeomName);
#endif
				TokenChar += GeomPos;
				GeomNum = PrimtoInt(GeomName);
#ifdef DEBUG
				fprintf(stderr, "Old Struct=%s \n", AllStructures[GeomNum - 30].Structure);
				fprintf(stderr, "New Struct=%s \n", TokenChar);
#endif
				strcpy(AllStructures[GeomNum - 30].Structure, TokenChar);
			free(TokenChar);
			}
		}
		/* Attribute Extraction   Ready for Version 3.0 */
		ListofAttribs = ConsCopyLL(GetAttrib(*InSet));
		
		if (SizeLL(ListofAttribs) > 0) {
		 ForeachLL_M(ListofAttribs, tmp_str) {
		 sscanf(tmp_str,"%s ",ATTokenType);
			AttribType = AttribStructToken(ATTokenType);
			if(AttribType==-1){
		           sscanf(tmp_str,"%[^\n]\n",ATTokenVal);
			   AttribId = AttribStructToken(ATTokenType);
			}
			else{
		           sscanf(tmp_str,"%s %[^\n]\n",ATTokenChar,ATTokenVal);
			   AttribId = AttribStructToken(ATTokenChar);

			}
			ParseAttribs(AttribId,ATTokenVal);
		 }
		}


		/* Get Format Name */
		strcpy(gfSet.FormatLine, GetFormat(*InSet));
#ifdef DEBUG
		fprintf(stderr, "%s\n", gfSet.FormatLine);
#endif
		gfSet.XmgfFormat = ExtractFormat(gfSet.FormatLine);
		/* Get Single Set Data */
		data = GetData(*InSet);
		/* Create Data */
		gfSet.ListXmgfLines = ConsLL();
		gfLine.ListXmgfObjects = ConsLL();


		ForeachLL_M(data, Str) {
			/* Get A Single Line */
			strcpy(SingleLine, Str);
			gfLine.ListXmgfObjects = ConsLL();

			first_pass = 1;
			ForeachLL_M(gfSet.XmgfFormat.Format, itemType) {
				/* Search Along Format Line to find Item */
#ifdef DEBUG
				fprintf(stderr, "%s has GeomStruct of %s \n",
					gfSet.FormatLine,
					AllStructures[(int) (*itemType) - 30].Structure);
#endif

				switch (*itemType) {

				    case REP:
					sscanf(SingleLine, "%d %n", &RepNum, &Pos);
					SingleLine += Pos;
					newitemType = NextElmLL(itemType);
					switch (*newitemType) {
					    case TEXT:
						LoadRepTextItem(SingleLine, &Pos, RepNum);
						TmpStr = &SingleLine[Pos];
						strcpy(SingleLine, TmpStr);
						itemType = NextElmLL(itemType);
						break;
					    case ID:
					gfLine =
					LoadRepIDItem(SingleLine, &Pos, RepNum, gfSet.XmgfFormat.IDNames);
					TmpStr = &SingleLine[Pos];
					strcpy(SingleLine, TmpStr);
					itemType = NextElmLL(itemType);
					break;
					default:
					gfObject.ListXmgfPolys =
					LoadRepItem(SingleLine, *newitemType, &Pos, RepNum);
					LocalRotate(gfObject.ListXmgfPolys, 
					LocRotX,LocRotY,LocRotZ, 
					RotCenX,RotCenY,RotCenZ);
					gfObject.visible = 0;
					gfObject.gfID.IDidentifier = 0;
					InsLastLL(gfLine.ListXmgfObjects, gfObject);
					itemType = NextElmLL(itemType);
					TmpStr = &SingleLine[Pos];
					strcpy(SingleLine, TmpStr);
					break;
					}	/* switch */
					break;
				    case TEXT:
					LoadTextItem(SingleLine, &Pos);
					TmpStr = &SingleLine[Pos];
					strcpy(SingleLine, TmpStr);
					break;
				    case ID:
					gfObject = 
					LoadIDItem(SingleLine, &Pos, gfSet.XmgfFormat.IDNames);
					InsLastLL(gfLine.ListXmgfObjects, gfObject);
					TmpStr = &SingleLine[Pos];
					strcpy(SingleLine, TmpStr);
					break;
				    default:
					gfObject.ListXmgfPolys =
				        LoadSingleItem(SingleLine, 
						(*itemType), &Pos);
				        LocalRotate(gfObject.ListXmgfPolys,
					LocRotX,LocRotY,LocRotZ,
					RotCenX,RotCenY,RotCenZ);

					gfObject.visible = 0;
					gfObject.gfID.IDidentifier = 0;
					InsLastLL(gfLine.ListXmgfObjects, gfObject);
					TmpStr = &SingleLine[Pos];
					strcpy(SingleLine, TmpStr);
					break;
				}	/* switch */
				if (WindowOpen && BusyCount & 10)
					BusyCursor();
				BusyCount++;
			}	/* foreachll */
			InsLastLL(gfSet.ListXmgfLines, gfLine);
		}		/* foreach */
		InsLastLL(gfSets.ListXmgfSets, gfSet);
		RestoreDefaultStructures();
		ResetDefaultAttribs();
	}			/* foreach */


/*	DoPoly = SizeLL(gfSets.ListXmgfSets);*/
	free(SingleLine);
	free(GeomName);
	free(ATTokenChar);
	free(ATTokenType);
	free(ATTokenVal);
	return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
t_LL
LoadSingleItem(SingleLine, itemType, Pos)
char *SingleLine;
int itemType;
int *Pos;
{
	t_LL PolyList;

	PolyList = ReadGeneral(SingleLine, Pos, itemType);
	return PolyList;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Load Rep Number of Items */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
t_LL
LoadRepItem(SingleLine, NewItemNumber, Pos, Rep)
char *SingleLine;
int NewItemNumber;
int *Pos;
int Rep;
{
	t_LL PolyList = ConsLL();
	t_LL Item;
	int i;
	int NewPos = 0;

	for (i = 0; i < Rep; i++) {
		Item = LoadSingleItem(SingleLine, NewItemNumber, Pos);
		MoveListLastLL(PolyList, Item);
		SingleLine += *Pos;
		NewPos += *Pos;
	}			/* for */
	*Pos = NewPos;
	return PolyList;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
t_XmgfLine
LoadRepIDItem(SingleLine, Pos, Rep, IDNames)
char *SingleLine;
int *Pos;
int Rep;
t_LL IDNames;
{
	int i;
	int NewPos = 0;
	t_XmgfLine gfLine;
	t_XmgfObject gfObject;

	gfLine.ListXmgfObjects = ConsLL();

	for (i = 0; i < Rep; i++) {
		gfObject = LoadIDItem(SingleLine, Pos, IDNames);
		InsLastLL(gfLine.ListXmgfObjects, gfObject);
		SingleLine += *Pos;
		NewPos += *Pos;
	}			/* for */
	*Pos = NewPos;
	return gfLine;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
t_XmgfObject
LoadIDItem(SingleLine, Pos, IDNames)
char *SingleLine;
int *Pos;
t_LL IDNames;
{
	int LineNum;
	static t_XmgfObject gfObject;
	static int first_pass = 1;

	LineNum = LoadNumItem(SingleLine, Pos);
	gfObject.gfID.IDidentifier = IDIDENTIFIER;
	/* Coded to Prevent Errors */
	gfObject.gfID.XmgfLineNum = LineNum;
	if (first_pass) {
		gfObject.gfID.XmgfSetName =
			FirstElmLL(IDNames);
		first_pass = 0;
	} else {
		gfObject.gfID.XmgfSetName =
			NextElmLL(gfObject.gfID.XmgfSetName);
	}
	gfObject.ListXmgfPolys = ConsLL();
	gfObject.visible = 0;
	gfObject.gfID.IDidentifier = IDIDENTIFIER;
	return gfObject;
}



/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Load in A Duff element */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
LoadTextItem(SingleLine, Pos)
char *SingleLine;
int *Pos;
{
	char *Dummy;

	Dummy = (char *) malloc(200 * sizeof(char));
	assert(Dummy);
	*Pos = 0;
	sscanf(SingleLine, "%s%n", Dummy, Pos);
	if (*Pos == 0 || *Pos > (int) strlen(SingleLine))
		*Pos = (int) strlen(SingleLine);
#ifdef NON_STR_PTR
	*Pos = 1 + strlen(Dummy);
#endif
	free(Dummy);
	return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Load in A Rep of Duff element */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
LoadRepTextItem(SingleLine, Pos, Rep)
char *SingleLine;
int *Pos;
int Rep;
{
	int i;
	int NewPos = 0;
	char *Dummy;

	Dummy = (char *) malloc(LARGE_STR_LEN * sizeof(char));
	assert(Dummy);

	for (i = 0; i < Rep; i++) {
		*Pos = 0;
		sscanf(SingleLine, "%s%n", Dummy, Pos);
		if (*Pos == 0 || *Pos > strlen(SingleLine))
			*Pos = strlen(SingleLine);
#ifdef NON_STR_PTR
		*Pos = 1 + strlen(Dummy);
#endif
		SingleLine += *Pos;
		NewPos += *Pos;
	}			/* for */
	*Pos = NewPos;
	free(Dummy);
	return ;
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Load in a Number and Return it */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
int
LoadNumItem(SingleLine, Pos)
char *SingleLine;
int *Pos;
{
	double Num;

	sscanf(SingleLine, "%lf %n", &Num, Pos);
	return (int) Num;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
t_LL
ReadGeneral(SingleLine, Pos, PrimitiveType)
char *SingleLine;
int *Pos;
int PrimitiveType;
{
	t_XmgfInfoStruct XmgfInfo;
	t_XmgfPt PtStart, Pt;
	t_XmgfPoly Poly;
	t_XmgfPoly *TmpPoly;
	t_LL PolyList = ConsLL();
	char *ColorStr;
	int Col;
	int NewPos;
	double Color;
	double count = 0.0;
	int Intcount = 0;
	double Xcen, Ycen, Zcen, Major, Minor, LTheta, Radius;
	double StAn, EnAn, AngMaj, AngMin, MajorAngle, MinorAngle, Angle;
	int NumberofSides;
	double Width, Length, Height, w2, l2;
	t_XmgfPt CubPt[10];
	double Rep;
	int i;

	Col = NOCOLOR;
	Poly.ListXmgfPts = ConsLL();
	Poly.ColNum = DefaultColourNumber;
	Poly.fill = NOFILL;
	Poly.cull = 0;
	Poly.Ill  = 0.0;
	Poly.Clipped = 0;
	Poly.Font = 0;
	Poly.FontSize = 0;
	Poly.FontWeight = 0;
	Poly.FontSlant = 0;
	Poly.PtType = MENU_POINT;
	Poly.LineStyle = DefaultLineStyle;
	Poly.FillStyle = DefaultFillStyle;
	Poly.LineWidth = DefaultLineWidth;
	Poly.z_depth = 0;
	Poly.num = 0;
#ifdef MALLOCTEXT
	Poly.Text = (char *) malloc(MAX_USER_STRLEN * sizeof(char));
	assert(Dummy);
#endif
	strcpy(Poly.Text, "");
	ColorStr = (char *) malloc(MAX_USER_STRLEN * sizeof(char));
	assert(ColorStr);
	switch (PrimitiveType) {

	    case CIRCLECOL:
		Col = COLOR;
	    case CIRCLE:{
			XmgfInfo = SearchFormatLine(
				AllStructures[PrimitiveType - 30].Structure, SingleLine);
			SingleLine += XmgfInfo.position;
			*Pos = XmgfInfo.position;
			Xcen = (double) XmgfInfo.xcen;
			Ycen = (double) XmgfInfo.ycen;
			Radius = (double) XmgfInfo.radius;
			/* Construnct Circle */
			count = 360 * 1 / DefaultResolution;
			Poly.num = 1 + DefaultResolution;
			for (i = 0; i <= 360 + count; i += count) {
				PtStart.x = Xcen + (Radius * cos(Deg2Rad((double) i)));
				PtStart.y = Ycen + (Radius * sin(Deg2Rad((double) i)));
				PtStart.z = 0;
				InsLastLL(Poly.ListXmgfPts, PtStart);
			}
			break;
		}
	    case ELLIPSECOL:
		Col = COLOR;
	    case ELLIPSE:{
			XmgfInfo = SearchFormatLine(
				AllStructures[PrimitiveType - 30].Structure, SingleLine);
			SingleLine += XmgfInfo.position;
			*Pos = XmgfInfo.position;
			Xcen = XmgfInfo.xcen;
			Ycen = XmgfInfo.ycen;
			Major = XmgfInfo.Elmajor;
			Minor = XmgfInfo.Elminor;
			LTheta = XmgfInfo.theta;
			/* Construnct Ellipse */
			count = 360 * 1 / DefaultResolution;
			Poly.num = 1 + DefaultResolution;
			for (i = 0; i < 360 + count; i += count) {
				AngMaj = Major * cos(Deg2Rad((double) i));
				AngMin = Minor * sin(Deg2Rad((double) i));
				Pt.x = Xcen + (AngMaj * cos(LTheta) + AngMin * sin(LTheta));
				Pt.y = Ycen + (AngMin * cos(LTheta) - AngMaj * sin(LTheta));
				Pt.z = 0;
				InsLastLL(Poly.ListXmgfPts, Pt);
			}
			break;
		}
	    case ARCCOL:
		Col = COLOR;
	    case ARC:{
			XmgfInfo = SearchFormatLine(
				AllStructures[PrimitiveType - 30].Structure, SingleLine);
			SingleLine += XmgfInfo.position;
			*Pos = XmgfInfo.position;
			Xcen = XmgfInfo.xcen;
			Ycen = XmgfInfo.ycen;
			Radius = XmgfInfo.radius;
			StAn = XmgfInfo.startangle;
			EnAn = XmgfInfo.endangle;
			/* Construnct ARC    StAngle to EndAngle */
			AngleCheck(&StAn, &EnAn);
			MinorAngle = StAn;
			MajorAngle = EnAn;
			count = 1+(int) (DefaultResolution * (MajorAngle - MinorAngle)) / 360.0;
			Poly.num = count;
			Intcount = (int) count;
			Angle = MinorAngle;
			for (i = 0; i <= Intcount; i++) {
				Pt.x = Xcen + Radius * cos(Deg2Rad((double) Angle));
				Pt.y = Ycen + Radius * sin(Deg2Rad((double) Angle));
				Pt.z = 0;
				Angle += (int) (360 / DefaultResolution);
				InsLastLL(Poly.ListXmgfPts, Pt);
			}
			break;
		}
	    case ARC3DCOL:
		Col = COLOR;
	    case ARC3D:{
			XmgfInfo = SearchFormatLine(
				AllStructures[PrimitiveType - 30].Structure, SingleLine);
			SingleLine += XmgfInfo.position;
			*Pos = XmgfInfo.position;
			Xcen = XmgfInfo.xcen;
			Ycen = XmgfInfo.ycen;
			Zcen = XmgfInfo.zcen;
			Radius = XmgfInfo.radius;
			StAn = XmgfInfo.startangle;
			EnAn = XmgfInfo.endangle;
			/* Construnct ARC    StAngle to EndAngle */
			AngleCheck(&StAn, &EnAn);
			MinorAngle = StAn;
			MajorAngle = EnAn;
			count = 1+(int) (DefaultResolution * (MajorAngle - MinorAngle)) / 360.0;
			Intcount = (int) count;
			Poly.num = Intcount;
			Angle = MinorAngle;
			for (i = 0; i <= Intcount; i++) {
				Pt.x = Xcen + Radius * cos(Deg2Rad((double) Angle));
				Pt.y = Ycen + Radius * sin(Deg2Rad((double) Angle));
				Pt.z = Zcen;
				Angle += (int) (360 / DefaultResolution);
				InsLastLL(Poly.ListXmgfPts, Pt);
			}
			break;
		}
	    case POINTSETCOL:
		Col = COLOR;
	    case POINTSET:{
			sscanf(SingleLine, "%lf %n", &Rep, Pos);
			SingleLine += *Pos;
			Poly.num = Rep;
			for (i = 0; i < (int) Rep; i++) {
				XmgfInfo = SearchFormatLine(
					AllStructures[PrimitiveType - 30].Structure, SingleLine);
				SingleLine += XmgfInfo.position;
				*Pos = XmgfInfo.position;
				PtStart.x = XmgfInfo.x;
				PtStart.y = XmgfInfo.y;
				PtStart.z = 0;
				InsLastLL(Poly.ListXmgfPts, PtStart);
			}
			break;
		}

	    case POINTSET3DCOL:
		Col = COLOR;
	    case POINTSET3D:{
			sscanf(SingleLine, "%lf %n", &Rep, Pos);
			SingleLine += *Pos;
			Poly.num = Rep;
			for (i = 0; i < (int) Rep; i++) {
				XmgfInfo = SearchFormatLine(
					AllStructures[PrimitiveType - 30].Structure, SingleLine);
				SingleLine += XmgfInfo.position;
				*Pos = XmgfInfo.position;
				PtStart.x = XmgfInfo.x;
				PtStart.y = XmgfInfo.y;
				PtStart.z = XmgfInfo.z;
				InsLastLL(Poly.ListXmgfPts, PtStart);
			}
			break;
		}

	    case POLYPOINTCOL:
		Col = COLORSET;
	    case POLYPOINT:{
			if (Col != COLORSET)
				Col = SET;
			sscanf(SingleLine, "%lf %n", &Rep, Pos);
			SingleLine += *Pos;
			for (i = 0; i < (int) Rep; i++) {
				XmgfInfo = SearchFormatLine(
					AllStructures[PrimitiveType - 30].Structure, SingleLine);
				SingleLine += XmgfInfo.position;
				*Pos = XmgfInfo.position;
				PtStart.x = XmgfInfo.x;
				PtStart.y = XmgfInfo.y;
				PtStart.z = 0;
				Poly.num = 1;
				Poly.PtType = MENU_POINT;
				InsLastLL(Poly.ListXmgfPts, PtStart);
				InsLastLL(PolyList, Poly);
				Poly.ListXmgfPts = ConsLL();
			}
			break;
		}
	    case POLYPOINT3DCOL:
		Col = COLORSET;
	    case POLYPOINT3D:{
			if (Col != COLORSET)
				Col = SET;
			sscanf(SingleLine, "%lf %n", &Rep, Pos);
			SingleLine += *Pos;
			for (i = 0; i < (int) Rep; i++) {
				XmgfInfo = SearchFormatLine(
					AllStructures[PrimitiveType - 30].Structure, SingleLine);
				SingleLine += XmgfInfo.position;
				*Pos = XmgfInfo.position;
				PtStart.x = XmgfInfo.x;
				PtStart.y = XmgfInfo.y;
				PtStart.z = XmgfInfo.z;
				Poly.num = 1;
				Poly.PtType = MENU_POINT;
				InsLastLL(Poly.ListXmgfPts, PtStart);
				InsLastLL(PolyList, Poly);
				Poly.ListXmgfPts = ConsLL();
			}
			break;
		}

	    case LINECOL:
		Col = COLOR;
	    case LINE:{
			Poly = LoadLineItem(PrimitiveType, SingleLine, DefaultLineStyle, 0, &NewPos);
			SingleLine += NewPos;
			*Pos = NewPos;
			break;
		}
	    case LINE3DCOL:
		Col = COLOR;
	    case LINE3D:{
			Poly = LoadLineItem(PrimitiveType, SingleLine, DefaultLineStyle, 1, &NewPos);
			SingleLine += NewPos;
			*Pos = NewPos;
			break;
		}
	    case DASHLINECOL:
		Col = COLOR;
	    case DASHLINE:{
			Poly = LoadLineItem(PrimitiveType, SingleLine, DASHLS, 0, &NewPos);
			SingleLine += NewPos;
			*Pos = NewPos;
			break;
		}
	    case DASHLINE3DCOL:
		Col = COLOR;
	    case DASHLINE3D:{
			Poly = LoadLineItem(PrimitiveType, SingleLine, DASHLS, 1, &NewPos);
			SingleLine += NewPos;
			*Pos = NewPos;
			break;
		}
	    case DOTLINECOL:
		Col = COLOR;
	    case DOTLINE:{
			Poly = LoadLineItem(PrimitiveType, SingleLine, DOTLS, 0, &NewPos);
			SingleLine += NewPos;
			*Pos = NewPos;
			break;
		}
	    case DOTLINE3DCOL:
		Col = COLOR;
	    case DOTLINE3D:{
			Poly = LoadLineItem(PrimitiveType, SingleLine, DOTLS, 1, &NewPos);
			SingleLine += NewPos;
			*Pos = NewPos;
			break;
		}
	    case POINTCOL:
		Col = COLOR;
	    case POINT:{
			Poly = LoadPointItem(PrimitiveType, SingleLine, DefaultPointType, 0, &NewPos);
			SingleLine += NewPos;
			*Pos = NewPos;
			break;
		}
	    case POINTCIRCLECOL:
		Col = COLOR;
	    case POINTCIRCLE:{
			Poly = LoadPointItem(PrimitiveType, SingleLine, MENU_CIRCLE, 0, &NewPos);
			SingleLine += NewPos;
			*Pos = NewPos;
			break;
		}
	    case POINTDOTCOL:
		Col = COLOR;
	    case POINTDOT:{
			Poly = LoadPointItem(PrimitiveType, SingleLine, MENU_POINT, 0, &NewPos);
			SingleLine += NewPos;
			*Pos = NewPos;
			break;
		}
	    case POINTBOXCOL:
		Col = COLOR;
	    case POINTBOX:{
			Poly = LoadPointItem(PrimitiveType, SingleLine, MENU_BOX, 0, &NewPos);
			SingleLine += NewPos;
			*Pos = NewPos;
			break;
		}
	    case POINTCROSSCOL:
		Col = COLOR;
	    case POINTCROSS:{
			Poly = LoadPointItem(PrimitiveType, SingleLine, MENU_CROSS, 0, &NewPos);
			SingleLine += NewPos;
			*Pos = NewPos;
			break;
		}
	    case POINTPLUSCOL:
		Col = COLOR;
	    case POINTPLUS:{
			Poly = LoadPointItem(PrimitiveType, SingleLine, MENU_PLUS, 0, &NewPos);
			SingleLine += NewPos;
			*Pos = NewPos;
			break;
		}
	    case POINTTRICOL:
		Col = COLOR;
	    case POINTTRI:{
			Poly = LoadPointItem(PrimitiveType, SingleLine, MENU_TRI, 0, &NewPos);
			SingleLine += NewPos;
			*Pos = NewPos;
			break;
		}
	    case POINTTYPECOL:
		Col = COLOR;
	    case POINTTYPE:{
			Poly = LoadPointItem(PrimitiveType, SingleLine, MENU_UD, 0, &NewPos);
			SingleLine += NewPos;
			*Pos = NewPos;
			break;
		}
	    case POINT3DCOL:
		Col = COLOR;
	    case POINT3D:{
			Poly = LoadPointItem(PrimitiveType, SingleLine, DefaultPointType, 1, &NewPos);
			SingleLine += NewPos;
			*Pos = NewPos;
			break;
		}
	    case POINTDOT3DCOL:
		Col = COLOR;
	    case POINTDOT3D:{
			Poly = LoadPointItem(PrimitiveType, SingleLine, MENU_POINT, 1, &NewPos);
			SingleLine += NewPos;
			*Pos = NewPos;
			break;
		}
	    case POINTCIRCLE3DCOL:
		Col = COLOR;
	    case POINTCIRCLE3D:{
	       Poly = LoadPointItem(PrimitiveType, SingleLine, MENU_CIRCLE, 1, &NewPos);
			SingleLine += NewPos;
			*Pos = NewPos;
			break;
		}
	    case POINTTRI3DCOL:
		Col = COLOR;
	    case POINTTRI3D:{
			Poly = LoadPointItem(PrimitiveType, SingleLine, MENU_TRI, 1, &NewPos);
			SingleLine += NewPos;
			*Pos = NewPos;
			break;
		}
	    case POINTBOX3DCOL:
		Col = COLOR;
	    case POINTBOX3D:{
			Poly = LoadPointItem(PrimitiveType, SingleLine, MENU_BOX, 1, &NewPos);
			SingleLine += NewPos;
			*Pos = NewPos;
			break;
		}
	    case POINTCROSS3DCOL:
		Col = COLOR;
	    case POINTCROSS3D:{
			Poly = LoadPointItem(PrimitiveType, SingleLine, MENU_CROSS, 1, &NewPos);
			SingleLine += NewPos;
			*Pos = NewPos;
			break;
		}
	    case POINTPLUS3DCOL:
		Col = COLOR;
	    case POINTPLUS3D:{
			Poly = LoadPointItem(PrimitiveType, SingleLine, MENU_PLUS, 1, &NewPos);
			SingleLine += NewPos;
			*Pos = NewPos;
			break;
		}
	    case POINTTYPE3DCOL:
		Col = COLOR;
	    case POINTTYPE3D:{
			Poly = LoadPointItem(PrimitiveType, SingleLine, MENU_UD, 1, &NewPos);
			SingleLine += NewPos;
			*Pos = NewPos;
			break;
		}

case POINTFBOX3DCOL:
Col = COLOR;
case POINTFBOX3D:{
Poly = LoadPointItem(PrimitiveType, SingleLine, MENU_FILLEDBOX, 1, &NewPos);
SingleLine += NewPos; *Pos = NewPos; break;
}
case POINTFBOXCOL:
Col = COLOR;
case POINTFBOX:{
Poly = LoadPointItem(PrimitiveType, SingleLine, MENU_FILLEDBOX, 0, &NewPos);
SingleLine += NewPos; *Pos = NewPos; break;
}
case POINTFTRI3DCOL:
Col = COLOR;
case POINTFTRI3D:{
Poly = LoadPointItem(PrimitiveType, SingleLine, MENU_FILLEDTRI, 1, &NewPos);
SingleLine += NewPos; *Pos = NewPos; break;
}
case POINTFTRICOL:
Col = COLOR;
case POINTFTRI:{
Poly = LoadPointItem(PrimitiveType, SingleLine, MENU_FILLEDTRI, 0, &NewPos);
SingleLine += NewPos; *Pos = NewPos; break;
}
case POINTFCIRCLE3DCOL:
Col = COLOR;
case POINTFCIRCLE3D:{
Poly = LoadPointItem(PrimitiveType, SingleLine, MENU_FILLEDCIRCLE, 1, &NewPos);
SingleLine += NewPos; *Pos = NewPos; break;
}
case POINTFCIRCLECOL:
Col = COLOR;
case POINTFCIRCLE:{
Poly = LoadPointItem(PrimitiveType, SingleLine, MENU_FILLEDCIRCLE, 0, &NewPos);
SingleLine += NewPos; *Pos = NewPos; break;
}



	    case POLYGONCOL:
		Col = POLYCOLOR;
	    case POLYGON:{
			sscanf(SingleLine, "%lf %n", &count, Pos);
			Intcount = (int) count;
			Poly.num = Intcount+1;
			Poly.fill = FILL;
			Poly.FillStyle = FILL;
			SingleLine += *Pos;
			for (i = 0; i < Intcount; i++) {
				XmgfInfo = SearchFormatLine(
					AllStructures[PrimitiveType - 30].Structure, SingleLine);
				SingleLine += XmgfInfo.position;
				*Pos = XmgfInfo.position;
				PtStart.x = XmgfInfo.x;
				PtStart.y = XmgfInfo.y;
				PtStart.z = 0;
				InsLastLL(Poly.ListXmgfPts, PtStart);
			}
			TmpPoly = FirstElmLL(Poly.ListXmgfPts);
			InsLastLL(Poly.ListXmgfPts, *TmpPoly);
			break;
		}
	    case POLYGON3DCOL:
		Col = POLYCOLOR;
	    case POLYGON3D:{
			sscanf(SingleLine, "%lf %n", &count, Pos);
			Intcount = (int) count;
			Poly.num = Intcount+1;
			Poly.fill = FILL;
			Poly.FillStyle = FILL;
			SingleLine += *Pos;
			for (i = 0; i < Intcount; i++) {
				XmgfInfo = SearchFormatLine(
					AllStructures[PrimitiveType - 30].Structure, SingleLine);
				SingleLine += XmgfInfo.position;
				*Pos = XmgfInfo.position;
				PtStart.x = XmgfInfo.x;
				PtStart.y = XmgfInfo.y;
				PtStart.z = XmgfInfo.z;
				InsLastLL(Poly.ListXmgfPts, PtStart);
			}
			TmpPoly = FirstElmLL(Poly.ListXmgfPts);
			InsLastLL(Poly.ListXmgfPts, *TmpPoly);
			break;
		}
	    case SPHERE3DCOL:
		Col = COLORSET;
	    case SPHERE3D:{
			if (Col != COLORSET)
				Col = SET;
			XmgfInfo = SearchFormatLine(
				AllStructures[PrimitiveType - 30].Structure, SingleLine);
			Xcen = (double) XmgfInfo.xcen;
			Ycen = (double) XmgfInfo.ycen;
			Zcen = (double) XmgfInfo.zcen;
			Radius = (double) XmgfInfo.radius;
			PolyList = MakeSphere(Xcen, Ycen, Zcen, Radius, DefaultTessLevel);
			SingleLine += XmgfInfo.position;
			break;
		}

	    case CUBOIDCOL:
		Col = COLORSET;
	    case CUBOID:{
			if (Col != COLORSET)
				Col = SET;
			XmgfInfo = SearchFormatLine(
				AllStructures[PrimitiveType - 30].Structure, SingleLine);
			SingleLine += XmgfInfo.position;
			*Pos = XmgfInfo.position;
			PtStart.x = XmgfInfo.x;
			PtStart.y = XmgfInfo.y;
			PtStart.z = XmgfInfo.z;
			Width = XmgfInfo.width;
			Length = XmgfInfo.length;
			Height = XmgfInfo.height;
			Poly.num = 5;
			Poly.fill = FILL;
			SingleLine += *Pos;
			w2 = Width / 2;
			l2 = Length / 2;
			/* Bot */
			CubPt[1].x = PtStart.x - w2;
			CubPt[1].y = PtStart.y - l2;
			CubPt[1].z = PtStart.z;
			CubPt[2].x = PtStart.x + w2;
			CubPt[2].y = PtStart.y - l2;
			CubPt[2].z = PtStart.z;
			CubPt[3].x = PtStart.x + w2;
			CubPt[3].y = PtStart.y + l2;
			CubPt[3].z = PtStart.z;
			CubPt[4].x = PtStart.x - w2;
			CubPt[4].y = PtStart.y + l2;
			CubPt[4].z = PtStart.z;
			/* Top */
			CubPt[5].x = PtStart.x - w2;
			CubPt[5].y = PtStart.y - l2;
			CubPt[5].z = PtStart.z + Height;
			CubPt[6].x = PtStart.x + w2;
			CubPt[6].y = PtStart.y - l2;
			CubPt[6].z = PtStart.z + Height;
			CubPt[7].x = PtStart.x + w2;
			CubPt[7].y = PtStart.y + l2;
			CubPt[7].z = PtStart.z + Height;
			CubPt[8].x = PtStart.x - w2;
			CubPt[8].y = PtStart.y + l2;
			CubPt[8].z = PtStart.z + Height;
			/* Make */
			Poly.ListXmgfPts = ConsLL();
			InsLastLL(Poly.ListXmgfPts, CubPt[6]);
			InsLastLL(Poly.ListXmgfPts, CubPt[2]);
			InsLastLL(Poly.ListXmgfPts, CubPt[1]);
			InsLastLL(Poly.ListXmgfPts, CubPt[5]);
			InsLastLL(Poly.ListXmgfPts, CubPt[6]);
			InsLastLL(PolyList, Poly);

			Poly.ListXmgfPts = ConsLL();
			InsLastLL(Poly.ListXmgfPts, CubPt[3]);
			InsLastLL(Poly.ListXmgfPts, CubPt[7]);
			InsLastLL(Poly.ListXmgfPts, CubPt[6]);
			InsLastLL(Poly.ListXmgfPts, CubPt[2]);
			InsLastLL(Poly.ListXmgfPts, CubPt[3]);
			InsLastLL(PolyList, Poly);

			Poly.ListXmgfPts = ConsLL();
			InsLastLL(Poly.ListXmgfPts, CubPt[4]);
			InsLastLL(Poly.ListXmgfPts, CubPt[8]);
			InsLastLL(Poly.ListXmgfPts, CubPt[7]);
			InsLastLL(Poly.ListXmgfPts, CubPt[3]);
			InsLastLL(Poly.ListXmgfPts, CubPt[4]);
			InsLastLL(PolyList, Poly);

			Poly.ListXmgfPts = ConsLL();
			InsLastLL(Poly.ListXmgfPts, CubPt[1]);
			InsLastLL(Poly.ListXmgfPts, CubPt[5]);
			InsLastLL(Poly.ListXmgfPts, CubPt[8]);
			InsLastLL(Poly.ListXmgfPts, CubPt[4]);
			InsLastLL(Poly.ListXmgfPts, CubPt[1]);
			InsLastLL(PolyList, Poly);

			Poly.ListXmgfPts = ConsLL();
			InsLastLL(Poly.ListXmgfPts, CubPt[5]);
			InsLastLL(Poly.ListXmgfPts, CubPt[6]);
			InsLastLL(Poly.ListXmgfPts, CubPt[7]);
			InsLastLL(Poly.ListXmgfPts, CubPt[8]);
			InsLastLL(Poly.ListXmgfPts, CubPt[5]);
			InsLastLL(PolyList, Poly);
			break;
		}



	    case POLYLINECOL:
		Col = POLYCOLOR;
	    case POLYLINE:{
			sscanf(SingleLine, "%lf %n", &count, Pos);
			Intcount = (int) count;
			Poly.num = Intcount;
			SingleLine += *Pos;
			NewPos = *Pos;
			for (i = 0; i < Intcount; i++) {
				XmgfInfo = SearchFormatLine(
					AllStructures[PrimitiveType - 30].Structure, SingleLine);
				SingleLine += XmgfInfo.position;
				NewPos += XmgfInfo.position;
				PtStart.x = XmgfInfo.x;
				PtStart.y = XmgfInfo.y;
				PtStart.z = 0;
				InsLastLL(Poly.ListXmgfPts, PtStart);
			} *Pos = NewPos;
			/* SingleLine+= *Pos; */
			break;
		}
	    case POLYLINE3DCOL:
		Col = POLYCOLOR;
	    case POLYLINE3D:{
			sscanf(SingleLine, "%lf %n", &count, Pos);
			Intcount = (int) count;
			Poly.num = Intcount;
			SingleLine += *Pos;
			NewPos = *Pos;
			for (i = 0; i < Intcount; i++) {
				XmgfInfo = SearchFormatLine(
					AllStructures[PrimitiveType - 30].Structure, SingleLine);
				SingleLine += XmgfInfo.position;
				NewPos = XmgfInfo.position;
				PtStart.x = XmgfInfo.x;
				PtStart.y = XmgfInfo.y;
				PtStart.z = XmgfInfo.z;
				InsLastLL(Poly.ListXmgfPts, PtStart);
			} *Pos = NewPos;
			/* SingleLine+= *Pos; */
			break;
		}

	    case POLYDOTLINECOL:
		Col = POLYCOLOR;
	    case POLYDOTLINE:{
			sscanf(SingleLine, "%lf %n", &count, Pos);
			Intcount = (int) count;
			Poly.num = Intcount;
			SingleLine += *Pos;
			NewPos = *Pos;
			for (i = 0; i < Intcount; i++) {
				XmgfInfo = SearchFormatLine(
					AllStructures[PrimitiveType - 30].Structure, SingleLine);
				SingleLine += XmgfInfo.position;
				NewPos += XmgfInfo.position;
				Poly.LineStyle = DOTLS;
				PtStart.x = XmgfInfo.x;
				PtStart.y = XmgfInfo.y;
				PtStart.z = 0;
				InsLastLL(Poly.ListXmgfPts, PtStart);
			} *Pos = NewPos;
			/* SingleLine+= *Pos; */
			break;
		}
	    case POLYDOTLINE3DCOL:
		Col = POLYCOLOR;
	    case POLYDOTLINE3D:{
			sscanf(SingleLine, "%lf %n", &count, Pos);
			Poly.num = Intcount;
			SingleLine += *Pos;
			NewPos = *Pos;
			for (i = 0; i < Intcount; i++) {
				XmgfInfo = SearchFormatLine(
					AllStructures[PrimitiveType - 30].Structure, SingleLine);
				SingleLine += XmgfInfo.position;
				NewPos += XmgfInfo.position;
				Poly.LineStyle = DOTLS;
				PtStart.x = XmgfInfo.x;
				PtStart.y = XmgfInfo.y;
				PtStart.z = XmgfInfo.z;
				InsLastLL(Poly.ListXmgfPts, PtStart);
			}
			*Pos = NewPos;
			/* SingleLine+= *Pos; */
			break;
		}
	    case POLYDASHLINECOL:
		Col = POLYCOLOR;
	    case POLYDASHLINE:{
			sscanf(SingleLine, "%lf %n", &count, Pos);
			Poly.num = Intcount;
			SingleLine += *Pos;
			NewPos = *Pos;
			for (i = 0; i < Intcount; i++) {
				XmgfInfo = SearchFormatLine(
					AllStructures[PrimitiveType - 30].Structure, SingleLine);
				SingleLine += XmgfInfo.position;
				NewPos += XmgfInfo.position;
				Poly.LineStyle = DASHLS;
				PtStart.x = XmgfInfo.x;
				PtStart.y = XmgfInfo.y;
				PtStart.z = 0;
				InsLastLL(Poly.ListXmgfPts, PtStart);
			} *Pos = NewPos;
			/* SingleLine+= *Pos; */
			break;
		}
	    case POLYDASHLINE3DCOL:
		Col = POLYCOLOR;
	    case POLYDASHLINE3D:{
			sscanf(SingleLine, "%lf %n", &count, Pos);
			Poly.num = Intcount;
			SingleLine += *Pos;
			NewPos = *Pos;
			for (i = 0; i < Intcount; i++) {
				XmgfInfo = SearchFormatLine(
					AllStructures[PrimitiveType - 30].Structure, SingleLine);
				SingleLine += XmgfInfo.position;
				NewPos += XmgfInfo.position;
				Poly.LineStyle = DASHLS;
				PtStart.x = XmgfInfo.x;
				PtStart.y = XmgfInfo.y;
				PtStart.z = XmgfInfo.z;
				InsLastLL(Poly.ListXmgfPts, PtStart);
			} *Pos = NewPos;
			/* SingleLine+= *Pos; */
			break;
		}
	    case CIRCLE3DCOL:
		Col = COLOR;
	    case CIRCLE3D:{
			XmgfInfo = SearchFormatLine(
				AllStructures[PrimitiveType - 30].Structure, SingleLine);
			SingleLine += XmgfInfo.position;
			*Pos = XmgfInfo.position;
			Xcen = XmgfInfo.xcen;
			Ycen = XmgfInfo.ycen;
			Zcen = XmgfInfo.zcen;
			Radius = XmgfInfo.radius;
			/* Construnct Circle */
			count = 360 * 1 / DefaultResolution;
			Poly.num = 1 + DefaultResolution;
			for (i = 0; i <= 360 + count; i += count) {
				PtStart.x = Xcen + Radius * cos(Deg2Rad((double) i));
				PtStart.y = Ycen + Radius * sin(Deg2Rad((double) i));
				PtStart.z = Zcen;
				InsLastLL(Poly.ListXmgfPts, PtStart);
			}
			break;
		}
	    case ELLIPSE3DCOL:
		Col = COLOR;
	    case ELLIPSE3D:{
			XmgfInfo = SearchFormatLine(
				AllStructures[PrimitiveType - 30].Structure, SingleLine);
			SingleLine += XmgfInfo.position;
			*Pos = XmgfInfo.position;
			Xcen = XmgfInfo.xcen;
			Ycen = XmgfInfo.ycen;
			Zcen = XmgfInfo.zcen;
			Major = XmgfInfo.Elmajor;
			Minor = XmgfInfo.Elminor;
			LTheta = XmgfInfo.theta;
			/* Construnct Ellipse */
			/* St=1/Major; St_angle = atan(S);
			   NumberofSteps=((int)2*PI/S_angle)+1; */
			count = 360 * 1 / DefaultResolution;
			Poly.num = 1 + DefaultResolution;
			for (i = 0; i < 360 + count; i += count) {
				AngMaj = Major * cos(Deg2Rad((double) i));
				AngMin = Minor * sin(Deg2Rad((double) i));
				Pt.x = Xcen + (AngMaj * cos(LTheta) + AngMin * sin(LTheta));
				Pt.y = Ycen + (AngMin * cos(LTheta) - AngMaj * sin(LTheta));
				Pt.z = Zcen;
				InsLastLL(Poly.ListXmgfPts, Pt);
			}
			break;
		}
	    case CYLINDER3DCOL:
		Col = COLORSET;
	    case CYLINDER3D:{
			NumberofSides = DefaultResolution;
			if (Col != COLORSET)
				Col = SET;
			PolyList = Load3DItem(SingleLine, Pos, NumberofSides, CYLN, PrimitiveType);
			SingleLine += *Pos;
		} break;
	    case TRUNCCYLINDER3DCOL:
		Col = COLORSET;
	    case TRUNCCYLINDER3D:{
			NumberofSides = DefaultResolution;
			if (Col != COLORSET)
				Col = SET;
			PolyList = Load3DItem(SingleLine, Pos, NumberofSides, TRUNC, PrimitiveType);
			SingleLine += *Pos;
		} break;
	    case CONE3DCOL:
		Col = COLORSET;
	    case CONE3D:{
			NumberofSides = DefaultResolution;
			if (Col != COLORSET)
				Col = SET;
			PolyList = Load3DItem(SingleLine, Pos, NumberofSides, CONE, PrimitiveType);
			SingleLine += *Pos;
		} break;
	    case BLOCK3DCOL:
		Col = COLORSET;
	    case BLOCK3D:{
			NumberofSides = 4;
			if (Col != COLORSET)
				Col = SET;
			PolyList = Load3DItem(SingleLine, Pos, NumberofSides, CYLN, PrimitiveType);
			SingleLine += *Pos;
		} break;
	    case TRUNCBLOCK3DCOL:
		Col = COLORSET;
	    case TRUNCBLOCK3D:{
			NumberofSides = 4;
			if (Col != COLORSET)
				Col = SET;
			PolyList = Load3DItem(SingleLine, Pos, NumberofSides, TRUNC, PrimitiveType);
			SingleLine += *Pos;
		} break;
	    case PYRAMID3DCOL:
		Col = COLORSET;
	    case PYRAMID3D:{
			NumberofSides = 4;
			if (Col != COLORSET)
				Col = SET;
			PolyList = Load3DItem(SingleLine, Pos, NumberofSides, CONE, PrimitiveType);
			SingleLine += *Pos;
		} break;
	    case TRIBLOCK3DCOL:
		Col = COLORSET;
	    case TRIBLOCK3D:{
			NumberofSides = 3;
			if (Col != COLORSET)
				Col = SET;
			PolyList = Load3DItem(SingleLine, Pos, NumberofSides, CYLN, PrimitiveType);
			SingleLine += *Pos;
		} break;
	    case TRITRUNCBLOCK3DCOL:
		Col = COLORSET;
	    case TRITRUNCBLOCK3D:{
			NumberofSides = 3;
			if (Col != COLORSET)
				Col = SET;
			PolyList = Load3DItem(SingleLine, Pos, NumberofSides, TRUNC, PrimitiveType);
			SingleLine += *Pos;
		} break;
	    case TRIPYRAMID3DCOL:
		Col = COLORSET;
	    case TRIPYRAMID3D:{
			NumberofSides = 3;
			if (Col != COLORSET)
				Col = SET;
			PolyList = Load3DItem(SingleLine, Pos, NumberofSides, CONE, PrimitiveType);
			SingleLine += *Pos;
		} break;
	    case TEXT3DCOL:
		Col = COLOR;
	    case TEXT3D:{
			XmgfInfo = SearchFormatLine(
				AllStructures[PrimitiveType - 30].Structure, SingleLine);
			SingleLine += XmgfInfo.position;
			*Pos += XmgfInfo.position;
			PtStart.x = XmgfInfo.x;
			PtStart.y = XmgfInfo.y;
			PtStart.z = XmgfInfo.z;
			Poly.num = 1;
			Poly.PtType = MENU_BOX;
			Poly.BaseType = TEXTLABEL;
        		Poly.Font = 	FontFamily;
        		Poly.FontSize = FontSize;
        		Poly.FontWeight = FontWeight;
        		Poly.FontSlant = FontSlant;
			InsLastLL(Poly.ListXmgfPts, PtStart);
			strcpy(Poly.Text, XmgfInfo.textseg);
			break;
		}
	    case TEXT2DCOL:
		Col = COLOR;
	    case TEXT2D:{
			XmgfInfo = SearchFormatLine(
				AllStructures[PrimitiveType - 30].Structure, SingleLine);
			SingleLine += XmgfInfo.position;
			PtStart.x = XmgfInfo.x;
			PtStart.y = XmgfInfo.y;
			PtStart.z = 0;
			Poly.num = 1;
			Poly.PtType = MENU_BOX;
			Poly.BaseType = TEXTLABEL;
			InsLastLL(Poly.ListXmgfPts, PtStart);
			strcpy(Poly.Text, XmgfInfo.textseg);
			break;
		}
	    case OrCYLINDER3DCOL:
		Col = COLORSET;
	    case OrCYLINDER3D:{
			NumberofSides = DefaultResolution;
			if (Col != COLORSET)
				Col = SET;
			PolyList = LoadOr3DItem(SingleLine, Pos, NumberofSides, CYLN, PrimitiveType);
			SingleLine += *Pos;
		} break;
	    case OrTRUNCCYLINDER3DCOL:
		Col = COLORSET;
	    case OrTRUNCCYLINDER3D:{
			NumberofSides = DefaultResolution;
			if (Col != COLORSET)
				Col = SET;
			PolyList = LoadOr3DItem(SingleLine, Pos, NumberofSides, TRUNC, PrimitiveType);
			SingleLine += *Pos;
		} break;
	    case OrCONE3DCOL:
		Col = COLORSET;
	    case OrCONE3D:{
			NumberofSides = DefaultResolution;
			if (Col != COLORSET)
				Col = SET;
			PolyList = LoadOr3DItem(SingleLine, Pos, NumberofSides, CONE, PrimitiveType);
			SingleLine += *Pos;
		} break;
	    case OrBLOCK3DCOL:
		Col = COLORSET;
	    case OrBLOCK3D:{
			NumberofSides = 4;
			if (Col != COLORSET)
				Col = SET;
			PolyList = LoadOr3DItem(SingleLine, Pos, NumberofSides, CYLN, PrimitiveType);
			SingleLine += *Pos;
		} break;
	    case OrTRUNCBLOCK3DCOL:
		Col = COLORSET;
	    case OrTRUNCBLOCK3D:{
			NumberofSides = 4;
			if (Col != COLORSET)
				Col = SET;
			PolyList = LoadOr3DItem(SingleLine, Pos, NumberofSides, TRUNC, PrimitiveType);
			SingleLine += *Pos;
		} break;
	    case OrPYRAMID3DCOL:
		Col = COLORSET;
	    case OrPYRAMID3D:{
			NumberofSides = 4;
			if (Col != COLORSET)
				Col = SET;
			PolyList = LoadOr3DItem(SingleLine, Pos, NumberofSides, CONE, PrimitiveType);
			SingleLine += *Pos;
		} break;
	    case OrTRIBLOCK3DCOL:
		Col = COLORSET;
	    case OrTRIBLOCK3D:{
			NumberofSides = 3;
			if (Col != COLORSET)
				Col = SET;
			PolyList = LoadOr3DItem(SingleLine, Pos, NumberofSides, CYLN, PrimitiveType);
			SingleLine += *Pos;
		} break;
	    case OrTRITRUNCBLOCK3DCOL:
		Col = COLORSET;
	    case OrTRITRUNCBLOCK3D:{
			NumberofSides = 3;
			if (Col != COLORSET)
				Col = SET;
			PolyList = LoadOr3DItem(SingleLine, Pos, NumberofSides, TRUNC, PrimitiveType);
			SingleLine += *Pos;
		} break;
	    case OrTRIPYRAMID3DCOL:
		Col = COLORSET;
	    case OrTRIPYRAMID3D:{
			if (Col != COLORSET)
				Col = SET;
			NumberofSides = 3;
			PolyList = LoadOr3DItem(SingleLine, Pos, NumberofSides, CONE, PrimitiveType);
			SingleLine += *Pos;
		} break;
	    case OrCIRCLE3DCOL:
		Col = COLORSET;
	    case OrCIRCLE3D:{
			if (Col != COLORSET)
				Col = SET;
			NumberofSides = DefaultResolution;
			Poly = LoadOr3DDisc(SingleLine, Pos, NumberofSides, PrimitiveType);
			InsLastLL(PolyList, Poly);
			SingleLine += *Pos;
		} break;
	    case OrSQUARE3DCOL:
		Col = COLORSET;
	    case OrSQUARE3D:{
			if (Col != COLORSET)
				Col = SET;
			NumberofSides = 4;
			Poly = LoadOr3DDisc(SingleLine, Pos, NumberofSides, PrimitiveType);
			InsLastLL(PolyList, Poly);
			SingleLine += *Pos;
		} break;
	    case OrCYLINDER3DARCCOL:
		Col = COLORSET;
	    case OrCYLINDER3DARC:{
			if (Col != COLORSET)
				Col = SET;
			NumberofSides = DefaultResolution;
			PolyList = LoadOr3DItem(SingleLine, Pos, NumberofSides, CYLNARC, PrimitiveType);
			SingleLine += *Pos;
		} break;
	    case OrCONE3DARCCOL:
		Col = COLORSET;
	    case OrCONE3DARC:{
			if (Col != COLORSET)
				Col = SET;
			NumberofSides = DefaultResolution;
			PolyList = LoadOr3DItem(SingleLine, Pos, NumberofSides, CONEARC, PrimitiveType);
			SingleLine += *Pos;
		} break;
	    case OrTRUNCCYLINDER3DARCCOL:
		Col = COLORSET;
	    case OrTRUNCCYLINDER3DARC:{
			if (Col != COLORSET)
				Col = SET;
			NumberofSides = DefaultResolution;
			PolyList = LoadOr3DItem(SingleLine, Pos, NumberofSides, TRUNCARC, PrimitiveType);
			SingleLine += *Pos;
		} break;
	    case INCLUDE:{
			XmgfInfo = SearchFormatLine(
                         AllStructures[PrimitiveType - 30].Structure, SingleLine);
                        SingleLine += XmgfInfo.position;
                        *Pos += XmgfInfo.position;
			fprintf(stderr,"Now attempting to read %s.....",
							XmgfInfo.textseg);
			InLineAppend3DSets(XmgfInfo.textseg);
			fprintf(stderr,"Done\n");
			break;
		 }
	}

	switch (Col) {
	    case POLYCOLOR:
		NewPos= *Pos;
		*Pos = 0;
		sscanf(SingleLine, "%s%n", ColorStr, Pos);
		if (*Pos == 0 || *Pos > strlen(SingleLine))
			*Pos = strlen(SingleLine);
#ifdef NON_STR_PTR
		*Pos = (int) strlen(ColorStr);
#endif
		Color = GetColourNumber(ColorStr);
		SingleLine += *Pos;
		Poly.ColNum = Color;
		InsLastLL(PolyList, Poly);
		NewPos += *Pos;
		*Pos = NewPos;
		break;
	    case COLORSET:
		Color = GetColourNumber(NewGlobalColor);
		ForeachLL_M(PolyList, TmpPoly) {
			TmpPoly->ColNum = Color;
		}
		break;
	    case COLOR:
		Color = GetColourNumber(NewGlobalColor);
		Poly.ColNum = Color;
		InsLastLL(PolyList, Poly);
		break;
	    case SET:
		ForeachLL_M(PolyList, TmpPoly) {
			TmpPoly->ColNum = DefaultColourNumber;
		}
		break;
	    default:
		Color = DefaultColourNumber;
		Poly.ColNum = Color;
		InsLastLL(PolyList, Poly);
		break;
	}

	return PolyList;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* t_LL ExtractFormat( char *FormatLine) */
t_XmgfFormatStruct
ExtractFormat(FormatLine)
char *FormatLine;
{
	char *Primitive;
	char *PrimitiveName;
	char *PrimPtr;

	t_XmgfFormatStruct FormatStru;
	int IntPosition;
	int PrimitiveNum;
	int newPrimitiveNum;
	int cou;

	FormatStru.Format = ConsLL();
	FormatStru.IDNames = ConsLL();
	Primitive = (char *) malloc(MAX_USER_STRLEN * sizeof(char));
	assert(Primitive);
	PrimitiveName = (char *) malloc(MAX_USER_STRLEN * sizeof(char));
	assert(PrimitiveName);
	IntPosition = 0;
	while (
		(cou = sscanf(FormatLine, "%s%n", Primitive, &IntPosition)) != -1) {
		if (IntPosition == 0 || IntPosition > strlen(FormatLine))
			IntPosition = strlen(FormatLine);
#ifdef NON_STR_PTR
		IntPosition = 1 + (int) strlen(Primitive);
		if (IntPosition > strlen(FormatLine))
			IntPosition = strlen(FormatLine);
#endif
		PrimitiveNum = PrimtoInt(Primitive);
		InsLastLL(FormatStru.Format, PrimitiveNum);
		/* IDcontrolStuff  */
		if (PrimitiveNum == ID) {
			newPrimitiveNum = 99;
			PrimPtr = &Primitive[2];
			strcpy(PrimitiveName, PrimPtr);
#ifdef DEBUG
			fprintf(stderr, "ID-%s Placing in List\n", PrimitiveName);
#endif
			InsLastLL(FormatStru.IDNames, PrimitiveName);
		}
		FormatLine += IntPosition;
	}
	free(Primitive);
	free(PrimitiveName);
	return FormatStru;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
int
PrimtoInt(Primitive)
char *Primitive;
{
	char IDstr[2];
	int result = NOP;

	/* Compatability Stuff */
	if (!strcasecmp(Primitive, "3DPoint"))
		result = POINT3D;
	if (!strcasecmp(Primitive, "3DLine"))
		result = LINE3D;
	if (!strcasecmp(Primitive, "3DCircle"))
		result = CIRCLE3D;
	if (!strcasecmp(Primitive, "3DPoly"))
		result = POLYGON3D;
	if (!strcasecmp(Primitive, "3DCylinder"))
		result = CYLINDER3D;
	if (!strcasecmp(Primitive, "3DCone"))
		result = CONE3D;
	if (!strcasecmp(Primitive, "3DPrism"))
		result = TRUNCBLOCK3D;
	if (!strcasecmp(Primitive, "3DTriPrism"))
		result = TRITRUNCBLOCK3D;

	/* New Format */
	if (!strcasecmp(Primitive, "Line"))
		result = LINE;
	if (!strcasecmp(Primitive, "Line3D"))
		result = LINE3D;
	if (!strcasecmp(Primitive, "LineCol"))
		result = LINECOL;
	if (!strcasecmp(Primitive, "Line3DCol"))
		result = LINE3DCOL;

	if (!strcasecmp(Primitive, "DotLine"))
		result = DOTLINE;
	if (!strcasecmp(Primitive, "DotLine3D"))
		result = DOTLINE3D;
	if (!strcasecmp(Primitive, "DotLineCol"))
		result = DOTLINECOL;
	if (!strcasecmp(Primitive, "DotLine3DCol"))
		result = DOTLINE3DCOL;

	if (!strcasecmp(Primitive, "DashLine"))
		result = DASHLINE;
	if (!strcasecmp(Primitive, "DashLine3D"))
		result = DASHLINE3D;
	if (!strcasecmp(Primitive, "DashLineCol"))
		result = DASHLINECOL;
	if (!strcasecmp(Primitive, "DashLine3DCol"))
		result = DASHLINE3DCOL;

	if (!strcasecmp(Primitive, "Point"))
		result = POINT;
	if (!strcasecmp(Primitive, "Point3D"))
		result = POINT3D;
	if (!strcasecmp(Primitive, "PointCol"))
		result = POINTCOL;
	if (!strcasecmp(Primitive, "Point3DCol"))
		result = POINT3DCOL;

	if (!strcasecmp(Primitive, "PointSet"))
		result = POINTSET;
	if (!strcasecmp(Primitive, "PointSet3D"))
		result = POINTSET3D;
	if (!strcasecmp(Primitive, "PointSetCol"))
		result = POINTSETCOL;
	if (!strcasecmp(Primitive, "PointSet3DCol"))
		result = POINTSET3DCOL;

	if (!strcasecmp(Primitive, "PolyPoint"))
		result = POLYPOINT;
	if (!strcasecmp(Primitive, "PolyPoint3D"))
		result = POLYPOINT3D;
	if (!strcasecmp(Primitive, "PolyPointCol"))
		result = POLYPOINTCOL;
	if (!strcasecmp(Primitive, "PolyPoint3DCol"))
		result = POLYPOINT3DCOL;

	if (!strcasecmp(Primitive, "PointDot"))
		result = POINTDOT;
	if (!strcasecmp(Primitive, "PointDot3D"))
		result = POINTDOT3D;
	if (!strcasecmp(Primitive, "PointDotCol"))
		result = POINTDOTCOL;
	if (!strcasecmp(Primitive, "PointDot3DCol"))
		result = POINTDOT3DCOL;

	if (!strcasecmp(Primitive, "PointBox"))
		result = POINTBOX;
	if (!strcasecmp(Primitive, "PointBox3D"))
		result = POINTBOX3D;
	if (!strcasecmp(Primitive, "PointBoxCol"))
		result = POINTBOXCOL;
	if (!strcasecmp(Primitive, "PointBox3DCol"))
		result = POINTBOX3DCOL;

	if (!strcasecmp(Primitive, "PointCross"))
		result = POINTCROSS;
	if (!strcasecmp(Primitive, "PointCross3D"))
		result = POINTCROSS3D;
	if (!strcasecmp(Primitive, "PointCrossCol"))
		result = POINTCROSSCOL;
	if (!strcasecmp(Primitive, "PointCross3DCol"))
		result = POINTCROSS3DCOL;

	if (!strcasecmp(Primitive, "PointType"))
		result = POINTTYPE;
	if (!strcasecmp(Primitive, "PointType3D"))
		result = POINTTYPE3D;
	if (!strcasecmp(Primitive, "PointTypeCol"))
		result = POINTTYPECOL;
	if (!strcasecmp(Primitive, "PointType3DCol"))
		result = POINTTYPE3DCOL;

	if (!strcasecmp(Primitive, "PointTri"))
		result = POINTTRI;
	if (!strcasecmp(Primitive, "PointTri3D"))
		result = POINTTRI3D;
	if (!strcasecmp(Primitive, "PointTriCol"))
		result = POINTTRICOL;
	if (!strcasecmp(Primitive, "PointTri3DCol"))
		result = POINTTRI3DCOL;

	if (!strcasecmp(Primitive, "PointCircle"))
		result = POINTCIRCLE;
	if (!strcasecmp(Primitive, "PointCircle3D"))
		result = POINTCIRCLE3D;
	if (!strcasecmp(Primitive, "PointCircleCol"))
		result = POINTCIRCLECOL;
	if (!strcasecmp(Primitive, "PointCircle3DCol"))
		result = POINTCIRCLE3DCOL;

	if (!strcasecmp(Primitive, "PointStar"))
		result = POINTPLUS;
	if (!strcasecmp(Primitive, "PointPlus"))
		result = POINTPLUS;
	if (!strcasecmp(Primitive, "PointPlus3D"))
		result = POINTPLUS3D;
	if (!strcasecmp(Primitive, "PointPlusCol"))
		result = POINTPLUSCOL;
	if (!strcasecmp(Primitive, "PointPlus3DCol"))
		result = POINTPLUS3DCOL;

	/* Compatibility FILLEDPOLY */
	if (!strcasecmp(Primitive, "FilledPoly"))
		result = POLYGON;
	if (!strcasecmp(Primitive, "FilledPoly3D"))
		result = POLYGON3D;
	if (!strcasecmp(Primitive, "FilledPolyCol"))
		result = POLYGONCOL;
	if (!strcasecmp(Primitive, "FilledPoly3DCol"))
		result = POLYGON3DCOL;

	if (!strcasecmp(Primitive, "Polygon"))
		result = POLYGON;
	if (!strcasecmp(Primitive, "Polygon3D"))
		result = POLYGON3D;
	if (!strcasecmp(Primitive, "PolygonCol"))
		result = POLYGONCOL;
	if (!strcasecmp(Primitive, "Polygon3DCol"))
		result = POLYGON3DCOL;

	if (!strcasecmp(Primitive, "PolyLine"))
		result = POLYLINE;
	if (!strcasecmp(Primitive, "PolyLine3D"))
		result = POLYLINE3D;
	if (!strcasecmp(Primitive, "PolyLineCol"))
		result = POLYLINECOL;
	if (!strcasecmp(Primitive, "PolyLine3DCol"))
		result = POLYLINE3DCOL;

	if (!strcasecmp(Primitive, "PolyDotLine"))
		result = POLYDOTLINE;
	if (!strcasecmp(Primitive, "PolyDotLine3D"))
		result = POLYDOTLINE3D;
	if (!strcasecmp(Primitive, "PolyDotLineCol"))
		result = POLYDOTLINECOL;
	if (!strcasecmp(Primitive, "PolyDotLine3DCol"))
		result = POLYDOTLINE3DCOL;

	if (!strcasecmp(Primitive, "PolyDashLine"))
		result = POLYDASHLINE;
	if (!strcasecmp(Primitive, "PolyDashLine3D"))
		result = POLYDASHLINE3D;
	if (!strcasecmp(Primitive, "PolyDashLineCol"))
		result = POLYDASHLINECOL;
	if (!strcasecmp(Primitive, "PolyDashLine3DCol"))
		result = POLYDASHLINE3DCOL;

	if (!strcasecmp(Primitive, "Arc"))
		result = ARC;
	if (!strcasecmp(Primitive, "ArcCol"))
		result = ARCCOL;
	if (!strcasecmp(Primitive, "Arc3D"))
		result = ARC3D;
	if (!strcasecmp(Primitive, "Arc3DCol"))
		result = ARC3DCOL;
	if (!strcasecmp(Primitive, "Ellipse"))
		result = ELLIPSE;
	if (!strcasecmp(Primitive, "EllipseCol"))
		result = ELLIPSECOL;

	if (!strcasecmp(Primitive, "Circle"))
		result = CIRCLE;
	if (!strcasecmp(Primitive, "CircleCol"))
		result = CIRCLECOL;
	if (!strcasecmp(Primitive, "Circle3D"))
		result = CIRCLE3D;
	if (!strcasecmp(Primitive, "Circle3DCol"))
		result = CIRCLE3DCOL;

	if (!strcasecmp(Primitive, "Cylinder3D"))
		result = CYLINDER3D;
	if (!strcasecmp(Primitive, "Cylinder3DCol"))
		result = CYLINDER3DCOL;
	if (!strcasecmp(Primitive, "TruncCylinder3D"))
		result = TRUNCCYLINDER3D;
	if (!strcasecmp(Primitive, "TruncCylinder3DCol"))
		result = TRUNCCYLINDER3DCOL;
	if (!strcasecmp(Primitive, "Cone3D"))
		result = CONE3D;
	if (!strcasecmp(Primitive, "Cone3DCol"))
		result = CONE3DCOL;

	if (!strcasecmp(Primitive, "Block3D"))
		result = BLOCK3D;
	if (!strcasecmp(Primitive, "Block3DCol"))
		result = BLOCK3DCOL;
	if (!strcasecmp(Primitive, "TruncBlock3D"))
		result = TRUNCBLOCK3D;
	if (!strcasecmp(Primitive, "TruncBlock3DCol"))
		result = TRUNCBLOCK3DCOL;
	if (!strcasecmp(Primitive, "Pyramid3D"))
		result = PYRAMID3D;
	if (!strcasecmp(Primitive, "Pyramid3DCol"))
		result = PYRAMID3DCOL;

	if (!strcasecmp(Primitive, "TriBlock3D"))
		result = TRIBLOCK3D;
	if (!strcasecmp(Primitive, "TriBlock3DCol"))
		result = TRIBLOCK3DCOL;
	if (!strcasecmp(Primitive, "TriTruncBlock3D"))
		result = TRITRUNCBLOCK3D;
	if (!strcasecmp(Primitive, "TriTruncBlock3DCol"))
		result = TRITRUNCBLOCK3DCOL;
	if (!strcasecmp(Primitive, "TriPyramid3D"))
		result = TRIPYRAMID3D;
	if (!strcasecmp(Primitive, "TriPyramid3DCol"))
		result = TRIPYRAMID3DCOL;
	if (!strcasecmp(Primitive, "Text3D"))
		result = TEXT3D;
	if (!strcasecmp(Primitive, "Text3DCol"))
		result = TEXT3DCOL;
	if (!strcasecmp(Primitive, "Text2D"))
		result = TEXT2D;
	if (!strcasecmp(Primitive, "Text2DCol"))
		result = TEXT2DCOL;
	if (!strcasecmp(Primitive, "OrCylinder3D"))
		result = OrCYLINDER3D;
	if (!strcasecmp(Primitive, "OrCylinder3DCol"))
		result = OrCYLINDER3DCOL;
	if (!strcasecmp(Primitive, "OrCone3D"))
		result = OrCONE3D;
	if (!strcasecmp(Primitive, "OrCone3DCOL"))
		result = OrCONE3DCOL;
	if (!strcasecmp(Primitive, "OrTruncCylinder3D"))
		result = OrTRUNCCYLINDER3D;
	if (!strcasecmp(Primitive, "OrTruncCylinder3DCol"))
		result = OrTRUNCCYLINDER3DCOL;
	if (!strcasecmp(Primitive, "OrBlock3D"))
		result = OrBLOCK3D;
	if (!strcasecmp(Primitive, "OrBlock3DCol"))
		result = OrBLOCK3DCOL;
	if (!strcasecmp(Primitive, "OrTruncBlock3D"))
		result = OrTRUNCBLOCK3D;
	if (!strcasecmp(Primitive, "OrTruncBlock3DCol"))
		result = OrTRUNCBLOCK3DCOL;
	if (!strcasecmp(Primitive, "OrPyramid3D"))
		result = OrPYRAMID3D;
	if (!strcasecmp(Primitive, "OrPyramid3DCol"))
		result = OrPYRAMID3DCOL;
	if (!strcasecmp(Primitive, "OrTriBlock3D"))
		result = OrTRIBLOCK3D;
	if (!strcasecmp(Primitive, "OrTriBlock3DCol"))
		result = OrTRIBLOCK3DCOL;
	if (!strcasecmp(Primitive, "OrTriTruncBlock3D"))
		result = OrTRITRUNCBLOCK3D;
	if (!strcasecmp(Primitive, "OrTriTruncBlock3DCol"))
		result = OrTRITRUNCBLOCK3DCOL;
	if (!strcasecmp(Primitive, "OrTriPyramid3D"))
		result = OrTRIPYRAMID3D;
	if (!strcasecmp(Primitive, "OrTriPyramid3DCol"))
		result = OrTRIPYRAMID3DCOL;

	if (!strcasecmp(Primitive, "OrCircle3D"))
		result = OrCIRCLE3D;
	if (!strcasecmp(Primitive, "OrCircle3DCol"))
		result = OrCIRCLE3DCOL;
	if (!strcasecmp(Primitive, "OrSquare3D"))
		result = OrSQUARE3D;
	if (!strcasecmp(Primitive, "OrSquare3DCol"))
		result = OrSQUARE3DCOL;

	if (!strcasecmp(Primitive, "OrCylinder3DArc"))
		result = OrCYLINDER3DARC;
	if (!strcasecmp(Primitive, "OrCylinder3DArcCol"))
		result = OrCYLINDER3DARCCOL;
	if (!strcasecmp(Primitive, "OrCone3DArc"))
		result = OrCONE3DARC;
	if (!strcasecmp(Primitive, "OrCone3DArcCol"))
		result = OrCONE3DARCCOL;
	if (!strcasecmp(Primitive, "OrTruncCylinder3DArc"))
		result = OrTRUNCCYLINDER3DARC;
	if (!strcasecmp(Primitive, "OrTruncCylinder3DArcCol"))
		result = OrTRUNCCYLINDER3DARCCOL;
	if (!strcasecmp(Primitive, "Cuboid3D"))
		result = CUBOID;
	if (!strcasecmp(Primitive, "Cuboid3DCol"))
		result = CUBOIDCOL;

	if (!strcasecmp(Primitive, "Sphere3D"))
		result = SPHERE3D;
	if (!strcasecmp(Primitive, "Sphere3DCol"))
		result = SPHERE3DCOL;

	if (!strcasecmp(Primitive, "PointFlledBox"))
		result = POINTFBOX;
	if (!strcasecmp(Primitive, "PointFilledBox3D"))
		result = POINTFBOX3D;
	if (!strcasecmp(Primitive, "PointFilledBoxCol"))
		result = POINTFBOXCOL;
	if (!strcasecmp(Primitive, "PointFilledBox3DCol"))
		result = POINTFBOX3DCOL;

	if (!strcasecmp(Primitive, "PointFlledTri"))
		result = POINTFTRI;
	if (!strcasecmp(Primitive, "PointFilledTri3D"))
		result = POINTFTRI3D;
	if (!strcasecmp(Primitive, "PointFilledTriCol"))
		result = POINTFTRICOL;
	if (!strcasecmp(Primitive, "PointFilledTri3DCol"))
		result = POINTFTRI3DCOL;

	if (!strcasecmp(Primitive, "PointFlledCircle"))
		result = POINTFCIRCLE;
	if (!strcasecmp(Primitive, "PointFilledCircle3D"))
		result = POINTFCIRCLE3D;
	if (!strcasecmp(Primitive, "PointFilledCircleCol"))
		result = POINTFCIRCLECOL;
	if (!strcasecmp(Primitive, "PointFilledCircle3DCol"))
		result = POINTFCIRCLE3DCOL;
	if (!strcasecmp(Primitive, "Include"))
		result = INCLUDE;
	if (!strcasecmp(Primitive, "Rep"))
		result = REP;

	if (result == NOP && strlen(Primitive) > 2) {
		sprintf(IDstr, "%c%c", Primitive[0], Primitive[1]);
		if (!strcasecmp(IDstr, "Id")) {
			result = ID;
			Primitive += 2;
			/* Primitive Holds IdSetName */
		}
	}
	if (result == NOP)
		result = TEXT;

	return result;
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
char *
GetName(InSet)
t_LLSet InSet;
{
	assert(InSet->id);
	return InSet->id;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
char *
GetFormat(InSet)
t_LLSet InSet;
{
	assert(InSet->format);
	return InSet->format;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
t_LL
GetGeom(InSet)
t_LLSet InSet;
{
	return InSet->GeomStruct;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
t_LL
GetAttrib(InSet)
t_LLSet InSet;
{
	return InSet->Attributes;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
t_LL
GetData(InSet)
t_LLSet InSet;
{
	return InSet->data;
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
t_LL
Load3DItem(SingleLine, Pos, NumberofSides, TrCo, PrimitiveType)
char *SingleLine;
int *Pos;
int NumberofSides;
int TrCo;
int PrimitiveType;
{
	t_XmgfInfoStruct XmgfInfo;
	t_LL PolyList = ConsLL();
	int Intcount = NumberofSides;
	int i;
	t_XmgfPoly Poly;
	t_XmgfPt Point, OrigPoint;
	double Radius, Height, SmallRad, TopRadius, BotRadius;
	double Angle = 0;
	double Cirx[MAX_RESOLUTION], Ciry[MAX_RESOLUTION + 1];
	double TCirx[MAX_RESOLUTION + 1], TCiry[MAX_RESOLUTION + 1];

	SmallRad = 0;

	XmgfInfo = SearchFormatLine(
		AllStructures[PrimitiveType - 30].Structure, SingleLine);
	SingleLine += XmgfInfo.position;
	assert(SingleLine);
	*Pos = XmgfInfo.position;
	OrigPoint.x = XmgfInfo.origx;
	OrigPoint.y = XmgfInfo.origy;
	OrigPoint.z = XmgfInfo.origz;
	BotRadius = XmgfInfo.botradius;
	TopRadius = XmgfInfo.topradius;
	Radius = XmgfInfo.radius;
	Height = XmgfInfo.height;
	switch (TrCo) {
	    case TRUNC:
		Radius = BotRadius;
		SmallRad = TopRadius;
		break;
	    case CONE:
		Radius = Radius;
		SmallRad = 0;
		break;
	    case CYLN:
		Radius = Radius;
		SmallRad = Radius;
		break;
	}

	for (i = 0; i < Intcount; i++) {
		Angle = (double) i *(360.0 / (double) Intcount);

		Cirx[i] = OrigPoint.x + Radius * cos(Deg2Rad(Angle));
		Ciry[i] = OrigPoint.y + Radius * sin(Deg2Rad(Angle));
		TCirx[i] = OrigPoint.x + SmallRad * cos(Deg2Rad(Angle));
		TCiry[i] = OrigPoint.y + SmallRad * sin(Deg2Rad(Angle));
	}
	Cirx[i] = Cirx[0];
	Ciry[i] = Ciry[0];
	TCirx[i] = TCirx[0];
	TCiry[i] = TCiry[0];
	for (i = 0; i < Intcount; i++) {
		Poly.ColNum = DefaultColourNumber;
		Poly.fill = 0;
		Poly.cull = 0;
		Poly.num = 5;
		Poly.Ill  = 0.0;
		Poly.Clipped = 0;
        	Poly.Font = 0;
        	Poly.FontSize = 0;
        	Poly.FontWeight = 0;
        	Poly.FontSlant = 0;
		Poly.ListXmgfPts = ConsLL();
		Poly.LineStyle = DefaultLineStyle;
        	Poly.FillStyle = DefaultFillStyle;
        	Poly.LineWidth = DefaultLineWidth;
#ifdef MALLOCTEXT
		Poly.Text = (char *) malloc(MAX_USER_STRLEN * sizeof(char));
		assert( Poly.Text);
#endif
		strcpy(Poly.Text, "");

		Point.x = Cirx[i];
		Point.y = Ciry[i];
		Point.z = OrigPoint.z;
		InsLastLL(Poly.ListXmgfPts, Point);
		Point.x = Cirx[i + 1];
		Point.y = Ciry[i + 1];
		Point.z = OrigPoint.z;
		InsLastLL(Poly.ListXmgfPts, Point);
		Point.x = TCirx[i + 1];
		Point.y = TCiry[i + 1];
		Point.z = OrigPoint.z + Height;
		InsLastLL(Poly.ListXmgfPts, Point);
		Point.x = TCirx[i];
		Point.y = TCiry[i];
		Point.z = OrigPoint.z + Height;
		InsLastLL(Poly.ListXmgfPts, Point);
		Point.x = Cirx[i];
		Point.y = Ciry[i];
		Point.z = OrigPoint.z;
		InsLastLL(Poly.ListXmgfPts, Point);
		InsLastLL(PolyList, Poly);
	}
	return PolyList;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
t_LL
LoadOr3DItem(singleLine, pos, sides, trCo, primitiveType)
char *singleLine;
int *pos;
int sides;
int trCo;
int primitiveType;
{
	t_XmgfInfoStruct XmgfInfo;
	t_LL PolyList = ConsLL();
	int Intcount;
	int i;
	t_XmgfPoly Poly;
	t_XmgfPt Point, OrigPoint, V_D;

	double Radius, Height, SmallRad, TopRadius, BotRadius;
	double Angle = 0;
	double MinorAngle, MajorAngle;
	int Total, Step;
	double StAn, EnAn;
	double Interval;
	double Cirx[MAX_RESOLUTION], Ciry[MAX_RESOLUTION + 1], Cirz[MAX_RESOLUTION + 1];
	double TCirx[MAX_RESOLUTION + 1], TCiry[MAX_RESOLUTION + 1], TCirz[MAX_RESOLUTION + 1];

	Intcount = sides;
	StAn = 0.0;
	EnAn = 360.0;
	SmallRad = 0;
	MinorAngle = 0;
	Total = 0;
	Step = 0;

	XmgfInfo = SearchFormatLine(
		AllStructures[primitiveType - 30].Structure, singleLine);
	singleLine += XmgfInfo.position;
	*pos = XmgfInfo.position;
	OrigPoint.x = XmgfInfo.origx;
	OrigPoint.y = XmgfInfo.origy;
	OrigPoint.z = XmgfInfo.origz;
	BotRadius = XmgfInfo.botradius;
	TopRadius = XmgfInfo.topradius;
	Radius = XmgfInfo.radius;
	Height = XmgfInfo.height;
	V_D.x = XmgfInfo.vx;
	V_D.y = XmgfInfo.vy;
	V_D.z = XmgfInfo.vz;
	StAn = XmgfInfo.startangle;
	EnAn = XmgfInfo.endangle;
	switch (trCo) {
	    case TRUNC:
		Radius = BotRadius;
		SmallRad = TopRadius;
		MinorAngle = 0.0;
		MajorAngle = 360.0;
		Step = (int) (360.0 / (double) sides);
		Total = Intcount;
		break;
	    case CONE:
		Radius = Radius;
		SmallRad = 0;
		MinorAngle = 0.0;
		MajorAngle = 360.0;
		Step = (int) (360.0 / (double) sides);
		Total = Intcount;
		break;
	    case CYLN:
		Radius = Radius;
		SmallRad = Radius;
		MinorAngle = 0.0;
		MajorAngle = 360.0;
		Step = (int) (360.0 / (double) sides);
		Total = Intcount;
		break;
	    case CYLNARC:
		Radius = Radius;
		SmallRad = Radius;
		AngleCheck(&StAn, &EnAn);
		MinorAngle = StAn;
		MajorAngle = EnAn;
		Interval = ((MajorAngle - MinorAngle) * (double) sides) / 360.0;
		Intcount = ((int) Interval);
		Intcount++;
		/* Intcount=1+(int)(sides*(MajorAngle-MinorAngle))/360.0; */
		Step = (int) (360.0 / (double) sides);
		Total = Intcount - 1;
		break;
	    case CONEARC:
		Radius = Radius;
		SmallRad = 0;
		AngleCheck(&StAn, &EnAn);
		MinorAngle = StAn;
		MajorAngle = EnAn;
		Interval = ((MajorAngle - MinorAngle) * (double) sides) / 360.0;
		Intcount = ((int) Interval);
		Intcount++;
		Step = (int) (360.0 / (double) sides);
		Total = Intcount - 1;
		break;
	    case TRUNCARC:
		Radius = BotRadius;
		SmallRad = TopRadius;
		AngleCheck(&StAn, &EnAn);
		MinorAngle = StAn;
		MajorAngle = EnAn;
		Interval = ((MajorAngle - MinorAngle) * (double) sides) / 360.0;
		Intcount = ((int) Interval);
		Intcount++;
		/* Intcount=1+(int)(sides*(MajorAngle-MinorAngle))/360.0; */
		Step = (int) (360.0 / (double) sides);
		Total = Intcount - 1;
		break;
	}

	/* Construct Orienttated Cylinder  */
	Angle = MinorAngle;
	for (i = 0; i < Intcount; i++) {
		Cirx[i] = Radius * cos(Deg2Rad((double) Angle));
		Ciry[i] = Radius * sin(Deg2Rad((double) Angle));
		Cirz[i] = 0;
		TCirx[i] = SmallRad * cos(Deg2Rad((double) Angle));
		TCiry[i] = SmallRad * sin(Deg2Rad((double) Angle));
		TCirz[i] = Height;
		Angle += (double) Step;
	}
	/* Rotate Points */
	OrObject(V_D, Cirx, Ciry, Cirz, Intcount, OrigPoint.x, OrigPoint.y, OrigPoint.z);
	OrObject(V_D, TCirx, TCiry, TCirz, Intcount, OrigPoint.x, OrigPoint.y, OrigPoint.z);
	/* Make End Loop Back to Begining */
	Cirx[i] = Cirx[0];
	Ciry[i] = Ciry[0];
	Cirz[i] = Cirz[0];
	TCirx[i] = TCirx[0];
	TCiry[i] = TCiry[0];
	TCirz[i] = TCirz[0];
	/* Make Polygon Segments */
	for (i = 0; i < Total; i++) {
		Poly.ColNum = DefaultColourNumber;
		Poly.fill = 0;
		Poly.Ill  = 0.0;
		Poly.Clipped = 0;
	        Poly.Font = 0;
        	Poly.FontSize = 0;
        	Poly.FontWeight = 0;
        	Poly.FontSlant = 0;
		Poly.cull = 0;
		Poly.num = 5;
#ifdef MALLOCTEXT
		Poly.Text = (char *) malloc(MAX_USER_STRLEN * sizeof(char));
		assert( Poly.Text);
#endif
		strcpy(Poly.Text, "");
		Poly.ListXmgfPts = ConsLL();
		Poly.LineStyle = DefaultLineStyle;
                Poly.FillStyle = DefaultFillStyle;
                Poly.LineWidth = DefaultLineWidth;
		Point.x = Cirx[i];
		Point.y = Ciry[i];
		Point.z = Cirz[i];
		InsLastLL(Poly.ListXmgfPts, Point);
		Point.x = Cirx[i + 1];
		Point.y = Ciry[i + 1];
		Point.z = Cirz[i + 1];
		InsLastLL(Poly.ListXmgfPts, Point);
		Point.x = TCirx[i + 1];
		Point.y = TCiry[i + 1];
		Point.z = TCirz[i + 1];
		InsLastLL(Poly.ListXmgfPts, Point);
		Point.x = TCirx[i];
		Point.y = TCiry[i];
		Point.z = TCirz[i];
		InsLastLL(Poly.ListXmgfPts, Point);
		Point.x = Cirx[i];
		Point.y = Ciry[i];
		Point.z = Cirz[i];
		InsLastLL(Poly.ListXmgfPts, Point);
		InsLastLL(PolyList, Poly);
	}
	return PolyList;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
double
VecLen(V_D)
t_XmgfPt V_D;
{
	double dist;

	/* Dot Product */
	dist = sqrt(V_D.x * V_D.x + V_D.y * V_D.y + V_D.z * V_D.z);
	return dist;
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
t_XmgfPt
VecNorm(V_D)
t_XmgfPt V_D;
{
	t_XmgfPt Vec;
	double dist;

	dist = VecLen(V_D);
#ifdef DEBUG
	if (dist == 0)
		fprintf(stderr, "dist = Zero");
#endif
	Vec.x = V_D.x / dist;
	Vec.y = V_D.y / dist;
	Vec.z = V_D.z / dist;
	return (Vec);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
t_XmgfPt
VecCross(V_A, V_B)
t_XmgfPt V_A;
t_XmgfPt V_B;
{
	t_XmgfPt V_Res;

	V_Res.x = V_A.y * V_B.z - V_A.z * V_B.y;
	V_Res.y = V_A.z * V_B.x - V_A.x * V_B.z;
	V_Res.z = V_A.x * V_B.y - V_A.y * V_B.x;

	return (V_Res);
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
OrObject(V_D, Cirx, Ciry, Cirz, Intcount, DisOX, DisOY, DisOZ)
t_XmgfPt V_D;
double *Cirx;
double *Ciry;
double *Cirz;
int Intcount;
double DisOX;
double DisOY;
double DisOZ;
{
	t_XmgfPt V_Z, V_R;
	double theta, n1, n2, n3, ca, ica, sa;
	double M[3][3];
	double Angle;
	int i;

	/* int OrOrientation; */
	double xb, yb, zb;

	V_D = VecNorm(V_D);
	V_Z.x = 0.0;
	V_Z.y = 0.0;
	V_Z.z = 1.0;
	V_R = VecCross(V_Z, V_D);
	if (VecLen(V_R) < 0.00000000001) {
		if (V_D.z >= 0) {
			V_R.x = 1;
			V_R.y = 0;
			V_R.z = 0;
		}
		if (V_D.z < 0) {
			V_R.x = -1;
			V_R.y = 0;
			V_R.z = 0;
		}
	}
	if (V_D.z < -1 || V_D.z > 1)
		fprintf(stderr, "V_D.z = %f\n", V_D.z);
	theta = acos(V_D.z);
	V_R = VecNorm(V_R);

	n1 = V_R.x;
	n2 = V_R.y;
	n3 = V_R.z;
	ca = cos((double) theta);
	ica = 1.0 - ca;
	sa = sin((double) theta);
	M[0][0] = n1 * n1 + (1.0 - n1 * n1) * ca;
	M[0][1] = n1 * n2 * ica - n3 * sa;
	M[0][2] = n1 * n3 * ica + n2 * sa;

	M[1][0] = n1 * n2 * ica + n3 * sa;
	M[1][1] = n2 * n2 + (1.0 - n2 * n2) * ca;
	M[1][2] = n2 * n3 * ica - n1 * sa;

	M[2][0] = n1 * n3 * ica - n2 * sa;
	M[2][1] = n2 * n3 * ica + n1 * sa;
	M[2][2] = n3 * n3 + (1.0 - n3 * n3) * ca;

	for (i = 0; i < Intcount; i++) {
		Angle = i * ((2 * PI) / Intcount);
		xb = M[0][0] * Cirx[i] + M[0][1] * Ciry[i] + M[0][2] * Cirz[i];
		yb = M[1][0] * Cirx[i] + M[1][1] * Ciry[i] + M[1][2] * Cirz[i];
		zb = M[2][0] * Cirx[i] + M[2][1] * Ciry[i] + M[2][2] * Cirz[i];
		Cirx[i] = xb + DisOX;
		Ciry[i] = yb + DisOY;
		Cirz[i] = zb + DisOZ;
	}
	/* return OrOrientation; */
	return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
t_XmgfPoly
LoadOr3DDisc(SingleLine, Pos, NumberofSides, PrimitiveType)
char *SingleLine;
int *Pos;
int NumberofSides;
int PrimitiveType;
{
	t_XmgfInfoStruct XmgfInfo;
	int count = NumberofSides;
	int i;
	t_XmgfPoly Poly;
	t_XmgfPt Point, OrigPoint, V_D;
	double Radius;
	double Angle;
	double Cirx[MAX_RESOLUTION], Ciry[MAX_RESOLUTION + 1], Cirz[MAX_RESOLUTION + 1];

	XmgfInfo = SearchFormatLine(
		AllStructures[PrimitiveType - 30].Structure, SingleLine);
	*Pos = XmgfInfo.position;
	OrigPoint.x = XmgfInfo.xcen;
	OrigPoint.y = XmgfInfo.ycen;
	OrigPoint.z = XmgfInfo.zcen;
	Radius = XmgfInfo.radius;
	V_D.x = XmgfInfo.vx;
	V_D.y = XmgfInfo.vy;
	V_D.z = XmgfInfo.vz;

	for (i = 0; i < count; i++) {
		Angle = i * ((2 * PI) / count);
		Cirx[i] = Radius * cos(Angle);
		Ciry[i] = Radius * sin(Angle);
		Cirz[i] = 0;
	}

	/* Rotate Points */

	OrObject(V_D, Cirx, Ciry, Cirz, count, OrigPoint.x, OrigPoint.y, OrigPoint.z);

	Cirx[i] = Cirx[0];
	Ciry[i] = Ciry[0];
	Cirz[i] = Cirz[0];
	Poly.ListXmgfPts = ConsLL();

	Poly.ColNum = DefaultColourNumber;
	Poly.fill = 0;
	Poly.cull = 0;
	Poly.Ill  = 0.0;
	Poly.Clipped = 0;
        Poly.Font = 0;
        Poly.FontSize = 0;
        Poly.FontWeight = 0;
        Poly.FontSlant = 0;
	Poly.num = count + 1;
	Poly.LineStyle = DefaultLineStyle;
        Poly.FillStyle = DefaultFillStyle;
        Poly.LineWidth = DefaultLineWidth;

#ifdef MALLOCTEXT
	Poly.Text = (char *) malloc(MAX_USER_STRLEN * sizeof(char));
	assert( Poly.Text);
#endif
	strcpy(Poly.Text, "");

	for (i = 0; i < count; i++) {
		Point.x = Cirx[i];
		Point.y = Ciry[i];
		Point.z = Cirz[i];
		InsLastLL(Poly.ListXmgfPts, Point);
	}
	/* Close Circle */
	Point.x = Cirx[0];
	Point.y = Ciry[0];
	Point.z = Cirz[0];
	InsLastLL(Poly.ListXmgfPts, Point);

	return Poly;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
AngleCheck(StAn, EnAn)
double *StAn;
double *EnAn;
{
	if (*StAn > *EnAn)
		*StAn = (*StAn) - 360;
	return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/****************************************************************/
/* Geometric Structure Stuff added for Xgf compatability 1/6/93 */
/* P.Hoad                                                       */
/* Useful references gfLL old xgf by:G.Matas,A.Tai              */
/****************************************************************/
void
MakeDefaultStructures()
{
	int i;

	DefaultStructs = (t_XmgfGeomStruct *) malloc(NumOfPrim * sizeof(t_XmgfGeomStruct));
	assert(DefaultStructs);
        for (i = 0; i < NumOfPrim; i++) {
                DefaultStructs[i] = AllStructures[i];
        }
	return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Restore the old Geometric Structures */
/* When a new set comes along */
void
RestoreDefaultStructures()
{
	int i;

	for (i = 0; i < NumOfPrim; i++) {
		AllStructures[i] = DefaultStructs[i];
	}
	return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Search along the current structure line */
t_XmgfInfoStruct
SearchFormatLine(IndividualStructure, CurrentLine)
char *IndividualStructure;
char *CurrentLine;
{
	char *Token;
	int PosA;
	int CurrentPos;
	int TokenType;
	t_XmgfInfoStruct XmgfInfo;

	XmgfInfo.position = 0;
	XmgfInfo.startangle = 0.0;
	XmgfInfo.endangle = 360.0;

	Token = (char *) malloc(MAX_USER_STRLEN * sizeof(char));
	assert(Token);
	if (Token == NULL)
		fprintf(stderr, "Malloc Error\n");
	XmgfInfo.textseg = (char *) malloc(MAX_USER_STRLEN * sizeof(char));
	assert(XmgfInfo.textseg);
	if (XmgfInfo.textseg == NULL)
		fprintf(stderr, "Malloc Error\n");
	XmgfInfo.color = (char *) malloc(MAX_USER_STRLEN * sizeof(char));
	assert( XmgfInfo.color);
	if (XmgfInfo.color == NULL)
		fprintf(stderr, "Malloc Error\n");
	XmgfInfo.type = (char *) malloc(MAX_USER_STRLEN * sizeof(char));
	assert(XmgfInfo.type);
	if (XmgfInfo.type == NULL)
		fprintf(stderr, "Malloc Error\n");
	XmgfInfo.num = (char *) malloc(MAX_USER_STRLEN * sizeof(char));
	assert(XmgfInfo.num);
	if (XmgfInfo.num == NULL)
		fprintf(stderr, "Malloc Error\n");


	PosA = 0;
	CurrentPos = 0;
	while ((sscanf(IndividualStructure, "%s%n", Token, &PosA) > 0)) {
		if (PosA == 0 || PosA > strlen(IndividualStructure))
			PosA = strlen(IndividualStructure);
#ifdef NON_STR_PTR
		PosA = 1 + (int) strlen(Token);
#endif
		IndividualStructure += PosA;
		TokenType = GeomStructToken(Token);
		switch (TokenType) {
		    case STARTX:
			sscanf(CurrentLine, "%lf %n",&XmgfInfo.startx, &CurrentPos);
			XmgfInfo.startx+=LocObjX;
			break;
		    case STARTY:
			sscanf(CurrentLine, "%lf %n",&XmgfInfo.starty, &CurrentPos);
			XmgfInfo.starty+=LocObjY;
			break;
		    case STARTZ:
			sscanf(CurrentLine, "%lf %n",&XmgfInfo.startz, &CurrentPos);
			XmgfInfo.startz+=LocObjZ;
			break;
		    case ENDX:
			sscanf(CurrentLine, "%lf %n", &XmgfInfo.endx, &CurrentPos);
			XmgfInfo.endx+=LocObjX;
			break;
		    case ENDY:
			sscanf(CurrentLine, "%lf %n", &XmgfInfo.endy, &CurrentPos);
			XmgfInfo.endy+=LocObjY;
			break;
		    case ENDZ:
			sscanf(CurrentLine, "%lf %n", &XmgfInfo.endz, &CurrentPos);
			XmgfInfo.endz+=LocObjZ;
			break;
		    case WIDTH:
			sscanf(CurrentLine, "%lf %n", &XmgfInfo.width, &CurrentPos);
			break;
		    case LENGTH:
			sscanf(CurrentLine, "%lf %n", &XmgfInfo.length, &CurrentPos);
			break;
		    case HEIGHT:
			sscanf(CurrentLine, "%lf %n", &XmgfInfo.height, &CurrentPos);
			break;
		    case RADIUS:
			sscanf(CurrentLine, "%lf %n", &XmgfInfo.radius, &CurrentPos);
			break;
		    case X:
			sscanf(CurrentLine, "%lf %n", &XmgfInfo.x, &CurrentPos);
			XmgfInfo.x+=LocObjX;
			break;
		    case Y:
			sscanf(CurrentLine, "%lf %n", &XmgfInfo.y, &CurrentPos);
			XmgfInfo.y+=LocObjY;
			break;
		    case Z:
			sscanf(CurrentLine, "%lf %n", &XmgfInfo.z, &CurrentPos);
			XmgfInfo.z+=LocObjZ;
			break;
		    case TEXTSEG:
			sscanf(CurrentLine, "%s%n", XmgfInfo.textseg, &CurrentPos);
			if (CurrentPos == 0 || CurrentPos > strlen(CurrentLine))
				CurrentPos = strlen(CurrentLine);
#ifdef NON_STR_PTR
			CurrentPos = 1 + (int) strlen(XmgfInfo.textseg);
#endif
			break;
		    case BOTRADIUS:
			sscanf(CurrentLine, "%lf %n", &XmgfInfo.botradius, &CurrentPos);
			break;
		    case TOPRADIUS:
			sscanf(CurrentLine, "%lf %n", &XmgfInfo.topradius, &CurrentPos);
			break;
		    case XCEN:
			sscanf(CurrentLine, "%lf %n", &XmgfInfo.xcen, &CurrentPos);
			XmgfInfo.xcen+=LocObjX;
			break;
		    case YCEN:
			sscanf(CurrentLine, "%lf %n", &XmgfInfo.ycen, &CurrentPos);
			XmgfInfo.ycen+=LocObjY;
			break;
		    case ZCEN:
			sscanf(CurrentLine, "%lf %n", &XmgfInfo.zcen, &CurrentPos);
			XmgfInfo.zcen+=LocObjZ;
			break;
		    case MAJOR:
			sscanf(CurrentLine, "%lf %n", &XmgfInfo.Elmajor, &CurrentPos);
			break;
		    case MINOR:
			sscanf(CurrentLine, "%lf %n", &XmgfInfo.Elminor, &CurrentPos);
			break;
		    case THETA:
			sscanf(CurrentLine, "%lf %n", &XmgfInfo.theta, &CurrentPos);
			break;
		    case VX:
			sscanf(CurrentLine, "%lf %n", &XmgfInfo.vx, &CurrentPos);
			break;
		    case VY:
			sscanf(CurrentLine, "%lf %n", &XmgfInfo.vy, &CurrentPos);
			break;
		    case VZ:
			sscanf(CurrentLine, "%lf %n", &XmgfInfo.vz, &CurrentPos);
			break;
		    case ORIGX:
			sscanf(CurrentLine, "%lf %n", &XmgfInfo.origx, &CurrentPos);
			XmgfInfo.origx+=LocObjX;
			break;
		    case ORIGY:
			sscanf(CurrentLine, "%lf %n", &XmgfInfo.origy, &CurrentPos);
			XmgfInfo.origy+=LocObjY;
			break;
		    case ORIGZ:
			sscanf(CurrentLine, "%lf %n", &XmgfInfo.origz, &CurrentPos);
			XmgfInfo.origz+=LocObjZ;
			break;
		    case COLORSTR:
			sscanf(CurrentLine, "%s%n", XmgfInfo.color, &CurrentPos);
			if (CurrentPos == 0 || CurrentPos > strlen(CurrentLine))
				CurrentPos = strlen(CurrentLine);
#ifdef NON_STR_PTR
			CurrentPos = 1 + (int) strlen(XmgfInfo.color);
#endif
			strcpy(NewGlobalColor, XmgfInfo.color);
			break;
		    case TYPESTR:
			sscanf(CurrentLine, "%s%n", XmgfInfo.type, &CurrentPos);
			if (CurrentPos == 0 || CurrentPos > strlen(CurrentLine))
				CurrentPos = strlen(CurrentLine);
#ifdef NON_STR_PTR
			CurrentPos = 1 + (int) strlen(XmgfInfo.type);
#endif
			break;
		    case STARTANGLE:
			sscanf(CurrentLine, "%lf %n", &XmgfInfo.startangle, &CurrentPos);
			break;
		    case ENDANGLE:
			sscanf(CurrentLine, "%lf %n", &XmgfInfo.endangle, &CurrentPos);
			break;
		    case REPSTR:
			sscanf(CurrentLine, "%n", &CurrentPos);
			break;
		    case NUM:
			sscanf(CurrentLine, "%s%n", XmgfInfo.num, &CurrentPos);
			if (CurrentPos == 0 || CurrentPos > strlen(CurrentLine))
				CurrentPos = strlen(CurrentLine);
#ifdef NON_STR_PTR
			CurrentPos = 1 + (int) strlen(XmgfInfo.num);
#endif
			break;
		    default:
			sscanf(CurrentLine, "%s%n", XmgfInfo.num, &CurrentPos);
			if (CurrentPos == 0 || CurrentPos > strlen(CurrentLine))
				CurrentPos = strlen(CurrentLine);
#ifdef NON_STR_PTR
			CurrentPos = 1 + (int) strlen(XmgfInfo.num);
#endif
			break;
		}
		XmgfInfo.position += CurrentPos;
		CurrentLine += CurrentPos;
	}
	return XmgfInfo;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
int
GeomStructToken(CurrentToken)
char *CurrentToken;
{

	if (!strcasecmp(CurrentToken, "STARTX"))
		return STARTX;
	if (!strcasecmp(CurrentToken, "STARTY"))
		return STARTY;
	if (!strcasecmp(CurrentToken, "STARTZ"))
		return STARTZ;
	if (!strcasecmp(CurrentToken, "ENDX"))
		return ENDX;
	if (!strcasecmp(CurrentToken, "ENDY"))
		return ENDY;
	if (!strcasecmp(CurrentToken, "ENDZ"))
		return ENDZ;
	if (!strcasecmp(CurrentToken, "WIDTH"))
		return WIDTH;
	if (!strcasecmp(CurrentToken, "HEIGHT"))
		return HEIGHT;
	if (!strcasecmp(CurrentToken, "LENGTH"))
		return LENGTH;
	if (!strcasecmp(CurrentToken, "RADIUS"))
		return RADIUS;
	if (!strcasecmp(CurrentToken, "X"))
		return X;
	if (!strcasecmp(CurrentToken, "Y"))
		return Y;
	if (!strcasecmp(CurrentToken, "Z"))
		return Z;
	if (!strcasecmp(CurrentToken, "TEXTSEG"))
		return TEXTSEG;
	if (!strcasecmp(CurrentToken, "BOTRADIUS"))
		return BOTRADIUS;
	if (!strcasecmp(CurrentToken, "TOPRADIUS"))
		return TOPRADIUS;
	if (!strcasecmp(CurrentToken, "XCEN"))
		return XCEN;
	if (!strcasecmp(CurrentToken, "YCEN"))
		return YCEN;
	if (!strcasecmp(CurrentToken, "ZCEN"))
		return ZCEN;
	if (!strcasecmp(CurrentToken, "MAJOR"))
		return MAJOR;
	if (!strcasecmp(CurrentToken, "MINOR"))
		return MINOR;
	if (!strcasecmp(CurrentToken, "THETA"))
		return THETA;
	if (!strcasecmp(CurrentToken, "STARTANGLE"))
		return STARTANGLE;
	if (!strcasecmp(CurrentToken, "ENDANGLE"))
		return ENDANGLE;
	if (!strcasecmp(CurrentToken, "VX"))
		return VX;
	if (!strcasecmp(CurrentToken, "VY"))
		return VY;
	if (!strcasecmp(CurrentToken, "VZ"))
		return VZ;
	if (!strcasecmp(CurrentToken, "COLOR"))
		return COLORSTR;
	if (!strcasecmp(CurrentToken, "TYPE"))
		return TYPESTR;
	if (!strcasecmp(CurrentToken, "ORIGX"))
		return ORIGX;
	if (!strcasecmp(CurrentToken, "ORIGY"))
		return ORIGY;
	if (!strcasecmp(CurrentToken, "ORIGZ"))
		return ORIGZ;
	if (!strcasecmp(CurrentToken, "REP"))
		return REPSTR;
	return NUM;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
int 
AttribTypeToken(CurrentToken)
char *CurrentToken;
{
       if (!strcasecmp(CurrentToken, "Set"))
         return ATTSET;
       if (!strcasecmp(CurrentToken, "Item"))
         return ATTITEM;
       return -1;
}
/* Not implemented Yet Ready for Version 3.0 */
int
AttribStructToken(CurrentToken)
char *CurrentToken;
{
	if (!strcasecmp(CurrentToken, "LineWidth")) return ATLINEWIDTH;
	if (!strcasecmp(CurrentToken, "LineStyle")) return ATLINESTYLE;
	if (!strcasecmp(CurrentToken, "Color")) return ATCOLOR;
	if (!strcasecmp(CurrentToken, "Colour")) return ATCOLOR;
	if (!strcasecmp(CurrentToken, "FillStyle")) return ATFILLSTYLE;
	if (!strcasecmp(CurrentToken, "PointType")) return ATPOINTTYPE;
	if (!strcasecmp(CurrentToken, "PointSize")) return ATPOINTSIZE;
	if (!strcasecmp(CurrentToken, "PointColor")) return ATPOINTCOLOR;
	if (!strcasecmp(CurrentToken, "PointColour")) return ATPOINTCOLOR;
	if (!strcasecmp(CurrentToken, "Font")) return ATFONT;
	if (!strcasecmp(CurrentToken, "FontSize")) return ATFONTSIZE;
	if (!strcasecmp(CurrentToken, "FontColor")) return ATFONTCOLOR;
	if (!strcasecmp(CurrentToken, "FontColour")) return ATFONTCOLOR;
	if (!strcasecmp(CurrentToken, "FontBold")) return ATFONTWEIGHT;
	if (!strcasecmp(CurrentToken, "FontItalic")) return ATFONTSLANT;
	if (!strcasecmp(CurrentToken, "LocalOrig")) return ATLOCALXYZ;
	if (!strcasecmp(CurrentToken, "LocalRotX")) return ATLOCALXROT;
	if (!strcasecmp(CurrentToken, "LocalRotY")) return ATLOCALYROT;
	if (!strcasecmp(CurrentToken, "LocalRotZ")) return ATLOCALZROT;
	if (!strcasecmp(CurrentToken, "LocalRotCentre")) return ATLOCALROTCEN;
	if (!strcasecmp(CurrentToken, "Resolution")) return ATCIRCLERES;
	if (!strcasecmp(CurrentToken, "LocalScale")) return ATLOCALSCALE;
	if (!strcasecmp(CurrentToken, "LocalScaleXYZ")) return ATLOCALSCALE;
	if (!strcasecmp(CurrentToken, "ScaleCenXYZ")) return ATSCALECENXYZ;
	if (!strcasecmp(CurrentToken, "ScaleXYZ")) return ATLOCALSCALE;
	if (!strcasecmp(CurrentToken, "ScaleX")) return ATSCALEX;
	if (!strcasecmp(CurrentToken, "ScaleY")) return ATSCALEY;
	if (!strcasecmp(CurrentToken, "ScaleZ")) return ATSCALEZ;
	if (!strcasecmp(CurrentToken, "LocalScaleX")) return ATSCALEX;
	if (!strcasecmp(CurrentToken, "LocalScaleY")) return ATSCALEY;
	if (!strcasecmp(CurrentToken, "LocalScaleZ")) return ATSCALEZ;
	/* global for use in 2.0*/
	if (!strcasecmp(CurrentToken,"GlobalLineWidth")) return ATGLOBALLINEWIDTH;
	if (!strcasecmp(CurrentToken,"GlobalLineStyle")) return ATGLOBALLINESTYLE;
	if (!strcasecmp(CurrentToken,"GlobalColor")) return ATGLOBALCOLOR;
	if (!strcasecmp(CurrentToken,"GlobalColour")) return ATGLOBALCOLOR;
	if (!strcasecmp(CurrentToken,"GlobalFillStyle")) return ATGLOBALFILLSTYLE;
	if (!strcasecmp(CurrentToken,"GlobalPointType")) return ATGLOBALPOINTTYPE;
	if (!strcasecmp(CurrentToken,"GlobalPointSize")) return ATGLOBALPOINTSIZE;
	if (!strcasecmp(CurrentToken,"GlobalPointColor"))return ATGLOBALPOINTCOLOR;
	if (!strcasecmp(CurrentToken,"GlobalPointColour"))return ATGLOBALPOINTCOLOR;
	if (!strcasecmp(CurrentToken,"GlobalResolution")) return ATGLOBALCIRCLERES;
	if (!strcasecmp(CurrentToken,"GlobalScale")) return ATGLOBALSCALE;
	if (!strcasecmp(CurrentToken,"GlobalScaleX")) return ATGLOBALSCALEX;
	if (!strcasecmp(CurrentToken,"GlobalScaleY")) return ATGLOBALSCALEY;
	if (!strcasecmp(CurrentToken,"GlobalScaleZ")) return ATGLOBALSCALEZ;
	if (!strcasecmp(CurrentToken,"GlobalScaleCenXYZ"))return ATGLOBALSCALECENXYZ;
	if (!strcasecmp(CurrentToken, "GlobalRotX")) return ATGLOBALXROT;
	if (!strcasecmp(CurrentToken, "GlobalRotY")) return ATGLOBALYROT;
	if (!strcasecmp(CurrentToken, "GlobalRotZ")) return ATGLOBALZROT;
	if (!strcasecmp(CurrentToken, "GlobalRotCenXYZ")) return ATGLOBALROTCEN;
	fprintf(stderr,"No Such Attribute as %s\n",CurrentToken);
	return -1;
}



/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
t_XmgfPoly
LoadPointItem(PrimitiveType, SingleLine, PtType, ThreeD, NPos)
int PrimitiveType;
char *SingleLine;
int PtType;
int ThreeD;
int *NPos;
{
	t_XmgfInfoStruct XmgfInfo;
	t_XmgfPt PtStart;
	t_XmgfPoly Poly;
	char StrType[20];

	Poly.ListXmgfPts = ConsLL();
	Poly.ColNum = DefaultColourNumber;
	Poly.fill = NOFILL;
	Poly.Ill  = 0.0;
	Poly.Clipped = 0;
        Poly.Font = 0;
        Poly.FontSize = 0;
        Poly.FontWeight = 0;
        Poly.FontSlant = 0;
	Poly.cull = 0;
	Poly.num = 0;
	Poly.PtType = PtType;
	Poly.LineStyle = DefaultLineStyle;
	Poly.FillStyle = DefaultFillStyle;
	Poly.LineWidth = DefaultLineWidth;
	Poly.num = 0;
#ifdef MALLOCTEXT
	Poly.Text = (char *) malloc(MAX_USER_STRLEN * sizeof(char));
	assert(Poly.Text);
	if (Poly.Text == NULL)
		fprintf(stderr, "Malloc Error\n");
#endif
	strcpy(Poly.Text, "");

	XmgfInfo = SearchFormatLine(
		AllStructures[PrimitiveType - 30].Structure, SingleLine);
	SingleLine += XmgfInfo.position;
	*NPos = XmgfInfo.position;
	PtStart.x = XmgfInfo.x;
	PtStart.y = XmgfInfo.y;
	if (ThreeD == 0)
		PtStart.z = 0;
	else
		PtStart.z = XmgfInfo.z;
	Poly.num = 1;
	if (PtType == MENU_UD) {
		strcpy(StrType, XmgfInfo.type);
		PtType = GetPointNumber(StrType);
	}
	Poly.PtType = PtType;
	InsLastLL(Poly.ListXmgfPts, PtStart);
	return Poly;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
t_XmgfPoly
LoadLineItem(PrimitiveType, SingleLine, LineType, ThreeD, NPos)
int PrimitiveType;
char *SingleLine;
int LineType;
int ThreeD;
int *NPos;
{
	t_XmgfInfoStruct XmgfInfo;
	t_XmgfPt PtStart, PtEnd;
	t_XmgfPoly Poly;

	Poly.ListXmgfPts = ConsLL();
	Poly.ColNum = DefaultColourNumber;
	Poly.fill = NOFILL;
	Poly.cull = 0;
	Poly.Ill  = 0.0;
	Poly.Clipped = 0;
        Poly.Font = 0;
        Poly.FontSize = 0;
        Poly.FontWeight = 0;
        Poly.FontSlant = 0;
	Poly.num = 0;
	Poly.PtType = MENU_POINT;
	Poly.LineStyle = DefaultLineStyle;
	Poly.FillStyle = DefaultFillStyle;
	Poly.LineWidth = DefaultLineWidth;
	Poly.num = 0;
#ifdef MALLOCTEXT
	Poly.Text = (char *) malloc(MAX_USER_STRLEN * sizeof(char));
	assert(Poly.Text);
	if (Poly.Text == NULL)
		fprintf(stderr, "Malloc Error\n");
#endif
	strcpy(Poly.Text, "");

	XmgfInfo = SearchFormatLine(
		AllStructures[PrimitiveType - 30].Structure, SingleLine);
	SingleLine += XmgfInfo.position;
	*NPos = XmgfInfo.position;
	PtStart.x = XmgfInfo.startx;
	PtStart.y = XmgfInfo.starty;
	PtEnd.x = XmgfInfo.endx;
	PtEnd.y = XmgfInfo.endy;
	if (ThreeD == 0) {
		PtStart.z = 0;
		PtEnd.z = 0;
	} else {
		PtStart.z = XmgfInfo.startz;
		PtEnd.z = XmgfInfo.endz;
	}
	Poly.num = 2;
	Poly.LineStyle = LineType;
	InsLastLL(Poly.ListXmgfPts, PtStart);
	InsLastLL(Poly.ListXmgfPts, PtEnd);

	return Poly;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void SetDefaultAttribs()
{
	DDefLineWidth = DefaultLineWidth;
	DDefLineStyle = DefaultLineStyle;
	DDefColor     = DefaultColourNumber;
	DDefFillStyle = DefaultFillStyle;
	DDefPointType = DefaultPointType;
	DDefPointSize = DefaultPointSize;
	DDefFont      = FontFamily;
	DDefFontSize  = FontSize;
	DDefFontWeight = FontWeight;
	DDefFontSlant = FontSlant;
	DDefLocObjX   = LocObjX;
	DDefLocObjY   = LocObjY;
	DDefLocObjZ   = LocObjZ;

	DDefLocRotX   = LocRotX;
	DDefLocRotY   = LocRotY;
	DDefLocRotZ   = LocRotZ;

	DDefRotCenX   = RotCenX;
	DDefRotCenY   = RotCenY;
	DDefRotCenZ   = RotCenZ;
	DDefLocalScale  = LocalScale;
	DDefLocScaleX   = LocScaleX;
	DDefLocScaleY   = LocScaleY;
	DDefLocScaleZ   = LocScaleZ;
	DDefScaleCenX   = ScaleCenX;
	DDefScaleCenY   = ScaleCenY;
	DDefScaleCenZ   = ScaleCenZ;

	DDefResolution= DefaultResolution;
	return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void ResetDefaultAttribs()
{
	DefaultLineWidth    = DDefLineWidth;
	DefaultLineStyle    = DDefLineStyle;
	DefaultColourNumber = DDefColor;
	DefaultFillStyle    = DDefFillStyle;
	DefaultPointType    = DDefPointType;
	DefaultPointSize    = DDefPointSize;
	FontFamily 	    = DDefFont;
	FontSize 	    = DDefFontSize;
	FontSlant           = DDefFontSlant;
	FontWeight          = DDefFontWeight;
	LocObjX		    = 0.0;
	LocObjY		    = 0.0;
	LocObjZ		    = 0.0;
	LocRotX		    = 0.0;
	LocRotY		    = 0.0;
	LocRotZ		    = 0.0;
	RotCenX		    = 0.0;
	RotCenY		    = 0.0;
	RotCenZ		    = 0.0;
	LocalScale	    = 1.0;
	LocScaleX	    = 1.0;
	LocScaleY	    = 1.0;
	LocScaleZ	    = 1.0;
	ScaleCenX   	    = 0.0;
	ScaleCenY   	    = 0.0;
	ScaleCenZ   	    = 0.0;
	DefaultResolution   = DDefResolution;
	return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void ParseAttribs(AttribId,ATTokenVal)
int AttribId;
char *ATTokenVal;
{
	switch (AttribId){
	case ATLINEWIDTH: 	DefaultLineWidth = atoi(ATTokenVal);break;
	case ATLINESTYLE: 	DefaultLineStyle = GetLineStyle(ATTokenVal);break;
	case ATFILLSTYLE: 	DefaultFillStyle = GetFillStyle(ATTokenVal);break;
	case ATPOINTTYPE: 	DefaultPointType = GetPointNumber(ATTokenVal);break;
	case ATPOINTSIZE: 	DefaultPointSize = atoi(ATTokenVal);break;
	case ATCOLOR:     	DefaultColourNumber = GetColourNumber(ATTokenVal);break;
	case ATFONT:      	FontFamily = GetFontNumber(ATTokenVal);break;
	case ATFONTSIZE:  	FontSize = atoi(ATTokenVal);break;
	case ATFONTWEIGHT:  	FontWeight = GetFontWeight(ATTokenVal);break;
	case ATFONTSLANT:  	FontSlant = GetFontSlant(ATTokenVal);break;
	case ATFONTCOLOR:  	FontColour = GetColourNumber(ATTokenVal);break;
	case ATLOCALXYZ:  	sscanf(ATTokenVal,"%lf %lf %lf",&LocObjX,&LocObjY,&LocObjZ);break;
	case ATLOCALXROT: 	sscanf(ATTokenVal,"%lf ",&LocRotX);break;
	case ATLOCALYROT: 	sscanf(ATTokenVal,"%lf ",&LocRotY);break;
	case ATLOCALZROT: 	sscanf(ATTokenVal,"%lf ",&LocRotZ);break;
	case ATLOCALROTCEN:	sscanf(ATTokenVal,"%lf %lf %lf",&RotCenX,&RotCenY,&RotCenZ);break;
	case ATLOCALSCALE:	sscanf(ATTokenVal,"%lf",&LocalScale);break;
	case ATSCALEX:		sscanf(ATTokenVal,"%lf",&LocScaleX);break;
	case ATSCALEY:		sscanf(ATTokenVal,"%lf",&LocScaleY);break;
	case ATSCALEZ:		sscanf(ATTokenVal,"%lf",&LocScaleZ);break;
	case ATCIRCLERES: 	DefaultResolution  = atoi(ATTokenVal);break;
	case ATSCALECENXYZ:	sscanf(ATTokenVal,"%lf %lf %lf",&ScaleCenX,&ScaleCenY,&ScaleCenZ);break;
	case ATGLOBALLINEWIDTH: DDefLineWidth = 
				DefaultLineWidth = atoi(ATTokenVal);break;
	case ATGLOBALLINESTYLE: DDefLineStyle =
				DefaultLineStyle = GetLineStyle(ATTokenVal);break;
	case ATGLOBALCOLOR:     DDefColor =
				DefaultColourNumber = 
				GetColourNumber(ATTokenVal);break;
	case ATGLOBALFILLSTYLE: DDefFillStyle =
				DefaultFillStyle = 
				GetFillStyle(ATTokenVal);break;
	case ATGLOBALPOINTTYPE: DDefPointType =
				DefaultPointType = 
				GetPointNumber(ATTokenVal);break;
	case ATGLOBALPOINTSIZE: DDefPointSize =
				DefaultPointSize = 
				atoi(ATTokenVal);break;
	case ATGLOBALCIRCLERES: DDefResolution =
				DefaultResolution  = 
				atoi(ATTokenVal);break;
	}

	return ;
}

int FileExist(filename)
char *filename;
{
        FILE *FilePtr;
        if ((FilePtr  = fopen(filename, "r"))==NULL){
                        XmErr(FILE_NOT_FOUND);
                        return 0;}
        else return 1;
}

void
LocalRotate(Polygons, RotX,RotY,RotZ,RotCenX,RotCenY,RotCenZ)
t_LL Polygons;
double RotX;
double RotY;
double RotZ;
double RotCenX;
double RotCenY;
double RotCenZ;
{
	t_XmgfPt *Pt;
	t_XmgfPt  NewPt;
	t_XmgfPoly *Poly;
	double DRotZ,DRotX,DRotY;

	DRotZ = Deg2Rad(RotZ);
	DRotX = Deg2Rad(RotX);
	DRotY = Deg2Rad(RotY);

	ForeachLL_M(Polygons,Poly){
	 ForeachLL_M(Poly->ListXmgfPts,Pt){
	 /* Local Scale X,Y,Z */
	 NewPt.x =  Pt->x - ScaleCenX;
	 NewPt.y =  Pt->y - ScaleCenY;
	 NewPt.z =  Pt->z - ScaleCenZ;
	 *Pt = NewPt;
	 NewPt.x =  Pt->x*LocScaleX;
	 NewPt.y =  Pt->y*LocScaleY;
	 NewPt.z =  Pt->z*LocScaleZ;
	 *Pt = NewPt;
	 /* Local ScaleXYZ */
	 NewPt.x =  Pt->x*LocalScale;
	 NewPt.y =  Pt->y*LocalScale;
	 NewPt.z =  Pt->z*LocalScale;
	 *Pt = NewPt;
	 NewPt.x =  Pt->x + ScaleCenX;
	 NewPt.y =  Pt->y + ScaleCenY;
	 NewPt.z =  Pt->z + ScaleCenZ;
	 *Pt = NewPt;
	/* Rotation */
	 NewPt.x =  Pt->x - RotCenX;
	 NewPt.y =  Pt->y - RotCenY;
	 NewPt.z =  Pt->z - RotCenZ;
	 *Pt = NewPt;
	 NewPt.x = (Pt->x*cos(DRotZ)) + (Pt->y*sin(DRotZ));
	 NewPt.y = (Pt->x*-sin(DRotZ)) + (Pt->y*cos(DRotZ));
	 NewPt.z = Pt->z;
	 *Pt = NewPt;
	 NewPt.x = (Pt->x*cos(DRotY)) + (Pt->z*sin(DRotY));
         NewPt.z = (Pt->x*-sin(DRotY)) + (Pt->z*cos(DRotY));
         NewPt.y = Pt->y;
	 *Pt = NewPt;
	 NewPt.y = (Pt->y*cos(DRotX)) + (Pt->z*sin(DRotX));
         NewPt.z = (Pt->y*-sin(DRotX)) + (Pt->z*cos(DRotX));
         NewPt.x = Pt->x;
	 *Pt = NewPt;
	 NewPt.x =  Pt->x + RotCenX;
         NewPt.y =  Pt->y + RotCenY;
         NewPt.z =  Pt->z + RotCenZ;
         *Pt = NewPt;

	}
	
       }
}

void
ResetLocalScales()
{
	LocScaleX=1.0;
	LocScaleY=1.0;
	LocScaleZ=1.0;
	LocalScale=1.0;
	ScaleCenX=0.0;
	ScaleCenY=0.0;
	ScaleCenZ=0.0;
	RotCenX=0.0;
	RotCenY=0.0;
	RotCenZ=0.0;
}

