/*
 * Copyright (C) 1992, 1993, Paul D. Hoad This file is part of the Xmgf
 * Software. For conditions of distribution and use, see the accompanying
 * README file.
 *
 * Vision Speech and Signal Processing Group . Dept. of Electronic Engineering.
 * University of Surrey. Guildford, Surrey. England. Phone: +44 483 300800
 * Ext 2753 Email: P.Hoad@ee.surrey.ac.uk
 */
#include <stdio.h>
#include <stdlib.h>
#ifdef HAVESLEEP
#include <unistd.h>
#endif
#include "XmgfStruct.h"
#include "XmgfDefines.h"
#include "Printer.h"
#include "Pixmaps.h"
#include "Compression.h"
#include "Disp3DGF.h"

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Function ProtoTypes For Printer.c */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
#ifndef _NO_PROTO
void PrinterCleanUp(char *filename);
#else
void PrinterCleanUp();
#endif

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Print The Current Image */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
PrintImage(PrinterName, Orientation, Colour)
char *PrinterName;
int Orientation;
int Colour;
{
	char *tmpdir;
	char filename[MAX_FILENAME];
	char str[MAX_FILENAME];
	int status;

	/* File Creation idea from XV */
	tmpdir = (char *) getenv("TMPDIR");
	if (!tmpdir)
		tmpdir = "/tmp";

	sprintf(filename, "%s/xmgf_XXXXXX", tmpdir);
	mktemp(filename);
	if (filename == NULL)
		fprintf(stderr, "mktemp Error\n");
	/* save as postscript */
	OutputPS(filename, SAVE_COLOUR, Orientation);
	sprintf(str, "%s %s", PrinterName, filename);

	if (system(str)) {
		fprintf(stderr, "Unable to Print '%s'...\n", filename);
		status = 0;
	} else {
		fprintf(stderr, "Printing '%s'...on %s\n", filename, PrinterName);
		status = 1;
	}
	fprintf(stderr, "Removing Temp File\n");
	fprintf(stderr, "Waiting for Printer\n");
	sleep(5);
	PrinterCleanUp(filename);
	fprintf(stderr, "Done\n");
	return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Clean Up the Print File */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
PrinterCleanUp(filename)
char *filename;
{
	char str[128];
	int status;

	sprintf(str, "%s %s", appres.RemoveCommand, filename);
	fprintf(stderr, "Removing file '%s'...\n", filename);
	if (system(str)) {
		fprintf(stderr, "Unable to Remove file '%s'...\n", filename);
		status = 0;
	} else
		status = 1;

	return ;
}
