/*
 * Copyright (C) 1992, 1993, Paul D. Hoad This file is part of the Xmgf
 * Software. For conditions of distribution and use, see the accompanying
 * README file.
 *
 * Vision Speech and Signal Processing Group . Dept. of Electronic Engineering.
 * University of Surrey. Guildford, Surrey. England. Phone: +44 483 300800
 * Ext 2753 Email: P.Hoad@ee.surrey.ac.uk
 */
#include <X11/StringDefs.h>
#include "XmgfStruct.h"
#include "XmgfGlobal.h"
#include "XmgfDefines.h"
#include "InitX.h"
#include "Polygon.h"
#include "callbacks.h"
#include "Parse.h"
#include "Pixmaps.h"

#define FRCTSPERBATCH 1024

#ifndef _NO_PROTO 
void DrawDot(short x, short y, Window TmpWind);
void DrawBox(short x, short y, Window TmpWind);
void DrawTri(short x, short y, Window TmpWind);
void DrawCross(short x, short y, Window TmpWind);
void DrawCircle(short x, short y, Window TmpWind);
void DrawPlus(short x, short y, Window TmpWind);
void DrawFilledB(short x, short y, Window TmpWind);
void DrawFilledT(short x, short y, Window TmpWind);
void DrawFilledCircle(short x, short y, Window TmpWind);
void MakeOutLine(XPoint *Pts,int num,Window TmpWind);
#else 
void DrawDot();
void DrawBox();
void DrawTri();
void DrawCross();
void DrawCircle();
void DrawPlus();
void DrawFilledB();
void DrawFilledT();
void DrawFilledCircle();
void MakeOutLine();
#endif 

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
Polygon(Pts, num, fill, TmpWind, Color, PtType, BaseType, LineStyle, LineWidth, FillStyle,ShadedVal)
XPoint *Pts;
int num;
int fill;
Window TmpWind;
int Color;
int PtType;
int BaseType;
int LineStyle;
int LineWidth;
int FillStyle;
int ShadedVal;
{

	int i;

	fill =  DetermineFillType(fill,num,PtType,FillStyle,BaseType);
	SetColor(Color);
	SetLine(LineWidth, LineStyle);
	switch (fill) {
	    case DOT:{
			DrawDot(Pts[0].x, Pts[0].y, TmpWind);
			break;
		}
	    case PLUS:{
			DrawPlus(Pts[0].x, Pts[0].y, TmpWind);
			break;
		}
	    case BOX:{
			DrawBox(Pts[0].x, Pts[0].y, TmpWind);
			break;
		}
	    case TRI:{
			DrawTri(Pts[0].x, Pts[0].y, TmpWind);
			break;
		}
	    case CROSS:{
			DrawCross(Pts[0].x, Pts[0].y, TmpWind);
			break;
		}
	    case PTCIRCLE:{
			DrawCircle(Pts[0].x, Pts[0].y, TmpWind);
			break;
		}
	    case FILLEDBOX:{
			DrawFilledB(Pts[0].x, Pts[0].y, TmpWind);
			break;
		}
	    case FILLEDTRI:{
			DrawFilledT(Pts[0].x, Pts[0].y, TmpWind);
			break;
		}
	    case FILLEDCIRCLE:{
			DrawFilledCircle(Pts[0].x, Pts[0].y, TmpWind);
                        break;
		}
	    case FILLEDOPAQUE:{
/*			SetColor(DEFAULTCOL);*/
			SetColor(BackGroundColour);
			XFillPolygon(theDisplay, (Drawable) TmpWind, theGC, Pts, num, CoordModeOrigin, Complex);
			SetColor(0);
			XDrawLines(theDisplay, (Drawable) TmpWind, theGC, Pts, num, CoordModeOrigin);
			break;
		}
	    case COLOUREDOPAQUE:{
/*			SetColor(DEFAULTCOL);*/
			SetColor(BackGroundColour);
			XFillPolygon(theDisplay, (Drawable) TmpWind, theGC, Pts, num, CoordModeOrigin, Complex);
                        SetColor(Color);
                        XDrawLines(theDisplay, (Drawable) TmpWind, theGC, Pts, num, CoordModeOrigin);
			break;

	     	}
	    case WHITELINES:{
			SetColor(63);
			CheckDither();
			XDrawLines(theDisplay, (Drawable) TmpWind, theGC, Pts, num, CoordModeOrigin);
			ReturnDither();
			break;
		}
	    case BLACKLINES:{
			SetColor(0);
			CheckDither();
			XDrawLines(theDisplay, (Drawable) TmpWind, theGC, Pts, num, CoordModeOrigin);
			ReturnDither();
			break;
		}
	    case COLOUREDLINES:{
			SetColor(Color);
                        XDrawLines(theDisplay, (Drawable) TmpWind, theGC, Pts, num, CoordModeOrigin);
                        break;
                }
	    case FILLEDHIDDENLINE:{
			SetColor(10);
			ChangeTile(ShadedVal);
			XFillPolygon(theDisplay, (Drawable) TmpWind, theGC, Pts, num, CoordModeOrigin, Complex);
			SetColor(50);
			XDrawLines(theDisplay, (Drawable) TmpWind, theGC, Pts, num, CoordModeOrigin);
			MakeOutLine(Pts,num,TmpWind);
/*			XSetForeground(theDisplay, theGC, 0);*/
			break;
		}
  case FILLEDCOLOR:{
   SetColor(Color);
   ChangeTile(ShadedVal);
   XFillPolygon(theDisplay,(Drawable)TmpWind,theGC,Pts,num,CoordModeOrigin,Complex);
   MakeOutLine(Pts,num,TmpWind);
   break;
		}
 case FILLEDDITHER:{
	fprintf(stderr,"Should not be in here \n");
	SetColor(Color);
        if (DitherFill){
	if (ShadedVal>=0 && ShadedVal<64) ChangeTile(ShadedVal);
	}
	XFillPolygon(theDisplay, (Drawable) TmpWind, theGC, Pts, num , CoordModeOrigin, Complex);
                      XSetForeground(theDisplay, theGC, 0);
			break;
			}
 case POINTS_ONLY:{
	SetColor(Color);
	 for(i=0;i<num+1;i++){ switch(PtType){ 
	   case MENU_POINT: DrawDot(Pts[i].x,Pts[i].y,TmpWind); break;
	   case MENU_BOX: DrawBox(Pts[i].x,Pts[i].y,TmpWind); break;
	   case MENU_TRI: DrawTri(Pts[i].x,Pts[i].y,TmpWind); break;
	   case MENU_CROSS: DrawCross(Pts[i].x,Pts[i].y,TmpWind);break;
	   case MENU_CIRCLE: DrawCircle(Pts[i].x,Pts[i].y,TmpWind); break;
	   case MENU_PLUS: DrawPlus(Pts[i].x,Pts[i].y,TmpWind); break;
	   case MENU_FILLEDBOX: DrawFilledB(Pts[i].x,Pts[i].y,TmpWind); break;
	   case MENU_FILLEDTRI: DrawFilledT(Pts[i].x,Pts[i].y,TmpWind); break;
	   case MENU_FILLEDCIRCLE: DrawFilledCircle(Pts[i].x,Pts[i].y,TmpWind); break;
		} 
	} 
/*	XDrawPoints(theDisplay, (Drawable) TmpWind, theGC, Pts, num, CoordModeOrigin);*/
	XSetForeground(theDisplay, theGC, 0);
	break;
		}
	    case TEXTLABEL:{
		SetColor(Color);
		XmgfSetFont();
                XDrawString(theDisplay, (Drawable) TmpWind, theGC, Pts[0].x,Pts[0].y,CurrentString, strlen(CurrentString));
		break;
        }
	    default:{		/* NOFILL */
			SetColor(Color);
			XDrawLines(theDisplay, (Drawable) TmpWind, theGC, Pts, num, CoordModeOrigin);
			break;
		}
	}
	return ;
}

void
DrawDot(x, y, TmpWind)
short x;
short y;
Window TmpWind;
{
	XDrawPoint(theDisplay, (Drawable) TmpWind, theGC, x, y);
}

void
DrawPlus(x, y, TmpWind)
short x;
short y;
Window TmpWind;
{
	int P;

	P = DefaultPointSize;
	XDrawLine(theDisplay, (Drawable) TmpWind, theGC, x - P, y, x + P, y);
	XDrawLine(theDisplay, (Drawable) TmpWind, theGC, x, y + P, x, y - P);
}

void
DrawBox(x, y, TmpWind)
short x;
short y;
Window TmpWind;
{
	int P;

	P = DefaultPointSize;
	XDrawLine(theDisplay, (Drawable) TmpWind, theGC, x - P, y - P, x + P, y - P);
	XDrawLine(theDisplay, (Drawable) TmpWind, theGC, x + P, y - P, x + P, y + P);
	XDrawLine(theDisplay, (Drawable) TmpWind, theGC, x + P, y + P, x - P, y + P);
	XDrawLine(theDisplay, (Drawable) TmpWind, theGC, x - P, y + P, x - P, y - P);
}

void
DrawTri(x, y, TmpWind)
short x;
short y;
Window TmpWind;
{
	int P;

	P = DefaultPointSize;
	XDrawLine(theDisplay, (Drawable) TmpWind, theGC, x - P, y + P, x + P, y + P);
	XDrawLine(theDisplay, (Drawable) TmpWind, theGC, x + P, y + P, x, y - P);
	XDrawLine(theDisplay, (Drawable) TmpWind, theGC, x, y - P, x - P, y + P);
}

void
DrawCross(x, y, TmpWind)
short x;
short y;
Window TmpWind;
{
	int P;

	P = DefaultPointSize;
	XDrawLine(theDisplay, (Drawable) TmpWind, theGC, x - P, y + P, x + P, y - P);
	XDrawLine(theDisplay, (Drawable) TmpWind, theGC, x + P, y + P, x - P, y - P);
}

void
DrawCircle(x, y, TmpWind)
short x;
short y;
Window TmpWind;
{
	int P;

	P = DefaultPointSize;
	XDrawArc(theDisplay, (Drawable) TmpWind, theGC, x - P, y - P, (unsigned int)(2 * P), (unsigned int)(2 * P), 0, 360 * 64);
}

void
DrawFilledCircle(x, y, TmpWind)
short x;
short y;
Window TmpWind;
{
	int P;

	P = DefaultPointSize;
	XFillArc(theDisplay, (Drawable) TmpWind, theGC, x - P, y - P, (unsigned int)(2 * P), (unsigned int)(2 * P), 0, 360 * 64);
}


void
DrawFilledB(x, y, TmpWind)
short x;
short y;
Window TmpWind;
{
	int P;
	XPoint Tmp[5];

	P = DefaultPointSize;
	Tmp[0].x = x - (P + 1);
	Tmp[0].y = y - (P + 1);
	Tmp[1].x = x + (P + 1);
	Tmp[1].y = y - (P + 1);
	Tmp[2].x = x + (P + 1);
	Tmp[2].y = y + (P + 1);
	Tmp[3].x = x - (P + 1);
	Tmp[3].y = y + (P + 1);
	Tmp[4].x = x - (P + 1);
	Tmp[4].y = y - (P + 1);
	XFillPolygon(theDisplay, (Drawable) TmpWind, theGC, Tmp, 5, CoordModeOrigin, Complex);
}

void
DrawFilledT(x, y, TmpWind)
short x;
short y;
Window TmpWind;
{
	int P;
	XPoint Tmp[4];

	P = DefaultPointSize;
	Tmp[0].x = x - (P + 1);
	Tmp[0].y = y + (P + 1);
	Tmp[1].x = x;
	Tmp[1].y = y - (P + 1);
	Tmp[2].x = x + (P + 1);
	Tmp[2].y = y + (P + 1);
	Tmp[3].x = x - (P + 1);
	Tmp[3].y = y + (P + 1);
	XFillPolygon(theDisplay, (Drawable) TmpWind, theGC, Tmp, 4, CoordModeOrigin, Complex);
}

void
MakeOutLine(Pts,num,TmpWind)
XPoint *Pts;
int num;
Window TmpWind;
{

    if(OutLine){
    SetColor(OutLineColour);
    if (DitherFill) XSetFillStyle(theDisplay,theGC,FillSolid);
    XDrawLines(theDisplay,(Drawable)TmpWind,theGC,Pts,num,CoordModeOrigin); 
    if (DitherFill) XSetFillStyle(theDisplay,theGC,FillOpaqueStippled);
    }
}

