/*
 * Copyright (C) 1992, 1993, Paul D. Hoad This file is part of the Xmgf
 * Software. For conditions of distribution and use, see the accompanying
 * README file.
 *
 * Vision Speech and Signal Processing Group . Dept. of Electronic Engineering.
 * University of Surrey. Guildford, Surrey. England. Phone: +44 483 300800
 * Ext 2753 Email: P.Hoad@ee.surrey.ac.uk
 */
#include <string.h>
#include <assert.h>

#include "XmgfStruct.h"
#include "XmgfGlobal.h"
#include "XmgfDefines.h"

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <Xm/SelectioB.h>
#include <Xm/FileSB.h>
#include <Xm/RowColumn.h>
#include <Xm/Label.h>
#include <Xm/ToggleB.h>


#include "Pixmaps.h"
#include "XmError.h"
#include "Menus.h"
#include "Disp3DGF.h"
#include "XFig.h"
#include "FrameMaker.h"
#include "PostScript.h"
#include "RayShade.h"
#include "InitX.h"
#include "GUI.h"
#include "BackDrop.h"
#include "Parse.h"
#include "MotifUtils.h"
#include "callbacks.h"
#include "rasterfile.h"
#include "Read3DSet.h"
#include "Animator.h"
#include "XmgfHelp.h"

char           *PGMDIR;
char           *PGMFIL;
char           *XBMDIR;
char           *XBMFIL;
char           *PBMDIR;
char           *PBMFIL;
char           *PPMDIR;
char           *PPMFIL;
char           *GIFDIR;
char           *GIFFIL;
char           *RASDIR;
char           *RASFIL;
char           *GFDIR;
char           *GFFIL;
char           *IMGDIR;
char           *IMGFIL;
char           *POSTDIR;
char           *POSTFIL;
char           *EPSDIR;
char           *EPSFIL;
char           *FIGDIR;
char           *FIGFIL;
char           *PARMDIR;
char           *PARMFIL;
char           *RAYDIR;
char           *RAYFIL;
char           *IMPORTDIR;
char           *IMPORTFIL;
char           *CMAPDIR;
char           *CMAPFIL;
char           *MIFDIR;
char           *MIFFIL;
char 	       *ANIMDIR;
char 	       *ANIMFIL;
char           *CurrentFile;


/*
 * XV2.21 Derived from Output Handling Routines Author:    John Bradley,
 * University of Pennsylvania (bradley@cis.upenn.edu)
 */

/* MONO returns total intensity of r,g,b components */
#define MONO(rd,gn,bl) (((rd)*11 + (gn)*16 + (bl)*5) >> 5)	/* .33R+ .5G+ .17B */

#define MAX_CELLS  256

typedef struct {
	XImage *ximage;
	int numcells;
	int red[MAX_CELLS], green[MAX_CELLS], blue[MAX_CELLS];
	unsigned char used[MAX_CELLS];
} imageInfo;

typedef struct {
	XImage *ximage;
	int numcells;
	unsigned char red[MAX_CELLS], green[MAX_CELLS], blue[MAX_CELLS];
	unsigned char used[MAX_CELLS];
} RASimage;

typedef long int count_int;
typedef unsigned char byte;
static byte pc2nc[256], r1[256], g1[256], b1[256];
int format = ZPixmap;

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SavePGMCB(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	XmFileSelect("Saving PGM File", SAVE_PGM_FILE, PGMFIL, "Out.pgm", PGMDIR);
	return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SaveXBMCB(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	if (theDepth < 8) {
		XmErr(MONO_NOSAVE);
		return ;
	}
	XmFileSelect("Saving XBM File", SAVE_XBM_FILE, XBMFIL, "Out.xbm", XBMDIR);
	return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SavePBMCB(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	XmFileSelect("Saving PBM File", SAVE_PBM_FILE, PBMFIL, "Out.pbm", PBMDIR);
	return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SavePPMCB(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	if (theDepth < 8) {
		XmErr(MONO_NOSAVE);
		return ;
	}
	XmFileSelect("Saving PPM File", SAVE_PPM_FILE, PPMFIL, "Out.ppm", PPMDIR);
	return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SaveGIFCB(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	if (theDepth < 8) {
		XmErr(MONO_NOSAVE);
		return ;
	}
	XmFileSelect("Saving GIF File", SAVE_GIF_FILE, GIFFIL, "Out.gif", GIFDIR);
	return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SaveRASCB(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	int ColourRequest = (int) client_data;
	int FileType;

	if (theDepth < 8) {
		XmErr(MONO_NOSAVE);
		return ;
	}
	switch (ColourRequest) {
	    case SAVE_COLOUR:
		FileType = SAVE_RASCOL_FILE;
		break;
	    case SAVE_GREY:
		FileType = SAVE_RAS_FILE;
		break;
	    default:
		FileType = SAVE_RAS_FILE;
		break;
	}
	XmFileSelect("Saving SunRaster File", FileType, RASFIL, "Out.ras", RASDIR);
	return ;
}


/*
 * Determine the pixmap size.
 */

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
int
Image_Size(image)
XImage *image;
{
	if (image->format != ZPixmap)
		return (image->bytes_per_line * image->height * image->depth);

	return (image->bytes_per_line * image->height);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
OutputPBM(fname, x, y, width, height, GraphicArea)
char *fname;
int x;
int y;
int width;
int height;
Window GraphicArea;
{
	imageInfo image;
	XImage *ximage;
	FILE *out_file;
	int i, j, k, bit;
	int ncolors;
	int BuffCount, Grey;
	Colormap cmap;
	int ArrayIndex;
	XColor colors[MAX_CELLS];
	int *newBuffer;

	/* Open Output File */
	/* At later date this will be made from file selector */
	BusyCursor();
	out_file = fopen(fname, "w");
	/* Grap window to Pixmap */
	ximage = XGetImage(theDisplay, GraphicArea, x, y, (unsigned int)width, (unsigned int)height, AllPlanes, format);
	image.ximage = ximage;

	cmap = DefaultColormap(theDisplay, theScreen);
	ncolors = DisplayCells(theDisplay, theScreen);
	for (i = 0; i < ncolors; i++) {
		colors[i].pixel = i;
	}
	BusyCursor();
	XQueryColors(theDisplay, cmap, colors, ncolors);
	for (i = 0; i < ncolors; i++) {
		image.red[i] = colors[i].red;
		image.green[i] = colors[i].green;
		image.blue[i] = colors[i].blue;
	}
	BusyCursor();

	/* Trasnfer Pixmap to PBM file */
	newBuffer = (int *) malloc(width * height * sizeof(int));
	assert(newBuffer);
	BuffCount = 0;
	BusyCursor();
	for (i = 0; i < width * height; i++) {
		ArrayIndex = image.ximage->data[i];
		Grey = MONO(image.red[ArrayIndex], image.green[ArrayIndex], image.blue[ArrayIndex]);
		newBuffer[BuffCount++] = (int) (Grey);
	}
	BusyCursor();
	/* Trasnfer Pixmap to PBM file */
	fprintf(out_file, "P4\n%d %d\n", (width - x), (height - y));
	/* 1-bit B/W stipple */
	for (i = 0; i < height; i++) {
		for (j = 0, bit = 0, k = 0; j < width; j++, newBuffer++) {
			k = (k << 1) | !*newBuffer;
			/* if (*newBuffer) K |= 0x80; */
			/* k = (k << 1) | !*newBuffer; */
			bit++;
			if (bit == 8) {
				fputc(k, out_file);
				bit = k = 0;
			}
		}		/* j */
		if (bit) {
			k = k << (8 - bit);
			fputc(k, out_file);
		}
	}
	BusyCursor();
	fclose(out_file);
	return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
OutputXBM(filename, x, y, width, height, GraphicArea)
char *filename;
int x;
int y;
int width;
int height;
Window GraphicArea;
{
	imageInfo image;
	XImage *ximage;
	char name[MAX_FILENAME], *foo;
	char fname[MAX_FILENAME];
	FILE *out_file;
	int i, j, k, bit;
	int ncolors;
	int BuffCount, Grey;
	Colormap cmap;
	int ArrayIndex;
	XColor colors[MAX_CELLS];
	int *newBuffer;
	int nbytes, len;

	/* Open Output File */
	/* At later date this will be made from file selector */
	BusyCursor();
	out_file = fopen(filename, "w");
	strcpy(fname, filename);
	/* figure out a reasonable basename */
	strcpy(name, fname);
	/* compute basefname */
	foo = (char *) rindex(name, '/');
	if (!foo)
		foo = name;
	else
		foo++;
	strcpy(name, foo);

	foo = (char *) strchr(name, '.');
	if (foo)
		*foo = '\0';	/* truncated name at first '.' */
	/* Grap window to Pixmap */
	ximage = XGetImage(theDisplay, GraphicArea, x, y, (unsigned int)width,(unsigned int) height, AllPlanes, format);
	image.ximage = ximage;

	BusyCursor();
	cmap = DefaultColormap(theDisplay, theScreen);
	ncolors = DisplayCells(theDisplay, theScreen);
	for (i = 0; i < ncolors; i++) {
		colors[i].pixel = i;
	}
	BusyCursor();
	XQueryColors(theDisplay, cmap, colors, ncolors);
	for (i = 0; i < ncolors; i++) {
		image.red[i] = colors[i].red;
		image.green[i] = colors[i].green;
		image.blue[i] = colors[i].blue;
	}
	BusyCursor();
	/* Trasnfer Pixmap to XBM file */
	newBuffer = (int *) malloc(width * height * sizeof(int));
	assert(newBuffer);
	BuffCount = 0;
	for (i = 0; i < width * height; i++) {
		ArrayIndex = image.ximage->data[i];
		Grey = MONO(image.red[ArrayIndex], image.green[ArrayIndex], image.blue[ArrayIndex]);
		newBuffer[BuffCount++] = (int) (Grey);
	}
	BusyCursor();
	fprintf(out_file, "#define %s_width %d\n", name, (width - x));
	fprintf(out_file, "#define %s_height %d\n", name, (height - y));
	fprintf(out_file, "static char %s_bits[] = {\n", name);
	fprintf(out_file, " ");

	nbytes = (height - y) * (((width - x) + 7) / 8);	/* # of bytes to write */
	for (i = 0, len = 1; i < (height - y); i++) {
		for (j = bit = k = 0; j < (width - x); j++, newBuffer++) {
			k = (k >> 1);
			if (*newBuffer)
				k |= 0x80;
			bit++;
			if (bit == 8) {
				fprintf(out_file, "0x%02x", (unsigned char) ~k);
				nbytes--;
				len += 4;
				if (nbytes) {
					fprintf(out_file, ",");
					len++;
				}
				if (len > 72) {
					fprintf(out_file, "\n ");
					len = 1;
				}
				bit = k = 0;
			}
		}

		if (bit) {
			k = k >> (8 - bit);
			fprintf(out_file, "0x%02x", (unsigned char) ~k);
			nbytes--;
			len += 4;
			if (nbytes) {
				fprintf(out_file, ",");
				len++;
			}
			if (len > 72) {
				fprintf(out_file, "\n ");
				len = 1;
			}
		}
	}

	BusyCursor();
	fprintf(out_file, "};\n");
	fclose(out_file);
	BusyCursor();
	return ;
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
int
XmFileSelect(title, fileType, selmask, defaultName, PWD)
char *title;
int fileType;
char *selmask;
char *defaultName;
char *PWD;
{
	if (FileSelector) return 0;
	FileSelector = CreateFileSelect(toplevel,
		title, "See README for info ", selmask, defaultName, NULL, 0, PWD);

	XtAddCallback(FileSelector, XmNokCallback,
		(XtCallbackProc) FICB, (caddr_t) fileType);
	XtAddCallback(FileSelector, XmNcancelCallback,
		(XtCallbackProc) NOFICB, (caddr_t) fileType);
	XtAddCallback(FileSelector, XmNhelpCallback,
		(XtCallbackProc) XmgfHelpCB, (caddr_t) HELP_LOAD);
	XtManageChild(w_FileSelectorDia);

	return 0;
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
int
FICB(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	Arg args[5];
	int Orientation = 0;
	char *DirectoryName;
	char *FilterName;
	XmString MotifString, FilterString;

	XmFileSelectionBoxCallbackStruct *fcb
	= (XmFileSelectionBoxCallbackStruct *) call_data;

	XmStringGetLtoR(fcb->value, charset, &Selectedfilename);

	XtSetArg(args[0], XmNdirectory, &MotifString);
	XtGetValues(FileSelector, args, 1);
	XtSetArg(args[0], XmNpattern, &FilterString);
	XtGetValues(FileSelector, args, 1);
	DirectoryName = (char *) malloc(256 * sizeof(char));
	assert(DirectoryName);
	FilterName = (char *) malloc(256 * sizeof(char));
	assert(FilterName);
	XmStringGetLtoR(MotifString, charset, &DirectoryName);
	XmStringGetLtoR(FilterString, charset, &FilterName);
	LoadOpen = 1;
	BusyCursor();
	if (Selectedfilename != NULL) {
		switch ((int) client_data) {
		    case SAVE_PGM_FILE:
			OutputPGM(Selectedfilename, 0, 0, 512, 512, w_Orth);
			strcpy(PGMDIR, DirectoryName);
			strcpy(PGMFIL, FilterName);
			break;
		    case SAVE_XBM_FILE:
			OutputXBM(Selectedfilename, 0, 0, 512, 512, w_Orth);
			strcpy(XBMDIR, DirectoryName);
			strcpy(XBMFIL, FilterName);
			break;
		    case SAVE_PBM_FILE:
			OutputPBM(Selectedfilename, 0, 0, 512, 512, w_Orth);
			strcpy(PBMDIR, DirectoryName);
			strcpy(PBMFIL, FilterName);
			break;
		    case SAVE_PARM_FILE:
			OutputPARM(Selectedfilename);
			strcpy(PARMDIR, DirectoryName);
			strcpy(PARMFIL, FilterName);
			break;
		    case LOAD_PARM_FILE:
			InputPARM(Selectedfilename);
			strcpy(PARMDIR, DirectoryName);
			strcpy(PARMFIL, FilterName);
			break;
		    case SAVE_FIG_FILE:
			OutputFIG(Selectedfilename, SAVE_GREY);
			strcpy(FIGDIR, DirectoryName);
			strcpy(FIGFIL, FilterName);
			break;
		    case SAVE_FIGCOL_FILE:
			OutputFIG(Selectedfilename, SAVE_COLOUR);
			strcpy(FIGDIR, DirectoryName);
			strcpy(FIGFIL, FilterName);
			break;
		    case SAVE_EPS_FILE:
			OutputPS(Selectedfilename, SAVE_COLOUR, Orientation);
			strcpy(EPSDIR, DirectoryName);
			strcpy(EPSFIL, FilterName);
			break;
		    case SAVE_PS_FILE:
			OutputPS(Selectedfilename, SAVE_GREY, Orientation);
			strcpy(POSTDIR, DirectoryName);
			strcpy(POSTFIL, FilterName);
			break;
		    case SAVE_PSCOL_FILE:
			OutputPS(Selectedfilename, SAVE_COLOUR, Orientation);
			strcpy(POSTDIR, DirectoryName);
			strcpy(POSTFIL, FilterName);
			break;
		    case SAVE_MIF_FILE:
			OutputFRAME(Selectedfilename, 0);
			strcpy(MIFDIR, DirectoryName);
			strcpy(MIFFIL, FilterName);
			break;
		    case SAVE_RAY_FILE:
			OutputRAY(Selectedfilename);
			strcpy(RAYDIR, DirectoryName);
			strcpy(RAYFIL, FilterName);
			break;
		    case SAVE_GIF_FILE:
			OutputGIF(Selectedfilename, 0, 0, 512, 512, w_Orth);
			strcpy(GIFDIR, DirectoryName);
			strcpy(GIFFIL, FilterName);
			break;
		    case SAVE_RAS_FILE:
			OutputRAS(Selectedfilename, 0, 0, 512, 512, w_Orth, SAVE_GREY);
			strcpy(RASDIR, DirectoryName);
			strcpy(RASFIL, FilterName);
			break;
		    case SAVE_RASCOL_FILE:
			OutputRAS(Selectedfilename, 0, 0, 512, 512, w_Orth, SAVE_COLOUR);
			strcpy(RASDIR, DirectoryName);
			strcpy(RASFIL, FilterName);
			break;
		    case SAVE_PPM_FILE:
			OutputPPM(Selectedfilename, 0, 0, 512, 512, w_Orth);
			strcpy(PPMDIR, DirectoryName);
			strcpy(PPMFIL, FilterName);
			break;
		    case IMPORT_OFF_FILE:
			ImportFile(Selectedfilename, IMPORT_OFF_FILE);
			strcpy(IMPORTDIR, DirectoryName);
			strcpy(IMPORTFIL, FilterName);
			break;
		    case IMPORT_NFF_FILE:
			ImportFile(Selectedfilename, IMPORT_NFF_FILE);
			strcpy(IMPORTDIR, DirectoryName);
			strcpy(IMPORTFIL, FilterName);
			break;
		    case IMPORT_RAY_FILE:
			ImportFile(Selectedfilename, IMPORT_RAY_FILE);
			strcpy(IMPORTDIR, DirectoryName);
			strcpy(IMPORTFIL, FilterName);
			break;
		    case IMPORT_SLA_FILE:
			ImportFile(Selectedfilename, IMPORT_SLA_FILE);
			strcpy(IMPORTDIR, DirectoryName);
			strcpy(IMPORTFIL, FilterName);
			break;
		    case IMPORT_OBJ_FILE:
			ImportFile(Selectedfilename, IMPORT_OBJ_FILE);
			strcpy(IMPORTDIR, DirectoryName);
			strcpy(IMPORTFIL, FilterName);
			break;
		    case IMPORT_DXF_FILE:
			ImportFile(Selectedfilename, IMPORT_DXF_FILE);
			strcpy(IMPORTDIR, DirectoryName);
			strcpy(IMPORTFIL, FilterName);
			break;
		    case IMPORT_IGRIP_FILE:
			ImportFile(Selectedfilename, IMPORT_IGRIP_FILE);
			strcpy(IMPORTDIR, DirectoryName);
			strcpy(IMPORTFIL, FilterName);
			break;
		    case IMPORT_MINICAD_FILE:
			ImportFile(Selectedfilename, IMPORT_MINICAD_FILE);
			strcpy(IMPORTDIR, DirectoryName);
			strcpy(IMPORTFIL, FilterName);
			break;
		    case LOAD_IMG_FILE:{
				strcpy(IMGDIR, DirectoryName);
				strcpy(IMGFIL, FilterName);
				BackImage = ReadImage(Selectedfilename, &BackDropWidth, &BackDropHeight);
				UpdateImage();
				if (BackImage != NULL) {
/*				 if (ImagePix!=NULL ) XFreePixmap(theDisplay,ImagePix);*/
/*				 if (ImageDraw!=NULL) XFreePixmap(theDisplay,ImageDraw);*/
					BackDropImage = 1;
					Redraw();
				} else {
/*					if (ImagePix!=NULL ) XFreePixmap(theDisplay,ImagePix);*/
/*					if (ImageDraw!=NULL) XFreePixmap(theDisplay,ImageDraw);*/
					BackDropImage = 0;
					Redraw();
				}
				break;
		    case LOAD_GF_FILE:
				Load3DSets(Selectedfilename);
				strcpy(GFDIR, DirectoryName);
				strcpy(GFFIL, FilterName);
				break;
		    case APPEND_GF_FILE:
				Append3DSets(Selectedfilename);
				strcpy(GFDIR, DirectoryName);
				strcpy(GFFIL, FilterName);
				break;
		    case LOAD_CMAP_FILE:
				LoadColourMap(Selectedfilename, COLOURMAP);
				strcpy(CMAPDIR, DirectoryName);
				strcpy(CMAPFIL, FilterName);
				break;
		    case LOAD_GMAP_FILE:
				LoadColourMap(Selectedfilename, GREYMAP);
				strcpy(CMAPDIR, DirectoryName);
				strcpy(CMAPFIL, FilterName);
				break;
		    case LOAD_ANIM_FILE:
				LoadAnimation(Selectedfilename);
				strcpy(ANIMDIR, DirectoryName);
				strcpy(ANIMFIL, FilterName);
				break;
		    case SAVE_ANIM_FILE:
				SaveAnimation(Selectedfilename);
				strcpy(ANIMDIR, DirectoryName);
				strcpy(ANIMDIR, FilterName);
				break;

			}

		}
	}			/* if */
	DoneCursor();
	LoadOpen = 0;
	free(DirectoryName);
	free(FilterName);
	FileSelector = 0;

	return 0;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
int
NOFICB(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	LoadOpen = 0;
	XtDestroyWidget(w_FileSelectorDia);
	FileSelector = 0;
	return 0;
}



/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
Widget
CreateFileSelect(parent, name, message, mask, defaultfname, arglist, argcount, DirName)
Widget parent;
String name;
String message;
String mask;
String defaultfname;
ArgList arglist;
int argcount;
char *DirName;
{
	Widget w_FS_RC;
	Widget w_Label;
	Widget w_Compression;
	Arg args[10];

	XtSetArg(args[0], XtNwidth, 310);
	XtSetArg(args[1], XmNautoUnmanage, True);
	XtSetArg(args[2], XmNdirMask, Str2MotStr(mask));
	XtSetArg(args[3], XmNdirSpec, Str2MotStr(defaultfname));
	XtSetArg(args[4], XmNdirectory, Str2MotStr(DirName));
	w_FileSelectorDia = XmCreateFileSelectionDialog(parent,"File Selector", args, 5);

	XtSetArg(args[0], XmNorientation, XmVERTICAL);
	w_FS_RC = XtCreateManagedWidget("RC",
		xmRowColumnWidgetClass, w_FileSelectorDia, args, 1);

	XtSetArg(args[0], XmNlabelString, Str2MotStr(name));
	w_Label = XtCreateManagedWidget("w_Label",
		xmLabelWidgetClass, w_FS_RC, args, 1);

	XtSetArg(args[0], XmNlabelString, Str2MotStr("Compress on Save"));
	XtSetArg(args[1], XmNsensitive, FALSE);
	w_Compression = XtCreateManagedWidget("w_Compression",
		xmToggleButtonWidgetClass, w_FS_RC, args, 2);

	return (w_FileSelectorDia);
}

/*
 * XV2.21 Derived from Output Handling Routines Author:    John Bradley,
 * University of Pennsylvania (bradley@cis.upenn.edu)
 */


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
OutputPPM(fname, x, y, width, height, GraphicArea)
char *fname;
int x;
int y;
int width;
int height;
Window GraphicArea;
{
	imageInfo image;
	FILE *out_file;
	int i, ncolors;
	int BuffCount;
	Colormap cmap;
	int ArrayIndex;
	XColor colors[MAX_CELLS];
	unsigned char *newBuffer;
	XImage *ximage;

	/* Open Output File */
	/* At later date this will be made from file selector */
	BusyCursor();
	out_file = fopen(fname, "w");
	/* Grap window to Pixmap */
	ximage = XGetImage(theDisplay, GraphicArea, x, y,(unsigned int) width,(unsigned int) height, AllPlanes, format);
	image.ximage = ximage;

	cmap = DefaultColormap(theDisplay, theScreen);
	ncolors = DisplayCells(theDisplay, theScreen);
	for (i = 0; i < ncolors; i++) {
		colors[i].pixel = i;
	}
	BusyCursor();

	XQueryColors(theDisplay, cmap, colors, ncolors);
	for (i = 0; i < ncolors; i++) {
		image.red[i] = colors[i].red;
		image.green[i] = colors[i].green;
		image.blue[i] = colors[i].blue;
	}
	BusyCursor();

	/* Trasnfer Pixmap to PPM file */
	newBuffer = (unsigned char *) malloc(width * height * 3 * sizeof(unsigned char));
	assert(newBuffer);
	BuffCount = 0;
	BusyCursor();
	for (i = 0; i < width * height; i++) {
		ArrayIndex = image.ximage->data[i];
		newBuffer[BuffCount++] = (unsigned char) image.red[ArrayIndex];
		newBuffer[BuffCount++] = (unsigned char) image.green[ArrayIndex];
		newBuffer[BuffCount++] = (unsigned char) image.blue[ArrayIndex];
	}
	BusyCursor();
	fprintf(out_file, "P6\n%d %d\n%d\n", (width - x), (height - y), 255);
	fwrite(newBuffer, width * height * 3, 1, out_file);
	BusyCursor();
	fclose(out_file);
	return ;
}

/*
 * XV2.21 Derived from Output Handling Routines Author:    John Bradley,
 * University of Pennsylvania (bradley@cis.upenn.edu)
 */


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
OutputPGM(fname, x, y, width, height, GraphicArea)
char *fname;
int x;
int y;
int width;
int height;
Window GraphicArea;
{
	imageInfo image;
	FILE *out_file;
	int i, ncolors;
	int BuffCount;
	Colormap cmap;
	int ArrayIndex;
	double Red, Blue, Green;
	XColor colors[MAX_CELLS];
	unsigned char *newBuffer;
	XImage *ximage;

	/* Open Output File */
	/* At later date this will be made from file selector */
	BusyCursor();
	out_file = fopen(fname, "w");
	/* Grap window to Pixmap */
	ximage = XGetImage(theDisplay, GraphicArea, x, y,(unsigned int) width,(unsigned int) height, AllPlanes, format);
	image.ximage = ximage;

	BusyCursor();
	cmap = DefaultColormap(theDisplay, theScreen);
	ncolors = DisplayCells(theDisplay, theScreen);
	for (i = 0; i < ncolors; i++) {
		colors[i].pixel = i;
	}
	BusyCursor();
	XQueryColors(theDisplay, cmap, colors, ncolors);
	for (i = 0; i < ncolors; i++) {
		image.red[i] = colors[i].red;
		image.green[i] = colors[i].green;
		image.blue[i] = colors[i].blue;
	}
	BusyCursor();

	/* Trasnfer Pixmap to PGM file */
	newBuffer = (unsigned char *) malloc(width * height * sizeof(unsigned char));
	assert(newBuffer);
	BuffCount = 0;
	for (i = 0; i < width * height; i++) {
		ArrayIndex = image.ximage->data[i];
		Red = (double) image.red[ArrayIndex];
		Green = (double) image.green[ArrayIndex];
		Blue = (double) image.blue[ArrayIndex];
		newBuffer[BuffCount++] = (unsigned char)
			(0.299 * Red + 0.587 * Green + 0.114 * Blue);
	}
	BusyCursor();
	fprintf(out_file, "P5\n%d %d\n%d\n", (width - x), (height - y), 255);
	fwrite(newBuffer, width * height, 1, out_file);
	fclose(out_file);
	return ;
}

/*
 * XV2.21 Derived from Output Handling Routines Author:    John Bradley,
 * University of Pennsylvania (bradley@cis.upenn.edu)
 */


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
OutputRAS(fname, x, y, width, height, GraphicArea, Col)
char *fname;
int x;
int y;
int width;
int height;
Window GraphicArea;
int Col;
{
	RASimage image;
	FILE *out_file;
	int i, ncolors;
	int BuffCount;
	Colormap cmap;
	int ArrayIndex;
	XColor colors[MAX_CELLS];
	unsigned char *newBuffer;
	XImage *ximage;
	struct rasterfile SunRaster;
	unsigned char *SingleLine;
	int ScreenDepth;
	int LineLength;

	/* Open Output File */
	/* At later date this will be made from file selector */
	BusyCursor();
	out_file = fopen(fname, "w");
	/* Grap window to Pixmap */
	ximage = XGetImage(theDisplay, GraphicArea, x, y,(unsigned int) width,(unsigned int) height, AllPlanes, format);
	image.ximage = ximage;

	cmap = DefaultColormap(theDisplay, theScreen);
	ncolors = DisplayCells(theDisplay, theScreen);
	for (i = 0; i < ncolors; i++) {
		colors[i].pixel = i;
	}
	BusyCursor();
	XQueryColors(theDisplay, cmap, colors, ncolors);
	for (i = 0; i < ncolors; i++) {
		image.red[i] = colors[i].red;
		image.green[i] = colors[i].green;
		image.blue[i] = colors[i].blue;
	}

	BusyCursor();
	/* Trasnfer Pixmap to PPM file */
	newBuffer = (unsigned char *) malloc(width * height * 3 * sizeof(unsigned char));
	assert(newBuffer);
	BuffCount = 0;
	for (i = 0; i < width * height; i++) {
		ArrayIndex = image.ximage->data[i];
		newBuffer[BuffCount++] = (unsigned char) ArrayIndex;
	}
	BusyCursor();

	LineLength = width;
	SingleLine = (unsigned char *) malloc(LineLength);
	assert(SingleLine);
	ScreenDepth = 8;
	SunRaster.ras_magic = RAS_MAGIC;
	SunRaster.ras_width = width;
	SunRaster.ras_height = height;
	SunRaster.ras_depth = ScreenDepth;
	SunRaster.ras_length = LineLength * height;
	SunRaster.ras_type = RT_STANDARD;
	SunRaster.ras_maptype = RMT_EQUAL_RGB;
	SunRaster.ras_maplength = 3 * ncolors;

	write_sun_long(SunRaster.ras_magic, out_file);
	write_sun_long(SunRaster.ras_width, out_file);
	write_sun_long(SunRaster.ras_height, out_file);
	write_sun_long(SunRaster.ras_depth, out_file);
	write_sun_long(SunRaster.ras_length, out_file);
	write_sun_long(SunRaster.ras_type, out_file);
	write_sun_long(SunRaster.ras_maptype, out_file);
	write_sun_long(SunRaster.ras_maplength, out_file);

	/* write the colormap */
	fwrite(image.red, sizeof(unsigned char), ncolors, out_file);
	fwrite(image.green, sizeof(unsigned char), ncolors, out_file);
	fwrite(image.blue, sizeof(unsigned char), ncolors, out_file);

	/* write the image */
	BusyCursor();
	SingleLine[LineLength - 1] = 0;
	for (y = 0; y < height; y++) {
		memcpy(SingleLine, newBuffer + y * width, width);

		if (fwrite(SingleLine, sizeof(unsigned char),
				LineLength, out_file) != LineLength) {
			free(SingleLine);

		}
	}
	fclose(out_file);
	return ;
}

/*
 * XV2.21 Derived from Output Handling Routines Author:    John Bradley,
 * University of Pennsylvania (bradley@cis.upenn.edu)
 */

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

/*******************************
 Code Taken From XV_2.21
********************************/
void
write_sun_long(l, fp)
long l;
FILE *fp;
{
	char c;

	c = ((l >> 24) & 0xff);
	if (putc(c, fp) == EOF)
		return ;
	c = ((l >> 16) & 0xff);
	if (putc(c, fp) == EOF)
		return ;
	c = ((l >> 8) & 0xff);
	if (putc(c, fp) == EOF)
		return ;
	c = (l & 0xff);
	if (putc(c, fp) == EOF)
		return ;
	return ;
}

/*******************************
 CODE FROM XV_2.21
********************************/
/*
 * XV2.21 Derived from Output Handling Routines Author:    John Bradley,
 * University of Pennsylvania (bradley@cis.upenn.edu)
 */

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
OutputGIF(fname, x, y, width, height, GraphicArea)
char *fname;
int x;
int y;
int width;
int height;
Window GraphicArea;
{
	imageInfo image;
	FILE *out_file;
	unsigned char *Red, *Blue, *Green;
	int i, ncolors;
	Colormap cmap;
	XColor colors[MAX_CELLS];
	XImage *ximage;

	/* Open Output File */
	/* At later date this will be made from file selector */
	BusyCursor();
	out_file = fopen(fname, "w");
	/* Grap window to Pixmap */
	ximage = XGetImage(theDisplay, GraphicArea, x, y,(unsigned int) width,(unsigned int) height, AllPlanes, format);
	image.ximage = ximage;

	cmap = DefaultColormap(theDisplay, theScreen);
	ncolors = DisplayCells(theDisplay, theScreen);

	Red = (unsigned char *) malloc(ncolors * sizeof(unsigned char));
	assert(Red);
	Green = (unsigned char *) malloc(ncolors * sizeof(unsigned char));
	assert(Green);
	Blue = (unsigned char *) malloc(ncolors * sizeof(unsigned char));
	assert(Blue);
	for (i = 0; i < ncolors; i++)
		colors[i].pixel = i;
	BusyCursor();
	XQueryColors(theDisplay, cmap, colors, ncolors);
	for (i = 0; i < ncolors; i++) {
		image.red[i] = colors[i].red;
		image.green[i] = colors[i].green;
		image.blue[i] = colors[i].blue;
		Red[i] = (unsigned char) image.red[i];
		Green[i] = (unsigned char) image.green[i];
		Blue[i] = (unsigned char) image.blue[i];
	}
	BusyCursor();

	WriteGIF(out_file, image.ximage->data, width, height, Red, Green, Blue, ncolors, 0);
	BusyCursor();
	fclose(out_file);
	return ;
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/******************************/
void
putword(w, fp)
int w;
FILE *fp;
{
	/* writes a 16-bit integer in GIF order (LSB first) */
	fputc(w & 0xff, fp);
	fputc((w >> 8) & 0xff, fp);
}


/***********************************************************************/


static unsigned long cur_accum = 0;
static int cur_bits = 0;



#ifndef min
#define min(a,b)        ((a>b) ? b : a)
#endif

#define XV_BITS	12		/* BITS was already defined on some systems */
#define MSDOS	1

#define HSIZE  5003		/* 80% occupancy */

typedef unsigned char char_type;


static int n_bits;		/* number of bits/code */
static int maxbits = XV_BITS;	/* user settable max # bits/code */
static int maxcode;		/* maximum code, given n_bits */
static int maxmaxcode = 1 << XV_BITS;	/* NEVER generate this */

#define MAXCODE(n_bits)     ( (1 << (n_bits)) - 1)

static count_int htab[HSIZE];
static unsigned short codetab[HSIZE];

#define HashTabOf(i)   htab[i]
#define CodeTabOf(i)   codetab[i]

static int hsize = HSIZE;	/* for dynamic table sizing */

/*
 * To save much memory, we overlay the table used by compress() with those
 * used by decompress().  The tab_prefix table is the same size and type as
 * the codetab.  The tab_suffix table needs 2**BITS characters.  We get this
 * from the beginning of htab.  The output stack uses the rest of htab, and
 * contains characters.  There is plenty of room for any possible stack
 * (stack used to be 8000 characters).
 */

#define tab_prefixof(i) CodeTabOf(i)
#define tab_suffixof(i)        ((char_type *)(htab))[i]
#define de_stack               ((char_type *)&tab_suffixof(1<<XV_BITS))

static int free_ent = 0;	/* first unused entry */

/*
 * block compression parameters -- after all codes are used up, and
 * compression rate changes, start over.
 */
static int clear_flg = 0;

static long int in_count = 1;	/* length of input */
static long int out_count = 0;	/* # of codes output (for debugging) */

/*
 * compress stdin to stdout
 *
 * Algorithm:  use open addressing double hashing (no chaining) on the prefix
 * code / next character combination.  We do a variant of Knuth's algorithm D
 * (vol. 3, sec. 6.4) along with G. Knott's relatively-prime secondary probe.
 * Here, the modular division first probe is gives way to a faster
 * exclusive-or manipulation.  Also do block compression with an adaptive
 * reset, whereby the code table is cleared when the compression ratio
 * decreases, but after the table fills.  The variable-length output codes
 * are re-sized at this point, and a special CLEAR code is generated for the
 * decompressor.  Late addition:  construct the table according to file size
 * for noticeable speed improvement on small files.  Please direct questions
 * about this implementation to ames!jaw.
 */

static int g_init_bits;
static FILE *g_outfile;

static int ClearCode;
static int EOFCode;


/********************************************************/
void
compress(init_bits, outfile, data, len)
int init_bits;
FILE *outfile;
byte *data;
int len;
{
	register long fcode;
	register int i = 0;
	register int c;
	register int ent;
	register int disp;
	register int hsize_reg;
	register int hshift;

	/* Set up the globals:  g_init_bits - initial number of bits g_outfile
	   - pointer to output file */
	g_init_bits = init_bits;
	g_outfile = outfile;

	/* initialize 'compress' globals */
	maxbits = XV_BITS;
	maxmaxcode = 1 << XV_BITS;
	memset((char *) htab, 0, sizeof(htab));
	memset((char *) codetab, 0, sizeof(codetab));
	hsize = HSIZE;
	free_ent = 0;
	clear_flg = 0;
	in_count = 1;
	out_count = 0;
	cur_accum = 0;
	cur_bits = 0;


	/* Set up the necessary values */
	out_count = 0;
	clear_flg = 0;
	in_count = 1;
	maxcode = MAXCODE(n_bits = g_init_bits);

	ClearCode = (1 << (init_bits - 1));
	EOFCode = ClearCode + 1;
	free_ent = ClearCode + 2;

	char_init();
	ent = pc2nc[*data++];
	len--;

	hshift = 0;
	for (fcode = (long) hsize; fcode < 65536L; fcode *= 2L)
		hshift++;
	hshift = 8 - hshift;	/* set hash code range bound */

	hsize_reg = hsize;
	cl_hash((count_int) hsize_reg);	/* clear hash table */

	output(ClearCode);

	while (len) {
		c = pc2nc[*data++];
		len--;
		in_count++;

		fcode = (long) (((long) c << maxbits) + ent);
		i = (((int) c << hshift) ^ ent);	/* xor hashing */

		if (HashTabOf(i) == fcode) {
			ent = CodeTabOf(i);
			continue;
		} else if ((long) HashTabOf(i) < 0)	/* empty slot */
			goto nomatch;

		disp = hsize_reg - i;	/* secondary hash (after G. Knott) */
		if (i == 0)
			disp = 1;

probe:
		if ((i -= disp) < 0)
			i += hsize_reg;

		if (HashTabOf(i) == fcode) {
			ent = CodeTabOf(i);
			continue;
		}
		if ((long) HashTabOf(i) > 0)
			goto probe;

nomatch:
		output(ent);
		out_count++;
		ent = c;

		if (free_ent < maxmaxcode) {
			CodeTabOf(i) = free_ent++;	/* code -> hashtable */
			HashTabOf(i) = fcode;
		} else
			cl_block();
	}

	/* Put out the final code */
	output(ent);
	out_count++;
	output(EOFCode);
}


/*****************************************************************
 * TAG( output )
 *
 * Output the given code.
 * Inputs:
 *      code:   A n_bits-bit integer.  If == -1, then EOF.  This assumes
 *              that n_bits =< (long)wordsize - 1.
 * Outputs:
 *      Outputs code to the file.
 * Assumptions:
 *      Chars are 8 bits long.
 * Algorithm:
 *      Maintain a BITS character long buffer (so that 8 codes will
 * fit in it exactly).  Use the VAX insv instruction to insert each
 * code in turn.  When the buffer fills up empty it and start over.
 */

static
unsigned long masks[] = {0x0000, 0x0001, 0x0003, 0x0007, 0x000F,
	0x001F, 0x003F, 0x007F, 0x00FF,
	0x01FF, 0x03FF, 0x07FF, 0x0FFF,
0x1FFF, 0x3FFF, 0x7FFF, 0xFFFF};

void
output(code)
int code;
{
	cur_accum &= masks[cur_bits];

	if (cur_bits > 0)
		cur_accum |= ((long) code << cur_bits);
	else
		cur_accum = code;

	cur_bits += n_bits;

	while (cur_bits >= 8) {
		char_out((unsigned int) (cur_accum & 0xff));
		cur_accum >>= 8;
		cur_bits -= 8;
	}

	/* If the next entry is going to be too big for the code size, then
	   increase it, if possible. */

	if (free_ent > maxcode || clear_flg) {

		if (clear_flg) {
			maxcode = MAXCODE(n_bits = g_init_bits);
			clear_flg = 0;
		} else {
			n_bits++;
			if (n_bits == maxbits)
				maxcode = maxmaxcode;
			else
				maxcode = MAXCODE(n_bits);
		}
	}
	if (code == EOFCode) {
		/* At EOF, write the rest of the buffer */
		while (cur_bits > 0) {
			char_out((unsigned int) (cur_accum & 0xff));
			cur_accum >>= 8;
			cur_bits -= 8;
		}

		flush_char();

		fflush(g_outfile);

		if (ferror(g_outfile)) {
			fprintf(stderr, "unable to write GIF file\n");
		}
	}
}


/********************************/
void
cl_block()
{				/* table clear for block compress */
	/* Clear out the hash table */

	cl_hash((count_int) hsize);
	free_ent = ClearCode + 2;
	clear_flg = 1;

	output(ClearCode);
}


/********************************/
void
cl_hash(hsize)			/* reset code table */
register count_int hsize;
{
	register count_int *htab_p = htab + hsize;
	register long i;
	register long m1 = -1;

	i = hsize - 16;
	do {			/* might use Sys V memset(3) here */
		*(htab_p - 16) = m1;
		*(htab_p - 15) = m1;
		*(htab_p - 14) = m1;
		*(htab_p - 13) = m1;
		*(htab_p - 12) = m1;
		*(htab_p - 11) = m1;
		*(htab_p - 10) = m1;
		*(htab_p - 9) = m1;
		*(htab_p - 8) = m1;
		*(htab_p - 7) = m1;
		*(htab_p - 6) = m1;
		*(htab_p - 5) = m1;
		*(htab_p - 4) = m1;
		*(htab_p - 3) = m1;
		*(htab_p - 2) = m1;
		*(htab_p - 1) = m1;
		htab_p -= 16;
	} while ((i -= 16) >= 0);

	for (i += 16; i > 0; i--)
		*--htab_p = m1;
}


/******************************************************************************
 *
 * GIF Specific routines
 *
 ******************************************************************************/

/*
 * Number of characters so far in this 'packet'
 */
static int a_count;

/*
 * Set up the 'byte output' routine
 */
void
char_init()
{
	a_count = 0;
}

/*
 * Define the storage for the packet accumulator
 */
static char accum[256];

/*
 * Add a character to the end of the current packet, and if it is 254
 * characters, flush the packet to disk.
 */
void
char_out(c)
int c;
{
	accum[a_count++] = c;
	if (a_count >= 254)
		flush_char();
}

/*
 * Flush the packet to disk, and reset the accumulator
 */
void
flush_char()
{
	if (a_count > 0) {
		fputc(a_count, g_outfile);
		fwrite(accum, 1, a_count, g_outfile);
		a_count = 0;
	}
}


/*************************************************************/
void
WriteGIF(fp, pic, w, h, rmap, gmap, bmap, numcols, colorstyle)
FILE *fp;
byte *pic;
int w, h;
byte *rmap, *gmap, *bmap;
int numcols, colorstyle;
{
	int RWidth, RHeight;
	int LeftOfs, TopOfs;
	int Height, Width;
	int Interlace;
	int ColorMapSize, InitCodeSize, Background, BitsPerPixel;
	int i, j, nc;


	Interlace = 0;
	Background = 0;


	for (i = 0; i < 256; i++) {
		pc2nc[i] = r1[i] = g1[i] = b1[i] = 0;
	}

	/* compute number of unique colors */
	nc = 0;

	for (i = 0; i < numcols; i++) {
		/* see if color #i is already used */
		for (j = 0; j < i; j++) {
			if (rmap[i] == rmap[j] && gmap[i] == gmap[j] &&
				bmap[i] == bmap[j])
				break;
		}

		if (j == i) {	/* wasn't found */
			pc2nc[i] = nc;
			r1[nc] = rmap[i];
			g1[nc] = gmap[i];
			b1[nc] = bmap[i];
			nc++;
		} else
			pc2nc[i] = pc2nc[j];
	}


	/* figure out 'BitsPerPixel' */
	for (i = 1; i < 8; i++)
		if ((1 << i) >= nc)
			break;

	BitsPerPixel = i;

	ColorMapSize = 1 << BitsPerPixel;

	RWidth = Width = w;
	RHeight = Height = h;
	LeftOfs = TopOfs = 0;


	if (BitsPerPixel <= 1)
		InitCodeSize = 2;
	else
		InitCodeSize = BitsPerPixel;


	if (!fp) {
		fprintf(stderr, "WriteGIF: file not open for writing\n");
		return ;
	}
	fwrite("GIF87a", 1, 6, fp);	/* the GIF magic number */

	putword(RWidth, fp);	/* screen descriptor */
	putword(RHeight, fp);

	i = 0x80;		/* Yes, there is a color map */
	i |= (8 - 1) << 4;	/* OR in the color resolution (hardwired 8) */
	i |= (BitsPerPixel - 1);/* OR in the # of bits per pixel */
	fputc(i, fp);

	fputc(Background, fp);	/* background color */

	fputc(0, fp);		/* future expansion byte */


	if (colorstyle == 1) {	/* greyscale */
		for (i = 0; i < ColorMapSize; i++) {
			j = MONO(r1[i], g1[i], b1[i]);
			fputc(j, fp);
			fputc(j, fp);
			fputc(j, fp);
		}
	} else {
		for (i = 0; i < ColorMapSize; i++) {	/* write out Global
							   colormap */
			fputc(r1[i], fp);
			fputc(g1[i], fp);
			fputc(b1[i], fp);
		}
	}

	fputc(',', fp);		/* image separator */

	/* Write the Image header */
	putword(LeftOfs, fp);
	putword(TopOfs, fp);
	putword(Width, fp);
	putword(Height, fp);
	if (Interlace)
		fputc(0x40, fp);/* Use Global Colormap, maybe Interlace */
	else
		fputc(0x00, fp);

	fputc(InitCodeSize, fp);
	compress(InitCodeSize + 1, fp, pic, w * h);

	fputc(0, fp);		/* Write out a Zero-length packet (EOF) */
	fputc(';', fp);		/* Write GIF file terminator */

	return ;
}

/*
 * XV2.21 Compression Handling Routines Author:
 * John Bradley,
 * University of Pennsylvania (bradley@cis.upenn.edu)
 */

#ifdef NOSTRCHR
char *
strchr(s1, c)
char *s1;
int c;
{
	char *p;

	p = s1;
	while (*p)
		if (*(p++) == c)
			return p - 1;

	return NULL;
}

#endif

int DetermineFillType(fill,num,PtType,FillStyle,BaseType)
int fill,num,PtType,FillStyle,BaseType;
{
        if (fill == 1 && num <= 2)
                fill = NOTFILLED;
        if (num == 1 && PtType == MENU_POINT)
                fill = DOT;
        if (num == 1 && PtType == MENU_PLUS)
                fill = PLUS;
        if (num == 1 && PtType == MENU_BOX)
                fill = BOX;
        if (num == 1 && PtType == MENU_TRI)
                fill = TRI;
        if (num == 1 && PtType == MENU_CROSS)
                fill = CROSS;
        if (num == 1 && PtType == MENU_CIRCLE)
                fill = PTCIRCLE;
        if (num == 1 && PtType == MENU_FILLEDBOX)
                fill = FILLEDBOX;
        if (num == 1 && PtType == MENU_FILLEDTRI)
                fill = FILLEDTRI;
        if (num == 1 && PtType == MENU_FILLEDCIRCLE)
                fill = FILLEDCIRCLE;
        if (num > 2)
                fill = FillStyle;
        if (num == 2 && FillStyle == FILLEDOPAQUE)
                fill = FillStyle;
        if (num == 2 && FillStyle == COLOUREDOPAQUE)
                fill = FillStyle;
/*        if (num == 2 && FillStyle == FILLEDCOLOR)*/
/*                fill = BLACKLINES;*/
        if (num == 2 && FillStyle == FILLEDCOLOR)
                fill = COLOUREDLINES;
        if (num == 2 && FillStyle == FILLEDHIDDENLINE)
                fill = FillStyle;
        if (num ==1 && BaseType == TEXTLABEL)
                fill = TEXTLABEL;

        return fill;
}

