/*
 * Copyright (C) 1992, 1993, Paul D. Hoad This file is part of the Xmgf
 * Software. For conditions of distribution and use, see the accompanying
 * README file.
 *
 * Vision Speech and Signal Processing Group . Dept. of Electronic Engineering.
 * University of Surrey. Guildford, Surrey. England. Phone: +44 483 300800
 * Ext 2753 Email: P.Hoad@ee.surrey.ac.uk
 */
#include "XmgfStruct.h"
#include "XmgfDefines.h"
#include "Read3DSet.h"
#include "InitX.h"
#include "GetColNum.h"

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* PointNames */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
char *thePointNames[maxPointTypes] =
{
	"Dot", "Box", "Triangle", "Plus", "Cross",
	"Circle", "FilledBox", "FilledTriangle", "FilledCircle"
};

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* LineStyle */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
char *theLineStyle[maxLineStyles] = 
{
	"Solid","Dotted","Dashed"
};

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* FillStyle */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
char *theFillStyle[maxFillStyles] = 
{
	"BlackLines","WhiteLines","ColouredLines","ShadedLines","HiddenLine",
	"OpaqueFill","ColouredOpaqueFill","ColouredFill","ShadedFill","Points"
};

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* GetColourNumber - Get the colour number from Col string */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
int
GetColourNumber(Col)
char *Col;
{
	int i;
	int colnu;

	i = 0;
	while ((strcasecmp(Col, theColorNames[i]) != 0) && (i < 84)) {
		i++;
	}
	if (i < 84)
		return (i + 64);
	if (sscanf(Col, "%d", &colnu) != 0) {
		if ((colnu) < maxcolorpixels)
			return (colnu);
	} else {		/* default Colour */
		return (0);
	}
	return (0);
}
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* GetPointNumber - Get the point number from PointType string */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
int
GetPointNumber(PointType)
char *PointType;
{
	int i;
	int Pntnu;
	int NoPTypes = 8;

	i = 0;
	while ((strcasecmp(PointType, thePointNames[i]) != 0) && (i < NoPTypes)) {
		i++;
	}
	if (i <= NoPTypes && i > -1) {
		return (i);
	}
	if (sscanf(PointType, "%d", &Pntnu) != 0)
		return (Pntnu);
	else
		return (0);	/* default Pointtype */
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* GetLineStyle - Get the Linestyle number from LineType string */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
int
GetLineStyle(LineType)
char *LineType;
{
	int i;
	int Linnu;
	int NoLTypes = 2;

	i = 0;
	while ((strcasecmp(LineType, theLineStyle[i]) != 0) && (i < NoLTypes)) {
		i++;
	}
	if (i < NoLTypes && i > -1) {
		return (i);
	}
	if (sscanf(LineType, "%d", &Linnu) != 0)
		return (Linnu);
	else
		return (0);	/* default Linetype */
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* GetFillStyle - Get the FillStyle number from FillType string */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
int
GetFillStyle(FillType)
char *FillType;
{
	int i;
	int Fllnu;
	int retval;
	int NoFTypes = 9;

	i = 0;
	while ((strcasecmp(FillType, theFillStyle[i]) != 0) && (i < NoFTypes)) {
		i++;
	}
	if (i < NoFTypes && i > -1) {
		retval = i;
	}
	else if (sscanf(FillType, "%d", &Fllnu) != 0)
		retval = Fllnu;
	else
		retval = 0 ;	/* default Flletype */

	switch(retval){
		case 0: return BLACKLINES;break;
		case 1: return WHITELINES;break;
		case 2: return COLOUREDLINES;break;
		case 3: return SHADED_LINES;break;
		case 4: return FILLEDHIDDENLINE;break;
		case 5: return FILLEDOPAQUE;break;
		case 6: return COLOUREDOPAQUE;break;
		case 7: return FILLEDCOLOR;break;
		case 8: return SHADED_FILL;break;
		case 9: return POINTS_ONLY;break;
		default: return 0;break;
	}
	return 0;
}

