last modification: Wed Nov 11 10:13:35 GMT 1992
author:            George Matas


The .gf file format
___________________

1. INTRODUCTION
The .gf format was defined with the purpose of creating a standard for
representation of the following types of data:

  1. geometric features (GFs) - lines, points, polygons, arcs, circles, etc.
  2. attributed n-tuples (relations) of geometric features 

Data discribing geometric features can be mixed with real numbers,
text, pointers to other features etc.


Why users should consider using a standard file format: 

  1. A sophisticated program Xgf for the visualisation of .gf data is
    available
  2. Programs that read in/ write out geometric data (edge detectors, line
	finders etc.) can be written in a more general way, not
        expecting a single fixed format
  3. A library is available for .gf file input/output 


2. FORMAT SPECIFICATION
A .gf file is a plain ASCII file.
Data in the .gf file are grouped in SETs. A SET consists of a number
of entities of the same format. Let us give a simple example of a .gf
file containing 2 sets:

;------- start of ex.gf -------------
@SET Lines
format number line
1 7 1 100 100
2 10 20 100 110
@
@SET Points
format point
3 4
6 7
@
;------- end of ex.gf ---------------

Let us ignore for the moment the precise format of the .gf file (the
@SET keyword etc.). The ex.gf file contains two SETs. The  name (or ID)
of the first set is Lines. The format line defines the structure of
entities in the set. In the case of the Lines set, an entity consists
of a number followed by a line definition.  By default (may be
overriden), a line is represented by coordinates of its endpoints.  The
second set defines 2 points.

2. SET DEFINITION

@SET set_name
GeomStruct user_definition_of_a_geometric_feature   (optional)
format format_definiton
entitity1
entitity2
.
.
.
@

Lines starting with @SET and @ respectively delimit the SET. The set name is 
used for referencing the set (see section on IDtype format item). The
interpretation of data in the set is defined by the format string.

2.1 THE FORMAT STRING
The format string (and hence the entities in the set)
may contain items of following type: 
- geometric structure (feature) 
- reference to a SET
- repetition count 
- text  (a sequence of characters delimited be a space)
- attribute (a real number)


2.1.0 Geometric structure (feature)
  The .gf recognizes the following predefined geometric features:

LINE     STARTX STARTY ENDX ENDY
DASHLINE STARTX STARTY ENDX ENDY
DOTLINE  STARTX STARTY ENDX ENDY
OrLINE   STARTX STARTY ENDX ENDY
ARC      CENTERX CENTERY STARTX STARTY ENDX ENDY
OrARC    CENTERX CENTERY STARTX STARTY ENDX ENDY DIR
CIRCLE   CENTERX CENTERY STARTX STARTY
ELLIPSE  CENTERX CENTERY MAJOR MINOR ANGLE
POINT         X Y
POINTBOX      X Y
POINTSTAR     X Y
POINTCROSS    X Y
POINTDOT      X Y
POINTSET      REP  X Y
POLYLINE      REP  X Y
POLYDASHLINE  REP X Y
POLYDOTLINE   REP X Y
FILLEDPOLY    REP X Y

Names of geometric structures and their parameters should be
self-explanatory.  All structures in the LINE group require 4
parameters, namely the x,y coordinates of the start and endpoint). A
LINE is drawn in Xgf as a solid line. A DOTLINE (a slight misnomer)
will be drawn as alternating short segments of the set and background
(black) colour.  The DASHLINE is similar, but between the coloured
segments the original pixel values are preserved (DASHLINE looks
trasnparent).  The OrLINE (!not implemented yet) is intended to be
displayed as a line oriented by an arrow.  The same is true for OrARC.

Geometric structures ARC,
CIRCLE and ELLIPSE (and their parameters) are self-explanatory.

POINT is displayed as a 5x5 pixel '+', POINTCROSS as a 7x7 '+',
POINTSTAR as a 3x3 'x', POINTDOT as a 1 pixel dot, POINTBOX as a 5x5
empty box. Parameters X Y are the point coordinates.

POINTSET contains a set of points. REP (repeat) defines the number of
points in the set. Each point is displayed as a dot. POLYLINE format
is identical but lines are drawn between points. To draw a closed
polygon, repeat the first point at the end. The variants POLYDASHLINE
and POLYDOTLINE are displayed in the style of DASHLINE resp DOTLINE.

The FILLEDPOLY structure will be drawn as a filled polygon. The
polygon doesn't have to be closed (ie. the last and first point/vertex
need not be the same); it the polygon is open the last vertex will be
appended automatically.



2.1.1 Customization of  geometric structure definition
Definition of a geometric structure consists of the structure name
and parameter
names. Parameters names  are used by the display program to extract
information necessary for display. In the
following set
;---- set StdLines -----------------------
@SET StdLines
format line
10 20 1 2
@
;----------------------------------------
the display program understands that the numbers 10 20 1 2 represent endpoints
of a line . The default definition of a geometric feature can be
overriden using GeomStruct keyword.

So, for instance, SET MyLines can define:
;--- set MyLines ------------------------
@SET MyLines
GeomStruct line startx endx starty endy
format line
10 1 20 2
@
;----------------------------------------
will be displayed exactly as the StdLines SET, because the Xgf display
program is able to establish the correspondence of  parameter names
(ie. detect that starty and endx were swapped).
Additional fields may be added in the geometric structure definition,
but the standard parameters must be present. If this rule is violated,
the geometric structure will not be displayed. This gives an example of
a valid line definition:
;---- set ComplexLine  ------------------------
@SET ComplexLine
GeomStruct line rho theta  startx endx starty endy quality
format line
17.4 0.94 10 1 20 2 0.9087
@

The POINTSET and POLYLINE definitions contain the REP keyword. A geometric
structure containing the REP keyword consist of a variable number of
elementary geom. structures, as in the following set.
;----RepExample1------------------------------------
@SET CannyStrings
format PointSet
3 1 2 1 3 1 4
7 2 5 2 6 2 7 3 7 2 8 2 8 2 9
@
;-----------------------------------------
The default PointSet definition is 'REP x y'. In the data, a count is
expected at the position of the REP keyword in the definition string.
The first line of RepExample1 (3 1 2 1 3 1 4) represents 3 points (1 2
1 3 1 4). Every point is defined by x y.  The user can define his own
types with the REP keyword as in RepExample2.
;-----RepExample2-------------------------
@SET CannyStringWithDirections
GeomStruct PoinSet REP x y dir
format PointSet
2 1 2 17.1 3 4 56.1
@
;-----end of example ---------------------
In fact, the 'canny' program outputs one of these 2 sets.



2.1.2 The REP
   To REP (repetition) was introduced to provide for a variable entity
format. It's semantics are exactly the same as inside the geometric
structure definition (sec 2.1.1). If, for instance, a collinear line
grouping is defined as an n-tuple of lines (where n varies), then  the
format defined bellow  may be used.
/-----RepExample----------------
@Set CollinearLines
format Rep Line
3 1 1 10 10 10 10 20 20 20 21 30 31
2 7 30 20 30 21 30 65 30
@
;------end of example----------


2.1.3 Reference to a SET
   This type of item was introduced to capture dependencies between
sets. If an entity is computed from data of a different set, it may be
helpful for visualisation to view both the data and it's origin at
once. In the following example
;----- IdExample --------------
@Set Lines
format line
1 1 10 10
20 20 10 10
10 20 10 10
@
@Set Junctions
format Rep IdLines point
2 1 2  10 10
3 1 2 3 13 10
@
;----- end of ex. ----
junctions is a point that has been computed from a variable number of
lines. Any token in the format string beginning with Id (case
insensitive) is consider to define a reference field. The name of the
set is the other part of the token (Lines in IdExample). Entities are
expected to contain integers that denote order in reference set. In
IdExample, the line 2 1 2 10 10 should be read as follows: This
junction is an intersection of two lines, no. 1 2. Their intersection
point is 10 10.
  A special token IdVar can be used when the origin is heterogenious.
In this case, the name of the referenced set is from the data, eg.
;---IdVarExample----------
@Set RosenWestList
format Rep IdVar
4 Line1 Line2 Arc1 Arc2
3 Line7 Arc5 Line10
@
;----end of ex. ------------

2.1.4 Text
  The Text keyword in the format string indicates a character string
the data .

2.1.5 Attributes
  Any keyword  not identified as a geometric structure, repetition,
reference or text is interpreted as a numerical attribute.


3. General Notes

3.1 
  All examples presented in the document can be visualized using Xgf.
This file can be read in by the Xgf file as is - the text between sets
is ignored.

3.2 The preprocessor
  All lines with ';' in the first column are ignored. Comments can be
inserted in the set data.
  Long lines can be broken using '\' as the last character before the
break.

3.3
  The whole system is case insensitive, e.g. "@Set" "@set" "@SET" are
identical.


  


