#ifndef  PGLLSTAND
#define PGLLSTAND  1
#include <stdio.h>
#include <stdlib.h>
#include <LL.h>

struct s_LLSet{
          char * id;
          char * format;
          t_LL GeomStruct;
	  t_LL Attributes;  /* Added by P.Hoad 13/6/93 for Xmgf*/
          t_LL data;
         };
typedef struct s_LLSet *t_LLSet;


/*---- Read/Write sets from a .gf file   ----------------------------------*/
#ifndef _NO_PROTO
t_LL  ReadLLSets(char *filename);           /* Read/Write a LL list of sets */
int   WriteLLSets(char *filename, t_LL AllSets);


t_LLSet ConsLLSet(char * SetName, t_LL GeomStruct, char * format);
void DestLLSet(t_LLSet Set);


int  GetLLSetNum(t_LL Sets, char *id) ;     /* Get a partic. set        */
t_LLSet GetPrefLLSet(t_LL Sets, char *id);
t_LLSet GetLLSet(t_LL Sets, char *id);
#else
t_LL  ReadLLSets();           /* Read/Write a LL list of sets */
int   WriteLLSets();
t_LLSet ConsLLSet();
void DestLLSet();
int  GetLLSetNum();
t_LLSet GetPrefLL();
t_LLSet GetLLSet();
#endif




/* error handling routines */
extern int  ErrStatus;
#define MyErr(A) {ErrStatus=1;printf("%s \n",(A)); return -1;}
#define MyPtrErr(A) {ErrStatus=1;printf("%s \n",(A)); return NULL;}
#define MAX_LINE_LENGHT 300000

/* predefinde strings */
/* strings defining beginning end end of a Set */
#define SET_STA_TOKEN "@Set"
#define SET_END_TOKEN "@"


/* strings used in Set header */
#define GEOM_TOKEN   "GeomStruct"      /* used in format string as well */
#define ATTR_TOKEN   "Attributes"      
#define SATTR_TOKEN   "Attribute"      
#define FORMAT_TOKEN "Format"

/* strings used in format string */
#define REP_TOKEN    "Rep"
#define ID_TOKEN      "ID"
#define ATT_TOKEN     "Att"
#define TEXT_TOKEN    "Text"
#define VAR_TOKEN     "Var"


/*--- ANCI C definitions used to stop gcc spitt warnings ---*/
/*-- ANSI header found --*/
#endif
