/*
 * Copyright (C) 1992, 1993, Paul D. Hoad 
 * This file is part of the Xmgf Software.
 * For conditions of distribution and use, see the accompanying README file.
 *
 *  Vision Speech and Signal Processing Group .
 *  Dept. of Electronic Engineering.
 *  University of Surrey.
 *  Guildford,
 *  Surrey.
 *  England.
 *  Phone: +44 483 300800 Ext 2753
 *  Email: P.Hoad@ee.surrey.ac.uk
 */

typedef struct{
        double Theta;
        double Phi;
        double Gamma;
        double ScaleNumber;
        double Scale_factor;
        double DistSC;
        double Ox;
        double Oy;
        double Oz;
        double TimePos;
        double FramesPerSlice;
        } t_RotParm;




#ifndef _NO_PROTO 
void NewAnimation(void);
void KillAnimation(void);
void RecordFrame(void);
void InterPolateFrame(t_RotParm First, t_RotParm Last, double Steps);
void PlaySingleFrame(void);
void PlaySlice(int a);
void SaveAnimation(char *Filename);
void LoadAnimation(char *Filename);
void SetAnimationSpeed(int NewFramesPerSlice);
#else 
void NewAnimation();
void KillAnimation();
void RecordFrame();
void InterPolateFrame();
void PlaySingleFrame();
void PlaySlice();
void SaveAnimation();
void LoadAnimation();
void SetAnimationSpeed();
#endif 

extern int  FlagForward;
extern int  FlagRewind;
extern int  FlagStop;
extern int  FlagPause;
extern int  FlagPlay;
extern int  FlagReverse;




	
