#include <stdio.h>
#include "LL.h"

typedef struct {
  double          x;
  double          y;
  double          z;
}               t_Vertex;

typedef struct {
  t_LL            PolyVertices;
}               t_Polygon;

#define MAX_CHAR 100


int 
main (argc, argv)
  int             argc;
  char          **argv;
{
  t_Vertex        Point, *OutPoint;
  t_Polygon       Poly, *OutPoly;
  int             NuVertices, NuPolygon;
  t_LL            Vertices;
  t_LL            Polygons;
  int             i, VertexNum;
  char            str[50];
  char           *singleline;
  double          scale = 1.0;
  int             pos;
  FILE           *FpIn, *FpOut, *FpInfo;
  char            BaseName[60];
  char            InFile[60];
  char            Message[MAX_CHAR];
  char            Field[50];
  int             Import;

  fprintf (stderr, "off2gf Filter :- P.Hoad 6/7/93\n");

  if (argc < 2) {
    fprintf (stderr, "Usage: off2gf infile.[geom/aoff] outfile [1/scale]\n");
    exit (0);
  }

  if (argc == 4)
    scale = (double) atoi (argv[3]);

  sscanf (argv[1], "%[^.]", BaseName);
  strcpy (InFile, BaseName);
  strcat (InFile, ".aoff");
  Import = 0;
  if ((FpInfo = fopen (InFile, "r")) != NULL) {
    Import = 1;
    fprintf (stderr, "Importing %s\n", InFile);
  }

  strcpy (InFile, BaseName);
  strcat (InFile, ".geom");
  /* FpIn = fopen(InFile,"r"); */
  if ((FpIn = fopen (argv[1], "r")) == NULL) {
    fprintf (stderr, "File %s Does not exist\n", argv[1]);
    exit (-1);
  }
  fprintf (stderr, "Reading %s\n", InFile);

  if ((FpOut = fopen (argv[2], "w")) == NULL) {
    fprintf (stderr, "File %s Does not exist\n", argv[2]);
    exit (-1);
  }
  fprintf (stderr, "Writing as %s\n", argv[2]);
  if (Import) {
    while (fgets (Message, MAX_CHAR, FpInfo)) {
      sscanf (Message, "%s", Field);
      if (!strcasecmp (Field, "copyright") ||
	  !strcasecmp (Field, "description") ||
	  !strcasecmp (Field, "name"))
	fprintf (FpOut, "; %s", Message);
    }
  }

  fscanf (FpIn, "%d%d%*d\n", &NuVertices, &NuPolygon);
  /* fprintf(stderr,"Verticies =%d\nPolygons = %d\n",NuVertices,NuPolygon); */

  Polygons = ConsLL ();
  Vertices = ConsLL ();
  for (i = 0; i < NuVertices; i++) {
    fscanf (FpIn, "%lf%lf%lf\n", &Point.x, &Point.y, &Point.z);
#ifdef DEBUG
    fprintf (stderr, "Points %lf %lf %lf\n", (double) Point.x, (double) Point.y, (double) Point.z);
#endif
    Point.x = Point.x / scale;
    Point.y = Point.y / scale;
    Point.z = Point.z / scale;
    InsLastLL (Vertices, Point);
  }

  for (i = 0; i < NuPolygon; i++) {
    Poly.PolyVertices = ConsLL ();
    fgets (str, 50, FpIn);
    singleline = str;
    sscanf (singleline, "%d%n", &VertexNum, &pos);
    singleline += pos;
    while (sscanf (singleline, "%d%n", &VertexNum, &pos) != 0) {
      singleline += pos;

#ifdef DEBUG
      fprintf (stderr, "Polygons Number=%d\n", VertexNum);
#endif

      OutPoint = NthElmLL (Vertices, (long) VertexNum);

#ifdef DEBUG
      fprintf (stderr, "Points %lf %lf %lf\n", OutPoint->x, OutPoint->y, OutPoint->z);
#endif

      InsLastLL (Poly.PolyVertices, *OutPoint);
    }

#ifdef DEBUG
    fprintf (stderr, "PolygonSides %d\n", SizeLL (Poly.PolyVertices));
#endif

    InsLastLL (Polygons, Poly);
  }
  fprintf (FpOut, "@Set %s\nFormat Polygon3D\n", BaseName);
  ForeachLL_M (Polygons, OutPoly) {
    fprintf (FpOut, "%d ", SizeLL (Poly.PolyVertices));
    ForeachLL_M (OutPoly->PolyVertices, OutPoint) {
      fprintf (FpOut, "%f %f %f ", OutPoint->x, OutPoint->y, OutPoint->z);
    }
    fprintf (FpOut, "\n");
  }
  fprintf (FpOut, "@\n");
  exit (0);
}
