#!/bin/sh
#
# @(#)makerel.sh	2.13 94/02/14
#
# Make xmcd binary release
#
#    xmcd - Motif(tm) CD Audio Player
#
#    Copyright (C) 1994  Ti Kan
#    E-mail: ti@amb.org
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#

FILES="	README \
	xmcd \
	install.sh \
	configure.sh \
	demo.cddb \
	dev.config \
	XMcd.ad \
	xmcd.man \
	XKeysymDB \
	cfgtbl/Apple \
	cfgtbl/Chinon \
	cfgtbl/Compaq \
	cfgtbl/DEC \
	cfgtbl/Hitachi \
	cfgtbl/IBM \
	cfgtbl/NEC \
	cfgtbl/Pioneer \
	cfgtbl/Plextor \
	cfgtbl/Procom \
	cfgtbl/Sony \
	cfgtbl/Sun \
	cfgtbl/Toshiba \
	helpfiles/AbBtn \
	helpfiles/CheckBox \
	helpfiles/DbModeInd \
	helpfiles/DbProgBtn \
	helpfiles/DdCancelBtn \
	helpfiles/DdClrBtn \
	helpfiles/DdDiscTxt \
	helpfiles/DdOkBtn \
	helpfiles/DiscIdInd \
	helpfiles/DiscTitleInd \
	helpfiles/DpAboutBtn \
	helpfiles/DpAddPgmBtn \
	helpfiles/DpCancelBtn \
	helpfiles/DpClrPgmBtn \
	helpfiles/DpDExtBtn \
	helpfiles/DpDTitleTxt \
	helpfiles/DpLinkBtn \
	helpfiles/DpLoadBtn \
	helpfiles/DpPgmSeqTxt \
	helpfiles/DpPlayPgmBtn \
	helpfiles/DpSaveBtn \
	helpfiles/DpTExtBtn \
	helpfiles/DpTTitleTxt \
	helpfiles/DpTimeSelBtn \
	helpfiles/DpTrkList \
	helpfiles/DsCancelBtn \
	helpfiles/DsDirList \
	helpfiles/DsOkBtn \
	helpfiles/DtCancelBtn \
	helpfiles/DtClrBtn \
	helpfiles/DtOkBtn \
	helpfiles/DtTrackTxt \
	helpfiles/EjectBtn \
	helpfiles/FfBtn \
	helpfiles/HelpBtn \
	helpfiles/IndexInd \
	helpfiles/KeypadBtn \
	helpfiles/KeypadInd \
	helpfiles/KpCancelBtn \
	helpfiles/KpClearBtn \
	helpfiles/KpEnterBtn \
	helpfiles/KpNumBtn \
	helpfiles/LevelScale \
	helpfiles/LsCancelBtn \
	helpfiles/LsLinkList \
	helpfiles/LsOkBtn \
	helpfiles/NextIdxBtn \
	helpfiles/NextTrkBtn \
	helpfiles/PlayModeInd \
	helpfiles/PlayPauseBtn \
	helpfiles/PowerBtn \
	helpfiles/PrevIdxBtn \
	helpfiles/PrevTrkBtn \
	helpfiles/ProgModeInd \
	helpfiles/RewBtn \
	helpfiles/SampleBtn \
	helpfiles/StopBtn \
	helpfiles/TimeBtn \
	helpfiles/TimeInd \
	helpfiles/TimeModeInd \
	helpfiles/TrackInd \
	helpfiles/TrackTitleInd \
	wm2xmcd/wm2xmcd \
	wm2xmcd/wm2xmcd.man"


# Use Sysv echo if possible
if [ -x /usr/5bin/echo ]				# SunOS SysV echo
then
	ECHO=/usr/5bin/echo
elif [ -z "`(echo -e a) 2>/dev/null | fgrep e`" ]	# GNU bash, etc.
then
	ECHO="echo -e"
else							# generic SysV
	ECHO=echo
fi

# Strip the binary symbol table
strip xmcd

# Remove comment section of binary if possible
(mcs -da '@(#)xmcd v1.1 (C) Ti Kan 1994' xmcd) >/dev/null 2>&1

# Create tar archive
tar cf xmcd.tar $FILES

# Compress tar archive
compress xmcd.tar

$ECHO '
Instructions to unpack xmcd binary and other info
-------------------------------------------------

At the end of this message is a compressed and uuencoded tar
file containing the xmcd binary and supporting files.  To extract,
save this message in a file "xmcd.uue" and do the following while
logged in as root:

	uudecode xmcd.uue
	uncompress xmcd.tar.Z
	tar xvf xmcd.tar
	sh ./install.sh

Xmcd must run setuid root because the SCSI passthrough interface to
the OS kernel requires superuser privilege.  Xmcd is careful about
security and changes the uid back to the user before writing any files.

See the README file for a list of supported CD-ROM drives.

Take a look at the resources in LIBDIR/app-defaults/XMcd.  If
there are anything you wish to customize you can put them in your
.Xdefaults file.  The default CD database directory hierarchy is defined by
the XMcd.dbdir resource.  This hierarchy is created for you by the
installation script.  Alternatively, each user can redefine these in their
.Xdefaults and maintain their own CD database files.  Finally, the
XMCD_DBPATH environment variable or the -dbdir option can be used to
override this resource.

To use xmcd, simply type "xmcd" while logged into the system under
the X windows environment.  Make sure the DISPLAY environment variable
is set properly.  The default device is the one specified in the
XMcd.device resource.  To operate other drives, use the -dev command line
option.

A help button is available on the xmcd main window.  You can also get
feature-specific help on any button, control, slider, indicator, list
or text entry area by positioning the mouse cursor over the feature,
and clicking the mouse button number 3.

' >xmcdbin.uue

# Uuencode
uuencode xmcd.tar.Z xmcd.tar.Z >>xmcdbin.uue

rm -f xmcd.tar.Z
ls -l xmcdbin.uue
exit 0

