/*
 *   xmcd - Motif(tm) CD Audio Player
 *
 *   Copyright (C) 1994  Ti Kan
 *   E-mail: ti@amb.org
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __AC_RESRC_H__
#define __AC_RESRC_H__

#ifndef LINT
static char *_ac_resrc_h_ident_ = "@(#)ac_resrc.h	2.2 94/02/24";
#endif

#define XmcdNdevnum			"devnum"
#define XmcdCDevnum			"Devnum"
#define XmcdNdevice			"device"
#define XmcdCDevice			"Device"
#define XmcdNlibdir			"libdir"
#define XmcdCLibdir			"Libdir"
#define XmcdNdbdir			"dbdir"
#define XmcdCDbdir			"Dbdir"
#define XmcdNmaxDbdirs			"maxDbdirs"
#define XmcdCMaxDbdirs			"MaxDbdirs"
#define XmcdNdbFileMode			"dbFileMode"
#define XmcdCDbFileMode			"DbFileMode"

#define XmcdNcaddyLock			"caddyLock"
#define XmcdCCaddyLock			"CaddyLock"
#define XmcdNstatusPollInterval		"statusPollInterval"
#define XmcdCStatusPollInterval		"StatusPollInterval"
#define XmcdNinsertPollInterval		"insertPollInterval"
#define XmcdCInsertPollInterval		"InsertPollInterval"
#define XmcdNpreviousThreshold		"previousThreshold"
#define XmcdCPreviousThreshold		"PreviousThreshold"
#define XmcdNsearchSkipBlocks		"searchSkipBlocks"
#define XmcdCSearchSkipBlocks		"SearchSkipBlocks"
#define XmcdNsearchPauseInterval	"searchPauseInterval"
#define XmcdCSearchPauseInterval	"SearchPauseInterval"
#define XmcdNsearchSpeedUpCount		"searchSpeedUpCount"
#define XmcdCSearchSpeedUpCount		"SearchSpeedUpCount"
#define XmcdNsearchVolumePercent	"searchVolumePercent"
#define XmcdCSearchVolumePercent	"SearchVolumePercent"
#define XmcdNsearchMinVolume		"searchMinVolume"
#define XmcdCSearchMinVolume		"SearchMinVolume"
#define XmcdNsampleBlocks		"sampleBlocks"
#define XmcdCSampleBlocks		"SampleBlocks"
#define XmcdNminimumPlayBlocks		"minimumPlayBlocks"
#define XmcdCMinimumPlayBlocks		"MinimumPlayBlocks"
#define XmcdNdisplayBlinkOnInterval	"displayBlinkOnInterval"
#define XmcdCDisplayBlinkOnInterval	"DisplayBlinkOnInterval"
#define XmcdNdisplayBlinkOffInterval	"displayBlinkOffInterval"
#define XmcdCDisplayBlinkOffInterval	"DisplayBlinkOffInterval"
#define XmcdNdriveVendorCode		"driveVendorCode"
#define XmcdCDriveVendorCode		"DriveVendorCode"
#define XmcdNplayAudio10Support		"playAudio10Support"
#define XmcdCPlayAudio10Support		"PlayAudio10Support"
#define XmcdNplayAudio12Support		"playAudio12Support"
#define XmcdCPlayAudio12Support		"PlayAudio12Support"
#define XmcdNplayAudioMSFSupport	"playAudioMSFSupport"
#define XmcdCPlayAudioMSFSupport	"PlayAudioMSFSupport"
#define XmcdNplayAudioTISupport		"playAudioTISupport"
#define XmcdCPlayAudioTISupport		"PlayAudioTISupport"
#define XmcdNloadSupport		"loadSupport"
#define XmcdCLoadSupport		"LoadSupport"
#define XmcdNejectSupport		"ejectSupport"
#define XmcdCEjectSupport		"EjectSupport"
#define XmcdNmodeSenseSetDBD		"modeSenseSetDBD"
#define XmcdCModeSenseSetDBD		"ModeSenseSetDBD"
#define XmcdNvolumeControlSupport	"volumeControlSupport"
#define XmcdCVolumeControlSupport	"VolumeControlSupport"
#define XmcdNscsiAudioVolumeBase	"scsiAudioVolumeBase"
#define XmcdCScsiAudioVolumeBase	"ScsiAudioVolumeBase"
#define XmcdNvolumeControlTaper		"volumeControlTaper"
#define XmcdCVolumeControlTaper		"VolumeControlTaper"
#define XmcdNpauseResumeSupport		"pauseResumeSupport"
#define XmcdCPauseResumeSupport		"PauseResumeSupport"
#define XmcdNcaddyLockSupport		"caddyLockSupport"
#define XmcdCCaddyLockSupport		"CaddyLockSupport"
#define XmcdNnoTURWhenPlaying		"noTURWhenPlaying"
#define XmcdCNoTURWhenPlaying		"NoTURWhenPlaying"
#define XmcdNcurposFormat		"curposFormat"
#define XmcdCCurposFormat		"CurposFormat"
#define XmcdNspinDownOnLoad		"spinDownOnLoad"
#define XmcdCSpinDownOnLoad		"SpinDownOnLoad"
#define XmcdNejectOnExit		"ejectOnExit"
#define XmcdCEjectOnExit		"EjectOnExit"
#define XmcdNstopOnExit			"stopOnExit"
#define XmcdCStopOnExit			"StopOnExit"
#define XmcdNexitOnEject		"exitOnEject"
#define XmcdCExitOnEject		"ExitOnEject"
#define XmcdNcloseOnEject		"closeOnEject"
#define XmcdCCloseOnEject		"CloseOnEject"
#define XmcdNsolaris2VolumeManager	"solaris2VolumeManager"
#define XmcdCSolaris2VolumeManager	"Solaris2VolumeManager"
#define XmcdNshowScsiErrMsg		"showScsiErrMsg"
#define XmcdCShowScsiErrMsg		"ShowScsiErrMsg"
#define XmcdNmainShowFocus		"mainShowFocus"
#define XmcdCMainShowFocus		"MainShowFocus"
#define XmcdNmainShowDiscTitle		"mainShowDiscTitle"
#define XmcdCMainShowDiscTitle		"MainShowDiscTitle"
#define XmcdNmainShowTrackTitle		"mainShowTrackTitle"
#define XmcdCMainShowTrackTitle		"MainShowTrackTitle"
#define XmcdNcddbTimeShowLength		"cddbTimeShowLength"
#define XmcdCCddbTimeShowLength		"CddbTimeShowLength"
#define XmcdNdebugMode			"debugMode"
#define XmcdCDebugMode			"DebugMode"

#define XmcdNmainWindowTitle		"mainWindowTitle"
#define XmcdCMainWindowTitle		"MainWindowTitle"
#define XmcdNdbModeMsg			"dbModeMsg"
#define XmcdCDbModeMsg			"DbModeMsg"
#define XmcdNprogModeMsg		"progModeMsg"
#define XmcdCProgModeMsg		"ProgModeMsg"
#define XmcdNelapseMsg			"elapseMsg"
#define XmcdCElapseMsg			"ElapseMsg"
#define XmcdNremainTrackMsg		"remainTrackMsg"
#define XmcdCRemainTrackMsg		"RemainTrackMsg"
#define XmcdNremainDiscMsg		"remainDiscMsg"
#define XmcdCRemainDiscMsg		"RemainDiscMsg"
#define XmcdNplayMsg			"playMsg"
#define XmcdCPlayMsg			"PlayMsg"
#define XmcdNpauseMsg			"pauseMsg"
#define XmcdCPauseMsg			"PauseMsg"
#define XmcdNreadyMsg			"readyMsg"
#define XmcdCReadyMsg			"ReadyMsg"
#define XmcdNsampleMsg			"sampleMsg"
#define XmcdCSampleMsg			"SampleMsg"
#define XmcdNusageMsg			"usageMsg"
#define XmcdCUsageMsg			"UsageMsg"
#define XmcdNbadOptsMsg			"badOptsMsg"
#define XmcdCBadOptsMsg			"BadOptsMsg"
#define XmcdNnoDiscMsg			"noDiscMsg"
#define XmcdCNoDiscMsg			"NoDiscMsg"
#define XmcdNdevBusyMsg			"devBusyMsg"
#define XmcdCDevBusyMsg			"DevBusyMsg"
#define XmcdNunknownDiscMsg		"unknownDiscMsg"
#define XmcdCUnknownDiscMsg		"UnknownDiscMsg"
#define XmcdNunknownTrackMsg		"unknownTrackMsg"
#define XmcdCUnknownTrackMsg		"UnknownTrackMsg"
#define XmcdNdataMsg			"dataMsg"
#define XmcdCDataMsg			"DataMsg"
#define XmcdNwarningMsg			"warningMsg"
#define XmcdCWarningMsg			"WarningMsg"
#define XmcdNfatalMsg			"fatalMsg"
#define XmcdCFatalMsg			"FatalMsg"
#define XmcdNconfirmMsg			"confirmMsg"
#define XmcdCConfirmMsg			"ConfirmMsg"
#define XmcdNinfoMsg			"infoMsg"
#define XmcdCInfoMsg			"InfoMsg"
#define XmcdNaboutMsg			"aboutMsg"
#define XmcdCAboutMsg			"AboutMsg"
#define XmcdNquitMsg			"quitMsg"
#define XmcdCQuitMsg			"QuitMsg"
#define XmcdNnoMemMsg			"noMemMsg"
#define XmcdCNoMemMsg			"NoMemMsg"
#define XmcdNnoHelpMsg			"noHelpMsg"
#define XmcdCNoHelpMsg			"NoHelpMsg"
#define XmcdNnoLinkMsg			"noLinkMsg"
#define XmcdCNoLinkMsg			"NoLinkMsg"
#define XmcdNnoDbMsg			"noDbMsg"
#define XmcdCNoDbMsg			"NoDbMsg"
#define XmcdNnotRomMsg			"notRomMsg"
#define XmcdCNotRomMsg			"NotRomMsg"
#define XmcdNnotScsi2Msg		"notScsi2Msg"
#define XmcdCNotScsi2Msg		"NotScsi2Msg"
#define XmcdNmodeErrMsg			"modeErrMsg"
#define XmcdCModeErrMsg			"ModeErrMsg"
#define XmcdNstatErrMsg			"statErrMsg"
#define XmcdCStatErrMsg			"StatErrMsg"
#define XmcdNnodeErrMsg			"nodeErrMsg"
#define XmcdCNodeErrMsg			"NodeErrMsg"
#define XmcdNseqFmtErrMsg		"seqFmtErrMsg"
#define XmcdCSeqFmtErrMsg		"SeqFmtErrMsg"
#define XmcdNdbdirsErrMsg		"dbdirsErrMsg"
#define XmcdCDbdirsErrMsg		"DbdirsErrMsg"
#define XmcdNrecovErrMsg		"recovErrMsg"
#define XmcdCRecovErrMsg		"RecovErrMsg"
#define XmcdNmaxErrMsg			"maxErrMsg"
#define XmcdCMaxErrMsg			"MaxErrMsg"
#define XmcdNsavErrForkMsg		"savErrForkMsg"
#define XmcdCSavErrForkMsg		"SavErrForkMsg"
#define XmcdNsavErrSuidMsg		"savErrSuidMsg"
#define XmcdCSavErrSuidMsg		"SavErrSuidMsg"
#define XmcdNsavErrOpenMsg		"savErrOpenMsg"
#define XmcdCSavErrOpenMsg		"SavErrOpenMsg"
#define XmcdNsavErrKilledMsg		"savErrKilledMsg"
#define XmcdCSavErrKilledMsg		"SavErrKilledMsg"
#define XmcdNlnkErrForkMsg		"lnkErrForkMsg"
#define XmcdCLnkErrForkMsg		"LnkErrForkMsg"
#define XmcdNlnkErrSuidMsg		"lnkErrSuidMsg"
#define XmcdCLnkErrSuidMsg		"LnkErrSuidMsg"
#define XmcdNlnkErrLinkMsg		"lnkErrLinkMsg"
#define XmcdCLnkErrLinkMsg		"LnkErrLinkMsg"
#define XmcdNlnkErrKilledMsg		"lnkErrKilledMsg"
#define XmcdCLnkErrKilledMsg		"LnkErrKilledMsg"

#define XmcdNbuttonLabelKey		"buttonLabelKey"
#define XmcdCButtonLabelKey		"ButtonLabelKey"
#define XmcdNlockKey			"lockKey"
#define XmcdCLockKey			"LockKey"
#define XmcdNrepeatKey			"repeatKey"
#define XmcdCRepeatKey			"RepeatKey"
#define XmcdNshuffleKey			"shuffleKey"
#define XmcdCShuffleKey			"ShuffleKey"
#define XmcdNejectKey			"ejectKey"
#define XmcdCEjectKey			"EjectKey"
#define XmcdNpowerOffKey		"powerOffKey"
#define XmcdCPowerOffKey		"PowerOffKey"
#define XmcdNdbprogKey			"dbprogKey"
#define XmcdCDbprogKey			"DbprogKey"
#define XmcdNhelpKey			"helpKey"
#define XmcdCHelpKey			"HelpKey"
#define XmcdNtimeKey			"timeKey"
#define XmcdCTimeKey			"TimeKey"
#define XmcdNabKey			"abKey"
#define XmcdCAbKey			"AbKey"
#define XmcdNsampleKey			"sampleKey"
#define XmcdCSampleKey			"SampleKey"
#define XmcdNkeypadKey			"keypadKey"
#define XmcdCKeypadKey			"KeypadKey"
#define XmcdNplayPauseKey		"playPauseKey"
#define XmcdCPlayPauseKey		"PlayPauseKey"
#define XmcdNstopKey			"stopKey"
#define XmcdCStopKey			"StopKey"
#define XmcdNprevTrackKey		"prevTrackKey"
#define XmcdCPrevTrackKey		"PrevTrackKey"
#define XmcdNnextTrackKey		"nextTrackKey"
#define XmcdCNextTrackKey		"NextTrackKey"
#define XmcdNprevIndexKey		"prevIndexKey"
#define XmcdCPrevIndexKey		"PrevIndexKey"
#define XmcdNnextIndexKey		"nextIndexKey"
#define XmcdCNextIndexKey		"NextIndexKey"
#define XmcdNrewKey			"rewKey"
#define XmcdCRewKey			"RewKey"
#define XmcdNffKey			"ffKey"
#define XmcdCFfKey			"FfKey"
#define XmcdNkeypadNumKey0		"keypadNumKey0"
#define XmcdCKeypadNumKey0		"KeypadNumKey0"
#define XmcdNkeypadNumKey1		"keypadNumKey1"
#define XmcdCKeypadNumKey1		"KeypadNumKey1"
#define XmcdNkeypadNumKey2		"keypadNumKey2"
#define XmcdCKeypadNumKey2		"KeypadNumKey2"
#define XmcdNkeypadNumKey3		"keypadNumKey3"
#define XmcdCKeypadNumKey3		"KeypadNumKey3"
#define XmcdNkeypadNumKey4		"keypadNumKey4"
#define XmcdCKeypadNumKey4		"KeypadNumKey4"
#define XmcdNkeypadNumKey5		"keypadNumKey5"
#define XmcdCKeypadNumKey5		"KeypadNumKey5"
#define XmcdNkeypadNumKey6		"keypadNumKey6"
#define XmcdCKeypadNumKey6		"KeypadNumKey6"
#define XmcdNkeypadNumKey7		"keypadNumKey7"
#define XmcdCKeypadNumKey7		"KeypadNumKey7"
#define XmcdNkeypadNumKey8		"keypadNumKey8"
#define XmcdCKeypadNumKey8		"KeypadNumKey8"
#define XmcdNkeypadNumKey9		"keypadNumKey9"
#define XmcdCKeypadNumKey9		"KeypadNumKey9"
#define XmcdNkeypadEnterKey		"keypadEnterKey"
#define XmcdCKeypadEnterKey		"KeypadEnterKey"
#define XmcdNkeypadClearKey		"keypadClearKey"
#define XmcdCKeypadClearKey		"KeypadClearKey"
#define XmcdNkeypadCancelKey		"keypadCancelKey"
#define XmcdCKeypadCancelKey		"KeypadCancelKey"


STATIC XtResource	resources[] = {
	{
		XmcdNdevnum, XmcdCDevnum,
		XmRInt, sizeof(int),
		XtOffsetOf(AppData, devnum), XmRImmediate,
		(XtPointer) DEVNUM,
	},
	{
		XmcdNdevice, XmcdCDevice,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, device), XmRImmediate,
		(XtPointer) DEVICE,
	},
	{
		XmcdNlibdir, XmcdCLibdir,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, libdir), XmRImmediate,
		(XtPointer) CDLIBDIR,
	},
	{
		XmcdNdbdir, XmcdCDbdir,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, dbdir), XmRImmediate,
		(XtPointer) CDDBDIR,
	},
	{
		XmcdNmaxDbdirs, XmcdCMaxDbdirs,
		XmRInt, sizeof(int),
		XtOffsetOf(AppData, max_dbdirs), XmRImmediate,
		(XtPointer) MAX_DBDIRS,
	},
	{
		XmcdNdbFileMode, XmcdCDbFileMode,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, dbfile_mode), XmRImmediate,
		(XtPointer) DBFILE_MODE,
	},
	{
		XmcdNcaddyLock, XmcdCCaddyLock,
		XmRBoolean, sizeof(Boolean),
		XtOffsetOf(AppData, caddy_lock), XmRImmediate,
		(XtPointer) CADDY_LOCK,
	},
	{
		XmcdNspinDownOnLoad, XmcdCSpinDownOnLoad,
		XmRBoolean, sizeof(Boolean),
		XtOffsetOf(AppData, load_spindown), XmRImmediate,
		(XtPointer) LOAD_SPINDOWN,
	},
	{
		XmcdNejectOnExit, XmcdCEjectOnExit,
		XmRBoolean, sizeof(Boolean),
		XtOffsetOf(AppData, exit_eject), XmRImmediate,
		(XtPointer) EXIT_EJECT,
	},
	{
		XmcdNstopOnExit, XmcdCStopOnExit,
		XmRBoolean, sizeof(Boolean),
		XtOffsetOf(AppData, exit_stop), XmRImmediate,
		(XtPointer) EXIT_STOP,
	},
	{
		XmcdNexitOnEject, XmcdCExitOnEject,
		XmRBoolean, sizeof(Boolean),
		XtOffsetOf(AppData, eject_exit), XmRImmediate,
		(XtPointer) EJECT_EXIT,
	},
	{
		XmcdNcloseOnEject, XmcdCCloseOnEject,
		XmRBoolean, sizeof(Boolean),
		XtOffsetOf(AppData, eject_close), XmRImmediate,
		(XtPointer) EJECT_CLOSE,
	},
	{
		XmcdNsolaris2VolumeManager, XmcdCSolaris2VolumeManager,
		XmRBoolean, sizeof(Boolean),
		XtOffsetOf(AppData, sol2_volmgt), XmRImmediate,
		(XtPointer) SOL2_VOLMGT_DFL,
	},
	{
		XmcdNshowScsiErrMsg, XmcdCShowScsiErrMsg,
		XmRBoolean, sizeof(Boolean),
		XtOffsetOf(AppData, scsierr_msg), XmRImmediate,
		(XtPointer) SCSIERR_MSG,
	},
	{
		XmcdNmainShowFocus, XmcdCMainShowFocus,
		XmRBoolean, sizeof(Boolean),
		XtOffsetOf(AppData, main_showfocus), XmRImmediate,
		(XtPointer) MAIN_SHOWFOCUS,
	},
	{
		XmcdNmainShowDiscTitle, XmcdCMainShowDiscTitle,
		XmRBoolean, sizeof(Boolean),
		XtOffsetOf(AppData, main_showdtitle), XmRImmediate,
		(XtPointer) MAIN_SHOWDTITLE,
	},
	{
		XmcdNmainShowTrackTitle, XmcdCMainShowTrackTitle,
		XmRBoolean, sizeof(Boolean),
		XtOffsetOf(AppData, main_showttitle), XmRImmediate,
		(XtPointer) MAIN_SHOWTTITLE,
	},
	{
		XmcdNcddbTimeShowLength, XmcdCCddbTimeShowLength,
		XmRBoolean, sizeof(Boolean),
		XtOffsetOf(AppData, dbtime_len), XmRImmediate,
		(XtPointer) DBTIME_LEN,
	},
	{
		XmcdNdebugMode, XmcdCDebugMode,
		XmRBoolean, sizeof(Boolean),
		XtOffsetOf(AppData, debug), XmRImmediate,
		(XtPointer) DEBUG_MODE,
	},
	{
		XmcdNstatusPollInterval, XmcdCStatusPollInterval,
		XmRInt, sizeof(int),
		XtOffsetOf(AppData, stat_interval), XmRImmediate,
		(XtPointer) STATUS_INTERVAL,
	},
	{
		XmcdNinsertPollInterval, XmcdCInsertPollInterval,
		XmRInt, sizeof(int),
		XtOffsetOf(AppData, ins_interval), XmRImmediate,
		(XtPointer) INSERT_INTERVAL,
	},
	{
		XmcdNpreviousThreshold, XmcdCPreviousThreshold,
		XmRInt, sizeof(int),
		XtOffsetOf(AppData, prev_threshold), XmRImmediate,
		(XtPointer) PREV_THRESHOLD,
	},
	{
		XmcdNsearchSkipBlocks, XmcdCSearchSkipBlocks,
		XmRInt, sizeof(int),
		XtOffsetOf(AppData, skip_blks), XmRImmediate,
		(XtPointer) SKIP_BLKS,
	},
	{
		XmcdNsearchPauseInterval, XmcdCSearchPauseInterval,
		XmRInt, sizeof(int),
		XtOffsetOf(AppData, skip_pause), XmRImmediate,
		(XtPointer) SKIP_PAUSE,
	},
	{
		XmcdNsearchSpeedUpCount, XmcdCSearchSpeedUpCount,
		XmRInt, sizeof(int),
		XtOffsetOf(AppData, skip_spdup), XmRImmediate,
		(XtPointer) SKIP_SPDUP,
	},
	{
		XmcdNsearchVolumePercent, XmcdCSearchVolumePercent,
		XmRInt, sizeof(int),
		XtOffsetOf(AppData, skip_vol), XmRImmediate,
		(XtPointer) SKIP_VOL,
	},
	{
		XmcdNsearchMinVolume, XmcdCSearchMinVolume,
		XmRInt, sizeof(int),
		XtOffsetOf(AppData, skip_minvol), XmRImmediate,
		(XtPointer) SKIP_MINVOL,
	},
	{
		XmcdNsampleBlocks, XmcdCSampleBlocks,
		XmRInt, sizeof(int),
		XtOffsetOf(AppData, sample_blks), XmRImmediate,
		(XtPointer) SAMPLE_BLKS,
	},
	{
		XmcdNminimumPlayBlocks, XmcdCMinimumPlayBlocks,
		XmRInt, sizeof(int),
		XtOffsetOf(AppData, min_playblks), XmRImmediate,
		(XtPointer) MIN_PLAYBLKS,
	},
	{
		XmcdNdisplayBlinkOnInterval, XmcdCDisplayBlinkOnInterval,
		XmRInt, sizeof(int),
		XtOffsetOf(AppData, blinkon_interval), XmRImmediate,
		(XtPointer) BLINKON_INTERVAL,
	},
	{
		XmcdNdisplayBlinkOffInterval, XmcdCDisplayBlinkOffInterval,
		XmRInt, sizeof(int),
		XtOffsetOf(AppData, blinkoff_interval), XmRImmediate,
		(XtPointer) BLINKOFF_INTERVAL,
	},
	{
		XmcdNdriveVendorCode, XmcdCDriveVendorCode,
		XmRInt, sizeof(int),
		XtOffsetOf(AppData, vendor_code), XmRImmediate,
		(XtPointer) VENDOR_CODE,
	},
	{
		XmcdNplayAudio10Support, XmcdCPlayAudio10Support,
		XmRBoolean, sizeof(Boolean),
		XtOffsetOf(AppData, play10_supp), XmRImmediate,
		(XtPointer) PLAY10_SUPP,
	},
	{
		XmcdNplayAudio12Support, XmcdCPlayAudio12Support,
		XmRBoolean, sizeof(Boolean),
		XtOffsetOf(AppData, play12_supp), XmRImmediate,
		(XtPointer) PLAY12_SUPP,
	},
	{
		XmcdNplayAudioMSFSupport, XmcdCPlayAudioMSFSupport,
		XmRBoolean, sizeof(Boolean),
		XtOffsetOf(AppData, playmsf_supp), XmRImmediate,
		(XtPointer) PLAYMSF_SUPP,
	},
	{
		XmcdNplayAudioTISupport, XmcdCPlayAudioTISupport,
		XmRBoolean, sizeof(Boolean),
		XtOffsetOf(AppData, playti_supp), XmRImmediate,
		(XtPointer) PLAYTI_SUPP,
	},
	{
		XmcdNloadSupport, XmcdCLoadSupport,
		XmRBoolean, sizeof(Boolean),
		XtOffsetOf(AppData, load_supp), XmRImmediate,
		(XtPointer) LOAD_SUPP,
	},
	{
		XmcdNejectSupport, XmcdCEjectSupport,
		XmRBoolean, sizeof(Boolean),
		XtOffsetOf(AppData, eject_supp), XmRImmediate,
		(XtPointer) EJECT_SUPP,
	},
	{
		XmcdNmodeSenseSetDBD, XmcdCModeSenseSetDBD,
		XmRBoolean, sizeof(Boolean),
		XtOffsetOf(AppData, msen_dbd), XmRImmediate,
		(XtPointer) MSEN_DBD,
	},
	{
		XmcdNvolumeControlSupport, XmcdCVolumeControlSupport,
		XmRBoolean, sizeof(Boolean),
		XtOffsetOf(AppData, mselvol_supp), XmRImmediate,
		(XtPointer) MSELVOL_SUPP,
	},
	{
		XmcdNscsiAudioVolumeBase, XmcdCScsiAudioVolumeBase,
		XmRInt, sizeof(int),
		XtOffsetOf(AppData, base_scsivol), XmRImmediate,
		(XtPointer) BASE_SCSIVOL,
	},
	{
		XmcdNvolumeControlTaper, XmcdCVolumeControlTaper,
		XmRInt, sizeof(int),
		XtOffsetOf(AppData, vol_taper), XmRImmediate,
		(XtPointer) VOL_TAPER,
	},
	{
		XmcdNpauseResumeSupport, XmcdCPauseResumeSupport,
		XmRBoolean, sizeof(Boolean),
		XtOffsetOf(AppData, pause_supp), XmRImmediate,
		(XtPointer) PAUSE_SUPP,
	},
	{
		XmcdNcaddyLockSupport, XmcdCCaddyLockSupport,
		XmRBoolean, sizeof(Boolean),
		XtOffsetOf(AppData, caddylock_supp), XmRImmediate,
		(XtPointer) CADDYLOCK_SUPP,
	},
	{
		XmcdNnoTURWhenPlaying, XmcdCNoTURWhenPlaying,
		XmRBoolean, sizeof(Boolean),
		XtOffsetOf(AppData, play_notur), XmRImmediate,
		(XtPointer) PLAY_NOTUR,
	},
	{
		XmcdNcurposFormat, XmcdCCurposFormat,
		XmRBoolean, sizeof(Boolean),
		XtOffsetOf(AppData, curpos_fmt), XmRImmediate,
		(XtPointer) CURPOS_FMT,
	},
	{
		XmcdNmainWindowTitle, XmcdCMainWindowTitle,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, main_title), XmRImmediate,
		(XtPointer) MAIN_TITLE,
	},
	{
		XmcdNdbModeMsg, XmcdCDbModeMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_dbmode), XmRImmediate,
		(XtPointer) STR_DBMODE,
	},
	{
		XmcdNprogModeMsg, XmcdCProgModeMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_progmode), XmRImmediate,
		(XtPointer) STR_PROGMODE,
	},
	{
		XmcdNelapseMsg, XmcdCElapseMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_elapse), XmRImmediate,
		(XtPointer) STR_ELAPSE,
	},
	{
		XmcdNremainTrackMsg, XmcdCRemainTrackMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_remaintrk), XmRImmediate,
		(XtPointer) STR_REMAIN_TRK,
	},
	{
		XmcdNremainDiscMsg, XmcdCRemainDiscMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_remaindisc), XmRImmediate,
		(XtPointer) STR_REMAIN_DISC,
	},
	{
		XmcdNplayMsg, XmcdCPlayMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_play), XmRImmediate,
		(XtPointer) STR_PLAY,
	},
	{
		XmcdNpauseMsg, XmcdCPauseMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_pause), XmRImmediate,
		(XtPointer) STR_PAUSE,
	},
	{
		XmcdNreadyMsg, XmcdCReadyMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_ready), XmRImmediate,
		(XtPointer) STR_READY,
	},
	{
		XmcdNsampleMsg, XmcdCSampleMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_sample), XmRImmediate,
		(XtPointer) STR_SAMPLE,
	},
	{
		XmcdNusageMsg, XmcdCUsageMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_usage), XmRImmediate,
		(XtPointer) STR_USAGE,
	},
	{
		XmcdNbadOptsMsg, XmcdCBadOptsMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_badopts), XmRImmediate,
		(XtPointer) STR_BADOPTS,
	},
	{
		XmcdNnoDiscMsg, XmcdCNoDiscMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_nodisc), XmRImmediate,
		(XtPointer) STR_NODISC,
	},
	{
		XmcdNdevBusyMsg, XmcdCDevBusyMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_busy), XmRImmediate,
		(XtPointer) STR_BUSY,
	},
	{
		XmcdNunknownDiscMsg, XmcdCUnknownDiscMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_unkndisc), XmRImmediate,
		(XtPointer) STR_UNKNDISC,
	},
	{
		XmcdNunknownTrackMsg, XmcdCUnknownTrackMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_unkntrk), XmRImmediate,
		(XtPointer) STR_UNKNTRK,
	},
	{
		XmcdNdataMsg, XmcdCDataMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_data), XmRImmediate,
		(XtPointer) STR_DATA,
	},
	{
		XmcdNwarningMsg, XmcdCWarningMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_warning), XmRImmediate,
		(XtPointer) STR_WARNING,
	},
	{
		XmcdNfatalMsg, XmcdCFatalMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_fatal), XmRImmediate,
		(XtPointer) STR_FATAL,
	},
	{
		XmcdNconfirmMsg, XmcdCConfirmMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_confirm), XmRImmediate,
		(XtPointer) STR_CONFIRM,
	},
	{
		XmcdNinfoMsg, XmcdCInfoMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_info), XmRImmediate,
		(XtPointer) STR_INFO,
	},
	{
		XmcdNaboutMsg, XmcdCAboutMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_about), XmRImmediate,
		(XtPointer) STR_ABOUT,
	},
	{
		XmcdNquitMsg, XmcdCQuitMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_quit), XmRImmediate,
		(XtPointer) STR_QUIT,
	},
	{
		XmcdNnoMemMsg, XmcdCNoMemMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_nomemory), XmRImmediate,
		(XtPointer) STR_NOMEMORY,
	},
	{
		XmcdNnoHelpMsg, XmcdCNoHelpMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_nohelp), XmRImmediate,
		(XtPointer) STR_NOHELP,
	},
	{
		XmcdNnoLinkMsg, XmcdCNoLinkMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_nolink), XmRImmediate,
		(XtPointer) STR_NOLINK,
	},
	{
		XmcdNnoDbMsg, XmcdCNoDbMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_nodb), XmRImmediate,
		(XtPointer) STR_NODB,
	},
	{
		XmcdNnotRomMsg, XmcdCNotRomMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_notrom), XmRImmediate,
		(XtPointer) STR_NOTROM,
	},
	{
		XmcdNnotScsi2Msg, XmcdCNotScsi2Msg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_notscsi2), XmRImmediate,
		(XtPointer) STR_NOTSCSI2,
	},
	{
		XmcdNmodeErrMsg, XmcdCModeErrMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_moderr), XmRImmediate,
		(XtPointer) STR_MODERR,
	},
	{
		XmcdNstatErrMsg, XmcdCStatErrMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_staterr), XmRImmediate,
		(XtPointer) STR_STATERR,
	},
	{
		XmcdNnodeErrMsg, XmcdCNodeErrMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_noderr), XmRImmediate,
		(XtPointer) STR_NODERR,
	},
	{
		XmcdNseqFmtErrMsg, XmcdCSeqFmtErrMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_seqfmterr), XmRImmediate,
		(XtPointer) STR_SEQFMTERR,
	},
	{
		XmcdNdbdirsErrMsg, XmcdCDbdirsErrMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_dbdirserr), XmRImmediate,
		(XtPointer) STR_DBDIRSERR,
	},
	{
		XmcdNrecovErrMsg, XmcdCRecovErrMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_recoverr), XmRImmediate,
		(XtPointer) STR_RECOVERR,
	},
	{
		XmcdNmaxErrMsg, XmcdCMaxErrMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_maxerr), XmRImmediate,
		(XtPointer) STR_MAXERR,
	},
	{
		XmcdNsavErrForkMsg, XmcdCSavErrForkMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_saverr_fork), XmRImmediate,
		(XtPointer) STR_SAVERR_FORK,
	},
	{
		XmcdNsavErrSuidMsg, XmcdCSavErrSuidMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_saverr_suid), XmRImmediate,
		(XtPointer) STR_SAVERR_SUID,
	},
	{
		XmcdNsavErrOpenMsg, XmcdCSavErrOpenMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_saverr_open), XmRImmediate,
		(XtPointer) STR_SAVERR_OPEN,
	},
	{
		XmcdNsavErrKilledMsg, XmcdCSavErrKilledMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_saverr_killed), XmRImmediate,
		(XtPointer) STR_SAVERR_KILLED,
	},
	{
		XmcdNlnkErrForkMsg, XmcdCLnkErrForkMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_lnkerr_fork), XmRImmediate,
		(XtPointer) STR_LNKERR_FORK,
	},
	{
		XmcdNlnkErrSuidMsg, XmcdCLnkErrSuidMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_lnkerr_suid), XmRImmediate,
		(XtPointer) STR_LNKERR_SUID,
	},
	{
		XmcdNlnkErrLinkMsg, XmcdCLnkErrLinkMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_lnkerr_link), XmRImmediate,
		(XtPointer) STR_LNKERR_LINK,
	},
	{
		XmcdNlnkErrKilledMsg, XmcdCLnkErrKilledMsg,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, str_lnkerr_killed), XmRImmediate,
		(XtPointer) STR_LNKERR_KILLED,
	},
	{
		XmcdNbuttonLabelKey, XmcdCButtonLabelKey,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, btnlbl_key), XmRImmediate,
		(XtPointer) BTNLBL_KEY,
	},
	{
		XmcdNlockKey, XmcdCLockKey,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, lock_key), XmRImmediate,
		(XtPointer) LOCK_KEY,
	},
	{
		XmcdNrepeatKey, XmcdCRepeatKey,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, repeat_key), XmRImmediate,
		(XtPointer) REPEAT_KEY,
	},
	{
		XmcdNshuffleKey, XmcdCShuffleKey,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, shuffle_key), XmRImmediate,
		(XtPointer) SHUFFLE_KEY,
	},
	{
		XmcdNejectKey, XmcdCEjectKey,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, eject_key), XmRImmediate,
		(XtPointer) EJECT_KEY,
	},
	{
		XmcdNpowerOffKey, XmcdCPowerOffKey,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, poweroff_key), XmRImmediate,
		(XtPointer) POWEROFF_KEY,
	},
	{
		XmcdNdbprogKey, XmcdCDbprogKey,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, dbprog_key), XmRImmediate,
		(XtPointer) DBPROG_KEY,
	},
	{
		XmcdNhelpKey, XmcdCHelpKey,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, help_key), XmRImmediate,
		(XtPointer) HELP_KEY,
	},
	{
		XmcdNtimeKey, XmcdCTimeKey,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, time_key), XmRImmediate,
		(XtPointer) TIME_KEY,
	},
	{
		XmcdNabKey, XmcdCAbKey,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, ab_key), XmRImmediate,
		(XtPointer) AB_KEY,
	},
	{
		XmcdNsampleKey, XmcdCSampleKey,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, sample_key), XmRImmediate,
		(XtPointer) SAMPLE_KEY,
	},
	{
		XmcdNkeypadKey, XmcdCKeypadKey,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, keypad_key), XmRImmediate,
		(XtPointer) KEYPAD_KEY,
	},
	{
		XmcdNplayPauseKey, XmcdCPlayPauseKey,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, playpause_key), XmRImmediate,
		(XtPointer) PLAYPAUSE_KEY,
	},
	{
		XmcdNstopKey, XmcdCStopKey,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, stop_key), XmRImmediate,
		(XtPointer) STOP_KEY,
	},
	{
		XmcdNprevTrackKey, XmcdCPrevTrackKey,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, prevtrk_key), XmRImmediate,
		(XtPointer) PREVTRK_KEY,
	},
	{
		XmcdNnextTrackKey, XmcdCNextTrackKey,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, nexttrk_key), XmRImmediate,
		(XtPointer) NEXTTRK_KEY,
	},
	{
		XmcdNprevIndexKey, XmcdCPrevIndexKey,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, previdx_key), XmRImmediate,
		(XtPointer) PREVIDX_KEY,
	},
	{
		XmcdNnextIndexKey, XmcdCNextIndexKey,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, nextidx_key), XmRImmediate,
		(XtPointer) NEXTIDX_KEY,
	},
	{
		XmcdNrewKey, XmcdCRewKey,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, rew_key), XmRImmediate,
		(XtPointer) REW_KEY,
	},
	{
		XmcdNffKey, XmcdCFfKey,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, ff_key), XmRImmediate,
		(XtPointer) FF_KEY,
	},
	{
		XmcdNkeypadNumKey0, XmcdCKeypadNumKey0,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, keypad0_key), XmRImmediate,
		(XtPointer) KEYPAD0_KEY,
	},
	{
		XmcdNkeypadNumKey1, XmcdCKeypadNumKey1,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, keypad1_key), XmRImmediate,
		(XtPointer) KEYPAD1_KEY,
	},
	{
		XmcdNkeypadNumKey2, XmcdCKeypadNumKey2,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, keypad2_key), XmRImmediate,
		(XtPointer) KEYPAD2_KEY,
	},
	{
		XmcdNkeypadNumKey3, XmcdCKeypadNumKey3,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, keypad3_key), XmRImmediate,
		(XtPointer) KEYPAD3_KEY,
	},
	{
		XmcdNkeypadNumKey4, XmcdCKeypadNumKey4,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, keypad4_key), XmRImmediate,
		(XtPointer) KEYPAD4_KEY,
	},
	{
		XmcdNkeypadNumKey5, XmcdCKeypadNumKey5,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, keypad5_key), XmRImmediate,
		(XtPointer) KEYPAD5_KEY,
	},
	{
		XmcdNkeypadNumKey6, XmcdCKeypadNumKey6,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, keypad6_key), XmRImmediate,
		(XtPointer) KEYPAD6_KEY,
	},
	{
		XmcdNkeypadNumKey7, XmcdCKeypadNumKey7,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, keypad7_key), XmRImmediate,
		(XtPointer) KEYPAD7_KEY,
	},
	{
		XmcdNkeypadNumKey8, XmcdCKeypadNumKey8,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, keypad8_key), XmRImmediate,
		(XtPointer) KEYPAD8_KEY,
	},
	{
		XmcdNkeypadNumKey9, XmcdCKeypadNumKey9,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, keypad9_key), XmRImmediate,
		(XtPointer) KEYPAD9_KEY,
	},
	{
		XmcdNkeypadEnterKey, XmcdCKeypadEnterKey,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, keypadenter_key), XmRImmediate,
		(XtPointer) KEYPADENTER_KEY,
	},
	{
		XmcdNkeypadClearKey, XmcdCKeypadClearKey,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, keypadclear_key), XmRImmediate,
		(XtPointer) KEYPADCLEAR_KEY,
	},
	{
		XmcdNkeypadCancelKey, XmcdCKeypadCancelKey,
		XmRString, sizeof(String),
		XtOffsetOf(AppData, keypadcancel_key), XmRImmediate,
		(XtPointer) KEYPADCANCEL_KEY,
	},
};


STATIC XrmOptionDescRec	options[] = {
	{ "-dev",	".device",	XrmoptionSepArg,	NULL },
	{ "-dbdir",	".dbdir",	XrmoptionSepArg,	NULL },
	{ "-debug",	".debugMode",	XrmoptionNoArg,		"True" },
};


STATIC String		fallbacks[] = {
	"*mainForm.width: 390",
	"*mainForm.height: 140",
	"*keypadForm.width: 150",
	"*keypadForm.height: 225",
	"*dbprogForm.width: 450",
	"*dbprogForm.height: 455",
	"*extDiscInfoForm.width: 400",
	"*extDiscInfoForm.height: 350",
	"*extTrackInfoForm.width: 400",
	"*extTrackInfoForm.height: 350",
	"*helpForm.width: 400",
	"*helpForm.height: 350",
	"*dirSelectForm.width: 250",
	"*dirSelectForm.height: 230",
	"*linkSelectForm.width: 350",
	"*linkSelectForm.height: 230",
	"*mainForm.XmPushButton.labelType: PIXMAP",
	"*mainForm.XmPushButton.fontList: -*-helvetica-bold-r-*--10-100-*",
	"*mainForm.checkBoxFrame*fontList: -*-helvetica-bold-r-*--10-100-*",
	"*trackIndicator.fontList: -*-helvetica-medium-o-*--24-240-*",
	"*indexIndicator.fontList: -*-helvetica-bold-o-*--14-140-*",
	"*timeIndicator.fontList: -*-helvetica-medium-o-*--24-240-*",
	"*dbModeIndicator.fontList: -*-helvetica-bold-r-*--12-120-*",
	"*progModeIndicator.fontList: -*-helvetica-bold-r-*--12-120-*",
	"*timeModeIndicator.fontList: -*-helvetica-bold-r-*--12-120-*",
	"*playModeIndicator.fontList: -*-helvetica-bold-r-*--12-120-*",
	"*discTitleIndicator.fontList: -*-helvetica-medium-r-*--10-100-*",
	"*trackTitleIndicator.fontList: -*-helvetica-medium-r-*--10-100-*",
	"*keypadForm*keypadLabel.fontList: -*-helvetica-medium-r-*--12-120-*",
	"*keypadForm*keypadIndicator.fontList: -*-helvetica-*-o-*--14-140-*",
	"*keypadForm*keypadCancelButton.fontList: -*-helvetica-medium-r-*--12-120-*",
	"*keypadForm*keypadClearButton.fontList: -*-helvetica-medium-r-*--12-120-*",
	"*keypadForm*fontList: -*-helvetica-bold-r-*--12-120-*",
	"*dirSelectList.fontList: -*-helvetica-medium-r-*--12-120-*",
	"*aboutPopup*fontList: -*-times-bold-i-*--24-240-*=chset1, -*-times-bold-i-*--12-120-*=chset2, -*-fixed-medium-r-*--10-100-*=chset3, fixed",
	"*discIdIndicator.fontList: -*-helvetica-medium-r-*--12-120-*",
	"*XmList.fontList: -*-helvetica-medium-r-*--12-120-*=chset1, -*-helvetica-bold-r-*--12-120-*=chset2, fixed",
	"*XmText.fontList: -*-helvetica-medium-r-*--12-120-*",
	"*XmScale*fontList: 6x10",
	"*fontlist: -*-helvetica-medium-r-*--12-120-*",
	"*checkBox*button_0.labelString: disp",
	"*checkBox*button_1.labelString: lock",
	"*checkBox*button_2.labelString: rept",
	"*checkBox*button_3.labelString: shuf",
	"*ejectButton.labelString: eject",
	"*powerOffButton.labelString: quit",
	"*dbprogButton.labelString: cddb\nprog",
	"*helpButton.labelString: help",
	"*timeButton.labelString: time",
	"*abButton.labelString: a->b",
	"*sampleButton.labelString: samp",
	"*keypadButton.labelString: kpad",
	"*playPauseButton.labelString: play / pause",
	"*stopButton.labelString: stop",
	"*prevTrackButton.labelString: < track",
	"*nextTrackButton.labelString: track >",
	"*prevIndexButton.labelString: < index",
	"*nextIndexButton.labelString: index >",
	"*rewButton.labelString: << rew",
	"*ffButton.labelString: ff >>",
	"*keypadLabel.labelString: Direct track access",
	"*keypadNumButton0.labelString: 0",
	"*keypadNumButton1.labelString: 1",
	"*keypadNumButton2.labelString: 2",
	"*keypadNumButton3.labelString: 3",
	"*keypadNumButton4.labelString: 4",
	"*keypadNumButton5.labelString: 5",
	"*keypadNumButton6.labelString: 6",
	"*keypadNumButton7.labelString: 7",
	"*keypadNumButton8.labelString: 8",
	"*keypadNumButton9.labelString: 9",
	"*keypadEnterButton.labelString: Enter",
	"*keypadCancelButton.labelString: Cancel",
	"*keypadClearButton.labelString: Clear",
	"*aboutButton.labelString: About...",
	"*discTitleLabel.labelString: Disc artist / Title",
	"*discLabel.labelString: Disc",
	"*extDiscInfoButton.labelString: Ext Info...",
	"*trackListLabel.labelString: Track / Time / Title",
	"*timeSelectLabel.labelString: Time",
	"*timeSelectBox*button_0.labelString: total",
	"*timeSelectBox*button_1.labelString: track",
	"*discIdLabel.labelString: Disc ID",
	"*discIdIndicator.labelString: ********",
	"*trackTitleLabel.labelString: Track title edit",
	"*trackLabel.labelString: Track",
	"*extTrackInfoButton.labelString: Ext Info...",
	"*programLabel.labelString: Trk Prog",
	"*addProgramButton.labelString: Add to",
	"*clearProgramButton.labelString: Clear",
	"*playProgramButton.labelString: Play",
	"*programSequenceLabel.labelString: Program sequence",
	"*saveDatabaseButton.labelString: Save",
	"*loadDatabaseButton.labelString: Load",
	"*linkDatabaseButton.labelString: Link",
	"*dbprogCancelButton.labelString: Cancel",
	"*extDiscInfoOkButton.labelString: OK",
	"*extDiscInfoClearButton.labelString: Clear",
	"*extDiscInfoCancelButton.labelString: Cancel",
	"*extTrackInfoOkButton.labelString: OK",
	"*extTrackInfoClearButton.labelString: Clear",
	"*extTrackInfoCancelButton.labelString: Cancel",
	"*helpOkButton.labelString: OK",
	"*dirSelectLabel.labelString: Database Directory Selection",
	"*dirSelectOkButton.labelString: OK",
	"*dirSelectCancelButton.labelString: Cancel",
	"*trackIndicator.foreground: white",
	"*trackIndicator.background: black",
	"*indexIndicator.foreground: white",
	"*indexIndicator.background: black",
	"*timeIndicator.foreground: white",
	"*timeIndicator.background: black",
	"*titleIndicator.foreground: white",
	"*titleIndicator.background: black",
	"*dbModeIndicator.foreground: white",
	"*dbModeIndicator.background: black",
	"*progModeIndicator.foreground: white",
	"*progModeIndicator.background: black",
	"*timeModeIndicator.foreground: white",
	"*timeModeIndicator.background: black",
	"*playModeIndicator.foreground: white",
	"*playModeIndicator.background: black",
	"*keypadIndicator.foreground: white",
	"*keypadIndicator.background: black",
	"*XmLabel.foreground: black",
	"*XmLabel.background: white",
	"*XmLabel.borderWidth: 0",
	"*foreground: black",
	"*background: white",
	"*title: xmcd - Can't access X defaults file",
	NULL,
};

#endif	/* __AC_RESRC_H__ */

