/* globals.h
 * actually defines globals, for both main.c, and other files.
 *
 *	Only have to change declaration of global in here, ONCE, and
 *	it's changed permanantly.
 *
 *	Put function declarations as "extern", NOT EXTERN.
 *	with the exception of CalculateColor, which is a function _pointer_
 */


#define START_MANDEL_WIDTH 300
#define START_MANDEL_HEIGHT 300


#ifndef MAIN
#define EXTERN extern

#else
#define EXTERN
#endif	/* ifndef MAIN */


/* Identify dialog widgets... */
enum {EqDIALOG};
/* for equasion dialog buttons */
enum {dialogOK, dialogRESET};


extern void quit();
extern int ReadValues();

extern void MakeEquasionDialog(),MakeWidgets();
extern void QuitCallback(Widget,XtPointer,XtPointer);
extern void RedrawCallback(Widget,XtPointer,XtPointer);
extern void ClearCallback(Widget,XtPointer,XtPointer);
extern void ResetCallback(Widget,XtPointer,XtPointer);
extern void MandelHandler(Widget,XtPointer, XEvent *,Boolean *);
extern void DialogOK();
extern void LoadColors();
extern void updatescaling();

#include "complex.h"
extern ComplexNum ComplexAdd(ComplexNum,ComplexNum);
extern ComplexNum ComplexSubtract(ComplexNum ,ComplexNum );
extern ComplexNum ComplexConjugate(ComplexNum);
extern ComplexNum ComplexDivide(ComplexNum ,ComplexNum );
extern ComplexNum ComplexMultiply(ComplexNum ,ComplexNum );
extern ComplexNum ComplexSquare(ComplexNum);
extern ComplexNum coordtocomplex(int,int );

extern int calculatePoint(ComplexNum);
extern int fastcalculatePoint(ComplexNum);


EXTERN  int  (* CalculateColor )(ComplexNum);
EXTERN Pixmap mandelbrotPixmap;
EXTERN int depth_of_screen;

EXTERN GC defaultgc;

EXTERN Display *display;
EXTERN Screen *screen;
EXTERN int screennum;
EXTERN Window mainwindow; /* parentwindow */
EXTERN Window rootwindow;/* root of display */
EXTERN GC defaultgc;
EXTERN unsigned int blackpixel,whitepixel;
EXTERN Colormap colormap;
EXTERN int maxcolor,iterate;

EXTERN int mandelwidth,mandelheight;/* size of WINDOW */
	/* scaling factors .. */
EXTERN double viewwidth,viewheight,viewcenterx,viewcentery;
EXTERN double esc_radius;

EXTERN XtAccelerators ReturnAccelerator;


EXTERN Widget toplevel,topform;
EXTERN Widget mandelWidget,equasionForm,formLabel;
EXTERN Widget buttonBox; /* need to replace this with something useful */
EXTERN Widget quitButton;
EXTERN Widget MouseHelpForm;

EXTERN Widget equasionWidget;

EXTERN XtAppContext Context;

 /* This is so we can tell if we're drawing, and maybe STOP it! */
EXTERN Boolean DoingDraw;
