#include <stdio.h>
#include <ctype.h>
#include <math.h>

#include <X11/Intrinsic.h>
#include "globals.h"

static double scalex,scaley;
static double halfwidth,halfheight;
double radius_squared;

/* updatescaling()
 *	Called to set up some constants in advance of calculation
 *	(To avoid recalculating them in each iteration)
 *	scale vars are used in coordtocomplex()
 */
void updatescaling(){
	scalex = viewwidth/ mandelwidth;
	scaley = viewheight / mandelheight;
	halfwidth = viewwidth/2;
	halfheight = viewheight/2;

	radius_squared = esc_radius * esc_radius;
	/* radius_squared only used if we're doing full
	 * precision.. but since it's only calculated once per
	 * mandel, we'll leave the code as-is
	 */
	
}

/* coordtocomplex()
 *	given a window coordinate, will calculate
 *	the complex co-ordinates, based on current scaling values,etc
 */
ComplexNum
coordtocomplex(int x,int y){
	ComplexNum returnnum;
	/* scale[xy] is the interval between one pixel on the screen */
	returnnum.real_part = scalex * x + (viewcenterx - halfwidth);
	returnnum.imag_part = scaley * y + (viewcentery - halfheight);
	return (returnnum);
}

ComplexNum ComplexConjugate(ComplexNum c){
	c.imag_part = - c.imag_part;
	return (c);
}


ComplexNum
ComplexSquare(ComplexNum first){
	ComplexNum returnnum;
	returnnum.real_part = (first.real_part * first.real_part) -
				(first.imag_part * first.imag_part);
	returnnum.imag_part = 2 * first.real_part * first.imag_part;
	return (returnnum);
}

ComplexNum
ComplexMultiply(ComplexNum first,ComplexNum second){
	ComplexNum returnnum;
	returnnum.real_part = (first.real_part * second.real_part) -
		(first.imag_part * second.imag_part);
	returnnum.imag_part = (first.real_part * second.imag_part) -
		(first.imag_part * second.real_part);
	return (returnnum);
}

ComplexNum
ComplexDivide(ComplexNum first,ComplexNum second){
	ComplexNum returnnum;
	double ratio;

	if(fabs(second.real_part) >fabs(second.imag_part) ){
		ratio = second.imag_part / second.real_part;
		returnnum.real_part =
			(first.real_part + first.imag_part * ratio) /
			  (second.real_part + ratio * second.imag_part);
		returnnum.imag_part =
			(first.imag_part - first.real_part * ratio) /
			  (second.real_part + ratio * second.imag_part);
		
		return (returnnum);
	}
	/* else */
	ratio = second.real_part / second.imag_part;
	returnnum.real_part =
		(first.real_part * ratio + first.imag_part) /
		 (second.imag_part + ratio * second.real_part);
	returnnum.imag_part =
		(first.imag_part * ratio - first.real_part) /
		 (second.imag_part + ratio * second.real_part);

	return (returnnum);
}

ComplexNum
ComplexAdd(ComplexNum first,ComplexNum second){
	ComplexNum returnnum;
	returnnum.real_part = first.real_part + second.real_part;
	returnnum.imag_part = first.imag_part + second.imag_part;
	return (returnnum);
}

ComplexNum
ComplexSubtract(ComplexNum first,ComplexNum second){
	ComplexNum returnnum;
	returnnum.real_part = first.real_part - second.real_part;
	returnnum.imag_part = first.imag_part - second.imag_part;
	return (returnnum);
}



