/* "colors.c"
 *	Has EVERYTHING to do with color handling
 */


#include <Xlib.h>
#include <Intrinsic.h>
#include <StringDefs.h>
#include <Xaw/Simple.h>
#include <Xaw/Form.h>

#include "globals.h"

#define NUMOFCOLORS 9
char *color_names[NUMOFCOLORS]={
	"black",	/* MUST have these two here, */
	"white",	/* as they are always present no matter what display */
	"violet",
	"purple", /* "indigo" */
	"blue",
	"green",
	"yellow",
	"orange",
	"red"
};
	
static long color_values[NUMOFCOLORS];
GC   gc_colors[NUMOFCOLORS];

void MakeColorguide(){

	Widget Colorbox;
	static Pixmap colorpixmap;
	int colorloop;

	colorpixmap = XCreatePixmap(display,rootwindow,
		      10,NUMOFCOLORS*10,depth_of_screen);
	XFillRectangle(display,colorpixmap,gc_colors[0],0,0,10,NUMOFCOLORS*20);
	colorloop = NUMOFCOLORS;
	
	while(--colorloop >=0){
		int Yval = colorloop * 3;
		XFillRectangle(display,colorpixmap,gc_colors[colorloop],
			       1,Yval,10,Yval +2);
	}
	Colorbox = XtVaCreateManagedWidget("colorbox",simpleWidgetClass,topform,
				XtNfromHoriz,MouseHelpForm,
				XtNhorizDistance,20,
				XtNfromVert,equasionForm,
				XtNwidth,10,
				XtNheight,NUMOFCOLORS*5+5,
				/* WHY "*5",  I do NOT know */
				XtNbackgroundPixmap,colorpixmap,
				NULL);

}

void ClearCallback(Widget widget,XtPointer data,XtPointer calldata){
	XFillRectangle(display,mandelbrotPixmap,gc_colors[0],
		       0,0,mandelwidth,mandelheight);
	XDrawString(display,mandelbrotPixmap,gc_colors[1],
			mandelwidth/2 - 60,mandelheight/2 ,"Welcome to Xmandel",18);

	XDrawRectangle(display,mandelbrotPixmap,gc_colors[1],
			20,20,mandelwidth-40,mandelheight-40);
		       
	XClearArea(display,XtWindow(mandelWidget),
			   0,0,mandelwidth,mandelheight,False);
}

/* LoadColors
 *	Assumes depth_of_screen is already set.
 *	Also assumes that screen is either monochrome,OR
 *	we can definately alocate a measly 8 colors that should
 *	be in that standard colormap anyways.
 *		Sets maxcolor;
 *		Clears pixmap
 */
void LoadColors(){
	XColor return_color,match_color;
	int colorloop=0;
	

	/*colormap = XCreateColormap(display,mainwindow,DefaultVisual(display,screennum),AllocNone);*/
	
	colormap = DefaultColormap(display,screennum);

	if(depth_of_screen==1){
		maxcolor=2;
	} else {
		maxcolor = NUMOFCOLORS ;
	}
	do {
#ifdef DEBUG
		printf("allocing #%d: %lx, %s\n",colorloop,color_values[colorloop],
		       color_names[colorloop]);
#endif /* DEBUG */
		if(XAllocNamedColor(display,colormap,color_names[colorloop],
				&return_color,   &match_color) == 0){
			fprintf("Could not alloc %s in default colormap",color_names[colorloop]);
		}
		color_values[colorloop]= match_color.pixel;
		gc_colors[colorloop] =
			XCreateGC(display,mainwindow,0,NULL);
		XSetForeground(display,gc_colors[colorloop],match_color.pixel);
	} while(++colorloop <maxcolor);

	XInstallColormap(display,colormap);

	ClearCallback(mandelWidget,NULL,NULL);
	XtVaSetValues(mandelWidget,XtNbackgroundPixmap,mandelbrotPixmap,NULL);

	MakeColorguide();
}

/* RedrawCallback:
 *	called when Draw button is clicked.
 *	Supposed to step through each pixel of the screen, 
 *	query the color value via calculatePoint(),
 *	then draw that colorvalue;
 */

extern void updatescaling();
extern Widget redrawButton;

#include "complex.h"

ComplexNum coordtocomplex(int,int);

static int Xloop,Yloop;

XtWorkProcId workprocID;
/* static Xloop, Yloop, above */
/* drawmandel() is an "XtWorkProc",
 * to draw stuff while the widgets are idle
 */
Boolean drawmandel(XtPointer calldata) {
	if(Yloop<mandelheight){
		ComplexNum Icoord;
		int color,newcolor;
		int initialX;


		/* now we attempt to buffer drawing,
		 * by drawing one line at a time
		 */

		Xloop=initialX = 0;
		Icoord=coordtocomplex(Xloop,Yloop);
		color =  (*CalculateColor)(Icoord);

		for(Xloop=1;Xloop<mandelwidth;Xloop++){
			Icoord= coordtocomplex(Xloop,Yloop);
			newcolor = (*CalculateColor)(Icoord);
			if(newcolor!=color){
				XDrawLine(display,mandelbrotPixmap,
					  gc_colors[color],
					  initialX,Yloop,
					  Xloop-1,Yloop);
				color= newcolor;
				initialX = Xloop;
			}

		}
		XDrawLine(display,mandelbrotPixmap,gc_colors[color],
			  initialX,Yloop,mandelwidth-1,Yloop);
		XClearArea(display,XtWindow(mandelWidget),
			   0,Yloop,mandelwidth,0,False);
		Yloop +=1;
		return False;
	} else {
		/* we're done!! */
		DoingDraw = False;
		XtSetSensitive(redrawButton,True);
		return True;
	}
}

/* RedrawCallback:
 *	DO the drawing!!
 *	(although the actual drawing gets done by drawmandel(), above)
 *	Note: This gets called by the XtAction Accelerator, as WELL
 *	as the "Draw" button.
 */
void RedrawCallback(Widget widget,XtPointer data,XtPointer calldata){

	if(DoingDraw == True){
		return;
		/* we've ALREADY CALLED THIS ROUTINE!! */
	}
	DoingDraw = True;
	Xloop = Yloop = 0;
	XtSetSensitive(widget,False);

	ReadValues();
	/* draw something for people to watch the progress.. */
	XDrawLine(display,mandelbrotPixmap,gc_colors[0],
		  0,0,0,mandelheight-1);
	XDrawLine(display,mandelbrotPixmap,gc_colors[1],
		  1,0,1,mandelheight-1);
	/* And redraw whole window.
	 * This does NOT clear, this redraws, since we are drawing
	 * to the background pixmap :->
	 */
	XClearArea(display,XtWindow(mandelWidget),
			   0,0,mandelwidth,mandelheight,False);
	updatescaling();

	workprocID = XtAppAddWorkProc(Context,drawmandel,NULL);

}

