.TH xlpsV2 1 "X-based Line Printer Status Display Program" "X11R4"
.SH Name
xlps, xlps_starter \- X-based line printer status reporting and display program.
.SH Description
An X-based program for displaying the status of all line printer queues,
jobs, and devices. \fIxlps\fP is the display portion of a three piece
client/server set of programs. The other two parts of the model are
\fIxlps_starter\fP and \fIxlps_server\fP. For an overall description of the
client/server set see the man page xlps(1).
.SH Appearance and Screen Utilization
The main display consists of a large window that utilizes the upper
right hand portion of the screen. Across the top of this window is a row
of command buttons, described in detail under \fIOptions\fP below. The
remainder of this window consists of one horizontal row of information
for each queue defined in /etc/printcap. 
.PP
The area of the screen
immediately below this window is referred to as the data area.  This
area is divided into n potential window sites, the value of n depending
on the servers screen geometry. When a job is sent to a queue for
printing, a popup window for that queue will appear in the next
available window site showing the job name, job owner, job size, and job
age, somewhat after the fashion of the lpq program. As soon as the queue
empties, the window pops back down (becomes invisible) and that window site is
made available for the next job pending popup window. A job pending
window for any given queue may be forced up by clicking the left mouse
on the queue name of that queue. Job pending windows brought up in this
manner will remain visible until the \fIquit\fP button in that window is
clicked on, or the \fIUnDisplay All Queue Contents\fP command button is
clicked on.
.PP
In the lower right
hand corner of the screen is an output age window, showing the number of
print jobs waiting for pickup at each known local or served printer, and
the age of the oldest job. 
.PP
Users with the right set of privileges, and that meet a certain set of
criteria, are given write access to the windows for the purpose of zeroing
the statistics. The full set of criteria to be met is: A) user must belong
to group \fIoperator\fP, and B) users display station must be specified in
the X application resource *controlTerm. This resource must be specified in
the applications default resource file /usr/lib/X11/app-defaults/LpsV2.
Clicking the left mouse on the printer name
in this window will clear the statistics for that printer, if the user
meets certain criteria.
.SH Syntax
\fBxlps\fP [any standard X-window command line switch or option]
.br
\fBxlps_starter\fP
.TP 3
\fIxlps\fP may be invoked anytime after an instance of \fIxlps_server\fP is
running. If \fIxlps_server\fP is not running, attempting to launch \fIxlps\fP
will result in a fatal error message.  In that event, the user should
launch \fIxlps\fP by issuing the \fIxlps_starter\fP command.
.TP 3
\fIxlps_starter\fP is the "safe" way to launch the \fIxlps\fP program.
\fIxlps_starter\fP determines if the \fIxlps_server\fP program is running, and if not
launches a new instance of \fIxlps_server\fP.  If (or after) the \fIxlps_server\fP is running
then \fIxlps_starter\fP execs an instance of \fIxlps\fP.
.SH Options
\fIxlps_starter\fP does not accept any command line switches or options.
.br
\fIxlps\fP accepts and correctly processes most standard X-window command
line switches and options. Most user customization is done through the use
of a row of command buttons across the top of the main display screen after
\fIxlps\fP is running. A description of these buttons follows.
.TP 5
\fIquit\fP. Placing the cursor within the boundries of the \fIquit\fP
button will cause the borders to highlight, indicating that the button is
ready for input.  Depressing left mouse while the cursor is in the button
area will cause a popup confirmation window to appear. Answering \fIno\fP
will cause the popup window to dissapear and the program to resume normal
operations. Answering \fIyes\fP will cause the program to perform an
orderly withdrawal from the client/server system.
.br
Note the caution under \fIScreen Saver\fP below.
.TP 5
\fIData Display Manager\fP. Placing the cursor within the boundries of the
\fIData Display Manager\fP button will cause the borders of the button to
highlight, indicating that the button is ready for input.  Depressing left
mouse while the cursor is within the button will cause a popup \fIDisplay
Manager Menu\fP window to appear. The choices offered by this menu are as
follows:
.IP 
\fI[Enable][Disable] Display of "Queued Jobs Pending" in Data Area\fP
.RS 10
\fIQueued Jobs Pending\fP are small popup windows that can optionally
appear in the area immediately below the main display anytime a queue has
jobs pending, and will automatically popdown when the queue is empty. 
This menu choice will read \fIenable\fP or \fIdisable\fP
depending on the current state of enablement, i.e., if the \fIjobs
pending\fP windows are currently enabled, the menu choice will read
\fIDisable Display of "Queued Jobs Pending" in Data Area"\fP and the choice
will read \fIenable\fP if they are not.
.RE
.IP
\fI[Enable][Disable] Display of "Tailed Log Files" in Data Area\fP
.RS 10
\fITailed Log Files\fP is a popup window that can optionally appear in the
area immediately below the main display anytime a status message that
demands immediate attention is found in any of the error logs specified in
the \fI/etc/printcap\fP file. As described above, This menu choice will read \fIenable\fP or \fIdisable\fP
depending on the current state of enablement, i.e., if the \fITailed Log
Files\fP are currently visible, then this choice will read
\fIDisable\fP, and visa-versa if they are not visible.
.RE
.IP
\fI[Enable][Disable] All Displays in Dynamic Data Area\fP
.RS 10
As described above, This menu choice will read \fIEnable\fP or \fIDisable\fP
depending on the current state of enablement, i.e., if any data windows
are enabled, this choice will read \fIDisable\fP, and visa-versa.  Note
that since some of the data windows are popup structures, enabled and
visible will not always be the same, i.e. the window may be enabled, but
since there is currently nothing to display it is not currently visible.
This menu choice is actually a short-cut choice combining the actions of
the first two choices.
.RE
.IP
\fILeave Everything the way it is.\fP
.RS 10
This is an option to exit this menu without modifying any structure
enablements or visibilities.
.RE 2
.TP 5
\fI[un]Display All Que Contents\fP
Another short cut method to popdown all currently visible queue content
windows, or to attempt to popup a job pending (queue content) window for
each queue listed.  The latter is not recommended as the screens on most
servers are not nearly large enough to display a queue content window
for every queue defined in /etc/printcap simultaneously. This button is
intended to be used to popdown queue content windows brought up by
clicking on its name in the queue name colume.
.NT
This button has no effect on child windows that were poped up automatically
as a result of queue activity. To remove those windows use the /fIData Display
Manager/Fp Menu.
.NE
.TP 5
\fIHelp\fP
If you haven't already figured out that this button brings up a help
window, then you need more than Help.
.TP 5
\fIScreen Saver\fP
Placing the cursor within the boundries of the \fIScreen Saver\fP button
and depressing and holding down the left mouse button will popup a
spring loaded menu that will only stay visible so long as the left mouse
button is held down. Dragging the cursor up or down the list of choices
given by this menu will cause them to reverse video as the cursor passes
over them. If the mouse button is realeased while one of the choices is
reversed, then that choice is invoked, otherwise nothing happens.
.PP
.RS 5
This button controls both the hardware and software screen saver.
Normally, when \fIxlps\fP is first invoked, the hardware screen saver is
disabled so the screen will not periodically go blank. Instead, a
software screen saver is created that moves each visible component of
the \fIxlps\fP system one pixel up & left, or down & right, once each
minute.
.RE
.PP
.RS 5
The software screen saver can be turned off by selecting the first menu
choice given by this function.
.RE
.PP
.RS 5
Conversly the hardware screen saver can be reinstated by selecting the
second menu choice given by this function, or by exiting the program via
the \fIquit\fP button.

.NT
If you exit the program by any method or means other than by using the
\fIquit\fP button, you will most likely leave the hardware screen saver
disabled, which can cause long term damage to the screen.  If necessary,
the hardware screen saver can be restored by issuing the command:
\fIxset s on\fP
.NE
.SH Main Body of Main Display
The main body of the main display is that portion under the command and
title bars. This section consists of one line for each queue defined in 
/etc/printcap. Each line gives the \fIQueue Name\fP, and shows the state
of \fIQueueing On\fP, \fIPrinting On\fP, the \fI# Jobs\fP waiting to print,
the \fIOldest Job Age\fP in minutes, the state of \fILocal Daemon On\fP, the
\fIAssigned To\fP printer name, and the \fILocal Status\fP. 
.PP
Some of the boxes in these columes 
are labels, which in X-Window parlance means the boxes are inactive (can't be clicked on),
and some are command boxes, which means that the boxes are active and can be clicked on
if certain other criteria are met.
.PP
Two conditions must be met in order for these command boxes to be activated. The first
is that the users server must have been specified in the \fIApplication-Defaults\fP resource file
in the resource list "*controlTerm". This is a comma seperated list of server names
that are allowed to modify the spooler. The second condition is that the user must belong to
group root or to group operator. If the above two conditions are NOT met the three control columes
\fIQueueing On\fP, \fIPrinting On\fP, and \fILocal Daemon On\fP will appear half-toned on
the users display; otherwise those columes will appear normally.
.PP
If the three control columes mentioned above do NOT appear half-toned, then the
user can change the state of that spooler parameter by clicking on the box for
that queue, i.e. if \fIPrinting On\fP for queue \fIcpfplot\fP currently reads "YES"
then clicking on that box will turn off printing for queue \fIcpfplot\fP.
.SH Environment
This suite of programs has been built and run under most SunOs and DEC
ULTRIX systems using TWM and TVWM window managers. Running the program
under Motif or OpenLook can produce some weird results, depending on the
settings of certain(??) window manager variables.

.SH See Also
lps(1), editprintcap(1), xlps_server(1), outputAge(1), lpinfo(1), xlps_starter(1)
.SH Errors
All error messages are sent to stderr.
.SH Bugs
Does not handle window resizes or geometry changes gracefully. Window
placement is determined by program control and most attempts to change
window location will result in the window returning to its original
location on the next software screen saver cycle.
.SH Copyright
1991 at NASA-Ames Research Center. Some portions of this program were
taken from the Berkeley spooler programs and from certain programs
contained in the MIT X11R4 release. Individual copyrights have been
reproduced for those portions affected.
.SH Author
.EX
Roger Smith
NASA-Ames Research Center
Mail Stop 233-10
Moffett Field, Ca. 94035
EMAIL: rsmith@george.arc.nasa.gov

REFER ANY PROBELMS OR BUG REPORTS TO:
	Roger Smith  x4-3583 or rsmith@george.arc.nasa.gov
	Ken Burgess  x4-6347 or kburgess@franklin.arc.nasa.gov
.EE

.SH Release
V2.1 May 1991

