.TH xlps 1 "X-based Line Printer Status & Control Programs" "X11R4"
.SH Name
xlps, lpsV2, editprintcap, xlps_starter, xlps_server, lpsd, outputAge, lpinfo \- X-based Line printer status reporting and 
control utility suite.
.SH Description
A X-based suite of tools and utilities for displaying the status of line
printer queues and jobs, and for displaying the contents of 
the \fI/etc/printcap\fP file, with an option to modify the file. 
.PP
The mainstay of the set is \fIxlps\fP, which is a client/server set of
programs that give a detailed display of the overall status of the entire
spooling system. This set consists of \fIxlps_starter\fP which gives an
unprivileged user the ability to start the privileged \fIxlps_server\fP and the
first invocation of \fIxlps\fP, \fIxlps_server\fP which is the data manipulation
portion of the client/server set, and \fIxlps\fP which is the X-display
portion of the client/server set.
.PP
\fIeditprintcap\fP allows the user to display all of the entries in the
\fI/etc/printcap\fP file in tabular format, and to optionally modify the
file.  \fIlpinfo\fP is a non-X-based utility for extracting lists of
information from \fI/etc/printcap\fP.

A more detailed description of each piece of the set
follows.
.IP "xlps \- Main status reporting program." 8
Builds a complex form on the invokers screen, one line
per each queue defined in \fI/etc/printcap\fP. Includes options to display other temporary popup 
and semi-permanent windows. Shows number of jobs pending in each queue and the length of time the
oldest job has been pending. Shows which printer each queue is assigned to and indicates if 
spooling is on, queueing is on, and if the daemon is on and the local status of that queue. In the
lower right hand portion of the screen will appear an \fIoutputAge\fP window that shows the number
of jobs waiting for pickup from each printer and the age of the oldest job. Users belonging to
group \fIoperator\fP may zero a printers pickup stats in the
\fIoutputAge\fP window by clicking on that printers name. The updated
display will be reflected on all other active invocations of \fIxlps\fP and \fIoutputAge\fP within
one second. Note that \fIoutputAge\fP may be invoked independent of
\fIxlps\fP (see below).
.TP 8 
editprintcap \- Display and/or modify the data in \fI/etc/printcap\fP.
An X-based utility for displaying and optionally 
modifying the entries in the
\fI/etc/printcap\fP file.  Builds a screen with one horizontal line for each queue defined in
\fI/etc/printcap\fP and one vertical colume for each parameter defined for that (all) queues.
Users with root priviliges may modify this file. All modifications are menu based and changes
are not committed to the file unless confirmed by the user.
.TP 8
xlps_starter \- Launch the privileged \fIxlps_server\fP program and 
an instance of \fIxlps\fP.
\fIxlps_starter\fP is only necessary if the \fIxlps_server\fP is not already running. In that case
\fIxlps_starter\fP allows a non-privileged user to launch the \fIxlps_server\fP program and the
first instance of the \fIxlps\fP program. If \fIxlps_server\fP is already running, the user need
only issue the \fIxlps\fP command to launch a new instance of the client, however, using
the \fIxlps_starter\fP command will check to see that \fIxlps_server\fP is running and then launch
a new instance of the \fIxlps\fP client.
.TP 8
lpsd \- Line printer status daemon.
\fIlpsd\fP is a private daemon that supports the \fIxlps\fP client/server set of programs. It expects
the tcp service socket 516 to be dedicated to utility \fIprinter_status\fP. In the event of
problems with running either the client or the server, the user should consult the system
error logs for entries from \fIlpsd\fP to try and identify the problem.
.TP 8
outputAge \- Show number of jobs waiting for pickup and their age.
\fIoutputAge\fP is a seperate program for those users who do not want the
entire \fIxlps\fP display on their screen.  Normally, \fIoutputAge\fP is
part of the \fIxlps\fP set of display windows, however, the \fIoutputAge\fP
window can be invoked alone with the \fIoutputAge\fP command. Users
belonging to group \fIoperator\fP and whose screen is included in the
application resource *controlTerm may zero a printers pickup stats by
clicking on that printers name. The updated display will be reflected on
all other active invocations of \fIxlps\fP and \fIoutputAge\fP within one
second. If the user does not meet the above criteria, then the printer names 
in that users \fIoutputAge\fPwindow will be grey scaled and the window will be read-only.
.TP 8
lpinfo \- extract information in list form from \fI/etc/printcap\fP.
\fIlpinfo\fP is actually a filter that extracts information from
\fI/etc/printcap\fP according to specified command line switches and
returns to the user a list resulting from applying the filter specified.
This was written to be called from another program, or especially from a
script or used in a shell pipe, to provide the calling program or shell
script with a controlled list of names according to a user specified criteria.
.SH Options
The X-based programs \fIxlps\fP and \fIoutputAge\fP honor all normal X command line options and
switches.  All other programs in this set do not accept any command line
options or switches, except for \fIlpinfo\fP.
.TP 8
xlps Options -
After \fIxlps\fP is up and running, there is a row of command buttons across 
the upper portion of the display that allow the user to customize the session.
.SH Installation
The distribution includes an Imake file. If the target system does not have a totally 
standard X distribution then the installer must specify -I and -D (at the minimum). 
For example:
.br
           imake -I/usr/lib/X11/config -DTOPDIR=/usr
.SH See Also
.EX
xlpsV2(1), editprintcap(1), xlps_starter(1), xlps_server(1), lpsd(1), 
outputAge(1), lpinfo(1)
.SH Author
.EX
Roger Smith
NASA-Ames Research Center
Mail Stop 233-10
Moffett Field, Ca. 94035
EMAIL: rsmith@george.arc.nasa.gov

REFER ANY PROBELMS OR BUG REPORTS TO:
	Roger Smith  x4-3583 or rsmith@george.arc.nasa.gov
	Ken Burgess  x4-6347 or kburgess@franklin.arc.nasa.gov
.EE

