
#include "../lp.h"
#include "../lps.h"
#include "../buffer_names.h"

#define CHILDWDOHT 250

extern Display *disp;
extern Widget topLevel, quit, pshell, allqueues;
extern Widget menuItem[2];
extern int interval;
extern XtTimerCallbackProc lpq();
extern XFontStruct  *font_info, *font5x8;
extern XtIntervalId ScreenSaverID;
extern XtAppContext app_context;
extern XtTimerCallbackProc ScreenSaver();
extern struct outputage outputAge;
extern void screenSaverMenu();
extern void allQueues();
extern void removeAllQueues();
extern int motion;
extern char   geometry_string[16];
extern int screentimeout, screeninterval, prefer_blanking, allow_exposures;
extern Bool ApplicationScreenSaver;
extern Bool HardwareScreenSaver;
extern XtIntervalId  bellID;
extern Bool bell;
extern Arg args[15];
extern int sid_clientActive, clientNum;

int    status_page_size[MAX_QUEUES];
Widget       new_text[MAX_QUEUES];
Widget       fileName[MAX_QUEUES];
Widget       new_window[MAX_QUEUES];
Widget       new_outer[MAX_QUEUES];
Widget       Qquit[MAX_QUEUES];
XtAppContext formApp[16];
int          context_count=0;
XtIntervalId intervalID[MAX_QUEUES];
XtIntervalId quitSoon;
int          slot[MAX_QUEUES][4];
XWindowAttributes window_attributes;
unsigned int display_width=0, display_height=0, ix=0, iy=0;
Dimension wd = 0, he=0, width, height, offset, border, wndomgr;
Bool displayallqueues=TRUE;

struct oldval OldVal[MAX_QUEUES];

/*
 *	Function name:	SetPopup
 *	Description:	This function pops up the specified dialog box.
 *	Arguments:	wdg - the widget to be popped up.
 *	Returns:	None.
 */

void SetPopup(wdg)
Widget wdg;
{
    Position x=0, y=0;
    Window rwin;
    Window chwin;
    int rx, ry, wx, wy;
    Dimension wd = 0;
    Dimension he = 0;
    unsigned int mask;
    
    /* Make the popup shell "wdg" come up at the current pointer position */

    XQueryPointer(XtDisplay(topLevel),XtWindow(topLevel),&rwin,&chwin,&rx,&ry,
		  &wx,&wy,&mask);
    
    XtSetArg(args[0], XtNwidth, &wd);
    XtSetArg(args[1], XtNheight, &he);
    XtGetValues(wdg, args, (Cardinal)2);
    if (wd == 0) wd = DIALOGWIDTH;
    if (he == 0) he = DIALOGHEIGHT;
    
    x = rx - wd/2;
    y = ry - he/2;
    
    sprintf(geometry_string,"+%d+%d",x,y);
    XtSetArg(args[0], XtNgeometry, geometry_string);
    XtSetValues(pshell, args, (Cardinal)1);
    XtSetSensitive(quit, FALSE);
    
    /* Popup the widget */
    XtPopup(pshell, XtGrabNone);
}
/*
 * bell ringing routine. Rings the bell once per second.
 */
XtTimerCallbackProc
ring_bell(client_data, bellid)
XtPointer client_data;
XtIntervalId *bellid;
{
    XBell (XtDisplay(topLevel), 0); /* ring the bell */
    bellID = XtAppAddTimeOut(app_context, (unsigned long) 2000, ring_bell,
			     (caddr_t) 0);
}
/*
 * dialog button
 */
/*ARGSUSED*/
void PopupDialog(w, client_data, call_data)
Widget w;
XtPointer client_data; /* cast to topLevel */
XtPointer call_data;
{
	Widget topLevel = (Widget) client_data;
	Position x, y;
	Dimension width, height;

	/*
 	 * get the coordinates of the middle of topLevel widget.
 	 */
	XtVaGetValues(topLevel, 
			XtNwidth, &width,
			XtNheight, &height,
			NULL);
	
	/*
	 * translate coordinates in application top-level window
	 * into coordinates from root window origin.
	 */
        XtTranslateCoords(topLevel,                /* Widget */
                (Position) width/2,        /* x */
                (Position) height/2,       /* y */
                &x, &y);          /* coords on root window */

	/* move popup shell to this position (it's not visible yet) */
	XtVaSetValues(pshell, 
			XtNx, x,
			XtNy, y,
			NULL);

	/*
	 * Indicate to user that no other application functions are
	 * valid while dialog is popped up...
	 */

	XtSetSensitive(quit, FALSE);

	XtPopup(pshell, XtGrabNonexclusive);
}
/*
 * yes button ( quit function)
 */
/*ARGSUSED*/
void Yes(w, client_data, call_data)
Widget w;
XtPointer client_data; /* cast to topLevel */
XtPointer call_data;
{
    extern XtTimerCallbackProc done();
    int i = 1;
    client_data = (char *)i;
    if (HardwareScreenSaver==OFF){
	screenSaverMenu(menuItem[1], client_data, NULL, 1); /* turn the screen saver back on */
    }
    quitSoon = XtAppAddTimeOut (app_context, (unsigned long)(1000), done, (caddr_t)0);
}

extern int s[MAX_QUEUES];
extern Bool lpsd[MAX_QUEUES];

/*ARGSUSED*/
XtTimerCallbackProc
done(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
    int i, nds;
    for (i=0; i<MAX_QUEUES; i++)
	if (s[i] && lpsd[i]){
	    write(s[i],"EOF",1);
	    close(s[i]);                /* close all active ports */
	}
    if ( (i = semclr(sid_clientActive, clientNum)) != 0 ) /* clear our clientAlive flag */
	syserr("semclr of clientActive set in quit", NULL, NULL);
    _exit();
}
/*
 * no button
 */
/*ARGSUSED*/
void No(w, client_data, call_data)
Widget w;
XtPointer client_data; /* cast to topLevel */
XtPointer call_data;
{
    XtPopdown (pshell);
    XtSetSensitive(quit,TRUE);
    return;
}

/*
 * function to popwdown a queue window when the user pushes the quit button.
 */

/*ARGSUSED*/
void popdown_window(w, client_data, call_data)
Widget w;
XtPointer client_data; 
XtPointer call_data;
{
    int    i;

    XtRemoveTimeOut(intervalID[(int) client_data]);
    if (bell&sigmask((int)client_data))	                    /* if bell bit set for this window */
	bell = bell^sigmask((int)client_data);		    /* clear this bit */
    if (!bell&&bellID !=0) {
	XtRemoveTimeOut(bellID);		    /* if bell is false, turn off the bell */
	bellID = 0;
    }
    XtPopdown(new_window[(int) client_data]);
    XtRemoveAllCallbacks(Qquit[(int) client_data], XtNcallback);
    OldVal[(int) client_data].isrealized = FALSE;
    for (i=0; i<MAX_QUEUES; i++)
	if (slot[i][NUM] == (int) client_data)
	    slot[i][STAT] = AVAIL;
    for (i=0; i<MAX_QUEUES; i++)
	if (OldVal[i].isrealized)
	    goto skipit;
    XtSetArg (args[0], XtNlabel,"  Display All\nQue  Contents" ); /* relabel the allqueues command box */
    XtSetValues (allqueues, args, 1);
    XtRemoveAllCallbacks(allqueues, XtNcallback);      /* remove the "undisplay all queues" callback */
    XtAddCallback(allqueues, XtNcallback, allQueues, 0);   /* set up new callback */
    displayallqueues = TRUE;
 skipit:
/*    status_page[(int)client_data] = (char *) realloc(status_page[(int)client_data], 256);*/
    copyWindowIDs((int)client_data);			    /* restore popup widget ids */
}

/*ARGSUSED*/
static void
Resize_Window(w, event, params, num_params)
Widget   w;
XEvent   *event;
String   *params;
Cardinal *num_params;
{
    Dimension width, height, new_width, new_height;
    int       i;
    XFontStruct  *fontp;

    XtVaGetValues(w,		                /* we come here with w containing ID of new_window[i] */
		  XtNheight, &height,
		  XtNwidth, &width,
		  NULL);
    for (i=1; i<MAX_QUEUES; i++)	                /* now find out which child window we are working with */
	if (w == new_window[i]) break;

    XawPanedSetRefigureMode(w, (Bool)TRUE);
    XawPanedSetRefigureMode(new_outer[i], (Bool)TRUE);

    if (OldVal[i].resized) {
	new_width = OldVal[i].old_width;
	new_height= OldVal[i].old_height;
	fontp = font5x8;
	OldVal[i].resized = FALSE;
	XtVaSetValues(new_text[i],
		      XtNfont,   fontp,
		      NULL);
	XtVaSetValues(Qquit[i],
		      XtNfont,   fontp,
		      NULL);
	XtVaSetValues(fileName[i],
		      XtNfont,   fontp,
		      NULL);
	XtVaSetValues(w,		                /* resize new_window[i] */
		      XtNheight, new_height,
		      XtNwidth,  new_width, 
		      XtNfont,   fontp,
		      NULL);
    }
    else {
	new_width = (Dimension)(width*1.5);
	new_height= (Dimension)(height);
	OldVal[i].old_width = width;
	OldVal[i].old_height= height;
	fontp = font_info;
	OldVal[i].resized = TRUE;
	XtVaSetValues(new_text[i],
		      XtNheight, new_height,
		      XtNfont,   fontp,
		      NULL);
	XtVaSetValues(Qquit[i],
		      XtNfont,   fontp,
		      NULL);
	XtVaSetValues(fileName[i],
		      XtNfont,   fontp,
		      NULL);
	XtVaSetValues(w,		                /* resize new_window[i] */
		      XtNwidth,  new_width, 
		      XtNfont,   fontp,
		      NULL);
    }
    printf("window resize for %d, old width=%d, new width=%d, old height=%d, new height=%d\n",
	   w, width, new_width, height, new_height);

    XRaiseWindow(XtDisplay(w) , XtWindow(w));
}

/*
 * function to popup a new window to display the contents of a queue in.
 */

void NewWindow(w, client_data, call_data)
Widget w;
XtPointer client_data;		/* XtPointer replaces caddr_t */
XtPointer call_data;
{
    Widget new_main_frame,  lab;
    int num_args, i;
    char icon_name[MAX_INPUT];
    Position x=0, y=0;
    char label_string[132];
    static XtActionsRec resize_actions[] = {"resize_window", Resize_Window};
    static char defaultTranslations[] = "#override\n <Btn3Down>: resize_window()";
    XtTranslations  mytranslations;
    char  quit_win_num[6];
    char  geometry_string[16];

    int quenum = (int) client_data;
    num_args = 0;

    if (OldVal[(int)client_data].isrealized){               /* is window already realized */
	XBell(XtDisplay(topLevel),0);
	fprintf(stderr,"WARNING - that window is already realized!\n");
	return;
    }

    if (OldVal[(int)client_data].isPopedUp)		    /* is window poped up */
	popdownWindow((int)client_data);

/* kill the screensaver timeout. avoids a nasty asynchronism between us and the window manager */

    if ((int)call_data != 5){
	XtRemoveTimeOut (ScreenSaverID);
    }

    if (displayallqueues){
	XtSetArg (args[0], XtNlabel,"UNdisplay All\nQue Contents" ); /* relabel the allqueues command box */
	XtSetValues (allqueues, args, 1);
	XtRemoveAllCallbacks(allqueues, XtNcallback);      /* remove the "display all queues" callback */
	XtAddCallback(allqueues, XtNcallback, removeAllQueues, 0);   /* set up new callback */
	displayallqueues = FALSE;
    }
/* now find an empty screen slot for child window */

    for (i=0; i<MAX_QUEUES; i++)
	if(slot[i][STAT] == AVAIL) break;
    if (i >= MAX_QUEUES){
	XBell(XtDisplay(topLevel),0);
	fprintf (stderr, "WARNING - no new window slots available\n");
	return;
    }
    slot[i][STAT] = NOTAVAIL;				    /* mark the window location as used */

    slot[i][NUM]  = (int) client_data;
    ix = slot[i][X] + motion;
    iy = slot[i][Y] + motion;
    sprintf(geometry_string,"+%d+%d",ix,iy);

    new_window[(int) client_data] = XtVaAppCreateShell(NULL, NewWindow, applicationShellWidgetClass, 
			   XtDisplay(topLevel),
			   XtNwidth,  width,
			   XtNheight, height,
			   XtNallowShellResize, TRUE,
			   XtNgeometry, geometry_string,
			   XtNiconName,  buf0->queNames[(int)client_data],
			   NULL);

    new_outer[(int) client_data] = XtVaCreateManagedWidget("new_outer",
					panedWidgetClass,
					new_window[(int) client_data],
					XtNallowResize, TRUE,
					NULL);
/*
 * Build the label for the child window
 */
    strcpy(label_string, "Spool Directory = ");
    strcat(label_string, buf0->qdata[(int)client_data][SDI]);
    strcat(label_string, "\nAssigned to ");
    if (buf0->qdata[(int)client_data][LPI][0] == NULL ) {
	strcat(label_string, buf0->qdata[(int)client_data][RMI]);
	strcat(label_string, ":");
	strcat(label_string, buf0->qdata[(int)client_data][RPI]);
    }
    else
	strcat(label_string, buf0->qdata[(int)client_data][LPI]);

    fileName[(int)client_data] = XtVaCreateManagedWidget("FileName",
				       labelWidgetClass,
				       new_outer[(int) client_data],
				       XtNlabel,     label_string, /* LABEL for child window */
				       XtNallowResize, TRUE,
				       NULL);

    new_text[(int) client_data] = XtVaCreateManagedWidget ("Text", 
							   asciiTextWidgetClass,
							   new_outer[(int) client_data],
							   XtNstring, status_page[(int)client_data], /* text string(s) to paint in window */
							   XtNheight, height-35,                     /* set height of text box */
							   XtNfromVert, fileName,
							   XtNscrollVertical, XawtextScrollWhenNeeded,
							   XtNallowResize, TRUE,
							   NULL);
    Qquit[(int) client_data] = XtVaCreateManagedWidget("Quit", 
				   commandWidgetClass,
				   new_outer[(int) client_data],	/* parent */
				   XtNfromVert,   new_text[(int) client_data],
				   XtNlabel,  "Quit",
				   XtNallowResize, TRUE,
				   NULL);
    XtAddCallback(Qquit[(int) client_data], XtNcallback, popdown_window, (int) client_data);

/*    displayq(0, (int) client_data);*/

    XtPopup(new_window[(int) client_data],XtGrabNone);

    OldVal[(int)client_data].isrealized = TRUE;
    formApp[(int) client_data] = XtWidgetToApplicationContext(new_outer[(int) client_data]);
    sprintf(quit_win_num, "%d\0", (int)client_data);
    XtAppAddActions (formApp[(int) client_data], resize_actions, XtNumber(resize_actions));
/*    mytranslations = XtParseTranslationTable(defaultTranslations);
    XtOverrideTranslations(new_window[(int) client_data], 
			   XtParseTranslationTable("<Btn3Down>: resize_window(*quit_win_num)"));*/
    intervalID[(int) client_data] = XtAppAddTimeOut (formApp[(int) client_data], 
				  (unsigned long) (interval*1000), 
				  lpq, 
				  (int) client_data);
    if ((int)call_data != 5)
	ScreenSaverID = XtAppAddTimeOut(app_context, 
					(unsigned long)(SCREENSAVERINTERVAL), 
					ScreenSaver,
					(caddr_t)NULL); /* restore the screen saver timeout */
}


calculateSlots()
{
    Display *display;
    int     screen;
    int     i;

/* get screen size from display structure macro */

    if (display_width==0){
	display = XtDisplay(topLevel);
	{
	    Window root, parent, *children;
	    unsigned int num_children;
	    XQueryTree (XtDisplay(topLevel),
			XtWindow(topLevel),
			&root, &parent, &children, &num_children);
	    XGetWindowAttributes (display,
				  parent,
				  &window_attributes); 
	    border = window_attributes.border_width;
	}
	screen = DefaultScreen(display);
	display_width = DisplayWidth(display, screen);
	display_height = DisplayHeight(display, screen);    /* now have width and height of screen */
	printf ("Display Width = %d, Height = %d\n", display_width, display_height);
	XtSetArg(args[0], XtNwidth, &wd);		    /* get width ... */
	XtSetArg(args[1], XtNheight, &he);		    /* and height ... */
	XtGetValues(topLevel, args, (Cardinal)2);	    /* of parent window */
	XGetWindowAttributes (display,
			      XtWindow(topLevel),
			      &window_attributes); 
	if (display_width >= 1280)
	    width = (display_width - 
		     ((window_attributes.border_width + (border * 2)) * 3)
		     ) / 3;				    /* child windows will be three across */
	else
	    width = (display_width - 
		     ((window_attributes.border_width + (border * 2)) * 2)
		     ) / 2;				    /* child windows will be two across */
	if ( width > 420 ) width = 420;			   /* maximum width = 420 */
	offset = (window_attributes.border_width * 2) + 
	          (border * 2) + window_attributes.y;	    /* allow for window manager title bar and borders */
	for (i=8; i>=1; i--){
	    height = (display_height - ((window_attributes.height + offset))); /* room for i rows */
	    height /= i;
/*#ifdef DEBUG*/
	    printf ("when i = %d new height = %d\n", i, height);
/*#endif*/
	    if (height >= display_height)
		continue;
	    if (height >= 90) 
		break;					    /* set minimum size larger than 90 pixels high*/
	}
	if (height >= display_height | height <= 90)
	    height = (display_height - ((window_attributes.height + offset)));
	printf ("Queue Status: width = %d, height = %d, border = %d\n", width, height, border);

	slot[0][STAT] = AVAIL;				    /* set up screen slots for child windows */
	slot[0][X] = 0;					    /* slot zero is on the extreme left hand side of screen... */
	slot[0][Y] = window_attributes.height + offset - 2;	    /* and just below the parent window */
	for (i=1; i<MAX_QUEUES; i++){				    /* do the rest of the available slots */

	    if (slot[i-1][Y] < 0)
		slot[i][STAT] = NOTAVAIL;		    /* every slot is available unless its off screen*/
	    else
		slot[i][STAT] = AVAIL;

	    if (slot[i][STAT] == AVAIL){
		slot[i][X] = slot[i-1][X] + width + (border * 2); /* each new slot is to the right of the previous one */
		if (slot[i][X] >= (display_width - width) +1){  /* if we are beyond the edge of the screen... */
		    slot[i][X] = 0;				    /* start over at the left side and... */
		    if ((slot[i-1][Y] + height + border) <= display_height) /* see if we are below bottom of screen */
			slot[i][Y] = slot[i-1][Y] + height + border;        /* if not, then move down one row */
		    else{				                    /* start over */
			slot[i][Y] = window_attributes.height + offset - 2;    /* just below the parent window */
		    }
		}
		else
		    slot[i][Y] = slot[i-1][Y];		    /* continue on same row */
	    }
	    else
		slot[i][Y] = -1;

	    if ( slot[i][X]+width > outputAge.x & slot[i][Y]+height > outputAge.y ) { /* dont cover up outputAge window */
		slot[i][X] = slot[i][X] + width + (border * 2); /* each new slot is to the right of the previous one */
		if (slot[i][X] >= (display_width - width) +1){  /* if we are beyond the edge of the screen... */
		    slot[i][X] = 0;				    /* start over at the left side and... */
		    if ((slot[i][Y] + height + border) <= display_height) /* see if we are below bottom of screen */
			slot[i][Y] = slot[i][Y] + height + border;        /* if not, then move down one row */
		    else{				                    /* start over */
			slot[i][Y] = window_attributes.height + offset - 2;    /* just below the parent window */
		    }
		}
		else
		    slot[i][Y] = slot[i-1][Y];		    /* continue on same row */
	    }

/*#ifdef DEBUG*/
	    printf ("for window pos #%d, x = %d, y = %d, AVAIL = %d\n", i, slot[i][X], slot[i][Y], slot[i][STAT]);
/*#endif*/
	}
    }
}
