
#define MAX_QUEUES 36
#include "../lps.h"
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/IntrinsicP.h>
#include <X11/ShellP.h>
#include <X11/Vendor.h>
#include <X11/VendorP.h>

#define XtNinterval "interval"
#define XtNcount "count"
#define XtCCount "Count"
#define XtNhelpFile "helpFile"
#define XtCHelpFile "HelpFile"
#define XtNcontrolTerm "controlTerm"
#define XtCControlTerm "ControlTerm"
#define DEF_INTERVAL	1
#define DEF_COUNT	-1

struct popupIds popupIDs[MAX_QUEUES];
Display *display;
int    screen_width, screen_height;
char   geometry_string[16];
char   display_name[32];
Screen *myscreen;
Pixel  white, black;
char   label_string[132];
Widget topLevel;
Widget lineShell, removeW, moveW, quitW, textW;
XtAppContext app_context;
static int defaultInterval = DEF_INTERVAL;
static int defaultCount = DEF_COUNT;
int    interval, count;
int    height=50;
XtWidgetGeometry request, reply;
Arg    args[15];
char   label[128];
String text_page[512];
Atom   QUE_LINE, QUE_LINE_TYPE;
Bool   poppedUpFirst = FALSE, lineWup = FALSE;
char   *queLines;

/* Application Resources - no particular widget */

static XtResource application_resources[] = {
    {"interval", "Interval", XtRInt, sizeof(int),
	    (Cardinal)&interval, XtRInt, (caddr_t) &defaultInterval},
    {"count", "Count", XtRInt, sizeof(int),
	    (Cardinal)&count, XtRInt, (caddr_t) &defaultCount},
};

/*
*  Command line options table. The command line is parsed for these,
*  and it sets/overrides the appropriate values in the resource
*  database
*/
static XrmOptionDescRec optionDescList[] = {
    {"-interval",   ".interval",    XrmoptionSepArg,    (caddr_t) NULL},
    {"-count",	    ".count",	    XrmoptionSepArg,    (caddr_t) NULL},
};
AppData app_data;
/* resource list */
static XtResource resources[] = {
    {
	XtNinterval,
	XtCInterval,
	XtRInt,
	sizeof(int),
	XtOffsetOf(AppData, interval),
	XtRImmediate,
	(caddr_t) DEF_INTERVAL
	},
	{
	XtNcount,
	XtCCount,
	XtRInt,
	sizeof(int),
	XtOffsetOf(AppData, count),
	XtRImmediate,
	(caddr_t) DEF_COUNT
	},
	{
	XtNhelpFile,
	XtCHelpFile,
	XtRString,
	sizeof(String),
	XtOffsetOf(AppData, helpFile),
	XtRString,
	HELPFILE
	},
	{
	    XtNcontrolTerm,
	    XtCControlTerm,
	    XtRString,
	    sizeof(String),
	    XtOffsetOf(AppData, ControlTerm),
	    XtRString,
	    NULL,
	}
};

void insert_selection(w, client_data, selection, type, value, length, format)
Widget w;
caddr_t client_data;
Atom *selection, *type;
caddr_t value;
unsigned long *length;
int *format;
{
    printf("from window #%d\n", (int)client_data);
    if ( !poppedUpFirst ) {
	request.request_mode = CWX | CWY;
	request.x = 0;
	request.y = 0+(200*3);
	XtMakeGeometryRequest(lineShell, &request, &reply);
	sprintf(geometry_string,"+%d+%d",request.x,request.y);
	XtSetArg(args[0], XtNgeometry, geometry_string);
	XtSetValues(lineShell, args, 1);   
	XtPopup (lineShell ,XtGrabNone);
	XtMoveWidget(lineShell, request.x, request.y);
	poppedUpFirst = lineWup = TRUE;
    }
    if ( !lineWup ){
	XtPopup (lineShell ,XtGrabNone);
	lineWup = TRUE;
    }
    XtVaSetValues(textW, 
		  XtNstring, value, 
		  NULL);			    /* display new data on screen */
    queLines = (char *) XtMalloc(strlen(value)+1);
    strcpy (queLines, value);
}

void get_selection(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
    int i;
    i = atoi(*params);
    XtGetSelectionValue(w, XA_PRIMARY, XA_STRING, insert_selection, i, event->xbutton.time);
}

main(argc, argv)
int argc;
char **argv;
{
    Widget pane1, pane2, yes, no, new;
    int    i, *p, n;
    char   *geometry;
    char   *myborder;
    char   warning_geometry[16];
    int    border=1;
    int    flags=0;
    Window root;
    Widget top;
    int    status, screen;
    Cursor cursor;
    XEvent event;
    char   newstring[1024];
    Position master_x;
    int    opergid, propCount;
    struct group *gr;
    static XtActionsRec window_actions[] = {
	{"get_selection", get_selection},
    };

    Atom   *property_list;
    int    button = 0;

    if ((display = XOpenDisplay(NULL))==0)		    /* open display, connect to server */
	perror("Display variable not set", NULL, NULL);
    screen = DefaultScreen(display);                        /* get screen NUMBER */
    screen_width = display->screens[0].width;
    screen_height = display->screens[0].height;
    strcpy(display_name, display->display_name);
    XSynchronize(display, TRUE);
    XCloseDisplay(display);				    /* disconnect from server */
/*
 * totalWidth equals the width of all boxes + the inter-box spacing (4) + the width of borders
 */

    sprintf(geometry_string,"200x200+%d+%d", 500, 0);

    topLevel = XtVaAppInitialize(
				 &app_context,		    /* Application context */
				 "LpsV2",		    /* application class name */
				 optionDescList, 
				 XtNumber(optionDescList),  /* command line option list */
				 &argc, argv,		    /* command line args */
				 NULL,			    /* for missing app-defaults file */
				 XtNgeometry, geometry_string,
				 XtNiconName,  LPS_VERSION,
				 NULL);			    /* terminate varargs list */

    display = XtDisplay(topLevel);
    myscreen = XtScreen(topLevel);			    /* get screen CORE STRUCTURE */
    white = WhitePixelOfScreen(myscreen);		    /* get default white pixel */
    createPopupStructures(4);
    XtRealizeWidget(topLevel);
    XtAppAddActions (app_context, window_actions, 1);
    for ( i=0; i<3; i++) {
	request.request_mode = CWX | CWY | CWWidth | CWHeight;
	request.x = 0;
	request.y = 0+(200*i);
	request.width = 250;
	request.height = 200 - 4;                   /* allow for borders */
	XtMakeGeometryRequest(popupIDs[i].outerShell, &request, &reply);
	sprintf(geometry_string,"+%d+%d",request.x,request.y);
	XtSetArg(args[0], XtNgeometry, geometry_string);
	XtSetValues(popupIDs[i].outerShell, args, 1);   
	XtPopup (popupIDs[i].outerShell ,XtGrabNone);
	XtMoveWidget(popupIDs[i].outerShell, request.x,request.y);
    }
    sprintf(text_page,"Now is the time for all \ngood\nMen to come to the aid\nof their country.\n");
    XtVaSetValues(popupIDs[0].textArea, 
		  XtNstring, text_page, 
		  NULL);			    /* display new data on screen */
    sprintf(text_page, "The quick brown fox\njumped over the lazy\ndogs back");
    XtVaSetValues(popupIDs[1].textArea, 
		  XtNstring, text_page, 
		  NULL);			    /* display new data on screen */
    sprintf(text_page, "Mary had a little lamb\nwhose fleece was white as snow.");
    XtVaSetValues(popupIDs[2].textArea, 
		  XtNstring, text_page, 
		  NULL);			    /* display new data on screen */

    XtAppMainLoop(app_context);
}

void quit_selections(w, client, call)
Widget w;
XtPointer client, call;
{
    printf("here we are in quit_selections\n");
    (void)XtFree(queLines);
    XtPopdown(lineShell);
    lineWup = FALSE;
}

void remove_selections(w, client, call)
Widget w;
XtPointer client, call;
{
    printf("here we are in remove_selections\nqueLines=%s\n", queLines);
    switch (fork()) {
    case -1:			/* fork failed */
	perror("fork failed in remove_selections");
	break;
    case 0:			/* child process */
	execl("/usr/ucb/lprm", "lprm", "-Ptest", "-", (char *)0 );
	perror("execl failed in remove_selections");
	exit(-1);
	break;
    default:			/* parent process */
	quit_selections();
    }
}

void move_selections(w, client, call)
Widget w;
XtPointer client, call;
{
    printf("here we are in move_selections\nqueLines=%s\n", queLines);
    switch (fork()) {
    case -1:			/* fork failed */
	perror("fork failed in move_selections");
	break;
    case 0:			/* child process */
	execl("/usr/local/bin/lpmv", "lpmv", "test", "test1", "-", (char *)0 );
	perror("execl failed in move_selections");
	exit(-1);
	break;
    default:			/* parent process */
	quit_selections();
    }
}

createPopupStructures(nitems)
int  nitems;
{
    int   i, lineNum;
    Widget unused;
    Widget lineForm, lineTitle;
    static XawTextSelectType sarray[] = {XawselectLine, XawselectNull};

    for (i=0; i<nitems; i++){
	popupIDs[i].outerShell = XtVaCreatePopupShell("popupwindow",
						       transientShellWidgetClass,
						       topLevel,
						       NULL);
	popupIDs[i].box = XtVaCreateManagedWidget("box",
						  panedWidgetClass,
						  popupIDs[i].outerShell,
						  XtNallowResize, TRUE,
						  NULL);
	popupIDs[i].title = XtVaCreateManagedWidget("title",
						     labelWidgetClass,
						     popupIDs[i].box,
						     NULL);
/*
 * Build the filename label for the popup window
 */
	sprintf(label_string, "buffer #%d", i);
	popupIDs[i].fileName = XtVaCreateManagedWidget ("FileName",
							labelWidgetClass,
							popupIDs[i].box,
							XtNfromVert, popupIDs[i].title,
							XtNlabel,     label_string, /* LABEL for child window */
							NULL);
	popupIDs[i].textArea = XtVaCreateManagedWidget ("Text",
#ifdef R4
							asciiStringWidgetClass,
#elif defined R5
							asciiTextWidgetClass,
#endif
							popupIDs[i].box,
							XtNheight,      height-35,
							XtNfromVert,    popupIDs[i].fileName,
#ifdef R4
							XtNtextOptions, scrollVertical,
#elif defined R5
							XtNscrollVertical, XawtextScrollWhenNeeded,
#endif
							NULL);
	sprintf (label, "<Btn1Up>: extend-end() get_selection(%d)\n\
<Btn3Up>: extend-end() get_selection(%d)", i, i);
	XtOverrideTranslations (popupIDs[i].textArea, XtParseTranslationTable(label));
	XawTextSetSelectionArray(popupIDs[i].textArea, sarray);
    }
/*
 * now create the control panel
 */
    lineShell = XtVaCreatePopupShell("Queue Entry Control Panel",
				     transientShellWidgetClass,
				     topLevel,
				     NULL);
    lineForm = XtVaCreateManagedWidget("formW",
				       formWidgetClass,
				       lineShell,
				       NULL);
    sprintf(label_string, "Queue Entry Control Panel");
    lineTitle = XtVaCreateManagedWidget("title",
					labelWidgetClass,
					lineForm,
					XtNheight,    25,
					XtNwidth,     300,
					XtNlabel,     label_string, /* LABEL for child window */
					NULL);
    sprintf(label_string, "  Remove\nSelections");
    removeW = XtVaCreateManagedWidget ("Remove Selections",
				       commandWidgetClass,
				       lineForm,
				       XtNfromVert,  lineTitle,
				       XtNheight,    35,
				       XtNlabel,     label_string, 
				       NULL);
    XtAddCallback (removeW, XtNcallback, remove_selections, NULL);
    sprintf(label_string, "   Move\nSelections");
    moveW = XtVaCreateManagedWidget ("Move Selections",
				     commandWidgetClass,
				     lineForm,
				     XtNfromVert,  lineTitle,
				     XtNfromHoriz, removeW,
				     XtNheight,    35,
				     XtNlabel,     label_string, 
				     NULL);
    XtAddCallback (moveW, XtNcallback, move_selections, NULL);
    sprintf(label_string, "Quit");
    quitW = XtVaCreateManagedWidget ("Quit Selections",
				     commandWidgetClass,
				     lineForm,
				     XtNheight,    35,
				     XtNfromVert,  lineTitle,
				     XtNfromHoriz, moveW,
				     XtNlabel,     label_string, 
				     NULL);
    XtAddCallback (quitW, XtNcallback, quit_selections, (Widget)lineShell);
    textW= XtVaCreateManagedWidget ("Text",
				    asciiTextWidgetClass,
				    lineForm,
				    XtNheight,      200,
				    XtNwidth,       300,
				    XtNfromVert,    removeW,
				    XtNscrollVertical, XawtextScrollWhenNeeded,
				    NULL);
}
