
#include "../lp.h"
#include "../buffer_names.h"
#include <sys/time.h>
#include <string.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <sys/sem.h>
#include <sys/shm.h>
#include <time.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <signal.h>

/*#define DEBUG 0*/
#define GRPALLOC TRUE
#define ATTACH_TO_ALL TRUE

#ifndef ENOENT
#include <errno.h>
#endif
#ifndef NULL
#define NULL 0
#endif
#ifndef Bool
typedef ushort Bool;
#endif
#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif
#ifndef SMSEG
#define SMSEG 6
#endif

extern char **environ;
extern void printenv();
extern int  errno;
extern int  pipelost();
extern int  getshmset();
extern time_t mtime[MAX_BUFFERS];
extern  char *  old_status_page[MAX_BUFFERS];

time_t  oldestJob[MAX_BUFFERS];
char    errmsg[MAXERRMSG];

struct	queue **queue;
struct  stat fileinfo;					    /* file information from fstat. */
struct sembuf setflag;

int sid, sid_control, sid_readReady, sid_writeLock, sid_clientActive;
int shmid[MAX_BUFFERS];
int clientList[MAX_READERS];
Bool verbose = FALSE;

main (argc, argv)
int argc;
char *argv[];
{ 
    extern int errno;
    char     *prog = argv[0];
    time_t start_time, end_time;
    key_t key=0;
    int i, n;
    int qid, retval;
    int status = 0;
    struct mymsg {
	long mtype;
	char c_clientNum[12];
    } msg;
    int flags;
    Bool change;
    short client_timeout[MAX_READERS];
    int  line, lineNum;
    int pgrp;

    struct databuf *copyofbuf0;


    argc--, argv++;
    while (argc > 0 && **argv == '-') {
	char *argp = *argv++;
	argp++;
	argc--;
	while (*argp++)
	    switch (argp[-1]) {
		
	    case 'V':
	    case 'v':
		verbose = TRUE;
		break;
	    default:
		fprintf(stderr, "%s: Valid options are:\n", prog);
		fprintf(stderr, "\t-v\tSet the verbose flag.\n");
		fprintf(stderr, "\t-d\tSet the debug flag (prints LOTS of stuff.)\n");
		exit();
	    }
    }
    setflag.sem_num = 0;
    setflag.sem_op = 1;
    setflag.sem_flg = SEM_UNDO;
    flags = 0777 | IPC_CREAT | SEM_UNDO;

#ifndef DEBUG
#ifdef GRPALLOC
    pgrp = getpgrp(0);
    printf ("in server pgrp = %d\n", pgrp);
    if (setpgrp(NULL, 28)<0)
	syserr("setpgrp in server", NULL, NULL);
    pgrp = getpgrp(0);
    printf ("in server setpgrp pgrp = %d\n", pgrp);
#endif
#endif

    key = getkey();
#ifdef mips
    openlog("lps_server", LOG_PID);
#else
    openlog("lps_server", LOG_PID, LOG_DAEMON);
#endif

/* now attempt to open some semaphore sets. */
         
    sid_control = getsemset(key, 3, "control");
    sid_readReady = getsemset(key+1, MAX_READERS, "readReady");
    sid_writeLock = getsemset(key+2, MAX_BUFFERS, "writeLock");
    sid_clientActive = getsemset(key+3, MAX_READERS, "clientActive");
/* 
  now make sure control flag #0 is off (set to 0).  If it is set to >0 then
  another server is still running.
*/
    if ((i = semctl(sid_control, 0, GETVAL, 0)) == -1)
	syserr("semctl of control set in server", NULL, NULL);
    if (i != 0)
	syserr("Control Flag 0 set on entry! Another server must still be running.", NULL, NULL);
/*
  Now set flag #0 to show that we are alive.
*/
    if ( (status = semop(sid_control, &setflag, 1)) == -1 )
	syserr("semop in server", NULL, sid_control);
#ifdef DEBUG
#define LINE #line
    line = __LINE__;
    printf ("in %s after semop status = %d at line %d\n", argv[0], status, line);
#endif
/*
  And clear the sid_clientActive set in case this is a restart
*/
    if ( semclrall(sid_clientActive) < 0 )
	syserr("semclrall in server", NULL, NULL);
    if ( semclr(sid_control, 1) < 0 )			    /* clear numClients counter */
	syserr("semclr of control flag 1 in server", NULL, NULL);
/*
  Now create a message queue to be used for clients to notify us
  of their existance. When we get notification we respond by 
  sending the new client its client number.
*/
    if ((qid = msgget((key_t)key, 0777|IPC_CREAT)) == -1)
	syserr ("msgget in server", NULL, NULL);
/*
  init writeLock sem set
*/
    if (semsetall(sid_writeLock)!=0)			    /* init writeLock flags to 1 */
	syserr("semsetall in server", NULL, NULL);
/*
  now get and attach the main shared memory region
*/
    shmid[0] = getshmset(key, sizeof(struct databuf), "buf0");
    printf ("in %s shmid%d = %d\n", argv[0], i, shmid[0]);
    if ((buf0 = (struct databuf *) shmat(shmid[0], 0, 0)) == ERR)
	syserr("shmat in server", NULL, NULL);
    bzero(buf0, sizeof(struct databuf));
    copyofbuf0 = (struct databuf *)malloc(sizeof(struct databuf)); /* get memory for old buf0 data */
    old_buf0 = (struct old_databuf *)malloc(sizeof(struct old_databuf)); /* * * FOR DEBUG * * */
    if (copyofbuf0 == NULL)
	syserr("ERROR, Can't malloc memory for copyofbuf0", NULL, NULL);
    bzero(copyofbuf0, sizeof(struct databuf *));
    if (seminc(sid_control, 2)<0)			    /* inc shmem region count */
	syserr("seminc in server", NULL, NULL);
/*
  go initialize our printcap data structures (shared memory region 0)
*/
    semwait(sid_writeLock, 0);				    /* wait till buffer #0 avail, then lock */
    buf0->mtime[0] = 0;					    /* init last update time */
    for (n=0; n<MAX_QUEUES; n++)
	buf0->oldestJob[n] = -1;                            /* init oldestJob structure */
    getStatus();
    seminc(sid_writeLock, 0);				    /* release lock */
    printf ("main segment inited with %d queues\n", buf0->nitems);
/*
  get the remainder of the shared memory regions.
*/
    printf ("SMSEG = %d \n", SMSEG);
    for (i=1; i<buf0->nitems; i++){
	sprintf (errmsg, "buffer #%d", i);
	shmid[i] = getshmset(key+i, SHMSIZE, errmsg);	    /* start out with 2048 bytes */
	printf ("in %s shmid%d = %d\n", argv[0], i, shmid[i]);
	old_status_page[i] = (char *) malloc(SHMSIZE);
	bzero(old_status_page[i], SHMSIZE);
#if ATTACH_TO_ALL
	if ((status_page[i] = (char *) shmat(shmid[i], 0, 0)) == (char *)-1)
	    syserr("shmat in server", NULL, NULL);
	bzero(status_page[i], SHMSIZE);
#endif
	if (seminc(sid_control, 2)<0)			    /* inc shmem region count */
	    syserr("seminc in server", NULL, NULL);
    }
    signal(SIGPIPE, pipelost);
/*
 * now build the output age structure 
*/
    buf0->numPrinters=0;
    for (i=0; i<MAX_BUFFERS; i++)
	strcpy(buf0->data[i].printer, "\0");               /* zero the structures first */
    for (i=1; i<buf0->nitems; i++){
	if ((strchr(buf0->assigned_to[i], '@')) == NULL){   /* skip any remotely assigned */
	    for (lineNum=0; lineNum<MAX_BUFFERS; lineNum++){
		if (strlen(buf0->data[lineNum].printer) == 0){
		    strcpy(buf0->data[lineNum].printer, buf0->assigned_to[i]);
		    buf0->numPrinters++;
		    break;
		}
		else if (strcmp(buf0->data[lineNum].printer, buf0->assigned_to[i]) == 0)
		    break;
		else
		    continue;
	    }
	}
    }
    printf ("found %d printers\n", buf0->numPrinters);

/***************** MAIN LOOP ***************/

    for (;;){
/*
  first check to see if any new clients are asking for recognition.
*/
  doAgain:
#ifdef DEBUG	
	printf("*********************loop******\n");
#endif
	start_time = time(NULL);
	if ((retval = msgrcv(qid, &msg, sizeof(msg), (long)1, IPC_NOWAIT)) == -1)
	    if (errno != ENOMSG) syserr ("msgrcv in server", NULL, NULL);
	if (retval>0){					    /* if msg_type (long)1 was ok */
	    if ( verbose )
		printf ("in server, received a %d byte msg with mtype = %d, msg = %s\n",
			retval, msg.mtype, msg.c_clientNum);    /* for received msgs, body contains pid of sender...*/
	    syslog (LOG_WARNING, "in server, received a %d byte msg with mtype = %d, msg = %s\n",
		    retval, msg.mtype, msg.c_clientNum);    /* for received msgs, body contains pid of sender... */
	    if (msg.mtype != 1){			    /* if mtype != 1, msg wasnt for us... */
		if ((retval = msgsnd(qid, &msg, sizeof(msg), 0)) == -1) /* resend msg  *NOTREACHED* if msgrcv worked */
		    syserr ("msgsnd in server", NULL, NULL);
	    }
	    else{					    /* process message */
		msg.mtype = atoi(msg.c_clientNum);	    /* to be used as mtype for response */
		for (i=0; i<MAX_READERS; i++){		    /* set up to find first empty clientNum */
		    if ((semctl(sid_clientActive, i, GETVAL, 0)) == 0){/* sequence through the clientActive flags */
			sprintf(msg.c_clientNum, "%d", i);  /* reset body to new clientNum */
			clientList[i] = msg.mtype;	    /* remember this clients pid */
			break;
		    }
		}
		if (i > MAX_READERS-1)			    /* if we run out of flags... */
		    sprintf(msg.c_clientNum, "%d", -1);	    /* set error return */
		if ( verbose )
		    printf ("in server sending msg with mtype = %d, decimal clientNum = %d, string clientNum = %s\n", 
			    msg.mtype, i, msg.c_clientNum);
		syslog (LOG_WARNING, "in server sending msg with mtype = %d, decimal clientNum = %d, string clientNum = %s\n", 
			msg.mtype, i, msg.c_clientNum);
		if ((retval = msgsnd(qid, &msg, sizeof(msg), 0)) == -1)
		    syserr ("msgsnd in server", NULL, NULL); /* send clientNum msg to client */
		for ( i=1; i<MAX_QUEUES; i++ )
		    if ( old_status_page[i] )
			bzero(old_status_page[i], sizeof(old_status_page[i]));
	    }						    /* else */
	}			                            /* if (retval) */
/*
  next check to make sure all active readers have finished processing the
  most recent update. We do this by checking the clientAlive flag for each client.
  If the clientAlive flag is set AND the readReady flag for that client is also
  set, then that client hasn't finished processing our most recent update.
*/
#ifndef DEBUG
	for (i=0; i<MAX_READERS; i++){
	    if ((semgetval(sid_clientActive, i)>0) && (semgetval(sid_readReady, i) != 0)){
		if ( verbose )
		    printf ("in server, waiting for client %d to finish read\n", i);
		if (++client_timeout[i] <= 9)                /* give it 10 seconds */
		    goto waitAwhile;
		else {
		    if ( verbose )
			printf("in server, aborting wait for client %d to finish read\n", i);
		    client_timeout[i] = 0;
		}
	    }
	    else
		client_timeout[i] = 0;
	}
#endif
/*
  now check to see if there is any new data
*/
	change = FALSE;
	for (i=0; i<=buf0->nitems-1; i++){
#ifdef DEBUG
	    mtime[i] = buf0->mtime[i];
	    strcpy(old_buf0->queNames[i], buf0->queNames[i]);
	    old_buf0->queingEna[i] = buf0->queingEna[i];
	    old_buf0->printEna[i] = buf0->printEna[i];
	    old_buf0->oldestJob[i] = buf0->oldestJob[i];
	    old_buf0->daemonPresent[i] = buf0->daemonPresent[i];
	    old_buf0->data[i].oldestJob = buf0->data[i].oldestJob;
	    strcpy(old_buf0->assigned_to[i], buf0->assigned_to[i]);
	    strcpy(old_buf0->status[i], buf0->status[i]);
#endif
	    old_buf0->numEntries[i] = buf0->numEntries[i];
	}
	semwait(sid_writeLock, 0);			    /* wait till buffer #0 avail, then lock */
	getStatus();					    /* go get new printcap status data */
	seminc(sid_writeLock, 0);			    /* release lock */

	for (i=1; i<buf0->nitems; i++){			    /* check on all queues */
#if !ATTACH_TO_ALL
	    if ((status_page[i] = (char *) shmat(shmid[i], 0, 0)) == (char *)-1)
		syserr("shmat in server", NULL, NULL);
#endif
	    semwait(sid_writeLock, i);			    /* take out a lock on this buffer */
	    if ((n = displayq(0, i))!=0){		    /* get queue content info... */
		change = TRUE;				    /* returns # files queued, else 0 */
#ifdef DEBUG	
		printf ("displayq returned %d for queue#%d\n", n, i);
#endif
	    }
	    seminc(sid_writeLock, i);			    /* release lock */
	    if (buf0->numEntries[i] <= 0)
		buf0->oldestJob[i] = -1;
#if !ATTACH_TO_ALL
	    shmdt(status_page[i]);
#endif
	}
	for (lineNum=0; lineNum<=buf0->nitems-1; lineNum++){
#ifdef DEBUG
	    if (buf0->mtime[lineNum] != mtime[lineNum])
		printf("mtime #%d changed from %d to %d\n", lineNum, mtime[lineNum], buf0->mtime[lineNum]);
	    if (strcmp(buf0->queNames[lineNum],old_buf0->queNames[lineNum])!=0)
		printf("queNames#%d changed from %s to %s\n", lineNum, old_buf0->queNames[lineNum], buf0->queNames[lineNum]);
	    if (buf0->queingEna[lineNum] != old_buf0->queingEna[lineNum])
		printf("queingEna#%d changed from %d to %d\n", lineNum, old_buf0->queingEna[lineNum], buf0->queingEna[lineNum]);
	    if (buf0->printEna[lineNum] != old_buf0->printEna[lineNum])
		printf("printEna#%d changed from %d to %d\n", lineNum, old_buf0->printEna[lineNum], buf0->printEna[lineNum]);
	    if (buf0->daemonPresent[lineNum] != old_buf0->daemonPresent[lineNum])
		printf("daemonPresent#%d changed from %d to %d\n", lineNum, old_buf0->daemonPresent[lineNum], buf0->daemonPresent[lineNum]);
	    if (buf0->oldestJob[lineNum] != old_buf0->oldestJob[lineNum])
		printf("oldestJob#%d changed from %d to %d\n", lineNum, old_buf0->oldestJob[lineNum], buf0->oldestJob[lineNum]);
	    if (strcmp(buf0->assigned_to[lineNum], old_buf0->assigned_to[lineNum]) != 0)
		printf("assigned_to#%d changed from %s to %s\n", lineNum, old_buf0->assigned_to[lineNum], buf0->assigned_to[lineNum]);
	    if (strcmp(buf0->status[lineNum], old_buf0->status[lineNum])!=0)
		printf("status#%d changed from %s to %s\n", lineNum, old_buf0->status[lineNum], buf0->status[lineNum]);
	    if (memcmp(buf0->qdata[lineNum], copyofbuf0->qdata[lineNum], sizeof(buf0->qdata[lineNum])) != 0)
		printf("qdata #%d changed from %s to %s\n", lineNum, copyofbuf0->qdata[lineNum], buf0->qdata[lineNum]);
#endif
	    if (buf0->numEntries[lineNum] != old_buf0->numEntries[lineNum]){
		i = old_buf0->numEntries[lineNum] - buf0->numEntries[lineNum];
		if (i > 0){
		    if ((strchr(buf0->assigned_to[lineNum], '@')) == 0){
			for (n=0; n<buf0->numPrinters; n++)
			    if (strcmp(buf0->data[n].printer, buf0->assigned_to[lineNum]) == 0)
				break;
			if (n >= buf0->numPrinters)
			    syserr("couldnt find assigned_to printer in prntrName list", NULL, NULL);
#ifdef DEBUG			
			printf ("numJobs#%d waiting for pickup changed from %d to ", n, buf0->data[n].numJobs);
#endif
			if (buf0->data[n].numJobs == 0)	    /* client will set numJobs & */
			    buf0->oldestJobTime[n] = time((long *)0); /* oldestJobTime to 0 when clearing job ageing display */
			buf0->data[n].numJobs += i;
#ifdef DEBUG			
			printf ("%d\n", buf0->data[n].numJobs);
#endif
		    }
		}
#ifdef DEBUG		
		printf("numEntries#%d changed from %d to %d\n", lineNum, old_buf0->numEntries[lineNum], buf0->numEntries[lineNum]);
#endif
	    }
	}
	for (n=0; n<buf0->numPrinters; n++){
	    if ((i = memcmp(&buf0->data[n].numJobs, &copyofbuf0->data[n].numJobs, sizeof(int))) != 0)
		if ( verbose )
		    printf ("numjobs waiting for pickup changed from %d to %d for %s\n",
			    copyofbuf0->data[n].numJobs, buf0->data[n].numJobs, buf0->data[n].printer);
	    if (buf0->oldestJobTime[n] != 0)
		buf0->data[n].oldestJob = (time((long *)0) - buf0->oldestJobTime[n])/60;
	}
	if ((i = memcmp(copyofbuf0, buf0, sizeof(struct databuf)))!=0){
	    change = TRUE;
	    buf0->mtime[0] = time(NULL);		    /* update buffers last mod time */
	    if ( verbose )
		printf ("in %s new buf0 info is ready\n", argv[0]);
	}
	if (change){
	    semsetall(sid_readReady);			    /* tell all clients a buffer has changed */
	    for (n=0; n<MAX_READERS; n++)		    /* set up to signal all clients */
		if (clientList[n])			    /* if client active */
		    if (kill(clientList[n], SIGUSR1) < 0)   /* send SIGUSR1 signal */
			if (errno == ESRCH)		    /* will return ESRCH if */
			    clientList[n] = 0;		    /* client has gone away */
			else
			    syserr("kill call in server", NULL,NULL);
	}
	memcpy(copyofbuf0, buf0, sizeof(struct databuf));	    /* save status region for later comparison */
    waitAwhile:
	end_time = time(NULL);
	if (end_time - start_time >= 2) goto doAgain;

#ifdef DEBUG	printf("&&&&&&&&&&&&&&& sleeping &&&&&&&&&&&&&&&&&&&\n");
#endif
	sleep(1);
    }							    /* for (;;) */
}

static int opensemset(key, nsems)
int nsems;
key_t key;
{
    int sid;
    int flags;

    flags = 0777 | IPC_CREAT | SEM_UNDO;

    if ((sid = semget(key, nsems, flags)) == -1){
        perror("opensemset");
	return(-1);
    }
    return(sid);
}

static int getsemset(key, nsems, name)
int nsems;
key_t key;
char *name;
{
    int sid;

    if ((sid = opensemset(key, nsems))==-1){                  
	if (errno == EINVAL) {				    /* if call fails then... */
	    if ((sid = semget(key, 0, 0777))>=0){	    /* try opening existing set with unknown # sems and... */
		rmsem(sid);				    /* remove this id and... */
		if ((sid = opensemset(key, nsems))==-1){    /* try to create another new set */
		    sprintf (errmsg,
			    "second semget for %d sems in %s set", 
			    nsems, name);
		    syserr(errmsg, NULL, NULL);
		    exit(-1);
		}
	    }
	}
	else {
	    sprintf(errmsg,"semget for %d sems in %s set", nsems, name);
	    syserr(errmsg, NULL, NULL);
	    exit(-1);
	}
    }
    return(sid);
}
mymemcmp(a, b, n)
char *a, *b;
int n;
{
    int i;
    
    for (i=0; i!=n; i++)
	if (*a != *b)
	    printf("error at byte #%d\n", i);
}
