
#include "../lp.h"
#include "../lps.h"
#include "../buffer_names.h"
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/IntrinsicP.h>
#include <X11/ShellP.h>
#include <X11/Vendor.h>
#include <X11/VendorP.h>

extern int motion;
extern char   label[64];
extern Dimension width, offset;
extern Widget topLevel;
extern Dimension height;
extern struct oldval OldVal[MAX_QUEUES];
extern int    status_page_size[MAX_QUEUES];
extern Widget new_window[MAX_QUEUES], new_outer[MAX_QUEUES], fileName[MAX_QUEUES], new_text[MAX_QUEUES];
extern int    slot[MAX_QUEUES][4];
extern Arg    args[15];
extern XFontStruct *font5x8;
extern struct outputage outputAge;
extern int screen_width, screen_height;
extern Bool ControlTerm, writeAccess;
extern void getformWnH();
extern int ret_width, ret_height;

struct popupIds popupIDs[MAX_QUEUES];
char   geometry_string[16];
char   label_string[132];

void getcoreWnH(lw)
ApplicationShellWidget lw;
{
    int i;
    Widget parent;
    parent = lw->core.parent;
    ret_width = lw->core.width + (lw->core.border_width * 2);
    ret_height = lw->core.height + (lw->core.border_width * 2);
/*    getcoreWnH(parent);*/
}

void clearOutputAge(w, Client_data, Call_data)
Widget w;
XtPointer Client_data, Call_data;
{
    int i = (int)Client_data;

    printf ("clearing line %d in output age window\n", (int)Client_data);
    sprintf(label_string, "\0");
    buf0->data[i].oldestJob = 0;
    buf0->data[i].numJobs = 0;
    buf0->oldestJobTime[i] = 0;
    XtVaSetValues(outputAge.dataLine[i].numJobs, XtNlabel, label_string, NULL);
    XtVaSetValues(outputAge.dataLine[i].oldestJob, XtNlabel, label_string, NULL);
    
}

createPopupStructures()
{
    int   i, lineNum;
    Widget unused;
    static XawTextSelectType sarray[] = {XawselectLine, XawselectNull};

    for (i=1; i<buf0->nitems; i++){
	popupIDs[i].outerShell = XtVaCreatePopupShell("popupwindow",
						       transientShellWidgetClass,
						       topLevel,
						      XtNiconName,  buf0->queNames[i],
						       NULL);
	popupIDs[i].box = XtVaCreateManagedWidget("box",
						  panedWidgetClass,
						  popupIDs[i].outerShell,
						  XtNallowResize, TRUE,
						  NULL);
	popupIDs[i].title = XtVaCreateManagedWidget("title",
						     labelWidgetClass,
						     popupIDs[i].box,
						     NULL);
/*
 * Build the filename label for the popup window
 */
	strcpy(label_string, "Spool Directory = ");
	strcat(label_string, buf0->qdata[i][SDI]);
	strcat(label_string, "\nAssigned to ");
	if (buf0->qdata[i][LPI][0] == NULL ) {
	    strcat(label_string, buf0->qdata[i][RMI]);
	    strcat(label_string, ":");
	    strcat(label_string, buf0->qdata[i][RPI]);
	}
	else
	    strcat(label_string, buf0->qdata[i][LPI]);
	if (strlen(label_string)>sizeof(label_string))
	    syserr("label_string too long in createPopupStructures", NULL, NULL);
	popupIDs[i].fileName = XtVaCreateManagedWidget ("FileName",
							labelWidgetClass,
							popupIDs[i].box,
							XtNfromVert, popupIDs[i].title,
							XtNlabel,     label_string, /* LABEL for child window */
							XtNfont, font5x8,
							NULL);
	popupIDs[i].textArea = XtVaCreateManagedWidget ("Text",
							asciiTextWidgetClass,
							popupIDs[i].box,
							XtNheight,      height-35,
							XtNfromVert,    popupIDs[i].fileName,
							XtNscrollVertical, XawtextScrollWhenNeeded,
							XtNfont, font5x8,
							NULL);
	copyWindowIDs(i);
	status_page_size[i] = SHMSIZE;
	sprintf (label_string, "<Btn1Up>: extend-end() get_selection(%d)\n\
<Btn3Up>: extend-end() get_selection(%d)", i, i);
	XtOverrideTranslations (popupIDs[i].textArea, XtParseTranslationTable(label_string));
	XawTextSetSelectionArray(popupIDs[i].textArea, sarray);
    }
/*
 * now for the output age window
 */
    outputAge.shell = XtVaCreatePopupShell("outputAge", 
					   transientShellWidgetClass,
					   topLevel, 
					   XtNallowShellResize, (XtArgVal) FALSE,
					   XtNiconName, "Output Job Ageing",
					   NULL);

    outputAge.form = XtVaCreateManagedWidget(
					     "form",	    /* widget name */
					     formWidgetClass, /* widget class */
					     outputAge.shell,	    /* parent widget*/
					     XtNborderWidth,     (Dimension) 1,
					     NULL);	    /* argument list*/
 
    outputAge.heading = XtVaCreateManagedWidget("NoServer",
						labelWidgetClass,
						outputAge.form,
						XtNlabel, "Output Pickup Ageing",
						XtNjustify, XtJustifyCenter,
						XtNwidth, 230,
						NULL);
    outputAge.title1 = XtVaCreateManagedWidget ("outputAge",
						labelWidgetClass,
						outputAge.form,
						XtNfromVert, outputAge.heading,
						XtNjustify, XtJustifyCenter,
						XtNwidth,       75,
						XtNlabel, "\nPrinter",
						NULL);
    outputAge.title2 = XtVaCreateManagedWidget ("Title",
						labelWidgetClass,
						outputAge.form,
						XtNfromVert, outputAge.heading,
						XtNfromHoriz, outputAge.title1,
						XtNjustify, XtJustifyCenter,
						XtNwidth,     70,
						XtNlabel, "\n# Jobs",
						NULL);
    outputAge.title3 = XtVaCreateManagedWidget ("title",
						labelWidgetClass,
						outputAge.form,
						XtNfromVert, outputAge.heading,
						XtNfromHoriz, outputAge.title2,
						XtNjustify, XtJustifyCenter,
						XtNwidth,       70,
						XtNlabel, "Oldest\nJob Age",
						NULL);
    unused = outputAge.title1;
    for (i=0; i<buf0->numPrinters; i++){
	outputAge.dataLine[i].prntrName = XtVaCreateManagedWidget(
						    "printer", /* widget name */
						    commandWidgetClass,	/* widget class */
						    outputAge.form,		/* parent widget*/
						    XtNfromVert,    unused,
						    XtNwidth,       75,
						    XtNborderWidth,     (Dimension) 1,
						    XtNlabel, buf0->data[i].printer,
						    NULL);		/* argument list*/
	sprintf (label, "<Leave>: unprompt() reset()");
	XtOverrideTranslations (outputAge.dataLine[i].prntrName, XtParseTranslationTable(label));
	sprintf (label, "<Enter>: prompt(%d,%d,%s) highlight()", i, 5, buf0->data[i].printer);
	XtOverrideTranslations (outputAge.dataLine[i].prntrName, XtParseTranslationTable(label));
	sprintf(label_string, "%d", buf0->data[i].numJobs);
	outputAge.dataLine[i].numJobs = XtVaCreateManagedWidget(
								"numjobs",
								labelWidgetClass,
								outputAge.form,
								XtNfromVert, unused,
								XtNwidth,       70,
								XtNfromHoriz, outputAge.dataLine[i].prntrName,
								XtNlabel, label_string,
								NULL);
	if (buf0->data[i].numJobs != 0)
	    sprintf(label_string, "%d min", buf0->data[i].oldestJob);
	else
	    sprintf(label_string, "0 min");
	outputAge.dataLine[i].oldestJob = XtVaCreateManagedWidget(
						     "oldest",
						     labelWidgetClass,
						     outputAge.form,
						     XtNfromVert, unused,
						     XtNfromHoriz, outputAge.dataLine[i].numJobs,
						     XtNwidth,       70,
						     XtNlabel, label_string,
						     NULL);
	unused = outputAge.dataLine[i].prntrName;
    }

/*
 * now set the command widgets sensitivity to off if we are not a control term.
 * The control term list is taken from the application resource database.
 */
    for (i=0; i<buf0->numPrinters; i++)
	if (!writeAccess)		                            /* if we are not a control term */
	    XtSetSensitive(outputAge.dataLine[i].prntrName, FALSE);
	else
	    XtAddCallback(outputAge.dataLine[i].prntrName , XtNcallback, clearOutputAge, i);

    XtSetMappedWhenManaged(outputAge.shell, FALSE);         /* Turn off mapping so we can... */
    XtRealizeWidget(outputAge.shell);			    /* realize widget without it being seen */
    getcoreWnH(outputAge.shell);			    /* get width and height from core structure*/
    XtMoveWidget(outputAge.shell,			    /* compute new x & y */
		 (Position)screen_width-ret_width, 
		 (Position)screen_height-ret_height);
    outputAge.x = screen_width-ret_width;
    outputAge.width = ret_width;
    outputAge.y = screen_height-ret_height;
    outputAge.height = ret_height;
    XtPopup(outputAge.shell, XtGrabNone);		    /* now popup really onlyfinishes mapping */
}

/*
 * routine to copy widget IDs of the popup windows to the new_window structures
 */
copyWindowIDs(num)
int  num;
{
    new_window[num] = popupIDs[num].outerShell;
    new_outer[num]  = popupIDs[num].box;
    fileName[num]   = popupIDs[num].fileName;
    new_text[num]   = popupIDs[num].textArea;
}

/* popup up a new window */

void popupWindow(windowNum)
int windowNum;
{
    XWindowAttributes window_attributes;
    int  i;
    unsigned int ix, iy;
    XtWidgetGeometry request, reply;

/* make sure the window isnt already realized */

    if (OldVal[windowNum].isrealized){
	fprintf(stderr, "Warning - Trying to popup a window that is already realized");
	return;
    }
    XtSetArg(args[0], XtNlabel, buf0->queNames[windowNum]);
    XtSetValues(popupIDs[windowNum].title, args, 1);

/* now find an empty screen slot for child window */

    for (i=0; i<MAX_QUEUES; i++)
	if(slot[i][STAT] == AVAIL) break;
    if (i >= MAX_QUEUES){
	XBell(XtDisplay(topLevel),0);
	fprintf (stderr, "WARNING - no new window slots available\n");
	return;
    }
    slot[i][STAT] = NOTAVAIL;				    /* mark the window location as used */
    slot[i][NUM]  = windowNum;
    ix = slot[i][X] + motion;
    iy = slot[i][Y] + motion;
    request.request_mode = CWX | CWY | CWWidth | CWHeight;
    request.x = ix;
    request.y = iy;
    request.width = width;
    request.height = height - 2;                   /* allow for borders */
    XtMakeGeometryRequest(popupIDs[windowNum].outerShell, &request, &reply);
    sprintf(geometry_string,"+%d+%d",ix,iy);
    XtSetArg(args[0], XtNgeometry, geometry_string);
    XtSetValues(popupIDs[windowNum].outerShell, args, 1);   
    XtPopup (popupIDs[windowNum].outerShell ,XtGrabNone);
    XtMoveWidget(popupIDs[windowNum].outerShell, ix, iy);
    OldVal[windowNum].isPopedUp = TRUE;			    /* Mark the window as poped up */
}

void popdownWindow(windowNum)
int windowNum;
{
    int   i;

/* Make sure the window is really poped up and not realized */

    if (!OldVal[windowNum].isPopedUp){
	fprintf(stderr, "Warning - Trying to popdown a window that is not poped up");
	return;
    }
    if (OldVal[windowNum].isrealized){
	fprintf(stderr, "Warning - Trying to popdown a window that is realized");
	return;
    }

    XtPopdown (popupIDs[windowNum].outerShell);
/*    buf0->oldestJob[windowNum] = -1;*/
    for (i=0; i<MAX_QUEUES; i++)
	if (slot[i][NUM] == windowNum){
	    slot[i][STAT] = AVAIL;
	    goto foundit;
	}
    fprintf (stderr, "Warning - Cant find popupID in slot structure for popdown");
 foundit:
    OldVal[windowNum].isPopedUp = FALSE;
}

