.TH outputAge 1 "X-based line printer output pickup ageing display program" "X11R4"
.SH Name
outputAge \- An X-based program to display the number of print jobs waiting
for pickup and the age in minutes of the oldest job.
.SH Description
This program was created to assist central print facility operators working
in a large print server facility where any number of operators are
collecting the output from any number of printers and distributing it to
various distribution points.
.PP
\fIoutputAge\fP is also part of the main display of lps(1). That portion of
the program that pertained only to output job ageing was excerpted from the
main program and compiled and linked to run seperately for those operator
supervisors and managers who only wanted to keep tabs on the status of
output print job pickup, and weren't interested is having the entire
\fIlps\fP display on their display screen.
.PP
\fIoutputAge\fP takes advantage of the client/server design of the main
\fIlps\fP system.  The \fIserver\fP collects the data and stores it already
formatted in shared memory sections which are then available to any program
with the right privileges and that knows the key number of the appropriate shared
memory section.
.PP
Users with the right set of privileges, and that meet a certain set of
criteria, are given write access to the windows for the purpose of zeroing
the statistics. The full set of criteria to be met is: A) user must belong
to group \fIoperator\fP, and B) users display station must be specified in
the X application resource *controlTerm. This resource must be specified in
the applications default resource file /usr/lib/X11/app-defaults/LpsV2.
Clicking on the printer name will zero the statistics for that printer.  If
the user dows not meet the above criteria, then the printer name colume
will be grey scaled in that users outputAge window and the window will be read-only.
.SH Syntax
outputAge[option[s]]
.br
Because \fIoutputAge\fP is part of the \fIlps\fP client/server set of
programs the \fIserver\fP program must be running.
.SH Options
\fIoutputAge\fP honors most standard X command line options and switches
(see \fIbugs\fP below).
.SH Example
outputAge -geom +0+0
.br
The above example invokes the program, locating its resulting window in the
upper left hand corner of the users screen.
.SH Environment
This suite of programs has been built and run under most SunOs and DEC
ULTRIX systems using TWM and TVWM window managers. Running the program
under Motif or OpenLook can produce some weird results, depending on the
settings of certain(??) window manager variables. We have not attempted to
run these programs under the DECWINDOWS Window Manager.

.SH See Also
lps(1), lpsV2(1), server(1), lpinfo(1)
.SH Errors
All error messages are sent to stderr.
.SH Bugs
Does not handle window resizes or geometry changes gracefully.
.SH Copyright
1991 at NASA-Ames Research Center. Some portions of this program were
taken from the Berkeley spooler programs and from certain programs
contained in the MIT X11R4 release. Individual copyrights have been
reproduced for those portions affected.
.SH Author
.EX
Roger Smith
NASA-Ames Research Center
Mail Stop 233-10
Moffett Field, Ca. 94035
EMAIL: rsmith@george.arc.nasa.gov

REFER ANY PROBELMS OR BUG REPORTS TO:
	Roger Smith  x4-3583 or rsmith@george.arc.nasa.gov
	Ken Burgess  x4-6347 or kburgess@franklin.arc.nasa.gov
.EE

.SH Release
V1-1 March 1991
