
#include "../lps.h"
/*
 *  So that we can use fprintf:
 */
#include <stdio.h>
#include <signal.h>
#include <sys/resource.h>

/* 
 * Standard Toolkit include files:
 */
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Shell.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <sys/sem.h>
#include <sys/shm.h>
#include <time.h>
#ifndef ENOENT
#include <errno.h>
#endif
#ifndef NULL
#define NULL 0
#endif
#ifndef Bool
typedef ushort Bool;
#endif
#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif
#define ERR ((struct databuf *) -1)

extern char **environ;

struct databuf {
    time_t mtime;
    char buf[1024];
}*buffer[4];

time_t mtime[4];
char *asctime();
struct tm *localtime();

extern int clientNum;
extern long key;
extern int sid, sid_control, sid_readReady, sid_writeLock, sid_clientActive;
extern int  clientNum;
extern int pid;
extern int signOn();

char   status_page[64];
int    status_page_size[32];
Widget       new_text[32];
Widget       fileName[32], lastTime[32];
Widget       new_window[32];
Widget       new_outer[32];
Widget       Qquit[32];
Widget       topLevel, form;
Widget       warning, noServer;
Display *display;
XtAppContext app_context;
XtAppContext formApp[16];
int          context_count=0;
XtIntervalId intervalID[32];
XtIntervalId quitSoon, DoAgainintervalID;
int          slot[32][4];
Dimension    width=220, height=100;
int          interval = 1;
Bool         miss = FALSE;
Bool         warningVisible = FALSE;
char         *myargv;

static XtTimerCallbackProc mainLoop(client_data, id)
caddr_t client_data;
XtIntervalId *id;
{
    int i, rdy;

    if ((i = semgetval(sid_control, 0))<0)                  /* make sure server is alive */
	syserr("semgetval in client", NULL, NULL);
    if (!i){						    /* if i=0 server has died */
	if (!warningVisible) XtPopup(warning, XtGrabNone);  /* popup warning window */
	warningVisible = TRUE;				    /* set flag */
	XBell(XtDisplay(topLevel), 0);			    /* hit the gong */
	interval = 5;					    /* reset intervat so bell dont ring so often */
    }
    else						    /* come here when i != 0, i.e. server is alive now */
	if(warningVisible){				    /* if warning window is poped up */
	    XtPopdown(warning);				    /* pop it down */
	    warningVisible = FALSE;			    /* reset flag */
	    signOn(&myargv);				    /* must re-register with new server */
	    semdec(sid_readReady, clientNum);		    /* unset readReady flag */
	    interval = 1;				    /* set interval back to normal */
	}
    DoAgainintervalID = XtAppAddTimeOut (app_context, (unsigned long) (interval*1000), mainLoop, (caddr_t) 0);
}

static serviceData(sig)
unsigned  sig;
{

    int i;
    char myName[16];
    extern char *sys_siglist[];
    struct itimerval it;

    signal(SIGALRM, SIG_IGN);				    /* ignore further signals */
    setpriority(PRIO_PROCESS, pid, -10);                    /* raise our priority */
#ifdef DEBUG
    printf("caught signal #%d in %s%d: %s\n", 
	    sig, myargv, clientNum, sys_siglist[sig]);
#endif
    if ((i = semgetval(sid_readReady, clientNum)) < 0)	    /* see if new data is ready */
	syserr("semgetval in windows of client", NULL, NULL);
    if (i){			                            /* if new data is ready... */
	for (i=0; i<4; i++){				    /* set up to scan all buffers */
	    if(mtime[i] != buffer[i]->mtime){		    /* new time stamp in this buffer??? */
		XtVaSetValues(new_text[i], 
			      XtNstring, buffer[i]->buf, 
			      NULL);			    /* display new data on screen */
		mtime[i] = buffer[i]->mtime;		    /* remember this update time */
		XtVaSetValues(lastTime[i],		    /* print it to screen */
			      XtNlabel, asctime(localtime(&mtime[i])), 
			      NULL);
		XFlush(display);
	    }						    /* if (mtime...) */
	}						    /* for (i=0 ...) */
	semdec(sid_readReady, clientNum);		    /* unset readReady flag */
    }							    /* if (i) */
    setpriority(PRIO_PROCESS, pid, 0);			    /* restore default priority */
    signal(SIGALRM, serviceData);			    /* reset signal catching */
/*    if (miss) setitimer(ITIMER_REAL, &it, (struct itimerval *) NULL);*/
    return;
}

void quit(w, client_data, call_data)
Widget w;
XtPointer client_data; 
XtPointer call_data;
{
    exit(0);
}

do_windows(argc, argv)
int argc;
char *argv[];
{
    extern int errno;
    int shmid[4], i, pid;
    XWindowAttributes window_attributes;
    Position new_x, new_y;
    char  geometry_string[16], warning_geometry[16];
    char  iconname[64];
    int screen;
    Window root;
    Widget top;
    int status;
    Cursor cursor;
    XEvent event;
    int button = 0;
    char newstring[1024];

    myargv = *argv;
    if ((display = XOpenDisplay(NULL))==0)                           /* open display, connect to server */
	syserr("Display variable not set", NULL, NULL);
    screen = DefaultScreen(display);
    XSynchronize(display, TRUE);			    /* turn on synchronization */
    root = RootWindow(display, screen);			    /* get id of root */
    cursor = XCreateFontCursor (display, XC_crosshair);	    /* create another cursor shape */
    status = XGrabPointer (display, root, FALSE,	    /* Grab pointer with new cursor, allow ptr to roam all over */
			   ButtonPressMask|ButtonReleaseMask, GrabModeSync,
			   GrabModeAsync, root, cursor, CurrentTime);
    if (status != GrabSuccess) printf("FATAL, cant grab mouse\n"), exit();
    printf ("Place cursor to where you want the upper-left-hand corner of the new window to go\n\
and press left mouse\n");
    for (;;){
	XAllowEvents(display, SyncPointer, CurrentTime);    /* pop an event from the event queue */
	XWindowEvent(display, root, ButtonPressMask|ButtonReleaseMask, &event);	/* copy it to our structure */

	switch (event.type){				    /* process it if... */
	case ButtonPress:				    /* it was a button press. ignore all other events */
	    printf ("ButtonPress #%d found. x = %d, y = %d\n", 
		    event.xbutton.button, event.xbutton.x_root, event.xbutton.y_root);
	    button = event.xbutton.button;
	    while (1){					    /* wait for button release of same button */
		XAllowEvents(display, SyncPointer, CurrentTime);
		XWindowEvent(display, root, ButtonPressMask|ButtonReleaseMask, &event);
		if (event.xbutton.button == button){
		    XUngrabPointer(display, CurrentTime);   /* let go of pointer */
		    XSynchronize(display, FALSE);	    /* turn off synchronization */
		    break;				    /* break out of while(1) */
		}
	    }
	    break;					    /* break out of switch */
	}
	break;						    /* break out of for(;;) */
    }
    printf ("ButtonRelease #%d found. x = %d, y = %d\n", 
	    event.xbutton.button, event.xbutton.x_root, event.xbutton.y_root);
    XCloseDisplay(display);				    /* disconnect from server */

    sprintf(geometry_string,"%dx%d+%d+%d",width, height, event.xbutton.x_root, event.xbutton.y_root);
    sprintf(iconname, "Client #%d", clientNum);
    topLevel = XtVaAppInitialize(
				 &app_context,       /* Application context */
				 "LpsV1",            /* application class name */
				 NULL, 
				 NULL,            /* command line option list */
				 &argc, argv,        /* command line args */
				 NULL,               /* for missing app-defaults file */
				 XtNx,  (Position) 1,
				 XtNy,  (Position) 2,
				 XtNgeometry, geometry_string,
				 XtNiconName,  iconname,
				 NULL);              /* terminate varargs list */

    form = XtVaCreateManagedWidget(
		"form", 	/* widget name */
		formWidgetClass,	/* widget class */
		topLevel,	/* parent widget*/
		XtNborderWidth,     (Dimension) 1,
		NULL);	/* argument list*/

    Qquit[0] = XtVaCreateManagedWidget("Quit", 
				       commandWidgetClass,
				       form,	/* parent */
				       XtNlabel,  "Quit",
				       XtNwidth, 50,
				       XtNheight, 25,
				       XtNallowResize, TRUE,
				       NULL);

    XtAddCallback(Qquit[0], XtNcallback, quit, 0);
    XtRealizeWidget(topLevel);
    XFlush(XtDisplay(topLevel));

/* now build a popup window for later display */

    sprintf(warning_geometry,"%dx%d+%d+%d",width-30, height-65, event.xbutton.x_root+20, event.xbutton.y_root+30);
    warning = XtVaCreatePopupShell("warning", 
				    transientShellWidgetClass,
				    form, 
				    XtNborderWidth,  (Dimension) 10,
				    XtNallowShellResize, (XtArgVal) FALSE,
				    XtNgeometry, warning_geometry,
				    NULL);

    noServer = XtVaCreateManagedWidget("NoServer",
					    labelWidgetClass,
					    warning,
					    XtNlabel, "WARNING - Server\nmalfunction",
					    XtNjustify, XtJustifyCenter,
					    NULL);

    XFlush(XtDisplay(topLevel));

    XGetWindowAttributes (XtDisplay(topLevel),
			  XtWindow(topLevel),
			  &window_attributes);
    XtTranslateCoords(topLevel, window_attributes.x, window_attributes.y, &new_x, &new_y);

    for (i=0; i<4; i++){
	if ((shmid[i] = shmget(key+i, sizeof(struct databuf), 0644)) <0)
	    syserr("shmget in client",NULL,NULL);	    /* get a shared memory region */

	printf ("in %s shmid%d = %d\n", argv[0], i, shmid[i]);
	if ((buffer[i] = (struct databuf *) shmat(shmid[i], 0, 0)) == ERR) /* attach to it */
	    syserr("shmat in client", NULL, NULL);
	if (semwait(sid_writeLock, i) != 0) syserr("semwait in client", NULL, NULL); /* take out a lock on this buffer */
	mtime[i] = buffer[i]->mtime;			    /* remember last update time */
	printf ("shmem region #%d = %s\n", i, buffer[i]->buf);
	sprintf(geometry_string,"%dx%d+%d+%d",width, height, event.xbutton.x_root, (height+30)*(i+1));
	sprintf(iconname, "Client #%d, Child #%d", clientNum, i);
	new_window[i] = XtVaAppCreateShell(NULL, do_windows, applicationShellWidgetClass, 
					   XtDisplay(topLevel),
					   XtNwidth,  width,
					   XtNheight, height,
					   XtNiconName,  iconname,
					   XtNallowShellResize, TRUE,
					   XtNgeometry, geometry_string,
					   NULL);

	new_outer[i] = XtVaCreateManagedWidget("new_outer",
					panedWidgetClass,
					new_window[i],
					XtNallowResize, TRUE,
					NULL);
/*
 * Build the label for the child window
 */
	sprintf(iconname, "Contents of shared memory region #%d", i);
	fileName[i] = XtVaCreateManagedWidget("FileName",
				       labelWidgetClass,
				       new_outer[i],
				       XtNlabel,     iconname, /* LABEL for child window */
				       XtNallowResize, TRUE,
				       NULL);

	lastTime[i] = XtVaCreateManagedWidget("FileName",
					      labelWidgetClass,
					      new_outer[i],
					      XtNlabel,     asctime(localtime(&mtime[i])), /* LABEL for child window */
					      XtNfromVert, fileName[i],
					      XtNallowResize, TRUE,
					      NULL);

	new_text[i] = XtVaCreateManagedWidget ("Text", 
					       asciiStringWidgetClass, 
					       new_outer[i],
					       XtNheight, height-35,                     /* set height of text box */
					       XtNfromVert, lastTime[i],
					       XtNstring,   buffer[i]->buf,
					       XtNtextOptions, scrollVertical,           /* add scroll bar */
					       XtNallowResize, TRUE,
					       NULL);
	Qquit[i+1] = XtVaCreateManagedWidget("Quit", 
				   commandWidgetClass,
				   new_outer[i],	/* parent */
				   XtNfromVert,   new_text[i],
				   XtNlabel,  "Quit",
				   XtNallowResize, TRUE,
				   NULL);

	XtAddCallback(Qquit[i+1], XtNcallback, quit, i+1);

	XtPopup(new_window[i],XtGrabNone);
	XFlush(XtDisplay(topLevel));
	if (seminc(sid_writeLock, i) != 0) syserr("seminc in client", NULL, NULL); /* release lock */
    }
    DoAgainintervalID = XtAppAddTimeOut (app_context, (unsigned long) (interval*1000), mainLoop, (caddr_t) NULL);
    signal(SIGALRM, serviceData);			    /* set signal catching */
    semdec(sid_readReady, clientNum);		    /* unset readReady flag */
    XtAppMainLoop(app_context);
}
