#include <stdio.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <sys/sem.h>
#include <sys/shm.h>
#include <time.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <signal.h>

#ifndef ENOENT
#include <errno.h>
#endif
#ifndef NULL
#define NULL 0
#endif
#ifndef Bool
typedef ushort Bool;
#endif
#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

#define MAX_READERS 12
#define MAX_BUFFERS NUMQUEUES+2
#define ERR ((struct databuf *) -1)

struct databuf {
    time_t mtime;
    char buf[1024];
}*buffer[4];
extern char **environ;
extern void printenv();

struct sembuf setflag;

int sid, sid_control, sid_readReady, sid_writeLock, sid_clientActive;
int shmid[4];
int clientList[MAX_READERS];

main (argc, argv)
int argc;
char *argv[];
{ 
    extern int errno;
    long key;
    char **eptr;
    int i, n;
    char   path[12];
    int qid, retval;
    int status = 0;
    int fd[4];
    struct stat sb;
    struct mymsg {
	long mtype;
	char c_clientNum[12];
    } msg;
    int flags;
    int clientNum = 0;
    char myName[16];
    Bool change;
    int  line;
    int pgrp;

    setflag.sem_num = 0;
    setflag.sem_op = 1;
    setflag.sem_flg = SEM_UNDO;
    flags = 0777 | IPC_CREAT | SEM_UNDO;

    pgrp = getpgrp(0);
    printf ("in server pgrp = %d\n", pgrp);
    if (setpgrp(NULL, 28)<0)
	syserr("setpgrp in server", NULL, NULL);
    pgrp = getpgrp(0);
    printf ("in server setpgrp pgrp = %d\n", pgrp);
    key = getkey();
    printf ("in %s key = %d\n", argv[0], key);

/* now attempt to open some semaphore sets. */
         
    if ((sid_control=opensemset(key))==-1){                  
	syserr("semget for control set", NULL, NULL);
	exit(-1);
    }
    printf ("in %s opensemset succeeded, sid_control = %d\n", argv[0], sid_control);
    if ((sid_readReady = semget(key+1, MAX_READERS, flags)) == -1){
	syserr("semget for readReady set", NULL, NULL);
	exit(-1);
    }
    printf ("in %s opensemset succeeded, sid_readReady = %d\n", argv[0], sid_readReady);
    if ((sid_writeLock = semget(key+2, MAX_BUFFERS, flags)) == -1){
	syserr("semget for writeLock set", NULL, NULL);
	exit(-1);
    }
    printf ("in %s opensemset succeeded, sid_writeLock = %d\n", argv[0], sid_writeLock);
    if ((sid_clientActive = semget(key+3, MAX_READERS, flags)) == -1){
	syserr("semget for clientActive set", NULL, NULL);
	exit(-1);
    }
    printf ("in %s opensemset succeeded, sid_clientActive = %d\n", argv[0], sid_clientActive);
/*
  now get and attach the shared memory regions
*/
    for (i=0; i<4; i++){
	if ((shmid[i] = shmget(key+i, sizeof(struct databuf), 0777|IPC_CREAT)) <0)
	    syserr("shmget1 in shmem",NULL,NULL);

	printf ("in %s shmid%d = %d\n", argv[0], i, shmid[i]);
	if ((buffer[i] = (struct databuf *) shmat(shmid[i], 0, 0)) == ERR)
	    syserr("shmat in shmem", NULL, NULL);
	if (seminc(sid_control, 2)<0)	                            /* inc shmem region count */
	    syserr("seminc in server", NULL, NULL);
	sprintf(path, "./test%d", i+1);
	if ((fd[i] = open(path, O_RDONLY)) == -1)
	    syserr("open in shmem", NULL, NULL);
	if ((n=read(fd[i],buffer[i]->buf,sizeof(buffer[i]->buf)))<=0)
	    syserr("read in shmem", NULL, NULL);
	printf ("in %s read %d characters from %s on fd %d\n", argv[0], n, path, fd[i]);
	buffer[i]->buf[n]=NULL;
	if (stat(path, &sb) == -1)
	    syserr("stat in shmem", NULL, NULL);
	buffer[i]->mtime = sb.st_mtime;
	close(fd[i]);
    }
/* 
  now make sure control flag #0 is off (set to 0).  If it is set to >0 then
  another server is still running.
*/
    if ((i = semctl(sid_control, 0, GETVAL, 0)) == -1)
	syserr("semctl of control set in server", NULL, NULL);
    if (i != 0)
	syserr("Control Flag 0 set on entry! Another server must still be running.", NULL, NULL);
/*
  Now set flag #0 to show that we are alive.
*/
    if ((status = semop(sid_control, &setflag, 1))==-1)
	syserr("semop in server", NULL, sid_control);
#define LINE #line
    line = __LINE__;
    printf ("in %s after semop status = %d at line %d\n", argv[0], status, line);
/*
  And clear the sid_clientActive set in case this is a restart
*/
    if (semclrall(sid_clientActive)<0)
	syserr("semclrall in server", NULL, NULL);
    if (semclr(sid_control, 1)<0)			    /* clear numClients counter */
	syserr("semclr of control flag 1 in server", NULL, NULL);
/*
  Now create a message queue to be used for clients to notify us
  of their existance. When we get notification we respond by 
  sending the new client its client number.
*/
    if ((qid = msgget((key_t)key, 0777|IPC_CREAT)) == -1)
	syserr ("msgget in server", NULL, NULL);
    if (semsetall(sid_writeLock)!=0)		    /* init writeLock flags to 1 */
	syserr("semsetall in server", NULL, NULL);

/***************** MAIN LOOP ***************/

    for (;;){
/*
  first check to see if any new clients are asking for recognition.
*/
	if ((retval = msgrcv(qid, &msg, sizeof(msg), (long)1, IPC_NOWAIT)) == -1)
	    if (errno != ENOMSG) syserr ("msgrcv in server", NULL, NULL);
	if (retval>0){					    /* if msg_type (long)1 was ok */
	    printf ("in server, received a %d byte msg with mtype = %d, msg = %s\n",
		    retval, msg.mtype, msg.c_clientNum);    /* for received msgs, body contains pid of sender... */
	    if (msg.mtype != 1){			    /* if mtype != 1, msg wasnt for us... */
		if ((retval = msgsnd(qid, &msg, sizeof(msg), 0)) == -1) /* resend msg  *NOTREACHED* if msgrcv worked */
		    syserr ("msgsnd in server", NULL, NULL);
	    }
	    else{					    /* process message */
		msg.mtype = atoi(msg.c_clientNum);	    /* to be used as mtype for response */
		for (i=0; i<MAX_READERS; i++){		    /* set up to find first empty clientNum */
		    if ((semctl(sid_clientActive, i, GETVAL, 0)) == 0){/* sequence through the clientActive flags */
			sprintf(msg.c_clientNum, "%d", i);  /* reset body to new clientNum */
			clientList[i] = msg.mtype;	    /* remember this clients pid */
			break;
		    }
		}
		if (i > MAX_READERS-1)			    /* if we run out of flags... */
		    sprintf(msg.c_clientNum, "%d", -1);	    /* set error return */
		printf ("in server sending msg with mtype = %d, decimal clientNum = %d, string clientNum = %s\n", 
			msg.mtype, i, msg.c_clientNum);
		if ((retval = msgsnd(qid, &msg, sizeof(msg), 0)) == -1)
		    syserr ("msgsnd in server", NULL, NULL); /* send clientNum msg to client */
	    }						    /* else */
	}			                            /* if (retval) */
/*
  next check to make sure all active readers have finished processing the
  most recent update. We do this by checking the clientAlive flag for each client.
  If the clientAlive flag is set AND the readReady flag for that client is also
  set, then that client hasn't finished processing our most recent update.
*/
	for (i=0; i<MAX_READERS; i++){
	    if ((semgetval(sid_clientActive, i)>0) && (semgetval(sid_readReady, i) != 0)){
		printf ("in server, waiting for client %d to finish read\n", i);
		goto waitAwhile;
	    }
	}
/*
  now check to see if there is any new data
*/
	change = FALSE;
	for (i=0; i<4; i++){
	    sprintf(path, "./test%d", i+1);
	    if (stat(path, &sb) == -1)
		syserr("stat in shmem", NULL, NULL);
	    if (buffer[i]->mtime != sb.st_mtime){	    /* if time stamp has changed - process new data */
		change = TRUE;
#ifdef DEBUG
	       	printf ("in shmem, stats have changed\n");
		printf ("Last Access:          %s", asctime(localtime(&sb.st_atime)));
		printf ("Last Modification:    %s", asctime(localtime(&sb.st_mtime)));
		printf ("Last Status Change:   %s", asctime(localtime(&sb.st_ctime)));
#endif
		if ((fd[i] = open(path, O_RDONLY)) == -1)
		    syserr("open in shmem", NULL, NULL);
		semwait(sid_writeLock, i);		    /* wait till buffer avail, then lock */
		if ((n=read(fd[i], buffer[i]->buf, sizeof(buffer[i]->buf)))<=0){
		    if (errno == EINTR){
			close(fd[i]);
			continue;
		    }
		    else
			syserr("read in shmem", NULL, NULL);
		}
		buffer[i]->buf[n]=NULL;
#ifdef DEBUG
		printf ("in %s read %d characters from %s on fd %d\n", argv[0], n, path, fd[i]);
#endif
		buffer[i]->mtime = sb.st_mtime;		    /* update buffers last mod time */
		close(fd[i]);
		seminc(sid_writeLock, i);		    /* release lock */
	    }						    /* if (buffer[i]->mtime != sb.st_mtime) */
	}			                            /* for (i=0; i<4; i++) */
	if (change){
	    semsetall(sid_readReady);			    /* tell all clients buffer has changed */
	    for (n=0; n<MAX_READERS; n++)		    /* set up to signal all clients */
		if (clientList[n])			    /* if client active */
		    if (kill(clientList[n], SIGALRM) < 0)   /* send sigalrm signal */
			if (errno == ESRCH)		    /* will return esrch if */
			    clientList[n] = 0;		    /* client has gone away */
			else
			    syserr("kill call in server", NULL,NULL);
	}
    waitAwhile:
	sleep(1);
    }							    /* for (;;) */
}

static int opensemset(key)
long key;
{
    int sid;
    int flags;

    flags = 0777 | IPC_CREAT | SEM_UNDO;

    if ((sid = semget(key, 3, flags)) == -1){
	syserr("semget", NULL, NULL);
	return(-1);
    }
    return(sid);
}
