#include <stdio.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <sys/sem.h>

#ifndef ENOENT
#include <errno.h>
#endif
#ifndef NULL
#define NULL 0
#endif

extern char **environ;
extern void printenv();
struct sembuf setflag;
struct semid_ds semid_ds;
int sid;

main (argc, argv)
int argc;
char *argv[];
{ 
    extern int errno;
    long key, k;
    char **eptr;
    int i;
    int status = 0;
    int sem_num, retval;
    union semun {
	int val;
	struct semid_ds *buf;
	ushort * array;
    }arg;

    setflag.sem_num = 0;
    setflag.sem_op = 1;
    setflag.sem_flg = SEM_UNDO;

    key = getkey();
    printf ("in %s key = %d\n", argv[0], key);

/* now attempt to open a semaphore set. */
         
    for (k=key; k<key+4; k++){
	if ((sid=openset(k))==-1)                
	    printf ("in %s opensemset failed for key %d\n", argv[0], k);		  
	else{
	    printf ("in %s openset succeeded, sid = %d\n", argv[0], sid);
	    arg.buf = &semid_ds;
	    if ((retval = semctl(sid, 0, IPC_STAT, arg)) == -1)
		syserr("semctl in starter", NULL, sid);
	    if (!(arg.array = (ushort *)malloc((unsigned)(semid_ds.sem_nsems * sizeof(ushort)))))
		syserr("malloc in starter", NULL, NULL);
	    if ((retval = semctl(sid, 0, GETALL, arg)) == -1)
		syserr("semctl in starter", NULL, sid);
	    printf ("SEMNUM SEMVAL SEMPID SEMNCNT SEMZCNT SEMKEY=%d SEMID=%d NSEMS=%d\n", 
		    k, sid, semid_ds.sem_nsems);
	    for (i=0; i<semid_ds.sem_nsems; i++)
		printf ("%6d%7d%7d%8d%8d\n", i, arg.array[i],
			semctl(sid, i, GETPID, 0),
			semctl(sid, i, GETNCNT, 0),
			semctl(sid, i, GETZCNT, 0));
	    free(arg.array);
	}
    }
}


static int openset(key)
long key;
{
    if ((sid = semget((key_t)key, 1, IPC_NOWAIT)) == -1 && errno != ENOENT){
	syserr("semget", NULL, NULL);
	return(-1);
    }
    return(sid);
}
