
#define GETSEMVAL
#include        "../lp.h"
#include	<sys/types.h>
#include <sys/ipc.h>
#undef GETSEMVAL

#ifdef sun
#ifndef KERNEL
#define KERNEL
#endif
#endif sun

#include        <nlist.h>
#include        <sys/sem.h>

#ifdef KERNEL
#undef KERNEL
#endif

#ifndef mips
#include        <kvm.h>
#endif

#include        <fcntl.h>
#include        <sys/user.h>

#ifdef ultrix 
#include        <sys/vm.h>
#endif
    
#define MAXLEN 80
#define SECLIMIT 600
#define HOUR 3600		/* number of seconds in 1 hour */
    
struct   tm timeWeWentDown, timeWeCameUp, tm_start, tm_stop;
time_t      timeWentDown, timeCameUp, t_start, t_stop;
float       down, up, totalTimeDown;
time_t  now;                    /* the current time of day */
struct  timeval boottime;
struct  seminfo seminfo;
time_t  uptime;                 /* time of last reboot & elapsed time since */

struct  nlist nl[] = {
#ifdef sgi
        { "seminfo" },
#else
	{ "_seminfo" },
#endif
#define X_SEMINFO      0
        { "" },
};
#ifdef sun
kvm_t      *kd;
#endif
int        kmem;
char       *prog;

main(argc,argv)
    int argc;
    char **argv;
{
    int	        size, numitems;
    FILE 	*fptr; 
    extern      int errno;
    char        *start="Jun  3 09:00:00 1992";
    char        *stop= "Jun  3 10:00:00 1992";
    int         days, hrs, mins;
    static long loadavg_seek;
    prog = argv[0];

#ifdef sun
    if ((kd = kvm_open(NULL, NULL, NULL, O_RDONLY, prog)) == NULL) {
	exit(1);
    }
    if (kvm_nlist(kd, nl) != 0) {
	fprintf(stderr, "%s: symbols missing from namelist\n", prog);
	exit(1);
    }
#else ifdef ultrix || sgi
    if (( kmem = open("/dev/kmem", 0)) <0 ) {
	perror("ERROR - opening /dev/kmem");
	exit(errno);
    }
#ifdef ultrix
    nlist("/vmunix", nl);
#else
    nlist("/unix", nl);
#endif
#endif

    if ( nl[X_SEMINFO].n_type == 0 ) {
	fprintf(stderr, "%s: '%s' not in namelist\n",
		prog, nl[X_SEMINFO].n_name);
	exit(1);
    }
    size = sizeof(seminfo);


#ifdef sun
    if ( kvm_read(kd, nl[X_SEMINFO].n_value, &seminfo, size) != size ) {
 	fprintf(stderr, "%s: kernel read error\n", prog);
	exit(1);
    }
#endif
#ifdef ultrix 
    lseek(kmem, (long)nl[X_SEMINFO].n_value, SEEK_SET);
    read(kmem, &seminfo, size);
#endif
#ifdef sgi
    loadavg_seek = nl[X_SEMINFO].n_value;
    loadavg_seek &= 0x7fffffff;

    if ( lseek((int)kmem, loadavg_seek, SEEK_SET) <= 0)
	perror("error in lseek");
    if ( read((int)kmem, &seminfo, (unsigned)size) != size )
	perror("error reading from kmem");
#endif
    printf("This system supports %d semaphore sets of %d semaphores or %d total individual semaphores\n",
	   seminfo.semmni, seminfo.semmsl, seminfo.semmns);
    printf("This system currently lists %d queues in /etc/printcap\n", NUMQUEUES);
    printf("The program will currently support up to %d queues\n", MAX_QUEUES);
    if ( MAX_QUEUES > seminfo.semmsl )
	printf("ERROR - The program supports more queues than semaphores allowed\n");
    if ( NUMQUEUES > MAX_QUEUES )
	printf("ERROR - The system defines more queues than built into the program\n");

}    
